/*
 * Decompiled with CFR 0.152.
 */
package ConfigurationPackage;

import ClientPackage.LiveDBClient;
import CommunicationPackage.MediaController;
import CommunicationPackage.MediaServer_Communication;
import ConfigurationPackage.MediaServer_Help;
import GraphicsDeviceToolsPackage.GraphicsDeviceTools;
import GraphicsDeviceToolsPackage.JPanel_GraphicsDevices;
import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LanguageTools.LiveLanguagePackage.LiveLanguageString;
import MainPackage.MediaServer;
import MediaObjectPackage.MediaSource;
import OS.OSChecker;
import RunPackage.Run_LiveShowMediaServer;
import ServerKernelPackage.LiveDBServerKernel;
import ServerKernelPackage.LiveDBServerKernelListener;
import SocketManagementPackage.LiveDBStream;
import SocketMessagePackage.LiveDBConnectionDescription;
import SocketMessagePackage.LiveDBMessageStreamInfo;
import SoundPackage.SoundMixerTablePanel;
import SoundPackage.SoundMixers;
import SwingTextPackage.DocumentFilter_Integer;
import SwingToolTipPackage.PopUpToolTip;
import SynchronizationPackage.EventQueueHandler;
import UserJVMOptionsPackage.UserJVMOptionsChecker;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Externalizable;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;

public class MediaServer_Configuration
extends JFrame
implements LiveDBServerKernelListener,
Externalizable,
GraphicsDeviceTools.GraphicsDeviceListener {
    public static final int SOFTWAREVERSION = 2;
    @LiveLanguageString
    public static String TOOLTIPTEXT_SURFACE = "Press mouse button or return to show configuration";
    @LiveLanguageString
    public static String MOVE_MEDIAFILES = "Move Mediafiles";
    @LiveLanguageString
    public static String MOVE_MEDIAIMAGEFILES = "Imagefiles";
    @LiveLanguageString
    public static String MOVE_MEDIAVIDEOFILES = "Videofiles";
    @LiveLanguageString
    public static String MOVE_MEDIATEXTFILES = "Textfiles";
    @LiveLanguageString
    public static String LOAD_MEDIAFILES = "Load Mediafiles";
    private MediaServer m_MediaServer;
    private MediaServer_Communication m_MediaServer_Communication;
    private String m_ServerName;
    private StringBuffer m_ServerIPAddresses;
    private File m_NewMediaDirectory;
    private boolean m_Configurated;
    private boolean m_AllGraphicDevicesFound;
    private boolean m_ServerStartButtonPressed;
    private static LineBorder s_LineBorderStartServer = new LineBorder(Color.GREEN, 1);
    private static LineBorder s_LineBorderStopServer = new LineBorder(Color.RED, 1);
    private boolean m_OnClosing;
    private ArrayList<GraphicsDeviceTools.GraphicsDeviceDescription> m_MissingGraphicsDeviceDescriptions;
    private ArrayList<GraphicsDeviceTools.GraphicsDeviceDescription> m_SelectedDeviceDescriptions;
    private final Object m_SyncDefaultDescriptions = new Object();
    public static MediaServer_Configuration s_SelfReference;
    public static ArrayList<Boolean> s_StartAdditionalInstances;
    public static Process s_ProcessMediaServer2;
    Runnable m_Runnable_ShowMediaSurface;
    Runnable m_Runnable_ShowConfiguration;
    private JButton jButton_Cancel;
    private JButton jButton_Close;
    private JButton jButton_DefaultMediaFolder;
    private JButton jButton_Help;
    private JButton jButton_Save;
    private JButton jButton_StartRemoteServer;
    private JButton jButton_StopRemoteServer;
    private JButton jButton_Sweep;
    private JCheckBox jCheckbox_AdditionalInstance;
    private JLabel jLabel_AdditionalInstanceRemark;
    private JLabel jLabel_AdditonalInstance;
    private JLabel jLabel_ConnectionStatus;
    private JLabel jLabel_DefaultFolder;
    private JLabel jLabel_DefaultMediaFolder;
    private JLabel jLabel_Displays_Header;
    private JLabel jLabel_RemoteServerIP;
    private JLabel jLabel_RemoteServerIP_Header;
    private JLabel jLabel_RemoteServerPort_Header;
    private JLabel jLabel_ServerName;
    private JLabel jLabel_ServerPortRange;
    private JLabel jLabel_Soundcards_Header;
    private JPanel jPanel_AdditionalInstances;
    private JPanel jPanel_DefaultMediaFolder_Header;
    private JPanel jPanel_GraphicsDevice;
    private JPanel_GraphicsDevices jPanel_GraphicsDevices1;
    private JPanel jPanel_Network;
    private JPanel jPanel_SaveCancel;
    private JPanel jPanel_ServerName;
    private JPanel jPanel_SoundMixers;
    private JScrollPane jScrollPane_RemoteServerIP;
    private JTextField jTextField_ServerPort;
    private SoundMixerTablePanel soundMixerTablePanel1;

    public MediaServer_Configuration(MediaServer p_MediaServer, MediaServer_Communication p_MediaServer_Communication) {
        this.initMembers();
        this.m_MediaServer = p_MediaServer;
        this.m_MediaServer_Communication = p_MediaServer_Communication;
        this.initComponents();
        this.initComponentsFurther();
        LiveLanguage.addLanguageListener((Object)this, null);
        LiveDBServerKernel.addLiveDBServerKernelListener((LiveDBServerKernelListener)this);
        this.refreshIPAddresses();
        this.refreshGUI_Config();
        SoundMixers.startProgram();
    }

    private void initMembers() {
        this.m_ServerIPAddresses = new StringBuffer();
        s_SelfReference = this;
        this.m_OnClosing = false;
        this.m_Configurated = false;
        this.m_AllGraphicDevicesFound = false;
        this.m_ServerStartButtonPressed = false;
        this.m_MissingGraphicsDeviceDescriptions = new ArrayList();
        this.m_SelectedDeviceDescriptions = new ArrayList();
        this.m_NewMediaDirectory = MediaServer.DEFAULTMEDIADIRECTORY;
        this.m_ServerName = LiveDBServerKernel.getServerHostName();
    }

    private void initComponentsFurther() {
        this.getContentPane().setBackground(Color.BLACK);
        this.setIconImage(MediaServer.s_ImageIcon.getImage());
        DocumentFilter_Integer o_DocumentFilter_Integer = new DocumentFilter_Integer(this.jTextField_ServerPort);
        o_DocumentFilter_Integer.setAllowNegativeNumbers(false);
        o_DocumentFilter_Integer.setMinValue(1024);
        o_DocumentFilter_Integer.setMaxValue(65535);
        GraphicsDeviceTools.addGraphicDeviceListener((GraphicsDeviceTools.GraphicsDeviceListener)this);
        this.jPanel_GraphicsDevices1.startAutomaticDeviceRefresh();
        this.jScrollPane_RemoteServerIP.getViewport().setBackground(Color.BLACK);
        this.jTextField_ServerPort.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_StartRemoteServer.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_StopRemoteServer.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jLabel_ConnectionStatus.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jPanel_GraphicsDevices1.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jLabel_DefaultMediaFolder.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_DefaultMediaFolder.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_Save.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_Cancel.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_Sweep.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_Close.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_Help.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jCheckbox_AdditionalInstance.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        String stringServerAddition = null;
        if (this.m_MediaServer != null) {
            MediaServer_Configuration mediaServer_Configuration = this;
            stringServerAddition = mediaServer_Configuration.m_MediaServer.getMediaServer_Addition();
        }
        if (stringServerAddition != null) {
            this.jLabel_ServerName.setText(this.m_ServerName + " " + stringServerAddition);
            this.jPanel_AdditionalInstances.setVisible(false);
        } else {
            this.jLabel_ServerName.setText(this.m_ServerName);
            this.jPanel_AdditionalInstances.setVisible(true);
        }
    }

    public void close() {
        if (this.m_OnClosing) {
            return;
        }
        this.m_OnClosing = true;
        SoundMixers.closeProgram();
        this.jPanel_GraphicsDevices1.stopAutomaticDeviceRefresh();
        GraphicsDeviceTools.removeGraphicDeviceListener((GraphicsDeviceTools.GraphicsDeviceListener)this);
        MediaServer.close(false, false);
        LiveLanguage.removeLanguageListener((Object)this);
    }

    private void initComponents() {
        this.jPanel_ServerName = new JPanel();
        this.jLabel_ServerName = new JLabel();
        this.jButton_Help = new JButton();
        this.jPanel_Network = new JPanel();
        this.jLabel_RemoteServerIP_Header = new JLabel();
        this.jLabel_RemoteServerPort_Header = new JLabel();
        this.jTextField_ServerPort = new JTextField();
        this.jButton_StartRemoteServer = new JButton();
        this.jButton_StopRemoteServer = new JButton();
        this.jLabel_ConnectionStatus = new JLabel();
        this.jLabel_ServerPortRange = new JLabel();
        this.jScrollPane_RemoteServerIP = new JScrollPane();
        this.jLabel_RemoteServerIP = new JLabel();
        this.jPanel_GraphicsDevice = new JPanel();
        this.jPanel_GraphicsDevices1 = new JPanel_GraphicsDevices();
        this.jLabel_Displays_Header = new JLabel();
        this.jPanel_DefaultMediaFolder_Header = new JPanel();
        this.jLabel_DefaultFolder = new JLabel();
        this.jLabel_DefaultMediaFolder = new JLabel();
        this.jButton_DefaultMediaFolder = new JButton();
        this.jPanel_SaveCancel = new JPanel();
        this.jButton_Save = new JButton();
        this.jButton_Cancel = new JButton();
        this.jButton_Sweep = new JButton();
        this.jButton_Close = new JButton();
        this.jPanel_AdditionalInstances = new JPanel();
        this.jCheckbox_AdditionalInstance = new JCheckBox();
        this.jLabel_AdditonalInstance = new JLabel();
        this.jLabel_AdditionalInstanceRemark = new JLabel();
        this.jPanel_SoundMixers = new JPanel();
        this.soundMixerTablePanel1 = new SoundMixerTablePanel();
        this.jLabel_Soundcards_Header = new JLabel();
        this.setDefaultCloseOperation(0);
        this.setTitle("MediaServer Configuration");
        this.setMinimumSize(new Dimension(340, 590));
        this.setPreferredSize(new Dimension(500, 700));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent evt) {
                MediaServer_Configuration.this.formComponentMoved(evt);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent evt) {
                MediaServer_Configuration.this.formWindowActivated(evt);
            }

            @Override
            public void windowClosing(WindowEvent evt) {
                MediaServer_Configuration.this.formWindowClosing(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.jPanel_ServerName.setBorder(BorderFactory.createLineBorder(Color.darkGray));
        this.jPanel_ServerName.setLayout(new GridBagLayout());
        this.jLabel_ServerName.setFont(new Font("Tahoma", 1, 14));
        this.jLabel_ServerName.setHorizontalAlignment(0);
        this.jLabel_ServerName.setText("jLabel2");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel_ServerName.add((Component)this.jLabel_ServerName, gridBagConstraints);
        this.jButton_Help.setIcon(new ImageIcon(this.getClass().getResource("/IconPackage/Help.png")));
        this.jButton_Help.setText("Help");
        this.jButton_Help.setContentAreaFilled(false);
        this.jButton_Help.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MediaServer_Configuration.this.jButton_HelpActionPerformed(evt);
            }
        });
        this.jPanel_ServerName.add((Component)this.jButton_Help, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jPanel_ServerName, gridBagConstraints);
        this.jPanel_Network.setMinimumSize(new Dimension(334, 120));
        this.jPanel_Network.setPreferredSize(new Dimension(334, 120));
        this.jPanel_Network.setLayout(new GridBagLayout());
        this.jLabel_RemoteServerIP_Header.setHorizontalAlignment(4);
        this.jLabel_RemoteServerIP_Header.setText("ServerIPs: ");
        this.jLabel_RemoteServerIP_Header.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Network.add((Component)this.jLabel_RemoteServerIP_Header, gridBagConstraints);
        this.jLabel_RemoteServerPort_Header.setHorizontalAlignment(4);
        this.jLabel_RemoteServerPort_Header.setText("ServerPort (1024\u201365535):");
        this.jLabel_RemoteServerPort_Header.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Network.add((Component)this.jLabel_RemoteServerPort_Header, gridBagConstraints);
        this.jTextField_ServerPort.setFont(new Font("Tahoma", 1, 14));
        this.jTextField_ServerPort.setHorizontalAlignment(0);
        this.jTextField_ServerPort.setText("jTextField1");
        this.jTextField_ServerPort.setToolTipText("insert server port number (between 1024 and 65535) ");
        this.jTextField_ServerPort.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MediaServer_Configuration.this.jTextField_ServerPortFocusLost(evt);
            }
        });
        this.jTextField_ServerPort.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                MediaServer_Configuration.this.jTextField_ServerPortKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Network.add((Component)this.jTextField_ServerPort, gridBagConstraints);
        this.jButton_StartRemoteServer.setText("Start Media Server");
        this.jButton_StartRemoteServer.setToolTipText("");
        this.jButton_StartRemoteServer.setBorder(new LineBorder(new Color(0, 255, 0), 1, true));
        this.jButton_StartRemoteServer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MediaServer_Configuration.this.jButton_StartRemoteServerActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Network.add((Component)this.jButton_StartRemoteServer, gridBagConstraints);
        this.jButton_StopRemoteServer.setText("Stop Media Server");
        this.jButton_StopRemoteServer.setToolTipText("");
        this.jButton_StopRemoteServer.setBorder(new LineBorder(new Color(255, 0, 0), 1, true));
        this.jButton_StopRemoteServer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MediaServer_Configuration.this.jButton_StopRemoteServerActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Network.add((Component)this.jButton_StopRemoteServer, gridBagConstraints);
        this.jLabel_ConnectionStatus.setBackground(new Color(0, 0, 0));
        this.jLabel_ConnectionStatus.setForeground(new Color(255, 255, 255));
        this.jLabel_ConnectionStatus.setToolTipText("Connection Status (green = server is connected)");
        this.jLabel_ConnectionStatus.setMaximumSize(new Dimension(16, 16));
        this.jLabel_ConnectionStatus.setMinimumSize(new Dimension(16, 16));
        this.jLabel_ConnectionStatus.setOpaque(true);
        this.jLabel_ConnectionStatus.setPreferredSize(new Dimension(16, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        this.jPanel_Network.add((Component)this.jLabel_ConnectionStatus, gridBagConstraints);
        this.jLabel_ServerPortRange.setHorizontalAlignment(2);
        this.jLabel_ServerPortRange.setText("(1024 - 65535)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        this.jPanel_Network.add((Component)this.jLabel_ServerPortRange, gridBagConstraints);
        this.jLabel_RemoteServerIP.setHorizontalAlignment(0);
        this.jLabel_RemoteServerIP.setText("-");
        this.jLabel_RemoteServerIP.setToolTipText("");
        this.jScrollPane_RemoteServerIP.setViewportView(this.jLabel_RemoteServerIP);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel_Network.add((Component)this.jScrollPane_RemoteServerIP, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jPanel_Network, gridBagConstraints);
        this.jPanel_GraphicsDevice.setLayout(new GridBagLayout());
        this.jPanel_GraphicsDevices1.setBackground(new Color(0, 0, 0));
        this.jPanel_GraphicsDevices1.setMinimumSize(new Dimension(100, 100));
        this.jPanel_GraphicsDevices1.setPreferredSize(new Dimension(100, 100));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_GraphicsDevice.add((Component)this.jPanel_GraphicsDevices1, gridBagConstraints);
        this.jLabel_Displays_Header.setText("Select Output Displays");
        this.jLabel_Displays_Header.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_GraphicsDevice.add((Component)this.jLabel_Displays_Header, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jPanel_GraphicsDevice, gridBagConstraints);
        this.jPanel_DefaultMediaFolder_Header.setLayout(new GridBagLayout());
        this.jLabel_DefaultFolder.setText("Media Directory:");
        this.jLabel_DefaultFolder.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_DefaultMediaFolder_Header.add((Component)this.jLabel_DefaultFolder, gridBagConstraints);
        this.jLabel_DefaultMediaFolder.setFont(new Font("Tahoma", 1, 14));
        this.jLabel_DefaultMediaFolder.setHorizontalAlignment(0);
        this.jLabel_DefaultMediaFolder.setText("jLabel2");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_DefaultMediaFolder_Header.add((Component)this.jLabel_DefaultMediaFolder, gridBagConstraints);
        this.jButton_DefaultMediaFolder.setIcon(new ImageIcon(this.getClass().getResource("/IconPackage/Menu_ProjectExport.png")));
        this.jButton_DefaultMediaFolder.setToolTipText("Change Media Directory");
        this.jButton_DefaultMediaFolder.setContentAreaFilled(false);
        this.jButton_DefaultMediaFolder.setMaximumSize(new Dimension(34, 34));
        this.jButton_DefaultMediaFolder.setMinimumSize(new Dimension(34, 34));
        this.jButton_DefaultMediaFolder.setPreferredSize(new Dimension(34, 34));
        this.jButton_DefaultMediaFolder.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconPackage/ButtonPressed.png")));
        this.jButton_DefaultMediaFolder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MediaServer_Configuration.this.jButton_DefaultMediaFolderActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_DefaultMediaFolder_Header.add((Component)this.jButton_DefaultMediaFolder, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jPanel_DefaultMediaFolder_Header, gridBagConstraints);
        this.jPanel_SaveCancel.setBorder(BorderFactory.createLineBorder(Color.darkGray));
        this.jPanel_SaveCancel.setLayout(new GridBagLayout());
        this.jButton_Save.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Edit_OK.png")));
        this.jButton_Save.setToolTipText("");
        this.jButton_Save.setContentAreaFilled(false);
        this.jButton_Save.setMargin(new Insets(0, 0, 2, 0));
        this.jButton_Save.setMaximumSize(new Dimension(34, 34));
        this.jButton_Save.setMinimumSize(new Dimension(34, 34));
        this.jButton_Save.setPreferredSize(new Dimension(34, 34));
        this.jButton_Save.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconPackage/ButtonPressed.png")));
        this.jButton_Save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MediaServer_Configuration.this.jButton_SaveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_SaveCancel.add((Component)this.jButton_Save, gridBagConstraints);
        this.jButton_Cancel.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Edit_Cancel.png")));
        this.jButton_Cancel.setToolTipText("");
        this.jButton_Cancel.setContentAreaFilled(false);
        this.jButton_Cancel.setMargin(new Insets(0, 0, 2, 0));
        this.jButton_Cancel.setMaximumSize(new Dimension(34, 34));
        this.jButton_Cancel.setMinimumSize(new Dimension(34, 34));
        this.jButton_Cancel.setPreferredSize(new Dimension(34, 34));
        this.jButton_Cancel.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconPackage/ButtonPressed.png")));
        this.jButton_Cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MediaServer_Configuration.this.jButton_CancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_SaveCancel.add((Component)this.jButton_Cancel, gridBagConstraints);
        this.jButton_Sweep.setIcon(new ImageIcon(this.getClass().getResource("/IconPackage/Edit_Sweep.png")));
        this.jButton_Sweep.setToolTipText("Deletes all media files that are currently not in use.");
        this.jButton_Sweep.setContentAreaFilled(false);
        this.jButton_Sweep.setMargin(new Insets(0, 0, 2, 0));
        this.jButton_Sweep.setMaximumSize(new Dimension(34, 34));
        this.jButton_Sweep.setMinimumSize(new Dimension(34, 34));
        this.jButton_Sweep.setPreferredSize(new Dimension(34, 34));
        this.jButton_Sweep.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_Sweep.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MediaServer_Configuration.this.jButton_SweepActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_SaveCancel.add((Component)this.jButton_Sweep, gridBagConstraints);
        this.jButton_Close.setIcon(new ImageIcon(this.getClass().getResource("/IconPackage/Menu_Close.png")));
        this.jButton_Close.setToolTipText("Deletes all media files that are currently not in use.");
        this.jButton_Close.setContentAreaFilled(false);
        this.jButton_Close.setMargin(new Insets(0, 0, 2, 0));
        this.jButton_Close.setMaximumSize(new Dimension(34, 34));
        this.jButton_Close.setMinimumSize(new Dimension(34, 34));
        this.jButton_Close.setPreferredSize(new Dimension(34, 34));
        this.jButton_Close.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconPackage/ButtonPressed.png")));
        this.jButton_Close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MediaServer_Configuration.this.jButton_CloseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_SaveCancel.add((Component)this.jButton_Close, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jPanel_SaveCancel, gridBagConstraints);
        this.jPanel_AdditionalInstances.setLayout(new GridBagLayout());
        this.jCheckbox_AdditionalInstance.setText("Media Server 2");
        this.jCheckbox_AdditionalInstance.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MediaServer_Configuration.this.jCheckbox_AdditionalInstanceActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_AdditionalInstances.add((Component)this.jCheckbox_AdditionalInstance, gridBagConstraints);
        this.jLabel_AdditonalInstance.setText("Second Instance liveSHOW_Media");
        this.jLabel_AdditonalInstance.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_AdditionalInstances.add((Component)this.jLabel_AdditonalInstance, gridBagConstraints);
        this.jLabel_AdditionalInstanceRemark.setHorizontalAlignment(0);
        this.jLabel_AdditionalInstanceRemark.setText("<html><center>Start a second instance of  liveSHOW_Media automatically.</center></html>");
        this.jLabel_AdditionalInstanceRemark.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_AdditionalInstances.add((Component)this.jLabel_AdditionalInstanceRemark, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jPanel_AdditionalInstances, gridBagConstraints);
        this.jPanel_SoundMixers.setMinimumSize(new Dimension(170, 120));
        this.jPanel_SoundMixers.setPreferredSize(new Dimension(170, 120));
        this.jPanel_SoundMixers.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel_SoundMixers.add((Component)this.soundMixerTablePanel1, gridBagConstraints);
        this.jLabel_Soundcards_Header.setText("Select Soundcard Output");
        this.jLabel_Soundcards_Header.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_SoundMixers.add((Component)this.jLabel_Soundcards_Header, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jPanel_SoundMixers, gridBagConstraints);
        this.pack();
    }

    @Override
    public void setVisible(boolean p_Visible) {
        super.setVisible(p_Visible);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(2);
        Object object = this.m_SyncDefaultDescriptions;
        synchronized (object) {
            int intDescriptionCount = this.m_SelectedDeviceDescriptions.size();
            out.writeInt(intDescriptionCount);
            for (int intDescription = 0; intDescription < intDescriptionCount; ++intDescription) {
                GraphicsDeviceTools.GraphicsDeviceDescription o_GraphicsDeviceDescription = this.m_SelectedDeviceDescriptions.get(intDescription);
                o_GraphicsDeviceDescription.writeExternal(out);
            }
            out.writeUTF(this.m_NewMediaDirectory.getAbsolutePath());
            out.writeBoolean(this.m_Configurated);
            out.writeInt(s_StartAdditionalInstances.size());
            for (int intStart = 0; intStart < s_StartAdditionalInstances.size(); ++intStart) {
                out.writeBoolean(s_StartAdditionalInstances.get(intStart));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int intSoftwareVersion = in.readInt();
        boolean boolAllGraphicDevicesFound = true;
        Object object = this.m_SyncDefaultDescriptions;
        synchronized (object) {
            this.m_SelectedDeviceDescriptions.clear();
            int intDescriptionCount = in.readInt();
            for (int intDescription = 0; intDescription < intDescriptionCount; ++intDescription) {
                GraphicsDeviceTools.GraphicsDeviceDescription o_GraphicsDeviceDescription = new GraphicsDeviceTools.GraphicsDeviceDescription();
                o_GraphicsDeviceDescription.readExternal(in);
                if (GraphicsDeviceTools.getGraphicsDevice((String)o_GraphicsDeviceDescription.getIDString()) != null) {
                    this.m_SelectedDeviceDescriptions.add(o_GraphicsDeviceDescription);
                    continue;
                }
                this.m_MissingGraphicsDeviceDescriptions.add(o_GraphicsDeviceDescription);
                boolAllGraphicDevicesFound = false;
            }
        }
        this.m_AllGraphicDevicesFound = boolAllGraphicDevicesFound;
        String stringMediaDirectory = in.readUTF();
        File o_MediaDirectory = new File(stringMediaDirectory);
        MediaServer.setDefaultMediaDirectory(o_MediaDirectory);
        this.m_NewMediaDirectory = MediaServer.DEFAULTMEDIADIRECTORY;
        this.m_Configurated = in.readBoolean();
        if (intSoftwareVersion >= 2) {
            int intStartAdditionalInstances = in.readInt();
            for (int intStart = 0; intStart < intStartAdditionalInstances; ++intStart) {
                boolean boolStartAdditionalInstance = in.readBoolean();
                if (intStart < s_StartAdditionalInstances.size()) {
                    s_StartAdditionalInstances.set(intStart, boolStartAdditionalInstance);
                } else {
                    s_StartAdditionalInstances.add(intStart, boolStartAdditionalInstance);
                }
                if (intStart != 0) continue;
                this.jCheckbox_AdditionalInstance.setSelected(s_StartAdditionalInstances.get(intStart));
            }
        }
        this.refreshGUI_Config();
    }

    public void startAdditionalInstances() {
        for (int intStart = 0; intStart < s_StartAdditionalInstances.size(); ++intStart) {
            String stringWorkingDirectory;
            String stringCommand;
            Process o_Process;
            if (!s_StartAdditionalInstances.get(intStart).booleanValue() || (o_Process = s_ProcessMediaServer2) != null && o_Process.isAlive()) continue;
            String stringAddition = String.valueOf(intStart + 2);
            if (UserJVMOptionsChecker.checkIsStartedFromInstalledApp()) {
                stringCommand = UserJVMOptionsChecker.createRestartStringExec((String)stringAddition);
                stringWorkingDirectory = UserJVMOptionsChecker.getWorkingDirectory();
            } else {
                stringCommand = Run_LiveShowMediaServer.getStartCommand(stringAddition);
                stringWorkingDirectory = Run_LiveShowMediaServer.getWorkingDirectory();
            }
            MediaServer_Configuration.startProcess(stringCommand, stringWorkingDirectory, stringAddition);
        }
    }

    public static void startProcess(String p_StringCommand, String p_WorkingDirectory, String p_Addition) {
        if (p_StringCommand == null) {
            return;
        }
        Process o_Process = null;
        try {
            String[] stringCommandArray = p_StringCommand.split(" ");
            ProcessBuilder o_ProcessBuilder = new ProcessBuilder(stringCommandArray);
            o_ProcessBuilder.directory(new File(p_WorkingDirectory));
            StringBuilder stringBuilderProcessOutputFile = new StringBuilder();
            stringBuilderProcessOutputFile.append(OSChecker.getPathUserHomeConfigDirectory());
            stringBuilderProcessOutputFile.append(File.separator);
            stringBuilderProcessOutputFile.append("ProcessOutput");
            if (p_Addition != null) {
                stringBuilderProcessOutputFile.append(p_Addition);
            }
            stringBuilderProcessOutputFile.append(".txt");
            File o_ProcessOutputFile = new File(stringBuilderProcessOutputFile.toString());
            if (o_ProcessOutputFile.exists()) {
                o_ProcessOutputFile.delete();
            }
            o_ProcessBuilder.redirectOutput(o_ProcessOutputFile);
            o_ProcessBuilder.redirectErrorStream(true);
            o_ProcessBuilder.start();
        }
        catch (Exception e) {
            o_Process = null;
            System.out.println("MediaServer cannot start second instance:");
            System.out.println(e.getMessage());
        }
        MediaServer_Configuration.setAdditionalInstance(o_Process);
    }

    public static boolean setAdditionalInstance(Process p_Process) {
        s_ProcessMediaServer2 = p_Process;
        if (s_ProcessMediaServer2 == null) {
            return false;
        }
        if (!s_ProcessMediaServer2.isAlive()) {
            s_ProcessMediaServer2 = null;
            return false;
        }
        Thread o_Thread = new Thread(new Runnable(){

            @Override
            public void run() {
                Process o_Process = s_ProcessMediaServer2;
                if (o_Process == null || !o_Process.isAlive()) {
                    s_ProcessMediaServer2 = null;
                    return;
                }
                try {
                    o_Process.waitFor();
                    s_ProcessMediaServer2 = null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        o_Thread.start();
        return true;
    }

    private void jButton_StartRemoteServerActionPerformed(ActionEvent evt) {
        this.m_ServerStartButtonPressed = true;
        try {
            int intServerPort = Integer.valueOf(this.jTextField_ServerPort.getText());
            if (intServerPort != this.m_MediaServer_Communication.getServerPort()) {
                this.m_Configurated = false;
            }
        }
        catch (Exception e) {
            int intServerPort = this.m_MediaServer_Communication.getServerPort();
        }
        this.m_MediaServer_Communication.setServerPort(Integer.valueOf(this.jTextField_ServerPort.getText()));
        MediaServer.getJFrame_MediaSurface().setGraphicsDevices(this.m_SelectedDeviceDescriptions);
        this.m_MediaServer_Communication.connectServer();
        this.jTextField_ServerPort.setText(String.valueOf(this.m_MediaServer_Communication.getServerPort()));
        this.refreshIPAddresses();
        this.refreshGUI_Network();
    }

    private void refreshIPAddresses() {
        this.m_ServerIPAddresses.delete(0, this.m_ServerIPAddresses.length());
        this.m_ServerIPAddresses.append("<html>");
        this.m_ServerIPAddresses.append(this.getServerIPAddresses());
        this.m_ServerIPAddresses.append("</html>");
    }

    public String getServerIPAddresses() {
        Enumeration<NetworkInterface> o_NetworkInterfaces;
        StringBuffer o_StringBuffer_Result = new StringBuffer();
        StringBuffer o_StringBuffer_NetworkInterface = new StringBuffer();
        try {
            o_NetworkInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (Exception e) {
            o_NetworkInterfaces = null;
        }
        if (o_NetworkInterfaces != null) {
            while (o_NetworkInterfaces.hasMoreElements()) {
                NetworkInterface o_NetworkInterface = o_NetworkInterfaces.nextElement();
                try {
                    if (!o_NetworkInterface.isUp() || o_NetworkInterface.isVirtual()) continue;
                    if (o_NetworkInterface.isPointToPoint()) {
                    }
                }
                catch (Exception e) {}
                continue;
                o_StringBuffer_NetworkInterface.delete(0, o_StringBuffer_NetworkInterface.length());
                List<InterfaceAddress> o_InterfaceAddresses = o_NetworkInterface.getInterfaceAddresses();
                for (int intInterfaceAddress = 0; intInterfaceAddress < o_InterfaceAddresses.size(); ++intInterfaceAddress) {
                    InetAddress o_InetAddress;
                    InterfaceAddress o_InterfaceAddress = o_InterfaceAddresses.get(intInterfaceAddress);
                    if (o_InterfaceAddress == null || (o_InetAddress = o_InterfaceAddress.getAddress()) == null) continue;
                    if (o_InetAddress instanceof Inet4Address) {
                        o_StringBuffer_NetworkInterface.append("<b>");
                    }
                    o_StringBuffer_NetworkInterface.append(o_InetAddress.getHostAddress());
                    if (o_InetAddress instanceof Inet4Address) {
                        o_StringBuffer_NetworkInterface.append("</b>");
                    }
                    if (intInterfaceAddress >= o_InterfaceAddresses.size() - 1) continue;
                    o_StringBuffer_NetworkInterface.append(", ");
                }
                o_StringBuffer_Result.append(o_StringBuffer_NetworkInterface.toString());
                try {
                    if (o_NetworkInterface.isLoopback()) {
                        o_StringBuffer_Result.append(" (local)");
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!o_NetworkInterfaces.hasMoreElements()) continue;
                o_StringBuffer_Result.append("<br>");
            }
        }
        return o_StringBuffer_Result.toString();
    }

    private void jButton_StopRemoteServerActionPerformed(ActionEvent evt) {
        LiveDBServerKernel.closeServer((int)1);
    }

    private void formWindowClosing(WindowEvent evt) {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButton_SaveActionPerformed(ActionEvent evt) {
        this.m_Configurated = true;
        Object object = this.m_SyncDefaultDescriptions;
        synchronized (object) {
            this.m_MissingGraphicsDeviceDescriptions.clear();
            this.m_AllGraphicDevicesFound = true;
        }
        if (s_StartAdditionalInstances.size() <= 0) {
            s_StartAdditionalInstances.add(false);
        }
        if (this.jCheckbox_AdditionalInstance.isSelected()) {
            s_StartAdditionalInstances.set(0, true);
        } else {
            s_StartAdditionalInstances.set(0, false);
        }
        this.save();
        this.checkOK();
        if (s_StartAdditionalInstances.get(0).booleanValue()) {
            this.startAdditionalInstances();
        }
    }

    private void jButton_CancelActionPerformed(ActionEvent evt) {
        this.m_Configurated = true;
        this.cancel();
        this.checkOK();
    }

    private void jButton_DefaultMediaFolderActionPerformed(ActionEvent evt) {
        LookAndFeel o_LookAndFeel_Actual = UIManager.getLookAndFeel();
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        JFileChooser o_JFileChooser = new JFileChooser(MediaServer.DEFAULTMEDIADIRECTORY);
        o_JFileChooser.setFileSelectionMode(1);
        o_JFileChooser.showOpenDialog(this);
        try {
            UIManager.setLookAndFeel(o_LookAndFeel_Actual);
        }
        catch (Exception exception) {
            // empty catch block
        }
        File o_SelectedDirectory = o_JFileChooser.getSelectedFile();
        if (!MediaServer.checkDefaultMediaDirectory(o_SelectedDirectory)) {
            return;
        }
        this.m_NewMediaDirectory = o_SelectedDirectory;
        this.jLabel_DefaultMediaFolder.setText(this.m_NewMediaDirectory.getAbsolutePath());
    }

    private void jTextField_ServerPortFocusLost(FocusEvent evt) {
        this.checkServerPort();
    }

    private void jTextField_ServerPortKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.checkServerPort();
        }
    }

    private void jButton_HelpActionPerformed(ActionEvent evt) {
        MediaServer_Help o_MediaServer_Help = MediaServer.getMediaServer_Help();
        if (o_MediaServer_Help == null) {
            return;
        }
        o_MediaServer_Help.setActualFocus(this);
        o_MediaServer_Help.setVisible(true);
        o_MediaServer_Help.toFront();
    }

    public static void showHelp() {
        MediaServer_Help o_MediaServer_Help = MediaServer.getMediaServer_Help();
        if (o_MediaServer_Help == null) {
            return;
        }
        o_MediaServer_Help.setActualFocus(s_SelfReference);
        o_MediaServer_Help.setVisible(true);
        o_MediaServer_Help.toFront();
    }

    private void formWindowActivated(WindowEvent evt) {
    }

    private void formComponentMoved(ComponentEvent evt) {
        GraphicsDeviceTools.checkComponentBounds((Component)this, null, null, (Rectangle)this.getBounds(), (int)100);
    }

    private void jButton_SweepActionPerformed(ActionEvent evt) {
        MediaSource.sweepAll();
    }

    private void jCheckbox_AdditionalInstanceActionPerformed(ActionEvent evt) {
    }

    private void jButton_CloseActionPerformed(ActionEvent evt) {
        this.close();
    }

    public boolean checkServerPort() {
        boolean boolPortOK;
        try {
            int intServerPort = Integer.valueOf(this.jTextField_ServerPort.getText());
            if (intServerPort < 1024) {
                intServerPort = 1024;
                this.jTextField_ServerPort.setText(String.valueOf(intServerPort));
                boolPortOK = false;
            } else if (intServerPort > 65535) {
                intServerPort = 65535;
                this.jTextField_ServerPort.setText(String.valueOf(intServerPort));
                boolPortOK = false;
            } else {
                boolPortOK = true;
            }
        }
        catch (Exception e) {
            int intServerPort = this.m_MediaServer_Communication.getServerPort();
            boolPortOK = false;
        }
        if (!boolPortOK) {
            this.jLabel_ServerPortRange.setForeground(Color.RED);
        } else {
            this.jLabel_ServerPortRange.setForeground(Color.BLACK);
        }
        return boolPortOK;
    }

    public boolean getAllGrahicDevicesFound() {
        return this.m_AllGraphicDevicesFound;
    }

    public void setConfigurated(boolean p_Configurated) {
        this.m_Configurated = p_Configurated;
    }

    public boolean getConfigurated() {
        return this.m_Configurated;
    }

    public boolean checkOK() {
        if (!this.m_Configurated) {
            this.showConfiguration();
            return false;
        }
        if (!this.m_AllGraphicDevicesFound) {
            this.showConfiguration();
            return false;
        }
        if (this.m_ServerStartButtonPressed) {
            this.showConfiguration();
            return false;
        }
        if (!this.m_MediaServer_Communication.getIsConnected()) {
            // empty if block
        }
        this.showMediaSurface();
        return true;
    }

    public void showMediaSurface() {
        if (this.m_Runnable_ShowMediaSurface == null) {
            this.m_Runnable_ShowMediaSurface = new Runnable(){

                @Override
                public void run() {
                    MediaServer.getJFrame_MediaSurface().setVisible(true);
                    MediaServer.getJFrame_MediaSurface().toFront();
                    MediaServer.getJFrame_MediaSurface().setGraphicsDevices(MediaServer_Configuration.this.m_SelectedDeviceDescriptions);
                }
            };
        }
        EventQueueHandler.invokeLater((Runnable)this.m_Runnable_ShowMediaSurface);
    }

    public void showConfiguration() {
        if (this.m_Runnable_ShowConfiguration == null) {
            this.m_Runnable_ShowConfiguration = new Runnable(){

                @Override
                public void run() {
                    MediaServer.getJFrame_MediaSurface().releaseFullScreen();
                    s_SelfReference.setVisible(true);
                    s_SelfReference.setExtendedState(0);
                    s_SelfReference.toFront();
                }
            };
        }
        EventQueueHandler.invokeLater((Runnable)this.m_Runnable_ShowConfiguration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        MediaController o_MediaController;
        this.m_ServerStartButtonPressed = false;
        Object object = this.m_SyncDefaultDescriptions;
        synchronized (object) {
            this.m_SelectedDeviceDescriptions = this.getSelectedGraphicsDeviceDescriptions();
        }
        MediaServer.setDefaultMediaDirectory(this.m_NewMediaDirectory);
        this.m_NewMediaDirectory = MediaServer.DEFAULTMEDIADIRECTORY;
        this.m_MediaServer.save();
        this.refreshGUI_Config();
        if (this.m_MediaServer_Communication != null && (o_MediaController = this.m_MediaServer_Communication.getMediaController()) != null) {
            o_MediaController.changedMediaServerInfo();
        }
    }

    public void cancel() {
        this.m_ServerStartButtonPressed = false;
        this.m_NewMediaDirectory = MediaServer.DEFAULTMEDIADIRECTORY;
        MediaServer.cancel();
        this.refreshGUI_Config();
    }

    public String getServerName() {
        return this.m_ServerName;
    }

    public String getServerAddition() {
        if (this.m_MediaServer == null) {
            return null;
        }
        MediaServer_Configuration mediaServer_Configuration = this;
        return mediaServer_Configuration.m_MediaServer.getMediaServer_Addition();
    }

    public JPanel_GraphicsDevices getJPanel_GraphicsDevices() {
        return this.jPanel_GraphicsDevices1;
    }

    public ArrayList<GraphicsDeviceTools.GraphicsDeviceDescription> getSelectedGraphicsDeviceDescriptions() {
        return this.jPanel_GraphicsDevices1.getSelectedGraphicsDeviceDescriptions(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<GraphicsDeviceTools.GraphicsDeviceDescription> getDefaultGraphicsDeviceDescriptions() {
        ArrayList<GraphicsDeviceTools.GraphicsDeviceDescription> o_GraphicsDeviceDescriptions;
        Object object = this.m_SyncDefaultDescriptions;
        synchronized (object) {
            o_GraphicsDeviceDescriptions = new ArrayList<GraphicsDeviceTools.GraphicsDeviceDescription>(this.m_SelectedDeviceDescriptions.size());
            o_GraphicsDeviceDescriptions.addAll(this.m_SelectedDeviceDescriptions);
        }
        return o_GraphicsDeviceDescriptions;
    }

    public void refreshGUI_Config() {
        Point o_Location = this.getLocation();
        Rectangle o_VitualScreenSize = GraphicsDeviceTools.getVirtualBounds_AllGraphicsDevices();
        if (o_Location.x < 0) {
            o_Location.x = 0;
        }
        if (o_Location.y < 0) {
            o_Location.y = 0;
        }
        if (o_Location.x > o_VitualScreenSize.width - 100) {
            o_Location.x = o_VitualScreenSize.width - 100;
        }
        if (o_Location.y > o_VitualScreenSize.height - 100) {
            o_Location.y = o_VitualScreenSize.height - 100;
        }
        this.setLocation(o_Location);
        String stringServerAddition = null;
        if (this.m_MediaServer != null) {
            MediaServer_Configuration mediaServer_Configuration = this;
            stringServerAddition = mediaServer_Configuration.m_MediaServer.getMediaServer_Addition();
        }
        if (stringServerAddition != null) {
            this.jLabel_ServerName.setText(this.m_ServerName + " " + stringServerAddition);
        } else {
            this.jLabel_ServerName.setText(this.m_ServerName);
        }
        this.jLabel_DefaultMediaFolder.setText(this.m_NewMediaDirectory.getAbsolutePath());
        this.jPanel_GraphicsDevices1.setSelectedGraphicsDeviceDescriptions(this.getDefaultGraphicsDeviceDescriptions());
        if (s_StartAdditionalInstances.size() > 0 && s_StartAdditionalInstances.get(0).booleanValue()) {
            this.jCheckbox_AdditionalInstance.setSelected(true);
        } else {
            this.jCheckbox_AdditionalInstance.setSelected(false);
        }
    }

    public void refreshGUI_Network() {
        this.jButton_StartRemoteServer.setEnabled(false);
        this.jButton_StartRemoteServer.setBorder(null);
        this.jButton_StopRemoteServer.setEnabled(false);
        this.jButton_StopRemoteServer.setBorder(null);
        this.jTextField_ServerPort.setEnabled(false);
        this.jLabel_RemoteServerIP.setText(this.m_ServerIPAddresses.toString());
        this.jTextField_ServerPort.setText(String.valueOf(this.m_MediaServer_Communication.getServerPort()));
        switch (LiveDBServerKernel.getConnectionStatus()) {
            case 0: {
                this.jButton_StartRemoteServer.setEnabled(true);
                this.jButton_StartRemoteServer.setBorder(s_LineBorderStartServer);
                this.jTextField_ServerPort.setEnabled(true);
                this.jLabel_ConnectionStatus.setBackground(Color.ORANGE);
                break;
            }
            case 2: {
                this.jButton_StopRemoteServer.setEnabled(true);
                this.jButton_StopRemoteServer.setBorder(s_LineBorderStopServer);
                this.jLabel_ConnectionStatus.setBackground(Color.GREEN);
                break;
            }
            case 6: {
                this.jButton_StartRemoteServer.setEnabled(true);
                this.jButton_StartRemoteServer.setBorder(s_LineBorderStartServer);
                this.jTextField_ServerPort.setEnabled(true);
                this.jLabel_ConnectionStatus.setBackground(Color.RED);
                break;
            }
            case 8: {
                this.jButton_StartRemoteServer.setEnabled(true);
                this.jButton_StartRemoteServer.setBorder(s_LineBorderStartServer);
                this.jTextField_ServerPort.setEnabled(true);
                this.jLabel_ConnectionStatus.setBackground(Color.YELLOW);
                break;
            }
            case 3: {
                this.jButton_StopRemoteServer.setEnabled(true);
                this.jButton_StopRemoteServer.setBorder(s_LineBorderStopServer);
                this.jLabel_ConnectionStatus.setBackground(Color.GREEN);
                break;
            }
            case 9: {
                this.jLabel_ConnectionStatus.setBackground(Color.GRAY);
                break;
            }
            case 1: {
                this.jLabel_ConnectionStatus.setBackground(Color.GRAY);
            }
        }
    }

    public void eventServerConnectionStatus(int p_ConnectionStatus) {
        this.refreshGUI_Network();
    }

    public void eventServerError(Exception p_Exception, String p_Remark) {
    }

    public void eventServerLiveDBClientAdded(LiveDBClient p_LiveDBClient) {
    }

    public void eventServerLiveDBClientRemoved(LiveDBClient p_LiveDBClient) {
    }

    public void eventServerVerbosedClientIP(String p_VerbosedIP, boolean p_New) {
    }

    public boolean verifyClientSoftwareVersion(LiveDBConnectionDescription p_ClientConnectionDescription, String p_ClientSoftwareVersion) {
        return true;
    }

    public boolean verifyClientLicense(LiveDBConnectionDescription p_ClientConnectionDescription, String p_ClientLicense) {
        return true;
    }

    public boolean verifyCloseServer(LiveDBClient p_LiveDBClient, int p_ShutdownFlag) {
        return true;
    }

    public boolean verifyShutDownLiveDBClient(LiveDBClient p_LiveDBClientActor, LiveDBClient p_LiveDBClientToClose) {
        return true;
    }

    public void eventClientConnectionStatus(LiveDBClient p_LiveDBClient, int p_ConnectionStatus) {
    }

    public void eventClientMessageReadUnknown(LiveDBClient p_LiveDBClient) {
    }

    public void eventClientMessageWritten(LiveDBClient p_LiveDBClient, Object p_MessageObject) {
    }

    public void eventClientError(LiveDBClient p_LiveDBClient, Exception p_Exception, String p_Remark) {
    }

    public void parseMessage(LiveDBClient p_LiveDBClient, Serializable p_MessageObject) {
    }

    public void parseMessageIncomingStreamStart(LiveDBClient p_LiveDBClient, LiveDBStream p_IncomingStream, LiveDBMessageStreamInfo p_StreamInfo) {
    }

    public void parseMessageIncomingStreamEnd(LiveDBClient p_LiveDBClient, LiveDBStream p_IncomingStream, boolean p_EndOfStream, boolean p_Canceled, boolean p_Error, String p_CancelRemark) {
    }

    public void parseMessageIncomingStreamPackage(LiveDBClient p_LiveDBClient, LiveDBStream p_IncomingStream, long p_ReceivedBytesCount) {
    }

    public void parseMessageOutgoingStreamStart(LiveDBClient p_LiveDBClient, LiveDBStream p_OutgoingingStream, LiveDBMessageStreamInfo p_StreamInfo) {
    }

    public void parseMessageOutgoingStreamEnd(LiveDBClient p_LiveDBClient, LiveDBStream p_OutgoingStream, boolean p_EndOfStream, boolean p_Canceled, boolean p_Error, String p_CancelRemark) {
    }

    public void parseMessageOutgoingStreamConfirmed(LiveDBClient p_LiveDBClient, LiveDBStream p_OutgoingStream, long p_ReceivedBytesCount) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eventGraphicsDeviceAdded(GraphicsDeviceTools.GraphicsDeviceDescription p_GraphicsDeviceDescription) {
        if (p_GraphicsDeviceDescription == null) {
            return;
        }
        GraphicsDeviceTools.GraphicsDeviceDescription o_GraphicsDeviceDescription = null;
        Object object = this.m_SyncDefaultDescriptions;
        synchronized (object) {
            for (int intDescription = 0; intDescription < this.m_MissingGraphicsDeviceDescriptions.size(); ++intDescription) {
                o_GraphicsDeviceDescription = this.m_MissingGraphicsDeviceDescriptions.get(intDescription);
                if (o_GraphicsDeviceDescription == null) continue;
                System.out.println("        GraphicDevice added: " + o_GraphicsDeviceDescription.getIDString());
                if (p_GraphicsDeviceDescription.getIDString().equals(o_GraphicsDeviceDescription.getIDString())) {
                    this.m_MissingGraphicsDeviceDescriptions.remove(intDescription);
                    break;
                }
                o_GraphicsDeviceDescription = null;
            }
            if (o_GraphicsDeviceDescription != null) {
                this.m_SelectedDeviceDescriptions.add(o_GraphicsDeviceDescription);
            }
        }
        if (o_GraphicsDeviceDescription != null) {
            if (this.m_MissingGraphicsDeviceDescriptions.size() == 0) {
                this.m_AllGraphicDevicesFound = true;
            }
            MediaServer.getJFrame_MediaSurface().setGraphicsDevices(this.m_SelectedDeviceDescriptions);
        }
        this.checkOK();
        this.refreshGUI_Config();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eventGraphicsDeviceRemoved(GraphicsDeviceTools.GraphicsDeviceDescription p_GraphicsDeviceDescription) {
        if (p_GraphicsDeviceDescription == null) {
            return;
        }
        boolean boolRemovedDeviceInUse = false;
        Object object = this.m_SyncDefaultDescriptions;
        synchronized (object) {
            for (int intDevice = 0; intDevice < this.m_SelectedDeviceDescriptions.size(); ++intDevice) {
                GraphicsDeviceTools.GraphicsDeviceDescription o_GraphicsDeviceDescription = this.m_SelectedDeviceDescriptions.get(intDevice);
                if (o_GraphicsDeviceDescription == null) continue;
                System.out.println("        GraphicDevice removed: " + o_GraphicsDeviceDescription.getIDString());
                if (!p_GraphicsDeviceDescription.getIDString().equals(o_GraphicsDeviceDescription.getIDString())) continue;
                this.m_SelectedDeviceDescriptions.remove(intDevice);
                boolRemovedDeviceInUse = true;
                break;
            }
        }
        this.refreshGUI_Config();
        if (boolRemovedDeviceInUse) {
            this.m_AllGraphicDevicesFound = false;
            this.m_MissingGraphicsDeviceDescriptions.add(p_GraphicsDeviceDescription);
            MediaServer.getJFrame_MediaSurface().setGraphicsDevices(this.m_SelectedDeviceDescriptions);
        }
        this.checkOK();
    }

    public void eventGraphicsDeviceChanged(GraphicsDeviceTools.GraphicsDeviceDescription p_GraphicsDeviceDescription) {
        if (p_GraphicsDeviceDescription != null) {
            System.out.println("        GraphicDevice changed: " + p_GraphicsDeviceDescription.getIDString());
        }
        this.refreshGUI_Config();
    }

    static {
        s_StartAdditionalInstances = new ArrayList();
        s_ProcessMediaServer2 = null;
    }
}

