/*
 * Decompiled with CFR 0.152.
 */
package CommunicationPackage;

import ClientPackage.LiveDBClient;
import CommunicationPackage.MediaController;
import ConfigurationPackage.MediaServer_Configuration;
import GUID.LiveGUID;
import MainPackage.MediaServer;
import MediaObjectPackage.MediaConstants;
import ServerAutoDetectPackage.ServerAutoDetect_Server;
import ServerKernelPackage.LiveDBServerKernel;
import ServerKernelPackage.LiveDBServerKernelListener;
import SocketManagementPackage.LiveDBStream;
import SocketMessagePackage.LiveDBConnectionDescription;
import SocketMessagePackage.LiveDBMessageStreamInfo;
import SynchronizationPackage.EventQueueHandler;
import java.awt.Color;
import java.awt.Component;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;

public class MediaServer_Communication
implements LiveDBServerKernelListener,
Externalizable {
    public static final int SOFTWAREVERSION = 1;
    public static int NETWORK_RETRY_WAIT_MILLISECONDS = 20000;
    public static MediaServer_Communication s_SelfReference = null;
    public static String PROGRAM_NAME = "LiveShow_MediaServer";
    public static int DEFAULT_WATCHDOGCONNECTION_TIME = 10000;
    MediaServer m_MediaServer;
    private String m_ServerID;
    private String m_ServerTaskID;
    private String m_ServerTaskName;
    private String m_ServerIP;
    private int m_ServerPort;
    private String m_ServerName;
    private boolean m_ServerConnected;
    private boolean m_ServerWasConnected;
    private String m_ServerAddition;
    private Thread m_ThreadFetchNetworkInterface;
    private boolean m_ThreadFetchNetworkInterfaceStop;
    public Runnable m_RunnableFetchNetworkInterface;
    public ArrayList<LiveDBClient> m_LostLiveDBClients;
    private MediaController m_MediaController;
    private final Object m_SyncMedia_Client = new Object();
    private final Object m_Sync_FetchNetwork = new Object();

    public MediaServer_Communication(MediaServer p_MediaServer, String p_ServerAddition) {
        this.initMembers();
        s_SelfReference = this;
        this.m_MediaServer = p_MediaServer;
        this.m_ServerAddition = p_ServerAddition;
        this.m_MediaController = new MediaController(s_SelfReference);
        LiveDBServerKernel.addLiveDBServerKernelListener((LiveDBServerKernelListener)this);
        LiveDBServerKernel.setLogEventOutput(null);
        LiveDBServerKernel.setWatchdogConnection_Time((long)DEFAULT_WATCHDOGCONNECTION_TIME);
        LiveDBServerKernel.setWatchdogConnectionLost_Time((long)DEFAULT_WATCHDOGCONNECTION_TIME);
    }

    private void initMembers() {
        this.m_ServerTaskID = MediaConstants.MEDIASERVERTASKID;
        this.m_ServerTaskName = MediaConstants.MEDIASERVERTASKNAME;
        this.m_ServerName = "MediaServer";
        this.m_LostLiveDBClients = new ArrayList();
        this.m_ServerID = LiveGUID.getUID();
        this.m_ServerConnected = false;
        this.m_ServerWasConnected = false;
        this.m_ServerIP = "";
        this.m_ServerPort = MediaConstants.DEFAULT_SERVERPORT;
    }

    public void close() {
        ServerAutoDetect_Server.stopServerAutoDetect((String)this.m_ServerID);
        this.m_MediaController.close();
        LiveDBServerKernel.destruct((boolean)true, (int)1, (long)2000L);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(1);
        out.writeUTF(this.m_ServerID);
        out.writeUTF(this.m_ServerIP);
        out.writeInt(this.m_ServerPort);
        out.writeBoolean(this.m_ServerConnected);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int intSoftwareVersion = in.readInt();
        this.m_ServerID = in.readUTF();
        this.m_ServerIP = in.readUTF();
        this.m_ServerPort = in.readInt();
        if (this.m_ServerPort < 1024 || this.m_ServerPort > 65535) {
            this.m_ServerPort = MediaConstants.DEFAULT_SERVERPORT;
        }
        this.m_ServerWasConnected = in.readBoolean();
        this.m_ServerConnected = false;
    }

    public MediaController getMediaController() {
        return this.m_MediaController;
    }

    public void setServerIP(String p_ServerIP) {
        if (p_ServerIP == null) {
            return;
        }
        this.m_ServerIP = p_ServerIP;
    }

    public String getServerIP() {
        return this.m_ServerIP;
    }

    public boolean setServerPort(int p_ServerPort) {
        if (p_ServerPort < 1024 || p_ServerPort > 65535) {
            return false;
        }
        this.m_ServerPort = p_ServerPort;
        return true;
    }

    public int getServerPort() {
        return this.m_ServerPort;
    }

    public boolean connectServer() {
        int intServerPort;
        String stringServerPort;
        try {
            stringServerPort = String.valueOf(this.m_ServerPort);
        }
        catch (Exception e) {
            return false;
        }
        if (stringServerPort == null || stringServerPort.length() <= 0) {
            return false;
        }
        try {
            intServerPort = Integer.valueOf(stringServerPort);
        }
        catch (Exception e) {
            return false;
        }
        if (intServerPort < 1024) {
            intServerPort = 1024;
        }
        if (intServerPort > 65535) {
            intServerPort = 65535;
        }
        this.m_ServerPort = intServerPort;
        this.m_ServerIP = "";
        LiveDBServerKernel.connectServer((String)this.m_ServerIP, (int)this.m_ServerPort, (String)this.m_ServerID, (String)this.m_ServerTaskID, (String)this.m_ServerName, (String)("Server " + this.m_ServerIP + " at Port " + String.valueOf(this.m_ServerPort)), (String)String.valueOf(1));
        return true;
    }

    public boolean getIsConnected() {
        return this.m_ServerConnected;
    }

    public boolean getWasConnected() {
        return this.m_ServerWasConnected;
    }

    public String getServerAddition() {
        return this.m_ServerAddition;
    }

    public void eventServerConnectionStatus(int p_ConnectionStatus) {
        MediaServer_Configuration o_MediaServer_Configuration = MediaServer.getMediaServer_Configuration();
        switch (LiveDBServerKernel.getConnectionStatus()) {
            case 0: {
                this.m_ServerConnected = false;
                break;
            }
            case 2: {
                this.m_ServerConnected = true;
                if (o_MediaServer_Configuration == null) break;
                o_MediaServer_Configuration.checkOK();
                break;
            }
            case 6: {
                this.m_ServerConnected = false;
                if (o_MediaServer_Configuration == null) break;
                o_MediaServer_Configuration.checkOK();
                break;
            }
            case 8: {
                this.m_ServerConnected = false;
                if (o_MediaServer_Configuration == null) break;
                o_MediaServer_Configuration.checkOK();
                break;
            }
            case 3: {
                this.m_ServerConnected = false;
                break;
            }
            case 9: {
                this.m_ServerConnected = false;
                break;
            }
            case 1: {
                this.m_ServerConnected = false;
            }
        }
        if (this.m_ServerConnected) {
            ServerAutoDetect_Server.startServerAutoDetect((String)this.m_ServerID, (String)this.m_ServerTaskID, (String)this.m_ServerTaskName, (int)15109, (int)this.m_ServerPort, (String)this.m_ServerAddition, (String)"");
        } else {
            ServerAutoDetect_Server.stopServerAutoDetect((String)this.m_ServerID);
        }
        EventQueueHandler.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                MediaServer.refresh();
            }
        });
    }

    public void eventServerError(Exception p_Exception, String p_Remark) {
    }

    public void eventServerLiveDBClientAdded(LiveDBClient p_LiveDBClient) {
        boolean boolShowInfo = false;
        MediaServer.showInformation(boolShowInfo);
    }

    public void eventServerLiveDBClientRemoved(LiveDBClient p_LiveDBClient) {
        boolean boolShowInfo = this.m_LostLiveDBClients.size() <= 0;
        this.m_LostLiveDBClients.remove(p_LiveDBClient);
        MediaServer.showInformation(boolShowInfo);
    }

    public void eventServerVerbosedClientIP(String p_VerbosedIP, boolean p_New) {
    }

    public boolean verifyClientSoftwareVersion(LiveDBConnectionDescription p_ClientConnectionDescription, String p_ClientSoftwareVersion) {
        return true;
    }

    public boolean verifyClientLicense(LiveDBConnectionDescription p_ClientConnectionDescription, String p_ClientLicense) {
        return true;
    }

    public boolean verifyCloseServer(LiveDBClient p_LiveDBClient, int p_ShutdownFlag) {
        return true;
    }

    public boolean verifyShutDownLiveDBClient(LiveDBClient p_LiveDBClientActor, LiveDBClient p_LiveDBClientToClose) {
        return true;
    }

    public void eventClientConnectionStatus(LiveDBClient p_LiveDBClient, int p_ConnectionStatus) {
        if (p_ConnectionStatus == 8) {
            if (!this.m_LostLiveDBClients.contains(p_LiveDBClient)) {
                this.m_LostLiveDBClients.add(p_LiveDBClient);
            }
        } else if (p_ConnectionStatus == 3) {
            this.m_LostLiveDBClients.remove(p_LiveDBClient);
        } else if (p_ConnectionStatus == 2) {
            this.m_LostLiveDBClients.remove(p_LiveDBClient);
        }
    }

    public void eventClientMessageReadUnknown(LiveDBClient p_LiveDBClient) {
    }

    public void eventClientMessageWritten(LiveDBClient p_LiveDBClient, Object p_MessageObject) {
    }

    public void eventClientError(LiveDBClient p_LiveDBClient, Exception p_Exception, String p_Remark) {
    }

    public void parseMessage(LiveDBClient p_LiveDBClient, Serializable p_MessageObject) {
    }

    public void parseMessageIncomingStreamStart(LiveDBClient p_LiveDBClient, LiveDBStream p_IncomingStream, LiveDBMessageStreamInfo p_StreamInfo) {
    }

    public void parseMessageIncomingStreamEnd(LiveDBClient p_LiveDBClient, LiveDBStream p_IncomingStream, boolean p_EndOfStream, boolean p_Canceled, boolean p_Error, String p_CancelRemark) {
    }

    public void parseMessageIncomingStreamPackage(LiveDBClient p_LiveDBClient, LiveDBStream p_IncomingStream, long p_ReceivedBytesCount) {
    }

    public void parseMessageOutgoingStreamStart(LiveDBClient p_LiveDBClient, LiveDBStream p_OutgoingingStream, LiveDBMessageStreamInfo p_StreamInfo) {
    }

    public void parseMessageOutgoingStreamEnd(LiveDBClient p_LiveDBClient, LiveDBStream p_OutgoingStream, boolean p_EndOfStream, boolean p_Canceled, boolean p_Error, String p_CancelRemark) {
    }

    public void parseMessageOutgoingStreamConfirmed(LiveDBClient p_LiveDBClient, LiveDBStream p_OutgoingStream, long p_ReceivedBytesCount) {
    }

    public static class NetworkDescriptionCellRenderer
    implements ListCellRenderer {
        protected DefaultListCellRenderer defaultRenderer = new DefaultListCellRenderer();

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel renderer = (JLabel)this.defaultRenderer.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            Color o_Background = null;
            Color o_Foreground = null;
            o_Background = list.getBackground();
            o_Foreground = list.getForeground();
            if (isSelected) {
                if (list.hasFocus()) {
                    o_Background = UIManager.getColor("List.selectionBackground");
                    o_Foreground = UIManager.getColor("List.selectionForeground");
                } else {
                    o_Background = UIManager.getColor("List.selectionInactiveBackground");
                    o_Foreground = UIManager.getColor("List.selectionInactiveForeground");
                }
            }
            renderer.setForeground(o_Foreground);
            renderer.setBackground(o_Background);
            if (value == null) {
                renderer.setText("");
            } else if (value instanceof NetworkDescription) {
                NetworkDescription o_NetworkDescription = (NetworkDescription)value;
                renderer.setText(o_NetworkDescription.getDisplayName());
            }
            return renderer;
        }
    }

    public static class NetworkDescription {
        private NetworkInterface m_NetworkInterface;
        private InetAddress m_InetAddress;
        private String m_NetworkInterfaceDisplayName;
        private String m_InetAddressName;
        private String m_DisplayName;

        public NetworkDescription() {
            this.initMembers();
        }

        private void initMembers() {
            this.m_DisplayName = "";
        }

        public void close() {
            this.setNetwork(null, null);
        }

        public void setNetwork(NetworkInterface p_NetworkInterface, InetAddress p_InetAddress) {
            this.m_NetworkInterface = p_NetworkInterface;
            this.m_InetAddress = p_InetAddress;
            this.m_NetworkInterfaceDisplayName = this.m_NetworkInterface != null ? this.m_NetworkInterface.getDisplayName() : "";
            this.m_InetAddressName = this.m_InetAddress != null ? this.m_InetAddress.getHostAddress() : "";
            this.m_DisplayName = this.m_NetworkInterfaceDisplayName + ": " + this.m_InetAddressName;
        }

        public NetworkInterface getNetworkInterface() {
            return this.m_NetworkInterface;
        }

        public InetAddress getInetAddress() {
            return this.m_InetAddress;
        }

        public String getInetAddressName() {
            return this.m_InetAddressName;
        }

        public String getDisplayName() {
            return this.m_DisplayName;
        }
    }
}

