/*
 * Decompiled with CFR 0.152.
 */
package CommunicationPackage;

import ClientPackage.LiveDBClient;
import CommunicationPackage.MediaServer_Client;
import CommunicationPackage.MediaServer_Communication;
import LanguageTools.LiveLanguagePackage.LiveLanguageString;
import MainPackage.MediaServer;
import MediaMessagePackage.MediaMessage_AddLiveShowMediaObject;
import MediaMessagePackage.MediaMessage_MainSoundVolume;
import MediaMessagePackage.MediaMessage_MainTransparency;
import MediaMessagePackage.MediaMessage_MediaObjectChanged;
import MediaMessagePackage.MediaMessage_PlayStatus;
import MediaMessagePackage.MediaMessage_RefreshMediaSource_Error;
import MediaMessagePackage.MediaMessage_RemoveLiveShowMediaObject;
import MediaMessagePackage.MediaMessage_Shutdown;
import MediaMessagePackage.MediaMessage_Sweep;
import MediaObjectPackage.MediaSource;
import ServerKernelPackage.LiveDBServerKernel;
import ServerKernelPackage.LiveDBServerKernelListener;
import SocketManagementPackage.LiveDBStream;
import SocketMessagePackage.LiveDBConnectionDescription;
import SocketMessagePackage.LiveDBMessageStreamInfo;
import java.io.Serializable;
import java.util.ArrayList;

public class MediaController
implements LiveDBServerKernelListener {
    @LiveLanguageString
    public static String REMARK_FILE_WRONGCHECKSUM = "Wrong checksum";
    @LiveLanguageString
    public static String REMARK_FILE_STREAMCANCELLED = "Stream cancelled";
    private MediaServer_Communication m_MediaServer_Communication;
    private ArrayList<MediaServer_Client> m_MediaServer_Clients;
    private final Object m_SyncClients = new Object();

    public MediaController(MediaServer_Communication p_MediaServer_Communication) {
        this.initMembers();
        this.m_MediaServer_Communication = p_MediaServer_Communication;
        LiveDBServerKernel.addLiveDBServerKernelListener((LiveDBServerKernelListener)this);
    }

    private void initMembers() {
        this.m_MediaServer_Clients = new ArrayList();
    }

    public void close() {
        LiveDBServerKernel.removeLiveDBServerKernelListener((LiveDBServerKernelListener)this);
        this.closeAllClients();
    }

    public int getLiveDBClientCount() {
        return this.m_MediaServer_Clients.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaServer_Client getMediaServer_Client(LiveDBClient p_LiveDBClient) {
        Object object = this.m_SyncClients;
        synchronized (object) {
            for (int intClient = 0; intClient < this.m_MediaServer_Clients.size(); ++intClient) {
                MediaServer_Client o_MediaServer_Client = this.m_MediaServer_Clients.get(intClient);
                if (o_MediaServer_Client == null || o_MediaServer_Client.getLiveDBClient() != p_LiveDBClient) continue;
                return o_MediaServer_Client;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMediaServer_Client(MediaServer_Client p_MediaServer_Client) {
        if (p_MediaServer_Client == null) {
            return;
        }
        Object object = this.m_SyncClients;
        synchronized (object) {
            if (this.m_MediaServer_Clients.contains(p_MediaServer_Client)) {
                return;
            }
            this.m_MediaServer_Clients.add(p_MediaServer_Client);
        }
        p_MediaServer_Client.sendMediaServerInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMediaServer_Client(MediaServer_Client p_MediaServer_Client) {
        if (p_MediaServer_Client == null) {
            return;
        }
        Object object = this.m_SyncClients;
        synchronized (object) {
            if (!this.m_MediaServer_Clients.contains(p_MediaServer_Client)) {
                return;
            }
            this.m_MediaServer_Clients.remove(p_MediaServer_Client);
        }
        p_MediaServer_Client.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAllClients() {
        ArrayList<MediaServer_Client> o_MediaServer_Clients;
        Object object = this.m_SyncClients;
        synchronized (object) {
            o_MediaServer_Clients = new ArrayList<MediaServer_Client>(this.m_MediaServer_Clients.size());
            o_MediaServer_Clients.addAll(this.m_MediaServer_Clients);
        }
        for (int intClient = o_MediaServer_Clients.size() - 1; intClient >= 0; --intClient) {
            LiveDBClient o_LiveDBClient;
            MediaServer_Client o_MediaServer_Client = (MediaServer_Client)o_MediaServer_Clients.get(intClient);
            if (o_MediaServer_Client == null || (o_LiveDBClient = o_MediaServer_Client.getLiveDBClient()) == null) continue;
            o_LiveDBClient.close();
            o_MediaServer_Client.close();
        }
    }

    public void parseMessage(LiveDBClient p_LiveDBClient, Serializable p_MessageObject) {
        if (p_MessageObject == null) {
            return;
        }
        MediaServer_Client o_MediaServer_Client = this.getMediaServer_Client(p_LiveDBClient);
        if (o_MediaServer_Client == null) {
            return;
        }
        try {
            if (p_MessageObject instanceof MediaMessage_AddLiveShowMediaObject) {
                MediaMessage_AddLiveShowMediaObject o_MediaMessage_AddLiveShowMediaObject = (MediaMessage_AddLiveShowMediaObject)p_MessageObject;
                o_MediaServer_Client.parseAddLiveShowMediaObject(p_LiveDBClient, o_MediaMessage_AddLiveShowMediaObject);
            } else if (p_MessageObject instanceof MediaMessage_RemoveLiveShowMediaObject) {
                MediaMessage_RemoveLiveShowMediaObject o_MediaMessage_RemoveLiveShowMediaObject = (MediaMessage_RemoveLiveShowMediaObject)p_MessageObject;
                o_MediaServer_Client.parseRemoveLiveShowMediaObject(p_LiveDBClient, o_MediaMessage_RemoveLiveShowMediaObject);
            } else if (p_MessageObject instanceof MediaMessage_RefreshMediaSource_Error) {
                MediaMessage_RefreshMediaSource_Error o_MediaMessage_RefreshMediaSource = (MediaMessage_RefreshMediaSource_Error)p_MessageObject;
                o_MediaServer_Client.parseRefreshMediaSource_Error(p_LiveDBClient, o_MediaMessage_RefreshMediaSource);
            } else if (p_MessageObject instanceof MediaMessage_PlayStatus) {
                MediaMessage_PlayStatus o_MediaMessage_PlayStatus = (MediaMessage_PlayStatus)p_MessageObject;
                o_MediaServer_Client.parseMessagePlayStatus(p_LiveDBClient, o_MediaMessage_PlayStatus);
            } else if (p_MessageObject instanceof MediaMessage_MainTransparency) {
                MediaMessage_MainTransparency o_MediaMessage_MainTransparency = (MediaMessage_MainTransparency)p_MessageObject;
                o_MediaServer_Client.parseMessageMainTransparency(p_LiveDBClient, o_MediaMessage_MainTransparency);
            } else if (p_MessageObject instanceof MediaMessage_MainSoundVolume) {
                MediaMessage_MainSoundVolume o_MediaMessage_MainSoundVolume = (MediaMessage_MainSoundVolume)p_MessageObject;
                o_MediaServer_Client.parseMessageMainSoundVolume(p_LiveDBClient, o_MediaMessage_MainSoundVolume);
            } else if (p_MessageObject instanceof MediaMessage_MediaObjectChanged) {
                MediaMessage_MediaObjectChanged o_MediaMessage_MediaObjectChanged = (MediaMessage_MediaObjectChanged)p_MessageObject;
                o_MediaServer_Client.parseMessageMediaObjectChanged(p_LiveDBClient, o_MediaMessage_MediaObjectChanged);
            } else if (p_MessageObject instanceof MediaMessage_Sweep) {
                MediaSource.sweepAll();
            } else if (p_MessageObject instanceof MediaMessage_Shutdown) {
                MediaMessage_Shutdown o_MediaMessage_Shutdown = (MediaMessage_Shutdown)p_MessageObject;
                if (o_MediaMessage_Shutdown.getRestart()) {
                    MediaServer.close(false, true);
                } else {
                    MediaServer.close(true, false);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void eventServerConnectionStatus(int p_ConnectionStatus) {
    }

    public void eventServerError(Exception p_Exception, String p_Remark) {
    }

    public void eventServerLiveDBClientAdded(LiveDBClient p_LiveDBClient) {
        if (p_LiveDBClient == null) {
            return;
        }
        MediaServer_Client o_MediaServer_Client = this.getMediaServer_Client(p_LiveDBClient);
        if (o_MediaServer_Client == null) {
            o_MediaServer_Client = new MediaServer_Client(p_LiveDBClient);
        }
        this.addMediaServer_Client(o_MediaServer_Client);
    }

    public void eventServerLiveDBClientRemoved(LiveDBClient p_LiveDBClient) {
        if (p_LiveDBClient == null) {
            return;
        }
        MediaServer_Client o_MediaServer_Client = this.getMediaServer_Client(p_LiveDBClient);
        this.removeMediaServer_Client(o_MediaServer_Client);
    }

    public void eventServerVerbosedClientIP(String p_VerbosedIP, boolean p_New) {
    }

    public boolean verifyClientSoftwareVersion(LiveDBConnectionDescription p_ClientConnectionDescription, String p_ClientSoftwareVersion) {
        return true;
    }

    public boolean verifyClientLicense(LiveDBConnectionDescription p_ClientConnectionDescription, String p_ClientLicense) {
        return true;
    }

    public boolean verifyCloseServer(LiveDBClient p_LiveDBClient, int p_ShutdownFlag) {
        return true;
    }

    public boolean verifyShutDownLiveDBClient(LiveDBClient p_LiveDBClientActor, LiveDBClient p_LiveDBClientToClose) {
        return true;
    }

    public void eventClientConnectionStatus(LiveDBClient p_LiveDBClient, int p_ConnectionStatus) {
        if (p_LiveDBClient == null) {
            return;
        }
        MediaServer_Client o_MediaServer_Client = this.getMediaServer_Client(p_LiveDBClient);
        switch (p_ConnectionStatus) {
            case 0: 
            case 8: {
                o_MediaServer_Client.closeMediaObjects();
            }
        }
    }

    public void eventClientMessageReadUnknown(LiveDBClient p_LiveDBClient) {
    }

    public void eventClientMessageWritten(LiveDBClient p_LiveDBClient, Object p_MessageObject) {
    }

    public void eventClientError(LiveDBClient p_LiveDBClient, Exception p_Exception, String p_Remark) {
    }

    public void parseMessageIncomingStreamStart(LiveDBClient p_LiveDBClient, LiveDBStream p_IncomingStream, LiveDBMessageStreamInfo p_StreamInfo) {
        if (p_StreamInfo.getInternalHandled()) {
            return;
        }
        MediaServer_Client o_MediaServer_Client = this.getMediaServer_Client(p_LiveDBClient);
        if (o_MediaServer_Client == null) {
            p_IncomingStream.cancel(REMARK_FILE_STREAMCANCELLED);
            return;
        }
        o_MediaServer_Client.parseMessageIncomingStreamStart(p_LiveDBClient, p_IncomingStream, p_StreamInfo);
    }

    public void parseMessageIncomingStreamEnd(LiveDBClient p_LiveDBClient, LiveDBStream p_IncomingStream, boolean p_EndOfStream, boolean p_Canceled, boolean p_Error, String p_CancelRemark) {
        if (p_IncomingStream.getInternalHandled()) {
            return;
        }
        MediaServer_Client o_MediaServer_Client = this.getMediaServer_Client(p_LiveDBClient);
        if (o_MediaServer_Client == null) {
            return;
        }
        o_MediaServer_Client.parseMessageIncomingStreamEnd(p_LiveDBClient, p_IncomingStream, p_EndOfStream, p_Canceled, p_Error, p_CancelRemark);
    }

    public void parseMessageIncomingStreamPackage(LiveDBClient p_LiveDBClient, LiveDBStream p_IncomingStream, long p_ReceivedBytesCount) {
        if (p_IncomingStream.getInternalHandled()) {
            return;
        }
    }

    public void parseMessageOutgoingStreamStart(LiveDBClient p_LiveDBClient, LiveDBStream p_OutgoingingStream, LiveDBMessageStreamInfo p_StreamInfo) {
    }

    public void parseMessageOutgoingStreamEnd(LiveDBClient p_LiveDBClient, LiveDBStream p_OutgoingStream, boolean p_EndOfStream, boolean p_Canceled, boolean p_Error, String p_CancelRemark) {
    }

    public void parseMessageOutgoingStreamConfirmed(LiveDBClient p_LiveDBClient, LiveDBStream p_OutgoingStream, long p_ReceivedBytesCount) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changedMediaServerInfo() {
        ArrayList<MediaServer_Client> o_MediaServer_Clients;
        Object object = this.m_SyncClients;
        synchronized (object) {
            o_MediaServer_Clients = new ArrayList<MediaServer_Client>(this.m_MediaServer_Clients.size());
            o_MediaServer_Clients.addAll(this.m_MediaServer_Clients);
        }
        for (int intClient = 0; intClient < o_MediaServer_Clients.size(); ++intClient) {
            MediaServer_Client o_MediaServer_Client = (MediaServer_Client)o_MediaServer_Clients.get(intClient);
            if (o_MediaServer_Client == null) continue;
            o_MediaServer_Client.sendMediaServerInfo();
        }
    }
}

