/*
 * Decompiled with CFR 0.152.
 */
package SwingModelPackage;

import SwingModelPackage.SinglePropertyChangeSupport;
import SwingTextPackage.DocumentFilter_Double;
import SwingTextPackage.DocumentFilter_Float;
import SwingTextPackage.DocumentFilter_Integer;
import SwingTextPackage.DocumentFilter_Long;
import SwingTextPackage.DocumentFilter_Time;
import SwingTextPackage.TextComparator;
import SwingToolTipPackage.JCheckBox_RightClickToolTip;
import SwingToolTipPackage.JLabel_RightClickToolTip;
import SwingToolTipPackage.JPanel_RightClickToolTip;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EventListener;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.ListCellRenderer;
import javax.swing.RowFilter;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public abstract class TableAndListModel<T>
extends AbstractTableModel {
    public static final String PROP_ELEMENTADDED = "propElementAdded";
    public static final String PROP_ELEMENTREMOVED = "propElementRemoved";
    public static final String PROP_ELEMENTCHANGED = "propElementChanged";
    public static final String PROP_CLEARED = "propCleared";
    private ArrayList<T> m_Elements;
    private ArrayList<T> m_Elements_Table;
    private boolean m_AllowNullElement;
    private final Object m_SyncObject = new Object();
    private ListModel<T> m_ListModel;
    private SinglePropertyChangeSupport m_PropertyChangeSupport;
    private TableAndListModel<T> m_SelfReference;

    public TableAndListModel(boolean p_AllowNullElement) {
        this.initMembers();
        this.m_SelfReference = this;
        this.m_AllowNullElement = p_AllowNullElement;
    }

    private void initMembers() {
        this.m_Elements = new ArrayList();
        this.m_Elements_Table = new ArrayList();
        this.m_AllowNullElement = false;
        this.m_PropertyChangeSupport = new SinglePropertyChangeSupport(this);
    }

    public void setAllowNull(boolean p_AllowNullElement) {
        this.m_AllowNullElement = p_AllowNullElement;
    }

    public boolean getAllowNull() {
        return this.m_AllowNullElement;
    }

    public void finishJTable(final JTable p_JTable, final TableRowSorter p_TableRowSorter, final RowFilter p_RowFilter) {
        if (p_JTable == null) {
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                p_JTable.setRowSorter(p_TableRowSorter);
                if (p_TableRowSorter == null) {
                    return;
                }
                p_TableRowSorter.allRowsChanged();
                p_TableRowSorter.setRowFilter(p_RowFilter);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        int intOldSize;
        Object object = this.m_SyncObject;
        synchronized (object) {
            intOldSize = this.m_Elements.size();
            this.m_Elements.clear();
        }
        this.m_PropertyChangeSupport.firePropertyChange(PROP_CLEARED, intOldSize, 0);
        if (EventQueue.isDispatchThread()) {
            this.eventClear();
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TableAndListModel.this.eventClear();
                }
            });
        }
        ListModel<T> o_ListModel = this.m_ListModel;
        if (o_ListModel != null) {
            o_ListModel.clear_Internal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void eventClear() {
        int intRowCount;
        Object object = this.m_SyncObject;
        synchronized (object) {
            intRowCount = this.m_Elements_Table.size();
            if (intRowCount <= 0) {
                return;
            }
            this.m_Elements_Table.clear();
        }
        this.fireTableRowsDeleted(0, intRowCount - 1);
    }

    public boolean add(T p_Element) {
        return this.addElement(p_Element);
    }

    public boolean add(int p_Position, T p_Element) {
        return this.addElement(p_Position, p_Element);
    }

    public boolean addElement(T p_Element) {
        return this.addElement(-1, p_Element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addElement(int p_Position, final T p_Element) {
        int intPosition;
        ListModel<T> o_ListModel = this.m_ListModel;
        if (!this.m_AllowNullElement && p_Element == null) {
            if (o_ListModel != null && o_ListModel.getAllowNull()) {
                o_ListModel.addElement_Internal(p_Element);
            }
            return false;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            if (this.m_Elements.contains(p_Element)) {
                return false;
            }
            intPosition = p_Element == null ? 0 : (p_Position < 0 || p_Position > this.m_Elements.size() ? this.m_Elements.size() : p_Position);
            this.m_Elements.add(intPosition, p_Element);
        }
        if (p_Element != null) {
            this.m_PropertyChangeSupport.firePropertyChange(PROP_ELEMENTADDED, null, p_Element);
        } else {
            this.m_PropertyChangeSupport.firePropertyChange(PROP_ELEMENTADDED, "null", p_Element);
        }
        if (EventQueue.isDispatchThread()) {
            this.eventAddElement(intPosition, p_Element);
        } else {
            final int intPositionIndex = intPosition;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TableAndListModel.this.eventAddElement(intPositionIndex, p_Element);
                }
            });
        }
        if (o_ListModel != null) {
            o_ListModel.addElement_Internal(p_Element);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void eventAddElement(int p_Position, T p_Element) {
        int intIndex;
        Object object = this.m_SyncObject;
        synchronized (object) {
            if (this.m_Elements_Table.contains(p_Element)) {
                return;
            }
            if (p_Position < 0 || p_Position > this.m_Elements_Table.size()) {
                this.m_Elements_Table.add(p_Element);
            } else {
                this.m_Elements_Table.add(p_Position, p_Element);
            }
            intIndex = this.m_Elements_Table.indexOf(p_Element);
        }
        this.fireTableRowsInserted(intIndex, intIndex);
    }

    public boolean remove(T p_Element) {
        return this.removeElement(p_Element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T remove(int p_Index) {
        T o_Element;
        if (p_Index < 0) {
            return null;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            if (p_Index >= this.m_Elements.size()) {
                return null;
            }
            o_Element = this.m_Elements.get(p_Index);
        }
        if (this.removeElement(o_Element)) {
            return o_Element;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeElement(final T p_Element) {
        ListModel<T> o_ListModel = this.m_ListModel;
        if (!this.m_AllowNullElement && p_Element == null) {
            if (o_ListModel != null && o_ListModel.getAllowNull()) {
                o_ListModel.removeElement_Internal(p_Element);
            }
            return false;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            if (!this.m_Elements.remove(p_Element)) {
                return false;
            }
        }
        if (p_Element != null) {
            this.m_PropertyChangeSupport.firePropertyChange(PROP_ELEMENTREMOVED, p_Element, null);
        } else {
            this.m_PropertyChangeSupport.firePropertyChange(PROP_ELEMENTREMOVED, null, "null");
        }
        if (EventQueue.isDispatchThread()) {
            this.eventRemoveElement(p_Element);
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TableAndListModel.this.eventRemoveElement(p_Element);
                }
            });
        }
        if (o_ListModel != null) {
            o_ListModel.removeElement_Internal(p_Element);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void eventRemoveElement(T p_Element) {
        int intIndex;
        Object object = this.m_SyncObject;
        synchronized (object) {
            intIndex = this.m_Elements_Table.indexOf(p_Element);
            if (intIndex < 0) {
                return;
            }
            this.m_Elements_Table.remove(intIndex);
        }
        this.fireTableRowsDeleted(intIndex, intIndex);
    }

    public void changedElement(final T p_Element) {
        this.m_PropertyChangeSupport.firePropertyChange(PROP_ELEMENTCHANGED, null, p_Element);
        if (EventQueue.isDispatchThread()) {
            this.eventChangedElement(p_Element);
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TableAndListModel.this.eventChangedElement(p_Element);
                }
            });
        }
        ListModel<T> o_ListModel = this.m_ListModel;
        if (o_ListModel != null) {
            o_ListModel.changedElement_Internal(p_Element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void eventChangedElement(T p_Element) {
        int intIndex;
        if (!this.m_AllowNullElement && p_Element == null) {
            return;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            intIndex = this.m_Elements_Table.indexOf(p_Element);
            if (intIndex < 0) {
                return;
            }
        }
        this.fireTableRowsUpdated(intIndex, intIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            if (p_Index >= this.m_Elements.size()) {
                return null;
            }
            return this.m_Elements.get(p_Index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getElementAt(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            if (p_Index >= this.m_Elements_Table.size()) {
                return null;
            }
            return this.m_Elements_Table.get(p_Index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.m_SyncObject;
        synchronized (object) {
            return this.m_Elements.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int indexOf(T p_Element) {
        if (!this.m_AllowNullElement && p_Element == null) {
            return -1;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            return this.m_Elements.indexOf(p_Element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(T p_Element) {
        if (!this.m_AllowNullElement && p_Element == null) {
            return false;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            return this.m_Elements.contains(p_Element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T[] getElementArray() {
        Object object = this.m_SyncObject;
        synchronized (object) {
            return this.m_Elements.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<T> getElementArrayList() {
        Object object = this.m_SyncObject;
        synchronized (object) {
            return this.m_Elements;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<T> getElementArrayList_Safe() {
        Object object = this.m_SyncObject;
        synchronized (object) {
            ArrayList<T> o_ArrayList = new ArrayList<T>(this.m_Elements.size());
            o_ArrayList.addAll(this.m_Elements);
            return o_ArrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRowCount() {
        Object object = this.m_SyncObject;
        synchronized (object) {
            return this.m_Elements_Table.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRowOf(T p_Element) {
        Object object = this.m_SyncObject;
        synchronized (object) {
            return this.m_Elements_Table.indexOf(p_Element);
        }
    }

    public void clearSelection(final JTable p_JTable) {
        if (p_JTable == null) {
            return;
        }
        if (EventQueue.isDispatchThread()) {
            this.eventClearSelection(p_JTable);
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                TableAndListModel.this.eventClearSelection(p_JTable);
            }
        });
    }

    private void eventClearSelection(JTable p_JTable) {
        if (p_JTable == null) {
            return;
        }
        p_JTable.clearSelection();
    }

    public void setSelectedElement(final JTable p_JTable, final T p_Element) {
        if (p_JTable == null) {
            return;
        }
        if (EventQueue.isDispatchThread()) {
            this.eventSetSelectedElement(p_JTable, p_Element);
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                TableAndListModel.this.eventSetSelectedElement(p_JTable, p_Element);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void eventSetSelectedElement(JTable p_JTable, T p_Element) {
        int intRow;
        if (p_JTable == null) {
            return;
        }
        if (!this.m_AllowNullElement && p_Element == null) {
            return;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            intRow = this.getRowOf(p_Element);
            if (intRow < 0) {
                return;
            }
            if ((intRow = p_JTable.convertRowIndexToView(intRow)) >= p_JTable.getRowCount()) {
                return;
            }
            if (intRow < 0) {
                return;
            }
        }
        p_JTable.setRowSelectionInterval(intRow, intRow);
    }

    public void addSelectedElement(final JTable p_JTable, final T p_Element) {
        if (EventQueue.isDispatchThread()) {
            this.eventAddSelectedElement(p_JTable, p_Element);
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                TableAndListModel.this.eventAddSelectedElement(p_JTable, p_Element);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void eventAddSelectedElement(JTable p_JTable, T p_Element) {
        int intRowSelect;
        if (p_JTable == null) {
            return;
        }
        if (!this.m_AllowNullElement && p_Element == null) {
            return;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            intRowSelect = this.getRowOf(p_Element);
            if (intRowSelect < 0) {
                return;
            }
            if ((intRowSelect = p_JTable.convertRowIndexToView(intRowSelect)) >= p_JTable.getRowCount()) {
                return;
            }
            if (intRowSelect < 0) {
                return;
            }
            int[] intSelectedRows = p_JTable.getSelectedRows();
            if (intSelectedRows.length > 1) {
                for (int intRow = 0; intRow < intSelectedRows.length; ++intRow) {
                    if (intRowSelect != intSelectedRows[intRow]) continue;
                    return;
                }
            }
        }
        p_JTable.addRowSelectionInterval(intRowSelect, intRowSelect);
    }

    public void removeSelectedElement(final JTable p_JTable, final T p_Element) {
        if (EventQueue.isDispatchThread()) {
            this.eventRemoveSelectedElement(p_JTable, p_Element);
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                TableAndListModel.this.eventRemoveSelectedElement(p_JTable, p_Element);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void eventRemoveSelectedElement(JTable p_JTable, T p_Element) {
        int intRowSelected;
        if (p_JTable == null) {
            return;
        }
        if (!this.m_AllowNullElement && p_Element == null) {
            return;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            int intRow;
            intRowSelected = this.getRowOf(p_Element);
            if (intRowSelected < 0) {
                return;
            }
            if ((intRowSelected = p_JTable.convertRowIndexToView(intRowSelected)) >= p_JTable.getRowCount()) {
                return;
            }
            if (intRowSelected < 0) {
                return;
            }
            int[] intSelectedRows = p_JTable.getSelectedRows();
            for (intRow = 0; intRow < intSelectedRows.length && intRowSelected != intSelectedRows[intRow]; ++intRow) {
            }
            if (intRow >= intSelectedRows.length) {
                return;
            }
        }
        p_JTable.removeRowSelectionInterval(intRowSelected, intRowSelected);
    }

    public T getSelectedElement(JTable p_JTable) {
        if (p_JTable == null) {
            return null;
        }
        int intRow = p_JTable.getSelectedRow();
        if (intRow < 0) {
            return null;
        }
        intRow = p_JTable.convertRowIndexToModel(intRow);
        return this.get(intRow);
    }

    public void scrollToSelection(JTable p_JTable) {
        if (p_JTable == null) {
            return;
        }
        int intIndex = -1;
        int intSelectedRow = 0;
        if (!(p_JTable.getParent() instanceof JViewport)) {
            return;
        }
        JViewport o_JViewport = (JViewport)p_JTable.getParent();
        int[] o_SelectedRows = p_JTable.getSelectedRows();
        for (int intSelected = 0; intSelected < o_SelectedRows.length; ++intSelected) {
            try {
                intSelectedRow = o_SelectedRows[intSelected];
            }
            catch (Exception e) {
                continue;
            }
            if (intSelectedRow <= intIndex) continue;
            intIndex = intSelectedRow;
        }
        if (intIndex < 0) {
            return;
        }
        Rectangle o_CellRect = p_JTable.getCellRect(intIndex, 0, true);
        Rectangle o_ViewportRect = o_JViewport.getViewRect();
        if (o_CellRect.y + o_CellRect.height / 2 < o_ViewportRect.y || o_CellRect.y + o_CellRect.height / 2 > o_ViewportRect.y + o_ViewportRect.height) {
            o_CellRect.setLocation(o_CellRect.x - o_ViewportRect.x, o_CellRect.y - o_ViewportRect.y);
            int intCenterY = (o_ViewportRect.height - o_CellRect.height) / 2;
            if (o_CellRect.y < intCenterY) {
                intCenterY = -intCenterY;
            }
            o_CellRect.translate(o_CellRect.x, intCenterY);
            o_JViewport.scrollRectToVisible(o_CellRect);
        }
    }

    @Override
    public abstract int getColumnCount();

    @Override
    public abstract String getColumnName(int var1);

    @Override
    public abstract boolean isCellEditable(int var1, int var2);

    public Class<? extends Object> getColumnClass(int c) {
        Object o_Object = this.getValueAt(0, c);
        if (o_Object == null) {
            return Object.class;
        }
        return o_Object.getClass();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValueAt(int p_Row, int p_Column) {
        T o_Element;
        Object object = this.m_SyncObject;
        synchronized (object) {
            o_Element = p_Row < 0 ? null : (p_Row >= this.m_Elements_Table.size() ? null : (T)this.m_Elements_Table.get(p_Row));
        }
        return this.getValue(o_Element, p_Column);
    }

    public abstract Object getValue(T var1, int var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValueAt(Object p_Value, int p_Row, int p_Column) {
        Object object = this.m_SyncObject;
        synchronized (object) {
            if (p_Row < 0) {
                return;
            }
            if (p_Row >= this.m_Elements_Table.size()) {
                return;
            }
            T o_Element = this.m_Elements_Table.get(p_Row);
            this.setValue(o_Element, p_Value, p_Column);
        }
        this.fireTableCellUpdated(p_Row, p_Column);
    }

    public abstract void setValue(T var1, Object var2, int var3);

    @Override
    public void fireTableDataChanged() {
        if (EventQueue.isDispatchThread()) {
            super.fireTableDataChanged();
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TableAndListModel.this.callFireTableChanged();
                }
            });
        }
    }

    private void callFireTableChanged() {
        super.fireTableDataChanged();
    }

    @Override
    public void fireTableStructureChanged() {
        if (EventQueue.isDispatchThread()) {
            super.fireTableStructureChanged();
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TableAndListModel.this.callFireTableStructureChanged();
                }
            });
        }
    }

    private void callFireTableStructureChanged() {
        super.fireTableStructureChanged();
    }

    public void addPropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
        if (p_PropertyChangeListener == null) {
            return;
        }
        this.m_PropertyChangeSupport.addPropertyChangeListener(p_PropertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
        if (p_PropertyChangeListener == null) {
            return;
        }
        this.m_PropertyChangeSupport.removePropertyChangeListener(p_PropertyChangeListener);
    }

    public static TextComparator.StringComparator_Normal getStringComparator_Normal() {
        return TextComparator.getStringComparator_Normal();
    }

    public static TextComparator.StringComparator_Integer getStringComparator_Integer() {
        return TextComparator.getStringComparator_Integer();
    }

    public static TextComparator.StringComparator_Double getStringComparator_Double() {
        return TextComparator.getStringComparator_Double();
    }

    public static TextComparator.StringComparator_Float getStringComparator_Float() {
        return TextComparator.getStringComparator_Float();
    }

    public static TextComparator.StringComparator_Time getStringComparator_Time() {
        return TextComparator.getStringComparator_Time();
    }

    public ListModel<T> getListModel() {
        if (this.m_ListModel == null) {
            this.m_ListModel = new ListModel(this);
            if (EventQueue.isDispatchThread()) {
                this.eventNewListModel();
            } else {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TableAndListModel.this.eventNewListModel();
                    }
                });
            }
        }
        return this.m_ListModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void eventNewListModel() {
        ListModel<T> o_ListModel = this.m_ListModel;
        if (o_ListModel == null) {
            return;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            for (int intElement = 0; intElement < this.m_Elements_Table.size(); ++intElement) {
                o_ListModel.addElement_Internal(this.m_Elements_Table.get(intElement));
            }
        }
    }

    public static class TableCellEditorRenderer_ComboBox<E>
    extends TableCellEditorRenderer<E> {
        private static final long serialVersionUID = 1L;
        protected ComboBoxModel<E> m_ComboBoxModel;
        protected ListCellRenderer m_ListCellRenderer;
        protected JList_Virtual<E> m_List_Virtual;
        protected int m_HorizontalAlignment;
        protected JLabel_RightClickToolTip m_JLabelError;

        public TableCellEditorRenderer_ComboBox() {
            super(new JComboBox());
            this.initComponents();
        }

        private void initComponents() {
            this.m_HorizontalAlignment = -1;
            this.m_JLabelError = new JLabel_RightClickToolTip();
            this.m_JLabelError.setText("ERROR NO LISTRENDERER");
            this.m_JLabelError.setBackground(Color.RED);
            this.m_JLabelError.setForeground(Color.WHITE);
            this.m_JLabelError.setOpaque(true);
            this.m_JLabelError.setToolTipText("ERROR NO LISTRENDERER");
            this.m_JLabelError.setToolTipText_RightClick("ERROR NO LISTRENDERER");
            this.m_List_Virtual = new JList_Virtual();
            this.m_ListCellRenderer = new ListRenderer();
        }

        public void setComboBoxModel(ComboBoxModel<E> p_ListModelWrapper) {
            if (p_ListModelWrapper == null) {
                return;
            }
            this.m_ComboBoxModel = p_ListModelWrapper;
            ((JComboBox)this.getComponent()).setModel(p_ListModelWrapper);
            this.m_List_Virtual.setModel(this.m_ComboBoxModel);
        }

        public void setListCellRenderer(ListCellRenderer p_ListCellRenderer) {
            if (p_ListCellRenderer == null) {
                return;
            }
            this.m_ListCellRenderer = p_ListCellRenderer;
            if (this.m_HorizontalAlignment >= 0) {
                if (this.m_ListCellRenderer instanceof JLabel) {
                    ((JLabel)((Object)this.m_ListCellRenderer)).setHorizontalAlignment(this.m_HorizontalAlignment);
                } else if (this.m_ListCellRenderer instanceof JTextField) {
                    ((JTextField)((Object)this.m_ListCellRenderer)).setHorizontalAlignment(this.m_HorizontalAlignment);
                }
            }
            ((JComboBox)this.getComponent()).setRenderer(p_ListCellRenderer);
        }

        @Override
        public void setHorizontalAlignment(int p_Alignment) {
            if (p_Alignment == 2 || p_Alignment == 0 || p_Alignment == 4 || p_Alignment == 10 || p_Alignment == 11) {
                this.m_HorizontalAlignment = p_Alignment;
                if (this.m_HorizontalAlignment >= 0) {
                    if (this.m_ListCellRenderer instanceof JLabel) {
                        ((JLabel)((Object)this.m_ListCellRenderer)).setHorizontalAlignment(p_Alignment);
                    } else if (this.m_ListCellRenderer instanceof JTextField) {
                        ((JTextField)((Object)this.m_ListCellRenderer)).setHorizontalAlignment(p_Alignment);
                    }
                }
            }
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (this.m_ListCellRenderer == null) {
                return this.m_JLabelError;
            }
            this.m_List_Virtual.setJTable(table);
            this.m_List_Virtual.setBackground(table.getBackground());
            this.m_List_Virtual.setForeground(table.getForeground());
            int intListIndex = 0;
            Component o_Component = this.m_ListCellRenderer.getListCellRendererComponent(this.m_List_Virtual, value, intListIndex, isSelected, hasFocus);
            if (o_Component instanceof JComponent) {
                super.setExternalRendererComponent((JComponent)o_Component);
                return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
            return o_Component;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            ((JComboBox)this.getComponent()).setSelectedItem(value);
            return (JComboBox)this.getComponent();
        }

        public static class JList_Virtual<E>
        extends JList<E> {
            JTable m_JTable;

            public void setJTable(JTable p_JTable) {
                this.m_JTable = p_JTable;
            }

            @Override
            public boolean hasFocus() {
                if (this.m_JTable == null) {
                    return false;
                }
                return this.m_JTable.hasFocus();
            }
        }
    }

    protected static class DefaultTableCellRenderer_CheckBox
    extends TableCellRenderer_Basic {
        protected JCheckBox_RightClickToolTip m_JCheckBox;
        protected TableCellEditorRenderer m_TableCellEditorRenderer;

        public DefaultTableCellRenderer_CheckBox(TableCellEditorRenderer p_TableCellEditorRenderer) {
            this.m_TableCellEditorRenderer = p_TableCellEditorRenderer;
            this.initComponents();
        }

        private void initComponents() {
            this.m_JCheckBox = new JCheckBox_RightClickToolTip();
            this.m_JCheckBox.setOpaque(true);
        }

        @Override
        public void setIcon(Icon p_Icon) {
            this.m_JCheckBox.setIcon(p_Icon);
        }

        public void setSelectedIcon(Icon p_Icon) {
            this.m_JCheckBox.setSelectedIcon(p_Icon);
        }

        public void setText(String p_Text) {
            if (p_Text == null) {
                p_Text = "";
            }
            this.m_JCheckBox.setText(p_Text);
        }

        @Override
        public void setHorizontalAlignment(int p_Alignment) {
            if (p_Alignment == 2 || p_Alignment == 0 || p_Alignment == 4 || p_Alignment == 10 || p_Alignment == 11) {
                this.m_JCheckBox.setHorizontalAlignment(p_Alignment);
            }
        }

        @Override
        public void setToolTipText_Automatic(int p_TooTipAutomaticMode) {
            this.m_ToolTip_Automatic = 0;
        }

        @Override
        public int getToolTipText_Automatic() {
            return 0;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Color o_Foreground = this.m_Foreground != null ? this.m_Foreground : table.getForeground();
            Color o_Background = this.m_Background != null ? this.m_Background : table.getBackground();
            if (isSelected) {
                if (table.hasFocus()) {
                    o_Background = UIManager.getColor("Table.selectionBackground");
                    o_Foreground = UIManager.getColor("Table.selectionForeground");
                } else {
                    o_Background = UIManager.getColor("Table.selectionInactiveBackground");
                    o_Foreground = UIManager.getColor("Table.selectionInactiveForeground");
                }
            }
            this.m_JCheckBox.setBackground(o_Background);
            this.m_JCheckBox.setForeground(o_Foreground);
            if (this.m_Font != null) {
                this.m_JCheckBox.setFont(this.m_Font);
            } else {
                this.m_JCheckBox.setFont(table.getFont());
            }
            boolean boolSelected = false;
            if (value instanceof Boolean) {
                boolSelected = (Boolean)value;
            } else if (value instanceof String) {
                if ("true".equalsIgnoreCase(((String)value).trim())) {
                    boolSelected = true;
                }
            } else if (value instanceof Object) {
                Method o_Method = null;
                try {
                    o_Method = value.getClass().getMethod("isSelected", new Class[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (o_Method == null) {
                    try {
                        o_Method = value.getClass().getMethod("getSelected", new Class[0]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (o_Method != null && o_Method.getReturnType() == Boolean.class) {
                    try {
                        boolSelected = (Boolean)o_Method.invoke(value, new Object[0]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            this.m_JCheckBox.setSelected(boolSelected);
            String stringToolTipText = this.m_DefaultToolTipText;
            if (this.m_ToolTipText_MouseOver) {
                this.m_JCheckBox.setToolTipText(stringToolTipText);
            } else {
                this.m_JCheckBox.setToolTipText(null);
            }
            if (this.m_ToolTipText_MouseRightClick) {
                this.m_JCheckBox.setToolTipText_RightClick(stringToolTipText);
            } else {
                this.m_JCheckBox.setToolTipText_RightClick(null);
            }
            return this.m_JCheckBox;
        }
    }

    public static class TableCellEditorRenderer_CheckBox
    extends TableCellEditorRenderer<String> {
        DefaultTableCellRenderer_CheckBox m_DefaultTableCellRenderer_CheckBox;

        public TableCellEditorRenderer_CheckBox() {
            super(new JCheckBox());
            this.m_DefaultTableCellRenderer_CheckBox = (DefaultTableCellRenderer_CheckBox)this.m_TableCellRenderer_Basic;
        }

        @Override
        public void setIcon(Icon p_Icon) {
            ((JCheckBox)this.getComponent()).setIcon(p_Icon);
            this.m_DefaultTableCellRenderer_CheckBox.setIcon(p_Icon);
        }

        public void setSelectedIcon(Icon p_Icon) {
            ((JCheckBox)this.getComponent()).setSelectedIcon(p_Icon);
            this.m_DefaultTableCellRenderer_CheckBox.setSelectedIcon(p_Icon);
        }

        public void setText(String p_Text) {
            if (p_Text == null) {
                p_Text = "";
            }
            ((JCheckBox)this.getComponent()).setText(p_Text);
            this.m_DefaultTableCellRenderer_CheckBox.setText(p_Text);
        }
    }

    public static class TableCellEditorRenderer_Time
    extends TableCellEditorRenderer<String> {
        private static final long serialVersionUID = 1L;
        protected DocumentFilter_Time m_DocumentFilter_Time;

        public TableCellEditorRenderer_Time() {
            super(new JTextField());
            this.initComponents();
        }

        private void initComponents() {
            this.m_DocumentFilter_Time = new DocumentFilter_Time((JTextField)this.getComponent());
        }

        public void setAllowNegativeTime(boolean p_AllowNegativeTime) {
            this.m_DocumentFilter_Time.setAllowNegativeTime(p_AllowNegativeTime);
        }
    }

    public static class TableCellEditorRenderer_Float
    extends TableCellEditorRenderer {
        private static final long serialVersionUID = 1L;
        protected DocumentFilter_Float m_DocumentFilter_Float;

        public TableCellEditorRenderer_Float() {
            super(new JTextField());
            this.initComponents();
        }

        private void initComponents() {
            this.m_DocumentFilter_Float = new DocumentFilter_Float((JTextField)this.getComponent());
        }

        public void setAllowNegativeNumbers(boolean p_AllowNegativeNumbers) {
            this.m_DocumentFilter_Float.setAllowNegativeNumbers(p_AllowNegativeNumbers);
        }
    }

    public static class TableCellEditorRenderer_Double
    extends TableCellEditorRenderer {
        private static final long serialVersionUID = 1L;
        protected DocumentFilter_Double m_DocumentFilter_Double;

        public TableCellEditorRenderer_Double() {
            super(new JTextField());
            this.initComponents();
        }

        private void initComponents() {
            this.m_DocumentFilter_Double = new DocumentFilter_Double((JTextField)this.getComponent());
        }

        public void setAllowNegativeNumbers(boolean p_AllowNegativeNumbers) {
            this.m_DocumentFilter_Double.setAllowNegativeNumbers(p_AllowNegativeNumbers);
        }
    }

    public static class TableCellEditorRenderer_Long
    extends TableCellEditorRenderer {
        private static final long serialVersionUID = 1L;
        protected DocumentFilter_Long m_DocumentFilter_Long;

        public TableCellEditorRenderer_Long() {
            super(new JTextField());
            this.initComponents();
        }

        private void initComponents() {
            this.m_DocumentFilter_Long = new DocumentFilter_Long((JTextField)this.getComponent());
        }

        public void setAllowNegativeNumbers(boolean p_AllowNegativeNumbers) {
            this.m_DocumentFilter_Long.setAllowNegativeNumbers(p_AllowNegativeNumbers);
        }
    }

    public static class TableCellEditorRenderer_Integer
    extends TableCellEditorRenderer {
        private static final long serialVersionUID = 1L;
        protected DocumentFilter_Integer m_DocumentFilter_Integer;

        public TableCellEditorRenderer_Integer() {
            super(new JTextField());
            this.initComponents();
        }

        private void initComponents() {
            this.m_DocumentFilter_Integer = new DocumentFilter_Integer((JTextField)this.getComponent());
        }

        public void setAllowNegativeNumbers(boolean p_AllowNegativeNumbers) {
            this.m_DocumentFilter_Integer.setAllowNegativeNumbers(p_AllowNegativeNumbers);
        }
    }

    public static class TableCellEditorRenderer_String
    extends TableCellEditorRenderer<String> {
        private static final long serialVersionUID = 1L;

        public TableCellEditorRenderer_String() {
            super(new JTextField());
        }
    }

    public static abstract class TableCellEditorRenderer<E>
    extends DefaultCellEditor
    implements TableCellEditor,
    TableCellRenderer {
        private static final long serialVersionUID = 1L;
        protected TableCellRenderer_Basic m_TableCellRenderer_Basic;

        public TableCellEditorRenderer(JTextField p_JTextField) {
            super(p_JTextField);
            this.initComponents();
        }

        public TableCellEditorRenderer(JCheckBox p_JCheckBox) {
            super(p_JCheckBox);
            this.initComponents();
        }

        public TableCellEditorRenderer(JComboBox<E> p_JComboBox) {
            super(p_JComboBox);
            this.initComponents();
        }

        private void initComponents() {
            if (this.getComponent() instanceof JTextField) {
                this.m_TableCellRenderer_Basic = new TableCellRenderer_Basic();
            } else if (this.getComponent() instanceof JCheckBox) {
                this.m_TableCellRenderer_Basic = new DefaultTableCellRenderer_CheckBox(this);
            } else if (this.getComponent() instanceof JComboBox) {
                this.m_TableCellRenderer_Basic = new TableCellRenderer_Basic();
            }
            this.m_TableCellRenderer_Basic.setHorizontalAlignment(0);
            if (this.getComponent() instanceof JTextField) {
                ((JTextField)this.getComponent()).setHorizontalAlignment(0);
            }
            if (this.getComponent() instanceof JCheckBox) {
                ((JCheckBox)this.getComponent()).setHorizontalAlignment(0);
            }
        }

        public void setHorizontalAlignment(int p_Alignment) {
            if (p_Alignment == 2 || p_Alignment == 0 || p_Alignment == 4 || p_Alignment == 10 || p_Alignment == 11) {
                if (this.getComponent() instanceof JLabel) {
                    ((JLabel)this.getComponent()).setHorizontalAlignment(p_Alignment);
                }
                if (this.getComponent() instanceof JTextField) {
                    ((JTextField)this.getComponent()).setHorizontalAlignment(p_Alignment);
                }
                if (this.getComponent() instanceof JCheckBox) {
                    ((JCheckBox)this.getComponent()).setHorizontalAlignment(p_Alignment);
                }
                this.m_TableCellRenderer_Basic.setHorizontalAlignment(p_Alignment);
            }
        }

        public void setToolTipText(String p_ToolTipText) {
            this.m_TableCellRenderer_Basic.setToolTipText(p_ToolTipText);
        }

        public String getToolTipText() {
            return this.m_TableCellRenderer_Basic.getToolTipText();
        }

        public void setToolTipTextAt(boolean p_MouseOver, boolean p_MouseRightClick) {
            this.m_TableCellRenderer_Basic.setToolTipTextAt(p_MouseOver, p_MouseRightClick);
        }

        public boolean getToolTipTextAt_MouseOver() {
            return this.m_TableCellRenderer_Basic.getToolTipTextAt_MouseOver();
        }

        public boolean getToolTipTextAt_MouseRightClick() {
            return this.m_TableCellRenderer_Basic.getToolTipTextAt_MouseRightClick();
        }

        public void setToolTipText_Automatic(int p_ToolTipAutomaticMode) {
            this.m_TableCellRenderer_Basic.setToolTipText_Automatic(p_ToolTipAutomaticMode);
        }

        public int getToolTipText_Automatic() {
            return this.m_TableCellRenderer_Basic.getToolTipText_Automatic();
        }

        public void setForeground(Color p_Foreground) {
            this.m_TableCellRenderer_Basic.setForeground(p_Foreground);
        }

        public void setBackground(Color p_Background) {
            this.m_TableCellRenderer_Basic.setBackground(p_Background);
        }

        public void setFont(Font p_Font) {
            this.m_TableCellRenderer_Basic.setFont(p_Font);
        }

        public void setBorder(Border p_Border) {
            this.m_TableCellRenderer_Basic.setBorder(p_Border);
        }

        public void setIcon(Icon p_Icon) {
            this.m_TableCellRenderer_Basic.setIcon(p_Icon);
        }

        public void setIconAutomatic(int p_IconAutomatic) {
            this.m_TableCellRenderer_Basic.setIconAutomatic(p_IconAutomatic);
        }

        public Icon getIcon() {
            return this.m_TableCellRenderer_Basic.getIcon();
        }

        protected void setExternalRendererComponent(JComponent p_Component) {
            this.m_TableCellRenderer_Basic.setExternalRendererComponent(p_Component);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return this.m_TableCellRenderer_Basic.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }

        @Override
        public void setClickCountToStart(int p_ClickCount) {
            if (p_ClickCount <= 0) {
                p_ClickCount = 1;
            }
            if (p_ClickCount > 3) {
                p_ClickCount = 3;
            }
            super.setClickCountToStart(p_ClickCount);
        }

        @Override
        public int getClickCountToStart() {
            return super.getClickCountToStart();
        }

        @Override
        public boolean stopCellEditing() {
            return super.stopCellEditing();
        }

        @Override
        public Object getCellEditorValue() {
            return super.getCellEditorValue();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            return super.getTableCellEditorComponent(table, value, isSelected, row, column);
        }
    }

    public static class TableCellRenderer_Basic
    implements TableCellRenderer {
        public static final int TOOLTIPAUTOMATIC_OFF = 0;
        public static final int TOOLTIPAUTOMATIC_EQUALSVALUE = 1;
        public static final int TOOLTIPAUTOMATIC_FROMELEMENT = 2;
        public static final int ICONAUTOMATIC_DEFAULT = 0;
        public static final int ICONAUTOMATIC_FROMELEMENT = 1;
        protected JPanel_RightClickToolTip m_JPanel_RightClick;
        protected JLabel_RightClickToolTip m_JLabel_RightClick;
        protected JComponent m_ExternalComponent;
        protected GridBagConstraints m_ExternGridBagConstraints;
        protected String m_DefaultToolTipText;
        protected boolean m_ToolTipText_MouseOver;
        protected boolean m_ToolTipText_MouseRightClick;
        protected int m_ToolTip_Automatic;
        protected Color m_Foreground;
        protected Color m_Background;
        protected Font m_Font;
        protected Border m_Border;
        protected Icon m_DefaultIcon;
        protected int m_IconAutomatic;

        public TableCellRenderer_Basic() {
            this.initComponents();
        }

        private void initComponents() {
            this.m_JPanel_RightClick = new JPanel_RightClickToolTip();
            this.m_JPanel_RightClick.setLayout(new GridBagLayout());
            this.m_ExternGridBagConstraints = new GridBagConstraints();
            this.m_ExternGridBagConstraints.gridx = 0;
            this.m_ExternGridBagConstraints.gridy = 0;
            this.m_ExternGridBagConstraints.fill = 1;
            this.m_ExternGridBagConstraints.weightx = 1.0;
            this.m_ExternGridBagConstraints.weighty = 1.0;
            this.m_JLabel_RightClick = new JLabel_RightClickToolTip();
            this.m_JLabel_RightClick.setOpaque(true);
            this.m_ToolTipText_MouseOver = true;
            this.m_ToolTipText_MouseRightClick = false;
            this.m_DefaultToolTipText = null;
            this.m_ToolTip_Automatic = 0;
            this.m_Background = null;
            this.m_Foreground = null;
            this.m_Font = null;
            this.m_DefaultIcon = null;
            this.m_IconAutomatic = 0;
            this.m_Border = null;
        }

        public void setHorizontalAlignment(int p_Alignment) {
            if (p_Alignment == 2 || p_Alignment == 0 || p_Alignment == 4 || p_Alignment == 10 || p_Alignment == 11) {
                this.m_JLabel_RightClick.setHorizontalAlignment(p_Alignment);
            }
        }

        public void setToolTipText(String p_ToolTipText) {
            this.m_DefaultToolTipText = p_ToolTipText;
        }

        public String getToolTipText() {
            return this.m_DefaultToolTipText;
        }

        public void setToolTipTextAt(boolean p_MouseOver, boolean p_MouseRightClick) {
            this.m_ToolTipText_MouseOver = p_MouseOver;
            this.m_ToolTipText_MouseRightClick = p_MouseRightClick;
        }

        public boolean getToolTipTextAt_MouseOver() {
            return this.m_ToolTipText_MouseOver;
        }

        public boolean getToolTipTextAt_MouseRightClick() {
            return this.m_ToolTipText_MouseRightClick;
        }

        public void setToolTipText_Automatic(int p_ToolTipAutomaticMode) {
            if (p_ToolTipAutomaticMode < 0 || p_ToolTipAutomaticMode > 2) {
                p_ToolTipAutomaticMode = 0;
            }
            this.m_ToolTip_Automatic = p_ToolTipAutomaticMode;
        }

        public int getToolTipText_Automatic() {
            return this.m_ToolTip_Automatic;
        }

        public void setForeground(Color p_Foreground) {
            this.m_Foreground = p_Foreground;
        }

        public Color getForeground() {
            return this.m_Foreground;
        }

        public void setBackground(Color p_Background) {
            this.m_Background = p_Background;
        }

        public Color getBackground() {
            return this.m_Background;
        }

        public void setFont(Font p_Font) {
            this.m_Font = p_Font;
        }

        public void setBorder(Border p_Border) {
            this.m_Border = p_Border;
        }

        public Border getBorder() {
            return this.m_Border;
        }

        public void setIcon(Icon p_Icon) {
            this.m_DefaultIcon = p_Icon;
        }

        public Icon getIcon() {
            return this.m_DefaultIcon;
        }

        public void setIconAutomatic(int p_IconAutomatic) {
            if (p_IconAutomatic != 0 && p_IconAutomatic != 1) {
                return;
            }
            this.m_IconAutomatic = p_IconAutomatic;
        }

        public void setExternalRendererComponent(JComponent p_Component) {
            if (this.m_ExternalComponent != null) {
                this.m_JPanel_RightClick.remove(this.m_ExternalComponent);
            }
            if (p_Component != null) {
                this.m_JPanel_RightClick.add((Component)p_Component, this.m_ExternGridBagConstraints);
            }
            this.m_ExternalComponent = p_Component;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String stringValue;
            String stringToolTipText = null;
            Object o_Element = null;
            if (this.m_ExternalComponent != null) {
                stringToolTipText = this.m_ToolTip_Automatic == 2 ? this.m_ExternalComponent.getToolTipText() : this.m_DefaultToolTipText;
                if (this.m_ToolTipText_MouseRightClick) {
                    this.m_JPanel_RightClick.setToolTipText_RightClick(stringToolTipText);
                } else {
                    this.m_JPanel_RightClick.setToolTipText_RightClick(null);
                }
                if (this.m_ToolTipText_MouseOver) {
                    this.m_JPanel_RightClick.setToolTipText(stringToolTipText);
                } else {
                    this.m_JPanel_RightClick.setToolTipText(null);
                }
                return this.m_JPanel_RightClick;
            }
            if (table == null) {
                this.m_JLabel_RightClick.setIcon(null);
                this.m_JLabel_RightClick.setText("");
                this.m_JLabel_RightClick.setToolTipText_RightClick(null);
                this.m_JLabel_RightClick.setToolTipText(null);
                return this.m_JLabel_RightClick;
            }
            Color o_Foreground = this.m_Foreground != null ? this.m_Foreground : table.getForeground();
            Color o_Background = this.m_Background != null ? this.m_Background : table.getBackground();
            if (isSelected) {
                if (table.hasFocus()) {
                    o_Background = UIManager.getColor("Table.selectionBackground");
                    o_Foreground = UIManager.getColor("Table.selectionForeground");
                } else {
                    o_Background = UIManager.getColor("Table.selectionInactiveBackground");
                    o_Foreground = UIManager.getColor("Table.selectionInactiveForeground");
                }
            }
            this.m_JLabel_RightClick.setBackground(o_Background);
            this.m_JLabel_RightClick.setForeground(o_Foreground);
            if (this.m_Font != null) {
                this.m_JLabel_RightClick.setFont(this.m_Font);
            } else {
                this.m_JLabel_RightClick.setFont(table.getFont());
            }
            this.m_JLabel_RightClick.setIcon(this.m_DefaultIcon);
            if (this.m_IconAutomatic == 1 && (o_Element = this.getElement(table, row)) != null) {
                Icon o_Icon;
                Method o_Method;
                try {
                    o_Method = o_Element.getClass().getMethod("getIcon", new Class[0]);
                    if (o_Method.getReturnType() != Icon.class) {
                        o_Method = null;
                    }
                }
                catch (Exception e) {
                    o_Method = null;
                }
                if (o_Method != null) {
                    try {
                        o_Icon = (Icon)o_Method.invoke(o_Element, new Object[0]);
                    }
                    catch (Exception e) {
                        o_Icon = null;
                    }
                } else {
                    o_Icon = null;
                }
                if (o_Icon != null) {
                    this.m_JLabel_RightClick.setIcon(o_Icon);
                }
            }
            this.m_JLabel_RightClick.setBorder(this.m_Border);
            if (value instanceof String) {
                stringValue = (String)value;
                this.m_JLabel_RightClick.setText(stringValue);
            } else {
                stringValue = String.valueOf(value);
                this.m_JLabel_RightClick.setText(stringValue);
            }
            if (this.m_ToolTip_Automatic == 0 || row < 0) {
                stringToolTipText = this.m_DefaultToolTipText;
            } else if (this.m_ToolTip_Automatic == 2 && row >= 0) {
                int intRow = table.convertRowIndexToModel(row);
                if ((this.m_ToolTipText_MouseOver || this.m_ToolTipText_MouseRightClick) && (o_Element = this.getElement(table, row)) != null) {
                    Method o_Method;
                    try {
                        o_Method = o_Element.getClass().getMethod("getToolTipText", new Class[0]);
                        if (o_Method.getReturnType() != String.class) {
                            o_Method = null;
                        }
                    }
                    catch (Exception e) {
                        o_Method = null;
                    }
                    if (o_Method != null) {
                        try {
                            stringToolTipText = (String)o_Method.invoke(o_Element, new Object[0]);
                        }
                        catch (Exception e) {
                            stringToolTipText = null;
                        }
                    } else {
                        stringToolTipText = null;
                    }
                }
            } else if (this.m_ToolTip_Automatic == 1) {
                stringToolTipText = stringValue;
            }
            if (this.m_ToolTipText_MouseOver) {
                this.m_JLabel_RightClick.setToolTipText(stringToolTipText);
            } else {
                this.m_JLabel_RightClick.setToolTipText(null);
            }
            if (this.m_ToolTipText_MouseRightClick) {
                this.m_JLabel_RightClick.setToolTipText_RightClick(stringToolTipText);
            } else {
                this.m_JLabel_RightClick.setToolTipText_RightClick(null);
            }
            return this.m_JLabel_RightClick;
        }

        private Object getElement(JTable p_JTable, int p_Row) {
            if (p_JTable == null) {
                return null;
            }
            if (p_Row < 0) {
                return null;
            }
            Object o_Element = null;
            int intRow = p_JTable.convertRowIndexToModel(p_Row);
            TableModel o_TableModel = p_JTable.getModel();
            if (o_TableModel != null) {
                if (o_TableModel instanceof TableAndListModel) {
                    o_Element = ((TableAndListModel)o_TableModel).getElementAt(intRow);
                } else {
                    try {
                        Method o_Method = o_TableModel.getClass().getMethod("getElementAt", Integer.TYPE);
                        if (o_Method.getReturnType() != Object.class) {
                            o_Method = null;
                        }
                        if (o_Method != null) {
                            o_Element = o_Method.invoke((Object)o_TableModel, intRow);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            return o_Element;
        }
    }

    public static class TableCellHeaderRenderer
    extends TableCellRenderer_Basic {
        private static final long serialVersionUID = 1L;

        public TableCellHeaderRenderer() {
            this.initComponents();
        }

        private void initComponents() {
            this.setHorizontalAlignment(0);
        }

        @Override
        public void setHorizontalAlignment(int p_Alignment) {
            if (p_Alignment == 2 || p_Alignment == 0 || p_Alignment == 4 || p_Alignment == 10 || p_Alignment == 11) {
                super.setHorizontalAlignment(p_Alignment);
            }
        }

        @Override
        public void setToolTipText_Automatic(int p_TooTipAutomatic) {
            if (p_TooTipAutomatic == 2) {
                p_TooTipAutomatic = 0;
            }
            super.setToolTipText_Automatic(p_TooTipAutomatic);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JComponent o_JComponent = (JComponent)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (this.m_Background == null) {
                this.setBackground(UIManager.getColor("TableHeader.background"));
            }
            if (this.m_Foreground == null) {
                this.setForeground(UIManager.getColor("TableHeader.foreground"));
            }
            return o_JComponent;
        }
    }

    public static class TableBehavior {
        private TableBehaviorListener m_TableBehaviorListener;
        private JTable m_JTable;
        private TableModel m_TableModel;
        private ArrayList<MouseListener> m_OriginalMouseListeners;
        private ArrayList<MouseMotionListener> m_OriginalMouseMotionListeners;
        private ArrayList<Integer> m_MouseExcludedColumns;
        private ArrayList<Boolean> m_MouseExcludedColumns_MouseEntered;
        private MouseAdapter m_NewMouseAdapter;
        private final Object m_Sync = new Object();

        public TableBehavior(JTable p_JTable, TableBehaviorListener p_TableBeaviorInterface) {
            this.initMembers();
            this.m_TableBehaviorListener = p_TableBeaviorInterface;
            this.m_JTable = p_JTable;
            if (this.m_JTable != null) {
                this.m_TableModel = this.m_JTable.getModel();
            }
            this.replaceMouseListeners();
        }

        private void initMembers() {
            this.m_JTable = null;
            this.m_TableModel = null;
            this.m_OriginalMouseListeners = new ArrayList();
            this.m_OriginalMouseMotionListeners = new ArrayList();
            this.m_MouseExcludedColumns = new ArrayList();
            this.m_MouseExcludedColumns_MouseEntered = new ArrayList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            if (this.m_JTable == null) {
                return;
            }
            if (this.m_TableModel == null) {
                return;
            }
            Object object = this.m_Sync;
            synchronized (object) {
                int intListener;
                this.m_JTable.removeMouseListener(this.m_NewMouseAdapter);
                for (intListener = 0; intListener < this.m_OriginalMouseListeners.size(); ++intListener) {
                    this.m_JTable.addMouseListener(this.m_OriginalMouseListeners.get(intListener));
                }
                this.m_JTable.removeMouseMotionListener(this.m_NewMouseAdapter);
                for (intListener = 0; intListener < this.m_OriginalMouseMotionListeners.size(); ++intListener) {
                    this.m_JTable.addMouseMotionListener(this.m_OriginalMouseMotionListeners.get(intListener));
                }
                this.m_OriginalMouseListeners.clear();
                this.m_OriginalMouseMotionListeners.clear();
                this.m_MouseExcludedColumns.clear();
                this.m_MouseExcludedColumns_MouseEntered.clear();
                this.m_JTable = null;
                this.m_TableModel = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addMouseExcludedColumn(int p_Column, boolean p_ExludeMouseEnteredExited) {
            Object object = this.m_Sync;
            synchronized (object) {
                if (this.m_TableModel == null) {
                    return;
                }
                if (p_Column < 0) {
                    return;
                }
                if (p_Column >= this.m_TableModel.getColumnCount()) {
                    return;
                }
                int intIndex = this.m_MouseExcludedColumns.indexOf(p_Column);
                if (intIndex < 0) {
                    this.m_MouseExcludedColumns.add(p_Column);
                    this.m_MouseExcludedColumns_MouseEntered.add(p_ExludeMouseEnteredExited);
                } else {
                    this.m_MouseExcludedColumns_MouseEntered.set(intIndex, p_ExludeMouseEnteredExited);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeExcludedColumn(int p_Column) {
            Object object = this.m_Sync;
            synchronized (object) {
                if (this.m_TableModel == null) {
                    return;
                }
                if (p_Column < 0) {
                    return;
                }
                if (p_Column >= this.m_TableModel.getColumnCount()) {
                    return;
                }
                int intIndex = this.m_MouseExcludedColumns.indexOf(p_Column);
                if (intIndex >= 0) {
                    this.m_MouseExcludedColumns.remove(intIndex);
                    this.m_MouseExcludedColumns_MouseEntered.remove(intIndex);
                }
            }
        }

        public int getMouseExludedColumnsCount() {
            return this.m_MouseExcludedColumns.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getMouseExludedColumn(int p_Index) {
            if (p_Index < 0) {
                return -1;
            }
            Object object = this.m_Sync;
            synchronized (object) {
                if (p_Index >= this.m_MouseExcludedColumns.size()) {
                    return -1;
                }
                return this.m_MouseExcludedColumns.get(p_Index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean getMouseExludedColumn_MouseEntered(int p_Index) {
            if (p_Index < 0) {
                return false;
            }
            Object object = this.m_Sync;
            synchronized (object) {
                if (p_Index >= this.m_MouseExcludedColumns_MouseEntered.size()) {
                    return false;
                }
                return this.m_MouseExcludedColumns_MouseEntered.get(p_Index);
            }
        }

        public int getOriginalMouseListenerCount() {
            return this.m_OriginalMouseListeners.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MouseListener getOriginalMouseListener(int p_Index) {
            Object object = this.m_Sync;
            synchronized (object) {
                if (p_Index < 0) {
                    return null;
                }
                if (p_Index >= this.m_OriginalMouseListeners.size()) {
                    return null;
                }
                return this.m_OriginalMouseListeners.get(p_Index);
            }
        }

        public int getOriginalMouseMotionListenerCount() {
            return this.m_OriginalMouseListeners.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MouseMotionListener getOriginalMouseMotionListener(int p_Index) {
            Object object = this.m_Sync;
            synchronized (object) {
                if (p_Index < 0) {
                    return null;
                }
                if (p_Index >= this.m_OriginalMouseMotionListeners.size()) {
                    return null;
                }
                return this.m_OriginalMouseMotionListeners.get(p_Index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void replaceMouseListeners() {
            if (this.m_JTable == null) {
                return;
            }
            if (this.m_TableModel == null) {
                return;
            }
            Object object = this.m_Sync;
            synchronized (object) {
                int intListener;
                MouseListener[] o_MouseListeners = this.m_JTable.getMouseListeners();
                for (intListener = 0; intListener < o_MouseListeners.length; ++intListener) {
                    MouseListener o_MouseListener = o_MouseListeners[intListener];
                    this.m_JTable.removeMouseListener(o_MouseListener);
                    this.m_OriginalMouseListeners.add(o_MouseListener);
                }
                MouseMotionListener[] o_MouseMotionListeners = this.m_JTable.getMouseMotionListeners();
                for (intListener = 0; intListener < o_MouseMotionListeners.length; ++intListener) {
                    MouseMotionListener o_MouseMotionListener = o_MouseMotionListeners[intListener];
                    this.m_JTable.removeMouseMotionListener(o_MouseMotionListener);
                    this.m_OriginalMouseMotionListeners.add(o_MouseMotionListener);
                }
                this.m_NewMouseAdapter = new MouseAdapter(){
                    private int m_ColumnPressed = -1;
                    private int m_RowPressed = -1;
                    private Object m_ValuePressed;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void mouseClicked(MouseEvent e) {
                        if (m_JTable == null) {
                            return;
                        }
                        boolean boolSuppress = false;
                        int intRow = m_JTable.rowAtPoint(e.getPoint());
                        int intColumn = m_JTable.columnAtPoint(e.getPoint());
                        if (intRow < 0 || intColumn < 0) {
                            return;
                        }
                        intRow = m_JTable.convertRowIndexToModel(intRow);
                        intColumn = m_JTable.convertColumnIndexToModel(intColumn);
                        Object object = m_Sync;
                        synchronized (object) {
                            if (m_MouseExcludedColumns.contains(intColumn)) {
                                boolSuppress = true;
                            }
                        }
                        if (boolSuppress) {
                            Object o_Value = null;
                            TableModel o_TableModel = m_JTable.getModel();
                            if (o_TableModel != null) {
                                o_Value = o_TableModel.getValueAt(intRow, intColumn);
                            }
                            if (m_TableBehaviorListener != null) {
                                m_TableBehaviorListener.excludedMouseEvent(e, m_JTable, intRow, intColumn, o_Value);
                            }
                            e.consume();
                            return;
                        }
                        for (int intListener = 0; intListener < this.getOriginalMouseListenerCount(); ++intListener) {
                            MouseListener o_MouseListener = this.getOriginalMouseListener(intListener);
                            if (o_MouseListener == null) continue;
                            try {
                                o_MouseListener.mouseClicked(e);
                                continue;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void mousePressed(MouseEvent e) {
                        if (m_JTable == null) {
                            return;
                        }
                        boolean boolSuppress = false;
                        int intRow = m_JTable.rowAtPoint(e.getPoint());
                        int intColumn = m_JTable.columnAtPoint(e.getPoint());
                        if (intRow < 0 || intColumn < 0) {
                            return;
                        }
                        intRow = m_JTable.convertRowIndexToModel(intRow);
                        intColumn = m_JTable.convertColumnIndexToModel(intColumn);
                        Object object = m_Sync;
                        synchronized (object) {
                            if (m_MouseExcludedColumns.contains(intColumn)) {
                                boolSuppress = true;
                            }
                        }
                        if (boolSuppress) {
                            this.m_RowPressed = intRow;
                            this.m_ColumnPressed = intColumn;
                            Object o_Value = null;
                            TableModel o_TableModel = m_JTable.getModel();
                            if (o_TableModel != null) {
                                o_Value = o_TableModel.getValueAt(intRow, intColumn);
                            }
                            this.m_ValuePressed = o_Value;
                            if (m_TableBehaviorListener != null) {
                                m_TableBehaviorListener.excludedMouseEvent(e, m_JTable, intRow, intColumn, o_Value);
                            }
                            e.consume();
                            return;
                        }
                        this.m_RowPressed = -1;
                        this.m_ColumnPressed = -1;
                        this.m_ValuePressed = null;
                        for (int intListener = 0; intListener < this.getOriginalMouseListenerCount(); ++intListener) {
                            MouseListener o_MouseListener = this.getOriginalMouseListener(intListener);
                            if (o_MouseListener == null) continue;
                            try {
                                o_MouseListener.mousePressed(e);
                                continue;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void mouseReleased(MouseEvent e) {
                        boolean boolExcluded = false;
                        this.m_RowPressed = -1;
                        this.m_ColumnPressed = -1;
                        int intRow = m_JTable.rowAtPoint(e.getPoint());
                        int intColumn = m_JTable.columnAtPoint(e.getPoint());
                        if (intRow < 0 || intColumn < 0) {
                            return;
                        }
                        intRow = m_JTable.convertRowIndexToModel(intRow);
                        intColumn = m_JTable.convertColumnIndexToModel(intColumn);
                        Object object = m_Sync;
                        synchronized (object) {
                            if (m_MouseExcludedColumns.contains(intColumn)) {
                                boolExcluded = true;
                            }
                        }
                        if (boolExcluded) {
                            Object o_Value = null;
                            TableModel o_TableModel = m_JTable.getModel();
                            if (o_TableModel != null) {
                                o_Value = o_TableModel.getValueAt(intRow, intColumn);
                            }
                            if (m_TableBehaviorListener != null) {
                                m_TableBehaviorListener.excludedMouseEvent(e, m_JTable, intRow, intColumn, o_Value);
                            }
                            e.consume();
                            return;
                        }
                        for (int intListener = 0; intListener < this.getOriginalMouseListenerCount(); ++intListener) {
                            MouseListener o_MouseListener = this.getOriginalMouseListener(intListener);
                            if (o_MouseListener == null) continue;
                            try {
                                o_MouseListener.mouseReleased(e);
                                continue;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }

                    @Override
                    public void mouseEntered(MouseEvent e) {
                        for (int intListener = 0; intListener < this.getOriginalMouseListenerCount(); ++intListener) {
                            MouseListener o_MouseListener = this.getOriginalMouseListener(intListener);
                            if (o_MouseListener == null) continue;
                            try {
                                o_MouseListener.mouseEntered(e);
                                continue;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                        for (int intListener = 0; intListener < this.getOriginalMouseListenerCount(); ++intListener) {
                            MouseListener o_MouseListener = this.getOriginalMouseListener(intListener);
                            if (o_MouseListener == null) continue;
                            try {
                                o_MouseListener.mouseExited(e);
                                continue;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }

                    @Override
                    public void mouseDragged(MouseEvent e) {
                        if (this.m_RowPressed >= 0 && this.m_ColumnPressed >= 0) {
                            if (m_TableBehaviorListener != null) {
                                m_TableBehaviorListener.excludedMouseEvent(e, m_JTable, this.m_RowPressed, this.m_ColumnPressed, this.m_ValuePressed);
                            }
                            e.consume();
                            return;
                        }
                        for (int intListener = 0; intListener < this.getOriginalMouseMotionListenerCount(); ++intListener) {
                            MouseMotionListener o_MouseMotionListener = this.getOriginalMouseMotionListener(intListener);
                            if (o_MouseMotionListener == null) continue;
                            o_MouseMotionListener.mouseDragged(e);
                        }
                    }

                    @Override
                    public void mouseMoved(MouseEvent e) {
                        for (int intListener = 0; intListener < this.getOriginalMouseMotionListenerCount(); ++intListener) {
                            MouseMotionListener o_MouseMotionListener = this.getOriginalMouseMotionListener(intListener);
                            if (o_MouseMotionListener == null) continue;
                            try {
                                o_MouseMotionListener.mouseMoved(e);
                                continue;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                };
                this.m_JTable.addMouseListener(this.m_NewMouseAdapter);
                this.m_JTable.addMouseMotionListener(this.m_NewMouseAdapter);
            }
        }
    }

    public static interface TableBehaviorListener {
        public void excludedMouseEvent(MouseEvent var1, JTable var2, int var3, int var4, Object var5);
    }

    public static class ListRenderer
    extends DefaultListCellRenderer {
        protected static final Border NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);
        protected static final Border SELECTED_BORDER = new LineBorder(Color.BLUE, 2, true);
        private String m_MethodName_GetStringValue;
        private String m_MethodName_GetIcon;
        private String m_MethodName_GetToolTipText;
        private String m_MethodName_GetForeground;
        private String m_MethodName_GetBackground;
        private String m_NUll_Text;
        private String m_NUll_ToolTipText;
        private Icon m_NUll_Icon;
        private Icon m_NUll_IconDisabled;
        private int m_NUll_HorizontalAlignment;
        private Color m_NULL_Background;
        private Color m_NULL_Foreground;
        private boolean m_NULL_Enabled;

        public ListRenderer() {
            this.initMembers();
        }

        public ListRenderer(String p_MethodName_GetStringValue, String p_MethodName_GetIcon) {
            this.initMembers();
            this.m_MethodName_GetStringValue = p_MethodName_GetStringValue;
            this.m_MethodName_GetIcon = p_MethodName_GetIcon;
        }

        public ListRenderer(String p_MethodName_GetStringValue, String p_MethodName_GetIcon, String p_MethodName_ToolTipText) {
            this.initMembers();
            this.m_MethodName_GetStringValue = p_MethodName_GetStringValue;
            this.m_MethodName_GetIcon = p_MethodName_GetIcon;
            this.m_MethodName_GetToolTipText = p_MethodName_ToolTipText;
        }

        private void initMembers() {
            this.m_MethodName_GetStringValue = "getName";
            this.m_MethodName_GetIcon = "getIcon";
            this.m_MethodName_GetToolTipText = "getToolTipText";
            this.m_MethodName_GetForeground = "getForeground";
            this.m_MethodName_GetBackground = "getBackground";
            this.setHorizontalAlignment(0);
            this.m_NUll_Icon = null;
            this.m_NUll_IconDisabled = null;
            this.m_NUll_Text = "---";
            this.m_NUll_ToolTipText = null;
            this.m_NUll_HorizontalAlignment = this.getHorizontalAlignment();
            this.m_NULL_Background = null;
            this.m_NULL_Foreground = null;
            this.m_NULL_Enabled = true;
        }

        public void setNullLabel(Icon p_Icon, Icon p_IconDisabled, String p_Text, String p_ToolTipText, int p_HorizontalAlignment, Color p_Background, Color p_Foreground) {
            this.m_NUll_Icon = p_Icon;
            this.m_NUll_IconDisabled = p_IconDisabled;
            this.m_NUll_Text = p_Text;
            this.m_NUll_ToolTipText = p_ToolTipText;
            this.m_NUll_HorizontalAlignment = p_HorizontalAlignment < 0 ? 10 : p_HorizontalAlignment;
            if (p_Background != null) {
                this.m_NULL_Background = p_Background;
            }
            if (p_Foreground != null) {
                this.m_NULL_Foreground = p_Foreground;
            }
        }

        public void setNullLabel_Enabled(boolean p_NullElementEnabled) {
            this.m_NULL_Enabled = p_NullElementEnabled;
        }

        @Override
        public void setHorizontalAlignment(int p_HorizontalAlignment) {
            super.setHorizontalAlignment(p_HorizontalAlignment);
        }

        private Border getNoFocusBorder() {
            return NO_FOCUS_BORDER;
        }

        private Border getSelectedBorder() {
            return SELECTED_BORDER;
        }

        public void setMethodeName_GetIcon(String p_GetIcon) {
            this.m_MethodName_GetIcon = p_GetIcon;
        }

        public Icon getIcon(Object p_Element) {
            if (p_Element == null) {
                if (this.m_NULL_Enabled) {
                    return this.m_NUll_Icon;
                }
                return this.m_NUll_IconDisabled;
            }
            if (this.m_MethodName_GetIcon == null) {
                return null;
            }
            Class<?> o_Class = p_Element.getClass();
            try {
                Method o_MethodGetName = o_Class.getMethod(this.m_MethodName_GetIcon, new Class[0]);
                if (o_MethodGetName == null) {
                    return null;
                }
                return (Icon)o_MethodGetName.invoke(p_Element, new Object[0]);
            }
            catch (Exception e) {
                return null;
            }
        }

        public String getStringValue(Object p_Element) {
            if (p_Element == null) {
                return this.m_NUll_Text;
            }
            if (this.m_MethodName_GetStringValue == null) {
                return "";
            }
            Class<?> o_Class = p_Element.getClass();
            try {
                Method o_MethodGetName = o_Class.getMethod(this.m_MethodName_GetStringValue, new Class[0]);
                if (o_MethodGetName == null) {
                    return null;
                }
                return (String)o_MethodGetName.invoke(p_Element, new Object[0]);
            }
            catch (Exception e) {
                return null;
            }
        }

        public String getStringToolTip(Object p_Element) {
            if (p_Element == null) {
                return this.m_NUll_ToolTipText;
            }
            if (this.m_MethodName_GetToolTipText == null) {
                return null;
            }
            Class<?> o_Class = p_Element.getClass();
            try {
                Method o_MethodGetName = o_Class.getMethod(this.m_MethodName_GetToolTipText, new Class[0]);
                if (o_MethodGetName == null) {
                    return null;
                }
                return (String)o_MethodGetName.invoke(p_Element, new Object[0]);
            }
            catch (Exception e) {
                return null;
            }
        }

        public Color getForeground(Object p_Element) {
            if (p_Element == null) {
                return this.m_NULL_Foreground;
            }
            if (this.m_MethodName_GetForeground == null) {
                return null;
            }
            Class<?> o_Class = p_Element.getClass();
            try {
                Method o_MethodGetName = o_Class.getMethod(this.m_MethodName_GetForeground, new Class[0]);
                if (o_MethodGetName == null) {
                    return null;
                }
                return (Color)o_MethodGetName.invoke(p_Element, new Object[0]);
            }
            catch (Exception e) {
                return null;
            }
        }

        public Color getBackground(Object p_Element) {
            if (p_Element == null) {
                return this.m_NULL_Background;
            }
            if (this.m_MethodName_GetBackground == null) {
                return null;
            }
            Class<?> o_Class = p_Element.getClass();
            try {
                Method o_MethodGetName = o_Class.getMethod(this.m_MethodName_GetBackground, new Class[0]);
                if (o_MethodGetName == null) {
                    return null;
                }
                return (Color)o_MethodGetName.invoke(p_Element, new Object[0]);
            }
            catch (Exception e) {
                return null;
            }
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setComponentOrientation(list.getComponentOrientation());
            Color o_Background = null;
            Color o_Foreground = null;
            Color o_ColorElement = this.getBackground(value);
            o_Background = o_ColorElement != null ? o_ColorElement : list.getBackground();
            o_ColorElement = this.getForeground(value);
            o_Foreground = o_ColorElement != null ? o_ColorElement : list.getForeground();
            if (isSelected) {
                if (list.hasFocus()) {
                    o_Background = UIManager.getColor("List.selectionBackground");
                    o_Foreground = UIManager.getColor("List.selectionForeground");
                } else {
                    o_Background = UIManager.getColor("List.selectionInactiveBackground");
                    o_Foreground = UIManager.getColor("List.selectionInactiveForeground");
                }
            }
            this.setForeground(o_Foreground);
            this.setBackground(o_Background);
            String stringName = this.getStringValue(value);
            if (stringName != null) {
                this.setText(stringName);
            } else {
                this.setText("");
            }
            this.setIcon(this.getIcon(value));
            this.setToolTipText(this.getStringToolTip(value));
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            return this;
        }
    }

    public static class ListModelWrapper<T>
    implements ComboBoxModel<T> {
        private ListModel<T> m_ListModel;
        private boolean m_ListResortStarted;
        private T m_SelectedElement;
        protected EventListenerList m_ListenerList;
        private final Object m_SyncEventListeners = new Object();

        public ListModelWrapper(ListModel<T> p_ListModel) {
            this.initMembers();
            this.m_ListModel = p_ListModel;
            this.m_ListModel.addListModelWrapper(this);
        }

        private void initMembers() {
            this.m_ListResortStarted = false;
            this.m_SelectedElement = null;
            this.m_ListenerList = new EventListenerList();
        }

        public void close() {
            if (this.m_ListModel != null) {
                this.m_ListModel.removeListModelWrapper(this);
            }
            this.m_SelectedElement = null;
            this.clearListDataListeners();
        }

        public ListModel<T> getListModel() {
            return this.m_ListModel;
        }

        public void setGetSortStringMethod(Class<T> p_Class, String p_MethodName, boolean p_IgnoreCase) {
            ListModel<T> o_ListModel = this.m_ListModel;
            if (o_ListModel == null) {
                return;
            }
            o_ListModel.setGetSortStringMethod(p_Class, p_MethodName, p_IgnoreCase);
        }

        public void setSortComparator(Comparator<T> p_Comparator) {
            ListModel<T> o_ListModel = this.m_ListModel;
            if (o_ListModel == null) {
                return;
            }
            o_ListModel.setSortComparator(p_Comparator);
        }

        public boolean add(T p_Element) {
            ListModel<T> o_ListModel = this.m_ListModel;
            if (o_ListModel == null) {
                return false;
            }
            return o_ListModel.add(p_Element);
        }

        public void addElement(T p_Element) {
            ListModel<T> o_ListModel = this.m_ListModel;
            if (o_ListModel == null) {
                return;
            }
            o_ListModel.addElement(p_Element);
        }

        public boolean remove(T p_Element) {
            ListModel<T> o_ListModel = this.m_ListModel;
            if (o_ListModel == null) {
                return false;
            }
            return o_ListModel.remove(p_Element);
        }

        public void removeElement(Object p_Element) {
            ListModel<T> o_ListModel = this.m_ListModel;
            if (o_ListModel == null) {
                return;
            }
            o_ListModel.removeElement(p_Element);
        }

        public void clear() {
            ListModel<T> o_ListModel = this.m_ListModel;
            if (o_ListModel == null) {
                return;
            }
            o_ListModel.clear();
        }

        @Override
        public T getSelectedItem() {
            ListModel<T> o_ListModel = this.m_ListModel;
            if (o_ListModel == null) {
                return null;
            }
            return this.m_SelectedElement;
        }

        @Override
        public void setSelectedItem(Object p_Element) {
            ListModel<T> o_ListModel = this.m_ListModel;
            if (o_ListModel == null) {
                return;
            }
            if (this.m_SelectedElement == p_Element) {
                return;
            }
            try {
                this.m_SelectedElement = p_Element;
                this.fireContentsChanged(this, -1, -1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public int size() {
            ListModel<T> o_ListModel = this.m_ListModel;
            if (o_ListModel == null) {
                return 0;
            }
            return o_ListModel.size();
        }

        public T get(int p_Index) {
            ListModel<T> o_ListModel = this.m_ListModel;
            if (o_ListModel == null) {
                return null;
            }
            return o_ListModel.get(p_Index);
        }

        public boolean contains(T p_Element) {
            ListModel<T> o_ListModel = this.m_ListModel;
            if (o_ListModel == null) {
                return false;
            }
            return o_ListModel.contains(p_Element);
        }

        public int indexOf(T p_Element) {
            ListModel<T> o_ListModel = this.m_ListModel;
            if (o_ListModel == null) {
                return -1;
            }
            return o_ListModel.indexOf(p_Element);
        }

        public void changedElement(T p_Element) {
            ListModel<T> o_ListModel = this.m_ListModel;
            if (o_ListModel == null) {
                return;
            }
            o_ListModel.changedElement(p_Element);
        }

        public T findBySortMethod(String p_SearchString) {
            ListModel<T> o_ListModel = this.m_ListModel;
            if (o_ListModel == null) {
                return null;
            }
            return o_ListModel.findBySortMethod(p_SearchString);
        }

        public T findByName(String p_SearchNameString) {
            ListModel<T> o_ListModel = this.m_ListModel;
            if (o_ListModel == null) {
                return null;
            }
            return o_ListModel.findByName(p_SearchNameString);
        }

        public void filterByName(String p_Filter) {
            ListModel<T> o_ListModel = this.m_ListModel;
            if (o_ListModel == null) {
                return;
            }
            o_ListModel.filterByName(p_Filter);
        }

        public void clearFilterByName() {
            ListModel<T> o_ListModel = this.m_ListModel;
            if (o_ListModel == null) {
                return;
            }
            o_ListModel.clearFilterByName();
        }

        public void removeElementsAll() {
            ListModel<T> o_ListModel = this.m_ListModel;
            if (o_ListModel == null) {
                return;
            }
            o_ListModel.clear();
        }

        @Override
        public int getSize() {
            ListModel<T> o_ListModel = this.m_ListModel;
            if (o_ListModel == null) {
                return 0;
            }
            return o_ListModel.getSize();
        }

        @Override
        public T getElementAt(int index) {
            ListModel<T> o_ListModel = this.m_ListModel;
            if (o_ListModel == null) {
                return null;
            }
            return o_ListModel.getElementAt(index);
        }

        public int getIndexOf(T anObject) {
            ListModel<T> o_ListModel = this.m_ListModel;
            if (o_ListModel == null) {
                return -1;
            }
            return o_ListModel.getIndexOf(anObject);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addListDataListener(ListDataListener l) {
            ListModel<T> o_ListModel = this.m_ListModel;
            if (o_ListModel == null) {
                return;
            }
            Object object = this.m_SyncEventListeners;
            synchronized (object) {
                this.m_ListenerList.add(ListDataListener.class, l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeListDataListener(ListDataListener l) {
            ListModel<T> o_ListModel = this.m_ListModel;
            if (o_ListModel == null) {
                return;
            }
            Object object = this.m_SyncEventListeners;
            synchronized (object) {
                this.m_ListenerList.remove(ListDataListener.class, l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ListDataListener[] getListDataListeners() {
            Object object = this.m_SyncEventListeners;
            synchronized (object) {
                return (ListDataListener[])this.m_ListenerList.getListeners(ListDataListener.class);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clearListDataListeners() {
            Object object = this.m_SyncEventListeners;
            synchronized (object) {
                Object[] o_ListenerList = this.m_ListenerList.getListenerList();
                for (int intListener = o_ListenerList.length - 1; intListener >= 0; --intListener) {
                    Object o_Object = o_ListenerList[intListener];
                    if (!(o_Object instanceof ListDataListener)) continue;
                    this.removeListDataListener((ListDataListener)o_Object);
                }
            }
        }

        public void eventListResort(boolean p_ResortStarted) {
            this.m_ListResortStarted = p_ResortStarted;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void fireContentsChanged(Object source, int index0, int index1) {
            Object[] listenersCopy;
            ListDataEvent e = null;
            Object object = this.m_SyncEventListeners;
            synchronized (object) {
                Object[] listeners = this.m_ListenerList.getListenerList();
                listenersCopy = new Object[listeners.length];
                System.arraycopy(listeners, 0, listenersCopy, 0, listeners.length);
            }
            for (int i = listenersCopy.length - 2; i >= 0; i -= 2) {
                if (listenersCopy[i] != ListDataListener.class) continue;
                if (e == null) {
                    e = new ListDataEvent(source, 0, index0, index1);
                }
                ((ListDataListener)listenersCopy[i + 1]).contentsChanged(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void fireIntervalAdded(Object source, int index0, int index1) {
            Object[] listenersCopy;
            ListDataEvent e = null;
            ListModel<T> o_ListModel = this.m_ListModel;
            Object object = this.m_SyncEventListeners;
            synchronized (object) {
                Object[] listeners = this.m_ListenerList.getListenerList();
                listenersCopy = new Object[listeners.length];
                System.arraycopy(listeners, 0, listenersCopy, 0, listeners.length);
            }
            if (o_ListModel != null && o_ListModel.getSize() == 1) {
                this.setSelectedItem(o_ListModel.getElementAt(0));
            }
            if (this.m_ListResortStarted) {
                this.setSelectedItem(this.m_SelectedElement);
            }
            for (int i = listenersCopy.length - 2; i >= 0; i -= 2) {
                if (listenersCopy[i] != ListDataListener.class) continue;
                if (e == null) {
                    e = new ListDataEvent(source, 1, index0, index1);
                }
                ((ListDataListener)listenersCopy[i + 1]).intervalAdded(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void fireIntervalRemoved(Object source, int index0, int index1) {
            Object[] listenersCopy;
            ListDataEvent e = null;
            Object object = this.m_SyncEventListeners;
            synchronized (object) {
                Object[] listeners = this.m_ListenerList.getListenerList();
                listenersCopy = new Object[listeners.length];
                System.arraycopy(listeners, 0, listenersCopy, 0, listeners.length);
            }
            ListModel<T> o_ListModel = this.m_ListModel;
            boolean boolSelectedFound = false;
            if (o_ListModel != null) {
                for (int intElement = 0; intElement <= o_ListModel.getSize(); ++intElement) {
                    T o_Element = o_ListModel.getElementAt(intElement);
                    if (o_Element != this.m_SelectedElement) continue;
                    boolSelectedFound = true;
                    break;
                }
                if (!boolSelectedFound && !this.m_ListResortStarted) {
                    if (o_ListModel.getSize() <= 0) {
                        this.setSelectedItem(null);
                    } else {
                        this.setSelectedItem(o_ListModel.getElementAt(0));
                    }
                }
            }
            for (int i = listenersCopy.length - 2; i >= 0; i -= 2) {
                if (listenersCopy[i] != ListDataListener.class) continue;
                if (e == null) {
                    e = new ListDataEvent(source, 2, index0, index1);
                }
                ((ListDataListener)listenersCopy[i + 1]).intervalRemoved(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T extends EventListener> T[] getListeners(Class<T> listenerType) {
            Object object = this.m_SyncEventListeners;
            synchronized (object) {
                return this.m_ListenerList.getListeners(listenerType);
            }
        }
    }

    public static class ListModel<T>
    extends DefaultComboBoxModel<T>
    implements PropertyChangeListener {
        private TableAndListModel<T> m_TableAndListModel;
        private ArrayList<T> m_Elements;
        private ArrayList<T> m_Elements_FilteredNot;
        private ArrayList<T> m_ElementsTemp;
        protected EventListenerList m_ListenerList;
        protected boolean m_UsePropertyChange;
        protected ArrayList<ListModelWrapper<T>> m_ListModelWrappers;
        private boolean m_AllowNullElement;
        private Method m_GetSortStringMethod;
        private boolean m_SortCompare_IgnoreCase;
        private Method m_GetNameMethod;
        private Comparator<T> m_SortComparator;
        private final Object m_SyncElements = new Object();
        private final Object m_SyncEventListeners = new Object();
        private final Object m_SyncWrappers = new Object();

        public ListModel(boolean p_AllowNullElement) {
            this.initMembers();
            this.m_AllowNullElement = p_AllowNullElement;
        }

        public ListModel(boolean p_AllowNullElement, boolean p_UsePropertyChange) {
            this.initMembers();
            this.m_AllowNullElement = p_AllowNullElement;
            this.m_UsePropertyChange = p_UsePropertyChange;
        }

        public ListModel(TableAndListModel<T> p_TableAndListModel) {
            this.initMembers();
            this.m_TableAndListModel = p_TableAndListModel;
            this.m_AllowNullElement = p_TableAndListModel.getAllowNull();
        }

        private void initMembers() {
            this.m_TableAndListModel = null;
            this.m_Elements = new ArrayList();
            this.m_Elements_FilteredNot = new ArrayList();
            this.m_ElementsTemp = new ArrayList();
            this.m_AllowNullElement = false;
            this.m_GetSortStringMethod = null;
            this.m_SortCompare_IgnoreCase = true;
            this.m_GetNameMethod = null;
            this.m_SortComparator = null;
            this.m_ListenerList = new EventListenerList();
            this.m_UsePropertyChange = false;
            this.m_ListModelWrappers = new ArrayList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            this.clearListDataListeners();
            Object object = this.m_SyncWrappers;
            synchronized (object) {
                for (int intWrapper = this.m_ListModelWrappers.size() - 1; intWrapper >= 0; --intWrapper) {
                    ListModelWrapper<T> o_ListModelWrapper = this.m_ListModelWrappers.get(intWrapper);
                    this.removeListModelWrapper(o_ListModelWrapper);
                }
            }
            this.clear();
        }

        public void setAllowNull(boolean p_AllowNullElement) {
            this.m_AllowNullElement = p_AllowNullElement;
        }

        public boolean getAllowNull() {
            return this.m_AllowNullElement;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setGetSortStringMethod(Class<T> p_Class, String p_MethodName, boolean p_IgnoreCase) {
            Method o_Method;
            if (p_Class == null || p_MethodName == null) {
                this.m_GetSortStringMethod = null;
            }
            try {
                o_Method = p_Class.getMethod(p_MethodName, new Class[0]);
                if (o_Method.getReturnType() != String.class) {
                    o_Method = null;
                }
            }
            catch (Exception e) {
                o_Method = null;
            }
            this.m_GetSortStringMethod = o_Method;
            this.m_SortCompare_IgnoreCase = p_IgnoreCase;
            if (this.m_GetSortStringMethod != null && this.m_SortComparator == null) {
                ArrayList<T> o_Elements;
                Object object = this.m_SyncElements;
                synchronized (object) {
                    o_Elements = new ArrayList<T>(this.m_Elements.size());
                    o_Elements.addAll(this.m_Elements);
                }
                for (int intElement = 0; intElement < o_Elements.size(); ++intElement) {
                    Object o_Element = o_Elements.get(intElement);
                    this.resort(o_Element);
                }
            }
        }

        public Method getSortStringMethod() {
            return this.m_GetSortStringMethod;
        }

        public String getSortStringMethodName() {
            if (this.m_GetSortStringMethod == null) {
                return "";
            }
            return this.m_GetSortStringMethod.getName();
        }

        public String getSortString(T p_Element) {
            if (p_Element == null) {
                if (this.m_AllowNullElement) {
                    return "";
                }
                return "";
            }
            if (this.m_GetSortStringMethod == null) {
                return "";
            }
            try {
                return (String)this.m_GetSortStringMethod.invoke(p_Element, new Object[0]);
            }
            catch (Exception e) {
                return "";
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public T findBySortMethod(String p_SearchString) {
            if (p_SearchString == null) {
                return null;
            }
            if (p_SearchString.length() <= 0) {
                return null;
            }
            Object object = this.m_SyncElements;
            synchronized (object) {
                for (int intElement = 0; intElement < this.m_Elements.size(); ++intElement) {
                    T o_Element = this.m_Elements.get(intElement);
                    String stringSortString = this.getSortString(o_Element);
                    if (stringSortString == null || stringSortString.length() < p_SearchString.length() || !stringSortString.toLowerCase().contains(p_SearchString.toLowerCase())) continue;
                    return o_Element;
                }
            }
            return null;
        }

        public void setGetNameMethod(Class p_Class, String p_GetNameMethodeName) {
            Method o_Method;
            if (p_Class == null || p_GetNameMethodeName == null) {
                this.m_GetNameMethod = null;
            }
            try {
                o_Method = p_Class.getMethod(p_GetNameMethodeName, new Class[0]);
                if (o_Method.getReturnType() != String.class) {
                    o_Method = null;
                }
            }
            catch (Exception e) {
                o_Method = null;
            }
            this.m_GetNameMethod = o_Method;
        }

        public Method getNameMethode() {
            return this.m_GetNameMethod;
        }

        public String getNameMethodeName() {
            if (this.m_GetNameMethod != null) {
                return this.m_GetNameMethod.getName();
            }
            return "";
        }

        public String getNameString(T p_Element) {
            if (p_Element == null) {
                if (this.m_AllowNullElement) {
                    return "";
                }
                return "";
            }
            if (this.m_GetNameMethod == null) {
                return "";
            }
            try {
                return (String)this.m_GetNameMethod.invoke(p_Element, new Object[0]);
            }
            catch (Exception e) {
                return "";
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public T findByName(String p_SearchNameString) {
            if (p_SearchNameString == null) {
                return null;
            }
            if (p_SearchNameString.length() <= 0) {
                return null;
            }
            String stringSearchName_LowerCase = p_SearchNameString.toLowerCase();
            Object object = this.m_SyncElements;
            synchronized (object) {
                for (int intElement = 0; intElement < this.m_Elements.size(); ++intElement) {
                    T o_Element = this.m_Elements.get(intElement);
                    String stringName = this.getNameString(o_Element);
                    if (stringName == null || stringName.length() < stringSearchName_LowerCase.length() || !stringName.toLowerCase().contains(stringSearchName_LowerCase)) continue;
                    return o_Element;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setSortComparator(Comparator<T> p_Comparator) {
            this.m_SortComparator = p_Comparator;
            if (this.m_SortComparator != null) {
                ArrayList<T> o_Elements;
                Object object = this.m_SyncElements;
                synchronized (object) {
                    o_Elements = new ArrayList<T>(this.m_Elements.size());
                    o_Elements.addAll(this.m_Elements);
                }
                for (int intElement = 0; intElement < o_Elements.size(); ++intElement) {
                    Object o_Element = o_Elements.get(intElement);
                    this.resort(o_Element);
                }
            }
        }

        public Comparator<T> getSortComparator() {
            return this.m_SortComparator;
        }

        protected void call_AddPropertyChangeListener(T p_Element) {
            if (p_Element == null) {
                return;
            }
            Method o_Method = null;
            try {
                o_Method = p_Element.getClass().getDeclaredMethod("addPropertyChangeListener", PropertyChangeListener.class);
                if (o_Method != null) {
                    o_Method.invoke(p_Element, this);
                }
            }
            catch (Exception e) {
                o_Method = null;
            }
        }

        protected void call_RemovePropertyChangeListener(T p_Element) {
            if (p_Element == null) {
                return;
            }
            Method o_Method = null;
            try {
                o_Method = p_Element.getClass().getDeclaredMethod("removePropertyChangeListener", PropertyChangeListener.class);
                if (o_Method != null) {
                    o_Method.invoke(p_Element, this);
                }
            }
            catch (Exception e) {
                o_Method = null;
            }
        }

        public void clear() {
            TableAndListModel<T> o_TableAndListModel = this.m_TableAndListModel;
            if (o_TableAndListModel != null) {
                o_TableAndListModel.clear();
            } else {
                this.clear_Internal();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear_Internal() {
            Object object = this.m_SyncElements;
            synchronized (object) {
                if (this.m_UsePropertyChange) {
                    for (int intElement = 0; intElement < this.m_Elements.size(); ++intElement) {
                        T o_Element = this.m_Elements.get(intElement);
                        if (o_Element == null) continue;
                        this.call_RemovePropertyChangeListener(o_Element);
                    }
                }
                this.m_Elements.clear();
                if (EventQueue.isDispatchThread()) {
                    this.removeAllElements();
                } else {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            this.removeAllElements();
                        }
                    });
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean add(T p_Element) {
            boolean boolAdded = true;
            Object object = this.m_SyncElements;
            synchronized (object) {
                if (p_Element == null) {
                    if (this.m_AllowNullElement) {
                        if (this.m_Elements.contains(p_Element)) {
                            boolAdded = false;
                        }
                        if (boolAdded && this.m_Elements_FilteredNot.contains(p_Element)) {
                            boolAdded = false;
                        }
                    } else {
                        boolAdded = false;
                    }
                } else {
                    if (this.m_Elements.contains(p_Element)) {
                        boolAdded = false;
                    }
                    if (boolAdded && this.m_Elements_FilteredNot.contains(p_Element)) {
                        boolAdded = false;
                    }
                }
            }
            this.addElement(p_Element);
            return boolAdded;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean add(int p_Index, T p_Element) {
            boolean boolAdded = true;
            Object object = this.m_SyncElements;
            synchronized (object) {
                if (p_Element == null) {
                    if (this.m_AllowNullElement) {
                        if (this.m_Elements.contains(p_Element)) {
                            boolAdded = false;
                        }
                        if (boolAdded && this.m_Elements_FilteredNot.contains(p_Element)) {
                            boolAdded = false;
                        }
                    } else {
                        boolAdded = false;
                    }
                } else {
                    if (this.m_Elements.contains(p_Element)) {
                        boolAdded = false;
                    }
                    if (boolAdded && this.m_Elements_FilteredNot.contains(p_Element)) {
                        boolAdded = false;
                    }
                }
            }
            this.addElement(p_Index, p_Element);
            return boolAdded;
        }

        @Override
        public void addElement(T p_Element) {
            TableAndListModel<T> o_TableAndListModel = this.m_TableAndListModel;
            if (p_Element == null) {
                if (this.m_AllowNullElement) {
                    this.addElement_Internal(p_Element);
                }
                if (o_TableAndListModel != null && o_TableAndListModel.getAllowNull()) {
                    o_TableAndListModel.addElement(p_Element);
                }
                return;
            }
            if (o_TableAndListModel != null) {
                o_TableAndListModel.addElement(p_Element);
            } else {
                this.addElement_Internal(p_Element);
            }
        }

        public void addElement(int p_Index, T p_Element) {
            TableAndListModel<T> o_TableAndListModel = this.m_TableAndListModel;
            if (p_Element == null) {
                if (this.m_AllowNullElement) {
                    this.addElement_Internal(p_Index, p_Element);
                }
                if (o_TableAndListModel != null && o_TableAndListModel.getAllowNull()) {
                    o_TableAndListModel.addElement(p_Element);
                }
                return;
            }
            this.addElement_Internal(p_Index, p_Element);
            if (o_TableAndListModel != null) {
                o_TableAndListModel.addElement(p_Element);
            }
        }

        public void addElement_Internal(T p_Element) {
            if (!this.m_AllowNullElement && p_Element == null) {
                return;
            }
            this.addSorted_Internal(p_Element);
        }

        public void addElement_Internal(int p_Index, T p_Element) {
            if (!this.m_AllowNullElement && p_Element == null) {
                return;
            }
            this.add_Internal(p_Index, p_Element);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean remove(T p_Element) {
            boolean boolContains = false;
            Object object = this.m_SyncElements;
            synchronized (object) {
                if (p_Element == null) {
                    if (this.m_AllowNullElement) {
                        Object object2 = this.m_SyncElements;
                        synchronized (object2) {
                            boolContains = this.m_Elements.contains(p_Element);
                            if (!boolContains) {
                                boolContains = this.m_Elements_FilteredNot.contains(p_Element);
                            }
                        }
                    }
                } else {
                    Object object3 = this.m_SyncElements;
                    synchronized (object3) {
                        boolContains = this.m_Elements.contains(p_Element);
                        if (!boolContains) {
                            boolContains = this.m_Elements_FilteredNot.contains(p_Element);
                        }
                    }
                }
            }
            this.removeElement(p_Element);
            return boolContains;
        }

        @Override
        public void removeElement(Object p_Element) {
            TableAndListModel<Object> o_TableAndListModel = this.m_TableAndListModel;
            if (p_Element == null) {
                if (this.m_AllowNullElement) {
                    this.removeElement_Internal(p_Element);
                }
                if (o_TableAndListModel != null && o_TableAndListModel.getAllowNull()) {
                    o_TableAndListModel.removeElement(p_Element);
                }
                return;
            }
            if (o_TableAndListModel != null) {
                o_TableAndListModel.removeElement(p_Element);
            } else {
                this.removeElement_Internal(p_Element);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeElement_Internal(final T p_Element) {
            if (!this.m_AllowNullElement && p_Element == null) {
                return;
            }
            Object object = this.m_SyncElements;
            synchronized (object) {
                int intIndex = this.m_Elements.indexOf(p_Element);
                if (intIndex < 0) {
                    this.m_Elements_FilteredNot.remove(p_Element);
                    return;
                }
                this.m_Elements.remove(intIndex);
                if (this.m_UsePropertyChange) {
                    this.call_RemovePropertyChangeListener(p_Element);
                }
                if (EventQueue.isDispatchThread()) {
                    this.eventRemoveElement(p_Element);
                } else {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            this.eventRemoveElement(p_Element);
                        }
                    });
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeElement_Filtered(final T p_Element) {
            if (!this.m_AllowNullElement && p_Element == null) {
                return;
            }
            Object object = this.m_SyncElements;
            synchronized (object) {
                int intIndex = this.m_Elements.indexOf(p_Element);
                if (intIndex < 0) {
                    return;
                }
                this.m_Elements.remove(intIndex);
                if (this.m_UsePropertyChange) {
                    this.call_RemovePropertyChangeListener(p_Element);
                }
                if (EventQueue.isDispatchThread()) {
                    this.eventRemoveElement(p_Element);
                } else {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            this.eventRemoveElement(p_Element);
                        }
                    });
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void eventRemoveElement(Object p_Element) {
            if (p_Element == null) {
                return;
            }
            Object object = this.m_SyncElements;
            synchronized (object) {
                super.removeElement(p_Element);
            }
        }

        public void changedElement(T p_Element) {
            if (p_Element == null) {
                return;
            }
            TableAndListModel<T> o_TableAndListModel = this.m_TableAndListModel;
            if (o_TableAndListModel != null) {
                o_TableAndListModel.changedElement(p_Element);
            } else {
                this.changedElement_Internal(p_Element);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void changedElement_Internal(final T p_Element) {
            if (p_Element == null) {
                return;
            }
            Object object = this.m_SyncElements;
            synchronized (object) {
                int intIndex = this.m_Elements.indexOf(p_Element);
                if (intIndex < 0) {
                    return;
                }
            }
            if (this.resort(p_Element)) {
                return;
            }
            if (EventQueue.isDispatchThread()) {
                this.eventChangedElement(p_Element);
            } else {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        this.eventChangedElement(p_Element);
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void eventChangedElement(T p_Element) {
            if (p_Element == null) {
                return;
            }
            Object object = this.m_SyncElements;
            synchronized (object) {
                int intIndex = this.getIndexOf(p_Element);
                if (intIndex < 0) {
                    return;
                }
                this.fireContentsChanged(this, intIndex, intIndex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addSorted_Internal(final T p_Element) {
            if (!this.m_AllowNullElement && p_Element == null) {
                return;
            }
            String stringSortNewElement = "";
            Object object = this.m_SyncElements;
            synchronized (object) {
                int intElement;
                if (this.m_Elements.contains(p_Element)) {
                    return;
                }
                if (this.m_Elements_FilteredNot.contains(p_Element)) {
                    return;
                }
                if (this.m_GetSortStringMethod == null && this.m_SortComparator == null || p_Element == null) {
                    if (p_Element == null) {
                        this.m_Elements.add(0, p_Element);
                        intElement = 0;
                    } else {
                        this.m_Elements.add(p_Element);
                        if (this.m_UsePropertyChange) {
                            this.call_AddPropertyChangeListener(p_Element);
                        }
                        intElement = this.m_Elements.indexOf(p_Element);
                    }
                } else {
                    stringSortNewElement = this.getSortString(p_Element);
                    if (this.m_SortComparator != null) {
                        T o_Element;
                        for (intElement = 0; intElement < this.m_Elements.size() && ((o_Element = this.m_Elements.get(intElement)) == null || this.m_SortComparator.compare(o_Element, p_Element) < 0); ++intElement) {
                        }
                        this.m_Elements.add(intElement, p_Element);
                        if (this.m_UsePropertyChange) {
                            this.call_AddPropertyChangeListener(p_Element);
                        }
                    } else {
                        for (intElement = 0; intElement < this.m_Elements.size(); ++intElement) {
                            T o_Element = this.m_Elements.get(intElement);
                            if (o_Element == null) continue;
                            String stringSortExisting = this.getSortString(o_Element);
                            if (!(this.m_SortCompare_IgnoreCase ? stringSortExisting.compareToIgnoreCase(stringSortNewElement) < 0 : stringSortExisting.compareTo(stringSortNewElement) < 0)) break;
                        }
                        this.m_Elements.add(intElement, p_Element);
                        if (this.m_UsePropertyChange) {
                            this.call_AddPropertyChangeListener(p_Element);
                        }
                    }
                }
                if (EventQueue.isDispatchThread()) {
                    if (intElement > this.getSize()) {
                        intElement = this.getSize();
                    }
                    super.insertElementAt(p_Element, intElement);
                } else {
                    final int intElementIndex = intElement;
                    EventQueue.invokeLater(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            int intIndex = intElementIndex;
                            Object object = m_SyncElements;
                            synchronized (object) {
                                if (intIndex < 0) {
                                    intIndex = 0;
                                }
                                if (intIndex > this.getSize()) {
                                    intIndex = this.getSize();
                                }
                                this.insertElementAt(p_Element, intIndex);
                            }
                        }
                    });
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add_Internal(int p_Index, final T p_Element) {
            if (!this.m_AllowNullElement && p_Element == null) {
                return;
            }
            Object object = this.m_SyncElements;
            synchronized (object) {
                if (this.m_Elements.contains(p_Element)) {
                    return;
                }
                if (this.m_Elements_FilteredNot.contains(p_Element)) {
                    return;
                }
                if (p_Index < 0) {
                    p_Index = 0;
                }
                if (p_Index > this.m_Elements.size()) {
                    p_Index = this.m_Elements.size();
                }
                this.m_Elements.add(p_Index, p_Element);
                if (EventQueue.isDispatchThread()) {
                    if (p_Index > this.getSize()) {
                        p_Index = this.getSize();
                    }
                    super.insertElementAt(p_Element, p_Index);
                } else {
                    final int intElementIndex = p_Index;
                    EventQueue.invokeLater(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            int intIndex = intElementIndex;
                            Object object = m_SyncElements;
                            synchronized (object) {
                                if (intIndex < 0) {
                                    intIndex = 0;
                                }
                                if (intIndex > this.getSize()) {
                                    intIndex = this.getSize();
                                }
                                this.insertElementAt(p_Element, intIndex);
                            }
                        }
                    });
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean resort(final T p_Element) {
            boolean boolWasSelected;
            if (p_Element == null && !this.m_AllowNullElement) {
                return false;
            }
            Object o_Element_Pre = null;
            T o_Element_Post = null;
            boolean boolShouldResort = false;
            if (this.m_GetSortStringMethod == null && this.m_SortComparator == null) {
                return false;
            }
            Object object = this.m_SyncElements;
            synchronized (object) {
                int intIndex = this.m_Elements.indexOf(p_Element);
                if (intIndex < 0) {
                    return false;
                }
                String stringSortElement = this.getSortString(p_Element);
                if (intIndex >= 1) {
                    o_Element_Pre = this.m_Elements.get(intIndex - 1);
                    String stringSortElement_Pre = this.getSortString(o_Element_Pre);
                    if (this.m_SortComparator != null) {
                        if (this.m_SortComparator.compare(o_Element_Pre, p_Element) > 0) {
                            boolShouldResort = true;
                        }
                    } else if (!boolShouldResort && this.m_GetSortStringMethod != null) {
                        if (this.m_SortCompare_IgnoreCase) {
                            if (stringSortElement_Pre.compareToIgnoreCase(stringSortElement) > 0) {
                                boolShouldResort = true;
                            }
                        } else if (stringSortElement_Pre.compareTo(stringSortElement) > 0) {
                            boolShouldResort = true;
                        }
                    }
                }
                if (intIndex < this.m_Elements.size() - 1) {
                    o_Element_Post = this.m_Elements.get(intIndex + 1);
                    String stringSortElement_Post = this.getSortString(o_Element_Post);
                    if (this.m_SortCompare_IgnoreCase) {
                        if (stringSortElement_Post.compareToIgnoreCase(stringSortElement) < 0) {
                            boolShouldResort = true;
                        }
                    } else if (stringSortElement_Post.compareTo(stringSortElement) < 0) {
                        boolShouldResort = true;
                    }
                }
                if (!boolShouldResort) {
                    return false;
                }
                boolWasSelected = p_Element == this.getSelectedItem();
            }
            this.notifyResort(true);
            this.removeElement_Internal(p_Element);
            this.addElement_Internal(p_Element);
            this.notifyResort(false);
            if (EventQueue.isDispatchThread()) {
                if (boolWasSelected) {
                    this.setSelectedItem(p_Element);
                }
            } else {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (boolWasSelected) {
                            this.setSelectedItem(p_Element);
                        }
                    }
                });
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int size() {
            Object object = this.m_SyncElements;
            synchronized (object) {
                return this.m_Elements.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int size_FilteredNot() {
            Object object = this.m_SyncElements;
            synchronized (object) {
                return this.m_Elements_FilteredNot.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ArrayList<T> getElementArrayList() {
            Object object = this.m_SyncElements;
            synchronized (object) {
                return this.m_Elements;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ArrayList<T> getElementArrayList_Safe() {
            Object object = this.m_SyncElements;
            synchronized (object) {
                ArrayList<T> o_ArrayList = new ArrayList<T>(this.m_Elements.size());
                o_ArrayList.addAll(this.m_Elements);
                return o_ArrayList;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public T get(int p_Index) {
            if (p_Index < 0) {
                return null;
            }
            Object object = this.m_SyncElements;
            synchronized (object) {
                if (p_Index >= this.m_Elements.size()) {
                    return null;
                }
                return this.m_Elements.get(p_Index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public T get_FilteredNot(int p_Index) {
            if (p_Index < 0) {
                return null;
            }
            Object object = this.m_SyncElements;
            synchronized (object) {
                if (p_Index >= this.m_Elements_FilteredNot.size()) {
                    return null;
                }
                return this.m_Elements_FilteredNot.get(p_Index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean contains(T p_Element) {
            Object object = this.m_SyncElements;
            synchronized (object) {
                return this.m_Elements.contains(p_Element);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean contains_FilteredNot(T p_Element) {
            Object object = this.m_SyncElements;
            synchronized (object) {
                return this.m_Elements_FilteredNot.contains(p_Element);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int indexOf(T p_Element) {
            Object object = this.m_SyncElements;
            synchronized (object) {
                return this.m_Elements.indexOf(p_Element);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clearFilterByName() {
            Object object = this.m_SyncElements;
            synchronized (object) {
                this.m_ElementsTemp.clear();
                this.m_ElementsTemp.addAll(this.m_Elements_FilteredNot);
                this.m_Elements_FilteredNot.clear();
            }
            for (int intElement = 0; intElement < this.m_ElementsTemp.size(); ++intElement) {
                T o_Element = this.m_ElementsTemp.get(intElement);
                this.addElement_Internal(o_Element);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void filterByName(String p_Filter) {
            int intElement;
            Object o_Element;
            ArrayList<T> o_ElementsToAdd = new ArrayList<T>();
            if (this.m_GetNameMethod == null) {
                return;
            }
            if (p_Filter == null || p_Filter.length() <= 0) {
                this.clearFilterByName();
                return;
            }
            String stringFilterLowerCase = p_Filter.toLowerCase();
            Object object = this.m_SyncElements;
            synchronized (object) {
                String stringName;
                int intElement2;
                this.m_ElementsTemp.clear();
                for (intElement2 = 0; intElement2 < this.m_Elements.size(); ++intElement2) {
                    o_Element = this.m_Elements.get(intElement2);
                    if (o_Element == null || (stringName = this.getNameString(o_Element)).toLowerCase().contains(stringFilterLowerCase)) continue;
                    this.m_ElementsTemp.add(o_Element);
                }
                for (intElement2 = this.m_Elements_FilteredNot.size() - 1; intElement2 >= 0; --intElement2) {
                    o_Element = this.m_Elements_FilteredNot.get(intElement2);
                    stringName = this.getNameString(o_Element);
                    if (!stringName.toLowerCase().contains(stringFilterLowerCase)) {
                        this.m_ElementsTemp.add(o_Element);
                        continue;
                    }
                    o_ElementsToAdd.add(o_Element);
                    this.m_Elements_FilteredNot.remove(o_Element);
                }
                this.m_Elements_FilteredNot.addAll(this.m_ElementsTemp);
            }
            for (intElement = 0; intElement < this.m_ElementsTemp.size(); ++intElement) {
                o_Element = this.m_ElementsTemp.get(intElement);
                this.removeElement_Filtered(o_Element);
            }
            for (intElement = 0; intElement < o_ElementsToAdd.size(); ++intElement) {
                o_Element = o_ElementsToAdd.get(intElement);
                this.addElement_Internal(o_Element);
            }
        }

        public ListModelWrapper<T> createListModelWrapper() {
            ListModelWrapper o_ListModelWrapper = new ListModelWrapper(this);
            return o_ListModelWrapper;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addListModelWrapper(ListModelWrapper<T> p_ListModelWrapper) {
            if (p_ListModelWrapper == null) {
                return;
            }
            Object object = this.m_SyncWrappers;
            synchronized (object) {
                if (this.m_ListModelWrappers.contains(p_ListModelWrapper)) {
                    return;
                }
                this.m_ListModelWrappers.add(p_ListModelWrapper);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeListModelWrapper(ListModelWrapper p_ListModelWrapper) {
            if (p_ListModelWrapper == null) {
                return;
            }
            Object object = this.m_SyncWrappers;
            synchronized (object) {
                this.m_ListModelWrappers.remove(p_ListModelWrapper);
            }
        }

        @Override
        public int getSize() {
            return super.getSize();
        }

        @Override
        public T getElementAt(int p_Index) {
            return (T)super.getElementAt(p_Index);
        }

        @Override
        public int getIndexOf(Object p_Element) {
            return super.getIndexOf(p_Element);
        }

        @Override
        public void removeElementAt(int p_Index) {
            super.removeElementAt(p_Index);
        }

        @Override
        public void removeAllElements() {
            super.removeAllElements();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addListDataListener(ListDataListener l) {
            Object object = this.m_SyncEventListeners;
            synchronized (object) {
                this.m_ListenerList.add(ListDataListener.class, l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeListDataListener(ListDataListener l) {
            Object object = this.m_SyncEventListeners;
            synchronized (object) {
                this.m_ListenerList.remove(ListDataListener.class, l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clearListDataListeners() {
            Object object = this.m_SyncEventListeners;
            synchronized (object) {
                Object[] o_ListenerList = this.m_ListenerList.getListenerList();
                for (int intListener = o_ListenerList.length - 1; intListener >= 0; --intListener) {
                    Object o_Object = o_ListenerList[intListener];
                    if (!(o_Object instanceof ListDataListener)) continue;
                    this.removeListDataListener((ListDataListener)o_Object);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ListDataListener[] getListDataListeners() {
            Object object = this.m_SyncEventListeners;
            synchronized (object) {
                return (ListDataListener[])this.m_ListenerList.getListeners(ListDataListener.class);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void fireContentsChanged(Object source, int index0, int index1) {
            ArrayList<ListModelWrapper<T>> o_ListModelWrappers;
            Object[] listenersCopy;
            ListDataEvent e = null;
            Object object = this.m_SyncEventListeners;
            synchronized (object) {
                Object[] listeners = this.m_ListenerList.getListenerList();
                listenersCopy = new Object[listeners.length];
                System.arraycopy(listeners, 0, listenersCopy, 0, listeners.length);
            }
            for (int i = listenersCopy.length - 2; i >= 0; i -= 2) {
                if (listenersCopy[i] != ListDataListener.class) continue;
                if (e == null) {
                    e = new ListDataEvent(source, 0, index0, index1);
                }
                ((ListDataListener)listenersCopy[i + 1]).contentsChanged(e);
            }
            Object object2 = this.m_SyncWrappers;
            synchronized (object2) {
                o_ListModelWrappers = new ArrayList<ListModelWrapper<T>>(this.m_ListModelWrappers.size());
                o_ListModelWrappers.addAll(this.m_ListModelWrappers);
            }
            for (int intWrapper = 0; intWrapper < o_ListModelWrappers.size(); ++intWrapper) {
                ((ListModelWrapper)o_ListModelWrappers.get(intWrapper)).fireContentsChanged(source, index0, index1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void fireIntervalAdded(Object source, int index0, int index1) {
            ArrayList<ListModelWrapper<T>> o_ListModelWrappers;
            Object[] listenersCopy;
            ListDataEvent e = null;
            Object object = this.m_SyncEventListeners;
            synchronized (object) {
                Object[] listeners = this.m_ListenerList.getListenerList();
                listenersCopy = new Object[listeners.length];
                System.arraycopy(listeners, 0, listenersCopy, 0, listeners.length);
            }
            if (this.getSize() == 1) {
                this.setSelectedItem(this.getElementAt(0));
            }
            for (int i = listenersCopy.length - 2; i >= 0; i -= 2) {
                if (listenersCopy[i] != ListDataListener.class) continue;
                if (e == null) {
                    e = new ListDataEvent(source, 1, index0, index1);
                }
                ((ListDataListener)listenersCopy[i + 1]).intervalAdded(e);
            }
            Object object2 = this.m_SyncWrappers;
            synchronized (object2) {
                o_ListModelWrappers = new ArrayList<ListModelWrapper<T>>(this.m_ListModelWrappers.size());
                o_ListModelWrappers.addAll(this.m_ListModelWrappers);
            }
            for (int intWrapper = 0; intWrapper < o_ListModelWrappers.size(); ++intWrapper) {
                ((ListModelWrapper)o_ListModelWrappers.get(intWrapper)).fireIntervalAdded(source, index0, index1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void fireIntervalRemoved(Object source, int index0, int index1) {
            ArrayList<ListModelWrapper<T>> o_ListModelWrappers;
            Object[] listenersCopy;
            ListDataEvent e = null;
            Object object = this.m_SyncEventListeners;
            synchronized (object) {
                Object[] listeners = this.m_ListenerList.getListenerList();
                listenersCopy = new Object[listeners.length];
                System.arraycopy(listeners, 0, listenersCopy, 0, listeners.length);
            }
            boolean boolSelectedFound = false;
            for (int intElement = 0; intElement <= this.getSize(); ++intElement) {
                T o_Element = this.getElementAt(intElement);
                if (o_Element != this.getSelectedItem()) continue;
                boolSelectedFound = true;
                break;
            }
            if (!boolSelectedFound) {
                if (this.getSize() <= 0) {
                    this.setSelectedItem(null);
                } else {
                    this.setSelectedItem(this.getElementAt(0));
                }
            }
            for (int i = listenersCopy.length - 2; i >= 0; i -= 2) {
                if (listenersCopy[i] != ListDataListener.class) continue;
                if (e == null) {
                    e = new ListDataEvent(source, 2, index0, index1);
                }
                ((ListDataListener)listenersCopy[i + 1]).intervalRemoved(e);
            }
            Object object2 = this.m_SyncWrappers;
            synchronized (object2) {
                o_ListModelWrappers = new ArrayList<ListModelWrapper<T>>(this.m_ListModelWrappers.size());
                o_ListModelWrappers.addAll(this.m_ListModelWrappers);
            }
            for (int intWrapper = 0; intWrapper < o_ListModelWrappers.size(); ++intWrapper) {
                ((ListModelWrapper)o_ListModelWrappers.get(intWrapper)).fireIntervalRemoved(source, index0, index1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void notifyResort(boolean p_ResortStarted) {
            ArrayList<ListModelWrapper<T>> o_ListModelWrappers;
            Object object = this.m_SyncWrappers;
            synchronized (object) {
                o_ListModelWrappers = new ArrayList<ListModelWrapper<T>>(this.m_ListModelWrappers.size());
                o_ListModelWrappers.addAll(this.m_ListModelWrappers);
            }
            for (int intWrapper = 0; intWrapper < o_ListModelWrappers.size(); ++intWrapper) {
                ((ListModelWrapper)o_ListModelWrappers.get(intWrapper)).eventListResort(p_ResortStarted);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T extends EventListener> T[] getListeners(Class<T> listenerType) {
            Object object = this.m_SyncEventListeners;
            synchronized (object) {
                return this.m_ListenerList.getListeners(listenerType);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent p_PropertyChangeEvent) {
            try {
                Object o_Element = p_PropertyChangeEvent.getSource();
                this.changedElement_Internal(o_Element);
            }
            catch (Exception e) {
                return;
            }
        }
    }
}

