/*
 * Decompiled with CFR 0.152.
 */
package SocketManagementPackage;

import SocketManagementPackage.LiveDBSocketChannelManagement;
import SynchronizationPackage.LiveDBCloseSemaphore;
import java.util.ArrayList;

public class LiveDBAdminThread
implements Runnable {
    private Thread m_ExecuteThread;
    private ArrayList<Runnable> m_ArrayListRunnables;
    private final Object m_SyncAdminThread = new Object();
    private boolean m_AdminThreadExit = false;
    private LiveDBCloseSemaphore m_LiveDBCloseSemaphore = new LiveDBCloseSemaphore(this.getClass().getName());

    public LiveDBAdminThread() {
        this.m_ArrayListRunnables = new ArrayList();
        this.m_ExecuteThread = new Thread((Runnable)this, this.getClass().getName());
        this.m_ExecuteThread.start();
    }

    public void close() {
        if (Thread.currentThread() != this.m_ExecuteThread) {
            this.addRunnable(new Runnable(){

                @Override
                public void run() {
                    LiveDBAdminThread.this.close();
                }
            });
            Thread o_ExecuteThread = this.m_ExecuteThread;
            if (o_ExecuteThread != null) {
                try {
                    o_ExecuteThread.join();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return;
        }
        if (!this.m_LiveDBCloseSemaphore.enterCloseSection()) {
            return;
        }
        this.m_AdminThreadExit = true;
        this.m_ExecuteThread = null;
        this.m_LiveDBCloseSemaphore.leaveCloseSection();
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    public Thread getThread() {
        return this.m_ExecuteThread;
    }

    public void addRunnable(Runnable p_Runnable) {
        this.addRunnable(-1, p_Runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRunnable(int p_Index, Runnable p_Runnable) {
        if (p_Runnable == null) {
            return;
        }
        if (!this.m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        Object object = this.m_SyncAdminThread;
        synchronized (object) {
            if (this.m_ArrayListRunnables.contains(p_Runnable)) {
                this.m_LiveDBCloseSemaphore.leaveWorkerSection();
                return;
            }
            if (p_Index < 0 || p_Index >= this.m_ArrayListRunnables.size()) {
                this.m_ArrayListRunnables.add(p_Runnable);
            } else {
                this.m_ArrayListRunnables.add(p_Index, p_Runnable);
            }
            this.m_LiveDBCloseSemaphore.leaveWorkerSection();
            this.m_SyncAdminThread.notifyAll();
        }
    }

    private void excuteRunnable(Runnable p_Runnable) {
        if (p_Runnable == null) {
            return;
        }
        try {
            p_Runnable.run();
        }
        catch (Exception e) {
            LiveDBSocketChannelManagement.eventError(e, LiveDBSocketChannelManagement.ERROR_SYSTEMRUNJOB);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object;
        if (!this.m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        this.m_LiveDBCloseSemaphore.leaveWorkerSection();
        Runnable o_Runnable = null;
        while (!this.m_AdminThreadExit) {
            object = this.m_SyncAdminThread;
            synchronized (object) {
                try {
                    if (this.m_ArrayListRunnables.size() <= 0) {
                        this.m_SyncAdminThread.wait();
                    }
                    if (this.m_AdminThreadExit) {
                        break;
                    }
                    if (this.m_ArrayListRunnables.size() <= 0) {
                        continue;
                    }
                    o_Runnable = this.m_ArrayListRunnables.get(0);
                    this.m_ArrayListRunnables.remove(0);
                }
                catch (Exception e) {
                    System.out.println("AdminThread fetch next Runnable " + e.getMessage());
                }
            }
            if (o_Runnable != null) {
                this.excuteRunnable(o_Runnable);
            }
            o_Runnable = null;
        }
        object = this.m_SyncAdminThread;
        synchronized (object) {
            this.m_ArrayListRunnables.clear();
        }
    }
}

