/*
 * Decompiled with CFR 0.152.
 */
package SelectorPackage;

import SocketManagementPackage.LiveDBSocketChannelManagement;
import SocketManagementPackage.LiveDBSocketChannelMerger;
import SynchronizationPackage.LiveDBCloseSemaphore;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;

public class LiveDBSelector
implements Runnable {
    private Thread m_SelectorThread;
    private boolean m_boolSelectorThreadExit;
    private Selector m_Selector;
    private ArrayList<SelectionKey> m_KeysToHandle;
    private ArrayList<Runnable> m_ListOpenSelectorJobs;
    private ArrayList<Runnable> m_ListActionSelectorJobs;
    private LiveDBCloseSemaphore m_LiveDBCloseSemaphore;
    private final Object m_SyncObject = new Object();

    public LiveDBSelector() {
        this.initMembers();
        try {
            this.m_Selector = Selector.open();
        }
        catch (IOException e) {
            LiveDBSocketChannelManagement.eventError(e, LiveDBSocketChannelManagement.ERROR_SELECTORCANNOTOPEN);
        }
        this.m_ListOpenSelectorJobs = new ArrayList();
        this.m_ListActionSelectorJobs = new ArrayList();
        this.m_SelectorThread = new Thread((Runnable)this, "SelectorThread");
        this.m_boolSelectorThreadExit = false;
        this.m_SelectorThread.start();
    }

    private void initMembers() {
        this.m_KeysToHandle = new ArrayList();
        this.m_SelectorThread = null;
        this.m_boolSelectorThreadExit = true;
        this.m_LiveDBCloseSemaphore = new LiveDBCloseSemaphore(this.getClass().getName());
    }

    public void close() {
        if (!this.m_LiveDBCloseSemaphore.enterCloseSection()) {
            return;
        }
        this.addOpenSelectorJob(new Runnable(){

            @Override
            public void run() {
                LiveDBSelector.this.closeSelectorAndChannels();
                LiveDBSelector.this.m_boolSelectorThreadExit = true;
            }
        });
        if (this.m_SelectorThread != null) {
            if (!Thread.currentThread().equals(this.m_SelectorThread)) {
                try {
                    this.m_SelectorThread.join();
                }
                catch (InterruptedException interruptedException) {}
            } else {
                this.doOpenSelectorJobs();
            }
        }
        this.m_LiveDBCloseSemaphore.leaveCloseSection();
    }

    protected void finalize() throws Throwable {
        if (this.m_ListOpenSelectorJobs != null) {
            this.m_ListOpenSelectorJobs.clear();
        }
        super.finalize();
    }

    private void closeSelectorAndChannels() {
        Socket o_Socket = null;
        ServerSocket o_ServerSocket = null;
        Set<SelectionKey> keys = null;
        try {
            keys = this.m_Selector.keys();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (keys != null) {
            for (SelectionKey key : keys) {
                if (key == null) continue;
                LiveDBSocketChannelMerger o_LiveDBSocketChannelMerger = (LiveDBSocketChannelMerger)key.attachment();
                try {
                    this.clearKeyEventInterest(key);
                    String stringSimpleName = key.channel().getClass().getSimpleName();
                    if (stringSimpleName != null && stringSimpleName.equals("ServerSocketChannelImpl")) {
                        o_ServerSocket = ((ServerSocketChannel)key.channel()).socket();
                        if (o_ServerSocket != null) {
                            o_ServerSocket.close();
                        }
                    } else {
                        o_Socket = ((SocketChannel)key.channel()).socket();
                        if (o_Socket != null) {
                            o_Socket.close();
                        }
                    }
                    key.channel().close();
                }
                catch (IOException e) {
                    LiveDBSocketChannelManagement.eventSelectorError(o_LiveDBSocketChannelMerger, e, LiveDBSocketChannelManagement.ERROR_SELECTORCLOSESOCKET);
                }
            }
        }
        try {
            this.m_Selector.close();
        }
        catch (IOException e) {
            LiveDBSocketChannelManagement.eventError(e, LiveDBSocketChannelManagement.ERROR_SELECTORCLOSE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addOpenSelectorJob(Runnable p_SelectorChange) {
        if (p_SelectorChange == null) {
            return;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            if (this.m_ListOpenSelectorJobs == null) {
                return;
            }
            this.m_ListOpenSelectorJobs.add(p_SelectorChange);
        }
        this.m_Selector.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doOpenSelectorJobs() {
        Object[] o_ActionJobs = null;
        Object object = this.m_SyncObject;
        synchronized (object) {
            if (this.m_ListOpenSelectorJobs != null) {
                o_ActionJobs = this.m_ListOpenSelectorJobs.toArray();
                this.m_ListOpenSelectorJobs.clear();
            }
        }
        if (o_ActionJobs != null) {
            for (int intJob = 0; intJob < o_ActionJobs.length; ++intJob) {
                Runnable o_SelectorChange = (Runnable)o_ActionJobs[intJob];
                if (o_SelectorChange == null) continue;
                o_SelectorChange.run();
            }
        }
    }

    public void registerChannelLater(final SelectableChannel p_SocketChannel, final int p_InterestOps, final Object p_Attachment) {
        if (p_SocketChannel == null) {
            return;
        }
        if (!this.m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        this.addOpenSelectorJob(new Runnable(){

            @Override
            public void run() {
                block2: {
                    try {
                        LiveDBSelector.this.registerChannelNow(p_SocketChannel, p_InterestOps, p_Attachment);
                    }
                    catch (IOException e) {
                        LiveDBSocketChannelMerger o_LiveDBSocketChannelMerger = (LiveDBSocketChannelMerger)p_Attachment;
                        if (o_LiveDBSocketChannelMerger == null) break block2;
                        LiveDBSocketChannelManagement.eventSelectorError(o_LiveDBSocketChannelMerger, e, LiveDBSocketChannelManagement.ERROR_SELECTORREGISTERCHANEL);
                    }
                }
            }
        });
        this.m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    private void registerChannelNow(SelectableChannel p_SocketChannel, int p_InterestOps, Object p_Attachment) throws IOException {
        if (p_SocketChannel == null) {
            return;
        }
        if (Thread.currentThread() != this.m_SelectorThread) {
            throw new IOException("LiveDBSelector Method can only be called from selector thread");
        }
        if (!p_SocketChannel.isOpen()) {
            throw new IOException("LiveDBServerSelector: registerChannelNow: Channel is not open.");
        }
        try {
            if (p_SocketChannel.isRegistered()) {
                SelectionKey sk = p_SocketChannel.keyFor(this.m_Selector);
                if (sk != null) {
                    throw new IOException("LiveDBSelector Channel is already registered with other selector");
                }
                sk.interestOps(p_InterestOps);
            } else {
                p_SocketChannel.configureBlocking(false);
                p_SocketChannel.register(this.m_Selector, p_InterestOps, p_Attachment);
            }
        }
        catch (Exception e) {
            IOException ioe = new IOException("LiveDBSelector Error registering channel.");
            ioe.initCause(e);
            throw ioe;
        }
    }

    private void addKeyEventInterest(SelectionKey p_SelectedKey, int p_NewInterest) throws IOException {
        if (p_SelectedKey == null) {
            return;
        }
        if (!p_SelectedKey.isValid()) {
            return;
        }
        try {
            if (p_NewInterest == 4) {
                // empty if block
            }
            p_SelectedKey.interestOps(p_SelectedKey.interestOps() | p_NewInterest);
        }
        catch (CancelledKeyException cke) {
            IOException ioe = new IOException("Failed to change channel interest.");
            ioe.initCause(cke);
            throw ioe;
        }
    }

    private void clearKeyEventInterest(SelectionKey p_SelectedKey) throws IOException {
        if (p_SelectedKey == null) {
            return;
        }
        if (!p_SelectedKey.isValid()) {
            return;
        }
        try {
            p_SelectedKey.interestOps(0);
        }
        catch (CancelledKeyException cke) {
            IOException ioe = new IOException("Failed to change channel interest.");
            ioe.initCause(cke);
            throw ioe;
        }
    }

    public void addChannelEventInterestLater(final SelectableChannel p_Channel, final int p_Interest) {
        if (p_Channel == null) {
            return;
        }
        if (!this.m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        if (p_Channel.isOpen()) {
            this.addOpenSelectorJob(new Runnable(){

                @Override
                public void run() {
                    try {
                        SelectionKey o_SelectedKey = p_Channel.keyFor(LiveDBSelector.this.m_Selector);
                        if (o_SelectedKey == null) {
                            LiveDBSelector.this.m_LiveDBCloseSemaphore.leaveWorkerSection();
                            return;
                        }
                        if (o_SelectedKey.isValid()) {
                            LiveDBSelector.this.addKeyEventInterest(o_SelectedKey, p_Interest);
                        }
                    }
                    catch (IOException e) {
                        LiveDBSocketChannelManagement.eventError(e, LiveDBSocketChannelManagement.ERROR_SELECTORCHANGEKEYINTEREST);
                    }
                }
            });
        }
        this.m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    private void handleAccept(ServerSocketChannel p_ServerSocketChannel) {
        if (p_ServerSocketChannel == null) {
            return;
        }
        SocketChannel o_ClientSocketChannel = null;
        try {
            o_ClientSocketChannel = p_ServerSocketChannel.accept();
            if (o_ClientSocketChannel == null) {
                return;
            }
            o_ClientSocketChannel.configureBlocking(false);
            o_ClientSocketChannel.socket().setReceiveBufferSize(LiveDBSocketChannelManagement.getSocketReceiveBufferSize());
            o_ClientSocketChannel.socket().setSendBufferSize(LiveDBSocketChannelManagement.getSocketSendBufferSize());
            o_ClientSocketChannel.socket().setSoTimeout(LiveDBSocketChannelManagement.getSocketSoTimeOut());
            int intLinget = LiveDBSocketChannelManagement.getSocketLingerTime();
            if (intLinget < 0) {
                o_ClientSocketChannel.socket().setSoLinger(false, 0);
            } else {
                o_ClientSocketChannel.socket().setSoLinger(true, intLinget);
            }
            o_ClientSocketChannel.socket().setTcpNoDelay(LiveDBSocketChannelManagement.getSocketTcpNoDelay());
            LiveDBSocketChannelManagement.eventConnectionAccept(o_ClientSocketChannel);
        }
        catch (IOException e) {
            try {
                o_ClientSocketChannel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            LiveDBSocketChannelManagement.eventServerError(e, LiveDBSocketChannelManagement.ERROR_SELECTORCHANGEKEYINTEREST);
        }
        try {
            SelectionKey o_SelectedKey = p_ServerSocketChannel.keyFor(this.m_Selector);
            if (o_SelectedKey == null) {
                return;
            }
            if (o_SelectedKey.isValid()) {
                this.addChannelEventInterestLater(p_ServerSocketChannel, 16);
            }
        }
        catch (Exception e) {
            LiveDBSocketChannelManagement.eventServerError(e, LiveDBSocketChannelManagement.ERROR_SELECTORCHANGEKEYINTEREST);
        }
    }

    private void handleConnect(SocketChannel p_SocketChannel, LiveDBSocketChannelMerger p_LiveDBSocketChannelMerger) {
        if (p_LiveDBSocketChannelMerger == null) {
            return;
        }
        if (p_SocketChannel == null) {
            return;
        }
        Socket o_Socket = p_SocketChannel.socket();
        if (o_Socket == null) {
            return;
        }
        try {
            if (!p_SocketChannel.finishConnect()) {
                LiveDBSocketChannelManagement.eventConnectionFailed(p_LiveDBSocketChannelMerger);
                return;
            }
            p_SocketChannel.socket().setReceiveBufferSize(LiveDBSocketChannelManagement.getSocketReceiveBufferSize());
            p_SocketChannel.socket().setSendBufferSize(LiveDBSocketChannelManagement.getSocketSendBufferSize());
            p_SocketChannel.socket().setSoTimeout(LiveDBSocketChannelManagement.getSocketSoTimeOut());
            int intLinget = LiveDBSocketChannelManagement.getSocketLingerTime();
            if (intLinget < 0) {
                p_SocketChannel.socket().setSoLinger(false, 0);
            } else {
                p_SocketChannel.socket().setSoLinger(true, intLinget);
            }
            p_SocketChannel.socket().setTcpNoDelay(LiveDBSocketChannelManagement.getSocketTcpNoDelay());
            p_SocketChannel.configureBlocking(false);
            LiveDBSocketChannelManagement.eventConnectionConnect(p_LiveDBSocketChannelMerger);
        }
        catch (Exception e) {
            LiveDBSocketChannelManagement.eventSelectorError(p_LiveDBSocketChannelMerger, e, LiveDBSocketChannelManagement.ERROR_SELECTORFINISHCONNECT);
            LiveDBSocketChannelManagement.eventConnectionFailed(p_LiveDBSocketChannelMerger);
        }
    }

    private void handleRead(LiveDBSocketChannelMerger p_LiveDBSocketChannelMerger) {
        if (p_LiveDBSocketChannelMerger == null) {
            return;
        }
        p_LiveDBSocketChannelMerger.selectorRead();
    }

    private void handleWrite(LiveDBSocketChannelMerger p_LiveDBSocketChannelMerger) {
        if (p_LiveDBSocketChannelMerger == null) {
            return;
        }
        p_LiveDBSocketChannelMerger.selectorWrite();
    }

    public void wakeUpSelector() {
        if (this.m_Selector != null) {
            this.m_Selector.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int intSelectedKeys = 0;
        while (true) {
            SelectionKey selectedKey;
            this.doOpenSelectorJobs();
            if (this.m_boolSelectorThreadExit) {
                Object object = this.m_SyncObject;
                synchronized (object) {
                    if (this.m_ListOpenSelectorJobs != null) {
                        this.m_ListOpenSelectorJobs.clear();
                    }
                    break;
                }
            }
            try {
                intSelectedKeys = this.m_Selector.select();
            }
            catch (ClosedSelectorException e) {
                LiveDBSocketChannelManagement.eventError(e, LiveDBSocketChannelManagement.ERROR_SELECTORSELECTKEYS);
                this.close();
                break;
            }
            catch (IOException e) {
                LiveDBSocketChannelManagement.eventError(e, LiveDBSocketChannelManagement.ERROR_SELECTORSELECTKEYS);
                continue;
            }
            Set<SelectionKey> o_SelectedKeys = null;
            try {
                o_SelectedKeys = this.m_Selector.selectedKeys();
            }
            catch (ClosedSelectorException e) {
                this.close();
                break;
            }
            if (o_SelectedKeys == null) continue;
            this.m_KeysToHandle.clear();
            Iterator<SelectionKey> keyIterator = o_SelectedKeys.iterator();
            while (keyIterator.hasNext()) {
                selectedKey = keyIterator.next();
                keyIterator.remove();
                if (selectedKey == null || !selectedKey.isValid()) continue;
                this.m_KeysToHandle.add(selectedKey);
            }
            for (int intKey = 0; intKey < this.m_KeysToHandle.size(); ++intKey) {
                LiveDBSocketChannelMerger o_LiveDBSocketChannelMerger;
                boolean boolKeyHandled = false;
                boolean boolError = false;
                selectedKey = this.m_KeysToHandle.get(intKey);
                try {
                    SocketChannel o_SocketChannel;
                    Object o_Attachment;
                    int intReadyOps = selectedKey.readyOps();
                    selectedKey.interestOps(selectedKey.interestOps() ^ intReadyOps);
                    if (selectedKey.isAcceptable()) {
                        boolKeyHandled = true;
                        this.handleAccept((ServerSocketChannel)selectedKey.channel());
                    } else if (selectedKey.isConnectable()) {
                        boolKeyHandled = true;
                        o_Attachment = selectedKey.attachment();
                        if (o_Attachment != null) {
                            this.handleConnect((SocketChannel)selectedKey.channel(), (LiveDBSocketChannelMerger)o_Attachment);
                        } else {
                            boolError = true;
                            LiveDBSocketChannelManagement.eventError(new Exception("LiveDBSelector isConnectable Key has no Attachment"), LiveDBSocketChannelManagement.ERROR_SELECTORMISSINGATTACHMENT);
                        }
                    }
                    if (!boolError && selectedKey.isReadable()) {
                        boolKeyHandled = true;
                        o_Attachment = selectedKey.attachment();
                        if (o_Attachment != null) {
                            o_SocketChannel = (SocketChannel)selectedKey.channel();
                            o_LiveDBSocketChannelMerger = (LiveDBSocketChannelMerger)o_Attachment;
                            if (!o_SocketChannel.isConnected()) {
                                boolError = true;
                                LiveDBSocketChannelManagement.eventConnectionLost(o_LiveDBSocketChannelMerger);
                            } else {
                                this.handleRead(o_LiveDBSocketChannelMerger);
                            }
                        } else {
                            boolError = true;
                            LiveDBSocketChannelManagement.eventError(new Exception("LiveDBSelector isReadable Key has no Attachment"), LiveDBSocketChannelManagement.ERROR_SELECTORMISSINGATTACHMENT);
                        }
                    }
                    if (!boolError && selectedKey.isWritable()) {
                        boolKeyHandled = true;
                        o_Attachment = selectedKey.attachment();
                        if (o_Attachment != null) {
                            o_SocketChannel = (SocketChannel)selectedKey.channel();
                            o_LiveDBSocketChannelMerger = (LiveDBSocketChannelMerger)o_Attachment;
                            if (!o_SocketChannel.isConnected()) {
                                boolError = true;
                                LiveDBSocketChannelManagement.eventConnectionLost(o_LiveDBSocketChannelMerger);
                            } else {
                                this.handleWrite(o_LiveDBSocketChannelMerger);
                            }
                        } else {
                            boolError = true;
                            LiveDBSocketChannelManagement.eventError(new Exception("LiveDBSelector isWritable Key has no Attachment"), LiveDBSocketChannelManagement.ERROR_SELECTORMISSINGATTACHMENT);
                        }
                    }
                    if (boolKeyHandled) continue;
                    boolError = true;
                    LiveDBSocketChannelManagement.eventError(new Exception("Unknown sekector key"), LiveDBSocketChannelManagement.ERROR_SELECTORMISSINGATTACHMENT);
                    continue;
                }
                catch (Exception e) {
                    boolError = true;
                    o_LiveDBSocketChannelMerger = (LiveDBSocketChannelMerger)selectedKey.attachment();
                    LiveDBSocketChannelManagement.eventSelectorError(o_LiveDBSocketChannelMerger, e, LiveDBSocketChannelManagement.ERROR_SELECTORPARSEKEY);
                }
            }
            this.m_KeysToHandle.clear();
        }
    }
}

