/*
 * Decompiled with CFR 0.152.
 */
package SelectorPackage;

import LiveDBSerializingPackage.LiveDBObjectDeserializing;
import LiveDBSerializingPackage.LiveDBObjectSerializing;
import RareByteInterpreterPackage.RareByteInterpreterInterface;
import SocketManagementPackage.LiveDBSocketChannelManagement;
import SocketManagementPackage.LiveDBSocketChannelMerger;
import SocketPackage.LiveDBSocket;
import SynchronizationPackage.LiveDBCloseSemaphore;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

public class LiveDBObjectReadWrite {
    public static int BYTEBUFFER_READWRITE_SIZE = 1024;
    private byte[] m_MessagePrecode = null;
    private int m_MessagePrecodeLength;
    private LiveDBSocketChannelMerger m_LiveDBSocketChannelMerger;
    private SocketChannel m_ClientSocketChannel;
    private boolean m_FlagChannelOK;
    private byte[] m_InputMessagePrecode;
    private ByteBuffer m_ByteBufferInputMessageLength;
    private int m_InputMessageLength;
    private ByteBuffer m_ByteBufferInputMessage;
    private boolean m_ByteBufferInputGotLength;
    private ByteBuffer m_ByteBuffer_Read;
    private ByteBuffer m_ByteBufferOutputMessage;
    private ByteBuffer m_ByteBufferOutputMessageLength;
    private int m_OutputMessageLength;
    private boolean m_ByteBufferOutputSendLength;
    private boolean m_boolIsWritingMessage;
    private int m_BytesWritten;
    private Serializable m_OutgoingMessage;
    private ByteBuffer m_ByteBuffer_Write;
    private boolean m_ByteBuffer_Write_Fill;
    private LiveDBCloseSemaphore m_LiveDBCloseSemaphore;

    public LiveDBObjectReadWrite(LiveDBSocketChannelMerger p_LiveDBSocketChannelMerger) {
        this.initMembers();
        if (p_LiveDBSocketChannelMerger == null) {
            return;
        }
        this.m_LiveDBSocketChannelMerger = p_LiveDBSocketChannelMerger;
        this.m_ClientSocketChannel = p_LiveDBSocketChannelMerger.getSocketChannel();
        this.m_FlagChannelOK = true;
    }

    private void initMembers() {
        this.m_LiveDBCloseSemaphore = new LiveDBCloseSemaphore(this.getClass().getName());
        this.m_MessagePrecode = LiveDBSocketChannelManagement.getMessagePrecode();
        if (this.m_MessagePrecode == null) {
            this.m_InputMessagePrecode = null;
            this.m_MessagePrecodeLength = 0;
        } else {
            this.m_MessagePrecodeLength = this.m_MessagePrecode.length;
            this.m_InputMessagePrecode = new byte[this.m_MessagePrecodeLength];
        }
        byte[] o_ByteArrayRead = new byte[BYTEBUFFER_READWRITE_SIZE];
        this.m_ByteBuffer_Read = ByteBuffer.wrap(o_ByteArrayRead);
        this.m_ByteBufferInputGotLength = false;
        this.m_InputMessageLength = 0;
        this.m_ByteBufferInputMessageLength = ByteBuffer.allocate(4 + this.m_MessagePrecodeLength);
        this.m_ByteBufferInputMessageLength.clear();
        byte[] o_ByteArrayWrite = new byte[BYTEBUFFER_READWRITE_SIZE];
        this.m_ByteBuffer_Write = ByteBuffer.wrap(o_ByteArrayWrite);
        this.m_ByteBuffer_Write_Fill = false;
        this.m_boolIsWritingMessage = false;
        this.m_ByteBufferOutputSendLength = false;
        this.m_OutputMessageLength = 0;
        this.m_ByteBufferOutputMessageLength = ByteBuffer.allocate(4 + this.m_MessagePrecodeLength);
        this.m_ByteBufferOutputMessageLength.clear();
    }

    public void close() {
        if (!this.m_LiveDBCloseSemaphore.enterCloseSection()) {
            return;
        }
        this.m_LiveDBSocketChannelMerger = null;
        this.m_ClientSocketChannel = null;
        this.m_LiveDBCloseSemaphore.leaveCloseSection();
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    public void selectorRead() {
        this.read();
    }

    public void selectorWrite() {
        this.write();
    }

    public void read() {
        int intCountBytes = 0;
        LiveDBSocketChannelMerger o_LiveDBSocketChannelMerger = this.m_LiveDBSocketChannelMerger;
        SocketChannel o_ClientSocketChannel = this.m_ClientSocketChannel;
        if (o_LiveDBSocketChannelMerger == null) {
            return;
        }
        if (o_ClientSocketChannel == null) {
            return;
        }
        if (!this.m_FlagChannelOK) {
            return;
        }
        LiveDBSocket o_LiveDBSocket = o_LiveDBSocketChannelMerger.getLiveDBSocket();
        if (o_LiveDBSocket != null) {
            o_LiveDBSocket.setTimeStampReaction();
        }
        if (!this.m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        if (!o_ClientSocketChannel.isConnected()) {
            System.err.println("LiveDBObjectReadWrite handleRead channel not connected");
            this.m_LiveDBCloseSemaphore.leaveWorkerSection();
            return;
        }
        if (!this.m_ByteBufferInputGotLength) {
            try {
                o_LiveDBSocket = o_LiveDBSocketChannelMerger.getLiveDBSocket();
                if (o_LiveDBSocket != null) {
                    o_LiveDBSocket.setTimeStampReaction();
                }
                try {
                    o_ClientSocketChannel.configureBlocking(false);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                intCountBytes = o_ClientSocketChannel.read(this.m_ByteBufferInputMessageLength);
            }
            catch (Exception e) {
                this.skipRestBytes(o_ClientSocketChannel);
                LiveDBSocketChannelManagement.eventSelectorError(o_LiveDBSocketChannelMerger, e, LiveDBSocketChannelManagement.ERROR_MESSAGEREADING);
                this.m_FlagChannelOK = false;
                if (o_LiveDBSocketChannelMerger != null) {
                    LiveDBSocketChannelManagement.eventConnectionLost(o_LiveDBSocketChannelMerger);
                }
                this.m_ByteBufferInputMessageLength.clear();
                this.m_LiveDBCloseSemaphore.leaveWorkerSection();
                return;
            }
            if (intCountBytes < 0) {
                this.m_FlagChannelOK = false;
                if (o_LiveDBSocketChannelMerger != null) {
                    LiveDBSocketChannelManagement.eventConnectionLost(o_LiveDBSocketChannelMerger);
                }
                this.m_ByteBufferInputMessageLength.clear();
                this.m_LiveDBCloseSemaphore.leaveWorkerSection();
                return;
            }
            if (intCountBytes > 0 && this.m_ByteBufferInputMessageLength.position() == 4 + this.m_MessagePrecodeLength) {
                this.m_ByteBufferInputMessageLength.flip();
                this.m_ByteBufferInputMessageLength.get(this.m_InputMessagePrecode);
                this.m_InputMessageLength = this.m_ByteBufferInputMessageLength.getInt(this.m_MessagePrecodeLength);
                this.m_ByteBufferInputMessageLength.clear();
                boolean boolPrecodeOK = true;
                if (this.m_MessagePrecodeLength > 0) {
                    for (int intByte = 0; intByte < this.m_MessagePrecodeLength; ++intByte) {
                        if (this.m_InputMessagePrecode[intByte] == this.m_MessagePrecode[intByte]) continue;
                        boolPrecodeOK = false;
                        break;
                    }
                }
                if (!boolPrecodeOK || this.m_InputMessageLength <= 0 || this.m_InputMessageLength > LiveDBSocketChannelManagement.MESSAGE_MAXLENGTH) {
                    LiveDBSocketChannelManagement.selectorMessageReadUnknown(o_LiveDBSocketChannelMerger);
                    LiveDBSocketChannelManagement.eventSelectorError(o_LiveDBSocketChannelMerger, new Exception("MessageLength out of bounds"), LiveDBSocketChannelManagement.ERROR_MESSAGEUNKNOWN);
                    this.m_ByteBufferInputGotLength = false;
                } else {
                    this.m_ByteBufferInputGotLength = true;
                    this.m_ByteBufferInputMessage = ByteBuffer.allocate(this.m_InputMessageLength);
                }
            }
        } else if (this.m_ByteBufferInputGotLength) {
            try {
                o_LiveDBSocket = o_LiveDBSocketChannelMerger.getLiveDBSocket();
                if (o_LiveDBSocket != null) {
                    o_LiveDBSocket.setTimeStampReaction();
                }
                this.m_ByteBuffer_Read.clear();
                if (this.m_ByteBufferInputMessage.remaining() < this.m_ByteBuffer_Read.capacity()) {
                    this.m_ByteBuffer_Read.limit(this.m_ByteBufferInputMessage.remaining());
                }
                if ((intCountBytes = o_ClientSocketChannel.read(this.m_ByteBuffer_Read)) > 0) {
                    this.m_ByteBufferInputMessage.put(this.m_ByteBuffer_Read.array(), 0, intCountBytes);
                }
            }
            catch (Exception e) {
                this.skipRestBytes(o_ClientSocketChannel);
                LiveDBSocketChannelManagement.eventSelectorError(o_LiveDBSocketChannelMerger, e, LiveDBSocketChannelManagement.ERROR_MESSAGEREADING);
                this.m_FlagChannelOK = false;
                if (o_LiveDBSocketChannelMerger != null) {
                    LiveDBSocketChannelManagement.eventConnectionLost(o_LiveDBSocketChannelMerger);
                }
                this.m_ByteBufferInputMessage.clear();
                this.m_ByteBufferInputMessage = null;
                this.m_ByteBufferInputGotLength = false;
                this.m_LiveDBCloseSemaphore.leaveWorkerSection();
                return;
            }
            if (intCountBytes < 0) {
                this.m_FlagChannelOK = false;
                if (o_LiveDBSocketChannelMerger != null) {
                    LiveDBSocketChannelManagement.eventConnectionLost(o_LiveDBSocketChannelMerger);
                }
                this.m_ByteBufferInputMessage.clear();
                this.m_ByteBufferInputMessage = null;
                this.m_ByteBufferInputGotLength = false;
                this.m_LiveDBCloseSemaphore.leaveWorkerSection();
                return;
            }
            if (intCountBytes > 0 && this.m_ByteBufferInputMessage.position() == this.m_InputMessageLength) {
                block38: {
                    try {
                        Serializable o_Message = LiveDBObjectDeserializing.deserialize((ByteBuffer)this.m_ByteBufferInputMessage);
                        if (o_LiveDBSocketChannelMerger != null) {
                            LiveDBSocketChannelManagement.selectorMessageRead(o_LiveDBSocketChannelMerger, o_Message, false);
                        }
                        o_Message = null;
                    }
                    catch (Exception e) {
                        boolean boolValidBytes = false;
                        try {
                            Serializable o_Message;
                            RareByteInterpreterInterface o_RareByteInterpreterInterface = LiveDBSocketChannelManagement.getRareByteInterpreter();
                            if (o_RareByteInterpreterInterface != null && (o_Message = o_RareByteInterpreterInterface.convertBytesToObject(this.m_ByteBufferInputMessage)) != null) {
                                boolValidBytes = true;
                                LiveDBSocketChannelManagement.selectorMessageRead(o_LiveDBSocketChannelMerger, o_Message, true);
                            }
                        }
                        catch (Exception e_RareByteInterpreter) {
                            boolValidBytes = false;
                        }
                        if (boolValidBytes) break block38;
                        LiveDBSocketChannelManagement.selectorMessageReadUnknown(o_LiveDBSocketChannelMerger);
                        LiveDBSocketChannelManagement.eventSelectorError(o_LiveDBSocketChannelMerger, new Exception("Message is unknown"), LiveDBSocketChannelManagement.ERROR_MESSAGEUNKNOWN);
                    }
                }
                this.m_ByteBufferInputMessage.clear();
                this.m_ByteBufferInputMessage = null;
                this.m_ByteBufferInputGotLength = false;
            }
        }
        if (o_LiveDBSocketChannelMerger != null) {
            o_LiveDBSocketChannelMerger.addChannelEventInterest(1);
        }
        this.m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    public void write() {
        int intCountByte = 0;
        LiveDBSocketChannelMerger o_LiveDBSocketChannelMerger = this.m_LiveDBSocketChannelMerger;
        SocketChannel o_ClientSocketChannel = this.m_ClientSocketChannel;
        if (o_LiveDBSocketChannelMerger == null) {
            return;
        }
        if (o_ClientSocketChannel == null) {
            return;
        }
        if (!this.m_FlagChannelOK) {
            return;
        }
        if (!this.m_LiveDBCloseSemaphore.enterWorkerSection()) {
            return;
        }
        if (!o_ClientSocketChannel.isConnected()) {
            this.m_LiveDBCloseSemaphore.leaveWorkerSection();
            return;
        }
        if (o_LiveDBSocketChannelMerger == null) {
            this.m_LiveDBCloseSemaphore.leaveWorkerSection();
            return;
        }
        LiveDBSocket o_LiveDBSocket = o_LiveDBSocketChannelMerger.getLiveDBSocket();
        if (o_LiveDBSocket == null) {
            this.m_LiveDBCloseSemaphore.leaveWorkerSection();
            return;
        }
        RareByteInterpreterInterface o_RareByteInterpreterInterface = o_LiveDBSocket.getRareByteInterpreterInterface();
        if (!this.m_boolIsWritingMessage) {
            this.m_OutgoingMessage = o_LiveDBSocket.getNextOutgoingMessage();
            if (this.m_OutgoingMessage == null) {
                this.m_LiveDBCloseSemaphore.leaveWorkerSection();
                return;
            }
            if (o_LiveDBSocket.getRareByteInterpreterInterface() == null) {
                try {
                    this.m_ByteBufferOutputMessage = LiveDBObjectSerializing.serialize((Serializable)this.m_OutgoingMessage);
                }
                catch (IOException e) {
                    this.m_boolIsWritingMessage = false;
                    this.m_ByteBufferOutputSendLength = false;
                    this.m_OutgoingMessage = null;
                    this.m_BytesWritten = 0;
                    o_LiveDBSocketChannelMerger.addChannelEventInterest(4);
                    LiveDBSocketChannelManagement.eventSelectorError(o_LiveDBSocketChannelMerger, e, LiveDBSocketChannelManagement.ERROR_MESSAGESERIALIZING);
                    this.m_LiveDBCloseSemaphore.leaveWorkerSection();
                    return;
                }
            }
            try {
                this.m_ByteBufferOutputMessage = o_RareByteInterpreterInterface.convertObjectToBytes(this.m_OutgoingMessage);
                if (this.m_ByteBufferOutputMessage == null) {
                    this.m_boolIsWritingMessage = false;
                    this.m_ByteBufferOutputSendLength = false;
                    this.m_OutgoingMessage = null;
                    this.m_BytesWritten = 0;
                    o_LiveDBSocketChannelMerger.addChannelEventInterest(4);
                    LiveDBSocketChannelManagement.eventSelectorError(o_LiveDBSocketChannelMerger, new IllegalArgumentException("Message langth is 0"), LiveDBSocketChannelManagement.ERROR_MESSAGEWRITING);
                    this.m_LiveDBCloseSemaphore.leaveWorkerSection();
                    return;
                }
            }
            catch (Exception e) {
                LiveDBSocketChannelManagement.eventSelectorError(o_LiveDBSocketChannelMerger, e, LiveDBSocketChannelManagement.ERROR_MESSAGEDESERIALIZING);
                this.m_boolIsWritingMessage = false;
                this.m_ByteBufferOutputSendLength = false;
                this.m_OutgoingMessage = null;
                this.m_BytesWritten = 0;
                o_LiveDBSocketChannelMerger.addChannelEventInterest(4);
                this.m_LiveDBCloseSemaphore.leaveWorkerSection();
                return;
            }
            this.m_ByteBufferOutputMessage.rewind();
            this.m_boolIsWritingMessage = true;
            this.m_ByteBufferOutputSendLength = false;
            this.m_BytesWritten = 0;
            this.m_OutputMessageLength = this.m_ByteBufferOutputMessage.capacity();
            this.m_ByteBufferOutputMessageLength.clear();
            if (this.m_MessagePrecodeLength > 0) {
                this.m_ByteBufferOutputMessageLength.put(this.m_MessagePrecode);
            }
            this.m_ByteBufferOutputMessageLength.putInt(this.m_OutputMessageLength);
            this.m_ByteBufferOutputMessageLength.rewind();
        }
        if (!this.m_ByteBufferOutputSendLength) {
            try {
                intCountByte = o_ClientSocketChannel.write(this.m_ByteBufferOutputMessageLength);
            }
            catch (Exception e) {
                LiveDBSocketChannelManagement.eventSelectorError(o_LiveDBSocketChannelMerger, e, LiveDBSocketChannelManagement.ERROR_MESSAGEWRITING);
                this.m_FlagChannelOK = false;
                if (o_LiveDBSocketChannelMerger != null) {
                    LiveDBSocketChannelManagement.eventConnectionLost(o_LiveDBSocketChannelMerger);
                }
                this.m_ByteBufferOutputMessage = null;
                this.m_boolIsWritingMessage = false;
                this.m_LiveDBCloseSemaphore.leaveWorkerSection();
                return;
            }
            if (intCountByte > 0 && this.m_ByteBufferOutputMessageLength.position() == 4 + this.m_MessagePrecodeLength) {
                this.m_ByteBufferOutputSendLength = true;
                this.m_ByteBufferOutputMessageLength.clear();
                this.m_ByteBuffer_Write_Fill = true;
            }
        } else if (this.m_ByteBufferOutputSendLength) {
            try {
                if (this.m_ByteBuffer_Write.remaining() <= 0 || this.m_ByteBuffer_Write_Fill) {
                    this.m_ByteBuffer_Write.clear();
                    if (this.m_ByteBufferOutputMessage.remaining() < this.m_ByteBuffer_Write.capacity()) {
                        this.m_ByteBuffer_Write.limit(this.m_ByteBufferOutputMessage.remaining());
                    }
                    int intPosition = this.m_ByteBufferOutputMessage.position();
                    this.m_ByteBuffer_Write.put(this.m_ByteBufferOutputMessage.array(), intPosition, this.m_ByteBuffer_Write.limit());
                    this.m_ByteBufferOutputMessage.position(intPosition + this.m_ByteBuffer_Write.limit());
                    this.m_ByteBuffer_Write.position(0);
                    this.m_ByteBuffer_Write_Fill = false;
                }
                if ((intCountByte = o_ClientSocketChannel.write(this.m_ByteBuffer_Write)) > 0) {
                    this.m_BytesWritten += intCountByte;
                    if (this.m_ByteBuffer_Write.remaining() <= 0) {
                        this.m_ByteBuffer_Write_Fill = true;
                    }
                }
            }
            catch (Exception e) {
                LiveDBSocketChannelManagement.eventSelectorError(o_LiveDBSocketChannelMerger, e, LiveDBSocketChannelManagement.ERROR_MESSAGEWRITING);
                this.m_FlagChannelOK = false;
                if (o_LiveDBSocketChannelMerger != null) {
                    LiveDBSocketChannelManagement.eventConnectionLost(o_LiveDBSocketChannelMerger);
                }
                this.m_ByteBufferOutputSendLength = false;
                this.m_ByteBufferOutputMessage = null;
                this.m_boolIsWritingMessage = false;
                this.m_BytesWritten = 0;
                this.m_LiveDBCloseSemaphore.leaveWorkerSection();
                return;
            }
            if (intCountByte > 0 && this.m_BytesWritten == this.m_OutputMessageLength) {
                LiveDBSocketChannelManagement.selectorMessageWritten(o_LiveDBSocketChannelMerger, this.m_OutgoingMessage);
                this.m_ByteBufferOutputSendLength = false;
                this.m_boolIsWritingMessage = false;
                this.m_ByteBufferOutputMessage.clear();
                this.m_ByteBufferOutputMessage = null;
                this.m_OutgoingMessage = null;
            }
        }
        if (o_LiveDBSocketChannelMerger != null) {
            o_LiveDBSocketChannelMerger.addChannelEventInterest(4);
        }
        this.m_LiveDBCloseSemaphore.leaveWorkerSection();
    }

    private void skipRestBytes(SocketChannel p_SocketChannel) {
        if (p_SocketChannel == null) {
            return;
        }
        SocketChannel o_ClientSocketChannel = this.m_ClientSocketChannel;
        if (o_ClientSocketChannel == null) {
            return;
        }
        try {
            InputStream o_InputStream;
            Socket o_Socket = o_ClientSocketChannel.socket();
            if (o_Socket != null && (o_InputStream = o_Socket.getInputStream()) != null) {
                int intRestBytes = o_InputStream.available();
                o_InputStream.skip(intRestBytes);
            }
        }
        catch (Exception eClear) {
            boolean bl = false;
        }
    }
}

