/*
 * Decompiled with CFR 0.152.
 */
package RunPackage;

import ConfigurationPackage.MediaServer_Configuration;
import OS.OSChecker;
import com.sun.management.OperatingSystemMXBean;
import java.awt.EventQueue;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.net.URLDecoder;

public class Run_LiveShowMediaServer {
    public static long DEFAULTSIZE_MIN_MB = 1500L;
    public static long DEFAULTSIZE_MAX_MB = 0L;
    public static long DEFAULTSIZE_SMALLMIN_MB = 900L;
    public static float DEFAULT_MAXPERCENTAGE = 0.4f;
    public static float DEFAULT_MINPERCENTAGE = 0.3f;
    public static long s_MaxMemory = DEFAULTSIZE_SMALLMIN_MB;
    public static long s_MinMemory = DEFAULTSIZE_SMALLMIN_MB;

    public static void runExecCommand(final String p_Additon) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Process o_Process = null;
                try {
                    String stringCommand = Run_LiveShowMediaServer.getStartCommand(p_Additon);
                    if (stringCommand == null) {
                        return;
                    }
                    String[] stringCommandArray = stringCommand.split(" ");
                    ProcessBuilder o_ProcessBuilder = new ProcessBuilder(stringCommandArray);
                    String stringWorkingDirectory = Run_LiveShowMediaServer.getWorkingDirectory();
                    StringBuilder stringBuilderProcessOutputFile = new StringBuilder();
                    stringBuilderProcessOutputFile.append(OSChecker.getPathUserHomeConfigDirectory());
                    stringBuilderProcessOutputFile.append("ProcessOutput");
                    if (p_Additon != null) {
                        stringBuilderProcessOutputFile.append(p_Additon);
                    }
                    File o_ProcessOutputFile = new File(stringBuilderProcessOutputFile.toString());
                    o_ProcessBuilder.redirectOutput(o_ProcessOutputFile);
                    o_ProcessBuilder.redirectErrorStream(true);
                    o_ProcessBuilder.start();
                }
                catch (Exception e) {
                    o_Process = null;
                    System.out.println("MediaServer cannot start second instance:");
                    System.out.println(e.getMessage());
                }
                MediaServer_Configuration.setAdditionalInstance(o_Process);
            }
        });
    }

    public static String getJarDirectory() {
        URL urlWorkingDirectory = Run_LiveShowMediaServer.class.getProtectionDomain().getCodeSource().getLocation();
        String stringWorkingDirectory = urlWorkingDirectory.getFile();
        try {
            stringWorkingDirectory = URLDecoder.decode(stringWorkingDirectory, "UTF-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        File o_RunFile = new File(stringWorkingDirectory);
        stringWorkingDirectory = o_RunFile.getParent();
        if (stringWorkingDirectory.endsWith("build")) {
            o_RunFile = new File(stringWorkingDirectory);
            stringWorkingDirectory = o_RunFile.getParent() + File.separator + "dist";
        }
        return stringWorkingDirectory;
    }

    public static String getWorkingDirectory() {
        URL urlWorkingDirectory = Run_LiveShowMediaServer.class.getProtectionDomain().getCodeSource().getLocation();
        String stringWorkingDirectory = urlWorkingDirectory.getFile();
        try {
            stringWorkingDirectory = URLDecoder.decode(stringWorkingDirectory, "UTF-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        File o_RunFile = new File(stringWorkingDirectory);
        stringWorkingDirectory = o_RunFile.getParent();
        if (stringWorkingDirectory.endsWith("build")) {
            o_RunFile = new File(stringWorkingDirectory);
            stringWorkingDirectory = o_RunFile.getParent();
        }
        return stringWorkingDirectory;
    }

    public static long getTotalPhysicalMemorySize() {
        OperatingSystemMXBean operatingSystemMXBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        long value = operatingSystemMXBean.getTotalPhysicalMemorySize();
        return value;
    }

    public static long getFreePhysicalMemorySize() {
        OperatingSystemMXBean operatingSystemMXBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        long value = operatingSystemMXBean.getFreePhysicalMemorySize();
        return value;
    }

    public static void calculateMemorySize() {
        float longMB = 1048576.0f;
        float longGB = 1.0737418E9f;
        long longTotalMemory = Run_LiveShowMediaServer.getTotalPhysicalMemorySize();
        long longFreeMemory = Run_LiveShowMediaServer.getFreePhysicalMemorySize();
        s_MaxMemory = (long)((float)longTotalMemory * DEFAULT_MAXPERCENTAGE / longMB);
        s_MinMemory = (long)((float)longTotalMemory * DEFAULT_MINPERCENTAGE / longMB);
        long longMinSize = longTotalMemory < 2500000000L ? DEFAULTSIZE_SMALLMIN_MB : DEFAULTSIZE_MIN_MB;
        if (s_MinMemory < longMinSize) {
            s_MinMemory = longMinSize;
        } else if (DEFAULTSIZE_MAX_MB > 0L && s_MinMemory > DEFAULTSIZE_MAX_MB) {
            s_MinMemory = DEFAULTSIZE_MAX_MB;
        }
        if (s_MaxMemory < longMinSize) {
            s_MaxMemory = longMinSize;
        } else if (DEFAULTSIZE_MAX_MB > 0L && s_MaxMemory > DEFAULTSIZE_MAX_MB) {
            s_MaxMemory = DEFAULTSIZE_MAX_MB;
        }
    }

    public static String getStartCommand(String p_Addition) {
        StringBuilder o_StringBuilder = new StringBuilder();
        try {
            Run_LiveShowMediaServer.calculateMemorySize();
            String stringJarDirectory = Run_LiveShowMediaServer.getJarDirectory();
            o_StringBuilder.append("java");
            if (OSChecker.getOSGroupFlag() == 1) {
                if (OSChecker.getOSArchitecture().toLowerCase().contains("arm")) {
                    o_StringBuilder.append(" -Xms" + String.valueOf(s_MinMemory) + "m -Xmx" + String.valueOf(s_MaxMemory) + "m -XX:+UseConcMarkSweepGC -jar \"" + stringJarDirectory + File.separator + "LiveShow_MediaServer.jar\"");
                } else {
                    o_StringBuilder.append(" -Xms" + String.valueOf(s_MinMemory) + "m -Xmx" + String.valueOf(s_MaxMemory) + "m -XX:+UseG1GC -XX:MaxNewSize=128m -jar \"" + stringJarDirectory + File.separator + "LiveShow_MediaServer.jar\"");
                }
            } else if (OSChecker.getOSArchitecture().toLowerCase().contains("arm")) {
                o_StringBuilder.append(" -Xms" + String.valueOf(s_MinMemory) + "m -Xmx" + String.valueOf(s_MaxMemory) + "m -XX:+UseConcMarkSweepGC -jar " + stringJarDirectory + File.separator + "LiveShow_MediaServer.jar");
            } else {
                o_StringBuilder.append(" -Xms" + String.valueOf(s_MinMemory) + "m -Xmx" + String.valueOf(s_MaxMemory) + "m -XX:+UseG1GC -XX:MaxNewSize=128m -jar " + stringJarDirectory + File.separator + "LiveShow_MediaServer.jar");
            }
            if (p_Addition != null) {
                o_StringBuilder.append(" ");
                o_StringBuilder.append(p_Addition);
            }
        }
        catch (Exception e) {
            return null;
        }
        return o_StringBuilder.toString();
    }
}

