/*
 * Decompiled with CFR 0.152.
 */
package MediaPackage;

import ConfigurationPackage.MediaServer_Configuration;
import GraphicsDeviceToolsPackage.GraphicsDeviceTools;
import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LanguageTools.LiveLanguagePackage.LiveLanguageString;
import MainPackage.MediaServer;
import MediaPlayerPackage.JPanel_MediaSurface;
import SoundPackage.SoundMixers;
import SynchronizationPackage.EventQueueHandler;
import ToolsGraphics.JLabelBackground;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;

public class JFrame_MediaSurface
extends JFrame
implements GraphicsDeviceTools.GraphicsDeviceListener {
    @LiveLanguageString
    public static String MEDIASERVER = "Media Server";
    @LiveLanguageString
    public static String MEDIASERVER_STARTED = "Server started";
    @LiveLanguageString
    public static String MEDIASERVER_STOPPED = "Server stopped";
    @LiveLanguageString
    public static String MEDIASERVER_SCREEN = "Screen";
    @LiveLanguageString
    public static String CONFIGURATION_REMARK = "-- Click to open the configuration --";
    private ArrayList<GraphicsDeviceTools.GraphicsDeviceDescription> m_GraphicsDeviceDescriptions;
    private Rectangle m_GraphicDeviceDescriptions_Bounds;
    private Runnable m_RunnableSetDevices;
    private JFrame_MediaSurface m_SelfReference;
    private final Object m_SyncDevices = new Object();
    private JLabelBackground jLabel_Info;
    private JLabel jLabel_Logo;
    private JPanel jPanel_Info;
    private JPanel_MediaSurface jPanel_MediaSurface1;

    public JFrame_MediaSurface() {
        this.initMembers();
        this.initComponents();
        this.initComponentsFurther();
        LiveLanguage.addLanguageListener((Object)this, null);
        GraphicsDeviceTools.addGraphicDeviceListener((GraphicsDeviceTools.GraphicsDeviceListener)this);
    }

    private void initMembers() {
        this.m_SelfReference = this;
        this.m_GraphicsDeviceDescriptions = new ArrayList();
        this.m_GraphicDeviceDescriptions_Bounds = new Rectangle(0, 0, 0, 0);
        this.m_RunnableSetDevices = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = JFrame_MediaSurface.this.m_SyncDevices;
                synchronized (object) {
                    Rectangle o_Bounds = new Rectangle(0, 0, 0, 0);
                    if (JFrame_MediaSurface.this.m_GraphicsDeviceDescriptions.size() <= 0) {
                        GraphicsConfiguration o_GraphicsConfiguration;
                        GraphicsDevice o_GraphicsDevice = GraphicsDeviceTools.getDefaultGraphicsDevice();
                        if (o_GraphicsDevice != null && (o_GraphicsConfiguration = o_GraphicsDevice.getDefaultConfiguration()) != null) {
                            o_Bounds = o_GraphicsConfiguration.getBounds();
                            if (o_Bounds != null) {
                                GraphicsDeviceTools.showOnGraphicsDevice((Window)JFrame_MediaSurface.this.m_SelfReference, (GraphicsDevice)o_GraphicsDevice, (Rectangle)o_Bounds);
                            } else {
                                o_Bounds = new Rectangle(0, 0, 0, 0);
                            }
                        }
                        JFrame_MediaSurface.this.m_GraphicDeviceDescriptions_Bounds.setBounds(o_Bounds);
                    } else {
                        o_Bounds = GraphicsDeviceTools.showOnGraphicsDevice_Descriptions((ArrayList)JFrame_MediaSurface.this.m_GraphicsDeviceDescriptions, (JFrame)JFrame_MediaSurface.this.m_SelfReference);
                        if (o_Bounds == null) {
                            o_Bounds = new Rectangle(0, 0, 0, 0);
                        }
                        JFrame_MediaSurface.this.m_GraphicDeviceDescriptions_Bounds.setBounds(o_Bounds);
                    }
                }
                JFrame_MediaSurface.this.refresh();
            }
        };
        this.setIconImage(MediaServer.s_ImageIcon.getImage());
    }

    private void initComponents() {
        this.jPanel_Info = new JPanel();
        this.jLabel_Logo = new JLabel();
        this.jLabel_Info = new JLabelBackground();
        this.jPanel_MediaSurface1 = new JPanel_MediaSurface();
        this.setDefaultCloseOperation(0);
        this.setTitle("Media");
        this.setUndecorated(true);
        this.getContentPane().setLayout(new GridBagLayout());
        this.jPanel_Info.setOpaque(false);
        this.jPanel_Info.setLayout(new GridBagLayout());
        this.jLabel_Logo.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/LiveShow_Background_Black.png")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(50, 0, 0, 0);
        this.jPanel_Info.add((Component)this.jLabel_Logo, gridBagConstraints);
        this.jLabel_Info.setHorizontalAlignment(0);
        this.jLabel_Info.setToolTipText("");
        this.jLabel_Info.setFont(new Font("Times New Roman", 1, 26));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel_Info.add((Component)this.jLabel_Info, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jPanel_Info, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jPanel_MediaSurface1, gridBagConstraints);
        this.pack();
    }

    private void initComponentsFurther() {
        ImageIcon o_ImageIcon = new ImageIcon(this.getClass().getResource("/IconsPackage/MediaServer.png"));
        this.setIconImage(o_ImageIcon.getImage());
        this.jLabel_Info.setBackgroundImage(new ImageIcon(this.getClass().getResource("/IconsPackage/Rainbow.png")).getImage());
        this.jLabel_Info.setBackgroundStyle(2);
        this.jLabel_Info.setBackgroundOpaque(true);
        this.jLabel_Info.setBorder((Border)new LineBorder(Color.YELLOW, 10));
        this.jLabel_Info.setToolTipText(MediaServer_Configuration.TOOLTIPTEXT_SURFACE);
        this.jPanel_Info.setToolTipText(MediaServer_Configuration.TOOLTIPTEXT_SURFACE);
        this.jPanel_Info.setVisible(true);
        this.refresh();
    }

    public void close() {
        GraphicsDeviceTools.removeGraphicDeviceListener((GraphicsDeviceTools.GraphicsDeviceListener)this);
        LiveLanguage.removeLanguageListener((Object)this);
    }

    @Override
    public void setVisible(boolean p_Visible) {
        super.setVisible(p_Visible);
    }

    public JPanel_MediaSurface getJPanel_MediaSurface() {
        return this.jPanel_MediaSurface1;
    }

    public ArrayList<GraphicsDeviceTools.GraphicsDeviceDescription> getGraphicsDeviceDescriptions() {
        return this.m_GraphicsDeviceDescriptions;
    }

    public Rectangle getGraphicDeviceDescriptions_Bounds() {
        return this.m_GraphicDeviceDescriptions_Bounds;
    }

    @Override
    public void addMouseListener(MouseListener p_MouseListener) {
        super.addMouseListener(p_MouseListener);
        this.jPanel_Info.addMouseListener(p_MouseListener);
        this.jLabel_Info.addMouseListener(p_MouseListener);
        this.jPanel_MediaSurface1.addMouseListener(p_MouseListener);
    }

    @Override
    public void removeMouseListener(MouseListener p_MouseListener) {
        super.removeMouseListener(p_MouseListener);
        this.jPanel_Info.removeMouseListener(p_MouseListener);
        this.jLabel_Info.removeMouseListener(p_MouseListener);
        this.jPanel_MediaSurface1.removeMouseListener(p_MouseListener);
    }

    @Override
    public void addKeyListener(KeyListener p_MouseListener) {
        super.addKeyListener(p_MouseListener);
        this.jPanel_Info.addKeyListener(p_MouseListener);
        this.jLabel_Info.addKeyListener(p_MouseListener);
    }

    @Override
    public void removeKeyListener(KeyListener p_MouseListener) {
        super.removeKeyListener(p_MouseListener);
        this.jPanel_Info.removeKeyListener(p_MouseListener);
        this.jLabel_Info.removeKeyListener(p_MouseListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGraphicsDevices(ArrayList<GraphicsDeviceTools.GraphicsDeviceDescription> p_GraphicsDeviceDescriptions) {
        Object object = this.m_SyncDevices;
        synchronized (object) {
            this.m_GraphicsDeviceDescriptions.clear();
            this.m_GraphicsDeviceDescriptions.addAll(p_GraphicsDeviceDescriptions);
        }
        EventQueueHandler.invokeLater((Runnable)this.m_RunnableSetDevices);
    }

    public void releaseFullScreen() {
        GraphicsDevice o_GraphicsDevice;
        GraphicsConfiguration o_GraphicsConfiguration = this.getGraphicsConfiguration();
        if (o_GraphicsConfiguration != null && (o_GraphicsDevice = o_GraphicsConfiguration.getDevice()) != null && o_GraphicsDevice.getFullScreenWindow() == this) {
            o_GraphicsDevice.setFullScreenWindow(null);
        }
    }

    public void showInformation(final boolean p_Show) {
        if (!SwingUtilities.isEventDispatchThread()) {
            EventQueueHandler.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    JFrame_MediaSurface.this.showInformation(p_Show);
                }
            });
            return;
        }
        if (!p_Show) {
            this.jPanel_Info.setVisible(false);
            this.jPanel_MediaSurface1.setVisible(true);
        } else {
            this.jPanel_Info.setVisible(true);
            this.jPanel_Info.repaint();
            this.jPanel_MediaSurface1.setVisible(false);
            this.refresh();
        }
        this.revalidate();
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        StringBuffer o_StringBuffer = new StringBuffer();
        o_StringBuffer.append("<html>");
        o_StringBuffer.append("<table align=center style=\"color: #000000;\">");
        o_StringBuffer.append("<tr>");
        o_StringBuffer.append("<td align=right>");
        o_StringBuffer.append("MediaServer:  ");
        o_StringBuffer.append("</td>");
        o_StringBuffer.append("<td align=center>");
        String stringServerAddition = MediaServer.getMediaServer_Configuration().getServerAddition();
        if (stringServerAddition != null) {
            o_StringBuffer.append(MediaServer.getMediaServer_Configuration().getServerName());
            o_StringBuffer.append(" ");
            o_StringBuffer.append(stringServerAddition);
        } else {
            o_StringBuffer.append(MediaServer.getMediaServer_Configuration().getServerName());
        }
        o_StringBuffer.append("</td>");
        o_StringBuffer.append("</tr>");
        o_StringBuffer.append("<tr>");
        o_StringBuffer.append("<td align=right>");
        o_StringBuffer.append("Port:  ");
        o_StringBuffer.append("</td>");
        o_StringBuffer.append("<td align=center>");
        o_StringBuffer.append(MediaServer.getMediaServer_Communication().getServerPort());
        o_StringBuffer.append("</td>");
        o_StringBuffer.append("<td align=center>");
        if (MediaServer.getMediaServer_Communication().getIsConnected()) {
            o_StringBuffer.append("<FONT COLOR=\"#009900\">");
            o_StringBuffer.append(MEDIASERVER_STARTED);
            o_StringBuffer.append("</Font>");
        } else {
            o_StringBuffer.append("<FONT COLOR=\"#FF0000\">");
            o_StringBuffer.append(MEDIASERVER_STOPPED);
            o_StringBuffer.append("</Font>");
        }
        o_StringBuffer.append("</td>");
        o_StringBuffer.append("</tr>");
        o_StringBuffer.append("<td>");
        o_StringBuffer.append("</td>");
        Object object = this.m_SyncDevices;
        synchronized (object) {
            for (int intDevice = 0; intDevice < this.m_GraphicsDeviceDescriptions.size(); ++intDevice) {
                GraphicsDeviceTools.GraphicsDeviceDescription o_GraphicsDeviceDescription = this.m_GraphicsDeviceDescriptions.get(intDevice);
                if (o_GraphicsDeviceDescription == null) continue;
                o_StringBuffer.append("<tr>");
                o_StringBuffer.append("<td align=right>");
                o_StringBuffer.append(MEDIASERVER_SCREEN);
                o_StringBuffer.append(":");
                o_StringBuffer.append("</td>");
                o_StringBuffer.append("<td align=center>");
                if (GraphicsDeviceTools.getGraphicsDevice((GraphicsDeviceTools.GraphicsDeviceDescription)o_GraphicsDeviceDescription) == null) {
                    o_StringBuffer.append("<FONT COLOR=\"#FF0000\">");
                } else {
                    o_StringBuffer.append("<FONT COLOR=\"#009900\">");
                }
                String stringGraphicsDeviceID = o_GraphicsDeviceDescription.getIDString();
                if (stringGraphicsDeviceID.startsWith("\\")) {
                    o_StringBuffer.append(stringGraphicsDeviceID.substring(1, stringGraphicsDeviceID.length()));
                } else {
                    o_StringBuffer.append(stringGraphicsDeviceID);
                }
                o_StringBuffer.append("</Font>");
                o_StringBuffer.append("</td>");
                o_StringBuffer.append("<td align=center>");
                o_StringBuffer.append(o_GraphicsDeviceDescription.getX());
                o_StringBuffer.append(", ");
                o_StringBuffer.append(o_GraphicsDeviceDescription.getY());
                o_StringBuffer.append("</td>");
                o_StringBuffer.append("<td align=center>");
                o_StringBuffer.append(o_GraphicsDeviceDescription.getWidth());
                o_StringBuffer.append(" x ");
                o_StringBuffer.append(o_GraphicsDeviceDescription.getHeight());
                o_StringBuffer.append("</td>");
            }
        }
        o_StringBuffer.append("</table>");
        o_StringBuffer.append("<br>");
        o_StringBuffer.append("<center>");
        o_StringBuffer.append("<FONT COLOR=\"#000000\">");
        o_StringBuffer.append(CONFIGURATION_REMARK);
        o_StringBuffer.append("</Font>");
        o_StringBuffer.append("</center>");
        if (!SoundMixers.checkSoundCardActivated()) {
            o_StringBuffer.append("<br>");
            o_StringBuffer.append("<center>");
            o_StringBuffer.append("<FONT COLOR=\"#FF0000\">");
            o_StringBuffer.append(SoundMixers.SOUNDMIXERERROR_NOMIXERACTIVATED_REMARK);
            o_StringBuffer.append("</Font>");
            o_StringBuffer.append("</center>");
        }
        o_StringBuffer.append("</html>");
        this.jLabel_Info.setText(o_StringBuffer.toString());
        this.jPanel_MediaSurface1.setRenderSize(this.m_GraphicDeviceDescriptions_Bounds);
        this.revalidate();
        this.repaint();
    }

    public void eventGraphicsDeviceAdded(GraphicsDeviceTools.GraphicsDeviceDescription p_GraphicsDeviceDescription) {
        this.refresh();
    }

    public void eventGraphicsDeviceRemoved(GraphicsDeviceTools.GraphicsDeviceDescription p_GraphicsDeviceDescription) {
        this.refresh();
    }

    public void eventGraphicsDeviceChanged(GraphicsDeviceTools.GraphicsDeviceDescription p_GraphicsDeviceDescription) {
        this.refresh();
    }
}

