/*
 * Decompiled with CFR 0.152.
 */
package MediaObjectPackage;

import CommunicationPackage.MediaServer_Client;
import LiveShowObjectPackage.LiveShowObjectDescription;
import LiveShowObjectPackage.SinglePropertyChangeSupport;
import MainPackage.MediaServer;
import MediaMessagePackage.MediaMessage_VideoAnanlyzerResult;
import MediaObjectPackage.LiveShowMediaObjectDescription;
import MediaObjectPackage.MediaObject_PlayStatus;
import MediaObjectPackage.MediaSource;
import MediaObjectPackage.MediaSourceListener;
import MediaPlayerPackage.FFmpegVideoAnalyzer;
import MediaPlayerPackage.LiveShow_MediaPlayer;
import MediaPlayerPackage.LiveShow_MediaPlayer_Image;
import MediaPlayerPackage.LiveShow_MediaPlayer_Text;
import MediaPlayerPackage.LiveShow_MediaPlayer_Video_FFmpeg;
import MediaPlayerPackage.LiveShow_MediaSurface;
import SynchronizationPackage.LiveCloseSemaphore;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;

public class MediaObject_Server
implements MediaSourceListener,
LiveShow_MediaPlayer.MediaPlayerListener {
    public static ArrayList<MediaObject_Server> s_MediaObjects_VIP = new ArrayList();
    public static ArrayList<MediaObject_Server> s_MediaObjects_Jingle = new ArrayList();
    public static final Object s_SyncMediaObjects = new Object();
    public static final String PROP_CLOSED = "mediaobjectClosed";
    private LiveCloseSemaphore m_LiveCloseSemaphore;
    private MediaServer_Client m_MediaServer_Client;
    private String m_Producer;
    private LiveShowMediaObjectDescription m_LiveShowMediaObjectDescription;
    private MediaSource m_MediaSource;
    private LiveShow_MediaPlayer m_LiveShow_MediaPlayer_0;
    private boolean m_LiveShow_MediaPlayer_0_Ready;
    private LiveShow_MediaPlayer m_LiveShow_MediaPlayer_1;
    private boolean m_LiveShow_MediaPlayer_1_Ready;
    private MediaObject_PlayStatus m_MediaObject_PlayStatus;
    private MediaObject_PlayStatus.ObjectPlayStatus m_ObjectPlayStatus;
    private SinglePropertyChangeSupport m_PropertyChangeSupport;
    private final Object m_SyncPlayStatus = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addMediaObject(String p_Producer, MediaObject_Server p_MediaObject_Server) {
        if (p_Producer == null) {
            return false;
        }
        if (p_MediaObject_Server == null) {
            return false;
        }
        ArrayList<MediaObject_Server> o_MediaObject_Servers = null;
        Object object = s_SyncMediaObjects;
        synchronized (object) {
            switch (p_Producer) {
                case "vip": {
                    o_MediaObject_Servers = s_MediaObjects_VIP;
                    break;
                }
                case "jingle": {
                    o_MediaObject_Servers = s_MediaObjects_Jingle;
                    break;
                }
                default: {
                    o_MediaObject_Servers = null;
                }
            }
            if (o_MediaObject_Servers == null) {
                return false;
            }
            if (o_MediaObject_Servers.contains(p_MediaObject_Server)) {
                return true;
            }
            o_MediaObject_Servers.add(p_MediaObject_Server);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeMediaObject(String p_Producer, MediaObject_Server p_MediaObject_Server) {
        if (p_Producer == null) {
            return false;
        }
        if (p_MediaObject_Server == null) {
            return false;
        }
        ArrayList<MediaObject_Server> o_MediaObject_Servers = null;
        Object object = s_SyncMediaObjects;
        synchronized (object) {
            switch (p_Producer) {
                case "vip": {
                    o_MediaObject_Servers = s_MediaObjects_VIP;
                    break;
                }
                case "jingle": {
                    o_MediaObject_Servers = s_MediaObjects_Jingle;
                    break;
                }
                default: {
                    o_MediaObject_Servers = null;
                }
            }
            if (o_MediaObject_Servers == null) {
                return false;
            }
            o_MediaObject_Servers.remove(p_MediaObject_Server);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MediaObject_Server getMediaObject_Server(String p_Producer, String p_ID) {
        if (p_ID == null) {
            return null;
        }
        if (p_Producer == null) {
            return null;
        }
        Object object = s_SyncMediaObjects;
        synchronized (object) {
            ArrayList<MediaObject_Server> o_MediaObject_Servers;
            switch (p_Producer) {
                case "vip": {
                    o_MediaObject_Servers = s_MediaObjects_VIP;
                    break;
                }
                case "jingle": {
                    o_MediaObject_Servers = s_MediaObjects_Jingle;
                    break;
                }
                default: {
                    o_MediaObject_Servers = null;
                }
            }
            if (o_MediaObject_Servers == null) {
                return null;
            }
            for (int intObject = 0; intObject < o_MediaObject_Servers.size(); ++intObject) {
                MediaObject_Server o_MediaObject_Server = o_MediaObject_Servers.get(intObject);
                if (o_MediaObject_Server == null || !p_ID.equals(o_MediaObject_Server.getID())) continue;
                return o_MediaObject_Server;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<MediaObject_Server> getMediaObjects_Server_Copy(String p_Producer) {
        Object object = s_SyncMediaObjects;
        synchronized (object) {
            switch (p_Producer) {
                case "vip": {
                    ArrayList<MediaObject_Server> o_MediaObject_Servers = new ArrayList<MediaObject_Server>(s_MediaObjects_VIP.size());
                    o_MediaObject_Servers.addAll(s_MediaObjects_VIP);
                    return o_MediaObject_Servers;
                }
                case "jingle": {
                    ArrayList<MediaObject_Server> o_MediaObject_Servers = new ArrayList<MediaObject_Server>(s_MediaObjects_Jingle.size());
                    o_MediaObject_Servers.addAll(s_MediaObjects_Jingle);
                    return o_MediaObject_Servers;
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<MediaObject_Server> getMediaObject_Servers_Copy_ByFile(String p_FileName) {
        ArrayList<MediaObject_Server> o_MediaObject_Servers = new ArrayList<MediaObject_Server>();
        Object object = s_SyncMediaObjects;
        synchronized (object) {
            MediaSource o_MediaSource;
            MediaObject_Server o_MediaObject_Server;
            int intObject;
            for (intObject = 0; intObject < s_MediaObjects_VIP.size(); ++intObject) {
                o_MediaObject_Server = s_MediaObjects_VIP.get(intObject);
                if (o_MediaObject_Server == null || (o_MediaSource = o_MediaObject_Server.getMediaSource()) == null || !o_MediaSource.getFileName().equals(p_FileName)) continue;
                o_MediaObject_Servers.add(o_MediaObject_Server);
            }
            for (intObject = 0; intObject < s_MediaObjects_Jingle.size(); ++intObject) {
                o_MediaObject_Server = s_MediaObjects_Jingle.get(intObject);
                if (o_MediaObject_Server == null || (o_MediaSource = o_MediaObject_Server.getMediaSource()) == null || !o_MediaSource.getFileName().equals(p_FileName)) continue;
                o_MediaObject_Servers.add(o_MediaObject_Server);
            }
        }
        return o_MediaObject_Servers;
    }

    public MediaObject_Server(MediaServer_Client p_MediaServer_Client, String p_Producer, LiveShowMediaObjectDescription p_LiveShowMediaObjectDescription) {
        this.initMembers();
        this.m_MediaServer_Client = p_MediaServer_Client;
        this.m_Producer = p_Producer;
        this.m_LiveShowMediaObjectDescription.copyFrom((LiveShowObjectDescription)p_LiveShowMediaObjectDescription);
        this.m_ObjectPlayStatus.getObjectPlayStatusPlayer_0().setMediaPositionFrame(this.m_LiveShowMediaObjectDescription.getFrameStartOffset());
        this.m_ObjectPlayStatus.getObjectPlayStatusPlayer_1().setMediaPositionFrame(this.m_LiveShowMediaObjectDescription.getFrameStartOffset());
    }

    private void initMembers() {
        this.m_LiveShowMediaObjectDescription = LiveShowMediaObjectDescription.poolGet();
        this.m_PropertyChangeSupport = new SinglePropertyChangeSupport((Object)this);
        this.m_LiveCloseSemaphore = new LiveCloseSemaphore(this.getClass().getSimpleName());
        this.m_MediaSource = null;
        this.m_LiveShow_MediaPlayer_0 = null;
        this.m_LiveShow_MediaPlayer_0_Ready = false;
        this.m_LiveShow_MediaPlayer_1 = null;
        this.m_LiveShow_MediaPlayer_1_Ready = false;
        this.m_MediaObject_PlayStatus = new MediaObject_PlayStatus();
        this.m_ObjectPlayStatus = new MediaObject_PlayStatus.ObjectPlayStatus();
    }

    public void close() {
        if (!this.m_LiveCloseSemaphore.enterCloseSection()) {
            return;
        }
        MediaObject_Server.removeMediaObject(this.m_Producer, this);
        this.m_PropertyChangeSupport.firePropertyChange(PROP_CLOSED, (Object)this, null);
        this.setMediaSource(null);
        this.m_PropertyChangeSupport.clear();
        this.m_LiveShowMediaObjectDescription.close(true);
        this.m_LiveShowMediaObjectDescription = null;
        this.m_LiveCloseSemaphore.leaveCloseSection();
    }

    public void setMediaSource(MediaSource p_MediaSource) {
        LiveShow_MediaPlayer o_LiveShow_MediaPlayer;
        if (this.m_MediaSource == p_MediaSource) {
            return;
        }
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return;
        }
        MediaSource o_MediaSource = this.m_MediaSource;
        if (o_MediaSource != null) {
            o_MediaSource.removeMediaSourceListener((MediaSourceListener)this);
            o_MediaSource.removeReference((Object)this, false);
            o_LiveShow_MediaPlayer = this.m_LiveShow_MediaPlayer_0;
            if (o_LiveShow_MediaPlayer != null) {
                o_LiveShow_MediaPlayer.removeMediaPlayerListener((LiveShow_MediaPlayer.MediaPlayerListener)this);
                o_LiveShow_MediaPlayer.setPlayStatus(0.0f, 0.0f, 0L, false, false);
                o_LiveShow_MediaPlayer.close();
                this.m_LiveShow_MediaPlayer_0_Ready = false;
                this.m_LiveShow_MediaPlayer_0 = null;
            }
            if ((o_LiveShow_MediaPlayer = this.m_LiveShow_MediaPlayer_1) != null) {
                o_LiveShow_MediaPlayer.removeMediaPlayerListener((LiveShow_MediaPlayer.MediaPlayerListener)this);
                o_LiveShow_MediaPlayer.setPlayStatus(0.0f, 0.0f, 0L, false, false);
                o_LiveShow_MediaPlayer.close();
                this.m_LiveShow_MediaPlayer_1_Ready = false;
                this.m_LiveShow_MediaPlayer_1 = null;
            }
        }
        o_MediaSource = this.m_MediaSource = p_MediaSource;
        LiveShowMediaObjectDescription o_LiveShowMediaObjectDescription = this.m_LiveShowMediaObjectDescription;
        if (o_LiveShowMediaObjectDescription == null) {
            o_LiveShowMediaObjectDescription.setMediaType(-1);
        }
        if (o_MediaSource != null) {
            o_MediaSource.addMediaSourceListener((MediaSourceListener)this);
            o_MediaSource.addReference((Object)this);
            if (o_LiveShowMediaObjectDescription.getMediaType() == 1001) {
                this.m_LiveShow_MediaPlayer_0 = LiveShow_MediaPlayer_Image.poolGet((MediaSource)o_MediaSource);
                this.m_LiveShow_MediaPlayer_0.setName("Image 0");
                this.m_LiveShow_MediaPlayer_0.setIndex(0);
                this.m_LiveShow_MediaPlayer_1 = LiveShow_MediaPlayer_Image.poolGet((MediaSource)o_MediaSource);
                this.m_LiveShow_MediaPlayer_1.setName("Image 1");
                this.m_LiveShow_MediaPlayer_1.setIndex(1);
            } else if (o_LiveShowMediaObjectDescription.getMediaType() == 1002) {
                if (MediaSource.s_VideoAnalyzer_ON && o_MediaSource.getMediaType() == 1002 && !o_MediaSource.getVideoAnalyzed()) {
                    FFmpegVideoAnalyzer.VideoAnalyzerResult o_VideoAnalyzerResult = FFmpegVideoAnalyzer.analyzeVideo((File)o_MediaSource.getFile(), (String)"liveSHOW_Media");
                    o_MediaSource.setVideoAnalyzed(true);
                    if (!o_VideoAnalyzerResult.getVideoOK() && this.m_MediaServer_Client != null) {
                        o_VideoAnalyzerResult.setComputerName(MediaServer.getMediaServer_Configuration().getServerName());
                        MediaMessage_VideoAnanlyzerResult o_MediaMessage = new MediaMessage_VideoAnanlyzerResult(o_VideoAnalyzerResult);
                        this.m_MediaServer_Client.sendMessage((Serializable)o_MediaMessage);
                    }
                }
                this.m_LiveShow_MediaPlayer_0 = new LiveShow_MediaPlayer_Video_FFmpeg(o_MediaSource);
                this.m_LiveShow_MediaPlayer_0.setName("Video 0");
                this.m_LiveShow_MediaPlayer_0.setIndex(0);
                this.m_LiveShow_MediaPlayer_1 = new LiveShow_MediaPlayer_Video_FFmpeg(o_MediaSource);
                this.m_LiveShow_MediaPlayer_1.setName("Video 1");
                this.m_LiveShow_MediaPlayer_1.setIndex(1);
            } else if (o_LiveShowMediaObjectDescription.getMediaType() == 1003) {
                this.m_LiveShow_MediaPlayer_0 = LiveShow_MediaPlayer_Text.poolGet((MediaSource)o_MediaSource);
                this.m_LiveShow_MediaPlayer_0.setName("Text 0");
                this.m_LiveShow_MediaPlayer_0.setIndex(0);
                this.m_LiveShow_MediaPlayer_1 = LiveShow_MediaPlayer_Text.poolGet((MediaSource)o_MediaSource);
                this.m_LiveShow_MediaPlayer_1.setName("Text 1");
                this.m_LiveShow_MediaPlayer_1.setIndex(1);
            }
            this.refreshLiveShowMediaObjectDescription(this.m_LiveShowMediaObjectDescription);
            o_LiveShow_MediaPlayer = this.m_LiveShow_MediaPlayer_0;
            if (o_LiveShow_MediaPlayer != null) {
                o_LiveShow_MediaPlayer.addMediaPlayerListener((LiveShow_MediaPlayer.MediaPlayerListener)this);
                o_LiveShow_MediaPlayer.setLiveShow_MediaSurface((LiveShow_MediaSurface)MediaServer.getJFrame_MediaSurface().getJPanel_MediaSurface());
            }
            if ((o_LiveShow_MediaPlayer = this.m_LiveShow_MediaPlayer_1) != null) {
                o_LiveShow_MediaPlayer.addMediaPlayerListener((LiveShow_MediaPlayer.MediaPlayerListener)this);
                o_LiveShow_MediaPlayer.setLiveShow_MediaSurface((LiveShow_MediaSurface)MediaServer.getJFrame_MediaSurface().getJPanel_MediaSurface());
            }
        } else {
            boolean bl = false;
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
    }

    public void changeLiveShowMediaObjectDescription(LiveShowMediaObjectDescription p_LiveShowMediaObjectDescription) {
        if (p_LiveShowMediaObjectDescription == null) {
            return;
        }
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return;
        }
        this.refreshLiveShowMediaObjectDescription(p_LiveShowMediaObjectDescription);
        this.m_LiveCloseSemaphore.leaveWorkerSection();
    }

    public MediaSource getMediaSource() {
        return this.m_MediaSource;
    }

    public void eventReady(LiveShow_MediaPlayer p_LiveShow_MediaPlayer, boolean p_MediaReady) {
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return;
        }
        if (this.m_LiveShow_MediaPlayer_0 == p_LiveShow_MediaPlayer) {
            this.m_LiveShow_MediaPlayer_0_Ready = p_MediaReady;
        }
        if (this.m_LiveShow_MediaPlayer_1 == p_LiveShow_MediaPlayer) {
            this.m_LiveShow_MediaPlayer_1_Ready = p_MediaReady;
        }
        if (this.m_LiveShow_MediaPlayer_0_Ready && this.m_LiveShow_MediaPlayer_1_Ready) {
            this.refreshMediaPlayer();
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
    }

    public void eventError(LiveShow_MediaPlayer p_LiveShow_MediaPlayer, String p_ErrorString) {
    }

    public void eventClose(LiveShow_MediaPlayer p_LiveShow_MediaPlayer) {
        this.m_LiveShow_MediaPlayer_0_Ready = false;
        this.m_LiveShow_MediaPlayer_1_Ready = false;
    }

    public void addPropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
        if (p_PropertyChangeListener == null) {
            return;
        }
        this.m_PropertyChangeSupport.addPropertyChangeListener(p_PropertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
        if (p_PropertyChangeListener == null) {
            return;
        }
        this.m_PropertyChangeSupport.removePropertyChangeListener(p_PropertyChangeListener);
    }

    public MediaServer_Client getMediaServer_Client() {
        return this.m_MediaServer_Client;
    }

    public LiveShowMediaObjectDescription getLiveShowMediaObjectDescription() {
        return this.m_LiveShowMediaObjectDescription;
    }

    public String getID() {
        LiveShowMediaObjectDescription o_LiveShowMediaObjectDescription = this.m_LiveShowMediaObjectDescription;
        if (o_LiveShowMediaObjectDescription == null) {
            return null;
        }
        return o_LiveShowMediaObjectDescription.getID();
    }

    public String getProducer() {
        return this.m_Producer;
    }

    public boolean isCursorPositionInside(long p_FramePosition) {
        return p_FramePosition < this.m_LiveShowMediaObjectDescription.getFrameStart() + this.m_LiveShowMediaObjectDescription.getFrameLength() && p_FramePosition >= this.m_LiveShowMediaObjectDescription.getFrameStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshMediaPlayer() {
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return;
        }
        LiveShow_MediaPlayer o_LiveShow_MediaPlayer_0 = this.m_LiveShow_MediaPlayer_0;
        LiveShow_MediaPlayer o_LiveShow_MediaPlayer_1 = this.m_LiveShow_MediaPlayer_1;
        MediaServer_Client o_MediaServer_Client = this.m_MediaServer_Client;
        if (o_LiveShow_MediaPlayer_0 != null && this.m_LiveShow_MediaPlayer_0_Ready && this.m_LiveShow_MediaPlayer_1_Ready) {
            boolean boolIsPlaying;
            float floatSoundVolume;
            float floatFadeFactor;
            long longPositionMilliseconds;
            MediaObject_PlayStatus.ObjectPlayStatusPlayer o_ObjectPlayStatusPlayer;
            Object object = this.m_SyncPlayStatus;
            synchronized (object) {
                this.m_MediaObject_PlayStatus.setReadPreObject(true);
                o_ObjectPlayStatusPlayer = this.m_ObjectPlayStatus.getObjectPlayStatusPlayer_Pre();
                longPositionMilliseconds = (long)((double)o_ObjectPlayStatusPlayer.getMediaPositionFrame() * this.m_MediaObject_PlayStatus.getFrameTime() + 0.5);
                floatFadeFactor = (float)((double)this.m_MediaObject_PlayStatus.getVolumeFactor() * this.m_MediaObject_PlayStatus.getFadeProgress() * (double)o_ObjectPlayStatusPlayer.getVolumeFactor() * o_ObjectPlayStatusPlayer.getFadeFactor());
                floatSoundVolume = (float)((double)o_LiveShow_MediaPlayer_0.getSoundVolume() * this.m_MediaObject_PlayStatus.getFadeProgress() * o_ObjectPlayStatusPlayer.getFadeFactor());
                if (o_MediaServer_Client != null) {
                    floatFadeFactor *= o_MediaServer_Client.getMainTransparency();
                    floatSoundVolume *= o_MediaServer_Client.getMainSoundVolume();
                }
                boolIsPlaying = o_ObjectPlayStatusPlayer.getIsPlaying();
            }
            if (o_ObjectPlayStatusPlayer.getPlayerIndex() == 0) {
                o_LiveShow_MediaPlayer_0.setPlayStatus(floatFadeFactor, floatSoundVolume, longPositionMilliseconds, boolIsPlaying, this.isCursorPositionInside(this.m_MediaObject_PlayStatus.getFramePosition()));
            } else {
                o_LiveShow_MediaPlayer_1.setPlayStatus(floatFadeFactor, floatSoundVolume, longPositionMilliseconds, boolIsPlaying, this.isCursorPositionInside(this.m_MediaObject_PlayStatus.getFramePosition()));
            }
            object = this.m_SyncPlayStatus;
            synchronized (object) {
                this.m_MediaObject_PlayStatus.setReadPreObject(false);
                o_ObjectPlayStatusPlayer = this.m_ObjectPlayStatus.getObjectPlayStatusPlayer();
                longPositionMilliseconds = (long)((double)o_ObjectPlayStatusPlayer.getMediaPositionFrame() * this.m_MediaObject_PlayStatus.getFrameTime() + 0.5);
                floatFadeFactor = (float)((double)this.m_MediaObject_PlayStatus.getVolumeFactor() * this.m_MediaObject_PlayStatus.getFadeProgress() * (double)o_ObjectPlayStatusPlayer.getVolumeFactor() * o_ObjectPlayStatusPlayer.getFadeFactor());
                floatSoundVolume = (float)((double)o_LiveShow_MediaPlayer_0.getSoundVolume() * this.m_MediaObject_PlayStatus.getFadeProgress() * o_ObjectPlayStatusPlayer.getFadeFactor());
                if (o_MediaServer_Client != null) {
                    floatFadeFactor *= o_MediaServer_Client.getMainTransparency();
                    floatSoundVolume *= o_MediaServer_Client.getMainSoundVolume();
                }
                boolIsPlaying = o_ObjectPlayStatusPlayer.getIsPlaying();
            }
            if (o_ObjectPlayStatusPlayer.getPlayerIndex() == 0) {
                o_LiveShow_MediaPlayer_0.setPlayStatus(floatFadeFactor, floatSoundVolume, longPositionMilliseconds, boolIsPlaying, this.isCursorPositionInside(this.m_MediaObject_PlayStatus.getFramePosition()));
            } else {
                o_LiveShow_MediaPlayer_1.setPlayStatus(floatFadeFactor, floatSoundVolume, longPositionMilliseconds, boolIsPlaying, this.isCursorPositionInside(this.m_MediaObject_PlayStatus.getFramePosition()));
            }
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
    }

    public void refreshLiveShowMediaObjectDescription(LiveShowMediaObjectDescription p_LiveShowMediaObjectDescription) {
        if (p_LiveShowMediaObjectDescription == null) {
            return;
        }
        if (p_LiveShowMediaObjectDescription.getSourceName() == null) {
            return;
        }
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return;
        }
        LiveShowMediaObjectDescription o_LiveShowMediaObjectDescription = this.m_LiveShowMediaObjectDescription;
        if (o_LiveShowMediaObjectDescription != null) {
            LiveShow_MediaPlayer o_LiveShow_MediaPlayer;
            o_LiveShowMediaObjectDescription.copyFrom((LiveShowObjectDescription)p_LiveShowMediaObjectDescription);
            MediaSource o_MediaSource = MediaServer.getMediaSource(o_LiveShowMediaObjectDescription.getSourceName());
            if (o_MediaSource != this.m_MediaSource) {
                if (o_MediaSource != null) {
                    if (o_MediaSource.getCheckSum().equals(p_LiveShowMediaObjectDescription.getCheckSum())) {
                        this.setMediaSource(o_MediaSource);
                        this.m_LiveCloseSemaphore.leaveWorkerSection();
                        return;
                    }
                } else {
                    this.m_LiveShowMediaObjectDescription.setSourceName(p_LiveShowMediaObjectDescription.getSourceName());
                    this.m_LiveShowMediaObjectDescription.setSourceString(p_LiveShowMediaObjectDescription.getSourceString());
                    this.m_MediaServer_Client.checkMediaObject_MediaSource(this);
                }
            }
            if ((o_MediaSource = this.m_MediaSource) != null) {
                if (!o_MediaSource.getCheckSum().equals(p_LiveShowMediaObjectDescription.getCheckSum()) && this.m_MediaServer_Client != null) {
                    this.m_MediaServer_Client.refreshMediaSource(o_MediaSource, p_LiveShowMediaObjectDescription.getSourceString(), p_LiveShowMediaObjectDescription.getCheckSum());
                }
            } else if (this.m_MediaServer_Client != null) {
                MediaServer.RequestMediaSource o_RequestMediaSource = MediaServer.getRequestMediaSource(p_LiveShowMediaObjectDescription.getSourceName());
                if (o_RequestMediaSource == null) {
                    o_RequestMediaSource = new MediaServer.RequestMediaSource(p_LiveShowMediaObjectDescription.getSourceName());
                }
                o_RequestMediaSource.requestMediaSource(this.m_MediaServer_Client, p_LiveShowMediaObjectDescription.getSourceName(), p_LiveShowMediaObjectDescription.getSourceString());
            }
            if ((o_LiveShow_MediaPlayer = this.m_LiveShow_MediaPlayer_0) != null) {
                o_LiveShow_MediaPlayer.setZOrder(o_LiveShowMediaObjectDescription.getMediaZOrder());
                o_LiveShow_MediaPlayer.setRelativePositionSize(o_LiveShowMediaObjectDescription.getMediaRelativePositionSize());
                o_LiveShow_MediaPlayer.setAnchor(o_LiveShowMediaObjectDescription.getMediaAnchor());
                o_LiveShow_MediaPlayer.setFlagAspect(o_LiveShowMediaObjectDescription.getMediaFlagAspect());
                o_LiveShow_MediaPlayer.setFlagSize(o_LiveShowMediaObjectDescription.getMediaFlagSize());
                o_LiveShow_MediaPlayer.setFlagPosition(o_LiveShowMediaObjectDescription.getMediaFlagPosition());
                o_LiveShow_MediaPlayer.setSoundVolume(o_LiveShowMediaObjectDescription.getMediaSoundVolume());
                o_LiveShow_MediaPlayer.setSoundDelay(o_LiveShowMediaObjectDescription.getMediaSoundDelay());
                o_LiveShow_MediaPlayer.setFlipHorizontally(o_LiveShowMediaObjectDescription.getMediaFlipHorizontally());
                o_LiveShow_MediaPlayer.setFlipVertically(o_LiveShowMediaObjectDescription.getMediaFlipVertically());
                o_LiveShow_MediaPlayer.setRotateValue(o_LiveShowMediaObjectDescription.getMediaRotateValue());
            }
            if ((o_LiveShow_MediaPlayer = this.m_LiveShow_MediaPlayer_1) != null) {
                o_LiveShow_MediaPlayer.setZOrder(o_LiveShowMediaObjectDescription.getMediaZOrder());
                o_LiveShow_MediaPlayer.setRelativePositionSize(o_LiveShowMediaObjectDescription.getMediaRelativePositionSize());
                o_LiveShow_MediaPlayer.setAnchor(o_LiveShowMediaObjectDescription.getMediaAnchor());
                o_LiveShow_MediaPlayer.setFlagAspect(o_LiveShowMediaObjectDescription.getMediaFlagAspect());
                o_LiveShow_MediaPlayer.setFlagSize(o_LiveShowMediaObjectDescription.getMediaFlagSize());
                o_LiveShow_MediaPlayer.setFlagPosition(o_LiveShowMediaObjectDescription.getMediaFlagPosition());
                o_LiveShow_MediaPlayer.setSoundVolume(o_LiveShowMediaObjectDescription.getMediaSoundVolume());
                o_LiveShow_MediaPlayer.setSoundDelay(o_LiveShowMediaObjectDescription.getMediaSoundDelay());
                o_LiveShow_MediaPlayer.setFlipHorizontally(o_LiveShowMediaObjectDescription.getMediaFlipHorizontally());
                o_LiveShow_MediaPlayer.setFlipVertically(o_LiveShowMediaObjectDescription.getMediaFlipVertically());
                o_LiveShow_MediaPlayer.setRotateValue(o_LiveShowMediaObjectDescription.getMediaRotateValue());
            }
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
    }

    public void eventMediaSourceInvalidFile(MediaSource p_MediaSource, File p_MediaFile) {
    }

    public void eventMediaSourceOpened(MediaSource p_MediaSource, File p_MediaFile, long p_SectionStart, long p_SectionEnd) {
    }

    public void eventMediaSourceClosing(MediaSource p_MediaSource) {
        this.setMediaSource(null);
    }

    public void eventMediaSourceRefreshing(MediaSource p_MediaSource) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMediaObject_PlayStatus(MediaObject_PlayStatus p_MediaObject_PlayStatus) {
        MediaObject_PlayStatus.ObjectPlayStatus o_ObjectPlayStatus_0 = null;
        boolean boolChanged = false;
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return;
        }
        if ("vip".equals(this.m_Producer)) {
            Object object = this.m_SyncPlayStatus;
            synchronized (object) {
                this.m_MediaObject_PlayStatus.copyHeader_From(p_MediaObject_PlayStatus);
                if (p_MediaObject_PlayStatus != null) {
                    o_ObjectPlayStatus_0 = p_MediaObject_PlayStatus.getObjectPlayStatus(this.m_LiveShowMediaObjectDescription.getID());
                }
                if (o_ObjectPlayStatus_0 == null) {
                    this.m_ObjectPlayStatus.setIsPlaying(false, false);
                    this.m_ObjectPlayStatus.setIsPlaying(false, true);
                } else {
                    this.m_ObjectPlayStatus.copyFrom(o_ObjectPlayStatus_0);
                }
                boolChanged = true;
            }
            if (boolChanged) {
                this.refreshMediaPlayer();
            }
        } else if ("jingle".equals(this.m_Producer)) {
            Object object = this.m_SyncPlayStatus;
            synchronized (object) {
                if (p_MediaObject_PlayStatus != null && (o_ObjectPlayStatus_0 = p_MediaObject_PlayStatus.getObjectPlayStatus(this.m_LiveShowMediaObjectDescription.getID())) != null) {
                    this.m_MediaObject_PlayStatus.copyHeader_From(p_MediaObject_PlayStatus);
                    this.m_ObjectPlayStatus.copyFrom(o_ObjectPlayStatus_0);
                    boolChanged = true;
                }
            }
            if (boolChanged) {
                this.refreshMediaPlayer();
            }
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
    }
}

