/*
 * Decompiled with CFR 0.152.
 */
package MainPackage;

import ClientPackage.LiveDBClient;
import CommunicationPackage.MediaController;
import CommunicationPackage.MediaServer_Client;
import CommunicationPackage.MediaServer_Communication;
import ConfigurationPackage.MediaServer_Configuration;
import ConfigurationPackage.MediaServer_Help;
import FileToolPackage.FileTools;
import GraphicsDeviceToolsPackage.GraphicsDeviceTools;
import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LiveShowNotificationPackage.LiveShowNotification;
import MainThemes.FlatHagi;
import MediaMessagePackage.MediaMessage_RequestMediaSource;
import MediaObjectPackage.MediaObject_Server;
import MediaObjectPackage.MediaSource;
import MediaPackage.JFrame_MediaSurface;
import OS.OSChecker;
import ServerAutoDetectPackage.ServerAutoDetect_Server;
import SocketManagementPackage.LiveDBParserManager;
import SoundPackage.SoundMixers;
import SwingFramePackage.JOptionDialog;
import SynchronizationPackage.EventQueueHandler;
import SynchronizationPackage.JobHandler;
import UserJVMOptionsPackage.UserJVMOptionsChecker;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.ImageIcon;

public class MediaServer {
    public static final String INIFILE_FIELDSEPERATOR = "=";
    public static String CONFIG_FILENAME = "LiveShow_MediaServer.msc";
    public static String MEDIAFOLDER_IMAGES = "MediaServer_Images";
    public static String MEDIAFOLDER_VIDEOS = "MediaServer_Videos";
    public static String MEDIAFOLDER_TEXT = "MediaServer_HTML";
    public static File DEFAULTMEDIADIRECTORY;
    private static boolean s_MediaSourcesLoaded;
    public static final ImageIcon s_ImageIcon;
    public static final Object s_SyncMediaSources;
    public static MediaServer s_SelfReference;
    private String m_MediaServer_Addition;
    private boolean m_FirstStart;
    private MediaServer_Help m_MediaServer_Help;
    private MediaServer_Communication m_MediaServer_Communication;
    private MediaServer_Configuration m_MediaServer_Configuration;
    private JFrame_MediaSurface m_JFrame_MediaSurface;
    private static boolean m_Closing;
    public static boolean s_ReadIni_Active;
    public static final Object s_SyncWriteIni;
    public static ArrayList<RequestMediaSource> s_RequestMediaSources;
    public static final Object s_SyncRequestMediaSources;

    public static void main(String[] args) {
        String stringArg = args == null || args.length <= 0 ? null : args[0];
        final String stringMediaServerArgument = stringArg != null ? (stringArg = FileTools.validateName((String)stringArg)) : null;
        HashMap<String, String> o_MapUserJVMOtions = new HashMap<String, String>();
        long longMemorySize_Min = UserJVMOptionsChecker.calculateMemorySizeMBOfPercent((float)0.3f);
        long longMemorySize_Max = UserJVMOptionsChecker.calculateMemorySizeMBOfPercent((float)0.4f);
        o_MapUserJVMOtions.put("-Dfile.encoding=", "UTF-8");
        o_MapUserJVMOtions.put("-Dsun.jnu.encoding=", "UTF-8");
        o_MapUserJVMOtions.put("-Xms", String.valueOf(longMemorySize_Min) + "m");
        o_MapUserJVMOtions.put("-Xmx", String.valueOf(longMemorySize_Max) + "m");
        o_MapUserJVMOtions.put("-XX:+UseG1GC", "");
        UserJVMOptionsChecker.checkOptions(o_MapUserJVMOtions, (String)stringMediaServerArgument);
        try {
            System.setProperty("jna.encoding", "UTF8");
            FlatHagi.setup();
            JOptionDialog.setTitlePaneIcon(s_ImageIcon);
            if (OSChecker.getOSGroupFlag() == 3) {
                try {
                    String stringApplicationClass = "com.apple.eawt.Application";
                    Class<?> clsApplication = Class.forName(stringApplicationClass);
                    Object o_Application = clsApplication.newInstance().getClass().getMethod("getApplication", new Class[0]).invoke(null, new Object[0]);
                    o_Application.getClass().getMethod("setDockIconImage", Image.class).invoke(o_Application, s_ImageIcon.getImage());
                    String stringAboutHandler = "com.apple.eawt.AboutHandler";
                    Class<?> clsABoutHandler = Class.forName(stringAboutHandler);
                    Class[] interfaceAboutHandler = new Class[]{clsABoutHandler};
                    Object o_AboutHandler = Proxy.newProxyInstance(MediaServer.class.getClassLoader(), interfaceAboutHandler, new InvocationHandler(){

                        @Override
                        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                            String name = method.getName();
                            if (name.equals("handleAbout")) {
                                MediaServer_Configuration.showHelp();
                                return null;
                            }
                            throw new RuntimeException("no method found");
                        }
                    });
                    o_Application.getClass().getMethod("setAboutHandler", clsABoutHandler).invoke(o_Application, o_AboutHandler);
                    String stringQuitHandler = "com.apple.eawt.QuitHandler";
                    Class<?> clsQuitHandler = Class.forName(stringQuitHandler);
                    Class[] interfaceQuitHandler = new Class[]{clsQuitHandler};
                    Object o_QuitHandler = Proxy.newProxyInstance(MediaServer.class.getClassLoader(), interfaceQuitHandler, new InvocationHandler(){

                        @Override
                        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                            String name = method.getName();
                            if (name.equals("handleQuitRequestWith")) {
                                MediaServer_Configuration.s_SelfReference.close();
                                return null;
                            }
                            throw new RuntimeException("no method found");
                        }
                    });
                    o_Application.getClass().getMethod("setQuitHandler", clsQuitHandler).invoke(o_Application, o_QuitHandler);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                GraphicsDeviceTools.refreshGraphicsDevices();
                LiveLanguage.setDefaultLanguageFileBaseName((String)"MediaServer");
                MediaServer o_MediaServer = new MediaServer(stringMediaServerArgument);
            }
        });
    }

    public static void shutdown() {
        try {
            System.out.println("SHUTDOWN COMPUTER");
            String shutdownCommand = null;
            if (OSChecker.getIsMac() || OSChecker.getIsLinux()) {
                shutdownCommand = "shutdown -h now";
            } else if (OSChecker.getIsWindows()) {
                shutdownCommand = "shutdown -s -t 0";
            } else {
                System.out.println("CANNOT SHUTDOWN COMPUTER -> UNKNOWN OS");
            }
            if (shutdownCommand != null) {
                Process process = Runtime.getRuntime().exec(shutdownCommand);
            }
        }
        catch (Exception e) {
            System.out.println("Error Shutdown: " + e.getMessage());
        }
    }

    public static void shutdownRestart() {
        try {
            System.out.println("SHUTDOWN AND RESTART COMPUTER");
            String shutdownCommand = null;
            String operatingSystem = System.getProperty("os.name");
            if (OSChecker.getIsMac() || OSChecker.getIsLinux()) {
                shutdownCommand = "shutdown -r now";
            } else if (OSChecker.getIsWindows()) {
                shutdownCommand = "shutdown -r -t 0";
            } else {
                System.out.println("CANNOT SHUTDOWN AND RESTART COMPUTER -> UNKNOWN OS");
            }
            if (shutdownCommand != null) {
                Process process = Runtime.getRuntime().exec(shutdownCommand);
            }
        }
        catch (Exception e) {
            System.out.println("Error Shutdown and Restart: " + e.getMessage());
        }
    }

    public boolean readIni() {
        String stringIniFile = OSChecker.getPathUserHomeConfigDirectory() + "/MediaServer.ini";
        File o_FileIni = new File(stringIniFile);
        if (!o_FileIni.exists()) {
            return false;
        }
        s_ReadIni_Active = true;
        boolean boolIni = false;
        FileReader o_FileReaderIni = null;
        BufferedReader o_BufferedReader = null;
        try {
            o_FileReaderIni = new FileReader(o_FileIni);
            o_BufferedReader = new BufferedReader(o_FileReaderIni);
            String stringLine = o_BufferedReader.readLine();
            while (stringLine != null) {
                String[] stringValuePair = stringLine.split(INIFILE_FIELDSEPERATOR);
                if (stringValuePair == null) {
                    stringLine = o_BufferedReader.readLine();
                    continue;
                }
                if (stringValuePair.length < 2) {
                    stringLine = o_BufferedReader.readLine();
                    continue;
                }
                if (stringValuePair[1].trim().length() > 0) {
                    String stringPropertyName = stringValuePair[0].trim();
                    String string = stringValuePair[1].trim();
                }
                stringLine = o_BufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (o_BufferedReader != null) {
                o_BufferedReader.close();
            }
            if (o_FileReaderIni != null) {
                o_FileReaderIni.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        s_ReadIni_Active = false;
        return boolIni;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeIni() {
        if (s_ReadIni_Active) {
            return false;
        }
        Object object = s_SyncWriteIni;
        synchronized (object) {
            File o_FileIni;
            boolean boolOK = true;
            String stringIniFile = OSChecker.getPathUserHomeConfigDirectory() + "/MediaServer.ini";
            try {
                o_FileIni = new File(stringIniFile);
                if (o_FileIni.exists()) {
                    boolOK = o_FileIni.delete();
                }
                if (!boolOK) {
                    return false;
                }
            }
            catch (Exception e) {
                return false;
            }
            boolean boolIni = false;
            FileWriter o_FileWriterIni = null;
            BufferedWriter o_BufferedWriter = null;
            try {
                o_FileWriterIni = new FileWriter(o_FileIni);
                o_BufferedWriter = new BufferedWriter(o_FileWriterIni);
                StringBuilder stringBuilder = new StringBuilder();
                boolIni = true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                if (o_BufferedWriter != null) {
                    o_BufferedWriter.flush();
                    o_BufferedWriter.close();
                }
                if (o_FileWriterIni != null) {
                    o_FileWriterIni.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return boolIni;
        }
    }

    public MediaServer(String p_MediaServerAddition) {
        s_SelfReference = this;
        this.m_MediaServer_Addition = p_MediaServerAddition;
        this.initMembers();
        MediaServer.showInformation(true);
        if (this.m_MediaServer_Addition == null || this.m_MediaServer_Addition.length() <= 0) {
            MediaServer.getMediaServer_Communication().setServerPort(15112);
        } else {
            int intInstance = 2;
            try {
                intInstance = Integer.valueOf(p_MediaServerAddition);
            }
            catch (Exception exception) {
                // empty catch block
            }
            MediaServer.getMediaServer_Communication().setServerPort(15111 + intInstance);
        }
        EventQueueHandler.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                MediaServer.this.load();
                MediaServer.refresh();
            }
        });
        try {
            File o_FileErr;
            File o_FileOut = new File(OSChecker.getPathUserHomeConfigDirectory() + File.separator + "logOut.txt");
            if (o_FileOut.exists()) {
                o_FileOut.delete();
            }
            if ((o_FileErr = new File(OSChecker.getPathUserHomeConfigDirectory() + File.separator + "logErr.txt")).exists()) {
                o_FileErr.delete();
            }
            System.setOut(new PrintStream(o_FileOut));
            System.setErr(new PrintStream(o_FileErr));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initMembers() {
        this.m_FirstStart = true;
        m_Closing = false;
        s_MediaSourcesLoaded = false;
        String stringAddition = "";
        if (this.m_MediaServer_Addition != null) {
            stringAddition = this.m_MediaServer_Addition;
        }
        OSChecker.setProgramName((String)(this.getClass().getSimpleName() + stringAddition));
        String stringConfigPath = OSChecker.getPathUserHomeConfigDirectory();
        DEFAULTMEDIADIRECTORY = new File(stringConfigPath);
        LiveDBParserManager.setINIPath((String)(stringConfigPath + File.separator));
        this.readIni();
        SoundMixers.createSoundLinesPreview();
        this.m_MediaServer_Help = new MediaServer_Help();
        this.m_MediaServer_Help.setPreferredSize(new Dimension(500, 600));
        this.m_MediaServer_Communication = new MediaServer_Communication(this, this.m_MediaServer_Addition);
        this.m_MediaServer_Configuration = new MediaServer_Configuration(this, this.m_MediaServer_Communication);
        this.m_MediaServer_Configuration.addWindowFocusListener(this.m_MediaServer_Help);
        this.m_JFrame_MediaSurface = new JFrame_MediaSurface();
        this.m_JFrame_MediaSurface.addWindowFocusListener(this.m_MediaServer_Help);
        this.m_JFrame_MediaSurface.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MediaServer.this.m_MediaServer_Configuration.showConfiguration();
            }
        });
        this.m_JFrame_MediaSurface.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent p_KeyEvent) {
                switch (p_KeyEvent.getKeyCode()) {
                    case 10: 
                    case 27: 
                    case 32: {
                        MediaServer.this.m_MediaServer_Configuration.showConfiguration();
                    }
                }
            }
        });
        MediaServer.getJFrame_MediaSurface().addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                MediaServer.close(false, false);
            }
        });
        this.m_MediaServer_Configuration.refreshGUI_Config();
    }

    public static void close(boolean p_ShutDown, boolean p_Restart) {
        if (!m_Closing) {
            m_Closing = true;
            if (s_SelfReference != null) {
                if (MediaSource.s_Thread_Sweep != null && MediaSource.s_Thread_Sweep.isAlive()) {
                    try {
                        MediaSource.s_Thread_Sweep.join(60000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                MediaServer.s_SelfReference.m_MediaServer_Communication.close();
                MediaServer.s_SelfReference.m_JFrame_MediaSurface.close();
                MediaServer.s_SelfReference.m_MediaServer_Configuration.close();
            }
            ServerAutoDetect_Server.stopServerAutoDetect();
            s_SelfReference = null;
            if (p_ShutDown) {
                MediaServer.shutdown();
            } else if (p_Restart) {
                MediaServer.shutdownRestart();
            }
            System.exit(0);
        }
    }

    public void load() {
        if (s_SelfReference == null) {
            return;
        }
        FileInputStream o_FileInputStream = null;
        ObjectInput o_ObjectInput = null;
        String stringMediaServerAddition = MediaServer.getMediaServer_Addition();
        String stringFileName = stringMediaServerAddition != null && stringMediaServerAddition.length() > 0 ? OSChecker.getPathUserHomeConfigDirectory() + "/" + CONFIG_FILENAME : OSChecker.getPathUserHomeConfigDirectory() + "/" + CONFIG_FILENAME;
        File o_File = new File(stringFileName);
        if (o_File.exists()) {
            this.setFirstStart(false);
            try {
                o_FileInputStream = new FileInputStream(o_File);
                o_ObjectInput = new ObjectInputStream(o_FileInputStream);
                MediaServer.getMediaServer_Communication().readExternal(o_ObjectInput);
                MediaServer.getMediaServer_Configuration().readExternal(o_ObjectInput);
                MediaServer.getMediaServer_Configuration().setConfigurated(true);
                if (MediaServer.getMediaServer_Communication().getWasConnected()) {
                    MediaServer.getMediaServer_Communication().connectServer();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (o_ObjectInput != null) {
                    o_ObjectInput.close();
                }
                if (o_FileInputStream != null) {
                    o_FileInputStream.close();
                }
            }
            catch (Exception exception) {}
        } else {
            MediaServer.getMediaServer_Communication().connectServer();
        }
        MediaServer.getMediaServer_Configuration().refreshGUI_Network();
        MediaServer.getMediaServer_Configuration().refreshGUI_Config();
        MediaServer.getMediaServer_Configuration().showMediaSurface();
        MediaServer.getJFrame_MediaSurface().setGraphicsDevices(MediaServer.getMediaServer_Configuration().getDefaultGraphicsDeviceDescriptions());
        if (!MediaServer.getMediaServer_Communication().getWasConnected()) {
            MediaServer.getMediaServer_Configuration().checkOK();
        }
        if (stringMediaServerAddition == null) {
            MediaServer.getMediaServer_Configuration().startAdditionalInstances();
        }
    }

    public void setFirstStart(boolean p_FirstStarted) {
        this.m_FirstStart = p_FirstStarted;
    }

    public boolean getFirstStart() {
        return this.m_FirstStart;
    }

    public void save() {
        String stringFileName;
        if (s_SelfReference == null) {
            return;
        }
        MediaServer.getJFrame_MediaSurface().setGraphicsDevices(MediaServer.getMediaServer_Configuration().getDefaultGraphicsDeviceDescriptions());
        MediaServer.refresh();
        FileOutputStream o_FileOutputStream = null;
        ObjectOutput o_ObjectOutput = null;
        String stringMediaServerAddition = MediaServer.getMediaServer_Addition();
        if (stringMediaServerAddition != null && stringMediaServerAddition.length() > 0) {
            boolean boolOK = true;
            String stringDirectory = OSChecker.getPathUserHomeConfigDirectory();
            File o_FileDirectory = new File(stringDirectory);
            if (!o_FileDirectory.exists()) {
                try {
                    boolOK = o_FileDirectory.mkdir();
                }
                catch (Exception e) {
                    boolOK = false;
                }
            }
            if (!boolOK) {
                return;
            }
            stringFileName = stringDirectory + "/" + CONFIG_FILENAME;
        } else {
            stringFileName = OSChecker.getPathUserHomeConfigDirectory() + "/" + CONFIG_FILENAME;
        }
        File o_File = new File(stringFileName);
        if (o_File.exists()) {
            try {
                o_File.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            o_FileOutputStream = new FileOutputStream(o_File);
            o_ObjectOutput = new ObjectOutputStream(o_FileOutputStream);
            MediaServer.getMediaServer_Communication().writeExternal(o_ObjectOutput);
            MediaServer.getMediaServer_Configuration().writeExternal(o_ObjectOutput);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (o_ObjectOutput != null) {
                o_ObjectOutput.close();
            }
            if (o_FileOutputStream != null) {
                o_FileOutputStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.writeIni();
    }

    public static void cancel() {
        MediaServer.getJFrame_MediaSurface().setGraphicsDevices(MediaServer.getMediaServer_Configuration().getDefaultGraphicsDeviceDescriptions());
    }

    public static void showInformation(boolean p_Show) {
        MediaServer.s_SelfReference.m_JFrame_MediaSurface.showInformation(p_Show);
    }

    public static void refresh() {
        MediaServer.s_SelfReference.m_JFrame_MediaSurface.refresh();
        if (s_SelfReference.getFirstStart() && MediaServer.s_SelfReference.m_MediaServer_Communication.getIsConnected()) {
            EventQueueHandler.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    s_SelfReference.setFirstStart(false);
                    s_SelfReference.save();
                }
            });
        }
        boolean intTest = false;
    }

    public static String getMediaServer_Addition() {
        return MediaServer.s_SelfReference.m_MediaServer_Addition;
    }

    public static MediaServer_Help getMediaServer_Help() {
        return MediaServer.s_SelfReference.m_MediaServer_Help;
    }

    public static MediaServer_Communication getMediaServer_Communication() {
        return MediaServer.s_SelfReference.m_MediaServer_Communication;
    }

    public static MediaServer_Configuration getMediaServer_Configuration() {
        return MediaServer.s_SelfReference.m_MediaServer_Configuration;
    }

    public static JFrame_MediaSurface getJFrame_MediaSurface() {
        return MediaServer.s_SelfReference.m_JFrame_MediaSurface;
    }

    public ArrayList<GraphicsDeviceTools.GraphicsDeviceDescription> getSelectedGraphicsDeviceDescriptions() {
        return this.m_MediaServer_Configuration.getSelectedGraphicsDeviceDescriptions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadMediaSources() {
        if (DEFAULTMEDIADIRECTORY == null) {
            return;
        }
        Object object = s_SyncMediaSources;
        synchronized (object) {
            MediaSource o_MediaSource;
            File o_File;
            int intFile;
            MediaSource.closeAll();
            ArrayList<File> o_Files = MediaServer.getMediaServerFiles_Images();
            if (o_Files != null) {
                for (intFile = 0; intFile < o_Files.size(); ++intFile) {
                    o_File = o_Files.get(intFile);
                    o_MediaSource = new MediaSource(o_File);
                }
            }
            if ((o_Files = MediaServer.getMediaServerFiles_Videos()) != null) {
                for (intFile = 0; intFile < o_Files.size(); ++intFile) {
                    o_File = o_Files.get(intFile);
                    o_MediaSource = new MediaSource(o_File);
                }
            }
            if ((o_Files = MediaServer.getMediaServerFiles_Text()) != null) {
                for (intFile = 0; intFile < o_Files.size(); ++intFile) {
                    o_File = o_Files.get(intFile);
                    o_MediaSource = new MediaSource(o_File);
                }
            }
            boolean bl = false;
        }
    }

    public static boolean checkDefaultMediaDirectory(File p_Directory) {
        if (p_Directory == null) {
            return false;
        }
        if (!p_Directory.isDirectory()) {
            return false;
        }
        boolean boolWritable = FileTools.checkWritable((File)p_Directory);
        return boolWritable;
    }

    public static boolean setDefaultMediaDirectory(File p_Directory) {
        File oldDirectoryText;
        File oldDirectoryVideos;
        File oldDirectoryImages;
        File newDirectoryText;
        File newDirectoryVideos;
        File newDirectoryImages;
        if (!MediaServer.checkDefaultMediaDirectory(p_Directory)) {
            return false;
        }
        File oldDirectory = DEFAULTMEDIADIRECTORY;
        DEFAULTMEDIADIRECTORY = p_Directory;
        try {
            newDirectoryImages = new File(DEFAULTMEDIADIRECTORY.getAbsolutePath() + File.separator + MEDIAFOLDER_IMAGES);
            if (!newDirectoryImages.exists()) {
                newDirectoryImages.mkdir();
            }
            if (!(newDirectoryVideos = new File(DEFAULTMEDIADIRECTORY.getAbsolutePath() + File.separator + MEDIAFOLDER_VIDEOS)).exists()) {
                newDirectoryVideos.mkdir();
            }
            if (!(newDirectoryText = new File(DEFAULTMEDIADIRECTORY.getAbsolutePath() + File.separator + MEDIAFOLDER_TEXT)).exists()) {
                newDirectoryText.mkdir();
            }
            if (oldDirectory != null && oldDirectory.getAbsolutePath().equals(p_Directory.getAbsolutePath())) {
                if (!s_MediaSourcesLoaded) {
                    MediaServer.loadMediaSources();
                    s_MediaSourcesLoaded = true;
                }
                return true;
            }
            if (oldDirectory != null) {
                oldDirectoryImages = new File(oldDirectory.getAbsolutePath() + File.separator + MEDIAFOLDER_IMAGES);
                oldDirectoryVideos = new File(oldDirectory.getAbsolutePath() + File.separator + MEDIAFOLDER_VIDEOS);
                oldDirectoryText = new File(oldDirectory.getAbsolutePath() + File.separator + MEDIAFOLDER_TEXT);
            } else {
                oldDirectoryImages = null;
                oldDirectoryVideos = null;
                oldDirectoryText = null;
            }
        }
        catch (Exception e) {
            return false;
        }
        Runnable o_RunnableCopyFiles = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = s_SyncMediaSources;
                synchronized (object) {
                    LiveShowNotification o_LiveShowNotification = null;
                    try {
                        MediaController o_MediaController;
                        MediaSource.closeAll();
                        s_MediaSourcesLoaded = false;
                        o_LiveShowNotification = new LiveShowNotification(MediaServer_Configuration.MOVE_MEDIAFILES, 4L, 0L, true);
                        MediaServer_Communication o_MediaServer_Communication = s_SelfReference.m_MediaServer_Communication;
                        if (o_MediaServer_Communication != null && (o_MediaController = o_MediaServer_Communication.getMediaController()) != null) {
                            o_MediaController.closeAllClients();
                        }
                        if (oldDirectoryImages != null) {
                            o_LiveShowNotification.setActionText(MediaServer_Configuration.MOVE_MEDIAIMAGEFILES);
                            if (oldDirectoryImages.exists()) {
                                FileTools.copyFilesTo((File)oldDirectoryImages, (File)newDirectoryImages, (boolean)true, (boolean)true);
                                try {
                                    oldDirectoryImages.delete();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }
                        o_LiveShowNotification.setProgress(1L);
                        if (oldDirectoryVideos != null) {
                            o_LiveShowNotification.setActionText(MediaServer_Configuration.MOVE_MEDIAVIDEOFILES);
                            if (oldDirectoryVideos.exists()) {
                                FileTools.copyFilesTo((File)oldDirectoryVideos, (File)newDirectoryVideos, (boolean)true, (boolean)true);
                                try {
                                    oldDirectoryVideos.delete();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }
                        o_LiveShowNotification.setProgress(2L);
                        if (oldDirectoryText != null) {
                            o_LiveShowNotification.setActionText(MediaServer_Configuration.MOVE_MEDIATEXTFILES);
                            if (oldDirectoryText.exists()) {
                                FileTools.copyFilesTo((File)oldDirectoryText, (File)newDirectoryText, (boolean)true, (boolean)true);
                                try {
                                    oldDirectoryText.delete();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }
                        o_LiveShowNotification.setProgress(3L);
                        o_LiveShowNotification.setText(MediaServer_Configuration.LOAD_MEDIAFILES);
                        o_LiveShowNotification.setActionText("");
                        MediaServer.loadMediaSources();
                        o_LiveShowNotification.setProgress(4L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (o_LiveShowNotification != null) {
                        o_LiveShowNotification.close();
                    }
                }
            }
        };
        JobHandler.addJob((Runnable)o_RunnableCopyFiles);
        return true;
    }

    public static File getMediaServerDirectory_Images() {
        if (DEFAULTMEDIADIRECTORY == null) {
            return null;
        }
        File newDirectoryImages = new File(DEFAULTMEDIADIRECTORY.getAbsolutePath() + File.separator + MEDIAFOLDER_IMAGES);
        if (!newDirectoryImages.exists()) {
            try {
                newDirectoryImages.mkdir();
            }
            catch (Exception e) {
                return null;
            }
        }
        return newDirectoryImages;
    }

    public static String getMediaServerDirectoryPath_Images() {
        if (DEFAULTMEDIADIRECTORY == null) {
            return "";
        }
        return DEFAULTMEDIADIRECTORY.getAbsolutePath() + File.separator + MEDIAFOLDER_IMAGES;
    }

    public static File getMediaServerDirectory_Videos() {
        if (DEFAULTMEDIADIRECTORY == null) {
            return null;
        }
        File newDirectoryVideos = new File(DEFAULTMEDIADIRECTORY.getAbsolutePath() + File.separator + MEDIAFOLDER_VIDEOS);
        if (!newDirectoryVideos.exists()) {
            try {
                newDirectoryVideos.mkdir();
            }
            catch (Exception e) {
                return null;
            }
        }
        return newDirectoryVideos;
    }

    public static String getMediaServerDirectoryPath_Videos() {
        if (DEFAULTMEDIADIRECTORY == null) {
            return "";
        }
        return DEFAULTMEDIADIRECTORY.getAbsolutePath() + File.separator + MEDIAFOLDER_VIDEOS;
    }

    public static File getMediaServerDirectory_Text() {
        if (DEFAULTMEDIADIRECTORY == null) {
            return null;
        }
        File newDirectoryHTML = new File(DEFAULTMEDIADIRECTORY.getAbsolutePath() + File.separator + MEDIAFOLDER_TEXT);
        if (!newDirectoryHTML.exists()) {
            try {
                newDirectoryHTML.mkdir();
            }
            catch (Exception e) {
                return null;
            }
        }
        return newDirectoryHTML;
    }

    public static String getMediaServerDirectoryPath_Text() {
        if (DEFAULTMEDIADIRECTORY == null) {
            return "";
        }
        return DEFAULTMEDIADIRECTORY.getAbsolutePath() + File.separator + MEDIAFOLDER_TEXT;
    }

    public static ArrayList<File> getMediaServerFiles_Images() {
        ArrayList<File> o_ImageFiles = new ArrayList<File>();
        File o_Directory = MediaServer.getMediaServerDirectory_Images();
        if (o_Directory == null) {
            return o_ImageFiles;
        }
        File[] o_CountainedFiles = o_Directory.listFiles();
        if (o_CountainedFiles == null) {
            return o_ImageFiles;
        }
        for (int intFile = 0; intFile < o_CountainedFiles.length; ++intFile) {
            File o_ContainedFile = o_CountainedFiles[intFile];
            if (o_ContainedFile.isDirectory()) continue;
            o_ImageFiles.add(o_ContainedFile);
        }
        return o_ImageFiles;
    }

    public static ArrayList<File> getMediaServerFiles_Videos() {
        ArrayList<File> o_VideoFiles = new ArrayList<File>();
        File o_Directory = MediaServer.getMediaServerDirectory_Videos();
        if (o_Directory == null) {
            return o_VideoFiles;
        }
        File[] o_CountainedFiles = o_Directory.listFiles();
        if (o_CountainedFiles == null) {
            return o_VideoFiles;
        }
        for (int intFile = 0; intFile < o_CountainedFiles.length; ++intFile) {
            File o_ContainedFile = o_CountainedFiles[intFile];
            if (o_ContainedFile.isDirectory()) continue;
            o_VideoFiles.add(o_ContainedFile);
        }
        return o_VideoFiles;
    }

    public static ArrayList<File> getMediaServerFiles_Text() {
        ArrayList<File> o_TextFiles = new ArrayList<File>();
        File o_Directory = MediaServer.getMediaServerDirectory_Text();
        if (o_Directory == null) {
            return o_TextFiles;
        }
        File[] o_CountainedFiles = o_Directory.listFiles();
        if (o_CountainedFiles == null) {
            return o_TextFiles;
        }
        for (int intFile = 0; intFile < o_CountainedFiles.length; ++intFile) {
            File o_ContainedFile = o_CountainedFiles[intFile];
            if (o_ContainedFile.isDirectory()) continue;
            o_TextFiles.add(o_ContainedFile);
        }
        return o_TextFiles;
    }

    public static File getMediaFile(String p_FileName) {
        File o_MediaFile;
        File o_Directory = MediaServer.getMediaServerDirectory_Images();
        if (o_Directory != null && (o_MediaFile = new File(o_Directory.getAbsoluteFile() + File.separator + p_FileName)).exists()) {
            return o_MediaFile;
        }
        o_Directory = MediaServer.getMediaServerDirectory_Videos();
        if (o_Directory != null && (o_MediaFile = new File(o_Directory.getAbsoluteFile() + File.separator + p_FileName)).exists()) {
            return o_MediaFile;
        }
        o_Directory = MediaServer.getMediaServerDirectory_Text();
        if (o_Directory != null && (o_MediaFile = new File(o_Directory.getAbsoluteFile() + File.separator + p_FileName)).exists()) {
            return o_MediaFile;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MediaSource getMediaSource(File p_File) {
        Object object = s_SyncMediaSources;
        synchronized (object) {
            return MediaSource.getMediaSource((File)p_File);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MediaSource getMediaSource(String p_FileName) {
        if (p_FileName == null) {
            return null;
        }
        Object object = s_SyncMediaSources;
        synchronized (object) {
            File o_File = MediaServer.getMediaFile(p_FileName);
            return MediaServer.getMediaSource(o_File);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addRequestMediaSource(RequestMediaSource p_RequestMediaSource) {
        if (p_RequestMediaSource == null) {
            return;
        }
        Object object = s_SyncRequestMediaSources;
        synchronized (object) {
            if (s_RequestMediaSources.contains(p_RequestMediaSource)) {
                return;
            }
            s_RequestMediaSources.add(p_RequestMediaSource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeRequestMediaSource(RequestMediaSource p_RequestMediaSource) {
        if (p_RequestMediaSource == null) {
            return;
        }
        Object object = s_SyncRequestMediaSources;
        synchronized (object) {
            s_RequestMediaSources.remove(p_RequestMediaSource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RequestMediaSource getRequestMediaSource(String p_FileName) {
        if (p_FileName == null) {
            return null;
        }
        Object object = s_SyncRequestMediaSources;
        synchronized (object) {
            for (int intRequest = 0; intRequest < s_RequestMediaSources.size(); ++intRequest) {
                RequestMediaSource o_RequestMediaSource = s_RequestMediaSources.get(intRequest);
                if (!p_FileName.equals(o_RequestMediaSource.getFileName())) continue;
                return o_RequestMediaSource;
            }
        }
        return null;
    }

    static {
        s_MediaSourcesLoaded = false;
        s_ImageIcon = new ImageIcon(MediaServer.class.getResource("/IconPackage/LiveShow_Icon_Media.png"));
        s_SyncMediaSources = new Object();
        m_Closing = false;
        s_ReadIni_Active = false;
        s_SyncWriteIni = new Object();
        s_RequestMediaSources = new ArrayList();
        s_SyncRequestMediaSources = new Object();
    }

    public static class RequestMediaSource
    implements PropertyChangeListener {
        private LiveDBClient m_LiveDBClient;
        private String m_FileName;
        private MediaSource m_MediaSource;
        private ArrayList<MediaObject_Server> m_WaitingMediaObjects;
        private boolean m_Requesting;
        private final Object m_SyncMediaObjects = new Object();

        public RequestMediaSource(String p_FileName) {
            this.initMembers();
            this.m_FileName = p_FileName;
            MediaServer.addRequestMediaSource(this);
        }

        private void initMembers() {
            this.m_WaitingMediaObjects = new ArrayList();
            this.m_Requesting = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            MediaServer.removeRequestMediaSource(this);
            Object object = this.m_SyncMediaObjects;
            synchronized (object) {
                this.m_WaitingMediaObjects.clear();
            }
            this.m_MediaSource = null;
        }

        public String getFileName() {
            return this.m_FileName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addMediaObject(MediaObject_Server p_MediaObject_Server) {
            Object object = this.m_SyncMediaObjects;
            synchronized (object) {
                if (this.m_MediaSource != null) {
                    p_MediaObject_Server.setMediaSource(this.m_MediaSource);
                    return;
                }
                if (this.m_WaitingMediaObjects.contains(p_MediaObject_Server)) {
                    return;
                }
                this.m_WaitingMediaObjects.add(p_MediaObject_Server);
                p_MediaObject_Server.addPropertyChangeListener(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeMediaObject(MediaObject_Server p_MediaObject_Server) {
            if (p_MediaObject_Server == null) {
                return;
            }
            boolean boolClose = false;
            Object object = this.m_SyncMediaObjects;
            synchronized (object) {
                p_MediaObject_Server.removePropertyChangeListener(this);
                this.m_WaitingMediaObjects.remove(p_MediaObject_Server);
                if (this.m_WaitingMediaObjects.size() <= 0) {
                    boolClose = true;
                }
            }
            if (boolClose) {
                Runnable o_RunnableClose = new Runnable(){

                    @Override
                    public void run() {
                        this.setStreamEnd(false, true, false);
                    }
                };
                JobHandler.addJob((Runnable)o_RunnableClose);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void requestMediaSource(MediaServer_Client p_MediaServer_Client, String p_FileName, String p_OriginalPath) {
            if (p_MediaServer_Client == null) {
                return;
            }
            if (p_FileName == null) {
                return;
            }
            if (p_OriginalPath == null) {
                return;
            }
            Object object = this.m_SyncMediaObjects;
            synchronized (object) {
                if (this.m_Requesting) {
                    return;
                }
                this.m_Requesting = true;
            }
            if (this.m_MediaSource != null) {
                this.adviseMediaSource(this.m_MediaSource);
                return;
            }
            ArrayList<MediaObject_Server> o_MediaObject_Servers = MediaObject_Server.getMediaObject_Servers_Copy_ByFile(p_FileName);
            if (o_MediaObject_Servers != null) {
                for (int intMediaObject = 0; intMediaObject < o_MediaObject_Servers.size(); ++intMediaObject) {
                    MediaObject_Server o_MediaObject_Server = o_MediaObject_Servers.get(intMediaObject);
                    if (this.m_WaitingMediaObjects.contains(o_MediaObject_Server)) continue;
                    this.m_WaitingMediaObjects.add(o_MediaObject_Server);
                    o_MediaObject_Server.setMediaSource(null);
                }
            }
            MediaMessage_RequestMediaSource o_Message_RequestMediaSource = new MediaMessage_RequestMediaSource(p_OriginalPath);
            p_MediaServer_Client.sendMessage((Serializable)o_Message_RequestMediaSource);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void adviseMediaSource(MediaSource p_MediaSource) {
            ArrayList<MediaObject_Server> o_MediaObjects;
            this.m_Requesting = false;
            this.m_MediaSource = p_MediaSource;
            if (this.m_MediaSource == null) {
                this.close();
                return;
            }
            Object object = this.m_SyncMediaObjects;
            synchronized (object) {
                o_MediaObjects = new ArrayList<MediaObject_Server>(this.m_WaitingMediaObjects.size());
                o_MediaObjects.addAll(this.m_WaitingMediaObjects);
            }
            for (int intObject = o_MediaObjects.size() - 1; intObject >= 0; --intObject) {
                MediaObject_Server o_MediaObject_Server = (MediaObject_Server)o_MediaObjects.get(intObject);
                o_MediaObject_Server.setMediaSource(this.m_MediaSource);
                this.removeMediaObject(o_MediaObject_Server);
            }
            this.close();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() instanceof MediaObject_Server && "mediaobjectClosed".equals(evt.getPropertyName())) {
                this.removeMediaObject((MediaObject_Server)evt.getSource());
            }
        }

        public void setStreamStarted() {
        }

        public void setStreamEnd(boolean p_OK, boolean p_Cancelled, boolean p_Error) {
            if (p_OK) {
                File o_File = MediaServer.getMediaFile(this.m_FileName);
                MediaSource o_MediaSource = MediaServer.getMediaSource(o_File);
                if (o_MediaSource == null) {
                    o_MediaSource = new MediaSource(o_File);
                } else {
                    o_MediaSource.refresh();
                }
                this.m_MediaSource = o_MediaSource;
                this.adviseMediaSource(this.m_MediaSource);
            } else {
                File o_File = MediaServer.getMediaFile(this.m_FileName);
                MediaSource o_MediaSource = MediaServer.getMediaSource(o_File);
                if (o_MediaSource == null) {
                    o_MediaSource = new MediaSource(o_File);
                }
                this.m_MediaSource = o_MediaSource;
                this.adviseMediaSource(this.m_MediaSource);
            }
        }

        public void setStreamException(Exception e) {
        }
    }
}

