/*
 * Decompiled with CFR 0.152.
 */
package CommunicationPackage;

import ClientPackage.LiveDBClient;
import CommunicationPackage.MediaController;
import MainPackage.MediaServer;
import MediaMessagePackage.MediaMessage_AddLiveShowMediaObject;
import MediaMessagePackage.MediaMessage_MainSoundVolume;
import MediaMessagePackage.MediaMessage_MainTransparency;
import MediaMessagePackage.MediaMessage_MediaObjectChanged;
import MediaMessagePackage.MediaMessage_MediaServerInfo;
import MediaMessagePackage.MediaMessage_PlayStatus;
import MediaMessagePackage.MediaMessage_RefreshMediaSource_Error;
import MediaMessagePackage.MediaMessage_RemoveLiveShowMediaObject;
import MediaMessagePackage.MediaMessage_Sweep;
import MediaObjectPackage.LiveShowMediaObjectDescription;
import MediaObjectPackage.MediaObject_PlayStatus;
import MediaObjectPackage.MediaObject_Server;
import MediaObjectPackage.MediaSource;
import ServerKernelPackage.LiveDBServerKernel;
import SocketManagementPackage.LiveDBStream;
import SocketMessagePackage.LiveDBMessageStreamCancel;
import SocketMessagePackage.LiveDBMessageStreamInfo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;

public class MediaServer_Client {
    private LiveDBClient m_LiveDBClient;
    private File m_StreamOutputFile;
    private FileOutputStream m_FileOutputStream;
    private float m_MainTransparency;
    private float m_MainSoundVolume;

    public MediaServer_Client(LiveDBClient p_LiveDBClient) {
        this.initMembers();
        this.m_LiveDBClient = p_LiveDBClient;
    }

    private void initMembers() {
        this.m_MainTransparency = 1.0f;
        this.m_MainSoundVolume = 1.0f;
    }

    public void close() {
        MediaController o_MediaController = MediaServer.getMediaServer_Communication().getMediaController();
        if (o_MediaController != null) {
            o_MediaController.removeMediaServer_Client(this);
        }
        this.closeMediaObjects();
    }

    public void closeMediaObjects() {
        MediaObject_Server o_MediaObject_Server;
        int intObject;
        ArrayList<MediaObject_Server> o_MediaObject_Servers = MediaObject_Server.getMediaObjects_Server_Copy("vip");
        if (o_MediaObject_Servers != null) {
            for (intObject = o_MediaObject_Servers.size() - 1; intObject >= 0; --intObject) {
                o_MediaObject_Server = o_MediaObject_Servers.get(intObject);
                if (o_MediaObject_Server == null || o_MediaObject_Server.getMediaServer_Client() != this) continue;
                o_MediaObject_Server.close();
            }
        }
        if ((o_MediaObject_Servers = MediaObject_Server.getMediaObjects_Server_Copy("jingle")) != null) {
            for (intObject = o_MediaObject_Servers.size() - 1; intObject >= 0; --intObject) {
                o_MediaObject_Server = o_MediaObject_Servers.get(intObject);
                if (o_MediaObject_Server == null || o_MediaObject_Server.getMediaServer_Client() != this) continue;
                o_MediaObject_Server.close();
            }
        }
    }

    public LiveDBClient getLiveDBClient() {
        return this.m_LiveDBClient;
    }

    public File getDirectory(int p_MediaType) {
        File o_Directory = null;
        if (p_MediaType == 1001) {
            o_Directory = MediaServer.getMediaServerDirectory_Images();
        } else if (p_MediaType == 1002) {
            o_Directory = MediaServer.getMediaServerDirectory_Videos();
        } else if (p_MediaType == 1003) {
            o_Directory = MediaServer.getMediaServerDirectory_Text();
        }
        return o_Directory;
    }

    public File calculateMediaFile(int p_MediaType, String p_FileName) {
        if (p_FileName == null) {
            return null;
        }
        File o_Directory = this.getDirectory(p_MediaType);
        if (o_Directory == null) {
            return null;
        }
        File o_MediaFile = new File(o_Directory.getAbsolutePath() + File.separator + p_FileName);
        return o_MediaFile;
    }

    public void sendMessage(Serializable p_Message) {
        if (p_Message == null) {
            return;
        }
        if (this.m_LiveDBClient == null) {
            return;
        }
        this.m_LiveDBClient.sendMessage(p_Message);
    }

    public void parseAddLiveShowMediaObject(LiveDBClient p_LiveDBClient, MediaMessage_AddLiveShowMediaObject p_MediaMessage_AddLiveShowMediaObject) {
        if (p_LiveDBClient == null) {
            return;
        }
        if (p_MediaMessage_AddLiveShowMediaObject == null) {
            return;
        }
        LiveShowMediaObjectDescription o_LiveShowMediaObjectDescription = p_MediaMessage_AddLiveShowMediaObject.getLiveShowMediaObjectDescription();
        if (o_LiveShowMediaObjectDescription == null) {
            return;
        }
        MediaObject_Server o_MediaObject_Server = MediaObject_Server.getMediaObject_Server(o_LiveShowMediaObjectDescription.getProducer(), o_LiveShowMediaObjectDescription.getID());
        if (o_MediaObject_Server == null && !MediaObject_Server.addMediaObject((o_MediaObject_Server = new MediaObject_Server(this, o_LiveShowMediaObjectDescription.getProducer(), o_LiveShowMediaObjectDescription)).getProducer(), o_MediaObject_Server)) {
            o_MediaObject_Server.close();
            o_MediaObject_Server = null;
        }
        if (o_MediaObject_Server == null) {
            return;
        }
        this.checkMediaObject_MediaSource(o_MediaObject_Server);
    }

    public void checkMediaObject_MediaSource(MediaObject_Server p_MediaObject_Server) {
        if (p_MediaObject_Server == null) {
            return;
        }
        LiveShowMediaObjectDescription o_LiveShowMediaObjectDescription = p_MediaObject_Server.getLiveShowMediaObjectDescription();
        if (o_LiveShowMediaObjectDescription == null) {
            return;
        }
        if (o_LiveShowMediaObjectDescription.getSourceName() == null) {
            return;
        }
        MediaSource o_MediaSource = MediaServer.getMediaSource(o_LiveShowMediaObjectDescription.getSourceName());
        if (o_MediaSource != null) {
            p_MediaObject_Server.setMediaSource(o_MediaSource);
            this.refreshMediaSource(o_MediaSource, o_LiveShowMediaObjectDescription.getSourceString(), o_LiveShowMediaObjectDescription.getCheckSum());
            return;
        }
        MediaServer.RequestMediaSource o_RequestMediaSource = MediaServer.getRequestMediaSource(o_LiveShowMediaObjectDescription.getSourceName());
        if (o_RequestMediaSource == null) {
            o_RequestMediaSource = new MediaServer.RequestMediaSource(o_LiveShowMediaObjectDescription.getSourceName());
        }
        o_RequestMediaSource.addMediaObject(p_MediaObject_Server);
        o_RequestMediaSource.requestMediaSource(this, o_LiveShowMediaObjectDescription.getSourceName(), o_LiveShowMediaObjectDescription.getSourceString());
    }

    public void parseRefreshMediaSource_Error(LiveDBClient p_LiveDBClient, MediaMessage_RefreshMediaSource_Error p_MediaMessage_RefreshMediaSource_Error) {
        if (p_LiveDBClient == null) {
            return;
        }
        if (p_MediaMessage_RefreshMediaSource_Error == null) {
            return;
        }
        int intMediaType = MediaSource.autoDetectMediaType((String)p_MediaMessage_RefreshMediaSource_Error.getFileName());
        File o_OldMediaSourceFile = this.calculateMediaFile(intMediaType, p_MediaMessage_RefreshMediaSource_Error.getFileName());
        MediaSource o_MediaSource = MediaSource.getMediaSource((File)o_OldMediaSourceFile);
        MediaServer.RequestMediaSource o_RequestMediaSource = MediaServer.getRequestMediaSource(p_MediaMessage_RefreshMediaSource_Error.getFileName());
        if (o_RequestMediaSource != null) {
            o_RequestMediaSource.setStreamEnd(false, false, true);
        }
    }

    public void refreshMediaSource(MediaSource p_MediaSource, String p_OriginalPath, String p_OriginalCheckSum) {
        if (p_MediaSource == null) {
            return;
        }
        if (p_OriginalPath == null) {
            return;
        }
        if (p_OriginalCheckSum == null) {
            return;
        }
        String stringNewCheckSum = p_MediaSource.getCheckSum();
        if (stringNewCheckSum != null && stringNewCheckSum.equals(p_OriginalCheckSum)) {
            return;
        }
        MediaServer.RequestMediaSource o_RequestMediaSource = MediaServer.getRequestMediaSource(p_MediaSource.getFileName());
        if (o_RequestMediaSource == null) {
            o_RequestMediaSource = new MediaServer.RequestMediaSource(p_MediaSource.getFileName());
        }
        o_RequestMediaSource.requestMediaSource(this, p_MediaSource.getFileName(), p_OriginalPath);
    }

    public void parseRemoveLiveShowMediaObject(LiveDBClient p_LiveDBClient, MediaMessage_RemoveLiveShowMediaObject p_MediaMessage_RemoveLiveShowMediaObject) {
        if (p_LiveDBClient == null) {
            return;
        }
        if (p_MediaMessage_RemoveLiveShowMediaObject == null) {
            return;
        }
        LiveShowMediaObjectDescription o_LiveShowMediaObjectDescription = p_MediaMessage_RemoveLiveShowMediaObject.getLiveShowMediaObjectDescription();
        if (o_LiveShowMediaObjectDescription == null) {
            return;
        }
        MediaObject_Server o_MediaObject_Server = MediaObject_Server.getMediaObject_Server(o_LiveShowMediaObjectDescription.getProducer(), o_LiveShowMediaObjectDescription.getID());
        if (o_MediaObject_Server == null) {
            return;
        }
        o_MediaObject_Server.close();
    }

    public void parseMessageMediaObjectChanged(LiveDBClient p_LiveDBClient, MediaMessage_MediaObjectChanged p_MediaMessage_MediaObjectChanged) {
        if (p_LiveDBClient == null) {
            return;
        }
        if (p_MediaMessage_MediaObjectChanged == null) {
            return;
        }
        LiveShowMediaObjectDescription o_LiveShowMediaObjectDescription = p_MediaMessage_MediaObjectChanged.getLiveShowMediaObjectDescription();
        if (o_LiveShowMediaObjectDescription == null) {
            return;
        }
        MediaObject_Server o_MediaObject_Server = MediaObject_Server.getMediaObject_Server(o_LiveShowMediaObjectDescription.getProducer(), o_LiveShowMediaObjectDescription.getID());
        if (o_MediaObject_Server == null) {
            return;
        }
        o_MediaObject_Server.changeLiveShowMediaObjectDescription(o_LiveShowMediaObjectDescription);
    }

    public void parseMessagePlayStatus(LiveDBClient p_LiveDBClient, MediaMessage_PlayStatus p_MediaMessage_PlayStatus) {
        if (p_LiveDBClient == null) {
            return;
        }
        if (p_MediaMessage_PlayStatus == null) {
            return;
        }
        String stringProducer = p_MediaMessage_PlayStatus.getProducer();
        ArrayList<MediaObject_Server> o_MediaObject_Servers = MediaObject_Server.getMediaObjects_Server_Copy(stringProducer);
        if (o_MediaObject_Servers == null) {
            return;
        }
        MediaObject_PlayStatus o_MediaObject_PlayStatus = p_MediaMessage_PlayStatus.getObjectPlayStatus_0();
        for (int intObject = 0; intObject < o_MediaObject_Servers.size(); ++intObject) {
            MediaObject_Server o_MediaObject_Server = o_MediaObject_Servers.get(intObject);
            if (o_MediaObject_Server == null) continue;
            o_MediaObject_Server.setMediaObject_PlayStatus(o_MediaObject_PlayStatus);
        }
    }

    public void parseMessageMainTransparency(LiveDBClient p_LiveDBClient, MediaMessage_MainTransparency p_MediaMessage_MainVolume) {
        if (p_LiveDBClient == null) {
            return;
        }
        if (p_MediaMessage_MainVolume == null) {
            return;
        }
        this.setMainTransparency(p_MediaMessage_MainVolume.getMainTransparency());
    }

    public void setMainTransparency(float p_MainTransparency) {
        MediaObject_Server o_MediaObject_Server;
        int intObject;
        if (p_MainTransparency < 0.0f) {
            p_MainTransparency = 0.0f;
        }
        if (p_MainTransparency > 1.0f) {
            p_MainTransparency = 1.0f;
        }
        if (this.m_MainTransparency == p_MainTransparency) {
            return;
        }
        this.m_MainTransparency = p_MainTransparency;
        ArrayList<MediaObject_Server> o_MediaObject_Servers = MediaObject_Server.getMediaObjects_Server_Copy("vip");
        if (o_MediaObject_Servers != null) {
            for (intObject = o_MediaObject_Servers.size() - 1; intObject >= 0; --intObject) {
                o_MediaObject_Server = o_MediaObject_Servers.get(intObject);
                if (o_MediaObject_Server == null || o_MediaObject_Server.getMediaServer_Client() != this) continue;
                o_MediaObject_Server.refreshMediaPlayer();
            }
        }
        if ((o_MediaObject_Servers = MediaObject_Server.getMediaObjects_Server_Copy("jingle")) != null) {
            for (intObject = o_MediaObject_Servers.size() - 1; intObject >= 0; --intObject) {
                o_MediaObject_Server = o_MediaObject_Servers.get(intObject);
                if (o_MediaObject_Server == null || o_MediaObject_Server.getMediaServer_Client() != this) continue;
                o_MediaObject_Server.refreshMediaPlayer();
            }
        }
    }

    public float getMainTransparency() {
        return this.m_MainTransparency;
    }

    public void parseMessageMainSoundVolume(LiveDBClient p_LiveDBClient, MediaMessage_MainSoundVolume p_MediaMessage_MainSoundVolume) {
        if (p_LiveDBClient == null) {
            return;
        }
        this.setMainSoundVolume(p_MediaMessage_MainSoundVolume.getMainSoundVolume());
    }

    public void setMainSoundVolume(float p_MainSoundVolume) {
        MediaObject_Server o_MediaObject_Server;
        int intObject;
        if (p_MainSoundVolume < 0.0f) {
            p_MainSoundVolume = 0.0f;
        }
        if (p_MainSoundVolume > 1.0f) {
            p_MainSoundVolume = 1.0f;
        }
        if (this.m_MainSoundVolume == p_MainSoundVolume) {
            return;
        }
        this.m_MainSoundVolume = p_MainSoundVolume;
        ArrayList<MediaObject_Server> o_MediaObject_Servers = MediaObject_Server.getMediaObjects_Server_Copy("vip");
        if (o_MediaObject_Servers != null) {
            for (intObject = o_MediaObject_Servers.size() - 1; intObject >= 0; --intObject) {
                o_MediaObject_Server = o_MediaObject_Servers.get(intObject);
                if (o_MediaObject_Server == null || o_MediaObject_Server.getMediaServer_Client() != this) continue;
                o_MediaObject_Server.refreshMediaPlayer();
            }
        }
        if ((o_MediaObject_Servers = MediaObject_Server.getMediaObjects_Server_Copy("jingle")) != null) {
            for (intObject = o_MediaObject_Servers.size() - 1; intObject >= 0; --intObject) {
                o_MediaObject_Server = o_MediaObject_Servers.get(intObject);
                if (o_MediaObject_Server == null || o_MediaObject_Server.getMediaServer_Client() != this) continue;
                o_MediaObject_Server.refreshMediaPlayer();
            }
        }
    }

    public float getMainSoundVolume() {
        return this.m_MainSoundVolume;
    }

    public void sendMediaServerInfo() {
        MediaMessage_MediaServerInfo o_MediaMessage_MediaServerInfo = new MediaMessage_MediaServerInfo(MediaServer.getJFrame_MediaSurface().getSize());
        this.sendMessage((Serializable)o_MediaMessage_MediaServerInfo);
    }

    public void parseMessageSweep(LiveDBClient p_LiveDBClient, MediaMessage_Sweep p_MediaMessage_Sweep) {
    }

    public void parseMessageIncomingStreamStart(LiveDBClient p_LiveDBClient, LiveDBStream p_IncomingStream, LiveDBMessageStreamInfo p_StreamInfo) {
        if (p_LiveDBClient != this.m_LiveDBClient) {
            return;
        }
        if (p_StreamInfo.getInternalHandled()) {
            return;
        }
        String stringFileName = p_StreamInfo.getRemark();
        File o_StreamFile = this.calculateMediaFile(p_StreamInfo.getDataType(), stringFileName);
        MediaServer.RequestMediaSource o_RequestMediaSource = MediaServer.getRequestMediaSource(stringFileName);
        if (o_StreamFile == null) {
            this.m_StreamOutputFile = null;
            String stringCancelRemark = "Could not create file: " + stringFileName;
            this.cancelStream(p_IncomingStream, p_StreamInfo.getStreamID(), stringFileName, stringCancelRemark);
            if (o_RequestMediaSource != null) {
                o_RequestMediaSource.setStreamException(new Exception(stringCancelRemark));
                o_RequestMediaSource.setStreamEnd(false, true, true);
            }
            return;
        }
        if (o_StreamFile.exists()) {
            boolean boolDeleted = false;
            try {
                boolDeleted = o_StreamFile.delete();
            }
            catch (Exception e) {
                boolDeleted = false;
            }
            if (!boolDeleted) {
                String stringCancelRemark = "Could not delete old file: " + stringFileName;
                this.cancelStream(p_IncomingStream, p_StreamInfo.getStreamID(), stringFileName, stringCancelRemark);
                if (o_RequestMediaSource != null) {
                    o_RequestMediaSource.setStreamException(new Exception(stringCancelRemark));
                    o_RequestMediaSource.setStreamEnd(false, true, true);
                }
                return;
            }
        }
        this.m_StreamOutputFile = o_StreamFile;
        try {
            this.m_FileOutputStream = new FileOutputStream(this.m_StreamOutputFile);
            LiveDBServerKernel.createIncomingStream((LiveDBClient)p_LiveDBClient, (LiveDBMessageStreamInfo)p_StreamInfo, (OutputStream)this.m_FileOutputStream);
        }
        catch (Exception e) {
            this.cancelStream(p_IncomingStream, p_StreamInfo.getStreamID(), stringFileName, e.getMessage());
            if (o_RequestMediaSource != null) {
                o_RequestMediaSource.setStreamException(e);
                o_RequestMediaSource.setStreamEnd(false, true, true);
            }
            return;
        }
        if (o_RequestMediaSource != null) {
            o_RequestMediaSource.setStreamStarted();
        }
    }

    public void cancelStream(LiveDBStream p_IncomingStream, String p_StreamID, String p_FileName, String p_CancelRemark) {
        if (p_IncomingStream != null) {
            p_IncomingStream.cancel(p_CancelRemark);
        } else {
            LiveDBMessageStreamCancel o_LiveDBMessageStreamCancel = new LiveDBMessageStreamCancel(p_StreamID, p_CancelRemark);
            this.sendMessage((Serializable)o_LiveDBMessageStreamCancel);
        }
    }

    public void parseMessageIncomingStreamEnd(LiveDBClient p_LiveDBClient, LiveDBStream p_IncomingStream, boolean p_EndOfStream, boolean p_Cancelled, boolean p_Error, String p_CancelRemark) {
        FileOutputStream o_FileOutputStream = (FileOutputStream)p_IncomingStream.getOutputStream();
        String stringFileName = p_IncomingStream.getRemark();
        MediaServer.RequestMediaSource o_RequestMediaSource = MediaServer.getRequestMediaSource(stringFileName);
        if (p_Cancelled || p_Error) {
            try {
                o_FileOutputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (this.m_StreamOutputFile != null) {
                    this.m_StreamOutputFile.delete();
                }
            }
            catch (Exception exception) {}
        } else if (p_EndOfStream) {
            try {
                o_FileOutputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (o_RequestMediaSource != null) {
            o_RequestMediaSource.setStreamEnd(p_EndOfStream, p_Cancelled, p_Error);
        }
        this.m_StreamOutputFile = null;
    }

    public void parseMessageIncomingStreamPackage(LiveDBClient p_LiveDBClient, LiveDBStream p_IncomingStream, long p_ReceivedBytesCount) {
    }
}

