/*
 * Decompiled with CFR 0.152.
 */
package LiveDBSerializingPackage;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class LiveDBObjectSerializing {
    public static <T extends Serializable> ByteBuffer serialize(T p_Object) throws IOException {
        ObjectOutputStream o_ObjectOutputStream = null;
        ByteArrayOutputStream o_ByteArrayOutputStream = null;
        ByteBuffer o_ByteBuffer = null;
        if (p_Object == null) {
            throw new IOException();
        }
        try {
            o_ByteArrayOutputStream = new ByteArrayOutputStream();
            o_ObjectOutputStream = new ObjectOutputStream(o_ByteArrayOutputStream);
            o_ObjectOutputStream.writeObject(p_Object);
            o_ObjectOutputStream.flush();
            o_ObjectOutputStream.close();
            o_ObjectOutputStream = null;
        }
        catch (IOException e) {
            if (o_ByteArrayOutputStream != null) {
                o_ByteArrayOutputStream.close();
                o_ByteArrayOutputStream = null;
            }
            if (o_ObjectOutputStream != null) {
                o_ObjectOutputStream.close();
                o_ObjectOutputStream = null;
            }
            throw e;
        }
        o_ByteBuffer = ByteBuffer.wrap(o_ByteArrayOutputStream.toByteArray());
        o_ByteBuffer.rewind();
        o_ByteBuffer.limit(o_ByteBuffer.capacity());
        return o_ByteBuffer;
    }

    public static <T extends Serializable> void serialize(T p_Object, FileOutputStream p_FileStream) throws FileNotFoundException, IOException {
        ByteBuffer o_ByteBuffer = null;
        ByteBuffer o_ByteBufferLength = null;
        if (p_Object == null) {
            throw new IOException("No Object");
        }
        if (p_FileStream == null) {
            throw new IOException("No File");
        }
        o_ByteBuffer = LiveDBObjectSerializing.serialize(p_Object);
        int intByteBufferLength = o_ByteBuffer.capacity();
        if (intByteBufferLength == 0) {
            throw new IOException("No serialized object exists");
        }
        o_ByteBufferLength = ByteBuffer.allocate(4);
        o_ByteBufferLength.clear();
        o_ByteBufferLength.putInt(intByteBufferLength);
        p_FileStream.write(o_ByteBufferLength.array());
        o_ByteBufferLength = null;
        p_FileStream.write(o_ByteBuffer.array());
        o_ByteBuffer = null;
    }
}

