/*
 * Decompiled with CFR 0.152.
 */
package TextPackage;

import SynchronizationPackage.EventQueueHandler;
import java.awt.Color;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.ChangedCharSetException;
import javax.swing.text.EditorKit;
import javax.swing.text.rtf.RTFEditorKit;

public class MediaTextDocument
implements PropertyChangeListener {
    private JEditorPane m_JEditorPane_Load;
    private EditorKit m_EditorKit;
    private boolean m_IsText_RTF;
    private ArrayList<LoadListener> m_LoadListeners;
    private final Object m_SyncListeners = new Object();
    private Dimension m_ViewSize;
    private boolean m_Closed;
    private MediaTextDocument m_SelfReference;
    private final Object m_SyncImage = new Object();

    public MediaTextDocument() {
        this.m_SelfReference = this;
        this.initMembers();
        this.initComponents();
    }

    private void initMembers() {
        this.m_Closed = false;
        this.m_LoadListeners = new ArrayList();
        this.m_ViewSize = new Dimension(0, 0);
        this.m_IsText_RTF = false;
    }

    private void initComponents() {
        this.m_JEditorPane_Load = new JEditorPane();
        this.m_JEditorPane_Load.setBackground(Color.BLACK);
        this.m_JEditorPane_Load.setOpaque(false);
        this.m_JEditorPane_Load.setBorder(null);
        this.m_JEditorPane_Load.addPropertyChangeListener(this);
        this.m_JEditorPane_Load.getDocument().putProperty("IgnoreCharsetDirective", new Boolean(true));
        this.m_JEditorPane_Load.getDocument().putProperty("i18n", new Boolean(false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.m_Closed) {
            return;
        }
        this.m_Closed = true;
        try {
            Object object = this.m_SyncImage;
            synchronized (object) {
                if (this.m_JEditorPane_Load != null) {
                    this.m_JEditorPane_Load.removePropertyChangeListener(this);
                    this.m_JEditorPane_Load = null;
                }
            }
        }
        catch (Exception e) {
            boolean bl = false;
        }
    }

    public void calculateRenderSize() {
        EventQueueHandler.invokeLater((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = MediaTextDocument.this.m_SyncImage;
                synchronized (object) {
                    JEditorPane o_JEditorPane_Load = MediaTextDocument.this.m_JEditorPane_Load;
                    if (o_JEditorPane_Load == null) {
                        MediaTextDocument.this.m_ViewSize.setSize(0, 0);
                        MediaTextDocument.this.notifyLoaded();
                        return;
                    }
                    Dimension o_TextSize = MediaTextDocument.this.m_EditorKit instanceof RTFEditorKit ? o_JEditorPane_Load.getPreferredScrollableViewportSize() : o_JEditorPane_Load.getPreferredScrollableViewportSize();
                    MediaTextDocument.this.m_ViewSize.setSize((int)(o_TextSize.getWidth() + 0.5), (int)(o_TextSize.getHeight() + 0.5));
                    o_JEditorPane_Load.setBounds(0, 0, ((MediaTextDocument)MediaTextDocument.this).m_ViewSize.width, ((MediaTextDocument)MediaTextDocument.this).m_ViewSize.height);
                }
                MediaTextDocument.this.notifyLoaded();
            }
        });
    }

    public Dimension getViewSize() {
        return this.m_ViewSize;
    }

    public Object getSyncImage() {
        return this.m_SyncImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(File p_TextFile) {
        JEditorPane o_JEditorPane;
        if (p_TextFile == null) {
            return;
        }
        this.m_ViewSize.setSize(0, 0);
        if (this.m_JEditorPane_Load == null) {
            this.initComponents();
        }
        URL o_Url = null;
        InputStream o_InputStream = null;
        Object object = this.m_SyncImage;
        synchronized (object) {
            o_JEditorPane = this.m_JEditorPane_Load;
            if (o_JEditorPane == null) {
                return;
            }
        }
        try {
            try {
                o_JEditorPane.getDocument().putProperty("IgnoreCharsetDirective", true);
                this.m_IsText_RTF = p_TextFile.getName().toLowerCase().indexOf("rtf") >= 0;
                o_Url = p_TextFile.toURI().toURL();
                URLConnection o_URLConnection = o_Url.openConnection();
                o_InputStream = o_URLConnection.getInputStream();
                String stringContentType = o_URLConnection.getContentType();
                if (stringContentType.toLowerCase().indexOf("unknown") >= 0) {
                    if (this.m_IsText_RTF) {
                        stringContentType = "application/rtf";
                    } else {
                        object = this.m_SyncImage;
                        synchronized (object) {
                            o_JEditorPane.getDocument().remove(0, o_JEditorPane.getDocument().getLength());
                        }
                        this.notifyLoaded();
                        return;
                    }
                }
                object = this.m_SyncImage;
                synchronized (object) {
                    this.m_EditorKit = this.m_IsText_RTF ? o_JEditorPane.getEditorKitForContentType(stringContentType) : o_JEditorPane.getEditorKitForContentType(stringContentType);
                    o_JEditorPane.setEditorKit(this.m_EditorKit);
                    String stringCharset = (String)o_JEditorPane.getClientProperty("charset");
                    InputStreamReader o_Reader = stringCharset != null ? new InputStreamReader(o_InputStream, stringCharset) : new InputStreamReader(o_InputStream);
                    o_JEditorPane.getDocument().remove(0, o_JEditorPane.getDocument().getLength());
                    o_JEditorPane.getEditorKit().read(o_Reader, o_JEditorPane.getDocument(), 0);
                }
            }
            catch (ChangedCharSetException changedCharSetException) {
                String charSetSpec = changedCharSetException.getCharSetSpec();
                Object object2 = this.m_SyncImage;
                synchronized (object2) {
                    block42: {
                        if (changedCharSetException.keyEqualsCharSet()) {
                            o_JEditorPane.putClientProperty("charset", charSetSpec);
                        } else {
                            try {
                                HeaderParser o_HeaderParser;
                                String charset;
                                int semi = charSetSpec.indexOf(59);
                                if (semi > -1 && semi < charSetSpec.length() - 1) {
                                    charSetSpec = charSetSpec.substring(semi + 1);
                                }
                                if (charSetSpec.length() > 0 && (charset = (o_HeaderParser = new HeaderParser(charSetSpec)).findValue("charset")) != null) {
                                    o_JEditorPane.putClientProperty("charset", charset);
                                }
                            }
                            catch (IndexOutOfBoundsException semi) {
                            }
                            catch (NullPointerException semi) {
                            }
                            catch (Exception e) {
                                System.err.println("JEditorPane.getCharsetFromContentTypeParameters failed on: " + charSetSpec);
                                e.printStackTrace();
                            }
                        }
                        try {
                            o_InputStream.reset();
                        }
                        catch (IOException exception) {
                            o_InputStream.close();
                            if (o_Url != null) {
                                URLConnection conn = o_Url.openConnection();
                                o_InputStream = conn.getInputStream();
                                break block42;
                            }
                            throw changedCharSetException;
                        }
                    }
                    Object object3 = this.m_SyncImage;
                    synchronized (object3) {
                        try {
                            o_JEditorPane.getDocument().remove(0, o_JEditorPane.getDocument().getLength());
                        }
                        catch (BadLocationException conn) {
                            // empty catch block
                        }
                        o_JEditorPane.getDocument().putProperty("IgnoreCharsetDirective", true);
                        String charset = (String)o_JEditorPane.getClientProperty("charset");
                        InputStreamReader r = charset != null ? new InputStreamReader(o_InputStream, charset) : new InputStreamReader(o_InputStream);
                        o_JEditorPane.getEditorKit().read(r, o_JEditorPane.getDocument(), 0);
                    }
                }
            }
            catch (Exception errorLoad) {
                boolean intTest = false;
                this.notifyLoaded();
            }
            if (o_InputStream != null) {
                o_InputStream.close();
            }
            this.calculateRenderSize();
        }
        catch (Exception e) {
            this.notifyLoaded();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.m_JEditorPane_Load && "page".equals(evt.getPropertyName())) {
            this.calculateRenderSize();
        }
    }

    public boolean getIsRTF() {
        return this.m_IsText_RTF;
    }

    public JEditorPane getJEditorPane() {
        return this.m_JEditorPane_Load;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLoadListener(LoadListener p_LoadListener) {
        if (p_LoadListener == null) {
            return;
        }
        Object object = this.m_SyncListeners;
        synchronized (object) {
            if (this.m_LoadListeners.contains(p_LoadListener)) {
                return;
            }
            this.m_LoadListeners.add(p_LoadListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLoadListener(LoadListener p_LoadListener) {
        if (p_LoadListener == null) {
            return;
        }
        Object object = this.m_SyncListeners;
        synchronized (object) {
            this.m_LoadListeners.remove(p_LoadListener);
        }
    }

    private void notifyLoaded() {
        this.notifyLoadedListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyLoadedListeners() {
        ArrayList<LoadListener> o_LoadListeners;
        Object object = this.m_SyncListeners;
        synchronized (object) {
            o_LoadListeners = new ArrayList<LoadListener>(this.m_LoadListeners.size());
            o_LoadListeners.addAll(this.m_LoadListeners);
        }
        for (int intListener = 0; intListener < o_LoadListeners.size(); ++intListener) {
            LoadListener o_LoadListener = (LoadListener)o_LoadListeners.get(intListener);
            o_LoadListener.eventLoaded(this.m_SelfReference);
        }
    }

    static class HeaderParser {
        String raw;
        String[][] tab;

        public HeaderParser(String raw) {
            this.raw = raw;
            this.tab = new String[10][2];
            this.parse();
        }

        private void parse() {
            if (this.raw != null) {
                this.raw = this.raw.trim();
                char[] ca = this.raw.toCharArray();
                int beg = 0;
                int end = 0;
                int i = 0;
                boolean inKey = true;
                boolean inQuote = false;
                int len = ca.length;
                while (end < len) {
                    char c = ca[end];
                    if (c == '=') {
                        this.tab[i][0] = new String(ca, beg, end - beg).toLowerCase();
                        inKey = false;
                        beg = ++end;
                        continue;
                    }
                    if (c == '\"') {
                        if (inQuote) {
                            this.tab[i++][1] = new String(ca, beg, end - beg);
                            inQuote = false;
                            while (++end < len && (ca[end] == ' ' || ca[end] == ',')) {
                            }
                            inKey = true;
                            beg = end;
                            continue;
                        }
                        inQuote = true;
                        beg = ++end;
                        continue;
                    }
                    if (c == ' ' || c == ',') {
                        if (inQuote) {
                            ++end;
                            continue;
                        }
                        if (inKey) {
                            this.tab[i++][0] = new String(ca, beg, end - beg).toLowerCase();
                        } else {
                            this.tab[i++][1] = new String(ca, beg, end - beg);
                        }
                        while (end < len && (ca[end] == ' ' || ca[end] == ',')) {
                            ++end;
                        }
                        inKey = true;
                        beg = end;
                        continue;
                    }
                    ++end;
                }
                if (--end > beg) {
                    if (!inKey) {
                        this.tab[i++][1] = ca[end] == '\"' ? new String(ca, beg, end - beg) : new String(ca, beg, end - beg + 1);
                    } else {
                        this.tab[i][0] = new String(ca, beg, end - beg + 1).toLowerCase();
                    }
                } else if (end == beg) {
                    if (!inKey) {
                        this.tab[i++][1] = ca[end] == '\"' ? String.valueOf(ca[end - 1]) : String.valueOf(ca[end]);
                    } else {
                        this.tab[i][0] = String.valueOf(ca[end]).toLowerCase();
                    }
                }
            }
        }

        public String findKey(int i) {
            if (i < 0 || i > 10) {
                return null;
            }
            return this.tab[i][0];
        }

        public String findValue(int i) {
            if (i < 0 || i > 10) {
                return null;
            }
            return this.tab[i][1];
        }

        public String findValue(String key) {
            return this.findValue(key, null);
        }

        public String findValue(String k, String Default) {
            if (k == null) {
                return Default;
            }
            k = k.toLowerCase();
            for (int i = 0; i < 10; ++i) {
                if (this.tab[i][0] == null) {
                    return Default;
                }
                if (!k.equals(this.tab[i][0])) continue;
                return this.tab[i][1];
            }
            return Default;
        }

        public int findInt(String k, int Default) {
            try {
                return Integer.parseInt(this.findValue(k, String.valueOf(Default)));
            }
            catch (Throwable t) {
                return Default;
            }
        }
    }

    public static interface LoadListener {
        public void eventLoaded(MediaTextDocument var1);
    }
}

