/*
 * Decompiled with CFR 0.152.
 */
package TextPackage;

import java.awt.Dimension;
import javax.swing.text.BoxView;
import javax.swing.text.ComponentView;
import javax.swing.text.Element;
import javax.swing.text.IconView;
import javax.swing.text.LabelView;
import javax.swing.text.ParagraphView;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.rtf.RTFEditorKit;

public class MediaRTFEditorKit
extends RTFEditorKit {
    private BoxView m_BoxView;

    @Override
    public ViewFactory getViewFactory() {
        return new StyledViewFactory();
    }

    public View getView() {
        return this.m_BoxView;
    }

    public float getPrefferedSpan(int p_Axis) {
        if (this.m_BoxView == null) {
            return 1.0f;
        }
        return this.m_BoxView.getPreferredSpan(p_Axis);
    }

    public float getMaximumdSpan(int p_Axis) {
        if (this.m_BoxView == null) {
            return 1.0f;
        }
        return this.m_BoxView.getMaximumSpan(p_Axis);
    }

    public float getMinimumSpan(int p_Axis) {
        if (this.m_BoxView == null) {
            return 1.0f;
        }
        return this.m_BoxView.getMinimumSpan(p_Axis);
    }

    public Dimension getPrefferedSpan() {
        Dimension o_Dimension = new Dimension(0, 0);
        o_Dimension.setSize(this.getMaximumdSpan(0), this.getMaximumdSpan(1));
        o_Dimension.setSize(this.getMinimumSpan(0), this.getMinimumSpan(1));
        o_Dimension.setSize(this.getPrefferedSpan(0), this.getPrefferedSpan(1));
        return o_Dimension;
    }

    public static class MediaBoxView
    extends BoxView {
        public MediaBoxView(Element p_Element, int p_Axis) {
            super(p_Element, p_Axis);
        }

        @Override
        protected void layoutMajorAxis(int targetSpan, int axis, int[] offsets, int[] spans) {
            long preferred = 0L;
            int n = this.getViewCount();
            for (int i = 0; i < n; ++i) {
                View v = this.getView(i);
                spans[i] = (int)v.getPreferredSpan(axis);
                preferred += (long)spans[i];
            }
            long desiredAdjustment = (long)targetSpan - preferred;
            float adjustmentFactor = 0.0f;
            int[] diffs = null;
            if (desiredAdjustment != 0L) {
                long totalSpan = 0L;
                diffs = new int[n];
                for (int i = 0; i < n; ++i) {
                    int tmp;
                    View v = this.getView(i);
                    if (desiredAdjustment < 0L) {
                        tmp = (int)v.getMinimumSpan(axis);
                        diffs[i] = spans[i] - tmp;
                    } else {
                        tmp = (int)v.getMaximumSpan(axis);
                        diffs[i] = tmp - spans[i];
                    }
                    totalSpan += (long)tmp;
                }
                float maximumAdjustment = Math.abs(totalSpan - preferred);
                adjustmentFactor = (float)desiredAdjustment / maximumAdjustment;
                adjustmentFactor = Math.min(adjustmentFactor, 1.0f);
                adjustmentFactor = Math.max(adjustmentFactor, -1.0f);
            }
            int totalOffset = 0;
            for (int i = 0; i < n; ++i) {
                offsets[i] = totalOffset;
                if (desiredAdjustment != 0L) {
                    float adjF = adjustmentFactor * (float)diffs[i];
                    int n2 = i;
                    spans[n2] = spans[n2] + Math.round(adjF);
                }
                totalOffset = (int)Math.min((long)totalOffset + (long)spans[i], Integer.MAX_VALUE);
            }
        }

        @Override
        protected void layoutMinorAxis(int targetSpan, int axis, int[] offsets, int[] spans) {
            int n = this.getViewCount();
            for (int i = 0; i < n; ++i) {
                View v = this.getView(i);
                int max = (int)v.getMaximumSpan(axis);
                if (max < targetSpan) {
                    float align = v.getAlignment(axis);
                    offsets[i] = (int)((float)(targetSpan - max) * align);
                    spans[i] = max;
                    continue;
                }
                int min = (int)v.getMinimumSpan(axis);
                offsets[i] = 0;
                spans[i] = Math.max(min, targetSpan);
            }
        }
    }

    class StyledViewFactory
    implements ViewFactory {
        StyledViewFactory() {
        }

        @Override
        public View create(Element elem) {
            String kind = elem.getName();
            if (kind != null) {
                if (kind.equals("content")) {
                    return new LabelView(elem);
                }
                if (kind.equals("paragraph")) {
                    return new ParagraphView(elem);
                }
                if (kind.equals("section")) {
                    MediaRTFEditorKit.this.m_BoxView = new MediaBoxView(elem, 1);
                    return MediaRTFEditorKit.this.m_BoxView;
                }
                if (kind.equals("component")) {
                    return new ComponentView(elem);
                }
                if (kind.equals("icon")) {
                    return new IconView(elem);
                }
            }
            return new LabelView(elem);
        }
    }
}

