/*
 * Decompiled with CFR 0.152.
 */
package MediaToolsPackage;

import FileToolPackage.FileSelection;
import FileToolPackage.FileTools;
import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LanguageTools.LiveLanguagePackage.LiveLanguageString;
import LiveShowObjectPackage.TimeString;
import MediaObjectPackage.MediaSource;
import MediaPlayerPackage.FFmpeg_VideoFrameConverter;
import OS.OSChecker;
import SoundPackage.SoundMixers;
import SwingFramePackage.JOptionDialog;
import SwingModelPackage.TableAndListModel;
import SwingTextPackage.DocumentFilter_Double;
import SwingTextPackage.DocumentFilter_Integer;
import SwingToolTipPackage.PopUpToolTip;
import SynchronizationPackage.EventQueueHandler;
import ToolsGraphics.ImagesTools;
import ToolsGraphics.JLabel_ResizeFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.sound.sampled.AudioFormat;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.text.JTextComponent;
import org.bytedeco.ffmpeg.ffmpeg;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacv.FFmpegFrameGrabber;
import org.bytedeco.javacv.Frame;
import org.bytedeco.javacv.FrameGrabber;
import org.bytedeco.javacv.Java2DFrameConverter;

public class Media_VideoConverter
extends JPanel {
    public static final String INIFILE_NAME = OSChecker.getPathUserHomeConfigDirectory() + "/Media_VideoConverter.ini";
    public static final String INIFILE_FIELDSEPERATOR = "=";
    public static File s_LastOpenFilePath = null;
    public static File s_LastSaveFilePath = null;
    private static BufferedImage s_BufferedImage_Sound = ImagesTools.convertToBufferedImage((Icon)new ImageIcon(Media_VideoConverter.class.getResource("/IconsPackage/Loudspeaker_128.png")));
    @LiveLanguageString
    public static String FILE_LOAD_TITLE = "Load Input File (Video/Sound)";
    @LiveLanguageString
    public static String FILE_LOAD_INPROGRESS = "File is loading";
    @LiveLanguageString
    public static String FILE_LOAD_ERROR = "The file could not be loaded";
    @LiveLanguageString
    public static String VIDEOSAVE_TITLE = "Save Video File";
    @LiveLanguageString
    public static String AUDIOSAVE_TITLE = "Save Audio File";
    @LiveLanguageString
    public static String FILE_CONVERTING_ERROR = "File could not be converted";
    @LiveLanguageString
    public static String FILE_CONVERTING_PROGRESS = "Converting...";
    @LiveLanguageString
    public static String FILE_CONVERTING_SUCCESS = "File is successfully converted";
    @LiveLanguageString
    public static String FILEEXISTS_TITLE = "file already exists";
    @LiveLanguageString
    public static String FILEEXISTS_MESSAGE = "Overwrite existing file?";
    @LiveLanguageString
    public static String FILEINUSE_TITLE = "The file is currently in use!";
    @LiveLanguageString
    public static String FILEINUSE_MESSAGE = "<html>Choose another file/folder<br>or close the used file instances.</html>";
    @LiveLanguageString
    public static String FILENOTWRITABLE_TITLE = "You do not have write permission!";
    @LiveLanguageString
    public static String FILENOTWRITABLE_MESSAGE = "<html>Select another folder.</html>";
    @LiveLanguageString
    public static String ENCODE_QUALITY_LOW = "Standard Quality (fast)";
    @LiveLanguageString
    public static String ENCODE_QUALITY_VP9_MIDDLE = "MIddle Quality (slow)";
    @LiveLanguageString
    public static String ENCODE_QUALITY_VP9_HIGH = "High Quality (slow)";
    @LiveLanguageString
    public static String ENCODE_QUALITY_VP9_VERYHIGH = "Very High Quality (slow)";
    public static Dimension SNAPAHOT_SIZE = new Dimension(100, 100);
    private File m_File_Input;
    private File m_File_Output;
    private FFmpegFrameGrabber m_FFmpegFrameGrabber;
    private boolean m_Status_IsLoading;
    private boolean m_Status_LoadSuccess;
    private boolean m_Status_IsVideoConverting;
    private boolean m_Status_IsAudioConverting;
    private boolean m_Status_ConvertSuccess;
    private boolean m_Status_ConvertWasStarted;
    private long m_Duration;
    private int m_VideoWidth_Origin;
    private int m_VideoHeight_Origin;
    private double m_VideoAspectRatio_Origin;
    private double m_VideoAspectRatio_New;
    private double m_VideoFrameRate_Origin;
    private int m_VideoWidth_New;
    private int m_VideoHeight_New;
    private double m_VideoFrameRate_New;
    private boolean m_VideoReplaceAlphaChannel;
    private AudioFormat m_AudioFormat_Output;
    private AudioFormat m_AudioFormat_Input;
    private BufferedImage m_BufferedImage_First;
    private BufferedImage m_BufferedImage_Middle;
    private BufferedImage m_BufferedImage_Last;
    private Java2DFrameConverter m_Java2DFrameConverter;
    private Thread m_Thread_Convert;
    private boolean m_Status_ConvertCancelled;
    private final Object m_SyncConvert = new Object();
    private Process m_ProcessConvert;
    private EncodeQualityModel m_EncodeQualityModel;
    private StringBuilder m_StringBuilder_Output;
    private static boolean s_ReadIniActive = false;
    public static final Object s_SyncWriteIni = new Object();
    public static FileNameExtensionFilter s_FileNameExtensionFilter_MP4 = FileSelection.createFileNameExtensionFilter((String)"Video (.mp4)", (String[])new String[]{".mp4"});
    public static FileNameExtensionFilter s_FileNameExtensionFilter_MOV = FileSelection.createFileNameExtensionFilter((String)"Quicktime Animation (.mov)", (String[])new String[]{".mov"});
    public static FileNameExtensionFilter s_FileNameExtensionFilter_WAV = FileSelection.createFileNameExtensionFilter((String)"Audio (.wav)", (String[])new String[]{".wav"});
    private ButtonGroup buttonGroup_AudioChannels;
    private ButtonGroup buttonGroup_VideoFrameRate;
    private JButton jButton_ConvertAudio;
    private JButton jButton_ConvertAudioCancel;
    private JButton jButton_ConvertVideo;
    private JButton jButton_ConvertVideoCancel;
    private JButton jButton_Load;
    private JCheckBox jCheckBox_VideoRemoveAlphaChannel;
    private JComboBox<String> jComboBox_VideoQuality;
    private JLabel jLabel_Audio;
    private JLabel jLabel_AudioChannels_Header;
    private JLabel jLabel_AudioChannels_Origin;
    private JLabel jLabel_AudioSampleRate_Header;
    private JLabel jLabel_AudioSampleRate_Origin;
    private JLabel jLabel_AudioSampleRate_Output;
    private JLabel jLabel_ConvertStatus;
    private JLabel jLabel_FileDirectory_Input;
    private JLabel jLabel_FileDirectory_Input_Header;
    private JLabel jLabel_FileDirectory_Output;
    private JLabel jLabel_FileDirectory_Output_Header;
    private JLabel jLabel_FileDuration_Input;
    private JLabel jLabel_FileDuration_Input_Header;
    private JLabel jLabel_FileName_Input;
    private JLabel jLabel_FileName_Input_Header;
    private JLabel jLabel_FileName_Output;
    private JLabel jLabel_FileName_Output_Header;
    private JLabel jLabel_ImageFirst;
    private JLabel jLabel_ImageLast;
    private JLabel jLabel_ImageMiddle;
    private JLabel jLabel_Input;
    private JLabel jLabel_Output;
    private JLabel_ResizeFrame jLabel_ResizeFrame1;
    private JLabel jLabel_Video;
    private JLabel jLabel_VideoArrow;
    private JLabel jLabel_VideoAspectRatio_Header;
    private JLabel jLabel_VideoAspectRatio_Origin;
    private JLabel jLabel_VideoFrameRate_Header;
    private JLabel jLabel_VideoFrameRate_Origin;
    private JLabel jLabel_VideoHeight_Header;
    private JLabel jLabel_VideoHeight_Origin;
    private JLabel jLabel_VideoQualityHeader;
    private JLabel jLabel_VideoWidth_Header;
    private JLabel jLabel_VideoWidth_Origin;
    private JPanel jPanel_AudioChannels;
    private JPanel jPanel_FileSave;
    private JPanel jPanel_Output;
    private JPanel jPanel_Screenshot;
    private JPanel jPanel_VideoFile;
    private JPanel jPanel_VideoFrameRate;
    private JPanel jPanel_VideoProperties;
    private JRadioButton jRadioButton_AudioChannels_0;
    private JRadioButton jRadioButton_AudioChannels_1;
    private JRadioButton jRadioButton_AudioChannels_10;
    private JRadioButton jRadioButton_AudioChannels_2;
    private JRadioButton jRadioButton_AudioChannels_6;
    private JRadioButton jRadioButton_AudioChannels_8;
    private JRadioButton jRadioButton_VideoFrameRate_25;
    private JRadioButton jRadioButton_VideoFrameRate_30;
    private JRadioButton jRadioButton_VideoFrameRate_60;
    private JScrollPane jScrollPane1;
    private JTextField jTextField_VideoAspectRatio_New;
    private JTextField jTextField_VideoHeight_New;
    private JTextField jTextField_VideoWidth_New;
    private JTextPane jTextPane_FFmpegOutput;

    public Media_VideoConverter() {
        this.initMembers();
        this.initComponents();
        this.initComponentsFurther();
        LiveLanguage.addLanguageListener((Object)this, null);
        this.m_EncodeQualityModel.addElement(ENCODE_QUALITY_LOW);
        this.m_EncodeQualityModel.addElement(ENCODE_QUALITY_VP9_MIDDLE);
        this.m_EncodeQualityModel.addElement(ENCODE_QUALITY_VP9_HIGH);
        this.m_EncodeQualityModel.addElement(ENCODE_QUALITY_VP9_VERYHIGH);
        this.jComboBox_VideoQuality.setSelectedIndex(2);
        this.resetParams();
        this.refresh();
    }

    private void initMembers() {
        this.m_Java2DFrameConverter = new Java2DFrameConverter();
        this.m_Status_ConvertCancelled = false;
        this.m_Status_IsVideoConverting = false;
        this.m_Status_IsAudioConverting = false;
        this.m_Status_ConvertSuccess = true;
        this.m_Status_ConvertWasStarted = false;
        this.m_Status_IsLoading = false;
        this.m_Status_LoadSuccess = true;
        this.m_AudioFormat_Input = null;
        this.m_ProcessConvert = null;
        this.setOutputAudioFormat(SoundMixers.DEFAULT_AUDIOFORMAT);
        this.m_StringBuilder_Output = new StringBuilder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Thread o_Thread_ConvertVideo;
        this.m_Status_ConvertCancelled = true;
        this.m_Status_ConvertWasStarted = false;
        Object object = this.m_SyncConvert;
        synchronized (object) {
            o_Thread_ConvertVideo = this.m_Thread_Convert;
        }
        if (o_Thread_ConvertVideo != null) {
            try {
                o_Thread_ConvertVideo.join(2000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        object = this.m_SyncConvert;
        synchronized (object) {
            if (this.m_FFmpegFrameGrabber != null) {
                try {
                    this.m_FFmpegFrameGrabber.stop();
                    this.m_FFmpegFrameGrabber.close();
                    this.m_FFmpegFrameGrabber = null;
                }
                catch (FrameGrabber.Exception exception) {
                    // empty catch block
                }
            }
            this.resetParams();
            this.refresh();
        }
    }

    private void resetParams() {
        this.m_File_Input = null;
        this.m_File_Output = null;
        this.m_Duration = 0L;
        this.m_VideoWidth_Origin = 0;
        this.m_VideoHeight_Origin = 0;
        this.m_VideoFrameRate_Origin = 0.0;
        this.m_VideoAspectRatio_Origin = 1.0;
        this.m_VideoAspectRatio_New = 1.0;
        this.m_VideoWidth_New = 0;
        this.m_VideoHeight_New = 0;
        this.m_VideoFrameRate_New = 0.0;
        this.m_VideoReplaceAlphaChannel = false;
        this.m_StringBuilder_Output.delete(0, this.m_StringBuilder_Output.length());
        this.jTextPane_FFmpegOutput.setText(this.m_StringBuilder_Output.toString());
    }

    public static boolean readIni() {
        File o_FileIni = new File(INIFILE_NAME);
        if (!o_FileIni.exists()) {
            return false;
        }
        s_ReadIniActive = true;
        boolean boolIni = false;
        FileReader o_FileReaderIni = null;
        BufferedReader o_BufferedReader = null;
        try {
            o_FileReaderIni = new FileReader(o_FileIni);
            o_BufferedReader = new BufferedReader(o_FileReaderIni);
            String stringLine = o_BufferedReader.readLine();
            while (stringLine != null) {
                String[] stringValuePair = stringLine.split(INIFILE_FIELDSEPERATOR);
                if (stringValuePair == null) {
                    stringLine = o_BufferedReader.readLine();
                    continue;
                }
                if (stringValuePair.length < 2) {
                    stringLine = o_BufferedReader.readLine();
                    continue;
                }
                if (stringValuePair[1].trim().length() > 0) {
                    String stringPropertyName = stringValuePair[0].trim();
                    String stringPropertyValue = stringValuePair[1].trim();
                    if (stringPropertyName.trim().equals("LastMediaConverterPath")) {
                        File o_FileLastPath = new File(stringPropertyValue);
                        if (!o_FileLastPath.exists()) {
                            o_FileLastPath = null;
                        }
                        s_LastOpenFilePath = o_FileLastPath;
                        boolIni = true;
                    }
                }
                stringLine = o_BufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (o_BufferedReader != null) {
                o_BufferedReader.close();
            }
            if (o_FileReaderIni != null) {
                o_FileReaderIni.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        s_ReadIniActive = false;
        return boolIni;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeIni() {
        if (s_ReadIniActive) {
            return false;
        }
        Object object = s_SyncWriteIni;
        synchronized (object) {
            File o_FileIni;
            boolean boolOK = true;
            try {
                o_FileIni = new File(INIFILE_NAME);
                if (o_FileIni.exists()) {
                    boolOK = o_FileIni.delete();
                }
                if (!boolOK) {
                    return false;
                }
            }
            catch (Exception e) {
                System.err.println("ERROR PlayMedia writeIni() - delete ini file:");
                e.printStackTrace();
                return false;
            }
            boolean boolIni = false;
            FileWriter o_FileWriterIni = null;
            BufferedWriter o_BufferedWriter = null;
            try {
                o_FileWriterIni = new FileWriter(o_FileIni);
                o_BufferedWriter = new BufferedWriter(o_FileWriterIni);
                StringBuilder stringBuilder = new StringBuilder();
                String stringLastPath = null;
                File o_LastFile = s_LastOpenFilePath;
                if (o_LastFile != null) {
                    try {
                        stringLastPath = o_LastFile.getAbsolutePath();
                    }
                    catch (Exception e) {
                        stringLastPath = null;
                    }
                }
                if (stringLastPath != null) {
                    stringBuilder.delete(0, stringBuilder.length());
                    stringBuilder.append("LastMediaConverterPath");
                    stringBuilder.append(INIFILE_FIELDSEPERATOR);
                    stringBuilder.append(stringLastPath);
                    stringBuilder.append(INIFILE_FIELDSEPERATOR);
                    stringBuilder.append("the last path where a media file is converted");
                    o_BufferedWriter.append(stringBuilder.toString());
                    o_BufferedWriter.newLine();
                }
                boolIni = true;
            }
            catch (IOException e_IOException) {
                System.err.println("ERROR PlayDMX writeIni():");
                e_IOException.printStackTrace();
            }
            try {
                if (o_BufferedWriter != null) {
                    o_BufferedWriter.flush();
                    o_BufferedWriter.close();
                }
                if (o_FileWriterIni != null) {
                    o_FileWriterIni.close();
                }
            }
            catch (IOException e_IOException) {
                System.err.println("ERROR PlayDMX writeIni() - close ini file:");
                e_IOException.printStackTrace();
            }
            return boolIni;
        }
    }

    private void initComponents() {
        this.buttonGroup_VideoFrameRate = new ButtonGroup();
        this.buttonGroup_AudioChannels = new ButtonGroup();
        this.jLabel_ResizeFrame1 = new JLabel_ResizeFrame();
        this.jPanel_VideoFile = new JPanel();
        this.jLabel_FileName_Input = new JLabel();
        this.jLabel_FileName_Input_Header = new JLabel();
        this.jLabel_FileDirectory_Input = new JLabel();
        this.jLabel_FileDirectory_Input_Header = new JLabel();
        this.jLabel_Input = new JLabel();
        this.jLabel_FileDuration_Input_Header = new JLabel();
        this.jLabel_FileDuration_Input = new JLabel();
        this.jPanel_Screenshot = new JPanel();
        this.jLabel_ImageFirst = new JLabel();
        this.jLabel_ImageMiddle = new JLabel();
        this.jLabel_ImageLast = new JLabel();
        this.jPanel_VideoProperties = new JPanel();
        this.jLabel_VideoHeight_Header = new JLabel();
        this.jLabel_VideoHeight_Origin = new JLabel();
        this.jTextField_VideoHeight_New = new JTextField();
        this.jLabel_VideoWidth_Header = new JLabel();
        this.jLabel_VideoWidth_Origin = new JLabel();
        this.jTextField_VideoWidth_New = new JTextField();
        this.jLabel_VideoAspectRatio_Header = new JLabel();
        this.jLabel_VideoAspectRatio_Origin = new JLabel();
        this.jLabel_VideoFrameRate_Header = new JLabel();
        this.jLabel_VideoFrameRate_Origin = new JLabel();
        this.jLabel_Video = new JLabel();
        this.jLabel_VideoArrow = new JLabel();
        this.jPanel_VideoFrameRate = new JPanel();
        this.jRadioButton_VideoFrameRate_25 = new JRadioButton();
        this.jRadioButton_VideoFrameRate_30 = new JRadioButton();
        this.jRadioButton_VideoFrameRate_60 = new JRadioButton();
        this.jLabel_AudioChannels_Header = new JLabel();
        this.jLabel_AudioSampleRate_Header = new JLabel();
        this.jLabel_AudioSampleRate_Origin = new JLabel();
        this.jLabel_AudioChannels_Origin = new JLabel();
        this.jLabel_Audio = new JLabel();
        this.jLabel_AudioSampleRate_Output = new JLabel();
        this.jPanel_AudioChannels = new JPanel();
        this.jRadioButton_AudioChannels_2 = new JRadioButton();
        this.jRadioButton_AudioChannels_6 = new JRadioButton();
        this.jRadioButton_AudioChannels_8 = new JRadioButton();
        this.jRadioButton_AudioChannels_1 = new JRadioButton();
        this.jRadioButton_AudioChannels_0 = new JRadioButton();
        this.jRadioButton_AudioChannels_10 = new JRadioButton();
        this.jComboBox_VideoQuality = new JComboBox();
        this.jLabel_VideoQualityHeader = new JLabel();
        this.jTextField_VideoAspectRatio_New = new JTextField();
        this.jCheckBox_VideoRemoveAlphaChannel = new JCheckBox();
        this.jPanel_FileSave = new JPanel();
        this.jLabel_FileName_Output = new JLabel();
        this.jLabel_FileName_Output_Header = new JLabel();
        this.jLabel_FileDirectory_Output = new JLabel();
        this.jLabel_FileDirectory_Output_Header = new JLabel();
        this.jLabel_Output = new JLabel();
        this.jLabel_ConvertStatus = new JLabel();
        this.jPanel_Output = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTextPane_FFmpegOutput = new JTextPane();
        this.jButton_Load = new JButton();
        this.jButton_ConvertVideo = new JButton();
        this.jButton_ConvertVideoCancel = new JButton();
        this.jButton_ConvertAudio = new JButton();
        this.jButton_ConvertAudioCancel = new JButton();
        this.setMinimumSize(new Dimension(470, 480));
        this.setPreferredSize(new Dimension(500, 450));
        this.setLayout(new GridBagLayout());
        this.jLabel_ResizeFrame1.setToolTipText("");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 14;
        this.add((Component)this.jLabel_ResizeFrame1, gridBagConstraints);
        this.jPanel_VideoFile.setLayout(new GridBagLayout());
        this.jLabel_FileName_Input.setFont(new Font("Tahoma", 0, 12));
        this.jLabel_FileName_Input.setHorizontalAlignment(0);
        this.jLabel_FileName_Input.setText("Filename");
        this.jLabel_FileName_Input.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_VideoFile.add((Component)this.jLabel_FileName_Input, gridBagConstraints);
        this.jLabel_FileName_Input_Header.setText("Name:");
        this.jLabel_FileName_Input_Header.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_VideoFile.add((Component)this.jLabel_FileName_Input_Header, gridBagConstraints);
        this.jLabel_FileDirectory_Input.setHorizontalAlignment(0);
        this.jLabel_FileDirectory_Input.setText("FilePath");
        this.jLabel_FileDirectory_Input.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_VideoFile.add((Component)this.jLabel_FileDirectory_Input, gridBagConstraints);
        this.jLabel_FileDirectory_Input_Header.setText("Directory:");
        this.jLabel_FileDirectory_Input_Header.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_VideoFile.add((Component)this.jLabel_FileDirectory_Input_Header, gridBagConstraints);
        this.jLabel_Input.setFont(new Font("Tahoma", 1, 11));
        this.jLabel_Input.setHorizontalAlignment(0);
        this.jLabel_Input.setText("Input File");
        this.jLabel_Input.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_VideoFile.add((Component)this.jLabel_Input, gridBagConstraints);
        this.jLabel_FileDuration_Input_Header.setText("Duration");
        this.jLabel_FileDuration_Input_Header.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_VideoFile.add((Component)this.jLabel_FileDuration_Input_Header, gridBagConstraints);
        this.jLabel_FileDuration_Input.setHorizontalAlignment(0);
        this.jLabel_FileDuration_Input.setText("Duration");
        this.jLabel_FileDuration_Input.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_VideoFile.add((Component)this.jLabel_FileDuration_Input, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jPanel_VideoFile, gridBagConstraints);
        this.jPanel_Screenshot.setLayout(new GridBagLayout());
        this.jLabel_ImageFirst.setMaximumSize(new Dimension(100, 100));
        this.jLabel_ImageFirst.setMinimumSize(new Dimension(100, 100));
        this.jLabel_ImageFirst.setPreferredSize(new Dimension(100, 100));
        this.jLabel_ImageFirst.setRequestFocusEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Screenshot.add((Component)this.jLabel_ImageFirst, gridBagConstraints);
        this.jLabel_ImageMiddle.setMaximumSize(new Dimension(100, 100));
        this.jLabel_ImageMiddle.setMinimumSize(new Dimension(100, 100));
        this.jLabel_ImageMiddle.setPreferredSize(new Dimension(100, 100));
        this.jLabel_ImageMiddle.setRequestFocusEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Screenshot.add((Component)this.jLabel_ImageMiddle, gridBagConstraints);
        this.jLabel_ImageLast.setMaximumSize(new Dimension(100, 100));
        this.jLabel_ImageLast.setMinimumSize(new Dimension(100, 100));
        this.jLabel_ImageLast.setPreferredSize(new Dimension(100, 100));
        this.jLabel_ImageLast.setRequestFocusEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Screenshot.add((Component)this.jLabel_ImageLast, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jPanel_Screenshot, gridBagConstraints);
        this.jPanel_VideoProperties.setLayout(new GridBagLayout());
        this.jLabel_VideoHeight_Header.setHorizontalAlignment(4);
        this.jLabel_VideoHeight_Header.setText("Height:");
        this.jLabel_VideoHeight_Header.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_VideoProperties.add((Component)this.jLabel_VideoHeight_Header, gridBagConstraints);
        this.jLabel_VideoHeight_Origin.setHorizontalAlignment(0);
        this.jLabel_VideoHeight_Origin.setText("---");
        this.jLabel_VideoHeight_Origin.setToolTipText("");
        this.jLabel_VideoHeight_Origin.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.jLabel_VideoHeight_Origin.setMinimumSize(new Dimension(60, 22));
        this.jLabel_VideoHeight_Origin.setPreferredSize(new Dimension(60, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_VideoProperties.add((Component)this.jLabel_VideoHeight_Origin, gridBagConstraints);
        this.jTextField_VideoHeight_New.setHorizontalAlignment(0);
        this.jTextField_VideoHeight_New.setToolTipText("Insert new height");
        this.jTextField_VideoHeight_New.setMinimumSize(new Dimension(60, 22));
        this.jTextField_VideoHeight_New.setPreferredSize(new Dimension(60, 22));
        this.jTextField_VideoHeight_New.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                Media_VideoConverter.this.jTextField_VideoHeight_NewFocusLost(evt);
            }
        });
        this.jTextField_VideoHeight_New.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                Media_VideoConverter.this.jTextField_VideoHeight_NewKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        this.jPanel_VideoProperties.add((Component)this.jTextField_VideoHeight_New, gridBagConstraints);
        this.jLabel_VideoWidth_Header.setHorizontalAlignment(4);
        this.jLabel_VideoWidth_Header.setText("Width:");
        this.jLabel_VideoWidth_Header.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_VideoProperties.add((Component)this.jLabel_VideoWidth_Header, gridBagConstraints);
        this.jLabel_VideoWidth_Origin.setHorizontalAlignment(0);
        this.jLabel_VideoWidth_Origin.setText("---");
        this.jLabel_VideoWidth_Origin.setToolTipText("");
        this.jLabel_VideoWidth_Origin.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.jLabel_VideoWidth_Origin.setMinimumSize(new Dimension(60, 22));
        this.jLabel_VideoWidth_Origin.setPreferredSize(new Dimension(60, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_VideoProperties.add((Component)this.jLabel_VideoWidth_Origin, gridBagConstraints);
        this.jTextField_VideoWidth_New.setHorizontalAlignment(0);
        this.jTextField_VideoWidth_New.setToolTipText("Insert new width");
        this.jTextField_VideoWidth_New.setMinimumSize(new Dimension(60, 22));
        this.jTextField_VideoWidth_New.setPreferredSize(new Dimension(60, 22));
        this.jTextField_VideoWidth_New.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                Media_VideoConverter.this.jTextField_VideoWidth_NewFocusLost(evt);
            }
        });
        this.jTextField_VideoWidth_New.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                Media_VideoConverter.this.jTextField_VideoWidth_NewKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        this.jPanel_VideoProperties.add((Component)this.jTextField_VideoWidth_New, gridBagConstraints);
        this.jLabel_VideoAspectRatio_Header.setHorizontalAlignment(4);
        this.jLabel_VideoAspectRatio_Header.setText("Display Aspect Ratio:");
        this.jLabel_VideoAspectRatio_Header.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_VideoProperties.add((Component)this.jLabel_VideoAspectRatio_Header, gridBagConstraints);
        this.jLabel_VideoAspectRatio_Origin.setHorizontalAlignment(0);
        this.jLabel_VideoAspectRatio_Origin.setText("---");
        this.jLabel_VideoAspectRatio_Origin.setToolTipText("");
        this.jLabel_VideoAspectRatio_Origin.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.jLabel_VideoAspectRatio_Origin.setMinimumSize(new Dimension(60, 22));
        this.jLabel_VideoAspectRatio_Origin.setPreferredSize(new Dimension(60, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_VideoProperties.add((Component)this.jLabel_VideoAspectRatio_Origin, gridBagConstraints);
        this.jLabel_VideoFrameRate_Header.setHorizontalAlignment(4);
        this.jLabel_VideoFrameRate_Header.setText("Frame Rate:");
        this.jLabel_VideoFrameRate_Header.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_VideoProperties.add((Component)this.jLabel_VideoFrameRate_Header, gridBagConstraints);
        this.jLabel_VideoFrameRate_Origin.setHorizontalAlignment(0);
        this.jLabel_VideoFrameRate_Origin.setText("---");
        this.jLabel_VideoFrameRate_Origin.setToolTipText("");
        this.jLabel_VideoFrameRate_Origin.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.jLabel_VideoFrameRate_Origin.setMinimumSize(new Dimension(60, 22));
        this.jLabel_VideoFrameRate_Origin.setPreferredSize(new Dimension(60, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_VideoProperties.add((Component)this.jLabel_VideoFrameRate_Origin, gridBagConstraints);
        this.jLabel_Video.setForeground(new Color(255, 255, 255));
        this.jLabel_Video.setHorizontalAlignment(0);
        this.jLabel_Video.setText("Video");
        this.jLabel_Video.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_VideoProperties.add((Component)this.jLabel_Video, gridBagConstraints);
        this.jLabel_VideoArrow.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Arrow_Right.png")));
        this.jLabel_VideoArrow.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 8;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_VideoProperties.add((Component)this.jLabel_VideoArrow, gridBagConstraints);
        this.jPanel_VideoFrameRate.setLayout(new GridBagLayout());
        this.buttonGroup_VideoFrameRate.add(this.jRadioButton_VideoFrameRate_25);
        this.jRadioButton_VideoFrameRate_25.setText("25 fps");
        this.jRadioButton_VideoFrameRate_25.setToolTipText("Set new frame rate to 25 frames per second");
        this.jRadioButton_VideoFrameRate_25.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Media_VideoConverter.this.jRadioButton_VideoFrameRate_25ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 4;
        this.jPanel_VideoFrameRate.add((Component)this.jRadioButton_VideoFrameRate_25, gridBagConstraints);
        this.buttonGroup_VideoFrameRate.add(this.jRadioButton_VideoFrameRate_30);
        this.jRadioButton_VideoFrameRate_30.setText("30 fps");
        this.jRadioButton_VideoFrameRate_30.setToolTipText("Set new frame rate to 30 frames per second");
        this.jRadioButton_VideoFrameRate_30.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Media_VideoConverter.this.jRadioButton_VideoFrameRate_30ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 4;
        this.jPanel_VideoFrameRate.add((Component)this.jRadioButton_VideoFrameRate_30, gridBagConstraints);
        this.buttonGroup_VideoFrameRate.add(this.jRadioButton_VideoFrameRate_60);
        this.jRadioButton_VideoFrameRate_60.setText("60 fps");
        this.jRadioButton_VideoFrameRate_60.setToolTipText("Set new frame rate to 60 frames per second");
        this.jRadioButton_VideoFrameRate_60.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Media_VideoConverter.this.jRadioButton_VideoFrameRate_60ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 4;
        this.jPanel_VideoFrameRate.add((Component)this.jRadioButton_VideoFrameRate_60, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        this.jPanel_VideoProperties.add((Component)this.jPanel_VideoFrameRate, gridBagConstraints);
        this.jLabel_AudioChannels_Header.setHorizontalAlignment(4);
        this.jLabel_AudioChannels_Header.setText("Channels:");
        this.jLabel_AudioChannels_Header.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_VideoProperties.add((Component)this.jLabel_AudioChannels_Header, gridBagConstraints);
        this.jLabel_AudioSampleRate_Header.setHorizontalAlignment(4);
        this.jLabel_AudioSampleRate_Header.setText("Sample Rate:");
        this.jLabel_AudioSampleRate_Header.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_VideoProperties.add((Component)this.jLabel_AudioSampleRate_Header, gridBagConstraints);
        this.jLabel_AudioSampleRate_Origin.setHorizontalAlignment(0);
        this.jLabel_AudioSampleRate_Origin.setText("---");
        this.jLabel_AudioSampleRate_Origin.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_VideoProperties.add((Component)this.jLabel_AudioSampleRate_Origin, gridBagConstraints);
        this.jLabel_AudioChannels_Origin.setHorizontalAlignment(0);
        this.jLabel_AudioChannels_Origin.setText("---");
        this.jLabel_AudioChannels_Origin.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_VideoProperties.add((Component)this.jLabel_AudioChannels_Origin, gridBagConstraints);
        this.jLabel_Audio.setFont(new Font("Tahoma", 1, 11));
        this.jLabel_Audio.setHorizontalAlignment(0);
        this.jLabel_Audio.setText("Audio");
        this.jLabel_Audio.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_VideoProperties.add((Component)this.jLabel_Audio, gridBagConstraints);
        this.jLabel_AudioSampleRate_Output.setText("---");
        this.jLabel_AudioSampleRate_Output.setToolTipText("");
        this.jLabel_AudioSampleRate_Output.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_VideoProperties.add((Component)this.jLabel_AudioSampleRate_Output, gridBagConstraints);
        this.jPanel_AudioChannels.setLayout(new GridBagLayout());
        this.buttonGroup_AudioChannels.add(this.jRadioButton_AudioChannels_2);
        this.jRadioButton_AudioChannels_2.setText("2 (stereo)");
        this.jRadioButton_AudioChannels_2.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_AudioChannels.add((Component)this.jRadioButton_AudioChannels_2, gridBagConstraints);
        this.buttonGroup_AudioChannels.add(this.jRadioButton_AudioChannels_6);
        this.jRadioButton_AudioChannels_6.setText("6 (5.1)");
        this.jRadioButton_AudioChannels_6.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_AudioChannels.add((Component)this.jRadioButton_AudioChannels_6, gridBagConstraints);
        this.buttonGroup_AudioChannels.add(this.jRadioButton_AudioChannels_8);
        this.jRadioButton_AudioChannels_8.setText("8 (7.1)");
        this.jRadioButton_AudioChannels_8.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_AudioChannels.add((Component)this.jRadioButton_AudioChannels_8, gridBagConstraints);
        this.buttonGroup_AudioChannels.add(this.jRadioButton_AudioChannels_1);
        this.jRadioButton_AudioChannels_1.setText("1 (mono)");
        this.jRadioButton_AudioChannels_1.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_AudioChannels.add((Component)this.jRadioButton_AudioChannels_1, gridBagConstraints);
        this.buttonGroup_AudioChannels.add(this.jRadioButton_AudioChannels_0);
        this.jRadioButton_AudioChannels_0.setSelected(true);
        this.jRadioButton_AudioChannels_0.setText("0 (-)");
        this.jRadioButton_AudioChannels_0.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_AudioChannels.add((Component)this.jRadioButton_AudioChannels_0, gridBagConstraints);
        this.buttonGroup_AudioChannels.add(this.jRadioButton_AudioChannels_10);
        this.jRadioButton_AudioChannels_10.setText("10 (9.1)");
        this.jRadioButton_AudioChannels_10.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_AudioChannels.add((Component)this.jRadioButton_AudioChannels_10, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        this.jPanel_VideoProperties.add((Component)this.jPanel_AudioChannels, gridBagConstraints);
        this.jComboBox_VideoQuality.setModel(new DefaultComboBoxModel<String>(new String[]{"Standard (fast)", "Higher Quality (slow)"}));
        this.jComboBox_VideoQuality.setToolTipText("<html><br>Select Image quality:<br>*Standard converts fast but has less image quality<br>*High quality converts very slow but has high image quality</html>");
        this.jComboBox_VideoQuality.setMinimumSize(new Dimension(125, 22));
        this.jComboBox_VideoQuality.setPreferredSize(new Dimension(125, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        this.jPanel_VideoProperties.add(this.jComboBox_VideoQuality, gridBagConstraints);
        this.jLabel_VideoQualityHeader.setHorizontalAlignment(4);
        this.jLabel_VideoQualityHeader.setText("Video Image Quality:");
        this.jLabel_VideoQualityHeader.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_VideoProperties.add((Component)this.jLabel_VideoQualityHeader, gridBagConstraints);
        this.jTextField_VideoAspectRatio_New.setHorizontalAlignment(0);
        this.jTextField_VideoAspectRatio_New.setToolTipText("insert new aspect ratio");
        this.jTextField_VideoAspectRatio_New.setMinimumSize(new Dimension(60, 22));
        this.jTextField_VideoAspectRatio_New.setPreferredSize(new Dimension(60, 22));
        this.jTextField_VideoAspectRatio_New.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                Media_VideoConverter.this.jTextField_VideoAspectRatio_NewFocusLost(evt);
            }
        });
        this.jTextField_VideoAspectRatio_New.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                Media_VideoConverter.this.jTextField_VideoAspectRatio_NewKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        this.jPanel_VideoProperties.add((Component)this.jTextField_VideoAspectRatio_New, gridBagConstraints);
        this.jCheckBox_VideoRemoveAlphaChannel.setText("Replace transparency with black");
        this.jCheckBox_VideoRemoveAlphaChannel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Media_VideoConverter.this.jCheckBox_VideoRemoveAlphaChannelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        this.jPanel_VideoProperties.add((Component)this.jCheckBox_VideoRemoveAlphaChannel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jPanel_VideoProperties, gridBagConstraints);
        this.jPanel_FileSave.setLayout(new GridBagLayout());
        this.jLabel_FileName_Output.setFont(new Font("Tahoma", 0, 12));
        this.jLabel_FileName_Output.setHorizontalAlignment(0);
        this.jLabel_FileName_Output.setText("Filename");
        this.jLabel_FileName_Output.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_FileSave.add((Component)this.jLabel_FileName_Output, gridBagConstraints);
        this.jLabel_FileName_Output_Header.setText("Name:");
        this.jLabel_FileName_Output_Header.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_FileSave.add((Component)this.jLabel_FileName_Output_Header, gridBagConstraints);
        this.jLabel_FileDirectory_Output.setHorizontalAlignment(0);
        this.jLabel_FileDirectory_Output.setText("FilePath");
        this.jLabel_FileDirectory_Output.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_FileSave.add((Component)this.jLabel_FileDirectory_Output, gridBagConstraints);
        this.jLabel_FileDirectory_Output_Header.setText("Directory:");
        this.jLabel_FileDirectory_Output_Header.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_FileSave.add((Component)this.jLabel_FileDirectory_Output_Header, gridBagConstraints);
        this.jLabel_Output.setFont(new Font("Tahoma", 1, 11));
        this.jLabel_Output.setHorizontalAlignment(0);
        this.jLabel_Output.setText("Output File");
        this.jLabel_Output.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_FileSave.add((Component)this.jLabel_Output, gridBagConstraints);
        this.jLabel_ConvertStatus.setFont(new Font("Tahoma", 0, 16));
        this.jLabel_ConvertStatus.setHorizontalAlignment(0);
        this.jLabel_ConvertStatus.setText("jLabel1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel_FileSave.add((Component)this.jLabel_ConvertStatus, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jPanel_FileSave, gridBagConstraints);
        this.jPanel_Output.setLayout(new GridBagLayout());
        this.jTextPane_FFmpegOutput.setBackground(new Color(0, 0, 0));
        this.jScrollPane1.setViewportView(this.jTextPane_FFmpegOutput);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel_Output.add((Component)this.jScrollPane1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 20, 3, 3);
        this.add((Component)this.jPanel_Output, gridBagConstraints);
        this.jButton_Load.setBackground(new Color(0, 0, 0));
        this.jButton_Load.setForeground(new Color(255, 255, 255));
        this.jButton_Load.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Menu_ProjectLoad.png")));
        this.jButton_Load.setToolTipText("Load Sound or Video file");
        this.jButton_Load.setBorderPainted(false);
        this.jButton_Load.setContentAreaFilled(false);
        this.jButton_Load.setHorizontalTextPosition(4);
        this.jButton_Load.setMargin(new Insets(2, 2, 2, 2));
        this.jButton_Load.setMaximumSize(new Dimension(36, 36));
        this.jButton_Load.setMinimumSize(new Dimension(36, 36));
        this.jButton_Load.setPreferredSize(new Dimension(36, 36));
        this.jButton_Load.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_Load.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Media_VideoConverter.this.jButton_LoadActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jButton_Load, gridBagConstraints);
        this.jButton_ConvertVideo.setBackground(new Color(0, 0, 0));
        this.jButton_ConvertVideo.setForeground(new Color(255, 255, 255));
        this.jButton_ConvertVideo.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Media_VideoConverter.png")));
        this.jButton_ConvertVideo.setToolTipText("<html>convert video to mp4<br>and increasing key frames</html>");
        this.jButton_ConvertVideo.setBorderPainted(false);
        this.jButton_ConvertVideo.setContentAreaFilled(false);
        this.jButton_ConvertVideo.setHorizontalTextPosition(4);
        this.jButton_ConvertVideo.setMargin(new Insets(2, 2, 2, 2));
        this.jButton_ConvertVideo.setMaximumSize(new Dimension(64, 32));
        this.jButton_ConvertVideo.setMinimumSize(new Dimension(64, 32));
        this.jButton_ConvertVideo.setPreferredSize(new Dimension(64, 32));
        this.jButton_ConvertVideo.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed_Wide.png")));
        this.jButton_ConvertVideo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Media_VideoConverter.this.jButton_ConvertVideoActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jButton_ConvertVideo, gridBagConstraints);
        this.jButton_ConvertVideoCancel.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Edit_Cancel.png")));
        this.jButton_ConvertVideoCancel.setToolTipText("cancel converting video");
        this.jButton_ConvertVideoCancel.setBorderPainted(false);
        this.jButton_ConvertVideoCancel.setContentAreaFilled(false);
        this.jButton_ConvertVideoCancel.setMargin(new Insets(0, 0, 2, 0));
        this.jButton_ConvertVideoCancel.setMaximumSize(new Dimension(64, 32));
        this.jButton_ConvertVideoCancel.setMinimumSize(new Dimension(64, 32));
        this.jButton_ConvertVideoCancel.setPreferredSize(new Dimension(64, 32));
        this.jButton_ConvertVideoCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Media_VideoConverter.this.jButton_ConvertVideoCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jButton_ConvertVideoCancel, gridBagConstraints);
        this.jButton_ConvertAudio.setBackground(new Color(0, 0, 0));
        this.jButton_ConvertAudio.setForeground(new Color(255, 255, 255));
        this.jButton_ConvertAudio.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Media_AudioConverter.png")));
        this.jButton_ConvertAudio.setToolTipText("<html>convert to audio wav<br>44100 Hz, 2 channels, little endian</html> ");
        this.jButton_ConvertAudio.setBorderPainted(false);
        this.jButton_ConvertAudio.setContentAreaFilled(false);
        this.jButton_ConvertAudio.setHorizontalTextPosition(4);
        this.jButton_ConvertAudio.setMargin(new Insets(2, 2, 2, 2));
        this.jButton_ConvertAudio.setMaximumSize(new Dimension(64, 32));
        this.jButton_ConvertAudio.setMinimumSize(new Dimension(64, 32));
        this.jButton_ConvertAudio.setPreferredSize(new Dimension(64, 32));
        this.jButton_ConvertAudio.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed_Wide.png")));
        this.jButton_ConvertAudio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Media_VideoConverter.this.jButton_ConvertAudioActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jButton_ConvertAudio, gridBagConstraints);
        this.jButton_ConvertAudioCancel.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Edit_Cancel.png")));
        this.jButton_ConvertAudioCancel.setToolTipText("cancel converting audio");
        this.jButton_ConvertAudioCancel.setBorderPainted(false);
        this.jButton_ConvertAudioCancel.setContentAreaFilled(false);
        this.jButton_ConvertAudioCancel.setMargin(new Insets(0, 0, 2, 0));
        this.jButton_ConvertAudioCancel.setMaximumSize(new Dimension(64, 32));
        this.jButton_ConvertAudioCancel.setMinimumSize(new Dimension(64, 32));
        this.jButton_ConvertAudioCancel.setPreferredSize(new Dimension(64, 32));
        this.jButton_ConvertAudioCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Media_VideoConverter.this.jButton_ConvertAudioCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jButton_ConvertAudioCancel, gridBagConstraints);
    }

    private void jButton_LoadActionPerformed(ActionEvent evt) {
        this.loadInputFile();
    }

    private void jButton_ConvertVideoActionPerformed(ActionEvent evt) {
        this.convertVideo();
    }

    private void jButton_ConvertVideoCancelActionPerformed(ActionEvent evt) {
        this.m_Status_ConvertCancelled = true;
        if (this.m_ProcessConvert != null) {
            this.m_Status_ConvertSuccess = false;
            try {
                this.m_ProcessConvert.destroy();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void jRadioButton_VideoFrameRate_25ActionPerformed(ActionEvent evt) {
        this.m_VideoFrameRate_New = 25.0;
        this.refresh();
    }

    private void jRadioButton_VideoFrameRate_30ActionPerformed(ActionEvent evt) {
        this.m_VideoFrameRate_New = 30.0;
        this.refresh();
    }

    private void jTextField_VideoWidth_NewKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            int intNewWidth;
            if (this.jTextField_VideoWidth_New.getText().length() <= 0) {
                intNewWidth = 0;
            } else {
                intNewWidth = Integer.valueOf(this.jTextField_VideoWidth_New.getText());
                if (intNewWidth < 0) {
                    intNewWidth = 0;
                }
            }
            this.calculateNewVideoSize(intNewWidth, -1);
        }
    }

    private void jTextField_VideoWidth_NewFocusLost(FocusEvent evt) {
        int intNewWidth;
        if (this.jTextField_VideoWidth_New.getText().length() <= 0) {
            intNewWidth = 0;
        } else {
            intNewWidth = Integer.valueOf(this.jTextField_VideoWidth_New.getText());
            if (intNewWidth < 0) {
                intNewWidth = 0;
            }
        }
        this.calculateNewVideoSize(intNewWidth, -1);
    }

    private void jTextField_VideoHeight_NewKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            int intNewHeight;
            if (this.jTextField_VideoHeight_New.getText().length() <= 0) {
                intNewHeight = 0;
            } else {
                intNewHeight = Integer.valueOf(this.jTextField_VideoHeight_New.getText());
                if (intNewHeight < 0) {
                    intNewHeight = 0;
                }
            }
            this.calculateNewVideoSize(-1, intNewHeight);
        }
    }

    private void jTextField_VideoHeight_NewFocusLost(FocusEvent evt) {
        int intNewHeight;
        if (this.jTextField_VideoHeight_New.getText().length() <= 0) {
            intNewHeight = 0;
        } else {
            intNewHeight = Integer.valueOf(this.jTextField_VideoHeight_New.getText());
            if (intNewHeight < 0) {
                intNewHeight = 0;
            }
        }
        this.calculateNewVideoSize(-1, intNewHeight);
    }

    private void jButton_ConvertAudioActionPerformed(ActionEvent evt) {
        this.convertAudio();
    }

    private void jButton_ConvertAudioCancelActionPerformed(ActionEvent evt) {
        this.m_Status_ConvertCancelled = true;
        if (this.m_ProcessConvert != null) {
            this.m_Status_ConvertSuccess = false;
            try {
                this.m_ProcessConvert.destroy();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void jTextField_VideoAspectRatio_NewFocusLost(FocusEvent evt) {
        double doubleAspectratioNew;
        this.m_VideoAspectRatio_New = doubleAspectratioNew = this.getAspectRatio_New();
        this.refresh();
    }

    private void jTextField_VideoAspectRatio_NewKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            double doubleAspectratioNew;
            this.m_VideoAspectRatio_New = doubleAspectratioNew = this.getAspectRatio_New();
            this.refresh();
        }
    }

    private void jCheckBox_VideoRemoveAlphaChannelActionPerformed(ActionEvent evt) {
        this.m_VideoReplaceAlphaChannel = this.jCheckBox_VideoRemoveAlphaChannel.isSelected();
    }

    private void jRadioButton_VideoFrameRate_60ActionPerformed(ActionEvent evt) {
        this.m_VideoFrameRate_New = 60.0;
        this.refresh();
    }

    private void calculateNewVideoSize(int p_NewWidth, int p_NewHeight) {
        if (this.m_VideoWidth_Origin <= 0 || this.m_VideoHeight_Origin <= 0) {
            this.jTextField_VideoWidth_New.setText("");
            this.jTextField_VideoHeight_New.setText("");
            return;
        }
        if (p_NewHeight <= 0 && p_NewWidth <= 0) {
            this.jTextField_VideoWidth_New.setText(String.valueOf(this.m_VideoWidth_Origin));
            this.jTextField_VideoHeight_New.setText(String.valueOf(this.m_VideoHeight_Origin));
            return;
        }
        double doubleFactor = (double)this.m_VideoWidth_Origin / (double)this.m_VideoHeight_Origin;
        if (p_NewHeight <= 0) {
            if (p_NewWidth > 3840) {
                p_NewWidth = 3840;
            }
            this.m_VideoWidth_New = p_NewWidth;
            this.m_VideoHeight_New = (int)((double)p_NewWidth / doubleFactor + 0.5);
        }
        if (p_NewWidth <= 0) {
            if (p_NewHeight > 2160) {
                p_NewHeight = 2160;
            }
            this.m_VideoHeight_New = p_NewHeight;
            this.m_VideoWidth_New = (int)((double)p_NewHeight * doubleFactor + 0.5);
        }
        this.refresh();
    }

    private void initComponentsFurther() {
        DocumentFilter_Integer o_DocumentFilter_Integer = new DocumentFilter_Integer((JTextComponent)this.jTextField_VideoWidth_New);
        o_DocumentFilter_Integer = new DocumentFilter_Integer((JTextComponent)this.jTextField_VideoHeight_New);
        DocumentFilter_Double o_DocumentFilter_Double = new DocumentFilter_Double((JTextComponent)this.jTextField_VideoAspectRatio_New);
        DefaultListCellRenderer o_DefaultListCellRenderer = new DefaultListCellRenderer();
        this.jComboBox_VideoQuality.setRenderer(o_DefaultListCellRenderer);
        this.m_EncodeQualityModel = new EncodeQualityModel();
        this.jComboBox_VideoQuality.setModel((ComboBoxModel<String>)this.m_EncodeQualityModel.getListModel());
        this.jButton_Load.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jButton_ConvertVideo.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jButton_ConvertVideoCancel.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jButton_ConvertAudio.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jButton_ConvertAudioCancel.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jTextField_VideoWidth_New.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jTextField_VideoHeight_New.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jComboBox_VideoQuality.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jLabel_VideoAspectRatio_Header.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jTextField_VideoAspectRatio_New.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jRadioButton_VideoFrameRate_25.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jRadioButton_VideoFrameRate_30.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jRadioButton_VideoFrameRate_60.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jCheckBox_VideoRemoveAlphaChannel.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jRadioButton_AudioChannels_0.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jRadioButton_AudioChannels_1.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jRadioButton_AudioChannels_2.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jRadioButton_AudioChannels_6.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jRadioButton_AudioChannels_8.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
        this.jRadioButton_AudioChannels_10.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
    }

    public JLabel_ResizeFrame getLabel_ResizeFrame() {
        return this.jLabel_ResizeFrame1;
    }

    public static void setLastOpenedFilePath(File p_File) {
        if (p_File == null) {
            if (s_LastOpenFilePath == null) {
                return;
            }
        } else {
            if (!p_File.isDirectory()) {
                p_File = p_File.getParentFile();
            }
            if (p_File.equals(s_LastOpenFilePath)) {
                return;
            }
        }
        s_LastOpenFilePath = p_File;
        Media_VideoConverter.writeIni();
    }

    public void loadInputFile() {
        FileNameExtensionFilter o_FileNameExtensionFilter = MediaSource.MEDIAFILE_FILTER_VIDEOAUDIO;
        final File o_SelectedFile = FileSelection.showOpen(null, (String)FILE_LOAD_TITLE, (File)s_LastOpenFilePath, (FileNameExtensionFilter)o_FileNameExtensionFilter, (boolean)true, (boolean)true, (FileNameExtensionFilter)MediaSource.MEDIAFILE_FILTER_IMAGE, null, (FileNameExtensionFilter)MediaSource.MEDIAFILE_FILTER_VIDEO, (FileNameExtensionFilter)MediaSource.MEDIAFILE_FILTER_TEXT);
        if (o_SelectedFile == null) {
            this.m_Status_IsLoading = false;
            return;
        }
        if (this.m_FFmpegFrameGrabber != null) {
            try {
                this.m_FFmpegFrameGrabber.close();
                this.m_FFmpegFrameGrabber = null;
                this.m_AudioFormat_Input = null;
            }
            catch (FrameGrabber.Exception exception) {
                // empty catch block
            }
        }
        this.resetParams();
        this.m_File_Input = o_SelectedFile;
        Media_VideoConverter.setLastOpenedFilePath(this.m_File_Input);
        Runnable o_Runnable_LoadVideo = new Runnable(){

            @Override
            public void run() {
                block29: {
                    Media_VideoConverter.this.m_Status_IsVideoConverting = false;
                    Media_VideoConverter.this.m_Status_ConvertWasStarted = false;
                    Media_VideoConverter.this.m_Status_ConvertCancelled = false;
                    Media_VideoConverter.this.m_Status_ConvertSuccess = true;
                    Media_VideoConverter.this.m_Status_LoadSuccess = false;
                    Media_VideoConverter.this.m_Status_IsLoading = true;
                    try {
                        Media_VideoConverter.this.m_FFmpegFrameGrabber = new FFmpegFrameGrabber(o_SelectedFile);
                        if (o_SelectedFile.getName().lastIndexOf(".mov") > 0) {
                            Media_VideoConverter.this.m_FFmpegFrameGrabber.setPixelFormat(27);
                        }
                        Media_VideoConverter.this.m_FFmpegFrameGrabber.start();
                    }
                    catch (Exception e) {
                        if (Media_VideoConverter.this.m_FFmpegFrameGrabber == null) break block29;
                        try {
                            Media_VideoConverter.this.m_FFmpegFrameGrabber.close();
                            Media_VideoConverter.this.m_FFmpegFrameGrabber = null;
                            Media_VideoConverter.this.m_AudioFormat_Input = null;
                        }
                        catch (FrameGrabber.Exception exception) {
                            // empty catch block
                        }
                    }
                }
                if (Media_VideoConverter.this.m_FFmpegFrameGrabber != null) {
                    Media_VideoConverter.this.m_Status_LoadSuccess = true;
                    Media_VideoConverter.this.m_Duration = Media_VideoConverter.this.m_FFmpegFrameGrabber.getLengthInTime() / 1000L;
                    if (Media_VideoConverter.this.m_FFmpegFrameGrabber.hasVideo()) {
                        Media_VideoConverter.this.m_VideoAspectRatio_Origin = Media_VideoConverter.this.m_FFmpegFrameGrabber.getAspectRatio();
                        if (Media_VideoConverter.this.m_VideoAspectRatio_Origin <= 0.0) {
                            Media_VideoConverter.this.m_VideoAspectRatio_Origin = 1.0;
                        }
                        Media_VideoConverter.this.m_VideoAspectRatio_New = Media_VideoConverter.this.m_VideoAspectRatio_Origin;
                        Media_VideoConverter.this.m_VideoWidth_Origin = Media_VideoConverter.this.m_FFmpegFrameGrabber.getImageWidth();
                        Media_VideoConverter.this.m_VideoHeight_Origin = Media_VideoConverter.this.m_FFmpegFrameGrabber.getImageHeight();
                        Media_VideoConverter.this.m_VideoFrameRate_Origin = Media_VideoConverter.this.m_FFmpegFrameGrabber.getFrameRate();
                        Media_VideoConverter.this.m_VideoWidth_New = Media_VideoConverter.this.m_VideoWidth_Origin;
                        Media_VideoConverter.this.m_VideoHeight_New = Media_VideoConverter.this.m_VideoHeight_Origin;
                        if (Media_VideoConverter.this.m_VideoFrameRate_Origin <= 25.0) {
                            Media_VideoConverter.this.m_VideoFrameRate_New = 25.0;
                        } else if (Media_VideoConverter.this.m_VideoFrameRate_Origin <= 30.0) {
                            Media_VideoConverter.this.m_VideoFrameRate_New = 30.0;
                        } else {
                            Media_VideoConverter.this.m_VideoFrameRate_New = 60.0;
                        }
                        if (s_LastSaveFilePath == null) {
                            s_LastSaveFilePath = s_LastOpenFilePath;
                        }
                    }
                    if (Media_VideoConverter.this.m_FFmpegFrameGrabber.hasAudio()) {
                        Media_VideoConverter.this.m_AudioFormat_Input = SoundMixers.getAudioFormat((FFmpegFrameGrabber)Media_VideoConverter.this.m_FFmpegFrameGrabber);
                        if (Media_VideoConverter.this.m_AudioFormat_Input != null) {
                            if (Media_VideoConverter.this.m_AudioFormat_Input.getChannels() == 0) {
                                Media_VideoConverter.this.jRadioButton_AudioChannels_0.setSelected(true);
                            } else if (Media_VideoConverter.this.m_AudioFormat_Input.getChannels() == 1) {
                                Media_VideoConverter.this.jRadioButton_AudioChannels_1.setSelected(true);
                            } else if (Media_VideoConverter.this.m_AudioFormat_Input.getChannels() == 2) {
                                Media_VideoConverter.this.jRadioButton_AudioChannels_2.setSelected(true);
                            } else if (Media_VideoConverter.this.m_AudioFormat_Input.getChannels() == 6) {
                                Media_VideoConverter.this.jRadioButton_AudioChannels_6.setSelected(true);
                            } else if (Media_VideoConverter.this.m_AudioFormat_Input.getChannels() == 8) {
                                Media_VideoConverter.this.jRadioButton_AudioChannels_8.setSelected(true);
                            } else if (Media_VideoConverter.this.m_AudioFormat_Input.getChannels() == 10) {
                                Media_VideoConverter.this.jRadioButton_AudioChannels_10.setSelected(true);
                            } else {
                                Media_VideoConverter.this.jRadioButton_AudioChannels_2.setSelected(true);
                            }
                        } else {
                            Media_VideoConverter.this.jRadioButton_AudioChannels_2.setSelected(true);
                        }
                    } else {
                        Media_VideoConverter.this.m_AudioFormat_Input = null;
                        Media_VideoConverter.this.jRadioButton_AudioChannels_0.setSelected(true);
                    }
                }
                Media_VideoConverter.this.setSnapShots();
                Media_VideoConverter.this.m_Status_IsLoading = false;
                EventQueueHandler.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Media_VideoConverter.this.refresh();
                    }
                });
            }
        };
        this.m_Status_IsLoading = true;
        this.m_Status_LoadSuccess = false;
        Thread o_Thread_LoadVideo = new Thread(o_Runnable_LoadVideo);
        o_Thread_LoadVideo.start();
        this.refresh();
    }

    private boolean setOutputVideo() {
        boolean boolMayContainAlpha = false;
        boolean boolReplaceFileEstension = false;
        boolean boolFileOK = true;
        if (this.m_File_Input == null || this.m_FFmpegFrameGrabber == null || !this.m_FFmpegFrameGrabber.hasVideo()) {
            return false;
        }
        String stringDirectory = this.m_File_Input.getParentFile().getAbsolutePath();
        String stringFileName = FileTools.getFileNameBase((File)this.m_File_Input);
        String stringFileExtension = ".mp4";
        FileNameExtensionFilter o_FileNameExtensionFilter = s_FileNameExtensionFilter_MP4;
        if (stringFileName.length() > 0) {
            if (this.m_File_Input.getName().endsWith(".mov")) {
                boolMayContainAlpha = true;
                stringFileExtension = ".mov";
                if (!this.m_VideoReplaceAlphaChannel) {
                    o_FileNameExtensionFilter = s_FileNameExtensionFilter_MOV;
                    stringFileExtension = ".mov";
                } else {
                    o_FileNameExtensionFilter = s_FileNameExtensionFilter_MP4;
                    stringFileExtension = ".mp4";
                }
            } else {
                boolMayContainAlpha = true;
                o_FileNameExtensionFilter = s_FileNameExtensionFilter_MP4;
                stringFileExtension = ".mp4";
            }
            int intSelectedAudioChannels = this.getSelectedAudioChannels();
            int intPosition = stringFileName.indexOf("_Format");
            if (intPosition > 0) {
                stringFileName = stringFileName.substring(0, intPosition);
            }
            stringFileName = stringFileName + "_Format_" + String.valueOf(this.m_VideoWidth_New) + "x" + String.valueOf(this.m_VideoHeight_New) + "_" + String.valueOf((int)this.m_VideoFrameRate_New);
            if (this.jComboBox_VideoQuality.getSelectedIndex() == 1) {
                stringFileName = stringFileName + "_Middle";
            } else if (this.jComboBox_VideoQuality.getSelectedIndex() == 2) {
                stringFileName = stringFileName + "_High";
            } else if (this.jComboBox_VideoQuality.getSelectedIndex() == 3) {
                stringFileName = stringFileName + "_VeryHigh";
            }
            if (intSelectedAudioChannels > 0) {
                stringFileName = stringFileName + "_" + String.valueOf(intSelectedAudioChannels) + "ch";
            }
            stringFileName = stringFileName + stringFileExtension;
        } else {
            stringFileName = "New.mp4";
        }
        File o_SelectedFile = new File(stringDirectory + File.separator + stringFileName);
        o_SelectedFile = FileSelection.showSave((Component)this, (String)VIDEOSAVE_TITLE, (File)o_SelectedFile, (FileNameExtensionFilter)o_FileNameExtensionFilter, (boolean)true, (boolean)true, null, null, (FileNameExtensionFilter)o_FileNameExtensionFilter, null);
        if (o_SelectedFile == null) {
            return false;
        }
        if (!FileTools.checkWritable((File)o_SelectedFile)) {
            return false;
        }
        stringFileName = o_SelectedFile.getName();
        stringDirectory = o_SelectedFile.getParentFile().getAbsolutePath();
        if (stringFileName.length() <= 0) {
            return false;
        }
        boolReplaceFileEstension = true;
        if (stringFileName.endsWith(stringFileExtension)) {
            boolReplaceFileEstension = false;
        }
        if (boolReplaceFileEstension) {
            int intPos = stringFileName.indexOf(".");
            if (intPos > 0) {
                stringFileName = stringFileName.substring(0, intPos);
            }
            stringFileName = stringFileName + stringFileExtension;
            o_SelectedFile = new File(stringDirectory + stringFileName);
        }
        if (o_SelectedFile.equals(this.m_File_Input)) {
            return false;
        }
        if (o_SelectedFile.exists()) {
            if (JOptionDialog.showConfirmDialog(null, (Object)FILEEXISTS_MESSAGE, (String)FILEEXISTS_TITLE, (int)0, (Object)1) == 1) {
                boolFileOK = false;
            } else {
                try {
                    boolFileOK = o_SelectedFile.delete();
                    if (!boolFileOK) {
                        JOptionDialog.showMessageDialog(null, (Object)FILEINUSE_MESSAGE, (String)FILEINUSE_TITLE, (int)0);
                    }
                }
                catch (Exception e) {
                    boolFileOK = false;
                }
            }
        } else if (!FileTools.checkWritable((File)o_SelectedFile.getParentFile())) {
            JOptionDialog.showMessageDialog(null, (Object)FILENOTWRITABLE_MESSAGE, (String)FILENOTWRITABLE_TITLE, (int)0);
            boolFileOK = false;
        }
        if (!boolFileOK) {
            this.m_File_Output = null;
        } else {
            this.m_File_Output = o_SelectedFile;
            s_LastSaveFilePath = o_SelectedFile.getParentFile();
        }
        return boolFileOK;
    }

    public void setOutputAudioFormat(AudioFormat p_AudioFormat) {
        if (p_AudioFormat == null) {
            return;
        }
        boolean boolIsEqual = true;
        if (this.m_AudioFormat_Output != null) {
            if (p_AudioFormat.getChannels() != this.m_AudioFormat_Output.getChannels()) {
                boolIsEqual = false;
            }
            if (p_AudioFormat.getSampleSizeInBits() != this.m_AudioFormat_Output.getSampleSizeInBits()) {
                boolIsEqual = false;
            }
            if (p_AudioFormat.isBigEndian() != this.m_AudioFormat_Output.isBigEndian()) {
                boolIsEqual = false;
            }
            if (p_AudioFormat.getSampleRate() != this.m_AudioFormat_Output.getSampleRate()) {
                boolIsEqual = false;
            }
            if (p_AudioFormat.getEncoding() != this.m_AudioFormat_Output.getEncoding()) {
                boolIsEqual = false;
            }
            if (boolIsEqual) {
                return;
            }
        }
        this.m_AudioFormat_Output = new AudioFormat(p_AudioFormat.getEncoding(), p_AudioFormat.getSampleRate(), p_AudioFormat.getSampleSizeInBits(), p_AudioFormat.getChannels(), p_AudioFormat.getFrameSize(), p_AudioFormat.getFrameRate(), p_AudioFormat.isBigEndian());
    }

    private boolean setOutputAudio() {
        boolean boolFileOK = true;
        if (this.m_File_Input == null || this.m_FFmpegFrameGrabber == null || !this.m_FFmpegFrameGrabber.hasAudio()) {
            return false;
        }
        int intChannels = this.getSelectedAudioChannels();
        StringBuilder o_StringBuilder = new StringBuilder();
        String stringDirectory = this.m_File_Input.getParentFile().getAbsolutePath();
        String stringFileName = FileTools.getFileNameBase((File)this.m_File_Input);
        if (stringFileName.length() > 0) {
            int intPosition = stringFileName.indexOf("_PCM_");
            if (intPosition > 0) {
                stringFileName = stringFileName.substring(0, intPosition);
            }
            o_StringBuilder.append(stringFileName);
            o_StringBuilder.append("_PCM_");
            o_StringBuilder.append(String.valueOf((int)this.m_AudioFormat_Output.getSampleRate()));
            o_StringBuilder.append("_");
            o_StringBuilder.append(String.valueOf(intChannels));
            o_StringBuilder.append("_S");
            o_StringBuilder.append(String.valueOf(this.m_AudioFormat_Output.getSampleSizeInBits()));
            o_StringBuilder.append("_");
            if (this.m_AudioFormat_Output.isBigEndian()) {
                o_StringBuilder.append("BE");
            } else {
                o_StringBuilder.append("LE");
            }
            o_StringBuilder.append(".wav");
            stringFileName = o_StringBuilder.toString();
        } else {
            stringFileName = "New.wav";
        }
        File o_SelectedFile = new File(stringDirectory + File.separator + stringFileName);
        o_SelectedFile = FileSelection.showSave((Component)this, (String)AUDIOSAVE_TITLE, (File)o_SelectedFile, (FileNameExtensionFilter)s_FileNameExtensionFilter_WAV, (boolean)true, (boolean)false, null, (FileNameExtensionFilter)s_FileNameExtensionFilter_WAV, null, null);
        if (o_SelectedFile == null) {
            return false;
        }
        if (!FileTools.checkWritable((File)o_SelectedFile)) {
            return false;
        }
        stringFileName = o_SelectedFile.getName();
        if (stringFileName.length() <= 0) {
            return false;
        }
        stringDirectory = o_SelectedFile.getParentFile().getAbsolutePath();
        if (!stringFileName.endsWith(".wav")) {
            int intPos = stringFileName.indexOf(".");
            if (intPos > 0) {
                stringFileName = stringFileName.substring(0, intPos);
            }
            stringFileName = stringFileName + ".wav";
            o_SelectedFile = new File(stringDirectory + stringFileName);
        }
        if (o_SelectedFile.equals(this.m_File_Input)) {
            return false;
        }
        if (o_SelectedFile.exists()) {
            if (JOptionDialog.showConfirmDialog(null, (Object)FILEEXISTS_MESSAGE, (String)FILEEXISTS_TITLE, (int)0, (Object)1) == 1) {
                boolFileOK = false;
            } else {
                try {
                    boolFileOK = o_SelectedFile.delete();
                    if (!boolFileOK) {
                        JOptionDialog.showMessageDialog(null, (Object)FILEINUSE_MESSAGE, (String)FILEINUSE_TITLE, (int)0);
                    }
                }
                catch (Exception e) {
                    boolFileOK = false;
                }
            }
        } else if (!FileTools.checkWritable((File)o_SelectedFile.getParentFile())) {
            JOptionDialog.showMessageDialog(null, (Object)FILENOTWRITABLE_MESSAGE, (String)FILENOTWRITABLE_TITLE, (int)0);
            boolFileOK = false;
        }
        if (!boolFileOK) {
            this.m_File_Output = null;
        } else {
            this.m_File_Output = o_SelectedFile;
            s_LastSaveFilePath = o_SelectedFile.getParentFile();
        }
        return boolFileOK;
    }

    private void setSnapShots() {
        if (this.m_FFmpegFrameGrabber == null || !this.m_FFmpegFrameGrabber.hasVideo() && !this.m_FFmpegFrameGrabber.hasAudio()) {
            if (this.m_BufferedImage_First != null) {
                this.m_BufferedImage_First.flush();
            }
            this.m_BufferedImage_First = null;
            if (this.m_BufferedImage_Middle != null) {
                this.m_BufferedImage_Middle.flush();
            }
            this.m_BufferedImage_Middle = null;
            if (this.m_BufferedImage_Last != null) {
                this.m_BufferedImage_Last.flush();
            }
            this.m_BufferedImage_Last = null;
            return;
        }
        if (this.m_FFmpegFrameGrabber.hasVideo()) {
            this.m_BufferedImage_First = this.drawImage(this.m_BufferedImage_First, 0L);
            this.m_BufferedImage_Middle = this.drawImage(this.m_BufferedImage_Middle, this.m_Duration / 2L * 1000L);
            this.m_BufferedImage_Last = this.drawImage(this.m_BufferedImage_Last, (this.m_Duration - 80L) * 1000L);
        } else if (this.m_FFmpegFrameGrabber.hasAudio()) {
            if (this.m_BufferedImage_First != null) {
                this.m_BufferedImage_First.flush();
            }
            this.m_BufferedImage_First = null;
            if (this.m_BufferedImage_Last != null) {
                this.m_BufferedImage_Last.flush();
            }
            this.m_BufferedImage_Last = null;
            this.m_BufferedImage_Middle = this.drawImage(this.m_BufferedImage_Middle, 0L);
        }
    }

    private BufferedImage drawImage(BufferedImage p_BufferedImage_Request, long p_Timestamp) {
        BufferedImage o_BufferedImage_Snapshot;
        block18: {
            o_BufferedImage_Snapshot = null;
            if (this.m_FFmpegFrameGrabber.hasVideo()) {
                long longDuration = this.m_FFmpegFrameGrabber.getLengthInTime();
                if (p_Timestamp < 0L) {
                    p_Timestamp = 0L;
                }
                if (p_Timestamp > longDuration) {
                    p_Timestamp = longDuration;
                }
                try {
                    boolean bl;
                    this.m_FFmpegFrameGrabber.setTimestamp(0L);
                    this.m_FFmpegFrameGrabber.setTimestamp(p_Timestamp);
                    Frame o_Frame = this.m_FFmpegFrameGrabber.grabImage();
                    if (o_Frame == null || o_Frame.image == null) {
                        return null;
                    }
                    o_BufferedImage_Snapshot = this.getBufferedImage(o_Frame);
                    if (o_BufferedImage_Snapshot == null) {
                        return null;
                    }
                    if (o_BufferedImage_Snapshot.getAlphaRaster() != null) {
                        bl = true;
                        break block18;
                    }
                    bl = false;
                }
                catch (FrameGrabber.Exception exception) {}
            } else if (this.m_FFmpegFrameGrabber.hasAudio()) {
                o_BufferedImage_Snapshot = s_BufferedImage_Sound;
            }
        }
        try {
            int intNewWidth;
            int intNewHeight;
            double doubleWidthFactor;
            double doubleHeightFactor;
            if (p_BufferedImage_Request == null) {
                p_BufferedImage_Request = new BufferedImage(Media_VideoConverter.SNAPAHOT_SIZE.width, Media_VideoConverter.SNAPAHOT_SIZE.height, 2);
            }
            double doubleAspectRatio = this.m_FFmpegFrameGrabber.getAspectRatio();
            int intOriginWidth = o_BufferedImage_Snapshot.getWidth();
            int intOriginHeight = o_BufferedImage_Snapshot.getHeight();
            if (doubleAspectRatio != 1.0 && doubleAspectRatio > 0.0) {
                doubleAspectRatio *= (double)intOriginWidth / (double)intOriginHeight;
                if (intOriginWidth > intOriginHeight) {
                    intOriginWidth = p_BufferedImage_Request.getWidth();
                    intOriginHeight = (int)((double)p_BufferedImage_Request.getHeight() / doubleAspectRatio + 0.5);
                } else {
                    intOriginHeight = p_BufferedImage_Request.getHeight();
                    intOriginWidth = (int)((double)p_BufferedImage_Request.getHeight() * doubleAspectRatio + 0.5);
                }
            }
            if ((doubleHeightFactor = (double)p_BufferedImage_Request.getHeight() / (double)intOriginHeight) < (doubleWidthFactor = (double)p_BufferedImage_Request.getWidth() / (double)intOriginWidth)) {
                intNewHeight = (int)((double)intOriginHeight * doubleHeightFactor);
                intNewWidth = (int)((double)intOriginWidth * doubleHeightFactor);
            } else {
                intNewHeight = (int)((double)intOriginHeight * doubleWidthFactor);
                intNewWidth = (int)((double)intOriginWidth * doubleWidthFactor);
            }
            int intX = (p_BufferedImage_Request.getWidth() - intNewWidth) / 2;
            int intY = (p_BufferedImage_Request.getHeight() - intNewHeight) / 2;
            Graphics2D o_Graphics2D = p_BufferedImage_Request.createGraphics();
            o_Graphics2D.clearRect(0, 0, p_BufferedImage_Request.getWidth(), p_BufferedImage_Request.getHeight());
            o_Graphics2D.drawImage(o_BufferedImage_Snapshot, intX, intY, intX + intNewWidth, intY + intNewHeight, 0, 0, o_BufferedImage_Snapshot.getWidth(), o_BufferedImage_Snapshot.getHeight(), null);
            o_Graphics2D.dispose();
        }
        catch (Exception e) {
            return null;
        }
        return p_BufferedImage_Request;
    }

    public BufferedImage getBufferedImage(Frame p_Frame) {
        if (p_Frame == null) {
            return null;
        }
        return FFmpeg_VideoFrameConverter.getBufferedImage(p_Frame, null);
    }

    private void refresh() {
        if (this.m_Status_IsLoading || !this.m_Status_LoadSuccess || this.m_File_Input == null || this.m_FFmpegFrameGrabber == null) {
            this.jLabel_FileName_Input.setText("");
            this.jLabel_FileName_Input.setToolTipText(null);
            this.jLabel_FileDirectory_Input.setText("");
            this.jLabel_FileDirectory_Input.setToolTipText(null);
            this.jLabel_FileDuration_Input.setText("");
            this.jLabel_ConvertStatus.setText("");
            this.jLabel_FileName_Output.setText("");
            this.jLabel_FileName_Output.setToolTipText(null);
            this.jLabel_FileDirectory_Output.setText("");
            this.jLabel_FileDirectory_Output.setToolTipText(null);
            this.setVideoPropertiesVisible(false);
            this.jButton_ConvertVideo.setVisible(false);
            this.jButton_ConvertVideoCancel.setVisible(false);
            this.jLabel_VideoWidth_Origin.setText("---");
            this.jTextField_VideoWidth_New.setText("");
            this.jLabel_VideoHeight_Origin.setText("---");
            this.jTextField_VideoHeight_New.setText("");
            this.jLabel_VideoAspectRatio_Origin.setText("---");
            this.jTextField_VideoAspectRatio_New.setText("");
            this.jLabel_VideoFrameRate_Origin.setText("---");
            this.jRadioButton_VideoFrameRate_25.setSelected(true);
            this.setAudioPropertiesVisible(false);
            this.jButton_ConvertAudio.setVisible(false);
            this.jButton_ConvertAudioCancel.setVisible(false);
            this.jLabel_AudioChannels_Origin.setText("");
            this.jLabel_AudioSampleRate_Origin.setText("");
            this.jLabel_ImageFirst.setIcon(null);
            this.jLabel_ImageMiddle.setIcon(null);
            this.jLabel_ImageLast.setIcon(null);
            if (this.m_Status_IsLoading) {
                this.jLabel_FileName_Input.setForeground(Color.GREEN);
                this.jLabel_FileName_Input.setText(FILE_LOAD_INPROGRESS);
            } else if (!this.m_Status_LoadSuccess) {
                this.jLabel_FileName_Input.setForeground(Color.RED);
                this.jLabel_FileName_Input.setText(FILE_LOAD_ERROR);
            } else {
                this.jLabel_FileName_Input.setForeground(Color.WHITE);
            }
        } else if (this.m_File_Input != null && this.m_FFmpegFrameGrabber != null) {
            this.jLabel_FileName_Input.setForeground(Color.WHITE);
            this.jLabel_FileName_Input.setText(this.m_File_Input.getName());
            this.jLabel_FileName_Input.setToolTipText(this.m_File_Input.getName());
            File o_Directory = this.m_File_Input.getParentFile();
            this.jLabel_FileDirectory_Input.setText(o_Directory.getAbsolutePath());
            this.jLabel_FileDirectory_Input.setToolTipText(o_Directory.getAbsolutePath());
            this.jLabel_FileDuration_Input.setText(TimeString.getTimeStringFromMillis((long)this.m_Duration));
            if (this.m_BufferedImage_First != null) {
                this.jLabel_ImageFirst.setIcon(new ImageIcon(this.m_BufferedImage_First));
            } else {
                this.jLabel_ImageFirst.setIcon(null);
            }
            if (this.m_BufferedImage_Middle != null) {
                this.jLabel_ImageMiddle.setIcon(new ImageIcon(this.m_BufferedImage_Middle));
            } else {
                this.jLabel_ImageMiddle.setIcon(null);
            }
            if (this.m_BufferedImage_Last != null) {
                this.jLabel_ImageLast.setIcon(new ImageIcon(this.m_BufferedImage_Last));
            } else {
                this.jLabel_ImageLast.setIcon(null);
            }
            if (this.m_FFmpegFrameGrabber.hasVideo()) {
                this.setVideoPropertiesVisible(true);
                this.jButton_ConvertAudio.setVisible(true);
                this.jLabel_VideoWidth_Origin.setText(String.valueOf(this.m_VideoWidth_Origin));
                this.jTextField_VideoWidth_New.setText(String.valueOf(this.m_VideoWidth_New));
                this.jLabel_VideoHeight_Origin.setText(String.valueOf(this.m_VideoHeight_Origin));
                this.jTextField_VideoHeight_New.setText(String.valueOf(this.m_VideoHeight_New));
                this.jLabel_VideoAspectRatio_Origin.setText(String.valueOf(this.m_VideoAspectRatio_Origin));
                this.jTextField_VideoAspectRatio_New.setText(String.valueOf(this.m_VideoAspectRatio_New));
                this.jLabel_VideoFrameRate_Origin.setText(String.valueOf(this.m_VideoFrameRate_Origin));
                if (this.m_VideoFrameRate_New <= 25.0) {
                    this.jRadioButton_VideoFrameRate_25.setSelected(true);
                } else if (this.m_VideoFrameRate_New <= 30.0) {
                    this.jRadioButton_VideoFrameRate_30.setSelected(true);
                } else {
                    this.jRadioButton_VideoFrameRate_60.setSelected(true);
                }
                this.jRadioButton_AudioChannels_0.setVisible(true);
                if (this.m_File_Input.getName().endsWith(".mov")) {
                    this.jCheckBox_VideoRemoveAlphaChannel.setVisible(true);
                    this.jCheckBox_VideoRemoveAlphaChannel.setSelected(this.m_VideoReplaceAlphaChannel);
                } else {
                    this.jCheckBox_VideoRemoveAlphaChannel.setVisible(false);
                }
            } else {
                this.setVideoPropertiesVisible(false);
                this.jButton_ConvertVideo.setVisible(false);
                this.jRadioButton_AudioChannels_0.setVisible(false);
            }
            if (this.m_AudioFormat_Input != null) {
                this.setAudioPropertiesVisible(true);
                this.jButton_ConvertAudio.setVisible(true);
                this.jLabel_AudioChannels_Origin.setText(String.valueOf(this.m_AudioFormat_Input.getChannels()));
                this.jLabel_AudioSampleRate_Origin.setText(String.valueOf((int)this.m_AudioFormat_Input.getFrameRate() + " Hz"));
                this.jRadioButton_AudioChannels_1.setVisible(false);
                this.jRadioButton_AudioChannels_2.setVisible(false);
                this.jRadioButton_AudioChannels_6.setVisible(false);
                this.jRadioButton_AudioChannels_8.setVisible(false);
                this.jRadioButton_AudioChannels_10.setVisible(false);
                switch (this.m_AudioFormat_Input.getChannels()) {
                    case 10: {
                        this.jRadioButton_AudioChannels_10.setVisible(true);
                    }
                    case 8: {
                        this.jRadioButton_AudioChannels_8.setVisible(true);
                    }
                    case 6: {
                        this.jRadioButton_AudioChannels_6.setVisible(true);
                    }
                    case 2: {
                        this.jRadioButton_AudioChannels_2.setVisible(true);
                    }
                    case 1: {
                        this.jRadioButton_AudioChannels_1.setVisible(true);
                    }
                }
            } else {
                this.setAudioPropertiesVisible(false);
                this.jButton_ConvertAudio.setVisible(false);
            }
            if (this.m_AudioFormat_Output != null) {
                StringBuilder o_StringBuilder = new StringBuilder();
                o_StringBuilder.append((int)this.m_AudioFormat_Output.getFrameRate());
                o_StringBuilder.append(" Hz ");
                if (!this.m_FFmpegFrameGrabber.hasVideo()) {
                    o_StringBuilder.append(this.m_AudioFormat_Output.getSampleSizeInBits());
                    o_StringBuilder.append(" bit ");
                    if (this.m_AudioFormat_Output.isBigEndian()) {
                        o_StringBuilder.append("big endian");
                    } else {
                        o_StringBuilder.append("little endian");
                    }
                }
                this.jLabel_AudioSampleRate_Output.setText(o_StringBuilder.toString());
            } else {
                this.jLabel_AudioSampleRate_Output.setText("---");
            }
            if (this.m_File_Output != null) {
                this.jLabel_FileName_Output.setForeground(Color.WHITE);
                this.jLabel_FileName_Output.setText(this.m_File_Output.getName());
                this.jLabel_FileName_Output.setToolTipText(this.m_File_Output.getName());
                o_Directory = this.m_File_Output.getParentFile();
                this.jLabel_FileDirectory_Output.setText(o_Directory.getAbsolutePath());
                this.jLabel_FileDirectory_Output.setToolTipText(o_Directory.getAbsolutePath());
            } else {
                this.jLabel_FileName_Output.setText("");
                this.jLabel_FileName_Output.setToolTipText(null);
                this.jLabel_FileDirectory_Output.setText("");
                this.jLabel_FileDirectory_Output.setToolTipText(null);
            }
        }
        if (this.m_Status_IsVideoConverting || this.m_Status_IsAudioConverting) {
            this.jLabel_ConvertStatus.setForeground(Color.ORANGE);
            this.jLabel_ConvertStatus.setText(FILE_CONVERTING_PROGRESS);
        } else if (!this.m_Status_ConvertSuccess) {
            this.jLabel_ConvertStatus.setForeground(Color.RED);
            this.jLabel_ConvertStatus.setText(FILE_CONVERTING_ERROR);
            this.m_StringBuilder_Output.append("\n");
            this.m_StringBuilder_Output.append(FILE_CONVERTING_ERROR);
            this.jTextPane_FFmpegOutput.setText(this.m_StringBuilder_Output.toString());
            this.jTextPane_FFmpegOutput.setCaretPosition(this.jTextPane_FFmpegOutput.getDocument().getLength());
        } else if (!this.m_Status_ConvertWasStarted) {
            this.jLabel_ConvertStatus.setText("");
        } else {
            this.jLabel_ConvertStatus.setForeground(Color.GREEN);
            this.jLabel_ConvertStatus.setText(FILE_CONVERTING_SUCCESS);
            this.m_StringBuilder_Output.append("\n");
            this.m_StringBuilder_Output.append(FILE_CONVERTING_SUCCESS);
            this.jTextPane_FFmpegOutput.setText(this.m_StringBuilder_Output.toString());
            this.jTextPane_FFmpegOutput.setCaretPosition(this.jTextPane_FFmpegOutput.getDocument().getLength());
        }
        this.jButton_ConvertAudio.setEnabled(true);
        this.jButton_ConvertVideo.setEnabled(true);
        if (this.m_Status_IsLoading) {
            this.jButton_Load.setEnabled(false);
            this.jButton_ConvertVideo.setEnabled(false);
            this.jButton_ConvertVideoCancel.setVisible(false);
            this.jButton_ConvertAudio.setEnabled(false);
            this.jButton_ConvertAudioCancel.setVisible(false);
        } else {
            this.jButton_Load.setEnabled(true);
        }
        if (this.m_FFmpegFrameGrabber != null && this.m_FFmpegFrameGrabber.hasVideo()) {
            if (this.m_Status_IsVideoConverting) {
                this.jButton_ConvertVideo.setVisible(false);
                this.jButton_ConvertVideoCancel.setVisible(true);
                this.jButton_Load.setEnabled(false);
                this.jButton_ConvertAudio.setEnabled(false);
            } else {
                this.jButton_ConvertVideoCancel.setVisible(false);
                this.jButton_ConvertVideo.setVisible(true);
                if (this.m_Status_IsLoading || this.m_File_Input == null) {
                    this.jButton_ConvertVideo.setEnabled(false);
                }
            }
        }
        if (this.m_FFmpegFrameGrabber != null && this.m_FFmpegFrameGrabber.hasAudio()) {
            if (this.m_Status_IsAudioConverting) {
                this.jButton_ConvertAudio.setVisible(false);
                this.jButton_ConvertAudioCancel.setVisible(true);
                this.jButton_Load.setEnabled(false);
                this.jButton_ConvertVideo.setEnabled(false);
            } else {
                this.jButton_ConvertAudioCancel.setVisible(false);
                this.jButton_ConvertAudio.setVisible(true);
                if (this.m_Status_IsLoading || this.m_File_Input == null) {
                    this.jButton_ConvertAudio.setEnabled(false);
                }
            }
        }
    }

    public void setVideoPropertiesVisible(boolean p_Visible) {
        this.jLabel_Video.setVisible(p_Visible);
        this.jLabel_VideoAspectRatio_Header.setVisible(p_Visible);
        this.jLabel_VideoAspectRatio_Origin.setVisible(p_Visible);
        this.jTextField_VideoAspectRatio_New.setVisible(p_Visible);
        this.jLabel_VideoFrameRate_Header.setVisible(p_Visible);
        this.jLabel_VideoFrameRate_Origin.setVisible(p_Visible);
        this.jPanel_VideoFrameRate.setVisible(p_Visible);
        this.jLabel_VideoHeight_Header.setVisible(p_Visible);
        this.jLabel_VideoHeight_Origin.setVisible(p_Visible);
        this.jLabel_VideoWidth_Header.setVisible(p_Visible);
        this.jLabel_VideoWidth_Origin.setVisible(p_Visible);
        this.jTextField_VideoHeight_New.setVisible(p_Visible);
        this.jTextField_VideoWidth_New.setVisible(p_Visible);
        this.jLabel_VideoQualityHeader.setVisible(p_Visible);
        this.jComboBox_VideoQuality.setVisible(p_Visible);
        this.jCheckBox_VideoRemoveAlphaChannel.setVisible(p_Visible);
    }

    public void setAudioPropertiesVisible(boolean p_Visible) {
        this.jLabel_Audio.setVisible(p_Visible);
        this.jLabel_AudioChannels_Header.setVisible(p_Visible);
        this.jLabel_AudioChannels_Origin.setVisible(p_Visible);
        this.jLabel_AudioSampleRate_Header.setVisible(p_Visible);
        this.jLabel_AudioSampleRate_Origin.setVisible(p_Visible);
        this.jLabel_AudioSampleRate_Output.setVisible(p_Visible);
        this.jPanel_AudioChannels.setVisible(p_Visible);
    }

    public void setProgress(int p_Progress) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convertVideo() {
        Object object = this.m_SyncConvert;
        synchronized (object) {
            if (this.m_Status_IsVideoConverting) {
                return;
            }
            if (!this.setOutputVideo()) {
                this.refresh();
                return;
            }
            Runnable o_Runnable_ConvertVideo = new Runnable(){

                @Override
                public void run() {
                    Media_VideoConverter.this.doConvertVideo();
                }
            };
            this.m_Status_ConvertCancelled = false;
            Object object2 = this.m_SyncConvert;
            synchronized (object2) {
                this.m_Status_IsVideoConverting = true;
                this.m_Status_ConvertSuccess = false;
                this.m_Thread_Convert = new Thread(o_Runnable_ConvertVideo);
                this.m_Thread_Convert.start();
            }
            this.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doConvertVideo() {
        boolean boolOK = false;
        Object object = this.m_SyncConvert;
        synchronized (object) {
            this.m_Status_IsVideoConverting = true;
            this.m_Status_ConvertSuccess = false;
            this.m_Status_ConvertWasStarted = true;
        }
        try {
            int intSelectedChannels = this.getSelectedAudioChannels();
            boolOK = this.convertVideo(this.m_FFmpegFrameGrabber, this.m_File_Input, this.m_File_Output, this.m_VideoFrameRate_New, this.m_VideoWidth_New, this.m_VideoHeight_New, intSelectedChannels);
        }
        catch (Exception e) {
            boolOK = false;
        }
        this.m_Thread_Convert = null;
        if (!boolOK && this.m_File_Output != null) {
            this.m_File_Output.delete();
        }
        object = this.m_SyncConvert;
        synchronized (object) {
            this.m_Status_IsVideoConverting = false;
            this.m_Status_ConvertSuccess = boolOK;
        }
        EventQueueHandler.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                Media_VideoConverter.this.refresh();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convertAudio() {
        Object object = this.m_SyncConvert;
        synchronized (object) {
            if (this.m_Status_IsAudioConverting) {
                return;
            }
            if (!this.setOutputAudio()) {
                this.refresh();
                return;
            }
            Runnable o_Runnable_ConvertAudio = new Runnable(){

                @Override
                public void run() {
                    Media_VideoConverter.this.doConvertAudio();
                }
            };
            this.m_Status_ConvertCancelled = false;
            Object object2 = this.m_SyncConvert;
            synchronized (object2) {
                this.m_Status_IsAudioConverting = true;
                this.m_Status_ConvertSuccess = false;
                this.m_Thread_Convert = new Thread(o_Runnable_ConvertAudio);
                this.m_Thread_Convert.start();
            }
            this.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doConvertAudio() {
        boolean boolOK = false;
        Object object = this.m_SyncConvert;
        synchronized (object) {
            this.m_Status_IsAudioConverting = true;
            this.m_Status_ConvertSuccess = false;
            this.m_Status_ConvertWasStarted = true;
        }
        try {
            boolOK = this.convertAudio(this.m_FFmpegFrameGrabber, this.m_File_Input, this.m_File_Output);
        }
        catch (Exception e) {
            boolOK = false;
        }
        this.m_Thread_Convert = null;
        if (!boolOK && this.m_File_Output != null) {
            this.m_File_Output.delete();
        }
        object = this.m_SyncConvert;
        synchronized (object) {
            this.m_Status_IsAudioConverting = false;
            this.m_Status_ConvertSuccess = boolOK;
        }
        EventQueueHandler.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                Media_VideoConverter.this.refresh();
            }
        });
    }

    public Thread getThread_Convert() {
        return this.m_Thread_Convert;
    }

    private double getAspectRatio_New() {
        double doubleAspectRatio_New;
        try {
            doubleAspectRatio_New = Double.valueOf(this.jTextField_VideoAspectRatio_New.getText());
        }
        catch (Exception e) {
            doubleAspectRatio_New = this.m_VideoAspectRatio_Origin;
        }
        if (doubleAspectRatio_New < 0.0) {
            doubleAspectRatio_New = 1.0;
        }
        return doubleAspectRatio_New;
    }

    public boolean convertVideo(FFmpegFrameGrabber p_FFmpegFrameGrabber, File p_InputFile, File p_DestFile, double p_NewFramerate, int p_NewWidth, int p_NewHeight, int p_SelectedChannels) {
        if (p_FFmpegFrameGrabber == null) {
            return false;
        }
        if (p_DestFile == null) {
            return false;
        }
        if (p_NewFramerate < 20.0) {
            return false;
        }
        if (p_NewFramerate > 120.0) {
            return false;
        }
        if (p_NewWidth < 10) {
            return false;
        }
        if (p_NewHeight < 10) {
            return false;
        }
        boolean boolOK = false;
        int intGOPSize = (int)p_NewFramerate * 2;
        int intHeight = p_FFmpegFrameGrabber.getImageHeight();
        int intWidth = p_FFmpegFrameGrabber.getImageWidth();
        if (intHeight == 0 || intWidth == 0) {
            return false;
        }
        double doubleFactorHeight = (double)intWidth / (double)intHeight;
        int intNewWidth = intWidth;
        int intNewHeight = intHeight;
        if (p_NewHeight > 0 && p_NewWidth > 0) {
            intNewHeight = p_NewHeight;
            intNewWidth = (int)((double)p_NewHeight * doubleFactorHeight);
        }
        double doubleAspectRatio = this.getAspectRatio_New();
        doubleAspectRatio *= (double)intNewWidth / (double)intNewHeight;
        String stringCRF = "28";
        if (this.jComboBox_VideoQuality.getSelectedIndex() == 1) {
            stringCRF = "28";
        } else if (this.jComboBox_VideoQuality.getSelectedIndex() == 2) {
            stringCRF = "23";
        } else if (this.jComboBox_VideoQuality.getSelectedIndex() == 3) {
            stringCRF = "18";
        }
        try {
            ProcessBuilder pb = null;
            String ffmpeg2 = Loader.load(ffmpeg.class);
            pb = p_DestFile.getName().endsWith(".mov") ? (p_SelectedChannels <= 0 ? (this.jComboBox_VideoQuality.getSelectedIndex() == 0 ? new ProcessBuilder(ffmpeg2, "-i", p_InputFile.getAbsolutePath(), "-c:v", "qtrle", "-vf", "scale=" + String.valueOf(intNewWidth) + ":" + String.valueOf(intNewHeight) + ",fps=" + String.valueOf(p_NewFramerate) + "", "-aspect", String.valueOf(doubleAspectRatio), "-g", String.valueOf(intGOPSize), "-an", p_DestFile.getAbsolutePath()) : new ProcessBuilder(ffmpeg2, "-i", p_InputFile.getAbsolutePath(), "-c:v", "qtrle", "-crf", stringCRF, "-b:v", "0", "-row-mt", "1", "-vf", "scale=" + String.valueOf(intNewWidth) + ":" + String.valueOf(intNewHeight) + ",fps=" + String.valueOf(p_NewFramerate) + "", "-aspect", String.valueOf(doubleAspectRatio), "-g", String.valueOf(intGOPSize), "-an", p_DestFile.getAbsolutePath())) : (this.jComboBox_VideoQuality.getSelectedIndex() == 0 ? new ProcessBuilder(ffmpeg2, "-i", p_InputFile.getAbsolutePath(), "-c:v", "qtrle", "-vf", "scale=" + String.valueOf(intNewWidth) + ":" + String.valueOf(intNewHeight) + ",fps=" + String.valueOf(p_NewFramerate) + "", "-aspect", String.valueOf(doubleAspectRatio), "-g", String.valueOf(intGOPSize), "-ac", String.valueOf(p_SelectedChannels), "-ar", String.valueOf((int)this.m_AudioFormat_Output.getFrameRate()), "-b:a", "192k", p_DestFile.getAbsolutePath()) : new ProcessBuilder(ffmpeg2, "-i", p_InputFile.getAbsolutePath(), "-c:v", "qtrle", "-crf", stringCRF, "-b:v", "0", "-row-mt", "1", "-vf", "scale=" + String.valueOf(intNewWidth) + ":" + String.valueOf(intNewHeight) + ",fps=" + String.valueOf(p_NewFramerate) + "", "-aspect", String.valueOf(doubleAspectRatio), "-g", String.valueOf(intGOPSize), "-ac", String.valueOf(p_SelectedChannels), "-ar", String.valueOf((int)this.m_AudioFormat_Output.getFrameRate()), "-b:a", "192k", p_DestFile.getAbsolutePath()))) : (p_SelectedChannels <= 0 ? (this.jComboBox_VideoQuality.getSelectedIndex() == 0 ? new ProcessBuilder(ffmpeg2, "-i", p_InputFile.getAbsolutePath(), "-vcodec", "h264", "-vf", "scale=" + String.valueOf(intNewWidth) + ":" + String.valueOf(intNewHeight) + ",fps=" + String.valueOf(p_NewFramerate) + "", "-aspect", String.valueOf(doubleAspectRatio), "-g", String.valueOf(intGOPSize), "-an", p_DestFile.getAbsolutePath()) : new ProcessBuilder(ffmpeg2, "-i", p_InputFile.getAbsolutePath(), "-c:v", "libvpx-vp9", "-b:v", "0", "-crf", stringCRF, "-row-mt", "1", "-vf", "scale=" + String.valueOf(intNewWidth) + ":" + String.valueOf(intNewHeight) + ",fps=" + String.valueOf(p_NewFramerate) + "", "-aspect", String.valueOf(doubleAspectRatio), "-g", String.valueOf(intGOPSize), "-an", p_DestFile.getAbsolutePath())) : (this.jComboBox_VideoQuality.getSelectedIndex() == 0 ? new ProcessBuilder(ffmpeg2, "-i", p_InputFile.getAbsolutePath(), "-vcodec", "h264", "-vf", "scale=" + String.valueOf(intNewWidth) + ":" + String.valueOf(intNewHeight) + ",fps=" + String.valueOf(p_NewFramerate) + "", "-aspect", String.valueOf(doubleAspectRatio), "-g", String.valueOf(intGOPSize), "-ac", String.valueOf(p_SelectedChannels), "-ar", String.valueOf((int)this.m_AudioFormat_Output.getFrameRate()), "-b:a", "192k", p_DestFile.getAbsolutePath()) : new ProcessBuilder(ffmpeg2, "-i", p_InputFile.getAbsolutePath(), "-c:v", "libvpx-vp9", "-b:v", "0", "-crf", stringCRF, "-row-mt", "1", "-vf", "scale=" + String.valueOf(intNewWidth) + ":" + String.valueOf(intNewHeight) + ",fps=" + String.valueOf(p_NewFramerate) + "", "-aspect", String.valueOf(doubleAspectRatio), "-g", String.valueOf(intGOPSize), "-ac", String.valueOf(p_SelectedChannels), "-ar", String.valueOf((int)this.m_AudioFormat_Output.getFrameRate()), "-b:a", "192k", p_DestFile.getAbsolutePath())));
            if (pb != null) {
                this.m_ProcessConvert = pb.start();
                BufferedReader stdError = new BufferedReader(new InputStreamReader(this.m_ProcessConvert.getErrorStream()));
                String stringOutputLine = null;
                try {
                    while ((stringOutputLine = stdError.readLine()) != null) {
                        this.m_StringBuilder_Output.append(stringOutputLine);
                        this.m_StringBuilder_Output.append("\n");
                        this.jTextPane_FFmpegOutput.setText(this.m_StringBuilder_Output.toString());
                        this.jTextPane_FFmpegOutput.setCaretPosition(this.jTextPane_FFmpegOutput.getDocument().getLength());
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.m_ProcessConvert.waitFor();
                try {
                    stdError.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.m_ProcessConvert = null;
            } else {
                this.m_Status_ConvertCancelled = true;
            }
            if (this.m_Status_ConvertCancelled) {
                boolOK = false;
                p_DestFile.delete();
            } else {
                boolOK = p_DestFile.exists() && p_DestFile.length() >= 1000L;
            }
        }
        catch (Exception e) {
            boolOK = false;
        }
        return boolOK;
    }

    public int getSelectedAudioChannels() {
        if (this.m_AudioFormat_Input == null) {
            return 0;
        }
        if (this.jRadioButton_AudioChannels_0.isSelected()) {
            return 0;
        }
        if (this.jRadioButton_AudioChannels_1.isSelected()) {
            return 1;
        }
        if (this.jRadioButton_AudioChannels_2.isSelected()) {
            return 2;
        }
        if (this.jRadioButton_AudioChannels_6.isSelected()) {
            return 6;
        }
        if (this.jRadioButton_AudioChannels_8.isSelected()) {
            return 8;
        }
        if (this.jRadioButton_AudioChannels_10.isSelected()) {
            return 10;
        }
        return SoundMixers.DEFAULT_AUDIOFORMAT.getChannels();
    }

    public boolean convertAudio(FFmpegFrameGrabber p_FFmpegFrameGrabber, File p_InputFile, File p_DestFile) {
        if (p_FFmpegFrameGrabber == null) {
            return false;
        }
        if (p_InputFile == null) {
            return false;
        }
        if (p_DestFile == null) {
            return false;
        }
        if (!p_InputFile.exists()) {
            return false;
        }
        int intSelectedChannels = this.getSelectedAudioChannels();
        if (!p_FFmpegFrameGrabber.hasAudio()) {
            return false;
        }
        AudioFormat o_AudioFormat_Output = new AudioFormat(this.m_AudioFormat_Output.getEncoding(), this.m_AudioFormat_Output.getSampleRate(), this.m_AudioFormat_Output.getSampleSizeInBits(), intSelectedChannels, intSelectedChannels * this.m_AudioFormat_Output.getSampleSizeInBits() / 8, this.m_AudioFormat_Output.getFrameRate(), this.m_AudioFormat_Output.isBigEndian());
        File o_FileResult = this.convertAudioFile(p_FFmpegFrameGrabber, p_InputFile, o_AudioFormat_Output, p_DestFile);
        return o_FileResult != null;
    }

    public File convertAudioFile(FFmpegFrameGrabber p_FFmpegFrameGrabber, File p_InputFile, AudioFormat p_OutputAudioFormat, File p_OutputFile) {
        if (p_InputFile == null) {
            return null;
        }
        if (p_OutputAudioFormat == null) {
            return null;
        }
        if (p_OutputFile == null) {
            return null;
        }
        if (p_FFmpegFrameGrabber == null) {
            return null;
        }
        int intAVCodec = -1;
        String stringAVCodec = "";
        File o_FileResult = p_OutputFile;
        if (p_OutputFile.exists() && !p_OutputFile.delete()) {
            return null;
        }
        int intChannels = p_OutputAudioFormat.getChannels();
        int intSampleRate = (int)p_OutputAudioFormat.getSampleRate();
        int intSampleSizeBits = p_OutputAudioFormat.getSampleSizeInBits();
        boolean boolIsBigEndian = p_OutputAudioFormat.isBigEndian();
        AudioFormat.Encoding o_Encoding = p_OutputAudioFormat.getEncoding();
        int intSampleFormat = -1;
        if (intSampleSizeBits == 16) {
            if (o_Encoding == AudioFormat.Encoding.PCM_SIGNED) {
                intSampleFormat = 1;
                if (boolIsBigEndian) {
                    intAVCodec = 65537;
                    stringAVCodec = "pcm_s16be";
                } else {
                    intAVCodec = 65536;
                    stringAVCodec = "pcm_s16le";
                }
            } else if (o_Encoding == AudioFormat.Encoding.PCM_UNSIGNED) {
                intSampleFormat = -1;
                if (boolIsBigEndian) {
                    intAVCodec = 65539;
                    stringAVCodec = "pcm_u16be";
                } else {
                    intAVCodec = 65538;
                    stringAVCodec = "pcm_u16le";
                }
            } else if (o_Encoding == AudioFormat.Encoding.PCM_FLOAT) {
                // empty if block
            }
        } else if (intSampleSizeBits == 24) {
            if (o_Encoding == AudioFormat.Encoding.PCM_SIGNED) {
                intSampleFormat = -1;
                if (boolIsBigEndian) {
                    intAVCodec = 65549;
                    stringAVCodec = "pcm_s24be";
                } else {
                    intAVCodec = 65548;
                    stringAVCodec = "pcm_s24le";
                }
            } else if (o_Encoding == AudioFormat.Encoding.PCM_UNSIGNED) {
                intSampleFormat = -1;
                if (boolIsBigEndian) {
                    intAVCodec = 65551;
                    stringAVCodec = "pcm_u24be";
                } else {
                    intAVCodec = 65550;
                    stringAVCodec = "pcm_u24le";
                }
            } else if (o_Encoding == AudioFormat.Encoding.PCM_FLOAT) {
                // empty if block
            }
        } else if (intSampleSizeBits == 32) {
            if (o_Encoding == AudioFormat.Encoding.PCM_SIGNED) {
                intSampleFormat = 2;
                if (boolIsBigEndian) {
                    intAVCodec = 65545;
                    stringAVCodec = "pcm_s32be";
                } else {
                    intAVCodec = 65544;
                    stringAVCodec = "pcm_s32le";
                }
            } else if (o_Encoding == AudioFormat.Encoding.PCM_UNSIGNED) {
                intSampleFormat = -1;
                if (boolIsBigEndian) {
                    intAVCodec = 65547;
                    stringAVCodec = "pcm_u32be";
                } else {
                    intAVCodec = 65546;
                    stringAVCodec = "pcm_u32le";
                }
            } else if (o_Encoding == AudioFormat.Encoding.PCM_FLOAT) {
                intSampleFormat = 3;
                if (boolIsBigEndian) {
                    intAVCodec = 65556;
                    stringAVCodec = "pcm_f32be";
                } else {
                    intAVCodec = 65557;
                    stringAVCodec = "pcm_f32le";
                }
            }
        } else if (intSampleSizeBits == 64) {
            if (o_Encoding == AudioFormat.Encoding.PCM_SIGNED) {
                intSampleFormat = 10;
                if (boolIsBigEndian) {
                    intAVCodec = 65568;
                    stringAVCodec = "pcm_s64be";
                } else {
                    intAVCodec = 65567;
                    stringAVCodec = "pcm_s64le";
                }
            } else if (o_Encoding == AudioFormat.Encoding.PCM_FLOAT) {
                intSampleFormat = 3;
                if (boolIsBigEndian) {
                    intAVCodec = 65558;
                    stringAVCodec = "pcm_f64be";
                } else {
                    intAVCodec = 65559;
                    stringAVCodec = "pcm_f64le";
                }
            }
        }
        if (intAVCodec < 0) {
            return null;
        }
        try {
            String ffmpeg2 = Loader.load(ffmpeg.class);
            ProcessBuilder pb = new ProcessBuilder(ffmpeg2, "-i", p_InputFile.getAbsolutePath(), "-acodec", stringAVCodec, "-ac", String.valueOf(intChannels), "-ar", String.valueOf(intSampleRate), p_OutputFile.getAbsolutePath());
            this.m_ProcessConvert = pb.inheritIO().start();
            this.m_ProcessConvert.waitFor();
            this.m_ProcessConvert = null;
            if (!p_OutputFile.exists() || p_OutputFile.length() < 1000L) {
                o_FileResult = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            o_FileResult = null;
        }
        if (this.m_Status_ConvertCancelled) {
            o_FileResult = null;
        }
        if (o_FileResult == null && p_OutputFile.exists()) {
            p_OutputFile.delete();
        }
        return o_FileResult;
    }

    public static class EncodeQualityModel
    extends TableAndListModel<String> {
        public EncodeQualityModel() {
            super(false);
        }

        public int getColumnCount() {
            return 1;
        }

        public String getColumnName(int col) {
            return "Quality";
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }

        public Object getValue(String p_Element, int p_ColumnIndex) {
            return p_Element;
        }

        public void setValue(String p_Element, Object value, int p_ColumnIndex) {
        }
    }

    public static interface VideoConvertListener {
        public int eventProgressInPercent_Video(int var1);

        public int eventProgressInPercent_Audio(int var1);
    }
}

