/*
 * Decompiled with CFR 0.152.
 */
package MediaToolsPackage;

import MediaObjectPackage.MediaSource;
import java.io.File;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class MediaSource_FileWatcher {
    public static MediaSource_FileWatcher s_MediaSource_FileWatcher = new MediaSource_FileWatcher();
    public static int s_WaitTime_BeforeDelete = 2000;
    private WatchService m_WatchService;
    private Map<MediaSource, WatchKey> m_WatchedMediaSources;
    private boolean m_Close;
    private ArrayList<ChangeListener> m_ChangeListeners;
    private final Object m__SyncListeners = new Object();

    static <T> WatchEvent<T> cast(WatchEvent<?> event) {
        return event;
    }

    MediaSource_FileWatcher() {
        this.initMembers();
        try {
            this.m_WatchService = FileSystems.getDefault().newWatchService();
        }
        catch (Exception e) {
            this.m_WatchService = null;
        }
        this.m_WatchedMediaSources = new HashMap<MediaSource, WatchKey>();
        this.m_Close = false;
        this.processEvents();
    }

    private void initMembers() {
        this.m_ChangeListeners = new ArrayList();
    }

    public static void close() {
        if (s_MediaSource_FileWatcher != null) {
            s_MediaSource_FileWatcher.closeInternal();
        }
    }

    public void closeInternal() {
        if (this.m_Close) {
            return;
        }
        this.m_Close = true;
    }

    public static boolean registerMediaSource(MediaSource p_MediaSource) {
        if (s_MediaSource_FileWatcher != null) {
            return s_MediaSource_FileWatcher.registerMediaSourceInternal(p_MediaSource);
        }
        return false;
    }

    public static boolean unregisterMediaSource(MediaSource p_MediaSource) {
        if (s_MediaSource_FileWatcher != null) {
            return s_MediaSource_FileWatcher.unregisterMediaSourceInternal(p_MediaSource);
        }
        return false;
    }

    private boolean registerMediaSourceInternal(MediaSource p_MediaSource) {
        WatchKey o_WatchKey;
        if (p_MediaSource == null) {
            return false;
        }
        if (this.m_WatchedMediaSources.containsKey(p_MediaSource)) {
            return true;
        }
        File o_File = p_MediaSource.getFile();
        File o_Directory = o_File.getParentFile();
        Path o_PathDirectory = Paths.get(o_Directory.toURI());
        try {
            o_WatchKey = o_PathDirectory.register(this.m_WatchService, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE);
        }
        catch (Exception e) {
            return false;
        }
        if (p_MediaSource instanceof ChangeListener) {
            MediaSource_FileWatcher.addChangeListener((ChangeListener)((Object)p_MediaSource));
        }
        this.m_WatchedMediaSources.put(p_MediaSource, o_WatchKey);
        return true;
    }

    private boolean unregisterMediaSourceInternal(MediaSource p_MediaSource) {
        if (p_MediaSource == null) {
            return false;
        }
        try {
            WatchKey o_WatchKey;
            if (p_MediaSource instanceof ChangeListener) {
                MediaSource_FileWatcher.removeChangeListener((ChangeListener)((Object)p_MediaSource));
            }
            if ((o_WatchKey = this.m_WatchedMediaSources.get(p_MediaSource)) != null) {
                this.m_WatchedMediaSources.remove(p_MediaSource);
                for (MediaSource o_MediaSource : this.m_WatchedMediaSources.keySet()) {
                    WatchKey o_WatchKeyRest = this.m_WatchedMediaSources.get(o_MediaSource);
                    if (o_WatchKeyRest != o_WatchKey) continue;
                    return true;
                }
                o_WatchKey.cancel();
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    void processEvents() {
        Runnable o_RunnableWatch = new Runnable(){

            @Override
            public void run() {
                ArrayList<MediaSource> o_ChangedMediaSources = new ArrayList<MediaSource>();
                while (!MediaSource_FileWatcher.this.m_Close) {
                    MediaSource o_MediaSource2;
                    WatchKey o_WatchKey;
                    o_ChangedMediaSources.clear();
                    try {
                        o_WatchKey = MediaSource_FileWatcher.this.m_WatchService.take();
                    }
                    catch (InterruptedException interruptedException) {
                        break;
                    }
                    for (MediaSource o_MediaSource2 : MediaSource_FileWatcher.this.m_WatchedMediaSources.keySet()) {
                        if (!o_WatchKey.equals(MediaSource_FileWatcher.this.m_WatchedMediaSources.get(o_MediaSource2))) continue;
                        o_ChangedMediaSources.add(o_MediaSource2);
                    }
                    if (o_ChangedMediaSources.size() <= 0) continue;
                    for (WatchEvent<?> o_WatchEvent : o_WatchKey.pollEvents()) {
                        if (o_WatchEvent.kind() == StandardWatchEventKinds.OVERFLOW) continue;
                        WatchEvent o_WatchEventCasted = MediaSource_FileWatcher.cast(o_WatchEvent);
                        Path o_WatchEventPath = (Path)o_WatchEventCasted.context();
                        File o_WatchEventFile = o_WatchEventPath.toFile();
                        for (int intMediaSource = o_ChangedMediaSources.size() - 1; intMediaSource >= 0; --intMediaSource) {
                            o_MediaSource2 = (MediaSource)o_ChangedMediaSources.get(intMediaSource);
                            if (!o_WatchKey.equals(MediaSource_FileWatcher.this.m_WatchedMediaSources.get(o_MediaSource2)) || !o_WatchEventFile.getName().equals(o_MediaSource2.getFileName())) continue;
                            if (StandardWatchEventKinds.ENTRY_MODIFY == o_WatchEvent.kind() && o_MediaSource2.checkFileLastModified()) {
                                MediaSource_FileWatcher.this.notify_MediaSourceChanged(o_MediaSource2);
                                continue;
                            }
                            if (StandardWatchEventKinds.ENTRY_DELETE != o_WatchEvent.kind()) continue;
                            MediaSource_FileWatcher.this.notify_MediaSourceDeleted(o_MediaSource2);
                        }
                    }
                    boolean valid = o_WatchKey.reset();
                    if (valid) continue;
                    Iterator o_Iterator_MediaSource = MediaSource_FileWatcher.this.m_WatchedMediaSources.keySet().iterator();
                    while (o_Iterator_MediaSource.hasNext()) {
                        o_MediaSource2 = (MediaSource)o_Iterator_MediaSource.next();
                        if (!o_WatchKey.equals(MediaSource_FileWatcher.this.m_WatchedMediaSources.get(o_MediaSource2))) continue;
                        o_Iterator_MediaSource.remove();
                        o_WatchKey.cancel();
                    }
                }
                MediaSource_FileWatcher.this.closeByWatchthread();
            }
        };
        Thread o_WatchThread = new Thread(o_RunnableWatch, this.getClass().getSimpleName() + "_FileWatch");
        o_WatchThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeByWatchthread() {
        Object object = this.m__SyncListeners;
        synchronized (object) {
            this.m_ChangeListeners.clear();
        }
        try {
            if (this.m_WatchService != null) {
                Iterator<MediaSource> o_Iterator_MediaSource = this.m_WatchedMediaSources.keySet().iterator();
                while (o_Iterator_MediaSource.hasNext()) {
                    MediaSource o_MediaSource = o_Iterator_MediaSource.next();
                    WatchKey o_WatchKeyToRemove = this.m_WatchedMediaSources.get(o_MediaSource);
                    o_Iterator_MediaSource.remove();
                    if (o_WatchKeyToRemove == null) continue;
                    o_WatchKeyToRemove.cancel();
                }
                this.m_WatchService.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void notify_MediaSourceChanged(final MediaSource p_MediaSource) {
        if (p_MediaSource == null) {
            return;
        }
        Runnable o_Runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ArrayList o_ChangeListeners;
                Object object = MediaSource_FileWatcher.this.m__SyncListeners;
                synchronized (object) {
                    o_ChangeListeners = new ArrayList(MediaSource_FileWatcher.this.m_ChangeListeners.size());
                    o_ChangeListeners.addAll(MediaSource_FileWatcher.this.m_ChangeListeners);
                }
                for (int intListener = 0; intListener < o_ChangeListeners.size(); ++intListener) {
                    ChangeListener o_ChangeListener = (ChangeListener)o_ChangeListeners.get(intListener);
                    if (o_ChangeListener instanceof MediaSource) {
                        if (o_ChangeListener != p_MediaSource) continue;
                        try {
                            o_ChangeListener.eventMediaSource_Changed(p_MediaSource);
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    try {
                        o_ChangeListener.eventMediaSource_Changed(p_MediaSource);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        };
        Thread o_ThreadNotify = new Thread(o_Runnable);
        o_ThreadNotify.start();
    }

    protected void notify_MediaSourceDeleted(final MediaSource p_MediaSource) {
        if (p_MediaSource == null) {
            return;
        }
        Runnable o_RunnableDelete = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ArrayList o_ChangeListeners;
                try {
                    Thread.sleep(s_WaitTime_BeforeDelete);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                File o_File = p_MediaSource.getFile();
                if (o_File.exists()) {
                    return;
                }
                Object object = MediaSource_FileWatcher.this.m__SyncListeners;
                synchronized (object) {
                    o_ChangeListeners = new ArrayList(MediaSource_FileWatcher.this.m_ChangeListeners.size());
                    o_ChangeListeners.addAll(MediaSource_FileWatcher.this.m_ChangeListeners);
                }
                for (int intListener = 0; intListener < o_ChangeListeners.size(); ++intListener) {
                    ChangeListener o_ChangeListener = (ChangeListener)o_ChangeListeners.get(intListener);
                    if (o_ChangeListener instanceof MediaSource) {
                        if (o_ChangeListener != p_MediaSource) continue;
                        try {
                            o_ChangeListener.eventMediaSource_Deleted(p_MediaSource);
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    try {
                        o_ChangeListener.eventMediaSource_Deleted(p_MediaSource);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        };
        Thread o_ThreadDelete = new Thread(o_RunnableDelete, this.getClass().getSimpleName() + "_Notify_MediaSourceDeleted");
        o_ThreadDelete.start();
    }

    public static void addChangeListener(ChangeListener p_ChangeListener) {
        if (s_MediaSource_FileWatcher != null) {
            s_MediaSource_FileWatcher.addChangeListenerInternal(p_ChangeListener);
        }
    }

    public static void removeChangeListener(ChangeListener p_ChangeListener) {
        if (s_MediaSource_FileWatcher != null) {
            s_MediaSource_FileWatcher.removeChangeListenerInternal(p_ChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListenerInternal(ChangeListener p_ChangeListener) {
        if (p_ChangeListener == null) {
            return;
        }
        Object object = this.m__SyncListeners;
        synchronized (object) {
            if (this.m_ChangeListeners.contains(p_ChangeListener)) {
                return;
            }
            this.m_ChangeListeners.add(p_ChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListenerInternal(ChangeListener p_ChangeListener) {
        if (p_ChangeListener == null) {
            return;
        }
        Object object = this.m__SyncListeners;
        synchronized (object) {
            this.m_ChangeListeners.remove(p_ChangeListener);
        }
    }

    public static interface ChangeListener {
        public void eventMediaSource_Changed(MediaSource var1);

        public void eventMediaSource_Deleted(MediaSource var1);
    }
}

