/*
 * Decompiled with CFR 0.152.
 */
package MediaPlayerPackage;

import MediaObjectPackage.MediaSource;
import MediaPlayerPackage.LiveShow_MediaPlayer;
import MediaPlayerPackage.LiveShow_MediaSurface;
import TextPackage.MediaTextDocument;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JEditorPane;

public class LiveShow_MediaPlayer_Text
extends LiveShow_MediaPlayer
implements MediaTextDocument.LoadListener,
LiveShow_MediaPlayer.MediaImage {
    public static int s_PoolSize = 100;
    public static ArrayList<LiveShow_MediaPlayer_Text> s_LiveShowMediaPlayersPool = new ArrayList(50);
    public static final Object s_SyncPool = new Object();
    public static long DEFAULTLENGTH_HTML = 10000L;
    private boolean m_Destroyed;
    private boolean m_LoadInProgress;
    private boolean m_IsLoaded;
    private boolean m_IsPlaying;
    private boolean m_IsInsideObject;
    private long m_PlayTIme;
    private Rectangle m_SnapShotOriginRect;
    private MediaTextDocument m_MediaTextDocument;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LiveShow_MediaPlayer_Text poolGet(MediaSource p_MediaSource) {
        LiveShow_MediaPlayer_Text o_LiveShow_MediaPlayer_Text;
        Object object = s_SyncPool;
        synchronized (object) {
            if (s_LiveShowMediaPlayersPool.size() > 0) {
                int intIndex = s_LiveShowMediaPlayersPool.size() - 1;
                o_LiveShow_MediaPlayer_Text = s_LiveShowMediaPlayersPool.get(intIndex);
                o_LiveShow_MediaPlayer_Text.reactivate(p_MediaSource);
                s_LiveShowMediaPlayersPool.remove(intIndex);
            } else {
                o_LiveShow_MediaPlayer_Text = new LiveShow_MediaPlayer_Text(p_MediaSource);
            }
        }
        return o_LiveShow_MediaPlayer_Text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean poolAddEmpty(LiveShow_MediaPlayer_Text p_LiveShow_MediaPlayer_Image) {
        Object object = s_SyncPool;
        synchronized (object) {
            if (s_LiveShowMediaPlayersPool.size() < s_PoolSize) {
                s_LiveShowMediaPlayersPool.add(p_LiveShow_MediaPlayer_Image);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void poolClear() {
        Object object = s_SyncPool;
        synchronized (object) {
            for (int intPool = s_LiveShowMediaPlayersPool.size() - 1; intPool >= 0; --intPool) {
                LiveShow_MediaPlayer_Text o_LiveShow_MediaPlayer_Text = s_LiveShowMediaPlayersPool.get(intPool);
                o_LiveShow_MediaPlayer_Text.destroy();
                s_LiveShowMediaPlayersPool.remove(intPool);
            }
            s_LiveShowMediaPlayersPool.clear();
        }
    }

    public LiveShow_MediaPlayer_Text(MediaSource p_MediaSource) {
        super(p_MediaSource);
        this.initMembers();
        this.setSnapShotUseOriginal(true);
    }

    private void initMembers() {
        this.m_IsPlaying = false;
        this.m_IsInsideObject = false;
        this.m_PlayTIme = 0L;
        this.m_SnapShotOriginRect = new Rectangle(0, 0, 100, 100);
        this.m_MediaTextDocument = new MediaTextDocument();
        this.m_MediaTextDocument.addLoadListener(this);
        this.m_LoadInProgress = false;
        this.m_IsLoaded = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.m_SyncMediaPlayer;
        synchronized (object) {
            if (this.m_Closed) {
                return;
            }
        }
        super.close();
        this.m_MediaTextDocument.removeLoadListener(this);
        this.m_MediaTextDocument.close();
        if (!this.m_WillDestroy && !LiveShow_MediaPlayer_Text.poolAddEmpty(this)) {
            this.destroy();
        }
    }

    @Override
    public void release() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        Object object = this.m_SyncMediaPlayer;
        synchronized (object) {
            if (this.m_Destroyed) {
                return;
            }
            this.m_Destroyed = true;
            this.m_WillDestroy = true;
        }
        if (!this.m_Closed) {
            this.close();
        }
        object = this.m_SyncMediaPlayer;
        synchronized (object) {
            super.destroy();
        }
    }

    @Override
    public Object getSyncImage() {
        return this.m_MediaTextDocument.getSyncImage();
    }

    @Override
    public BufferedImage getBufferedImage() {
        return null;
    }

    @Override
    public long getImageNumber() {
        return 0L;
    }

    @Override
    public long getTimeStamp() {
        return 0L;
    }

    @Override
    public LiveShow_MediaPlayer.MediaImage getMediaImage() {
        return this;
    }

    @Override
    public boolean saveActualImage_PNG(File p_ImageFile) {
        double doubleScaleY;
        double doubleScaleX;
        int intNewWidth;
        int intNewHeight;
        double doubleWidthFactor;
        if (this.m_LiveShow_MediaSurface == null) {
            return false;
        }
        int intWidth = 1920;
        int intHeight = 1080;
        JEditorPane o_JEditorPane = this.getJEditorPane();
        if (o_JEditorPane == null) {
            return false;
        }
        BufferedImage o_BufferedImage = new BufferedImage(intWidth, intHeight, 2);
        Graphics2D o_Graphics2D = (Graphics2D)o_BufferedImage.getGraphics();
        Dimension o_PlayerGrabSize = this.getPlayerGrabSize();
        if (o_PlayerGrabSize == null || o_PlayerGrabSize.width <= 0 || o_PlayerGrabSize.height <= 0) {
            return false;
        }
        double doubleHeightFactor = (double)intHeight / o_PlayerGrabSize.getHeight();
        if (doubleHeightFactor < (doubleWidthFactor = (double)intWidth / o_PlayerGrabSize.getWidth())) {
            intNewHeight = (int)(o_PlayerGrabSize.getHeight() * doubleHeightFactor);
            intNewWidth = (int)(o_PlayerGrabSize.getWidth() * doubleHeightFactor);
            doubleScaleX = doubleHeightFactor;
            doubleScaleY = doubleHeightFactor;
        } else {
            intNewHeight = (int)(o_PlayerGrabSize.getHeight() * doubleWidthFactor);
            intNewWidth = (int)(o_PlayerGrabSize.getWidth() * doubleWidthFactor);
            doubleScaleX = doubleWidthFactor;
            doubleScaleY = doubleWidthFactor;
        }
        int intX = intWidth / 2 - intNewWidth / 2;
        int intY = intHeight / 2 - intNewHeight / 2;
        o_Graphics2D.setBackground(COLOR_TRANSPARENT);
        o_Graphics2D.fillRect(0, 0, intWidth, intHeight);
        o_Graphics2D.translate(intX, intY);
        o_Graphics2D.scale(doubleScaleX, doubleScaleY);
        o_JEditorPane.paint(o_Graphics2D);
        return super.saveActualImage_PNG(p_ImageFile, o_BufferedImage, new Dimension(intNewWidth, intNewHeight));
    }

    @Override
    public void setLiveShow_MediaSurface(LiveShow_MediaSurface p_JPanel_ImageSurface) {
        if (p_JPanel_ImageSurface == null) {
            return;
        }
        super.setLiveShow_MediaSurface(p_JPanel_ImageSurface);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reactivate(MediaSource p_MediaSource) {
        Object object = this.m_SyncMediaPlayer;
        synchronized (object) {
            if (this.m_Destroyed) {
                return;
            }
            super.reactivate(p_MediaSource);
            this.m_MediaTextDocument = new MediaTextDocument();
            this.m_LoadInProgress = false;
            this.m_IsLoaded = false;
        }
        this.m_MediaTextDocument.addLoadListener(this);
    }

    @Override
    public int getMediaType() {
        return 1003;
    }

    public boolean getIsRTF() {
        return this.m_MediaTextDocument.getIsRTF();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean load() {
        MediaSource o_MediaSource = this.m_MediaSource;
        if (o_MediaSource == null) {
            return false;
        }
        if (o_MediaSource.getMediaType() != 1003) {
            return false;
        }
        Object object = this.m_SyncMediaPlayer;
        synchronized (object) {
            if (this.m_Closed) {
                return false;
            }
            if (this.m_LoadInProgress) {
                return true;
            }
            this.m_LoadInProgress = true;
            this.setFade(0.0f, true);
            this.m_MediaTextDocument.load(o_MediaSource.getFile());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void eventLoaded(MediaTextDocument p_MediaTextDocument) {
        this.drawText();
        Object object = this.m_SyncMediaPlayer;
        synchronized (object) {
            this.m_IsLoaded = true;
        }
        this.setMediaReady(true);
        this.recallSnapshotRequests();
        this.paintImage();
    }

    @Override
    public long getLength() {
        return DEFAULTLENGTH_HTML;
    }

    @Override
    protected void setRenderSize(int p_Width, int p_Height) {
    }

    @Override
    public JEditorPane getJEditorPane() {
        return this.m_MediaTextDocument.getJEditorPane();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawText() {
        JEditorPane o_JEditorPane = this.m_MediaTextDocument.getJEditorPane();
        int intOriginWidth = this.m_MediaTextDocument.getViewSize().width;
        int intOriginHeight = this.m_MediaTextDocument.getViewSize().height;
        if (intOriginWidth <= 0) {
            intOriginWidth = 1;
        }
        if (intOriginHeight <= 0) {
            intOriginHeight = 1;
        }
        if (o_JEditorPane == null) {
            return;
        }
        Object object = this.m_SyncMediaPlayer;
        synchronized (object) {
            this.m_PlayerGrabSize.setSize(intOriginWidth, intOriginHeight);
            this.m_RenderSize.setSize(LiveShow_MediaPlayer.SnapshotEventListener.s_SnapShotDimension.width, LiveShow_MediaPlayer.SnapshotEventListener.s_SnapShotDimension.height);
        }
    }

    @Override
    public void findSnapShots() {
        LiveShow_MediaPlayer.SnapshotRequest o_SnapshotRequest = null;
        BufferedImage o_SnapShotImage = null;
        LiveShow_MediaPlayer.SnapshotEventListener o_SnapshotEventListener = null;
        int intNewHeight = 0;
        int intNewWidth = 0;
        int intX = 0;
        int intY = 0;
        JEditorPane o_JEditorPane = this.getJEditorPane();
        if (o_JEditorPane == null) {
            return;
        }
        while (this.getSnapshotRequestCount() > 0) {
            try {
                double doubleWidthFactor;
                o_SnapshotRequest = this.getSnapshotRequest(0);
                if (o_SnapshotRequest == null) {
                    return;
                }
                this.removeSnapshotRequest(o_SnapshotRequest);
                o_SnapShotImage = o_SnapshotRequest.getSnapShotImage();
                if (o_SnapShotImage == null) {
                    return;
                }
                o_SnapshotEventListener = o_SnapshotRequest.getSnapshotEventListener();
                if (o_SnapshotEventListener == null) {
                    return;
                }
                double doubleHeightFactor = (double)o_SnapShotImage.getHeight() / this.m_PlayerGrabSize.getHeight();
                double doubleScale = doubleHeightFactor < (doubleWidthFactor = (double)o_SnapShotImage.getWidth() / this.m_PlayerGrabSize.getWidth()) ? doubleHeightFactor : doubleWidthFactor;
                intNewHeight = (int)(this.m_PlayerGrabSize.getHeight() * doubleScale);
                intNewWidth = (int)(this.m_PlayerGrabSize.getWidth() * doubleScale);
                intX = (o_SnapShotImage.getWidth() - intNewWidth) / 2;
                intY = (o_SnapShotImage.getHeight() - intNewHeight) / 2;
                Graphics2D o_Graphics2D = o_SnapShotImage.createGraphics();
                if (o_Graphics2D == null) {
                    return;
                }
                o_Graphics2D.setColor(COLOR_TRANSPARENT);
                o_Graphics2D.fillRect(0, 0, o_SnapShotImage.getWidth(), o_SnapShotImage.getHeight());
                o_Graphics2D.translate(intX, intY);
                o_Graphics2D.scale(doubleScale, doubleScale);
                o_JEditorPane.paint(o_Graphics2D);
                o_Graphics2D.dispose();
            }
            catch (Exception e) {
                this.addSnapshotRequest(o_SnapshotRequest);
            }
            this.m_SnapShotOriginRect.setRect(intX, intY, intNewWidth, intNewHeight);
            o_SnapshotEventListener.eventSnapshotImage(o_SnapshotRequest.getID(), o_SnapshotRequest.getTime(), o_SnapShotImage, this.m_SnapShotOriginRect);
        }
    }

    @Override
    public void setPlayStatus(float p_Fade, float p_SoundVolume, long p_Milliseconds, boolean p_Playing, boolean p_InsideObject) {
        this.m_IsPlaying = p_Playing;
        this.m_IsInsideObject = p_InsideObject;
        this.m_PlayTIme = p_Milliseconds;
        super.setFade(p_Fade, true);
    }

    @Override
    public boolean isPlaying() {
        return this.m_IsPlaying;
    }

    @Override
    public boolean isInsideObject() {
        return this.m_IsInsideObject;
    }

    @Override
    public long getPlayTime() {
        return this.m_PlayTIme;
    }
}

