/*
 * Decompiled with CFR 0.152.
 */
package MediaPlayerPackage;

import BioMathmaticsPackage.BioMathematics;
import GUID.LiveGUID;
import GraphicsDeviceToolsPackage.GraphicsDeviceTools;
import LiveShowObjectPackage.LiveShowObject;
import MediaObjectPackage.MediaSource;
import MediaPlayerPackage.LiveShow_MediaPlayer_Image;
import MediaPlayerPackage.LiveShow_MediaPlayer_Text;
import MediaPlayerPackage.LiveShow_MediaSurface;
import SynchronizationPackage.EventQueueHandler;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.swing.JEditorPane;

public abstract class LiveShow_MediaPlayer {
    public static Rectangle s_RenderSize = GraphicsDeviceTools.getDefaultGraphicsDevice_Bounds();
    public static ArrayList<LiveShow_MediaPlayer> s_LiveShow_MediaPlayers = new ArrayList();
    public static final Dimension RENDER_SIZE_VGA = new Dimension(640, 480);
    public static final Dimension RENDER_SIZE_WVGA = new Dimension(800, 480);
    public static final Dimension RENDER_SIZE_SVGA = new Dimension(800, 600);
    public static final Dimension RENDER_SIZE_XGA = new Dimension(1024, 768);
    public static final Dimension RENDER_SIZE_HD_720 = new Dimension(1280, 720);
    public static final Dimension RENDER_SIZE_HD_WXGA = new Dimension(1280, 768);
    public static final Dimension RENDER_SIZE_HD_UWXGA = new Dimension(1600, 768);
    public static final Dimension RENDER_SIZE_HD_UXGA = new Dimension(1600, 1200);
    public static final Dimension RENDER_SIZE_HD_1080 = new Dimension(1920, 1080);
    public static final Dimension RENDER_SIZE_HD_WQXGA = new Dimension(2560, 1600);
    public static final Dimension RENDER_SIZE_HD_ULTRA = new Dimension(3840, 2160);
    public static final Dimension RENDER_SIZE_8K_ULTRA = new Dimension(7680, 4320);
    public static Dimension RENDER_SIZE_DEFAULT = new Dimension(RENDER_SIZE_HD_1080);
    public static Dimension[] s_RenderDimensions = new Dimension[]{RENDER_SIZE_VGA, RENDER_SIZE_WVGA, RENDER_SIZE_SVGA, RENDER_SIZE_XGA, RENDER_SIZE_HD_720, RENDER_SIZE_HD_WXGA, RENDER_SIZE_HD_UWXGA, RENDER_SIZE_HD_UXGA, RENDER_SIZE_HD_1080, RENDER_SIZE_HD_WQXGA, RENDER_SIZE_HD_ULTRA, RENDER_SIZE_8K_ULTRA};
    public static Color COLOR_TRANSPARENT = new Color(0, 0, 0, 0);
    public static Dimension s_SnapShotSize = new Dimension(960, 540);
    protected String m_ID;
    protected String m_Name;
    protected int m_Index;
    protected MediaSource m_MediaSource;
    protected Dimension m_RenderSize;
    protected BufferedImage m_BufferedImagePrepared;
    protected Runnable m_RunnableRefresh;
    protected boolean m_SnapShotUseOriginal;
    protected ArrayList<SnapshotRequest> m_SnapshotRequests;
    protected ArrayList<SnapshotRequest> m_RecallSnapshotRequests;
    protected final Object m_SyncSnapshot = new Object();
    protected LiveShow_MediaSurface m_LiveShow_MediaSurface;
    protected float m_Fade;
    protected Dimension m_PlayerGrabSize;
    protected Dimension m_SourceSize;
    protected int m_Anchor;
    protected int m_FlagAspect;
    protected int m_FlagSize;
    protected int m_FlagPosition;
    protected Rectangle2D m_RelativePositionSize;
    protected boolean m_FlipHorizontally;
    protected boolean m_FlipVertically;
    protected double m_RotateValue;
    protected int m_ZOrder;
    protected float m_SoundVolume;
    protected long m_SoundDelay;
    protected boolean m_Closed;
    protected boolean m_Destroyed;
    protected boolean m_WillDestroy;
    protected boolean m_MediaReady;
    protected boolean m_MediaError;
    protected Runnable m_Runnable_Notify_Ready;
    protected Runnable m_Runnable_Notify_Error;
    protected String m_MediaErrorString;
    protected ArrayList<MediaPlayerListener> m_MediaPlayerListeners;
    protected LiveShow_MediaPlayer m_Selfreference;
    protected long m_Paint_LastNanos;
    protected long m_ImageNumber_Actual;
    protected AffineTransform m_AffineTransform;
    protected final Object m_SyncSurface = new Object();
    protected final Object m_SyncMediaPlayer = new Object();
    protected final Object m_SyncListener = new Object();
    private BufferedImage m_PreparedBufferedImage_InPaintProcess = null;
    protected final Object m_SyncPreparedBufferedImage = new Object();
    private Runnable m_RunnableFindSnapshots = new Runnable(){

        @Override
        public void run() {
            LiveShow_MediaPlayer.this.findSnapShots();
        }
    };

    public static Dimension findNearestRenderDimension(Dimension p_Dimension) {
        if (p_Dimension == null) {
            return RENDER_SIZE_HD_1080;
        }
        int intDistance = Integer.MAX_VALUE;
        Dimension o_Dimension1Result = null;
        int intWidhtPlusHeight_Param = p_Dimension.width + p_Dimension.height;
        for (int intDimension = 0; intDimension < s_RenderDimensions.length; ++intDimension) {
            Dimension o_Dimension = s_RenderDimensions[intDimension];
            int intWidhtPlusHeight_DisplayRenderSize = o_Dimension.width + o_Dimension.height;
            if (intWidhtPlusHeight_DisplayRenderSize == intWidhtPlusHeight_Param) {
                o_Dimension1Result = o_Dimension;
                break;
            }
            if (intWidhtPlusHeight_DisplayRenderSize >= intWidhtPlusHeight_Param) break;
            if (intDistance <= intWidhtPlusHeight_Param - intWidhtPlusHeight_DisplayRenderSize) continue;
            intDistance = intWidhtPlusHeight_Param - intWidhtPlusHeight_DisplayRenderSize;
            o_Dimension1Result = o_Dimension;
        }
        if (o_Dimension1Result == null) {
            o_Dimension1Result = RENDER_SIZE_HD_1080;
        }
        return o_Dimension1Result;
    }

    public static void poolClear() {
        LiveShow_MediaPlayer_Text.poolClear();
        LiveShow_MediaPlayer_Image.poolClear();
    }

    public LiveShow_MediaPlayer(MediaSource p_MediaSource) {
        this.initMembers();
        this.m_MediaSource = p_MediaSource;
        s_LiveShow_MediaPlayers.add(this);
    }

    private void initMembers() {
        this.m_Selfreference = this;
        this.m_ID = LiveGUID.getUID();
        this.m_Name = "";
        this.m_Index = 0;
        this.m_RenderSize = new Dimension(LiveShow_MediaPlayer.s_RenderSize.width, LiveShow_MediaPlayer.s_RenderSize.height);
        this.m_PlayerGrabSize = new Dimension(0, 0);
        this.m_SourceSize = new Dimension(0, 0);
        this.m_Fade = 0.0f;
        this.m_Anchor = 0;
        this.m_FlagAspect = 0;
        this.m_FlagSize = 0;
        this.m_FlagPosition = 0;
        this.m_RelativePositionSize = new Rectangle2D.Double();
        this.m_RelativePositionSize.setRect(0.0, 0.0, 1.0, 1.0);
        this.m_ZOrder = 0;
        this.m_FlipHorizontally = false;
        this.m_FlipVertically = false;
        this.m_RotateValue = 0.0;
        this.m_LiveShow_MediaSurface = null;
        this.m_Closed = false;
        this.m_Destroyed = false;
        this.m_WillDestroy = false;
        this.m_MediaReady = false;
        this.m_MediaError = false;
        this.m_MediaErrorString = "";
        this.m_MediaPlayerListeners = new ArrayList();
        this.m_SnapShotUseOriginal = false;
        this.m_SnapshotRequests = new ArrayList();
        this.m_RecallSnapshotRequests = new ArrayList();
        this.m_AffineTransform = new AffineTransform();
        this.m_Paint_LastNanos = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.m_SyncMediaPlayer;
        synchronized (object) {
            if (this.m_Closed) {
                return;
            }
            this.m_Closed = true;
        }
        this.notifyListeners_Close();
        s_LiveShow_MediaPlayers.remove(this);
        this.setFade(0.0f, true);
        LiveShow_MediaSurface o_LiveShow_MediaSurface = this.m_LiveShow_MediaSurface;
        if (o_LiveShow_MediaSurface != null) {
            this.removeLiveShow_MediaSurface(o_LiveShow_MediaSurface);
        }
        object = this.m_SyncListener;
        synchronized (object) {
            this.m_MediaPlayerListeners.clear();
        }
        object = this.m_SyncSnapshot;
        synchronized (object) {
            this.m_SnapshotRequests.clear();
            this.m_RecallSnapshotRequests.clear();
        }
        this.setMediaReady(false);
        this.setMediaError(false, "");
        object = this.m_SyncMediaPlayer;
        synchronized (object) {
            this.m_MediaSource = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.m_SyncMediaPlayer;
        synchronized (object) {
            if (this.m_Destroyed) {
                return;
            }
            this.m_Destroyed = true;
        }
        if (!this.m_Closed) {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reactivate(MediaSource p_MediaSource) {
        Object object = this.m_SyncMediaPlayer;
        synchronized (object) {
            if (this.m_Destroyed) {
                return;
            }
            this.m_Name = "";
            this.m_Index = 0;
            this.m_Closed = false;
            this.m_MediaSource = p_MediaSource;
            this.m_RenderSize = new Dimension(LiveShow_MediaPlayer.s_RenderSize.width, LiveShow_MediaPlayer.s_RenderSize.height);
            this.m_PlayerGrabSize.setSize(0, 0);
            this.m_SourceSize.setSize(0, 0);
            this.m_Fade = 0.0f;
            this.m_Anchor = 0;
            this.m_FlagAspect = 0;
            this.m_FlagSize = 0;
            this.m_FlagPosition = 0;
            this.m_RelativePositionSize = new Rectangle2D.Double();
            this.m_RelativePositionSize.setRect(0.0, 0.0, 1.0, 1.0);
            this.m_ZOrder = 0;
            this.m_FlipHorizontally = false;
            this.m_FlipVertically = false;
            this.m_RotateValue = 0.0;
        }
    }

    public String getID() {
        return this.m_ID;
    }

    public void setName(String p_Name) {
        if (p_Name == null) {
            return;
        }
        this.m_Name = p_Name;
    }

    public String getName() {
        return this.m_Name;
    }

    public void setIndex(int p_Index) {
        this.m_Index = p_Index;
    }

    public int getIndex() {
        return this.m_Index;
    }

    protected void setMediaReady(boolean p_MediaReady) {
        if (this.m_MediaReady == p_MediaReady) {
            return;
        }
        LiveShowObject o_LiveShowObject = null;
        this.m_MediaReady = p_MediaReady;
        if (this.m_Runnable_Notify_Ready == null) {
            this.m_Runnable_Notify_Ready = new Runnable(){

                @Override
                public void run() {
                    LiveShow_MediaPlayer.this.notifyListeners_Ready(LiveShow_MediaPlayer.this.m_MediaReady);
                }
            };
        }
        MediaSource o_MediaSource = this.m_MediaSource;
        if (!this.m_Closed) {
            if (o_MediaSource != null) {
                o_LiveShowObject = o_MediaSource.getLiveShowObject();
            }
            if (o_LiveShowObject == null) {
                this.setPlayStatus(0.0f, 0.0f, 0L, false, false);
            } else {
                this.setPlayStatus(0.0f, 0.0f, (long)((double)o_LiveShowObject.getFrameStartOffset() * o_LiveShowObject.getFrameTime()), false, false);
                if (this.m_MediaReady) {
                    EventQueueHandler.invokeLater((Runnable)this.m_RunnableFindSnapshots);
                }
            }
        }
        EventQueueHandler.invokeLater((Runnable)this.m_Runnable_Notify_Ready);
    }

    public boolean getMediaReady() {
        return this.m_MediaReady;
    }

    protected void setMediaError(boolean p_Error, String p_ErrorString) {
        if (this.m_MediaError == p_Error) {
            return;
        }
        this.m_MediaError = p_Error;
        this.m_MediaErrorString = p_ErrorString == null ? "" : p_ErrorString;
        if (this.m_Runnable_Notify_Error == null) {
            this.m_Runnable_Notify_Error = new Runnable(){

                @Override
                public void run() {
                    LiveShow_MediaPlayer.this.notifyListeners_Error(LiveShow_MediaPlayer.this.m_MediaErrorString);
                }
            };
        }
        Thread o_Thread = new Thread(this.m_Runnable_Notify_Error, this.getClass().getSimpleName() + "_SetMediaError");
        o_Thread.start();
    }

    public boolean getMediaError() {
        return this.m_MediaError;
    }

    public String getMediaErrorString() {
        return this.m_MediaErrorString;
    }

    public long getLength() {
        return -1L;
    }

    public int getMediaType() {
        return -1;
    }

    public abstract Object getSyncImage();

    public abstract BufferedImage getBufferedImage();

    public abstract MediaImage getMediaImage();

    public AffineTransform getAffineTransform() {
        return this.m_AffineTransform;
    }

    public boolean getSnapShotUseOriginal() {
        return this.m_SnapShotUseOriginal;
    }

    public void setSnapShotUseOriginal(boolean p_UseOriginalImage) {
        this.m_SnapShotUseOriginal = p_UseOriginalImage;
    }

    public Dimension getRenderSize() {
        return this.m_RenderSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setRenderSize(int p_Width, int p_Height) {
        if (this.m_RenderSize.width == p_Width && this.m_RenderSize.height == p_Height) {
            return;
        }
        if (p_Width < 1) {
            return;
        }
        if (p_Height < 1) {
            return;
        }
        Object object = this.m_SyncMediaPlayer;
        synchronized (object) {
            this.m_RenderSize.setSize(p_Width, p_Height);
        }
        this.load();
    }

    public void setMediaSurfaceSize(int p_Width, int p_Height) {
    }

    public abstract boolean saveActualImage_PNG(File var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveActualImage_PNG(File p_ImageFile, BufferedImage p_BufferedImage, Dimension p_Size) {
        if (p_BufferedImage == null) {
            return false;
        }
        if (p_ImageFile == null) {
            return false;
        }
        try {
            Graphics2D o_Graphics2D_Copy;
            BufferedImage o_BufferedImage;
            Object object = this.m_SyncMediaPlayer;
            synchronized (object) {
                o_BufferedImage = new BufferedImage(p_Size.width, p_Size.height, 2);
                o_Graphics2D_Copy = o_BufferedImage.createGraphics();
                o_Graphics2D_Copy.drawImage(p_BufferedImage, 0, 0, p_Size.width, p_Size.height, 0, 0, p_BufferedImage.getWidth(), p_BufferedImage.getHeight(), null);
            }
            ImageIO.write((RenderedImage)o_BufferedImage, "png", p_ImageFile);
            o_Graphics2D_Copy.dispose();
            o_BufferedImage.flush();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public void setSoundVolume(float p_Volume) {
        if (p_Volume < 0.0f) {
            p_Volume = 0.0f;
        }
        if (p_Volume > 2.0f) {
            p_Volume = 2.0f;
        }
        this.m_SoundVolume = (float)BioMathematics.calculateVolumeFactor_Logarithm((double)p_Volume);
    }

    public float getSoundVolume() {
        return this.m_SoundVolume;
    }

    public void setSoundDelay(long p_Delay_ms) {
        if (p_Delay_ms < 0L) {
            p_Delay_ms = 0L;
        }
        this.m_SoundDelay = p_Delay_ms;
    }

    public long getSoundDelay() {
        return this.m_SoundDelay;
    }

    public void setSourceSize(Dimension p_Size) {
        if (p_Size == null) {
            return;
        }
        if (p_Size.height == this.m_SourceSize.height && p_Size.width == this.m_SourceSize.width) {
            return;
        }
        this.m_SourceSize.setSize(p_Size);
    }

    public void setSourceSize(int p_Width, int p_Height) {
        if (p_Width == this.m_SourceSize.width && p_Height == this.m_SourceSize.height) {
            return;
        }
        this.m_SourceSize.setSize(p_Width, p_Height);
    }

    public Dimension getSourceSize() {
        return this.m_SourceSize;
    }

    public void setPlayerGrabSize(Dimension p_Size) {
        if (p_Size == null) {
            return;
        }
        if (p_Size.height == this.m_PlayerGrabSize.height && p_Size.width == this.m_PlayerGrabSize.width) {
            return;
        }
        this.m_PlayerGrabSize.setSize(p_Size);
    }

    public void setPlayerGrabSize(int p_Width, int p_Height) {
        if (p_Width == this.m_PlayerGrabSize.width && p_Height == this.m_PlayerGrabSize.height) {
            return;
        }
        this.m_PlayerGrabSize.setSize(p_Width, p_Height);
    }

    public Dimension getPlayerGrabSize() {
        return this.m_PlayerGrabSize;
    }

    public void setAnchor(int p_Anchor) {
        if (p_Anchor < 0 || p_Anchor > 8) {
            return;
        }
        if (this.m_Anchor == p_Anchor) {
            return;
        }
        this.m_Anchor = p_Anchor;
        this.paintImage();
    }

    public int getAnchor() {
        return this.m_Anchor;
    }

    public void setFlagAspect(int p_FlagAspect) {
        if (p_FlagAspect != 0 && p_FlagAspect != 1) {
            return;
        }
        if (this.m_FlagAspect == p_FlagAspect) {
            return;
        }
        this.m_FlagAspect = p_FlagAspect;
        this.paintImage();
    }

    public int getFlagAspect() {
        return this.m_FlagAspect;
    }

    public void setFlagSize(int p_FlagSize) {
        if (p_FlagSize != 0 && p_FlagSize != 1) {
            p_FlagSize = 0;
        }
        if (this.m_FlagSize == p_FlagSize) {
            return;
        }
        this.m_FlagSize = p_FlagSize;
        this.paintImage();
    }

    public int getFlagSize() {
        return this.m_FlagSize;
    }

    public void setFlagPosition(int p_FlagPosition) {
        if (p_FlagPosition != 0 && p_FlagPosition != 1) {
            return;
        }
        if (this.m_FlagPosition == p_FlagPosition) {
            return;
        }
        this.m_FlagPosition = p_FlagPosition;
        this.paintImage();
    }

    public int getFlagPosition() {
        return this.m_FlagPosition;
    }

    public void setRelativePositionSize(Rectangle2D p_RelativePositionSize) {
        if (p_RelativePositionSize == null) {
            return;
        }
        if (this.m_RelativePositionSize.equals(p_RelativePositionSize)) {
            return;
        }
        this.m_RelativePositionSize.setRect(p_RelativePositionSize);
        this.paintImage();
    }

    public Rectangle2D getRelativePositionSize() {
        return this.m_RelativePositionSize;
    }

    public void setFlipHorizontally(boolean p_FlipHorizontally) {
        if (this.m_FlipHorizontally == p_FlipHorizontally) {
            return;
        }
        this.m_FlipHorizontally = p_FlipHorizontally;
        this.paintImage();
    }

    public boolean getFlipHorizontally() {
        return this.m_FlipHorizontally;
    }

    public void setFlipVertically(boolean p_FlipVertically) {
        if (this.m_FlipVertically == p_FlipVertically) {
            return;
        }
        this.m_FlipVertically = p_FlipVertically;
        this.paintImage();
    }

    public boolean getFlipVertically() {
        return this.m_FlipVertically;
    }

    public void setRotateValue(double p_RotateValue) {
        if (this.m_RotateValue == p_RotateValue) {
            return;
        }
        this.m_RotateValue = p_RotateValue;
        this.paintImage();
    }

    public double getRotateValue() {
        return this.m_RotateValue;
    }

    public void setZOrder(int p_ZOrder) {
        if (this.m_ZOrder == p_ZOrder) {
            return;
        }
        this.m_ZOrder = p_ZOrder;
        LiveShow_MediaSurface o_LiveShow_MediaSurface = this.m_LiveShow_MediaSurface;
        if (o_LiveShow_MediaSurface == null) {
            return;
        }
        o_LiveShow_MediaSurface.resort(this);
        this.paintImage();
    }

    public int getZOrder() {
        return this.m_ZOrder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLiveShow_MediaSurface(LiveShow_MediaSurface p_LiveShow_MediaSurface) {
        if (p_LiveShow_MediaSurface == null) {
            return;
        }
        if (this.m_LiveShow_MediaSurface == p_LiveShow_MediaSurface) {
            return;
        }
        Object object = this.m_SyncSurface;
        synchronized (object) {
            this.m_LiveShow_MediaSurface = p_LiveShow_MediaSurface;
            this.m_RenderSize.setSize(p_LiveShow_MediaSurface.getRenderBounds().width, p_LiveShow_MediaSurface.getRenderBounds().height);
        }
        this.load();
        p_LiveShow_MediaSurface.addLiveShow_MediaPlayer(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLiveShow_MediaSurface(LiveShow_MediaSurface p_JPanel_ImageSurface) {
        if (p_JPanel_ImageSurface == null) {
            return;
        }
        if (this.m_LiveShow_MediaSurface != p_JPanel_ImageSurface) {
            return;
        }
        Object object = this.m_SyncSurface;
        synchronized (object) {
            this.m_LiveShow_MediaSurface = null;
        }
        p_JPanel_ImageSurface.removeLiveShow_MediaPlayer(this);
        this.release();
    }

    public LiveShow_MediaSurface getLiveShow_MediaSurface() {
        return this.m_LiveShow_MediaSurface;
    }

    protected abstract void release();

    public abstract boolean load();

    public abstract void setPlayStatus(float var1, float var2, long var3, boolean var5, boolean var6);

    public abstract boolean isPlaying();

    public abstract boolean isInsideObject();

    public abstract long getPlayTime();

    public MediaSource getMediaSource() {
        return this.m_MediaSource;
    }

    public float getFade() {
        return this.m_Fade;
    }

    public void setFade(float p_Fade, boolean p_Refresh) {
        if (p_Fade < 0.0f) {
            p_Fade = 0.0f;
        } else if (p_Fade > 2.0f) {
            p_Fade = 2.0f;
        } else if (p_Refresh) {
            p_Fade = (float)((int)(p_Fade * 200.0f)) / 200.0f;
        }
        if (this.m_Fade == p_Fade) {
            return;
        }
        this.m_Fade = p_Fade;
        if (p_Refresh) {
            this.paintImage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freePreparedBufferdImage(BufferedImage p_BufferedImage) {
        Object object = this.m_SyncPreparedBufferedImage;
        synchronized (object) {
            this.m_PreparedBufferedImage_InPaintProcess = null;
        }
    }

    public void paintImage() {
        if (this.m_Closed) {
            return;
        }
        LiveShow_MediaSurface o_LiveShow_MediaSurface = this.m_LiveShow_MediaSurface;
        if (o_LiveShow_MediaSurface == null) {
            return;
        }
        o_LiveShow_MediaSurface.paintImage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMediaPlayerListener(MediaPlayerListener p_MediaPlayerListener) {
        if (p_MediaPlayerListener == null) {
            return;
        }
        Object object = this.m_SyncListener;
        synchronized (object) {
            if (this.m_MediaPlayerListeners.contains(p_MediaPlayerListener)) {
                return;
            }
            this.m_MediaPlayerListeners.add(p_MediaPlayerListener);
        }
        if (this.m_MediaReady) {
            p_MediaPlayerListener.eventReady(this.m_Selfreference, true);
        }
        if (this.m_MediaError) {
            p_MediaPlayerListener.eventError(this.m_Selfreference, this.m_MediaErrorString);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMediaPlayerListener(MediaPlayerListener p_MediaPlayerListener) {
        if (p_MediaPlayerListener == null) {
            return;
        }
        Object object = this.m_SyncListener;
        synchronized (object) {
            if (!this.m_MediaPlayerListeners.contains(p_MediaPlayerListener)) {
                return;
            }
            this.m_MediaPlayerListeners.remove(p_MediaPlayerListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyListeners_Ready(boolean p_Ready) {
        ArrayList<MediaPlayerListener> o_Listeners;
        Object object = this.m_SyncListener;
        synchronized (object) {
            if (this.m_MediaPlayerListeners.size() <= 0) {
                return;
            }
            o_Listeners = new ArrayList<MediaPlayerListener>(this.m_MediaPlayerListeners.size());
            o_Listeners.addAll(this.m_MediaPlayerListeners);
        }
        for (int intListener = 0; intListener < o_Listeners.size(); ++intListener) {
            MediaPlayerListener o_MediaPlayerListener = (MediaPlayerListener)o_Listeners.get(intListener);
            o_MediaPlayerListener.eventReady(this, p_Ready);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyListeners_Error(String p_ErrorString) {
        ArrayList<MediaPlayerListener> o_Listeners;
        Object object = this.m_SyncListener;
        synchronized (object) {
            if (this.m_MediaPlayerListeners.size() <= 0) {
                return;
            }
            o_Listeners = new ArrayList<MediaPlayerListener>(this.m_MediaPlayerListeners.size());
            o_Listeners.addAll(this.m_MediaPlayerListeners);
        }
        for (int intListener = 0; intListener < o_Listeners.size(); ++intListener) {
            MediaPlayerListener o_MediaPlayerListener = (MediaPlayerListener)o_Listeners.get(intListener);
            o_MediaPlayerListener.eventError(this, p_ErrorString);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyListeners_Close() {
        ArrayList<MediaPlayerListener> o_Listeners;
        Object object = this.m_SyncListener;
        synchronized (object) {
            if (this.m_MediaPlayerListeners.size() <= 0) {
                return;
            }
            o_Listeners = new ArrayList<MediaPlayerListener>(this.m_MediaPlayerListeners.size());
            o_Listeners.addAll(this.m_MediaPlayerListeners);
        }
        for (int intListener = 0; intListener < o_Listeners.size(); ++intListener) {
            MediaPlayerListener o_MediaPlayerListener = (MediaPlayerListener)o_Listeners.get(intListener);
            o_MediaPlayerListener.eventClose(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requestSnapshot(String p_ID, BufferedImage p_SnapShotImage, long p_Milliseconds, SnapshotEventListener p_SnapshotEventListener) {
        if (p_ID == null) {
            return false;
        }
        if (p_SnapshotEventListener == null) {
            return false;
        }
        if (p_Milliseconds < 0L) {
            return false;
        }
        if (p_SnapShotImage == null) {
            p_SnapShotImage = new BufferedImage(SnapshotEventListener.s_SnapShotDimension.width, SnapshotEventListener.s_SnapShotDimension.height, 2);
        }
        Object object = this.m_SyncSnapshot;
        synchronized (object) {
            SnapshotRequest o_SnapshotRequest;
            if (this.m_Closed) {
                return false;
            }
            boolean boolFound = false;
            for (int intRequest = 0; intRequest < this.m_SnapshotRequests.size(); ++intRequest) {
                o_SnapshotRequest = this.m_SnapshotRequests.get(intRequest);
                if (!p_ID.equals(o_SnapshotRequest.getID())) continue;
                boolFound = true;
                o_SnapshotRequest.setSnapshotEventListener(p_SnapshotEventListener);
                o_SnapshotRequest.setTime(p_Milliseconds);
                o_SnapshotRequest.setImageFetched(false);
                break;
            }
            if (!boolFound) {
                o_SnapshotRequest = new SnapshotRequest(p_ID, p_SnapShotImage, p_Milliseconds, p_SnapshotEventListener);
                this.m_SnapshotRequests.add(o_SnapshotRequest);
            }
        }
        this.findSnapShots();
        return true;
    }

    public int getSnapshotRequestCount() {
        return this.m_SnapshotRequests.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSnapshotRequest(SnapshotRequest p_SnapshotRequest) {
        if (p_SnapshotRequest == null) {
            return;
        }
        Object object = this.m_SyncSnapshot;
        synchronized (object) {
            if (this.m_SnapshotRequests.remove(p_SnapshotRequest) && !this.m_RecallSnapshotRequests.contains(p_SnapshotRequest)) {
                this.m_RecallSnapshotRequests.add(p_SnapshotRequest);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSnapshotRequest(SnapshotRequest p_SnapshotRequest) {
        if (p_SnapshotRequest == null) {
            return;
        }
        Object object = this.m_SyncSnapshot;
        synchronized (object) {
            if (this.m_SnapshotRequests.contains(p_SnapshotRequest)) {
                return;
            }
            this.m_SnapshotRequests.add(p_SnapshotRequest);
            this.m_RecallSnapshotRequests.remove(p_SnapshotRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SnapshotRequest getSnapshotRequest(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        Object object = this.m_SyncSnapshot;
        synchronized (object) {
            if (p_Index >= this.m_SnapshotRequests.size()) {
                return null;
            }
            return this.m_SnapshotRequests.get(p_Index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recallSnapshotRequests() {
        Object object = this.m_SyncSnapshot;
        synchronized (object) {
            for (int intRequest = this.m_RecallSnapshotRequests.size() - 1; intRequest >= 0; --intRequest) {
                SnapshotRequest o_SnapshotRequest = this.m_RecallSnapshotRequests.get(intRequest);
                this.m_SnapshotRequests.add(o_SnapshotRequest);
                this.m_RecallSnapshotRequests.remove(intRequest);
            }
        }
        this.findSnapShots();
    }

    public abstract void findSnapShots();

    public abstract JEditorPane getJEditorPane();

    public static interface SnapshotEventListener {
        public static final Dimension s_SnapShotDimension = new Dimension(250, 250);

        public void eventSnapshotImage(String var1, long var2, Image var4, Rectangle var5);
    }

    public static class SnapshotRequest {
        private String m_ID;
        private BufferedImage m_SnapShotImage;
        private SnapshotEventListener m_SnapshotEventListener;
        private long m_Time;
        private boolean m_ImageFetched;

        public SnapshotRequest(String p_ID, BufferedImage p_BufferedImage, long p_Time, SnapshotEventListener p_SnapshotEventListener) {
            this.m_ID = p_ID;
            this.m_SnapShotImage = p_BufferedImage;
            this.m_Time = p_Time;
            this.m_SnapshotEventListener = p_SnapshotEventListener;
            this.m_ImageFetched = false;
        }

        public String getID() {
            return this.m_ID;
        }

        public BufferedImage getSnapShotImage() {
            return this.m_SnapShotImage;
        }

        public void setTime(long p_Time) {
            if (this.m_Time == p_Time) {
                return;
            }
            this.m_ImageFetched = false;
            this.m_Time = p_Time;
        }

        public long getTime() {
            return this.m_Time;
        }

        public void setImageFetched(boolean p_ImageFetched) {
            this.m_ImageFetched = p_ImageFetched;
        }

        public boolean getImageFetched() {
            return this.m_ImageFetched;
        }

        public void setSnapshotEventListener(SnapshotEventListener p_SnapshotEventListener) {
            this.m_SnapshotEventListener = p_SnapshotEventListener;
        }

        public SnapshotEventListener getSnapshotEventListener() {
            return this.m_SnapshotEventListener;
        }
    }

    public static interface MediaPlayerListener {
        public void eventReady(LiveShow_MediaPlayer var1, boolean var2);

        public void eventError(LiveShow_MediaPlayer var1, String var2);

        public void eventClose(LiveShow_MediaPlayer var1);
    }

    public static interface MediaImage {
        public long getImageNumber();

        public long getTimeStamp();

        public BufferedImage getBufferedImage();
    }
}

