/*
 * Decompiled with CFR 0.152.
 */
package MediaPlayerPackage;

import GraphicsDeviceToolsPackage.GraphicsDeviceTools;
import MediaPlayerPackage.LiveShow_MediaPlayer;
import MediaPlayerPackage.LiveShow_MediaPlayer_Text;
import MediaPlayerPackage.LiveShow_MediaSurface;
import MediaPlayerPackage.PlayerPaintHandler;
import ToolsGraphics.GraphicsTools;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class JPanel_MediaSurface
extends JPanel
implements LiveShow_MediaSurface {
    public static Color COLOR_TRANSPARENT = new Color(0, 0, 0, 0);
    public static Cursor CURSOR_BLANK;
    private boolean m_MouseMoved;
    private Thread m_MouseMovedThread;
    private final Object m_MouseMovedSync = new Object();
    private boolean m_MouseMovedClose;
    private Runnable m_Runnable_Repaint;
    private ArrayList<LiveShow_MediaPlayer> m_LiveShow_MediaPlayers;
    private final Object m_SyncMediaPlayers = new Object();
    private Rectangle m_RenderSize;
    private BufferedImage m_BufferedImage_Interim;
    private GraphicsTools.Spline m_Spline_AlphaComposite;
    private JPanel_MediaSurface m_SelfReference;
    long longTimeLastPaintComponent = 0L;
    long longTimePaintComponent = 0L;

    public JPanel_MediaSurface() {
        this.initMembers();
        this.initComponents();
        this.initComponentsFurther();
    }

    private void initComponents() {
        this.setBackground(new Color(0, 0, 0));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                JPanel_MediaSurface.this.formComponentResized(evt);
            }
        });
        this.setLayout((LayoutManager)new AbsoluteLayout());
    }

    private void formComponentResized(ComponentEvent evt) {
    }

    private void initMembers() {
        this.m_SelfReference = this;
        this.m_LiveShow_MediaPlayers = new ArrayList();
        this.m_BufferedImage_Interim = null;
        this.m_RenderSize = new Rectangle();
        this.setRenderSize(GraphicsDeviceTools.getDefaultGraphicsDevice_Bounds());
        this.m_Spline_AlphaComposite = new GraphicsTools.Spline();
        this.m_Spline_AlphaComposite.addPoint(new Point2D.Double(0.0, 0.0));
        this.m_Spline_AlphaComposite.addPoint(new Point2D.Double(0.5, 0.7));
        this.m_Spline_AlphaComposite.addPoint(new Point2D.Double(1.0, 1.0));
        this.m_Spline_AlphaComposite.calculateSpline();
        CURSOR_BLANK = Toolkit.getDefaultToolkit().createCustomCursor(new ImageIcon(this.getClass().getResource("/IconsPackage/MousePointer_Blank.png")).getImage(), new Point(0, 0), "CursorPlayCursor");
        this.m_MouseMoved = false;
        this.m_MouseMovedClose = false;
    }

    private void initComponentsFurther() {
        ComponentAdapter o_ComponentListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (JPanel_MediaSurface.this.getWidth() <= 0 || JPanel_MediaSurface.this.getHeight() <= 0) {
                    return;
                }
                for (int intMediaPlayer = 0; intMediaPlayer < JPanel_MediaSurface.this.getLiveShow_MediaPlayer_Count(); ++intMediaPlayer) {
                    LiveShow_MediaPlayer o_LiveShow_MediaPlayer = JPanel_MediaSurface.this.getLiveShow_MediaPlayer(intMediaPlayer);
                    o_LiveShow_MediaPlayer.setMediaSurfaceSize(JPanel_MediaSurface.this.getWidth(), JPanel_MediaSurface.this.getHeight());
                }
                JPanel_MediaSurface.this.paintImage();
            }
        };
        this.addComponentListener(o_ComponentListener);
        this.m_Runnable_Repaint = new Runnable(){

            @Override
            public void run() {
                JPanel_MediaSurface.this.repaint();
            }
        };
        this.setBackground(Color.BLACK);
        this.setOpaque(true);
        this.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                JPanel_MediaSurface.this.m_MouseMoved = true;
            }
        });
        this.m_MouseMovedThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (!JPanel_MediaSurface.this.m_MouseMovedClose) {
                    Object object = JPanel_MediaSurface.this.m_MouseMovedSync;
                    synchronized (object) {
                        try {
                            long longWaitTime = 1000L;
                            JPanel_MediaSurface.this.m_MouseMovedSync.wait(longWaitTime);
                        }
                        catch (Exception e) {
                            JPanel_MediaSurface.this.m_MouseMovedClose = true;
                            JPanel_MediaSurface.this.m_SelfReference.setCursor(Cursor.getDefaultCursor());
                            continue;
                        }
                        if (JPanel_MediaSurface.this.m_MouseMoved) {
                            if (JPanel_MediaSurface.this.m_SelfReference.getCursor() != Cursor.getDefaultCursor()) {
                                JPanel_MediaSurface.this.m_SelfReference.setCursor(Cursor.getDefaultCursor());
                            }
                            JPanel_MediaSurface.this.m_MouseMoved = false;
                        } else if (JPanel_MediaSurface.this.m_SelfReference.getCursor() != CURSOR_BLANK) {
                            JPanel_MediaSurface.this.m_SelfReference.setCursor(CURSOR_BLANK);
                        }
                    }
                }
            }
        });
        this.setCursor(Cursor.getDefaultCursor());
        this.m_MouseMovedThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        ArrayList<LiveShow_MediaPlayer> o_LiveShow_MediaPlayers;
        Object object = this.m_SyncMediaPlayers;
        synchronized (object) {
            o_LiveShow_MediaPlayers = new ArrayList<LiveShow_MediaPlayer>(this.m_LiveShow_MediaPlayers.size());
            o_LiveShow_MediaPlayers.addAll(this.m_LiveShow_MediaPlayers);
        }
        for (int intMediaPlayer = o_LiveShow_MediaPlayers.size() - 1; intMediaPlayer >= 0; --intMediaPlayer) {
            LiveShow_MediaPlayer o_LiveShow_MediaPlayer = (LiveShow_MediaPlayer)o_LiveShow_MediaPlayers.get(intMediaPlayer);
            this.removeLiveShow_MediaPlayer(o_LiveShow_MediaPlayer);
        }
        Object object2 = this.m_MouseMovedSync;
        synchronized (object2) {
            this.m_MouseMovedClose = true;
            this.m_MouseMovedSync.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLiveShow_MediaPlayer(LiveShow_MediaPlayer p_LiveShow_MediaPlayer) {
        if (p_LiveShow_MediaPlayer == null) {
            return;
        }
        Object object = this.m_SyncMediaPlayers;
        synchronized (object) {
            if (this.m_LiveShow_MediaPlayers.contains(p_LiveShow_MediaPlayer)) {
                return;
            }
            this.addSorted(p_LiveShow_MediaPlayer);
        }
        p_LiveShow_MediaPlayer.setLiveShow_MediaSurface(this);
        this.paintImage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLiveShow_MediaPlayer(LiveShow_MediaPlayer p_LiveShow_MediaPlayer) {
        if (p_LiveShow_MediaPlayer == null) {
            return;
        }
        Object object = this.m_SyncMediaPlayers;
        synchronized (object) {
            if (!this.m_LiveShow_MediaPlayers.contains(p_LiveShow_MediaPlayer)) {
                return;
            }
            this.m_LiveShow_MediaPlayers.remove(p_LiveShow_MediaPlayer);
        }
        p_LiveShow_MediaPlayer.removeLiveShow_MediaSurface(this);
        this.paintImage();
    }

    @Override
    public void resort(LiveShow_MediaPlayer p_LiveShow_MediaPlayer) {
        this.addSorted(p_LiveShow_MediaPlayer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSorted(LiveShow_MediaPlayer p_LiveShow_MediaPlayer) {
        if (p_LiveShow_MediaPlayer == null) {
            return;
        }
        int intZorder = p_LiveShow_MediaPlayer.getZOrder();
        Object object = this.m_SyncMediaPlayers;
        synchronized (object) {
            LiveShow_MediaPlayer o_LiveShow_MediaPlayer;
            if (this.m_LiveShow_MediaPlayers.contains(p_LiveShow_MediaPlayer)) {
                this.m_LiveShow_MediaPlayers.remove(p_LiveShow_MediaPlayer);
            }
            int intPlayer = 0;
            for (intPlayer = 0; intPlayer < this.m_LiveShow_MediaPlayers.size() && intZorder <= (o_LiveShow_MediaPlayer = this.m_LiveShow_MediaPlayers.get(intPlayer)).getZOrder(); ++intPlayer) {
            }
            this.m_LiveShow_MediaPlayers.add(intPlayer, p_LiveShow_MediaPlayer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLiveShow_MediaPlayer_Count() {
        Object object = this.m_SyncMediaPlayers;
        synchronized (object) {
            return this.m_LiveShow_MediaPlayers.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LiveShow_MediaPlayer getLiveShow_MediaPlayer(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        Object object = this.m_SyncMediaPlayers;
        synchronized (object) {
            if (p_Index >= this.m_LiveShow_MediaPlayers.size()) {
                return null;
            }
            return this.m_LiveShow_MediaPlayers.get(p_Index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLiveShow_MediaPlayer_Index(LiveShow_MediaPlayer p_LiveShow_MediaPlayer) {
        if (p_LiveShow_MediaPlayer == null) {
            return -1;
        }
        Object object = this.m_SyncMediaPlayers;
        synchronized (object) {
            return this.m_LiveShow_MediaPlayers.indexOf(p_LiveShow_MediaPlayer);
        }
    }

    @Override
    public Rectangle getRenderBounds() {
        return this.m_RenderSize;
    }

    public void setRenderSize(Rectangle p_Bounds) {
        if (p_Bounds == null) {
            return;
        }
        boolean boolChangedSize = false;
        if (p_Bounds.width <= 0 || p_Bounds.height <= 0) {
            return;
        }
        if (p_Bounds.width != this.m_RenderSize.width || p_Bounds.height != this.m_RenderSize.height) {
            boolChangedSize = true;
        }
        this.m_RenderSize.setBounds(p_Bounds);
        if (boolChangedSize) {
            for (int intMediaPlayer = 0; intMediaPlayer < this.getLiveShow_MediaPlayer_Count(); ++intMediaPlayer) {
                LiveShow_MediaPlayer o_LiveShow_MediaPlayer = this.getLiveShow_MediaPlayer(intMediaPlayer);
                if (o_LiveShow_MediaPlayer == null) continue;
                o_LiveShow_MediaPlayer.setRenderSize(this.m_RenderSize.width, this.m_RenderSize.height);
            }
        }
        if (this.m_BufferedImage_Interim == null || this.m_BufferedImage_Interim.getWidth() != this.m_RenderSize.width || this.m_BufferedImage_Interim.getHeight() != this.m_RenderSize.height) {
            this.m_BufferedImage_Interim = new BufferedImage(this.m_RenderSize.width, this.m_RenderSize.height, 2);
        }
    }

    @Override
    public void prepareBufferedImage(LiveShow_MediaPlayer p_LiveShow_MediaPlayer, Graphics p_Graphics, AffineTransform p_AffineTransform, boolean p_ClearRect) {
        int intNewHeight;
        int intNewWidth;
        float floatFade;
        BufferedImage o_BufferedImage = null;
        JEditorPane o_JEditorPane = null;
        Graphics2D o_Graphics2D = (Graphics2D)p_Graphics;
        Composite o_Composite_Origin = o_Graphics2D.getComposite();
        AffineTransform o_AffineTransform_Origin = o_Graphics2D.getTransform();
        AffineTransform o_AffineTransform = p_AffineTransform;
        o_Graphics2D = (Graphics2D)p_Graphics;
        if (p_ClearRect) {
            o_Graphics2D.setBackground(COLOR_TRANSPARENT);
            o_Graphics2D.clearRect(0, 0, this.getWidth(), this.getHeight());
        }
        int intDisplayWidth = this.getWidth();
        int intDisplayHeight = this.getHeight();
        int intX = 0;
        int intY = 0;
        LiveShow_MediaPlayer o_LiveShow_MediaPlayer = p_LiveShow_MediaPlayer;
        if (o_LiveShow_MediaPlayer == null) {
            return;
        }
        if (!o_LiveShow_MediaPlayer.getMediaReady()) {
            return;
        }
        if (o_LiveShow_MediaPlayer.getFade() <= 0.0f) {
            return;
        }
        if (o_LiveShow_MediaPlayer instanceof LiveShow_MediaPlayer_Text) {
            LiveShow_MediaPlayer.MediaImage o_MediaImage = o_LiveShow_MediaPlayer.getMediaImage();
            o_JEditorPane = o_LiveShow_MediaPlayer.getJEditorPane();
            if (o_JEditorPane == null) {
                return;
            }
        } else {
            LiveShow_MediaPlayer.MediaImage o_MediaImage = o_LiveShow_MediaPlayer.getMediaImage();
            if (o_MediaImage == null) {
                return;
            }
            o_BufferedImage = o_MediaImage.getBufferedImage();
            if (o_BufferedImage == null) {
                return;
            }
        }
        if ((floatFade = o_LiveShow_MediaPlayer.getFade()) > 1.0f) {
            floatFade = 1.0f;
        }
        if (floatFade < 0.0f) {
            floatFade = 0.0f;
        }
        if (floatFade <= 0.0f) {
            return;
        }
        if ((floatFade = (float)this.m_Spline_AlphaComposite.getValue((double)floatFade)) <= 0.0f) {
            return;
        }
        Dimension o_OriginSize = o_LiveShow_MediaPlayer.getPlayerGrabSize();
        Rectangle2D o_RelativePositionSize = o_LiveShow_MediaPlayer.getRelativePositionSize();
        double doubleScaleX = 1.0;
        double doubleScaleY = 1.0;
        if (o_LiveShow_MediaPlayer.getFlagSize() == 1) {
            intDisplayWidth = (int)(o_RelativePositionSize.getWidth() * (double)intDisplayWidth + 0.5);
            intDisplayHeight = (int)(o_RelativePositionSize.getHeight() * (double)intDisplayHeight + 0.5);
            intNewWidth = intDisplayWidth;
            intNewHeight = intDisplayHeight;
        } else {
            intNewWidth = intDisplayWidth;
            intNewHeight = intDisplayHeight;
        }
        switch (o_LiveShow_MediaPlayer.getFlagAspect()) {
            case 1: {
                double doubleWidthFactor;
                if (o_OriginSize.width <= 0 || o_OriginSize.height <= 0) break;
                double doubleHeightFactor = (double)intDisplayHeight / o_OriginSize.getHeight();
                doubleScaleX = doubleWidthFactor = (double)intDisplayWidth / o_OriginSize.getWidth();
                doubleScaleY = doubleHeightFactor;
                break;
            }
            case 0: {
                double doubleWidthFactor;
                if (o_OriginSize.width <= 0 || o_OriginSize.height <= 0) break;
                double doubleHeightFactor = (double)intDisplayHeight / o_OriginSize.getHeight();
                if (doubleHeightFactor < (doubleWidthFactor = (double)intDisplayWidth / o_OriginSize.getWidth())) {
                    intNewHeight = (int)(o_OriginSize.getHeight() * doubleHeightFactor);
                    intNewWidth = (int)(o_OriginSize.getWidth() * doubleHeightFactor);
                    doubleScaleX = doubleHeightFactor;
                    doubleScaleY = doubleHeightFactor;
                    break;
                }
                intNewHeight = (int)(o_OriginSize.getHeight() * doubleWidthFactor);
                intNewWidth = (int)(o_OriginSize.getWidth() * doubleWidthFactor);
                doubleScaleX = doubleWidthFactor;
                doubleScaleY = doubleWidthFactor;
            }
        }
        double doubleXCentered = (double)(this.getWidth() - intNewWidth) / 2.0;
        double doubleYCentered = (double)(this.getHeight() - intNewHeight) / 2.0;
        double doubleXMoveLength = (double)(this.getWidth() + intNewWidth) / 2.0;
        double doubleYMoveLength = (double)(this.getHeight() + intNewHeight) / 2.0;
        if (o_LiveShow_MediaPlayer.getFlagPosition() == 1) {
            double doubleXCorrectRound = o_RelativePositionSize.getX() >= 0.0 ? 0.5 : -0.5;
            double doubleYCorrectRound = o_RelativePositionSize.getY() >= 0.0 ? 0.5 : -0.5;
            intX = (int)(doubleXCentered + o_RelativePositionSize.getX() * doubleXMoveLength + doubleXCorrectRound);
            intY = (int)(doubleYCentered + o_RelativePositionSize.getY() * doubleYMoveLength + doubleYCorrectRound);
        } else {
            switch (o_LiveShow_MediaPlayer.getAnchor()) {
                case 0: {
                    intX = (int)(doubleXCentered + 0.5);
                    intY = (int)(doubleYCentered + 0.5);
                    break;
                }
                case 1: {
                    intX = (int)(doubleXCentered + 0.5);
                    intY = 0;
                    break;
                }
                case 2: {
                    intX = (int)(doubleXCentered + 0.5);
                    intY = this.getHeight() - intNewHeight;
                    break;
                }
                case 3: {
                    intX = 0;
                    intY = (int)(doubleYCentered + 0.5);
                    break;
                }
                case 4: {
                    intX = this.getWidth() - intNewWidth;
                    intY = (int)(doubleYCentered + 0.5);
                    break;
                }
                case 5: {
                    intX = 0;
                    intY = 0;
                    break;
                }
                case 6: {
                    intX = this.getWidth() - intNewWidth;
                    intY = 0;
                    break;
                }
                case 7: {
                    intX = 0;
                    intY = this.getHeight() - intNewHeight;
                    break;
                }
                case 8: {
                    intX = this.getWidth() - intNewWidth;
                    intY = this.getHeight() - intNewHeight;
                }
            }
        }
        o_AffineTransform.setToIdentity();
        o_AffineTransform.translate(o_AffineTransform_Origin.getTranslateX(), o_AffineTransform_Origin.getTranslateY());
        boolean boolCorrectFlipRotation = false;
        if (o_LiveShow_MediaPlayer instanceof LiveShow_MediaPlayer_Text) {
            try {
                if (o_LiveShow_MediaPlayer.getFlipHorizontally() && o_LiveShow_MediaPlayer.getFlipVertically()) {
                    o_AffineTransform.scale(-1.0, -1.0);
                    o_AffineTransform.translate(-this.getWidth(), -this.getHeight());
                    intY = this.getHeight() - (intY + intNewHeight);
                    intX = this.getWidth() - (intX + intNewWidth);
                } else if (o_LiveShow_MediaPlayer.getFlipHorizontally()) {
                    o_AffineTransform.scale(1.0, -1.0);
                    o_AffineTransform.translate(0.0, -this.getHeight());
                    intY = this.getHeight() - (intY + intNewHeight);
                    boolCorrectFlipRotation = true;
                } else if (o_LiveShow_MediaPlayer.getFlipVertically()) {
                    o_AffineTransform.scale(-1.0, 1.0);
                    o_AffineTransform.translate(-this.getWidth(), 0.0);
                    intX = this.getWidth() - (intX + intNewWidth);
                    boolCorrectFlipRotation = true;
                }
                if (o_LiveShow_MediaPlayer.getRotateValue() != 0.0) {
                    if (!boolCorrectFlipRotation) {
                        o_AffineTransform.rotate(o_LiveShow_MediaPlayer.getRotateValue() * Math.PI / 180.0, intX + intNewWidth / 2, intY + intNewHeight / 2);
                    } else {
                        o_AffineTransform.rotate(-o_LiveShow_MediaPlayer.getRotateValue() * Math.PI / 180.0, intX + intNewWidth / 2, intY + intNewHeight / 2);
                    }
                }
                o_Graphics2D.setTransform(o_AffineTransform);
                if (floatFade >= 0.0f && floatFade < 1.0f) {
                    AlphaComposite o_AlphaComposite = AlphaComposite.getInstance(3, floatFade);
                    o_Graphics2D.setComposite(o_AlphaComposite);
                }
                o_Graphics2D.translate(intX, intY);
                o_Graphics2D.scale(doubleScaleX, doubleScaleY);
                o_JEditorPane.paint(o_Graphics2D);
            }
            catch (Exception e) {
                boolean bl = false;
            }
            o_Graphics2D.setComposite(o_Composite_Origin);
            o_Graphics2D.setTransform(o_AffineTransform_Origin);
            return;
        }
        try {
            if (o_LiveShow_MediaPlayer.getFlipHorizontally() && o_LiveShow_MediaPlayer.getFlipVertically()) {
                o_AffineTransform.scale(-1.0, -1.0);
                o_AffineTransform.translate(-this.getWidth(), -this.getHeight());
                intY = this.getHeight() - (intY + intNewHeight);
                intX = this.getWidth() - (intX + intNewWidth);
            } else if (o_LiveShow_MediaPlayer.getFlipHorizontally()) {
                o_AffineTransform.scale(1.0, -1.0);
                o_AffineTransform.translate(0.0, -this.getHeight());
                intY = this.getHeight() - (intY + intNewHeight);
                boolCorrectFlipRotation = true;
            } else if (o_LiveShow_MediaPlayer.getFlipVertically()) {
                o_AffineTransform.scale(-1.0, 1.0);
                o_AffineTransform.translate(-this.getWidth(), 0.0);
                intX = this.getWidth() - (intX + intNewWidth);
                boolCorrectFlipRotation = true;
            }
            if (o_LiveShow_MediaPlayer.getRotateValue() != 0.0) {
                if (!boolCorrectFlipRotation) {
                    o_AffineTransform.rotate(o_LiveShow_MediaPlayer.getRotateValue() * Math.PI / 180.0, intX + intNewWidth / 2, intY + intNewHeight / 2);
                } else {
                    o_AffineTransform.rotate(-o_LiveShow_MediaPlayer.getRotateValue() * Math.PI / 180.0, intX + intNewWidth / 2, intY + intNewHeight / 2);
                }
            }
            o_Graphics2D.setTransform(o_AffineTransform);
            if (floatFade >= 0.0f && floatFade < 1.0f) {
                AlphaComposite o_AlphaComposite = AlphaComposite.getInstance(3, floatFade);
                o_Graphics2D.setComposite(o_AlphaComposite);
            }
            boolean boolImagedIsDrawn = false;
            boolImagedIsDrawn = o_Graphics2D.drawImage(o_BufferedImage, intX, intY, intX + intNewWidth, intY + intNewHeight, 0, 0, o_BufferedImage.getWidth(), o_BufferedImage.getHeight(), null);
        }
        catch (Exception e) {
            boolean bl = false;
        }
        o_Graphics2D.setComposite(o_Composite_Origin);
        o_Graphics2D.setTransform(o_AffineTransform_Origin);
    }

    @Override
    public void paintImage() {
        PlayerPaintHandler.invokeLater(this.m_Runnable_Repaint);
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D o_Graphics2D = (Graphics2D)g;
        super.paintComponent(g);
        for (int intMediaPlayer = 0; intMediaPlayer < this.getLiveShow_MediaPlayer_Count(); ++intMediaPlayer) {
            BufferedImage o_BufferedImage_Interim;
            LiveShow_MediaPlayer o_LiveShow_MediaPlayer = this.getLiveShow_MediaPlayer(intMediaPlayer);
            if (o_LiveShow_MediaPlayer == null || o_LiveShow_MediaPlayer.getFade() <= 0.0f) continue;
            if (o_LiveShow_MediaPlayer instanceof LiveShow_MediaPlayer_Text && (o_BufferedImage_Interim = this.m_BufferedImage_Interim) != null) {
                this.prepareBufferedImage(o_LiveShow_MediaPlayer, o_BufferedImage_Interim.getGraphics(), o_LiveShow_MediaPlayer.getAffineTransform(), true);
                o_Graphics2D.drawImage(o_BufferedImage_Interim, 0, 0, o_BufferedImage_Interim.getWidth(), o_BufferedImage_Interim.getHeight(), null);
                continue;
            }
            this.prepareBufferedImage(o_LiveShow_MediaPlayer, o_Graphics2D, o_LiveShow_MediaPlayer.getAffineTransform(), false);
        }
    }
}

