/*
 * Decompiled with CFR 0.152.
 */
package MediaPlayerPackage;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.bytedeco.javacv.Frame;

public class FFmpeg_VideoFrameConverter {
    public static ColorSpace s_ColorSpace_Gray = ColorSpace.getInstance(1003);
    public static ColorSpace s_ColorSpace_LINEAR_RGB = ColorSpace.getInstance(1004);
    public static int[] s_Offsets_1 = new int[]{0};
    public static int[] s_Offsets_3 = new int[]{2, 1, 0};
    public static int[] s_Offsets_4 = new int[]{0, 1, 2, 3};

    public static void copy(Frame frame, BufferedImage bufferedImage) {
        Buffer in = frame.image[0];
        WritableRaster r = bufferedImage.getRaster();
        DataBuffer out = r.getDataBuffer();
        in.rewind();
        if (out instanceof DataBufferByte) {
            byte[] a = ((DataBufferByte)out).getData();
            ByteBuffer o_ByteBuffer_Dest = ByteBuffer.wrap(a);
            if (o_ByteBuffer_Dest.capacity() != in.capacity()) {
                return;
            }
            o_ByteBuffer_Dest.rewind();
            o_ByteBuffer_Dest.put((ByteBuffer)in);
        } else if (out instanceof DataBufferDouble) {
            double[] a = ((DataBufferDouble)out).getData();
            DoubleBuffer o_DoubleBuffer_Dest = DoubleBuffer.wrap(a);
            if (o_DoubleBuffer_Dest.capacity() != in.capacity()) {
                return;
            }
            o_DoubleBuffer_Dest.rewind();
            o_DoubleBuffer_Dest.put((DoubleBuffer)in);
        } else if (out instanceof DataBufferFloat) {
            float[] a = ((DataBufferFloat)out).getData();
            FloatBuffer o_FloatBuffer_Dest = FloatBuffer.wrap(a);
            if (o_FloatBuffer_Dest.capacity() != in.capacity()) {
                return;
            }
            o_FloatBuffer_Dest.rewind();
            o_FloatBuffer_Dest.put((FloatBuffer)in);
        } else if (out instanceof DataBufferInt) {
            int[] a = ((DataBufferInt)out).getData();
            IntBuffer o_IntBuffer_Dest = IntBuffer.wrap(a);
            if (o_IntBuffer_Dest.capacity() != in.capacity()) {
                return;
            }
            if (in instanceof ByteBuffer) {
                in = ((ByteBuffer)in).order(ByteOrder.BIG_ENDIAN).asIntBuffer();
            }
            o_IntBuffer_Dest.rewind();
            o_IntBuffer_Dest.put((IntBuffer)in);
        } else if (out instanceof DataBufferShort) {
            short[] a = ((DataBufferShort)out).getData();
            ShortBuffer o_ShortBuffer_Dest = ShortBuffer.wrap(a);
            if (o_ShortBuffer_Dest.capacity() != in.capacity()) {
                return;
            }
            o_ShortBuffer_Dest.rewind();
            o_ShortBuffer_Dest.put((ShortBuffer)in);
        } else if (out instanceof DataBufferUShort) {
            short[] a = ((DataBufferShort)out).getData();
            ShortBuffer o_ShortBuffer_Dest = ShortBuffer.wrap(a);
            if (o_ShortBuffer_Dest.capacity() != in.capacity()) {
                return;
            }
            o_ShortBuffer_Dest.rewind();
            o_ShortBuffer_Dest.put((ShortBuffer)in);
        } else assert (false);
    }

    public static int getBufferedImageType(Frame frame) {
        int type = 0;
        if (frame.imageChannels == 1) {
            if (frame.imageDepth == 8 || frame.imageDepth == -8) {
                type = 10;
            } else if (frame.imageDepth == 16) {
                type = 11;
            }
        } else if (frame.imageChannels == 3) {
            if (frame.imageDepth == 8 || frame.imageDepth == -8) {
                type = 5;
            }
        } else if (frame.imageChannels == 4 && (frame.imageDepth == 8 || frame.imageDepth == -8)) {
            type = 6;
        }
        return type;
    }

    public static BufferedImage getBufferedImage(Frame p_Frame, BufferedImage p_BufferedImage) {
        if (p_Frame == null || p_Frame.image == null) {
            return null;
        }
        ColorSpace cs = null;
        int intBufferedImageType = FFmpeg_VideoFrameConverter.getBufferedImageType(p_Frame);
        if (p_BufferedImage == null || p_BufferedImage.getWidth() != p_Frame.imageWidth || p_BufferedImage.getHeight() != p_Frame.imageHeight || p_BufferedImage.getType() != intBufferedImageType) {
            BufferedImage bufferedImage = p_BufferedImage = intBufferedImageType == 0 || cs != null ? null : new BufferedImage(p_Frame.imageWidth, p_Frame.imageHeight, intBufferedImageType);
        }
        if (p_BufferedImage == null) {
            boolean alpha = false;
            int[] offsets = null;
            if (p_Frame.imageChannels == 1) {
                alpha = false;
                cs = s_ColorSpace_Gray;
                offsets = s_Offsets_1;
            } else if (p_Frame.imageChannels == 3) {
                alpha = false;
                cs = s_ColorSpace_LINEAR_RGB;
                offsets = s_Offsets_3;
            } else if (p_Frame.imageChannels == 4) {
                alpha = true;
                cs = s_ColorSpace_LINEAR_RGB;
                offsets = s_Offsets_4;
            } else assert (false);
            ComponentColorModel cm = null;
            WritableRaster wr = null;
            if (p_Frame.imageDepth == 8 || p_Frame.imageDepth == -8) {
                cm = new ComponentColorModel(cs, alpha, false, 1, 0);
                wr = Raster.createWritableRaster(new ComponentSampleModel(0, p_Frame.imageWidth, p_Frame.imageHeight, p_Frame.imageChannels, p_Frame.imageStride, offsets), null);
            } else if (p_Frame.imageDepth == 16) {
                cm = new ComponentColorModel(cs, alpha, false, 1, 1);
                wr = Raster.createWritableRaster(new ComponentSampleModel(1, p_Frame.imageWidth, p_Frame.imageHeight, p_Frame.imageChannels, p_Frame.imageStride, offsets), null);
            } else if (p_Frame.imageDepth == -16) {
                cm = new ComponentColorModel(cs, alpha, false, 1, 2);
                wr = Raster.createWritableRaster(new ComponentSampleModel(2, p_Frame.imageWidth, p_Frame.imageHeight, p_Frame.imageChannels, p_Frame.imageStride, offsets), null);
            } else if (p_Frame.imageDepth == -32) {
                cm = new ComponentColorModel(cs, alpha, false, 1, 3);
                wr = Raster.createWritableRaster(new ComponentSampleModel(3, p_Frame.imageWidth, p_Frame.imageHeight, p_Frame.imageChannels, p_Frame.imageStride, offsets), null);
            } else if (p_Frame.imageDepth == 32) {
                cm = new ComponentColorModel(cs, alpha, false, 1, 4);
                wr = Raster.createWritableRaster(new ComponentSampleModel(4, p_Frame.imageWidth, p_Frame.imageHeight, p_Frame.imageChannels, p_Frame.imageStride, offsets), null);
            } else if (p_Frame.imageDepth == 64) {
                cm = new ComponentColorModel(cs, alpha, false, 1, 5);
                wr = Raster.createWritableRaster(new ComponentSampleModel(5, p_Frame.imageWidth, p_Frame.imageHeight, p_Frame.imageChannels, p_Frame.imageStride, offsets), null);
            } else assert (false);
            p_BufferedImage = new BufferedImage(cm, wr, false, null);
        }
        if (p_BufferedImage != null) {
            FFmpeg_VideoFrameConverter.copy(p_Frame, p_BufferedImage);
        }
        return p_BufferedImage;
    }
}

