/*
 * Decompiled with CFR 0.152.
 */
package MediaObjectPackage;

import FileToolPackage.FileSelection;
import FileToolPackage.FileTools;
import Icons.IconManager;
import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LanguageTools.LiveLanguagePackage.LiveLanguageString;
import LiveShowObjectPackage.LiveShowObject;
import MediaObjectPackage.MediaSourceListener;
import SwingModelPackage.TableAndListModel;
import SynchronizationPackage.LiveCloseSemaphore;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;

public class MediaSource {
    public static boolean s_VideoAnalyzer_ON = true;
    @LiveLanguageString
    public static String MEDIATYPENAME_UNKNOWN = "";
    @LiveLanguageString
    public static String MEDIATYPENAME_VIDEO = "Video";
    @LiveLanguageString
    public static String MEDIATYPENAME_IMAGE = "Image";
    @LiveLanguageString
    public static String MEDIATYPENAME_TEXT = "Text";
    public static ImageIcon s_Icon = IconManager.getImageIcon((String)"Media.png");
    public static ImageIcon s_Icon_Image = IconManager.getImageIcon((String)"Media_Images.png");
    public static ImageIcon s_Icon_Video = IconManager.getImageIcon((String)"Media_Video.png");
    public static ImageIcon s_Icon_Text = IconManager.getImageIcon((String)"Media_Text.png");
    public static FileNameExtensionFilter MEDIAFILE_FILTER_VIDEO = FileSelection.createFileNameExtensionFilter((String)"Video", (String[])new String[]{"avi", "mp4", "mpg", "mp2", "wmv", "mov", "ogg", "amv", "asf", "divx", "flv", "dv", "iso", "mpeg1", "mpeg2", "mpeg4", "mkv", "vob", "webm"});
    public static FileNameExtensionFilter MEDIAFILE_FILTER_IMAGE = FileSelection.createFileNameExtensionFilter((String)"Image", (String[])new String[]{"jpg", "png", "gif"});
    public static FileNameExtensionFilter MEDIAFILE_FILTER_TEXT = FileSelection.createFileNameExtensionFilter((String)"Text", (String[])new String[]{"html", "rtf"});
    public static FileNameExtensionFilter MEDIAFILE_FILTER_ALLMEDIA = FileSelection.createFileNameExtensionFilter((String)"Media (Image/Video/Text)", (String[])new String[]{"jpg", "png", "gif", "html", "rtf", "avi", "mp4", "mpg", "mp2", "wmv", "mov", "ogg", "amv", "asf", "divx", "flv", "dv", "iso", "mpeg1", "mpeg2", "mpeg4", "mkv", "vob", "webm", "webm"});
    public static FileNameExtensionFilter MEDIAFILE_FILTER_VIDEOAUDIO = FileSelection.createFileNameExtensionFilter((String)"Video", (String[])new String[]{"avi", "mp4", "mpg", "mp2", "wmv", "mov", "ogg", "amv", "asf", "divx", "flv", "dv", "iso", "mpeg1", "mpeg2", "mpeg4", "mkv", "vob", "webm", "wav", "mp3", "wma", "aac", "aif", "aiff"});
    public static final String SPLITSTRING = ";";
    public static final int STATUS_UNKNOWN = 0;
    public static final int STATUS_OK = 1;
    public static final int STATUS_FAILURE = 9;
    public static ArrayList<MediaSource> s_MediaSources = new ArrayList();
    public static MediaSourcetListModel s_MediaSourcetListModel_ImageText = new MediaSourcetListModel();
    public static MediaSourceListRenderer s_MediaSourceListRenderer = new MediaSourceListRenderer();
    public static final Object s_SyncMediaSources = new Object();
    public static Thread s_Thread_Sweep;
    public static Runnable s_Runnable_Sweep;
    private int m_MediaType;
    private File m_File;
    private long m_FileLastModified;
    private String m_CheckSum;
    private LiveShowObject m_LiveShowObject;
    private ArrayList<Object> m_References;
    private LiveCloseSemaphore m_LiveCloseSemaphore;
    private ArrayList<MediaSourceListener> m_MediaSourceListeners;
    private final Object m_SyncMediaSourceListeners = new Object();
    private boolean m_VideoAnalyzed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addMediaSource(MediaSource p_MediaSource) {
        if (p_MediaSource == null) {
            return false;
        }
        Object object = s_SyncMediaSources;
        synchronized (object) {
            if (s_MediaSources.contains(p_MediaSource)) {
                return true;
            }
            if (s_MediaSources.add(p_MediaSource)) {
                if (p_MediaSource.getMediaType() == 1001 || p_MediaSource.getMediaType() == 1003) {
                    s_MediaSourcetListModel_ImageText.add(p_MediaSource);
                }
                if (p_MediaSource.getMediaType() == 1002) {
                    // empty if block
                }
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeMediaSource(MediaSource p_MediaSource) {
        if (p_MediaSource == null) {
            return false;
        }
        Object object = s_SyncMediaSources;
        synchronized (object) {
            if (s_MediaSources.remove(p_MediaSource)) {
                s_MediaSourcetListModel_ImageText.removeMediaSource(p_MediaSource);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MediaSource getMediaSource(File p_MediaFile) {
        if (p_MediaFile == null) {
            return null;
        }
        int intMediaType = MediaSource.autoDetectMediaType(p_MediaFile);
        Object object = s_SyncMediaSources;
        synchronized (object) {
            for (int intMediaSource = 0; intMediaSource < s_MediaSources.size(); ++intMediaSource) {
                MediaSource o_MediaSource = s_MediaSources.get(intMediaSource);
                if (o_MediaSource.getMediaType() != intMediaType || !o_MediaSource.getFilePath().equals(p_MediaFile.getAbsolutePath())) continue;
                return o_MediaSource;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeAll() {
        Object object = s_SyncMediaSources;
        synchronized (object) {
            for (int intMediaSource = s_MediaSources.size() - 1; intMediaSource >= 0; --intMediaSource) {
                MediaSource o_MediaSource = s_MediaSources.get(intMediaSource);
                o_MediaSource.close();
            }
        }
    }

    public static void sweepAll() {
        if (s_Runnable_Sweep == null) {
            s_Runnable_Sweep = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = s_SyncMediaSources;
                    synchronized (object) {
                        for (int intMediaSource = s_MediaSources.size() - 1; intMediaSource >= 0; --intMediaSource) {
                            MediaSource o_MediaSource = s_MediaSources.get(intMediaSource);
                            o_MediaSource.sweep();
                        }
                    }
                }
            };
        }
        if (s_Thread_Sweep == null || !s_Thread_Sweep.isAlive()) {
            s_Thread_Sweep = new Thread(s_Runnable_Sweep, MediaSource.class.getSimpleName() + "_SweepAll");
            s_Thread_Sweep.start();
        }
    }

    public static int autoDetectMediaType(File p_File) {
        if (p_File == null) {
            return -1;
        }
        if (MEDIAFILE_FILTER_IMAGE.accept(p_File)) {
            return 1001;
        }
        if (MEDIAFILE_FILTER_VIDEO.accept(p_File)) {
            return 1002;
        }
        if (MEDIAFILE_FILTER_TEXT.accept(p_File)) {
            return 1003;
        }
        return -1;
    }

    public static int autoDetectMediaType(String p_FileName) {
        if (p_FileName == null) {
            return -1;
        }
        return MediaSource.autoDetectMediaType(new File(p_FileName));
    }

    public MediaSource(File p_File) {
        this.initMembers();
        this.m_File = p_File;
        if (this.m_File != null) {
            this.m_FileLastModified = this.m_File.lastModified();
        }
        LiveLanguage.addLanguageListener((Object)this, null);
        this.m_MediaType = MediaSource.autoDetectMediaType(this.m_File);
        this.createCheckSum();
        MediaSource.addMediaSource(this);
    }

    private void initMembers() {
        this.m_LiveCloseSemaphore = new LiveCloseSemaphore(this.getClass().getSimpleName());
        this.m_MediaType = -1;
        this.m_File = null;
        this.m_CheckSum = "";
        this.m_References = new ArrayList();
        this.m_MediaSourceListeners = new ArrayList();
        this.m_VideoAnalyzed = false;
    }

    public void close() {
        if (!this.m_LiveCloseSemaphore.enterCloseSection()) {
            return;
        }
        MediaSource.removeMediaSource(this);
        this.notifyListener_Closing();
        this.m_LiveCloseSemaphore.leaveCloseSection();
    }

    public void refresh() {
        this.m_MediaType = MediaSource.autoDetectMediaType(this.m_File);
        this.createCheckSum();
        MediaSource.addMediaSource(this);
        this.notifyListener_Refreshing();
    }

    public long getDiskSpaceEstimated(File p_ExportDirectory) {
        long longBytesCount = 0L;
        try {
            File o_File;
            if (this.m_File != null) {
                longBytesCount += this.m_File.length();
            }
            if (p_ExportDirectory != null && this.m_File != null && (o_File = new File(p_ExportDirectory.getAbsolutePath() + "/" + this.m_File.getName())).exists()) {
                longBytesCount -= o_File.length();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return longBytesCount;
    }

    public String getToolTipText() {
        if (this.m_File == null) {
            return null;
        }
        return this.m_File.getAbsolutePath();
    }

    public boolean equals(Object p_Object) {
        if (p_Object == null) {
            return false;
        }
        if (!(p_Object instanceof MediaSource)) {
            return false;
        }
        MediaSource o_MediaSource = (MediaSource)p_Object;
        if (this.getMediaType() != o_MediaSource.getMediaType()) {
            return false;
        }
        File o_File = this.getFile();
        return !(o_File == null ? o_MediaSource.getFile() != null : !this.getFile().equals(o_MediaSource.getFile()));
    }

    public void setLiveShowObject(LiveShowObject p_LiveShowObject) {
        this.m_LiveShowObject = p_LiveShowObject;
    }

    public LiveShowObject getLiveShowObject() {
        return this.m_LiveShowObject;
    }

    public void addReference(Object p_Object) {
        if (p_Object == null) {
            return;
        }
        if (this.m_References.contains(p_Object)) {
            return;
        }
        this.m_References.add(p_Object);
    }

    public void removeReference(Object p_Object, boolean p_Finish) {
        if (p_Object == null) {
            return;
        }
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return;
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        if (!this.m_References.contains(p_Object)) {
            return;
        }
        this.m_References.remove(p_Object);
        if (!p_Finish) {
            return;
        }
        if (this.m_References.size() > 1) {
            return;
        }
        if (this.m_References.size() == 1 && this.m_LiveShowObject != null) {
            if (this.m_References.get(0) != this.m_LiveShowObject) {
                return;
            }
            this.m_LiveShowObject.close(true);
            return;
        }
        this.m_LiveShowObject = null;
        this.close();
    }

    public int getReferenceCount() {
        return this.m_References.size();
    }

    public Object getReferenceObject(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return null;
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        if (p_Index >= this.m_References.size()) {
            return null;
        }
        try {
            return this.m_References.get(p_Index);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean sweep() {
        boolean boolDeleted = false;
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return false;
        }
        if (this.m_References.size() <= 0 && this.m_File != null) {
            try {
                boolDeleted = this.m_File.delete();
            }
            catch (Exception e) {
                boolDeleted = false;
            }
        }
        if (boolDeleted) {
            this.close();
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return boolDeleted;
    }

    public boolean getValid() {
        return this.m_CheckSum.length() > 0;
    }

    protected String createCheckSum() {
        this.m_CheckSum = this.m_File == null ? "" : FileTools.getCheckSum_MD5_Partial((File)this.m_File);
        return this.m_CheckSum;
    }

    public String getCheckSum() {
        if (this.m_CheckSum.length() <= 0) {
            this.m_CheckSum = this.createCheckSum();
        }
        return this.m_CheckSum;
    }

    public int getMediaType() {
        return this.m_MediaType;
    }

    public String getMediaTypeName() {
        switch (this.m_MediaType) {
            case 1002: {
                return MEDIATYPENAME_VIDEO;
            }
            case 1001: {
                return MEDIATYPENAME_IMAGE;
            }
            case 1003: {
                return MEDIATYPENAME_TEXT;
            }
        }
        return MEDIATYPENAME_UNKNOWN;
    }

    public File getFile() {
        return this.m_File;
    }

    public File getDirectory() {
        if (this.m_File == null) {
            return null;
        }
        return this.m_File.getParentFile();
    }

    public String getFilePath() {
        if (this.m_File == null) {
            return "";
        }
        try {
            return this.m_File.getAbsolutePath();
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getFileName() {
        if (this.m_File == null) {
            return "";
        }
        return this.m_File.getName();
    }

    public File getMediaFileDirectory() {
        File o_MediaFile = this.getFile();
        if (o_MediaFile == null) {
            return null;
        }
        return o_MediaFile.getParentFile();
    }

    public boolean checkFileLastModified() {
        if (this.m_File == null) {
            return false;
        }
        long longFileLastModified = this.m_File.lastModified();
        if (this.m_FileLastModified != longFileLastModified) {
            this.m_FileLastModified = longFileLastModified;
            return true;
        }
        return false;
    }

    public long getFileLastModified() {
        return this.m_FileLastModified;
    }

    public boolean getVideoAnalyzed() {
        return this.m_VideoAnalyzed;
    }

    public void setVideoAnalyzed(boolean p_VideoAnalyzed) {
        this.m_VideoAnalyzed = p_VideoAnalyzed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addMediaSourceListener(MediaSourceListener p_MediaSourceListener) {
        if (p_MediaSourceListener == null) {
            return false;
        }
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return false;
        }
        boolean boolAdded = false;
        Object object = this.m_SyncMediaSourceListeners;
        synchronized (object) {
            if (this.m_MediaSourceListeners != null) {
                if (!this.m_MediaSourceListeners.contains(p_MediaSourceListener)) {
                    this.m_MediaSourceListeners.add(p_MediaSourceListener);
                    boolAdded = true;
                } else {
                    boolAdded = true;
                }
            }
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return boolAdded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeMediaSourceListener(MediaSourceListener p_MediaSourceListener) {
        if (p_MediaSourceListener == null) {
            return false;
        }
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return false;
        }
        boolean boolRemoved = false;
        Object object = this.m_SyncMediaSourceListeners;
        synchronized (object) {
            if (this.m_MediaSourceListeners != null) {
                boolRemoved = this.m_MediaSourceListeners.remove(p_MediaSourceListener);
            }
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return boolRemoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyListener_Opened() {
        ArrayList<MediaSourceListener> o_MediaSourceListeners;
        Object object = this.m_SyncMediaSourceListeners;
        synchronized (object) {
            if (this.m_MediaSourceListeners == null) {
                return;
            }
            if (this.m_MediaSourceListeners.size() <= 0) {
                return;
            }
            o_MediaSourceListeners = new ArrayList<MediaSourceListener>(this.m_MediaSourceListeners.size());
            o_MediaSourceListeners.addAll(this.m_MediaSourceListeners);
        }
        for (int intListener = 0; intListener < o_MediaSourceListeners.size(); ++intListener) {
            MediaSourceListener o_MediaSourceListener = (MediaSourceListener)o_MediaSourceListeners.get(intListener);
            o_MediaSourceListener.eventMediaSourceOpened(this, this.getFile(), -1L, -1L);
        }
        o_MediaSourceListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyListener_Closing() {
        ArrayList<MediaSourceListener> o_MediaSourceListeners;
        Object object = this.m_SyncMediaSourceListeners;
        synchronized (object) {
            if (this.m_MediaSourceListeners == null) {
                return;
            }
            if (this.m_MediaSourceListeners.size() <= 0) {
                return;
            }
            o_MediaSourceListeners = new ArrayList<MediaSourceListener>(this.m_MediaSourceListeners.size());
            o_MediaSourceListeners.addAll(this.m_MediaSourceListeners);
            this.m_MediaSourceListeners.clear();
        }
        int intListenerCount = o_MediaSourceListeners.size();
        for (int intListener = intListenerCount - 1; intListener >= 0; --intListener) {
            MediaSourceListener o_MediaSourceListener = (MediaSourceListener)o_MediaSourceListeners.get(intListener);
            o_MediaSourceListener.eventMediaSourceClosing(this);
        }
        o_MediaSourceListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyListener_InvalidMediaFile(File p_MediaFile) {
        ArrayList<MediaSourceListener> o_MediaSourceListeners;
        Object object = this.m_SyncMediaSourceListeners;
        synchronized (object) {
            if (this.m_MediaSourceListeners == null) {
                return;
            }
            if (this.m_MediaSourceListeners.size() <= 0) {
                return;
            }
            o_MediaSourceListeners = new ArrayList<MediaSourceListener>(this.m_MediaSourceListeners.size());
            o_MediaSourceListeners.addAll(this.m_MediaSourceListeners);
        }
        for (int intListener = 0; intListener < o_MediaSourceListeners.size(); ++intListener) {
            MediaSourceListener o_MediaSourceListener = (MediaSourceListener)o_MediaSourceListeners.get(intListener);
            o_MediaSourceListener.eventMediaSourceInvalidFile(this, p_MediaFile);
        }
        o_MediaSourceListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyListener_Refreshing() {
        ArrayList<MediaSourceListener> o_MediaSourceListeners;
        Object object = this.m_SyncMediaSourceListeners;
        synchronized (object) {
            if (this.m_MediaSourceListeners == null) {
                return;
            }
            if (this.m_MediaSourceListeners.size() <= 0) {
                return;
            }
            o_MediaSourceListeners = new ArrayList<MediaSourceListener>(this.m_MediaSourceListeners.size());
            o_MediaSourceListeners.addAll(this.m_MediaSourceListeners);
        }
        for (int intListener = 0; intListener < o_MediaSourceListeners.size(); ++intListener) {
            MediaSourceListener o_MediaSourceListener = (MediaSourceListener)o_MediaSourceListeners.get(intListener);
            o_MediaSourceListener.eventMediaSourceRefreshing(this);
        }
        o_MediaSourceListeners.clear();
    }

    public static MediaSourcetListModel getComboBoxModel() {
        return s_MediaSourcetListModel_ImageText;
    }

    public static MediaSourceListRenderer getMediaSourceListRenderer() {
        return s_MediaSourceListRenderer;
    }

    public static class MediaSourceListRenderer
    extends DefaultListCellRenderer {
        public static StringBuffer s_StringBuffer = new StringBuffer();

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel o_JLabel = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            Color o_Background = null;
            Color o_Foreground = null;
            o_Background = list.getBackground();
            o_Foreground = list.getForeground();
            if (isSelected) {
                if (list.hasFocus()) {
                    o_Background = UIManager.getColor("List.selectionBackground");
                    o_Foreground = UIManager.getColor("List.selectionForeground");
                } else {
                    o_Background = UIManager.getColor("List.selectionInactiveBackground");
                    o_Foreground = UIManager.getColor("List.selectionInactiveForeground");
                }
            }
            o_JLabel.setForeground(o_Foreground);
            o_JLabel.setBackground(o_Background);
            this.setForeground(o_Foreground);
            this.setBackground(o_Background);
            if (value == null || !(value instanceof MediaSource)) {
                o_JLabel.setText("");
                o_JLabel.setIcon(null);
            } else {
                MediaSource o_MediaSource = (MediaSource)value;
                s_StringBuffer.delete(0, s_StringBuffer.length());
                s_StringBuffer.append(o_MediaSource.getFileName());
                o_JLabel.setText(s_StringBuffer.toString());
                if (o_MediaSource.getMediaType() == 1001) {
                    o_JLabel.setIcon(s_Icon_Image);
                } else if (o_MediaSource.getMediaType() == 1002) {
                    o_JLabel.setIcon(s_Icon_Video);
                } else if (o_MediaSource.getMediaType() == 1003) {
                    o_JLabel.setIcon(s_Icon_Text);
                } else {
                    o_JLabel.setIcon(s_Icon);
                }
            }
            return o_JLabel;
        }
    }

    public static class MediaSourcetListModel
    extends TableAndListModel.ListModel<MediaSource>
    implements MediaSourceListener {
        private final Object m_SyncObject = new Object();

        public MediaSourcetListModel() {
            super(false);
            this.setGetSortStringMethod(MediaSource.class, "getFileName", true);
        }

        public void addDMXMediaSource(MediaSource p_MediaSource) {
            if (p_MediaSource == null) {
                return;
            }
            this.add(p_MediaSource);
        }

        public void removeMediaSource(MediaSource p_MediaSource) {
            if (p_MediaSource == null) {
                return;
            }
            this.remove(p_MediaSource);
        }

        @Override
        public void eventMediaSourceInvalidFile(MediaSource p_MediaSource, File p_MediaFile) {
        }

        @Override
        public void eventMediaSourceOpened(MediaSource p_MediaSource, File p_MediaFile, long p_SectionStart, long p_SectionEnd) {
        }

        @Override
        public void eventMediaSourceClosing(MediaSource p_MediaSource) {
            this.removeMediaSource(p_MediaSource);
        }

        @Override
        public void eventMediaSourceRefreshing(MediaSource p_MediaSource) {
        }
    }

    public static class MediaSourceTableCellRenderer
    extends TableAndListModel.TableCellEditorRenderer_String {
        private static final Border DEFAULT_NO_FOCUS_BORDER = new EmptyBorder(2, 2, 2, 2);
        protected Border m_NoFocusBorder = DEFAULT_NO_FOCUS_BORDER;
        private Color m_UnselectedForeground;
        private Color m_UnselectedBackground;

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            MediaSource o_MediaSource;
            Component o_Component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            try {
                int intRowModel = table.convertRowIndexToModel(row);
                MediaSourceTableModel o_MediaSourceTableModel = (MediaSourceTableModel)((Object)table.getModel());
                o_MediaSource = (MediaSource)o_MediaSourceTableModel.getElementAt(table.convertRowIndexToModel(intRowModel));
            }
            catch (Exception e) {
                o_MediaSource = null;
            }
            if (o_Component instanceof JLabel) {
                JLabel o_JLabel = (JLabel)o_Component;
                if (o_MediaSource != null) {
                    if (o_MediaSource.getMediaType() == 1001) {
                        o_JLabel.setIcon(s_Icon_Image);
                    } else if (o_MediaSource.getMediaType() == 1002) {
                        o_JLabel.setIcon(s_Icon_Video);
                    } else if (o_MediaSource.getMediaType() == 1003) {
                        o_JLabel.setIcon(s_Icon_Text);
                    } else {
                        o_JLabel.setIcon(s_Icon);
                    }
                } else {
                    o_JLabel.setIcon(null);
                }
            }
            return o_Component;
        }
    }

    public static class MediaSourceTableModel
    extends TableAndListModel<MediaSource> {
        public static final int COLUMNCOUNT = 2;
        public static final int COLUMNINDEX_FILENAME = 0;
        public static final int COLUMNINDEX_FILEPATH = 1;
        @LiveLanguageString
        public static String COLUMN_FILENAME = "Name";
        @LiveLanguageString
        public static String COLUMN_FILEPATH = "Path";
        private TableRowSorter m_TableRowSorter;
        private final Object m_SyncObject = new Object();

        public MediaSourceTableModel() {
            super(false);
            this.initMembers();
            LiveLanguage.addLanguageListener((Object)((Object)this), null);
        }

        private void initMembers() {
            this.m_TableRowSorter = new TableRowSorter<MediaSourceTableModel>(this);
        }

        public void finishJTable(JTable p_JTable) {
            MediaSourceTableCellRenderer o_TableCellEditorRenderer_String;
            if (p_JTable == null) {
                return;
            }
            this.m_TableRowSorter.setComparator(0, (Comparator<?>)TableAndListModel.getStringComparator_Normal());
            this.m_TableRowSorter.setComparator(1, (Comparator<?>)TableAndListModel.getStringComparator_Normal());
            super.finishJTable(p_JTable, this.m_TableRowSorter, null);
            TableColumnModel o_TableColumnModel = p_JTable.getColumnModel();
            TableColumn o_TableColumn = o_TableColumnModel.getColumn(0);
            if (o_TableColumn != null) {
                o_TableColumn.setMinWidth(120);
                o_TableColumn.setPreferredWidth(150);
                o_TableCellEditorRenderer_String = new MediaSourceTableCellRenderer();
                o_TableCellEditorRenderer_String.setHorizontalAlignment(10);
                o_TableCellEditorRenderer_String.setToolTipText_Automatic(1);
                o_TableCellEditorRenderer_String.setToolTipTextAt(false, true);
                o_TableColumn.setCellEditor((TableCellEditor)((Object)o_TableCellEditorRenderer_String));
                o_TableColumn.setCellRenderer((TableCellRenderer)((Object)o_TableCellEditorRenderer_String));
            }
            if ((o_TableColumn = o_TableColumnModel.getColumn(1)) != null) {
                o_TableColumn.setMinWidth(120);
                o_TableColumn.setPreferredWidth(150);
                o_TableCellEditorRenderer_String = new TableAndListModel.TableCellEditorRenderer_String();
                o_TableCellEditorRenderer_String.setHorizontalAlignment(10);
                o_TableCellEditorRenderer_String.setToolTipText_Automatic(1);
                o_TableCellEditorRenderer_String.setToolTipTextAt(false, true);
                o_TableColumn.setCellEditor((TableCellEditor)((Object)o_TableCellEditorRenderer_String));
                o_TableColumn.setCellRenderer((TableCellRenderer)((Object)o_TableCellEditorRenderer_String));
            }
        }

        public void addSelectedMediaSource(JTable p_JTable, MediaSource p_MediaSource) {
            if (p_JTable == null) {
                return;
            }
            if (p_MediaSource == null) {
                return;
            }
            super.addSelectedElement(p_JTable, (Object)p_MediaSource);
        }

        public void removeSelectedMediaSource(JTable p_JTable, MediaSource p_MediaSource) {
            if (p_JTable == null) {
                return;
            }
            if (p_MediaSource == null) {
                return;
            }
            super.removeSelectedElement(p_JTable, (Object)p_MediaSource);
        }

        public MediaSource getMediaSource(int p_Index) {
            return (MediaSource)this.get(p_Index);
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return COLUMN_FILENAME;
                }
                case 1: {
                    return COLUMN_FILEPATH;
                }
            }
            return "";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getValue(MediaSource p_MediaSource, int columnIndex) {
            String stringValue = "";
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (p_MediaSource == null) {
                    return stringValue;
                }
            }
            switch (columnIndex) {
                case 0: {
                    stringValue = p_MediaSource.getFile().getName();
                    break;
                }
                case 1: {
                    stringValue = p_MediaSource.getMediaFileDirectory().getPath();
                }
            }
            return stringValue;
        }

        public boolean isCellEditable(int row, int col) {
            switch (col) {
                case 0: {
                    return false;
                }
                case 1: {
                    return false;
                }
            }
            return false;
        }

        public void setValue(MediaSource p_MediaSource, Object p_Value, int p_Column) {
        }
    }
}

