/*
 * Decompiled with CFR 0.152.
 */
package MediaObjectPackage;

import LiveShowObjectPackage.LiveShowObjectDescription;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class MediaObject_PlayStatus
implements Externalizable {
    public static final int SOFTWAREVERSION = 1;
    public static ArrayList<MediaObject_PlayStatus> s_MediaObject_PlayStatuse_Pool = new ArrayList(100);
    public static int s_PoolSize = 500;
    public static final Object s_SyncPool = new Object();
    private String m_Name;
    private HashMap<String, ObjectPlayStatus> m_ObjectPlayStatusList;
    private ArrayList<ObjectPlayStatus> m_Copy_ObjectPlayStatuses;
    private PlayStatus_PositionFade m_PlayStatus_PositionFade_Pre;
    private PlayStatus_PositionFade m_PlayStatus_PositionFade;
    private boolean m_ReadPreObject;
    private final Object m_SyncPlayStatusList = new Object();
    private boolean m_Closed;
    private final Object m_SyncObject = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MediaObject_PlayStatus poolGet() {
        MediaObject_PlayStatus o_MediaObject_PlayStatus;
        Object object = s_SyncPool;
        synchronized (object) {
            if (s_MediaObject_PlayStatuse_Pool.size() > 0) {
                int intIndex = s_MediaObject_PlayStatuse_Pool.size() - 1;
                o_MediaObject_PlayStatus = s_MediaObject_PlayStatuse_Pool.get(intIndex);
                o_MediaObject_PlayStatus.reactivate();
                s_MediaObject_PlayStatuse_Pool.remove(intIndex);
            } else {
                o_MediaObject_PlayStatus = new MediaObject_PlayStatus();
            }
        }
        return o_MediaObject_PlayStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean poolAddEmpty(MediaObject_PlayStatus p_MediaObject_PlayStatus) {
        Object object = s_SyncPool;
        synchronized (object) {
            if (s_MediaObject_PlayStatuse_Pool.size() < s_PoolSize) {
                s_MediaObject_PlayStatuse_Pool.add(p_MediaObject_PlayStatus);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void poolClear() {
        Object object = s_SyncPool;
        synchronized (object) {
            s_MediaObject_PlayStatuse_Pool.clear();
        }
    }

    public MediaObject_PlayStatus() {
        this.initMembers();
    }

    private void initMembers() {
        this.m_PlayStatus_PositionFade = new PlayStatus_PositionFade(false);
        this.m_PlayStatus_PositionFade_Pre = new PlayStatus_PositionFade(true);
        this.m_ObjectPlayStatusList = new HashMap();
        this.reactivate();
        this.m_ReadPreObject = false;
    }

    public void reactivate() {
        this.m_Name = "";
        this.reset();
        this.m_Closed = false;
    }

    private void reset() {
        this.setFramePosition(0L);
        this.setFramePositionOld(0L);
        this.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.m_SyncObject;
        synchronized (object) {
            if (this.m_Closed) {
                return;
            }
            this.m_Closed = true;
            Object object2 = this.m_SyncPlayStatusList;
            synchronized (object2) {
                Iterator<String> o_Iterator = this.m_ObjectPlayStatusList.keySet().iterator();
                while (o_Iterator.hasNext()) {
                    String stringObjectID = o_Iterator.next();
                    o_Iterator.remove();
                    ObjectPlayStatus o_ObjectPlayStatus = this.m_ObjectPlayStatusList.get(stringObjectID);
                    if (o_ObjectPlayStatus == null) continue;
                    o_ObjectPlayStatus.close();
                }
            }
            MediaObject_PlayStatus.poolAddEmpty(this);
        }
    }

    public void setName(String p_Name) {
        if (p_Name == null) {
            return;
        }
        this.m_Name = p_Name;
    }

    public String getName() {
        return this.m_Name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLiveShowMediaObject(LiveShowObjectDescription p_LiveShowObjectDescription) {
        if (p_LiveShowObjectDescription == null) {
            return;
        }
        String stringObjectID = p_LiveShowObjectDescription.getID();
        Object object = this.m_SyncPlayStatusList;
        synchronized (object) {
            ObjectPlayStatus o_ObjectPlayStatus = this.getObjectPlayStatus(stringObjectID);
            if (o_ObjectPlayStatus == null) {
                o_ObjectPlayStatus = ObjectPlayStatus.poolGet();
                o_ObjectPlayStatus.setObjectID(stringObjectID);
                this.m_ObjectPlayStatusList.put(stringObjectID, o_ObjectPlayStatus);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLiveShowMediaObject(LiveShowObjectDescription p_LiveShowObjectDescription) {
        ObjectPlayStatus o_ObjectPlayStatus;
        if (p_LiveShowObjectDescription == null) {
            return;
        }
        String stringObjectID = p_LiveShowObjectDescription.getID();
        Object object = this.m_SyncPlayStatusList;
        synchronized (object) {
            o_ObjectPlayStatus = this.m_ObjectPlayStatusList.remove(stringObjectID);
        }
        if (o_ObjectPlayStatus != null) {
            o_ObjectPlayStatus.close();
        }
    }

    public void setReadPreObject(boolean p_ReadPreObject) {
        this.m_ReadPreObject = p_ReadPreObject;
    }

    public PlayStatus_PositionFade getPlayStatus_PositionFade() {
        return this.m_PlayStatus_PositionFade;
    }

    public PlayStatus_PositionFade getPlayStatus_PositionFade_Pre() {
        return this.m_PlayStatus_PositionFade_Pre;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectPlayStatus getObjectPlayStatus(String p_ObjectID) {
        if (p_ObjectID == null) {
            return null;
        }
        Object object = this.m_SyncPlayStatusList;
        synchronized (object) {
            return this.m_ObjectPlayStatusList.get(p_ObjectID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPlayStatus(String p_ObjectID, boolean p_IsPlaying, boolean p_IsPreObject, long p_MediaPositionFrame, float p_VolumeFactor, double p_FadeProgress, boolean p_FadeIn, boolean p_FadeOut) {
        ObjectPlayStatus o_ObjectPlayStatus;
        if (p_ObjectID == null) {
            return;
        }
        Object object = this.m_SyncPlayStatusList;
        synchronized (object) {
            o_ObjectPlayStatus = this.m_ObjectPlayStatusList.get(p_ObjectID);
        }
        if (o_ObjectPlayStatus == null) {
            o_ObjectPlayStatus = ObjectPlayStatus.poolGet();
            o_ObjectPlayStatus.setObjectID(p_ObjectID);
            object = this.m_SyncPlayStatusList;
            synchronized (object) {
                this.m_ObjectPlayStatusList.put(p_ObjectID, o_ObjectPlayStatus);
            }
        }
        o_ObjectPlayStatus.setPlayStatus(p_IsPlaying, p_IsPreObject, p_MediaPositionFrame, p_VolumeFactor, p_FadeProgress, p_FadeIn, p_FadeOut);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        Object object = this.m_SyncPlayStatusList;
        synchronized (object) {
            for (String stringObjectID : this.m_ObjectPlayStatusList.keySet()) {
                ObjectPlayStatus o_ObjectPlayStatus = this.m_ObjectPlayStatusList.get(stringObjectID);
                if (o_ObjectPlayStatus == null) continue;
                o_ObjectPlayStatus.setIsPlaying(false, true);
                o_ObjectPlayStatus.setIsPlaying(false, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.m_SyncPlayStatusList;
        synchronized (object) {
        }
        this.setFrameTime(0.022675736961451247);
        this.setFramesToRead(0L);
        this.setFadeProgress(1.0);
        this.setFadeInProgress(0.0);
        this.setFadeOutProgress(0.0);
        this.setVolumeFactor(1.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(1);
        out.writeUTF(this.m_Name);
        this.m_PlayStatus_PositionFade.writeExternal(out);
        this.m_PlayStatus_PositionFade_Pre.writeExternal(out);
        Object object = this.m_SyncPlayStatusList;
        synchronized (object) {
            ObjectPlayStatus o_ObjectPlayStatus;
            int intObjectCount = this.m_ObjectPlayStatusList.size();
            ArrayList<ObjectPlayStatus> o_ObjectPlayStatuses = new ArrayList<ObjectPlayStatus>(intObjectCount);
            for (String stringObjectID : this.m_ObjectPlayStatusList.keySet()) {
                if (stringObjectID == null || (o_ObjectPlayStatus = this.m_ObjectPlayStatusList.get(stringObjectID)) == null) continue;
                o_ObjectPlayStatuses.add(o_ObjectPlayStatus);
            }
            intObjectCount = o_ObjectPlayStatuses.size();
            out.writeInt(intObjectCount);
            for (int intObject = 0; intObject < intObjectCount; ++intObject) {
                o_ObjectPlayStatus = (ObjectPlayStatus)o_ObjectPlayStatuses.get(intObject);
                o_ObjectPlayStatus.writeExternal(out);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int intSoftwareVersion = in.readInt();
        this.m_Name = in.readUTF();
        this.m_PlayStatus_PositionFade.readExternal(in);
        this.m_PlayStatus_PositionFade_Pre.readExternal(in);
        Object object = this.m_SyncPlayStatusList;
        synchronized (object) {
            int intObjectCount = in.readInt();
            for (int intObject = 0; intObject < intObjectCount; ++intObject) {
                ObjectPlayStatus o_ObjectPlayStatus = new ObjectPlayStatus();
                o_ObjectPlayStatus.readExternal(in);
                this.m_ObjectPlayStatusList.put(o_ObjectPlayStatus.getObjectID(), o_ObjectPlayStatus);
            }
        }
    }

    public Object getData() {
        return this.m_ObjectPlayStatusList;
    }

    public void setFramePosition(long p_FramePosition) {
        if (!this.m_ReadPreObject) {
            this.m_PlayStatus_PositionFade.setFramePosition(p_FramePosition);
        } else {
            this.m_PlayStatus_PositionFade_Pre.setFramePosition(p_FramePosition);
        }
    }

    public long getFramePosition() {
        if (!this.m_ReadPreObject) {
            return this.m_PlayStatus_PositionFade.getFramePosition();
        }
        return this.m_PlayStatus_PositionFade_Pre.getFramePosition();
    }

    public void setFramePositionOld(long p_FramePosition) {
        if (!this.m_ReadPreObject) {
            this.m_PlayStatus_PositionFade.setFramePositionOld(p_FramePosition);
        } else {
            this.m_PlayStatus_PositionFade_Pre.setFramePositionOld(p_FramePosition);
        }
    }

    public long getFramePositionOld() {
        if (!this.m_ReadPreObject) {
            return this.m_PlayStatus_PositionFade.getFramePositionOld();
        }
        return this.m_PlayStatus_PositionFade_Pre.getFramePositionOld();
    }

    public void setFrameTime(double p_FrameTime) {
        this.m_PlayStatus_PositionFade.setFrameTime(p_FrameTime);
        this.m_PlayStatus_PositionFade_Pre.setFrameTime(p_FrameTime);
    }

    public double getFrameTime() {
        if (!this.m_ReadPreObject) {
            return this.m_PlayStatus_PositionFade.getFrameTime();
        }
        return this.m_PlayStatus_PositionFade_Pre.getFrameTime();
    }

    public void setFramesToRead(long p_FrameLength) {
        if (!this.m_ReadPreObject) {
            this.m_PlayStatus_PositionFade.setFramesToRead(p_FrameLength);
        } else {
            this.m_PlayStatus_PositionFade_Pre.setFramesToRead(p_FrameLength);
        }
    }

    public long getFramesToRead() {
        if (!this.m_ReadPreObject) {
            return this.m_PlayStatus_PositionFade.getFramesToRead();
        }
        return this.m_PlayStatus_PositionFade_Pre.getFramesToRead();
    }

    public void setFramesBuffered(int p_FramesBuffered) {
        this.m_PlayStatus_PositionFade.setFramesBuffered(p_FramesBuffered);
        this.m_PlayStatus_PositionFade_Pre.setFramesBuffered(p_FramesBuffered);
    }

    public int getFramesBuffered() {
        if (!this.m_ReadPreObject) {
            return this.m_PlayStatus_PositionFade.getFramesBuffered();
        }
        return this.m_PlayStatus_PositionFade_Pre.getFramesBuffered();
    }

    public double getFadeProgress() {
        if (!this.m_ReadPreObject) {
            return this.m_PlayStatus_PositionFade.getFadeProgress();
        }
        return this.m_PlayStatus_PositionFade_Pre.getFadeProgress();
    }

    public double getFadeInProgress() {
        if (!this.m_ReadPreObject) {
            return this.m_PlayStatus_PositionFade.getFadeInProgress();
        }
        return this.m_PlayStatus_PositionFade_Pre.getFadeInProgress();
    }

    public double getFadeOutProgress() {
        if (!this.m_ReadPreObject) {
            return this.m_PlayStatus_PositionFade.getFadeOutProgress();
        }
        return this.m_PlayStatus_PositionFade_Pre.getFadeOutProgress();
    }

    public void setFadeInProgress(double p_FadeInProgress) {
        if (!this.m_ReadPreObject) {
            this.m_PlayStatus_PositionFade.setFadeInProgress(p_FadeInProgress);
        } else {
            this.m_PlayStatus_PositionFade_Pre.setFadeInProgress(p_FadeInProgress);
        }
    }

    public void setFadeOutProgress(double p_FadeOutProgress) {
        if (!this.m_ReadPreObject) {
            this.m_PlayStatus_PositionFade.setFadeOutProgress(p_FadeOutProgress);
        } else {
            this.m_PlayStatus_PositionFade_Pre.setFadeOutProgress(p_FadeOutProgress);
        }
    }

    public void setFadeProgress(double p_FadeProgress) {
        if (!this.m_ReadPreObject) {
            this.m_PlayStatus_PositionFade.setFadeProgress(p_FadeProgress);
        } else {
            this.m_PlayStatus_PositionFade_Pre.setFadeProgress(p_FadeProgress);
        }
    }

    public double getFadeProgress(boolean p_Pre) {
        if (!p_Pre) {
            return this.m_PlayStatus_PositionFade.getFadeProgress();
        }
        return this.m_PlayStatus_PositionFade_Pre.getFadeProgress();
    }

    public double getFadeInProgress(boolean p_Pre) {
        if (!p_Pre) {
            return this.m_PlayStatus_PositionFade.getFadeInProgress();
        }
        return this.m_PlayStatus_PositionFade_Pre.getFadeInProgress();
    }

    public double getFadeOutProgress(boolean p_Pre) {
        if (!p_Pre) {
            return this.m_PlayStatus_PositionFade.getFadeOutProgress();
        }
        return this.m_PlayStatus_PositionFade_Pre.getFadeOutProgress();
    }

    public void setVolumeFactor(float p_Factor) {
        if (!this.m_ReadPreObject) {
            this.m_PlayStatus_PositionFade.setVolumeFactor(p_Factor);
        } else {
            this.m_PlayStatus_PositionFade_Pre.setVolumeFactor(p_Factor);
        }
    }

    public float getVolumeFactor() {
        if (!this.m_ReadPreObject) {
            return this.m_PlayStatus_PositionFade.getVolumeFactor();
        }
        return this.m_PlayStatus_PositionFade_Pre.getVolumeFactor();
    }

    public HashMap<String, ObjectPlayStatus> getObjectPlayStatusList() {
        return this.m_ObjectPlayStatusList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<ObjectPlayStatus> getObjectPlayStatuseArray() {
        ArrayList<ObjectPlayStatus> o_ObjectPlayStatuses;
        Object object = this.m_SyncPlayStatusList;
        synchronized (object) {
            o_ObjectPlayStatuses = new ArrayList<ObjectPlayStatus>(this.m_ObjectPlayStatusList.size());
            o_ObjectPlayStatuses.addAll(this.m_ObjectPlayStatusList.values());
        }
        return o_ObjectPlayStatuses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFrom(MediaObject_PlayStatus p_MediaObject_PlayStatus) {
        if (p_MediaObject_PlayStatus == null) {
            return;
        }
        this.m_PlayStatus_PositionFade.copyFrom(p_MediaObject_PlayStatus.getPlayStatus_PositionFade());
        this.m_PlayStatus_PositionFade_Pre.copyFrom(p_MediaObject_PlayStatus.getPlayStatus_PositionFade_Pre());
        Object object = this.m_SyncPlayStatusList;
        synchronized (object) {
            ObjectPlayStatus o_ObjectPlayStatus_Self;
            int intObjectPlayStatus;
            if (this.m_Copy_ObjectPlayStatuses == null) {
                this.m_Copy_ObjectPlayStatuses = new ArrayList(this.m_ObjectPlayStatusList.size());
                this.m_Copy_ObjectPlayStatuses.addAll(this.m_ObjectPlayStatusList.values());
            }
            ArrayList<ObjectPlayStatus> o_ObjectPlayStatuses_From = p_MediaObject_PlayStatus.getObjectPlayStatuseArray();
            for (intObjectPlayStatus = 0; intObjectPlayStatus < o_ObjectPlayStatuses_From.size(); ++intObjectPlayStatus) {
                ObjectPlayStatus o_ObjectPlayStatus = o_ObjectPlayStatuses_From.get(intObjectPlayStatus);
                if (o_ObjectPlayStatus == null) continue;
                String stringObjectID = o_ObjectPlayStatus.getObjectID();
                o_ObjectPlayStatus_Self = this.m_ObjectPlayStatusList.get(stringObjectID);
                if (o_ObjectPlayStatus_Self != null) {
                    o_ObjectPlayStatus_Self.copyFrom(o_ObjectPlayStatus);
                    this.m_Copy_ObjectPlayStatuses.remove(o_ObjectPlayStatus_Self);
                    continue;
                }
                o_ObjectPlayStatus_Self = ObjectPlayStatus.poolGet();
                o_ObjectPlayStatus_Self.copyFrom(o_ObjectPlayStatus);
                this.m_ObjectPlayStatusList.put(stringObjectID, o_ObjectPlayStatus_Self);
            }
            for (intObjectPlayStatus = 0; intObjectPlayStatus < this.m_Copy_ObjectPlayStatuses.size(); ++intObjectPlayStatus) {
                o_ObjectPlayStatus_Self = this.m_Copy_ObjectPlayStatuses.get(intObjectPlayStatus);
                if (o_ObjectPlayStatus_Self == null) continue;
                this.m_ObjectPlayStatusList.remove(o_ObjectPlayStatus_Self.getObjectID());
                o_ObjectPlayStatus_Self.close();
            }
        }
    }

    public void copyHeader_From(MediaObject_PlayStatus p_NewMediaObject_PlayStatus) {
        this.m_PlayStatus_PositionFade.copyFrom(p_NewMediaObject_PlayStatus.getPlayStatus_PositionFade());
        this.m_PlayStatus_PositionFade_Pre.copyFrom(p_NewMediaObject_PlayStatus.getPlayStatus_PositionFade_Pre());
    }

    public static class ObjectPlayStatusPlayer
    implements Externalizable {
        public static final int SOFTWAREVERSION = 1;
        public static ArrayList<ObjectPlayStatusPlayer> s_ObjectPlayStatusPlayer_Pool = new ArrayList(100);
        public static int s_PoolSize = 500;
        public static final Object s_SyncPool = new Object();
        private int m_PlayerIndex;
        private String m_ObjectID;
        private boolean m_IsPlaying;
        private boolean m_IsPreObject;
        private long m_MediaPositionFrame;
        private boolean m_FadeIn;
        private boolean m_FadeOut;
        private double m_FadeFactor;
        private float m_VolumeFactor;
        private boolean m_Closed;
        private final Object m_SyncObject = new Object();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static ObjectPlayStatusPlayer poolGet() {
            ObjectPlayStatusPlayer o_ObjectPlayStatus;
            Object object = s_SyncPool;
            synchronized (object) {
                if (s_ObjectPlayStatusPlayer_Pool.size() > 0) {
                    int intIndex = s_ObjectPlayStatusPlayer_Pool.size() - 1;
                    o_ObjectPlayStatus = s_ObjectPlayStatusPlayer_Pool.get(intIndex);
                    o_ObjectPlayStatus.reactivate();
                    s_ObjectPlayStatusPlayer_Pool.remove(intIndex);
                } else {
                    o_ObjectPlayStatus = new ObjectPlayStatusPlayer();
                }
            }
            return o_ObjectPlayStatus;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static boolean poolAddEmpty(ObjectPlayStatusPlayer p_ObjectPlayStatusPlayer) {
            Object object = s_SyncPool;
            synchronized (object) {
                if (s_ObjectPlayStatusPlayer_Pool.size() < s_PoolSize) {
                    s_ObjectPlayStatusPlayer_Pool.add(p_ObjectPlayStatusPlayer);
                    return true;
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void poolClear() {
            Object object = s_SyncPool;
            synchronized (object) {
                s_ObjectPlayStatusPlayer_Pool.clear();
            }
        }

        public ObjectPlayStatusPlayer() {
            this.initMembers();
        }

        private void initMembers() {
            this.m_PlayerIndex = 0;
            this.m_ObjectID = "";
            this.m_IsPlaying = false;
            this.m_IsPreObject = false;
            this.m_MediaPositionFrame = 0L;
            this.m_FadeIn = false;
            this.m_FadeOut = false;
            this.m_FadeFactor = 0.0;
            this.m_VolumeFactor = 1.0f;
            this.m_Closed = false;
        }

        public void reactivate() {
            this.initMembers();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (this.m_Closed) {
                    return;
                }
                this.m_Closed = true;
                this.m_ObjectID = "";
                this.m_IsPlaying = false;
                this.m_IsPreObject = false;
                this.m_MediaPositionFrame = 0L;
                this.m_FadeIn = false;
                this.m_FadeOut = false;
                this.m_FadeFactor = 0.0;
                this.m_VolumeFactor = 1.0f;
                ObjectPlayStatusPlayer.poolAddEmpty(this);
            }
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(1);
            out.writeUTF(this.m_ObjectID);
            out.writeBoolean(this.m_IsPlaying);
            out.writeBoolean(this.m_IsPreObject);
            out.writeBoolean(this.m_FadeIn);
            out.writeBoolean(this.m_FadeOut);
            out.writeDouble(this.m_FadeFactor);
            out.writeFloat(this.m_VolumeFactor);
            out.writeLong(this.m_MediaPositionFrame);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int intSoftwareVersion = in.readInt();
            this.m_ObjectID = in.readUTF();
            this.m_IsPlaying = in.readBoolean();
            this.m_IsPreObject = in.readBoolean();
            this.m_FadeIn = in.readBoolean();
            this.m_FadeOut = in.readBoolean();
            this.m_FadeFactor = in.readDouble();
            this.m_VolumeFactor = in.readFloat();
            this.m_MediaPositionFrame = in.readLong();
        }

        public void copyFrom(ObjectPlayStatusPlayer p_ObjectPlayStatusPlayer) {
            if (p_ObjectPlayStatusPlayer == null) {
                return;
            }
            this.m_ObjectID = p_ObjectPlayStatusPlayer.getObjectID();
            this.m_IsPlaying = p_ObjectPlayStatusPlayer.getIsPlaying();
            this.m_IsPreObject = p_ObjectPlayStatusPlayer.getIsPreObject();
            this.m_FadeIn = p_ObjectPlayStatusPlayer.getFadeIn();
            this.m_FadeOut = p_ObjectPlayStatusPlayer.getFadeOut();
            this.m_FadeFactor = p_ObjectPlayStatusPlayer.getFadeFactor();
            this.m_VolumeFactor = p_ObjectPlayStatusPlayer.getVolumeFactor();
            this.m_MediaPositionFrame = p_ObjectPlayStatusPlayer.getMediaPositionFrame();
        }

        public void setPlayerIndex(int p_PlayerIndex) {
            this.m_PlayerIndex = p_PlayerIndex;
        }

        public int getPlayerIndex() {
            return this.m_PlayerIndex;
        }

        public void setObjectID(String p_ID) {
            this.m_ObjectID = p_ID;
        }

        public String getObjectID() {
            return this.m_ObjectID;
        }

        public void setIsPlaying(boolean p_IsPlaying) {
            this.m_IsPlaying = p_IsPlaying;
        }

        public boolean getIsPlaying() {
            return this.m_IsPlaying;
        }

        public void setIsPreObject(boolean p_IsPreObject) {
            this.m_IsPreObject = p_IsPreObject;
        }

        public boolean getIsPreObject() {
            return this.m_IsPreObject;
        }

        public void setMediaPositionFrame(long p_FramePosition) {
            this.m_MediaPositionFrame = p_FramePosition;
        }

        public long getMediaPositionFrame() {
            return this.m_MediaPositionFrame;
        }

        public void setFadeFactor(double p_Factor) {
            this.m_FadeFactor = p_Factor;
        }

        public double getFadeFactor() {
            return this.m_FadeFactor;
        }

        public void setFadeIn(boolean p_FadeIn) {
            this.m_FadeIn = p_FadeIn;
        }

        public boolean getFadeIn() {
            return this.m_FadeIn;
        }

        public void setFadeOut(boolean p_FadeOut) {
            this.m_FadeOut = p_FadeOut;
        }

        public boolean getFadeOut() {
            return this.m_FadeOut;
        }

        public void setVolumeFactor(float p_Factor) {
            this.m_VolumeFactor = p_Factor;
        }

        public float getVolumeFactor() {
            return this.m_VolumeFactor;
        }

        public void setPlayStatus(boolean p_IsPlaying, boolean p_IsPreObject, long p_MediaPositionFrame, float p_VolumeFactor, double p_FadeProgress, boolean p_FadeIn, boolean p_FadeOut) {
            this.m_IsPlaying = p_IsPlaying;
            this.m_IsPreObject = p_IsPreObject;
            this.m_FadeIn = p_FadeIn;
            this.m_FadeOut = p_FadeOut;
            this.m_FadeFactor = p_FadeProgress;
            this.m_VolumeFactor = p_VolumeFactor;
            this.m_MediaPositionFrame = p_MediaPositionFrame;
        }
    }

    public static class ObjectPlayStatus
    implements Externalizable {
        public static final int SOFTWAREVERSION = 1;
        public static ArrayList<ObjectPlayStatus> s_ObjectPlayStatus_Pool = new ArrayList(100);
        public static int s_PoolSize = 500;
        public static final Object s_SyncPool = new Object();
        private String m_ObjectID;
        private ObjectPlayStatusPlayer m_ObjectPlayStatusPlayer_0;
        private ObjectPlayStatusPlayer m_ObjectPlayStatusPlayer_1;
        private ObjectPlayStatusPlayer m_ObjectPlayStatusPlayer;
        private ObjectPlayStatusPlayer m_ObjectPlayStatusPlayer_Pre;
        private boolean m_Switched;
        private final Object m_SyncPlayers = new Object();
        private boolean m_Closed;
        private final Object m_SyncObject = new Object();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static ObjectPlayStatus poolGet() {
            ObjectPlayStatus o_ObjectPlayStatus;
            Object object = s_SyncPool;
            synchronized (object) {
                if (s_ObjectPlayStatus_Pool.size() > 0) {
                    int intIndex = s_ObjectPlayStatus_Pool.size() - 1;
                    o_ObjectPlayStatus = s_ObjectPlayStatus_Pool.get(intIndex);
                    o_ObjectPlayStatus.reactivate();
                    s_ObjectPlayStatus_Pool.remove(intIndex);
                } else {
                    o_ObjectPlayStatus = new ObjectPlayStatus();
                }
            }
            return o_ObjectPlayStatus;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static boolean poolAddEmpty(ObjectPlayStatus p_ObjectPlayStatus) {
            Object object = s_SyncPool;
            synchronized (object) {
                if (s_ObjectPlayStatus_Pool.size() < s_PoolSize) {
                    s_ObjectPlayStatus_Pool.add(p_ObjectPlayStatus);
                    return true;
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void poolClear() {
            Object object = s_SyncPool;
            synchronized (object) {
                s_ObjectPlayStatus_Pool.clear();
            }
        }

        public ObjectPlayStatus() {
            this.initMembers();
        }

        private void initMembers() {
            this.m_ObjectID = "";
            this.m_Switched = false;
            this.m_ObjectPlayStatusPlayer_0 = ObjectPlayStatusPlayer.poolGet();
            this.m_ObjectPlayStatusPlayer_0.setPlayerIndex(0);
            this.m_ObjectPlayStatusPlayer = this.m_ObjectPlayStatusPlayer_0;
            this.m_ObjectPlayStatusPlayer_1 = ObjectPlayStatusPlayer.poolGet();
            this.m_ObjectPlayStatusPlayer_1.setPlayerIndex(1);
            this.m_ObjectPlayStatusPlayer_Pre = this.m_ObjectPlayStatusPlayer_1;
            this.m_Closed = false;
        }

        public void reactivate() {
            this.initMembers();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (this.m_Closed) {
                    return;
                }
                this.m_Closed = true;
                this.m_ObjectID = "";
                ObjectPlayStatusPlayer o_ObjectPlayStatusPlayer = this.m_ObjectPlayStatusPlayer;
                if (o_ObjectPlayStatusPlayer != null) {
                    o_ObjectPlayStatusPlayer.close();
                    this.m_ObjectPlayStatusPlayer = null;
                }
                if ((o_ObjectPlayStatusPlayer = this.m_ObjectPlayStatusPlayer_Pre) != null) {
                    o_ObjectPlayStatusPlayer.close();
                    this.m_ObjectPlayStatusPlayer = null;
                }
                ObjectPlayStatus.poolAddEmpty(this);
            }
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(1);
            out.writeUTF(this.m_ObjectID);
            out.writeBoolean(this.m_Switched);
            this.m_ObjectPlayStatusPlayer_0.writeExternal(out);
            this.m_ObjectPlayStatusPlayer_1.writeExternal(out);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int intSoftwareVersion = in.readInt();
            this.m_ObjectID = in.readUTF();
            this.m_Switched = in.readBoolean();
            this.m_ObjectPlayStatusPlayer_0.readExternal(in);
            this.m_ObjectPlayStatusPlayer_1.readExternal(in);
        }

        public void copyFrom(ObjectPlayStatus p_ObjectPlayStatus) {
            if (p_ObjectPlayStatus == null) {
                return;
            }
            this.m_ObjectID = p_ObjectPlayStatus.getObjectID();
            this.m_Switched = p_ObjectPlayStatus.getSwitched();
            this.m_ObjectPlayStatusPlayer_0.copyFrom(p_ObjectPlayStatus.m_ObjectPlayStatusPlayer_0);
            this.m_ObjectPlayStatusPlayer_1.copyFrom(p_ObjectPlayStatus.m_ObjectPlayStatusPlayer_1);
        }

        public void setObjectID(String p_ID) {
            this.m_ObjectID = p_ID;
            this.m_ObjectPlayStatusPlayer_0.setObjectID(this.m_ObjectID);
            this.m_ObjectPlayStatusPlayer_1.setObjectID(this.m_ObjectID);
        }

        public String getObjectID() {
            return this.m_ObjectID;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ObjectPlayStatusPlayer getObjectPlayStatusPlayer_0() {
            Object object = this.m_SyncPlayers;
            synchronized (object) {
                return this.m_ObjectPlayStatusPlayer_0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ObjectPlayStatusPlayer getObjectPlayStatusPlayer_1() {
            Object object = this.m_SyncPlayers;
            synchronized (object) {
                return this.m_ObjectPlayStatusPlayer_1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ObjectPlayStatusPlayer getObjectPlayStatusPlayer() {
            Object object = this.m_SyncPlayers;
            synchronized (object) {
                if (this.m_Switched) {
                    return this.m_ObjectPlayStatusPlayer_1;
                }
                return this.m_ObjectPlayStatusPlayer_0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ObjectPlayStatusPlayer getObjectPlayStatusPlayer_Pre() {
            Object object = this.m_SyncPlayers;
            synchronized (object) {
                if (this.m_Switched) {
                    return this.m_ObjectPlayStatusPlayer_0;
                }
                return this.m_ObjectPlayStatusPlayer_1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setIsPlaying(boolean p_IsPlaying, boolean p_IsPreobject) {
            ObjectPlayStatusPlayer o_ObjectPlayStatusPlayer_Pre;
            ObjectPlayStatusPlayer o_ObjectPlayStatusPlayer;
            Object object = this.m_SyncPlayers;
            synchronized (object) {
                o_ObjectPlayStatusPlayer = this.getObjectPlayStatusPlayer();
                o_ObjectPlayStatusPlayer_Pre = this.getObjectPlayStatusPlayer_Pre();
            }
            if (p_IsPreobject) {
                o_ObjectPlayStatusPlayer_Pre.setIsPlaying(p_IsPlaying);
            } else {
                o_ObjectPlayStatusPlayer.setIsPlaying(p_IsPlaying);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void switchPlayers() {
            Object object = this.m_SyncPlayers;
            synchronized (object) {
                ObjectPlayStatusPlayer o_TempPlayer = this.m_ObjectPlayStatusPlayer;
                this.m_ObjectPlayStatusPlayer = this.m_ObjectPlayStatusPlayer_Pre;
                this.m_ObjectPlayStatusPlayer_Pre = o_TempPlayer;
                this.m_Switched = !this.m_Switched;
            }
        }

        public boolean getSwitched() {
            return this.m_Switched;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setPlayStatus(boolean p_IsPlaying, boolean p_IsPreObject, long p_MediaPositionFrame, float p_VolumeFactor, double p_FadeProgress, boolean p_FadeIn, boolean p_FadeOut) {
            ObjectPlayStatusPlayer o_ObjectPlayStatusPlayer_Pre;
            ObjectPlayStatusPlayer o_ObjectPlayStatusPlayer;
            if (p_MediaPositionFrame == 0L) {
                // empty if block
            }
            Object object = this.m_SyncPlayers;
            synchronized (object) {
                o_ObjectPlayStatusPlayer = this.getObjectPlayStatusPlayer();
                o_ObjectPlayStatusPlayer_Pre = this.getObjectPlayStatusPlayer_Pre();
            }
            if (p_IsPreObject) {
                o_ObjectPlayStatusPlayer_Pre.setPlayStatus(p_IsPlaying, p_IsPreObject, p_MediaPositionFrame, p_VolumeFactor, p_FadeProgress, p_FadeIn, p_FadeOut);
            } else {
                o_ObjectPlayStatusPlayer.setPlayStatus(p_IsPlaying, p_IsPreObject, p_MediaPositionFrame, p_VolumeFactor, p_FadeProgress, p_FadeIn, p_FadeOut);
            }
        }
    }

    public static class PlayStatus_PositionFade
    implements Externalizable {
        public static final int SOFTWAREVERSION = 1;
        private boolean m_isPreObject;
        private long m_FramePosition;
        private long m_FramePositionOld;
        private double m_FrameTime;
        private long m_FramesToRead;
        private int m_FramesBuffered;
        private double m_FadeProgress;
        private double m_FadeInProgress;
        private double m_FadeOutProgress;
        private float m_VolumeFactor_SceneBridge;

        public PlayStatus_PositionFade(boolean p_IsPreObject) {
            this.initMembers();
            this.m_isPreObject = p_IsPreObject;
        }

        private void initMembers() {
            this.m_isPreObject = false;
            this.m_FrameTime = 0.022675736961451247;
            this.m_FramesToRead = 0L;
            this.m_FadeProgress = 1.0;
            this.m_FadeInProgress = 0.0;
            this.m_FadeOutProgress = 0.0;
            this.m_VolumeFactor_SceneBridge = 1.0f;
        }

        public void clear() {
            this.m_FrameTime = 0.022675736961451247;
            this.m_FramesToRead = 0L;
            this.m_FadeProgress = 1.0;
            this.m_FadeInProgress = 0.0;
            this.m_FadeOutProgress = 0.0;
            this.m_VolumeFactor_SceneBridge = 1.0f;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(1);
            out.writeLong(this.m_FramePosition);
            out.writeDouble(this.m_FrameTime);
            out.writeLong(this.m_FramesToRead);
            out.writeInt(this.m_FramesBuffered);
            out.writeDouble(this.m_FadeProgress);
            out.writeDouble(this.m_FadeInProgress);
            out.writeDouble(this.m_FadeOutProgress);
            out.writeFloat(this.m_VolumeFactor_SceneBridge);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int intSoftwareVersion = in.readInt();
            this.m_FramePosition = in.readLong();
            this.m_FrameTime = in.readDouble();
            this.m_FramesToRead = in.readLong();
            this.m_FramesBuffered = in.readInt();
            this.m_FadeProgress = in.readDouble();
            this.m_FadeInProgress = in.readDouble();
            this.m_FadeOutProgress = in.readDouble();
            this.m_VolumeFactor_SceneBridge = in.readFloat();
        }

        public void copyFrom(PlayStatus_PositionFade p_PlayStatus_PositionFade) {
            if (p_PlayStatus_PositionFade == null) {
                this.setFadeInProgress(1.0);
                this.setFadeOutProgress(1.0);
                this.setFadeProgress(1.0);
                this.setFramePosition(0L);
                this.setFrameTime(0.022675736961451247);
                this.setFramesBuffered(1);
                this.setFramesToRead(0L);
                this.setVolumeFactor(1.0f);
            } else {
                this.m_FadeInProgress = p_PlayStatus_PositionFade.getFadeInProgress();
                this.m_FadeOutProgress = p_PlayStatus_PositionFade.getFadeOutProgress();
                this.m_FadeProgress = p_PlayStatus_PositionFade.getFadeProgress();
                this.m_FramePosition = p_PlayStatus_PositionFade.getFramePosition();
                this.m_FramePositionOld = p_PlayStatus_PositionFade.getFramePositionOld();
                this.m_FrameTime = p_PlayStatus_PositionFade.getFrameTime();
                this.m_FramesBuffered = p_PlayStatus_PositionFade.getFramesBuffered();
                this.m_FramesToRead = p_PlayStatus_PositionFade.getFramesToRead();
                this.m_VolumeFactor_SceneBridge = p_PlayStatus_PositionFade.getVolumeFactor();
            }
        }

        public void setFramePosition(long p_FramePosition) {
            this.m_FramePositionOld = this.m_FramePosition;
            this.m_FramePosition = p_FramePosition;
        }

        public long getFramePosition() {
            return this.m_FramePosition;
        }

        public void setFramePositionOld(long p_FramePositionOld) {
            this.m_FramePositionOld = p_FramePositionOld;
        }

        public long getFramePositionOld() {
            return this.m_FramePositionOld;
        }

        public void setFrameTime(double p_FrameTime) {
            this.m_FrameTime = p_FrameTime;
        }

        public double getFrameTime() {
            return this.m_FrameTime;
        }

        public void setFramesToRead(long p_FrameLength) {
            this.m_FramesToRead = p_FrameLength;
        }

        public long getFramesToRead() {
            return this.m_FramesToRead;
        }

        public void setFramesBuffered(int p_FramesBuffered) {
            this.m_FramesBuffered = p_FramesBuffered;
        }

        public int getFramesBuffered() {
            return this.m_FramesBuffered;
        }

        public double getFadeProgress() {
            return this.m_FadeProgress;
        }

        public double getFadeInProgress() {
            return this.m_FadeInProgress;
        }

        public double getFadeOutProgress() {
            return this.m_FadeOutProgress;
        }

        public void setFadeInProgress(double p_FadeInProgress) {
            this.m_FadeInProgress = p_FadeInProgress;
        }

        public void setFadeOutProgress(double p_FadeOutProgress) {
            this.m_FadeOutProgress = p_FadeOutProgress;
        }

        public void setFadeProgress(double p_FadeProgress) {
            this.m_FadeProgress = p_FadeProgress;
        }

        public void setVolumeFactor(float p_Factor) {
            this.m_VolumeFactor_SceneBridge = p_Factor;
        }

        public float getVolumeFactor() {
            return this.m_VolumeFactor_SceneBridge;
        }
    }
}

