/*
 * Decompiled with CFR 0.152.
 */
package MediaObjectPackage;

import LiveShowObjectPackage.LiveShowObjectDescription;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;

public class LiveShowMediaObjectDescription
extends LiveShowObjectDescription {
    public static final int SOFTWAREVERSION = 6;
    public static final String DEFAULT_MEDIAOBJECTNAME = "MediaObject";
    public static final double MAX_SIZE_FACTOR = 2.0;
    public static int s_PoolSize = 1000;
    public static ArrayList<LiveShowMediaObjectDescription> s_LiveShowMediaObjectDescriptionsPool = new ArrayList(100);
    public static final Object s_SyncPool = new Object();
    private int m_MediaType;
    private String m_CheckSum;
    private String m_Producer;
    private ArrayList<String> m_MediaServerIDs;
    private ArrayList<String> m_MediaServerURLs;
    private ArrayList<String> m_MediaServerPorts;
    private float m_MediaSoundVolume;
    private long m_MediaSoundDelay;
    private Rectangle2D m_MediaRelativePositionSize;
    private int m_MediaFlagSize;
    private int m_MediaFlagPosition;
    private int m_MediaFlagAspect;
    private int m_MediaAnchor;
    private boolean m_MediaFlip_Horizontally;
    private boolean m_MediaFlip_Vertically;
    private double m_MediaRotateValue;
    private int m_MediaZOrder;
    private final Object m_SyncMediaServers = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LiveShowMediaObjectDescription poolGet() {
        LiveShowMediaObjectDescription o_LiveShowDMXObjectDescription;
        Object object = s_SyncPool;
        synchronized (object) {
            if (s_LiveShowMediaObjectDescriptionsPool.size() > 0) {
                int intIndex = s_LiveShowMediaObjectDescriptionsPool.size() - 1;
                o_LiveShowDMXObjectDescription = s_LiveShowMediaObjectDescriptionsPool.get(intIndex);
                o_LiveShowDMXObjectDescription.reactivate(true);
                s_LiveShowMediaObjectDescriptionsPool.remove(intIndex);
            } else {
                o_LiveShowDMXObjectDescription = new LiveShowMediaObjectDescription();
            }
        }
        return o_LiveShowDMXObjectDescription;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean poolAddEmpty(LiveShowMediaObjectDescription p_LiveShowDMXObjectDescription) {
        if (p_LiveShowDMXObjectDescription == null) {
            return false;
        }
        Object object = s_SyncPool;
        synchronized (object) {
            if (s_LiveShowMediaObjectDescriptionsPool.size() < s_PoolSize) {
                s_LiveShowMediaObjectDescriptionsPool.add(p_LiveShowDMXObjectDescription);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void poolClear() {
        Object object = s_SyncPool;
        synchronized (object) {
            s_LiveShowMediaObjectDescriptionsPool.clear();
        }
    }

    public LiveShowMediaObjectDescription() {
        this.initMembers();
    }

    private void initMembers() {
        this.m_MediaType = -1;
        this.m_CheckSum = "";
        this.m_Producer = "";
        this.m_MediaServerIDs = new ArrayList();
        this.m_MediaServerPorts = new ArrayList();
        this.m_MediaServerURLs = new ArrayList();
        this.m_MediaSoundVolume = 1.0f;
        this.m_MediaSoundDelay = 0L;
        this.m_MediaRelativePositionSize = new Rectangle2D.Double();
        this.m_MediaRelativePositionSize.setRect(0.0, 0.0, 1.0, 1.0);
        this.m_MediaFlagAspect = 0;
        this.m_MediaAnchor = 0;
        this.m_MediaFlip_Horizontally = false;
        this.m_MediaFlip_Vertically = false;
        this.m_MediaRotateValue = 0.0;
        this.m_MediaZOrder = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(6);
        super.writeExternal(out);
        out.writeInt(this.m_MediaType);
        out.writeUTF(this.m_CheckSum);
        out.writeUTF(this.m_Producer);
        Object object = this.m_SyncMediaServers;
        synchronized (object) {
            int intMediaServerCount = this.m_MediaServerIDs.size();
            out.writeInt(intMediaServerCount);
            for (int intMediaServer = 0; intMediaServer < intMediaServerCount; ++intMediaServer) {
                out.writeUTF(this.m_MediaServerIDs.get(intMediaServer));
                out.writeUTF(this.m_MediaServerURLs.get(intMediaServer));
                out.writeUTF(this.m_MediaServerPorts.get(intMediaServer));
            }
        }
        out.writeDouble(this.m_MediaRelativePositionSize.getX());
        out.writeDouble(this.m_MediaRelativePositionSize.getY());
        out.writeDouble(this.m_MediaRelativePositionSize.getWidth());
        out.writeDouble(this.m_MediaRelativePositionSize.getHeight());
        out.writeInt(this.m_MediaAnchor);
        out.writeInt(this.m_MediaFlagAspect);
        out.writeInt(this.m_MediaFlagSize);
        out.writeInt(this.m_MediaFlagPosition);
        out.writeFloat(this.m_MediaSoundVolume);
        out.writeLong(this.m_MediaSoundDelay);
        out.writeBoolean(this.m_MediaFlip_Horizontally);
        out.writeBoolean(this.m_MediaFlip_Vertically);
        out.writeDouble(this.m_MediaRotateValue);
        out.writeInt(this.m_MediaZOrder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int intSoftwareVersion = in.readInt();
        super.readExternal(in);
        this.m_MediaType = in.readInt();
        this.m_CheckSum = in.readUTF();
        this.m_Producer = in.readUTF();
        if (intSoftwareVersion >= 5) {
            int intMediaServerCount = in.readInt();
            for (int intMediaServer = 0; intMediaServer < intMediaServerCount; ++intMediaServer) {
                String stringMediaServerID = in.readUTF();
                String stringMediaServerURL = in.readUTF();
                String stringMediaServerPort = in.readUTF();
                if (stringMediaServerID == null || stringMediaServerID.length() <= 0) continue;
                Object object = this.m_SyncMediaServers;
                synchronized (object) {
                    this.m_MediaServerIDs.add(stringMediaServerID);
                    this.m_MediaServerURLs.add(stringMediaServerURL);
                    this.m_MediaServerPorts.add(stringMediaServerPort);
                    continue;
                }
            }
        } else {
            String stringMediaServerID = in.readUTF();
            String stringMediaServerURL = in.readUTF();
            String stringMediaServerPort = in.readUTF();
            if (stringMediaServerID != null && stringMediaServerID.length() > 0) {
                Object intMediaServer = this.m_SyncMediaServers;
                synchronized (intMediaServer) {
                    this.m_MediaServerIDs.add(stringMediaServerID);
                    this.m_MediaServerURLs.add(stringMediaServerURL);
                    this.m_MediaServerPorts.add(stringMediaServerPort);
                }
            }
        }
        double doubleX = in.readDouble();
        double doubleY = in.readDouble();
        double doubleWidth = in.readDouble();
        double doubleHeight = in.readDouble();
        this.m_MediaRelativePositionSize.setRect(doubleX, doubleY, doubleWidth, doubleHeight);
        this.m_MediaAnchor = in.readInt();
        this.m_MediaFlagAspect = in.readInt();
        this.m_MediaFlagSize = in.readInt();
        if (this.m_MediaFlagSize != 0 && this.m_MediaFlagSize != 1) {
            this.m_MediaFlagSize = 0;
        }
        this.m_MediaFlagPosition = in.readInt();
        if (intSoftwareVersion >= 2) {
            this.m_MediaSoundVolume = in.readFloat();
            this.m_MediaSoundDelay = in.readLong();
        }
        if (intSoftwareVersion >= 3) {
            this.m_MediaFlip_Horizontally = in.readBoolean();
            this.m_MediaFlip_Vertically = in.readBoolean();
        }
        if (intSoftwareVersion >= 4) {
            this.m_MediaRotateValue = in.readDouble();
        }
        this.m_MediaZOrder = intSoftwareVersion >= 6 ? in.readInt() : this.getVIPTrackNumber();
        boolean intTest = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDiskSpaceEstimated() {
        long longBytesCount = 0L;
        longBytesCount += 4L;
        longBytesCount += super.getDiskSpaceEstimated();
        longBytesCount += 4L;
        longBytesCount += (long)(this.m_CheckSum.length() * 2);
        longBytesCount += (long)(this.m_Producer.length() * 2);
        Object object = this.m_SyncMediaServers;
        synchronized (object) {
            int intMediaServerCount = this.m_MediaServerIDs.size();
            for (int intMediaServer = 0; intMediaServer < intMediaServerCount; ++intMediaServer) {
                String stringMediaServerID = this.m_MediaServerIDs.get(intMediaServer);
                String stringMediaServerURL = this.m_MediaServerURLs.get(intMediaServer);
                String stringMediaServerPort = this.m_MediaServerPorts.get(intMediaServer);
                if (stringMediaServerID != null) {
                    longBytesCount += (long)(stringMediaServerID.length() * 2);
                }
                if (stringMediaServerURL != null) {
                    longBytesCount += (long)(stringMediaServerURL.length() * 2);
                }
                if (stringMediaServerPort == null) continue;
                longBytesCount += (long)(stringMediaServerPort.length() * 2);
            }
        }
        longBytesCount += 8L;
        longBytesCount += 8L;
        longBytesCount += 8L;
        longBytesCount += 8L;
        longBytesCount += 4L;
        longBytesCount += 4L;
        longBytesCount += 4L;
        longBytesCount += 4L;
        longBytesCount += 4L;
        return longBytesCount += 4L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean p_Final) {
        super.close(false);
        if (p_Final) {
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (this.m_Closed) {
                    return;
                }
                this.m_Closed = true;
                if (!LiveShowMediaObjectDescription.poolAddEmpty(this)) {
                    // empty if block
                }
            }
        }
    }

    public void reactivate(boolean p_SetTDefault) {
        super.reactivate(p_SetTDefault);
        this.m_MediaType = -1;
        this.m_CheckSum = "";
        this.m_Producer = "";
        this.clearMediaServerIDs();
        this.m_FrameLength = LiveShowObjectDescription.DEFAULTFRAMELENGTH;
        this.m_MediaFlagSize = 0;
        this.m_MediaRelativePositionSize.setRect(0.0, 0.0, 1.0, 1.0);
        this.m_MediaFlagAspect = 0;
        this.m_MediaAnchor = 0;
        this.m_MediaFlip_Horizontally = false;
        this.m_MediaFlip_Vertically = false;
        this.m_MediaRotateValue = 0.0;
        this.m_MediaSoundVolume = 1.0f;
        this.m_MediaSoundDelay = 0L;
    }

    public int getMediaType() {
        return this.m_MediaType;
    }

    public boolean setMediaType(int p_MediaType) {
        if (p_MediaType != 1001 && p_MediaType != 1002 && p_MediaType != 1003) {
            p_MediaType = -1;
        }
        if (this.m_MediaType == p_MediaType) {
            return false;
        }
        this.m_MediaType = p_MediaType;
        return true;
    }

    public boolean setCheckSum(String p_CheckSum) {
        if (p_CheckSum == null) {
            return false;
        }
        if (p_CheckSum.equals(this.m_CheckSum)) {
            return false;
        }
        this.m_CheckSum = p_CheckSum;
        return true;
    }

    public String getCheckSum() {
        return this.m_CheckSum;
    }

    public String getProducer() {
        return this.m_Producer;
    }

    public boolean setProducer(String p_Producer) {
        if (p_Producer == null) {
            return false;
        }
        if (this.m_Producer.equals(p_Producer)) {
            return false;
        }
        this.m_Producer = p_Producer;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMediaServerID(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        Object object = this.m_SyncMediaServers;
        synchronized (object) {
            if (p_Index >= this.m_MediaServerIDs.size()) {
                return null;
            }
            return this.m_MediaServerIDs.get(p_Index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMediaServerURL(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        Object object = this.m_SyncMediaServers;
        synchronized (object) {
            if (p_Index >= this.m_MediaServerURLs.size()) {
                return null;
            }
            return this.m_MediaServerURLs.get(p_Index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMediaServerPort(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        Object object = this.m_SyncMediaServers;
        synchronized (object) {
            if (p_Index >= this.m_MediaServerPorts.size()) {
                return null;
            }
            return this.m_MediaServerPorts.get(p_Index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addMediaServerID_Connection(String p_MediaServerID, String p_MediaServerURL, String p_MediaServerPort) {
        if (p_MediaServerID == null || p_MediaServerID.length() <= 0) {
            return false;
        }
        if (p_MediaServerURL == null) {
            p_MediaServerURL = "";
        }
        if (p_MediaServerPort == null) {
            p_MediaServerPort = "";
        }
        Object object = this.m_SyncMediaServers;
        synchronized (object) {
            int intIndex = this.m_MediaServerIDs.indexOf(p_MediaServerID);
            if (intIndex >= 0) {
                String stringMediaServerURL = this.m_MediaServerURLs.get(intIndex);
                String stringMediaServerPort = this.m_MediaServerPorts.get(intIndex);
                if (p_MediaServerURL.equals(stringMediaServerURL) && p_MediaServerPort.equals(stringMediaServerPort)) {
                    return false;
                }
                this.m_MediaServerURLs.set(intIndex, p_MediaServerURL);
                this.m_MediaServerPorts.set(intIndex, p_MediaServerPort);
                return true;
            }
            this.m_MediaServerIDs.add(p_MediaServerID);
            this.m_MediaServerURLs.add(p_MediaServerURL);
            this.m_MediaServerPorts.add(p_MediaServerPort);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeMediaServerID_Connection(String p_MediaServerID) {
        Object object = this.m_SyncMediaServers;
        synchronized (object) {
            int intIndex = this.m_MediaServerIDs.indexOf(p_MediaServerID);
            if (intIndex >= 0) {
                this.m_MediaServerIDs.remove(intIndex);
                this.m_MediaServerURLs.remove(intIndex);
                this.m_MediaServerPorts.remove(intIndex);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearMediaServerIDs() {
        Object object = this.m_SyncMediaServers;
        synchronized (object) {
            this.m_MediaServerIDs.clear();
            this.m_MediaServerURLs.clear();
            this.m_MediaServerPorts.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMediaServerIDCount() {
        Object object = this.m_SyncMediaServers;
        synchronized (object) {
            return this.m_MediaServerIDs.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsMediaServerID(String p_MediaServerID, String p_MediaServerURL, String p_MediaServerPort) {
        if (p_MediaServerID == null || p_MediaServerID.length() <= 0) {
            return false;
        }
        Object object = this.m_SyncMediaServers;
        synchronized (object) {
            int intIndex = this.m_MediaServerIDs.indexOf(p_MediaServerID);
            if (intIndex < 0) {
                return false;
            }
            String stringMediaServerURL = this.m_MediaServerURLs.get(intIndex);
            String stringMediaServerPort = this.m_MediaServerPorts.get(intIndex);
            if (stringMediaServerURL.equals(p_MediaServerURL) && stringMediaServerPort.equals(p_MediaServerPort)) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsMediaServerID(String p_MediaServerID) {
        if (p_MediaServerID == null || p_MediaServerID.length() <= 0) {
            return false;
        }
        Object object = this.m_SyncMediaServers;
        synchronized (object) {
            int intIndex = this.m_MediaServerIDs.indexOf(p_MediaServerID);
            if (intIndex >= 0) {
                return true;
            }
        }
        return false;
    }

    public boolean setMediaZOrder(int p_ZOrder) {
        if (this.m_MediaZOrder == p_ZOrder) {
            return false;
        }
        this.m_MediaZOrder = p_ZOrder;
        return true;
    }

    public int getMediaZOrder() {
        return this.m_MediaZOrder;
    }

    public boolean setMediaFlipHorizontally(boolean p_FlipHorizontally) {
        if (this.m_MediaFlip_Horizontally == p_FlipHorizontally) {
            return false;
        }
        this.m_MediaFlip_Horizontally = p_FlipHorizontally;
        return true;
    }

    public boolean getMediaFlipHorizontally() {
        return this.m_MediaFlip_Horizontally;
    }

    public boolean setMediaFlipVertically(boolean p_FlipVertically) {
        if (this.m_MediaFlip_Vertically == p_FlipVertically) {
            return false;
        }
        this.m_MediaFlip_Vertically = p_FlipVertically;
        return true;
    }

    public boolean getMediaFlipVertically() {
        return this.m_MediaFlip_Vertically;
    }

    public boolean setMediaRotateValue(double p_Degrees) {
        if (this.m_MediaRotateValue == p_Degrees) {
            return false;
        }
        this.m_MediaRotateValue = p_Degrees;
        return true;
    }

    public double getMediaRotateValue() {
        return this.m_MediaRotateValue;
    }

    public boolean setMediaRelativePositionSize(Rectangle2D p_Rectangle2D) {
        if (p_Rectangle2D == null) {
            return false;
        }
        return this.setMediaRelativePositionSize(p_Rectangle2D.getX(), p_Rectangle2D.getY(), p_Rectangle2D.getWidth(), p_Rectangle2D.getHeight());
    }

    public boolean setMediaRelativePositionSize(double p_X, double p_Y, double p_Width, double p_Height) {
        if (p_X < -1.0) {
            p_X = -1.0;
        }
        if (p_X > 1.0) {
            p_X = 1.0;
        }
        if (p_Y < -1.0) {
            p_Y = -1.0;
        }
        if (p_Y > 1.0) {
            p_Y = 1.0;
        }
        if (p_Width < 0.0) {
            p_Width = 0.0;
        }
        if (p_Width > 2.0) {
            p_Width = 2.0;
        }
        if (p_Height < 0.0) {
            p_Height = 0.0;
        }
        if (p_Height > 2.0) {
            p_Height = 2.0;
        }
        if (p_X == this.m_MediaRelativePositionSize.getX() && p_Y == this.m_MediaRelativePositionSize.getY() && p_Width == this.m_MediaRelativePositionSize.getWidth() && p_Height == this.m_MediaRelativePositionSize.getHeight()) {
            return false;
        }
        this.m_MediaRelativePositionSize.setRect(p_X, p_Y, p_Width, p_Height);
        return true;
    }

    public Rectangle2D getMediaRelativePositionSize() {
        return this.m_MediaRelativePositionSize;
    }

    public boolean setMediaFlagSize(int p_MediaFlagSize) {
        if (p_MediaFlagSize != 0 && p_MediaFlagSize != 1) {
            p_MediaFlagSize = 0;
        }
        if (this.m_MediaFlagSize == p_MediaFlagSize) {
            return false;
        }
        this.m_MediaFlagSize = p_MediaFlagSize;
        return true;
    }

    public int getMediaFlagSize() {
        return this.m_MediaFlagSize;
    }

    public boolean setMediaFlagPosition(int p_MediaFlagSize) {
        if (p_MediaFlagSize != 0 && p_MediaFlagSize != 1) {
            return false;
        }
        if (this.m_MediaFlagPosition == p_MediaFlagSize) {
            return false;
        }
        this.m_MediaFlagPosition = p_MediaFlagSize;
        return true;
    }

    public int getMediaFlagPosition() {
        return this.m_MediaFlagPosition;
    }

    public boolean setMediaFlagAspect(int p_FlagAspect) {
        if (p_FlagAspect != 0 && p_FlagAspect != 1) {
            return false;
        }
        if (this.m_MediaFlagAspect == p_FlagAspect) {
            return false;
        }
        this.m_MediaFlagAspect = p_FlagAspect;
        return true;
    }

    public int getMediaFlagAspect() {
        return this.m_MediaFlagAspect;
    }

    public boolean setMediaAnchor(int p_MediaAnchor) {
        if (p_MediaAnchor < 0 || p_MediaAnchor > 8) {
            p_MediaAnchor = 0;
        }
        if (this.m_MediaAnchor == p_MediaAnchor) {
            return false;
        }
        this.m_MediaAnchor = p_MediaAnchor;
        return true;
    }

    public int getMediaAnchor() {
        return this.m_MediaAnchor;
    }

    public boolean setMediaSoundVolume(float p_Volume) {
        boolean boolChanged = false;
        if (p_Volume < 0.0f) {
            p_Volume = 0.0f;
        }
        if (p_Volume > 2.0f) {
            p_Volume = 2.0f;
        }
        if (this.m_MediaSoundVolume == p_Volume) {
            return boolChanged;
        }
        this.m_MediaSoundVolume = p_Volume;
        boolChanged = true;
        return boolChanged;
    }

    public float getMediaSoundVolume() {
        return this.m_MediaSoundVolume;
    }

    public boolean setMediaSoundDelay(long p_Milliseconds) {
        boolean boolChanged = false;
        if (p_Milliseconds < 0L) {
            p_Milliseconds = 0L;
        }
        if (this.m_MediaSoundDelay == p_Milliseconds) {
            return boolChanged;
        }
        this.m_MediaSoundDelay = p_Milliseconds;
        boolChanged = true;
        return boolChanged;
    }

    public long getMediaSoundDelay() {
        return this.m_MediaSoundDelay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LiveShowObjectDescription clone(LiveShowObjectDescription p_LiveShowObjectDescription) {
        LiveShowMediaObjectDescription o_LiveShowMediaObjectDescription = p_LiveShowObjectDescription == null ? LiveShowMediaObjectDescription.poolGet() : (LiveShowMediaObjectDescription)p_LiveShowObjectDescription;
        super.clone((LiveShowObjectDescription)o_LiveShowMediaObjectDescription);
        o_LiveShowMediaObjectDescription.setMediaType(this.m_MediaType);
        o_LiveShowMediaObjectDescription.setCheckSum(this.m_CheckSum);
        o_LiveShowMediaObjectDescription.setProducer(this.m_Producer);
        Object object = this.m_SyncMediaServers;
        synchronized (object) {
            o_LiveShowMediaObjectDescription.clearMediaServerIDs();
            int intMediaServerCount = this.m_MediaServerIDs.size();
            for (int intMediaServer = 0; intMediaServer < intMediaServerCount; ++intMediaServer) {
                String stringMediaServerID = this.getMediaServerID(intMediaServer);
                String stringMediaServerURL = this.getMediaServerURL(intMediaServer);
                String stringMediaServerPort = this.getMediaServerPort(intMediaServer);
                o_LiveShowMediaObjectDescription.addMediaServerID_Connection(stringMediaServerID, stringMediaServerURL, stringMediaServerPort);
            }
        }
        o_LiveShowMediaObjectDescription.setMediaRelativePositionSize(this.m_MediaRelativePositionSize);
        o_LiveShowMediaObjectDescription.setMediaFlagAspect(this.m_MediaFlagAspect);
        o_LiveShowMediaObjectDescription.setMediaFlagSize(this.m_MediaFlagSize);
        o_LiveShowMediaObjectDescription.setMediaFlagPosition(this.m_MediaFlagPosition);
        o_LiveShowMediaObjectDescription.setMediaAnchor(this.m_MediaAnchor);
        o_LiveShowMediaObjectDescription.setMediaSoundVolume(this.m_MediaSoundVolume);
        o_LiveShowMediaObjectDescription.setMediaSoundDelay(this.m_MediaSoundDelay);
        o_LiveShowMediaObjectDescription.setMediaFlipHorizontally(this.m_MediaFlip_Horizontally);
        o_LiveShowMediaObjectDescription.setMediaFlipVertically(this.m_MediaFlip_Vertically);
        o_LiveShowMediaObjectDescription.setMediaRotateValue(this.m_MediaRotateValue);
        o_LiveShowMediaObjectDescription.setMediaZOrder(this.m_MediaZOrder);
        return o_LiveShowMediaObjectDescription;
    }

    public boolean copyFrom(LiveShowObjectDescription p_LiveShowObjectDescription) {
        if (p_LiveShowObjectDescription == null) {
            return false;
        }
        boolean boolChanged = false;
        LiveShowMediaObjectDescription o_LiveShowMediaObjectDescription = (LiveShowMediaObjectDescription)p_LiveShowObjectDescription;
        boolChanged = super.copyFrom((LiveShowObjectDescription)o_LiveShowMediaObjectDescription);
        if (this.copyMediaObjectParamFrom(o_LiveShowMediaObjectDescription)) {
            boolChanged = true;
        }
        return boolChanged;
    }

    public boolean copyObjectParamsFrom(LiveShowObjectDescription p_LiveShowObjectDescription) {
        if (p_LiveShowObjectDescription == null) {
            return false;
        }
        boolean boolChanged = false;
        boolChanged = super.copyFrom(p_LiveShowObjectDescription);
        return boolChanged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean copyMediaObjectParamFrom(LiveShowMediaObjectDescription p_LiveShowMediaObjectDescription) {
        if (p_LiveShowMediaObjectDescription == null) {
            return false;
        }
        boolean boolChanged = false;
        if (this.setMediaType(p_LiveShowMediaObjectDescription.getMediaType())) {
            boolChanged = true;
        }
        if (this.setCheckSum(p_LiveShowMediaObjectDescription.getCheckSum())) {
            boolChanged = true;
        }
        if (this.setProducer(p_LiveShowMediaObjectDescription.getProducer())) {
            boolChanged = true;
        }
        if (!this.isEqualMediaServerIDs(p_LiveShowMediaObjectDescription)) {
            boolChanged = true;
            Object object = this.m_SyncMediaServers;
            synchronized (object) {
                this.clearMediaServerIDs();
                int intMediaServerCount = p_LiveShowMediaObjectDescription.getMediaServerIDCount();
                for (int intMediaServer = 0; intMediaServer < intMediaServerCount; ++intMediaServer) {
                    String stringMediaServerID = p_LiveShowMediaObjectDescription.getMediaServerID(intMediaServer);
                    String stringMediaServerURL = p_LiveShowMediaObjectDescription.getMediaServerURL(intMediaServer);
                    String stringMediaServerPort = p_LiveShowMediaObjectDescription.getMediaServerPort(intMediaServer);
                    this.addMediaServerID_Connection(stringMediaServerID, stringMediaServerURL, stringMediaServerPort);
                }
            }
        }
        if (this.setMediaRelativePositionSize(p_LiveShowMediaObjectDescription.getMediaRelativePositionSize())) {
            boolChanged = true;
        }
        if (this.setMediaFlagAspect(p_LiveShowMediaObjectDescription.getMediaFlagAspect())) {
            boolChanged = true;
        }
        if (this.setMediaFlagSize(p_LiveShowMediaObjectDescription.getMediaFlagSize())) {
            boolChanged = true;
        }
        if (this.setMediaFlagPosition(p_LiveShowMediaObjectDescription.getMediaFlagPosition())) {
            boolChanged = true;
        }
        if (this.setMediaAnchor(p_LiveShowMediaObjectDescription.getMediaAnchor())) {
            boolChanged = true;
        }
        if (this.setMediaSoundVolume(p_LiveShowMediaObjectDescription.getMediaSoundVolume())) {
            boolChanged = true;
        }
        if (this.setMediaSoundDelay(p_LiveShowMediaObjectDescription.getMediaSoundDelay())) {
            boolChanged = true;
        }
        if (this.setMediaFlipHorizontally(p_LiveShowMediaObjectDescription.getMediaFlipHorizontally())) {
            boolChanged = true;
        }
        if (this.setMediaFlipVertically(p_LiveShowMediaObjectDescription.getMediaFlipVertically())) {
            boolChanged = true;
        }
        if (this.setMediaRotateValue(p_LiveShowMediaObjectDescription.getMediaRotateValue())) {
            boolChanged = true;
        }
        if (this.setMediaZOrder(p_LiveShowMediaObjectDescription.getMediaZOrder())) {
            boolChanged = true;
        }
        return boolChanged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEqualMediaServerIDs(LiveShowMediaObjectDescription p_LiveShowMediaObjectDescription) {
        if (p_LiveShowMediaObjectDescription == null) {
            return false;
        }
        Object object = this.m_SyncMediaServers;
        synchronized (object) {
            int intMediaServerCount = this.m_MediaServerIDs.size();
            if (intMediaServerCount != p_LiveShowMediaObjectDescription.getMediaServerIDCount()) {
                return false;
            }
            for (int intMediaServer = 0; intMediaServer < intMediaServerCount; ++intMediaServer) {
                String stringMediaServerPort;
                String stringMediaServerURL;
                String stringMediaServerID = this.m_MediaServerIDs.get(intMediaServer);
                if (p_LiveShowMediaObjectDescription.containsMediaServerID(stringMediaServerID, stringMediaServerURL = this.m_MediaServerURLs.get(intMediaServer), stringMediaServerPort = this.m_MediaServerPorts.get(intMediaServer))) continue;
                return false;
            }
            return true;
        }
    }

    public boolean isEqual(LiveShowMediaObjectDescription p_LiveShowMediaObjectDescription) {
        if (p_LiveShowMediaObjectDescription == null) {
            return false;
        }
        if (!super.isEqual((LiveShowObjectDescription)p_LiveShowMediaObjectDescription)) {
            return false;
        }
        if (this.m_MediaType != p_LiveShowMediaObjectDescription.getMediaType()) {
            return false;
        }
        if (!this.m_CheckSum.equals(p_LiveShowMediaObjectDescription.getCheckSum())) {
            return false;
        }
        if (!this.m_Producer.equals(p_LiveShowMediaObjectDescription.getProducer())) {
            return false;
        }
        if (!this.isEqualMediaServerIDs(p_LiveShowMediaObjectDescription)) {
            return false;
        }
        if (!this.m_MediaRelativePositionSize.equals(p_LiveShowMediaObjectDescription.getMediaRelativePositionSize())) {
            return false;
        }
        if (this.m_MediaFlagAspect != p_LiveShowMediaObjectDescription.getMediaFlagAspect()) {
            return false;
        }
        if (this.m_MediaFlagSize != p_LiveShowMediaObjectDescription.getMediaFlagSize()) {
            return false;
        }
        if (this.m_MediaFlagPosition != p_LiveShowMediaObjectDescription.getMediaFlagPosition()) {
            return false;
        }
        if (this.m_MediaAnchor != p_LiveShowMediaObjectDescription.getMediaAnchor()) {
            return false;
        }
        if (this.m_MediaSoundVolume != p_LiveShowMediaObjectDescription.getMediaSoundVolume()) {
            return false;
        }
        if (this.m_MediaSoundDelay != p_LiveShowMediaObjectDescription.getMediaSoundDelay()) {
            return false;
        }
        if (this.m_MediaFlip_Horizontally != p_LiveShowMediaObjectDescription.getMediaFlipHorizontally()) {
            return false;
        }
        if (this.m_MediaFlip_Vertically != p_LiveShowMediaObjectDescription.getMediaFlipVertically()) {
            return false;
        }
        if (this.m_MediaRotateValue != p_LiveShowMediaObjectDescription.getMediaRotateValue()) {
            return false;
        }
        return this.m_MediaZOrder == p_LiveShowMediaObjectDescription.getMediaZOrder();
    }
}

