/*
 * Decompiled with CFR 0.152.
 */
package SocketMessagePackage;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class LiveDBMessageStreamInfo
implements Externalizable {
    private String m_StreamID;
    private String m_Remark;
    private int m_DataType;
    private long m_DataBytesCount;
    private int m_Priority;
    private boolean m_InternalHandled;
    static final long serialVersionUID = 7088769645491002016L;

    public LiveDBMessageStreamInfo() {
        this.initMembers();
    }

    public LiveDBMessageStreamInfo(String p_StreamID, int p_Priority, boolean p_InternalHandled, int p_DataType, long p_DataBytesCount, String p_Remark) {
        this.initMembers();
        this.m_StreamID = p_StreamID;
        this.m_Priority = p_Priority;
        this.m_InternalHandled = p_InternalHandled;
        this.m_DataType = p_DataType;
        this.m_DataBytesCount = p_DataBytesCount;
        this.m_Remark = p_Remark;
    }

    private void initMembers() {
        this.m_StreamID = "";
        this.m_DataType = 0;
        this.m_DataBytesCount = 0L;
        this.m_Priority = 0;
        this.m_Remark = null;
        this.m_InternalHandled = false;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int intSize = this.m_StreamID.length();
        out.writeInt(intSize);
        out.writeChars(this.m_StreamID);
        intSize = this.m_Remark.length();
        out.writeInt(intSize);
        out.writeChars(this.m_Remark);
        out.writeInt(this.m_DataType);
        out.writeLong(this.m_DataBytesCount);
        out.writeInt(this.m_Priority);
        out.writeBoolean(this.m_InternalHandled);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int intChar;
        int intSize = in.readInt();
        char[] charID = new char[intSize];
        for (intChar = 0; intChar < intSize; ++intChar) {
            charID[intChar] = in.readChar();
        }
        this.m_StreamID = new String(charID);
        intSize = in.readInt();
        charID = new char[intSize];
        for (intChar = 0; intChar < intSize; ++intChar) {
            charID[intChar] = in.readChar();
        }
        this.m_Remark = new String(charID);
        this.m_DataType = in.readInt();
        this.m_DataBytesCount = in.readLong();
        this.m_Priority = in.readInt();
        this.m_InternalHandled = in.readBoolean();
    }

    public String getStreamID() {
        return this.m_StreamID;
    }

    public String getRemark() {
        return this.m_Remark;
    }

    public int getDataType() {
        return this.m_DataType;
    }

    public long getDataBytesCount() {
        return this.m_DataBytesCount;
    }

    public int getPriority() {
        return this.m_Priority;
    }

    public boolean getInternalHandled() {
        return this.m_InternalHandled;
    }
}

