/*
 * Decompiled with CFR 0.152.
 */
package SocketMessagePackage;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class LiveDBMessageStreamConfirmation
implements Externalizable {
    private String m_StreamID;
    private long m_DataPosition;
    static final long serialVersionUID = -4994378942492039142L;

    public LiveDBMessageStreamConfirmation() {
        this.initMembers();
    }

    public LiveDBMessageStreamConfirmation(String p_StreamID, long p_DataPosition) {
        this.initMembers();
        this.m_StreamID = p_StreamID;
        this.m_DataPosition = p_DataPosition;
    }

    private void initMembers() {
        this.m_DataPosition = 0L;
    }

    public String getStreamID() {
        return this.m_StreamID;
    }

    public long getDataPosition() {
        return this.m_DataPosition;
    }

    public void setDataPosition(long p_DataPosition) {
        this.m_DataPosition = p_DataPosition;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.m_StreamID == null) {
            this.m_StreamID = "";
        }
        int intSize = this.m_StreamID.length();
        out.writeInt(intSize);
        out.writeChars(this.m_StreamID);
        out.writeLong(this.m_DataPosition);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int intSize = in.readInt();
        if (intSize > 0) {
            char[] charID = new char[intSize];
            for (int intChar = 0; intChar < intSize; ++intChar) {
                charID[intChar] = in.readChar();
            }
            this.m_StreamID = new String(charID);
        } else {
            this.m_StreamID = "";
        }
        this.m_DataPosition = in.readLong();
    }
}

