#!/bin/bash
#This script installs the liveSHOW software

#---- Declare path settings ----

SOURCE_APPFOLDER="LiveShow"
SOURCE_APPPATH=`dirname "$0"`

DEST_APPNAME="liveSHOW"
DEST_APPFOLDER="$SOURCE_APPFOLDER"
DEST_APPSPATH="$HOME/.local/share/liveSHOWApps"

#Path to applications menu
DEST_MENUPATH="$HOME/.local/share/applications"
#Path to Desktop
desktopVar=$(cat $HOME/.config/user-dirs.dirs | grep "XDG_DESKTOP_DIR")
DEST_DESKTOPPATH="${desktopVar[@]/XDG_DESKTOP_DIR='"$HOME'/$HOME}"
DEST_DESKTOPPATH="${DEST_DESKTOPPATH[@]/'"'/''}"
DEST_APP_LOCALPATH="$HOME/.LiveShow"
#Path to autostart
DEST_AUTOSTARTPATH="$HOME/.config/autostart"

mkdir "$DEST_AUTOSTARTPATH"

DESKTOP_FILE="$DEST_AUTOSTARTPATH/$DEST_APPNAME.desktop"
echo "create menu and desktop items .desktop file"

cat > $DESKTOP_FILE << EOM
[Desktop Entry]
Version=1.0
Name=$DEST_APPNAME
Comment=Start $DEST_APPNAME
Icon=$DEST_APPSPATH/$DEST_APPFOLDER/icon.png
Exec=bash -c "sleep 10 && '$DEST_APP_LOCALPATH/Run_LiveShow_Linux.sh'"
Type=Application
StartupNotify=false
Terminal=false
Categories=AudioVideo
EOM

#---- Copy desktop file to autostart ----

cp "$DESKTOP_FILE" "$DEST_AUTOSTARTPATH"

echo "$DEST_APPNAME autostart enabled"
