/*
 * Decompiled with CFR 0.152.
 */
package Tools;

import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.EventListener;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.MutableComboBoxModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class LiveShowListTools {

    public static class ListRenderer
    extends DefaultListCellRenderer {
        protected static final Border NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);
        protected static final Border SELECTED_BORDER = new LineBorder(Color.BLUE, 2, true);
        private String m_MethodName_GetStringValue;
        private String m_MethodName_GetIcon;
        private String m_MethodName_GetToolTipText;
        private String m_MethodName_GetForeground;
        private String m_MethodName_GetBackground;
        private String m_NUll_Text;
        private String m_NUll_ToolTipText;
        private Icon m_NUll_Icon;
        private Icon m_NUll_IconDisabled;
        private int m_NUll_HorizontalAlignment;
        private Color m_NULL_Background;
        private Color m_NULL_Foreground;
        private boolean m_NULL_Enabled;

        public ListRenderer() {
            this.initMembers();
        }

        public ListRenderer(String p_MethodName_GetStringValue, String p_MethodName_GetIcon) {
            this.initMembers();
            this.m_MethodName_GetStringValue = p_MethodName_GetStringValue;
            this.m_MethodName_GetIcon = p_MethodName_GetIcon;
        }

        public ListRenderer(String p_MethodName_GetStringValue, String p_MethodName_GetIcon, String p_MethodName_ToolTipText) {
            this.initMembers();
            this.m_MethodName_GetStringValue = p_MethodName_GetStringValue;
            this.m_MethodName_GetIcon = p_MethodName_GetIcon;
            this.m_MethodName_GetToolTipText = p_MethodName_ToolTipText;
        }

        private void initMembers() {
            this.m_MethodName_GetStringValue = "getName";
            this.m_MethodName_GetIcon = "getIcon";
            this.m_MethodName_GetToolTipText = "getDescription";
            this.m_MethodName_GetForeground = "getForeground";
            this.m_MethodName_GetBackground = "getBackground";
            this.setHorizontalAlignment(0);
            this.m_NUll_Icon = null;
            this.m_NUll_IconDisabled = null;
            this.m_NUll_Text = "---";
            this.m_NUll_ToolTipText = null;
            this.m_NUll_HorizontalAlignment = this.getHorizontalAlignment();
            this.m_NULL_Background = null;
            this.m_NULL_Foreground = null;
            this.m_NULL_Enabled = true;
        }

        public void setNullLabel(Icon p_Icon, Icon p_IconDisabled, String p_Text, String p_ToolTipText, int p_HorizontalAlignment, Color p_Background, Color p_Foreground) {
            this.m_NUll_Icon = p_Icon;
            this.m_NUll_IconDisabled = p_IconDisabled;
            this.m_NUll_Text = p_Text;
            this.m_NUll_ToolTipText = p_ToolTipText;
            this.m_NUll_HorizontalAlignment = p_HorizontalAlignment < 0 ? 10 : p_HorizontalAlignment;
            if (p_Background != null) {
                this.m_NULL_Background = p_Background;
            }
            if (p_Foreground != null) {
                this.m_NULL_Foreground = p_Foreground;
            }
        }

        public void setNullLabel_Enabled(boolean p_NullElementEnabled) {
            this.m_NULL_Enabled = p_NullElementEnabled;
        }

        @Override
        public void setHorizontalAlignment(int p_HorizontalAlignment) {
            super.setHorizontalAlignment(p_HorizontalAlignment);
        }

        private Border getNoFocusBorder() {
            return NO_FOCUS_BORDER;
        }

        private Border getSelectedBorder() {
            return SELECTED_BORDER;
        }

        public void setMethodeName_GetIcon(String p_GetIcon) {
            this.m_MethodName_GetIcon = p_GetIcon;
        }

        public Icon getIcon(Object p_Element) {
            if (p_Element == null) {
                if (this.m_NULL_Enabled) {
                    return this.m_NUll_Icon;
                }
                return this.m_NUll_IconDisabled;
            }
            if (this.m_MethodName_GetIcon == null) {
                return null;
            }
            Class<?> o_Class = p_Element.getClass();
            try {
                Method o_MethodGetName = o_Class.getMethod(this.m_MethodName_GetIcon, new Class[0]);
                if (o_MethodGetName == null) {
                    return null;
                }
                return (Icon)o_MethodGetName.invoke(p_Element, new Object[0]);
            }
            catch (Exception e) {
                return null;
            }
        }

        public String getStringValue(Object p_Element) {
            if (p_Element == null) {
                return this.m_NUll_Text;
            }
            if (this.m_MethodName_GetStringValue == null) {
                return "";
            }
            Class<?> o_Class = p_Element.getClass();
            try {
                Method o_MethodGetName = o_Class.getMethod(this.m_MethodName_GetStringValue, new Class[0]);
                if (o_MethodGetName == null) {
                    return null;
                }
                return (String)o_MethodGetName.invoke(p_Element, new Object[0]);
            }
            catch (Exception e) {
                return null;
            }
        }

        public String getStringToolTip(Object p_Element) {
            if (p_Element == null) {
                return this.m_NUll_ToolTipText;
            }
            if (this.m_MethodName_GetToolTipText == null) {
                return null;
            }
            Class<?> o_Class = p_Element.getClass();
            try {
                Method o_MethodGetName = o_Class.getMethod(this.m_MethodName_GetToolTipText, new Class[0]);
                if (o_MethodGetName == null) {
                    return null;
                }
                return (String)o_MethodGetName.invoke(p_Element, new Object[0]);
            }
            catch (Exception e) {
                return null;
            }
        }

        public Color getForeground(Object p_Element) {
            if (p_Element == null) {
                return this.m_NULL_Foreground;
            }
            if (this.m_MethodName_GetForeground == null) {
                return null;
            }
            Class<?> o_Class = p_Element.getClass();
            try {
                Method o_MethodGetName = o_Class.getMethod(this.m_MethodName_GetForeground, new Class[0]);
                if (o_MethodGetName == null) {
                    return null;
                }
                return (Color)o_MethodGetName.invoke(p_Element, new Object[0]);
            }
            catch (Exception e) {
                return null;
            }
        }

        public Color getBackground(Object p_Element) {
            if (p_Element == null) {
                return this.m_NULL_Background;
            }
            if (this.m_MethodName_GetBackground == null) {
                return null;
            }
            Class<?> o_Class = p_Element.getClass();
            try {
                Method o_MethodGetName = o_Class.getMethod(this.m_MethodName_GetBackground, new Class[0]);
                if (o_MethodGetName == null) {
                    return null;
                }
                return (Color)o_MethodGetName.invoke(p_Element, new Object[0]);
            }
            catch (Exception e) {
                return null;
            }
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setComponentOrientation(list.getComponentOrientation());
            Color o_Background = null;
            Color o_Foreground = null;
            Color o_ColorElement = this.getBackground(value);
            o_Background = o_ColorElement != null ? o_ColorElement : list.getBackground();
            o_ColorElement = this.getForeground(value);
            o_Foreground = o_ColorElement != null ? o_ColorElement : list.getForeground();
            if (isSelected) {
                if (list.hasFocus()) {
                    o_Background = UIManager.getColor("List.selectionBackground");
                    o_Foreground = UIManager.getColor("List.selectionForeground");
                } else {
                    o_Background = UIManager.getColor("List.selectionInactiveBackground");
                    o_Foreground = UIManager.getColor("List.selectionInactiveForeground");
                }
            }
            this.setForeground(o_Foreground);
            this.setBackground(o_Background);
            String stringName = this.getStringValue(value);
            if (stringName != null) {
                this.setText(stringName);
            } else {
                this.setText("");
            }
            this.setIcon(this.getIcon(value));
            this.setToolTipText(this.getStringToolTip(value));
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            return this;
        }
    }

    public static class ListModelWrapper<T>
    implements MutableComboBoxModel {
        private LiveShowListModel<T> m_ListModel;
        private T m_SelectedElement;
        protected EventListenerList m_ListenerList;

        public ListModelWrapper(LiveShowListModel<T> p_ListModel) {
            this.initMembers();
            this.m_ListModel = p_ListModel;
            this.m_ListModel.addListModelWrapper(this);
        }

        private void initMembers() {
            this.m_SelectedElement = null;
            this.m_ListenerList = new EventListenerList();
        }

        public void close() {
            if (this.m_ListModel != null) {
                this.m_ListModel.removeListModelWrapper(this);
            }
        }

        public boolean containsElement(T p_Element) {
            return this.m_ListModel.containsElement(p_Element);
        }

        public void addElement(Object p_Element) {
            this.m_ListModel.addElement(p_Element);
        }

        @Override
        public void removeElement(Object p_Element) {
            this.m_ListModel.removeElement(p_Element);
        }

        public void removeElementsAll() {
            this.m_ListModel.removeElementsAll();
        }

        @Override
        public int getSize() {
            return this.m_ListModel.getSize();
        }

        @Override
        public Object getElementAt(int index) {
            return this.m_ListModel.getElementAt(index);
        }

        public int getIndexOf(T anObject) {
            return this.m_ListModel.indexOf(anObject);
        }

        @Override
        public T getSelectedItem() {
            return this.m_SelectedElement;
        }

        @Override
        public void setSelectedItem(Object p_Element) {
            try {
                this.m_SelectedElement = p_Element;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void addListDataListener(ListDataListener l) {
            this.m_ListenerList.add(ListDataListener.class, l);
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
            this.m_ListenerList.remove(ListDataListener.class, l);
        }

        public ListDataListener[] getListDataListeners() {
            return (ListDataListener[])this.m_ListenerList.getListeners(ListDataListener.class);
        }

        public void fireContentsChanged(Object source, int index0, int index1) {
            Object[] listeners = this.m_ListenerList.getListenerList();
            ListDataEvent e = null;
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != ListDataListener.class) continue;
                if (e == null) {
                    e = new ListDataEvent(source, 0, index0, index1);
                }
                ((ListDataListener)listeners[i + 1]).contentsChanged(e);
            }
        }

        protected void fireIntervalAdded(Object source, int index0, int index1) {
            Object[] listeners = this.m_ListenerList.getListenerList();
            ListDataEvent e = null;
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != ListDataListener.class) continue;
                if (e == null) {
                    e = new ListDataEvent(source, 1, index0, index1);
                }
                ((ListDataListener)listeners[i + 1]).intervalAdded(e);
            }
        }

        protected void fireIntervalRemoved(Object source, int index0, int index1) {
            Object[] listeners = this.m_ListenerList.getListenerList();
            ListDataEvent e = null;
            boolean boolSelectedFound = false;
            for (int intElement = 0; intElement <= this.m_ListModel.getSize(); ++intElement) {
                T o_Element = this.m_ListModel.getElementAt(intElement);
                if (o_Element != this.m_SelectedElement) continue;
                boolSelectedFound = true;
                break;
            }
            if (!boolSelectedFound) {
                if (this.m_ListModel.getSize() <= 0) {
                    this.setSelectedItem(null);
                } else {
                    this.setSelectedItem(this.m_ListModel.getElementAt(0));
                }
            }
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != ListDataListener.class) continue;
                if (e == null) {
                    e = new ListDataEvent(source, 2, index0, index1);
                }
                ((ListDataListener)listeners[i + 1]).intervalRemoved(e);
            }
        }

        public <T extends EventListener> T[] getListeners(Class<T> listenerType) {
            return this.m_ListenerList.getListeners(listenerType);
        }

        public void insertElementAt(Object anObject, int index) {
            this.m_ListModel.insertElementAt(anObject, index);
            this.fireIntervalAdded(this, index, index);
        }

        @Override
        public void removeElementAt(int index) {
            if (this.getElementAt(index) == this.m_SelectedElement) {
                if (index == 0) {
                    this.setSelectedItem(this.getSize() == 1 ? null : this.getElementAt(index + 1));
                } else {
                    this.setSelectedItem(this.getElementAt(index - 1));
                }
            }
            this.m_ListModel.removeElementAt(index);
            this.fireIntervalRemoved(this, index, index);
        }
    }

    public static class LiveShowListModel<T>
    implements ComboBoxModel,
    PropertyChangeListener {
        ArrayList<T> m_Elements;
        T m_SelectedElement;
        ArrayList<ListModelWrapper<T>> m_ListModelWrappers;
        ArrayList<ListDataListener> m_ListDataListeners;

        public LiveShowListModel() {
            this.initMembers();
        }

        public LiveShowListModel(T p_FirstElement) {
            this.initMembers();
            this.addElement(p_FirstElement);
        }

        private void initMembers() {
            this.m_Elements = new ArrayList();
            this.m_ListModelWrappers = new ArrayList();
            this.m_SelectedElement = null;
            this.m_ListDataListeners = new ArrayList();
        }

        public void close() {
            for (int intListener = this.m_ListDataListeners.size() - 1; intListener >= 0; --intListener) {
                ListDataListener o_ListDataListener = this.m_ListDataListeners.get(intListener);
                this.m_ListDataListeners.remove(intListener);
            }
            for (int intWrapper = this.m_ListModelWrappers.size() - 1; intWrapper >= 0; --intWrapper) {
                ListModelWrapper<T> o_ListModelWrapper = this.m_ListModelWrappers.get(intWrapper);
                this.removeListModelWrapper(o_ListModelWrapper);
            }
            this.removeElementsAll();
        }

        public void addListModelWrapper(ListModelWrapper<T> p_ListModelWrapper) {
            if (p_ListModelWrapper == null) {
                return;
            }
            if (this.m_ListModelWrappers.contains(p_ListModelWrapper)) {
                return;
            }
            this.m_ListModelWrappers.add(p_ListModelWrapper);
        }

        public void removeListModelWrapper(ListModelWrapper p_ListModelWrapper) {
            if (p_ListModelWrapper == null) {
                return;
            }
            this.m_ListModelWrappers.remove(p_ListModelWrapper);
        }

        public int size() {
            return this.getSize();
        }

        @Override
        public int getSize() {
            return this.m_Elements.size();
        }

        public boolean contains(T p_Element) {
            return this.containsElement(p_Element);
        }

        public boolean containsElement(T p_Element) {
            return this.m_Elements.contains(p_Element);
        }

        public boolean add(T p_Element) {
            return this.addElement(p_Element);
        }

        public boolean addElement(Object p_Element) {
            Object o_Element;
            if (p_Element == null) {
                // empty if block
            }
            try {
                o_Element = p_Element != null ? p_Element : null;
            }
            catch (Exception e) {
                return false;
            }
            if (this.containsElement(o_Element)) {
                return true;
            }
            if (o_Element != null) {
                this.call_AddPropertyChangeListener(o_Element);
            }
            if (this.m_Elements.add(o_Element)) {
                int intIndex = this.m_Elements.indexOf(p_Element);
                this.fireIntervalAdded(this, intIndex, intIndex);
                return true;
            }
            return false;
        }

        public boolean add(int p_Index, T p_Element) {
            return this.insertElementAt(p_Element, p_Index);
        }

        public boolean insertElementAt(T anObject, int index) {
            try {
                this.m_Elements.add(index, anObject);
                this.fireIntervalAdded(this, index, index);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }

        public boolean remove(T p_Element) {
            return this.removeElement(p_Element);
        }

        public boolean removeElement(Object p_Element) {
            Object o_Element;
            if (p_Element == null) {
                // empty if block
            }
            try {
                o_Element = p_Element != null ? p_Element : null;
            }
            catch (Exception e) {
                return false;
            }
            int intIndex = this.m_Elements.indexOf(o_Element);
            if (intIndex < 0) {
                return false;
            }
            if (o_Element != null) {
                this.call_RemovePropertyChangeListener(o_Element);
            }
            this.m_Elements.remove(o_Element);
            this.fireIntervalRemoved(this, intIndex, intIndex);
            return true;
        }

        public void remove(int p_Index) {
            if (p_Index < 0 || p_Index >= this.m_Elements.size()) {
                return;
            }
            this.removeElementAt(p_Index);
        }

        public void removeElementAt(int index) {
            if (index < 0 || index >= this.m_Elements.size()) {
                return;
            }
            if (this.m_Elements.remove(index) != null) {
                this.fireIntervalRemoved(this, index, index);
            }
        }

        public void clear() {
            this.removeElementsAll();
        }

        public void removeElementsAll() {
            int intSize = this.getSize();
            for (int intElement = intSize - 1; intElement >= 0; --intElement) {
                this.removeElementAt(intElement);
            }
        }

        @Override
        public T getElementAt(int p_Index) {
            return this.get(p_Index);
        }

        public T get(int p_Index) {
            if (p_Index < 0 || p_Index >= this.m_Elements.size()) {
                return null;
            }
            return this.m_Elements.get(p_Index);
        }

        public ArrayList<T> getArrayList() {
            return this.m_Elements;
        }

        public int indexOf(T p_Element) {
            return this.m_Elements.indexOf(p_Element);
        }

        protected void call_AddPropertyChangeListener(Object p_Element) {
            if (p_Element == null) {
                return;
            }
            Method o_Method = null;
            try {
                o_Method = p_Element.getClass().getDeclaredMethod("addPropertyChangeListener", PropertyChangeListener.class);
                if (o_Method != null) {
                    o_Method.invoke(p_Element, this);
                }
            }
            catch (Exception e) {
                o_Method = null;
            }
        }

        protected void call_RemovePropertyChangeListener(Object p_Element) {
            if (p_Element == null) {
                return;
            }
            Method o_Method = null;
            try {
                o_Method = p_Element.getClass().getDeclaredMethod("removePropertyChangeListener", PropertyChangeListener.class);
                if (o_Method != null) {
                    o_Method.invoke(p_Element, this);
                }
            }
            catch (Exception e) {
                o_Method = null;
            }
        }

        public T[] toAray() {
            Object[] o_Array = new Object[this.getSize()];
            for (int intElement = 0; intElement < this.getSize(); ++intElement) {
                T o_Element = this.getElementAt(intElement);
                o_Array[intElement] = o_Element;
            }
            return o_Array;
        }

        public ArrayList<T> toArrayList() {
            return (ArrayList)this.m_Elements.clone();
        }

        public T getSelectedItem() {
            return this.m_SelectedElement;
        }

        public void fireContentsChanged(Object source, int index0, int index1) {
            ListDataEvent o_ListDataEvent = new ListDataEvent(this, 0, index0, index1);
            for (int intListener = 0; intListener < this.m_ListDataListeners.size(); ++intListener) {
                ListDataListener o_Listener = this.m_ListDataListeners.get(intListener);
                o_Listener.contentsChanged(o_ListDataEvent);
            }
            for (int intSingleModel = 0; intSingleModel < this.m_ListModelWrappers.size(); ++intSingleModel) {
                this.m_ListModelWrappers.get(intSingleModel).fireContentsChanged(source, index0, index1);
            }
        }

        protected void fireIntervalAdded(Object source, int index0, int index1) {
            ListDataEvent o_ListDataEvent = new ListDataEvent(this, 1, index0, index1);
            for (int intListener = 0; intListener < this.m_ListDataListeners.size(); ++intListener) {
                ListDataListener o_Listener = this.m_ListDataListeners.get(intListener);
                o_Listener.intervalAdded(o_ListDataEvent);
            }
            for (int intSingleModel = 0; intSingleModel < this.m_ListModelWrappers.size(); ++intSingleModel) {
                this.m_ListModelWrappers.get(intSingleModel).fireIntervalAdded(source, index0, index1);
            }
        }

        protected void fireIntervalRemoved(Object source, int index0, int index1) {
            ListDataEvent o_ListDataEvent = new ListDataEvent(this, 2, index0, index1);
            for (int intListener = 0; intListener < this.m_ListDataListeners.size(); ++intListener) {
                ListDataListener o_Listener = this.m_ListDataListeners.get(intListener);
                o_Listener.intervalRemoved(o_ListDataEvent);
            }
            for (int intSingleModel = 0; intSingleModel < this.m_ListModelWrappers.size(); ++intSingleModel) {
                this.m_ListModelWrappers.get(intSingleModel).fireIntervalRemoved(source, index0, index1);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            int intIndex = this.indexOf(evt.getSource());
            if (intIndex < 0) {
                return;
            }
            this.fireContentsChanged(this, intIndex, intIndex);
        }

        @Override
        public void setSelectedItem(Object anItem) {
            this.m_SelectedElement = anItem;
        }

        @Override
        public void addListDataListener(ListDataListener l) {
            if (l == null) {
                return;
            }
            if (this.m_ListDataListeners.contains(l)) {
                return;
            }
            this.m_ListDataListeners.add(l);
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
            this.m_ListDataListeners.remove(l);
        }
    }
}

