/*
 * Decompiled with CFR 0.152.
 */
package NetworkTools;

import NetworkTools.NetworkTool;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketTimeoutException;
import java.util.ArrayList;

public class UDP_Transport_Multicast {
    private static final int SOTIMEOUT = 1000;
    private MulticastSocket m_MulticastSocket;
    private final Object m_SyncSend = new Object();
    private int m_SOTimeout;
    private InetAddress m_LocalInetAddress;
    private int m_LocalPort;
    private InetSocketAddress m_LocalInetSocketAddress;
    private boolean m_IsListen;
    private Thread m_ThreadReceiver;
    private Runnable m_RunnableReceive;
    private DatagramPacket m_DatagramPacket_Received;
    private ArrayList<InetSocketAddress> m_JoinedGroups;
    private ArrayList<UDPGroupReceiver> m_UDPGroupReceivers;
    private ArrayList<UDPTransportListener> m_UDPTransportListeners;
    private final Object m_SyncListeners = new Object();
    private final Object m_SyncReceive = new Object();

    public UDP_Transport_Multicast() {
        this.initMembers();
    }

    public UDP_Transport_Multicast(InetAddress p_InetAddress, int p_Port) {
        this.initMembers();
        this.m_LocalInetAddress = p_InetAddress;
        this.m_LocalPort = p_Port;
    }

    private void initMembers() {
        this.m_LocalInetAddress = null;
        this.m_LocalPort = 0;
        this.m_IsListen = false;
        this.m_JoinedGroups = new ArrayList();
        this.m_UDPGroupReceivers = new ArrayList();
        this.m_UDPTransportListeners = new ArrayList();
        this.m_ThreadReceiver = null;
        this.m_SOTimeout = 1000;
        this.m_RunnableReceive = new Runnable(){

            @Override
            public void run() {
                UDP_Transport_Multicast.this.receive();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        MulticastSocket o_MulticastSocket;
        this.m_IsListen = false;
        this.leaveGroupsAll();
        Object object = this.m_SyncReceive;
        synchronized (object) {
            o_MulticastSocket = this.m_MulticastSocket;
        }
        if (o_MulticastSocket != null) {
            o_MulticastSocket.close();
        }
        this.fireEventClosed();
        object = this.m_SyncListeners;
        synchronized (object) {
            this.m_UDPTransportListeners.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean bind(InetAddress p_InetAddress, Integer p_Port) {
        boolean boolException = false;
        if (this.isBound()) {
            InetAddress boundInetAddress = this.m_MulticastSocket.getLocalAddress();
            int boundPort = this.m_MulticastSocket.getLocalPort();
            if (boundInetAddress != null && NetworkTool.isEqual(boundInetAddress, p_InetAddress) && boundPort == p_Port) {
                return true;
            }
            this.stopReceive();
            this.m_MulticastSocket.close();
            this.leaveGroupsAll();
        }
        Object object = this.m_SyncReceive;
        synchronized (object) {
            this.m_LocalInetAddress = p_InetAddress;
            this.m_LocalPort = p_Port == null ? 0 : (p_Port < 0 ? 0 : p_Port);
            try {
                if (this.m_LocalInetAddress == null) {
                    this.m_MulticastSocket = new MulticastSocket();
                } else {
                    this.m_LocalInetSocketAddress = new InetSocketAddress(this.m_LocalInetAddress, this.m_LocalPort);
                    this.m_MulticastSocket = new MulticastSocket(this.m_LocalInetSocketAddress);
                }
                boolException = false;
            }
            catch (Exception e) {
                boolException = true;
            }
        }
        if (!boolException) {
            this.fireEventBound();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBound() {
        MulticastSocket o_MulticastSocket;
        Object object = this.m_SyncReceive;
        synchronized (object) {
            o_MulticastSocket = this.m_MulticastSocket;
        }
        if (o_MulticastSocket == null) {
            return false;
        }
        return o_MulticastSocket.isBound();
    }

    public NetworkInterface getNetworkInterface() {
        if (!this.isBound()) {
            return null;
        }
        return NetworkTool.getNetworkInterface(this.m_LocalInetAddress);
    }

    public boolean joinGroup(InetAddress p_GroupInetAddress, int p_GroupPort) {
        InetSocketAddress o_InetSocketAddress = new InetSocketAddress(p_GroupInetAddress, p_GroupPort);
        return this.joinGroup(o_InetSocketAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean joinGroup(InetSocketAddress p_InetSocketAddress) {
        if (p_InetSocketAddress == null) {
            return false;
        }
        if (!this.isBound()) {
            return false;
        }
        InetAddress o_InetAddress = p_InetSocketAddress.getAddress();
        if (o_InetAddress == null) {
            return false;
        }
        if (!o_InetAddress.isMulticastAddress()) {
            return false;
        }
        UDPGroupReceiver o_UDPGroupReceiver = this.getUDPGroupReceiver(p_InetSocketAddress);
        if (o_UDPGroupReceiver != null) {
            return true;
        }
        try {
            NetworkInterface o_NetworkInterface = NetworkTool.getNetworkInterface(this.m_LocalInetAddress);
            if (o_NetworkInterface == null) {
                return false;
            }
            if (!o_NetworkInterface.supportsMulticast()) {
                return false;
            }
            o_UDPGroupReceiver = new UDPGroupReceiver(this, p_InetSocketAddress.getAddress(), p_InetSocketAddress.getPort());
            o_UDPGroupReceiver.bind();
            o_UDPGroupReceiver.startReceive();
            Object object = this.m_SyncReceive;
            synchronized (object) {
                this.m_UDPGroupReceivers.add(o_UDPGroupReceiver);
                this.m_JoinedGroups.add(o_UDPGroupReceiver.getInetSocketAddress());
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public UDPGroupReceiver getUDPGroupReceiver(InetAddress p_InetAddress, int p_Port) {
        InetSocketAddress o_InetSocketAddress = new InetSocketAddress(p_InetAddress, p_Port);
        return this.getUDPGroupReceiver(o_InetSocketAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UDPGroupReceiver getUDPGroupReceiver(InetSocketAddress p_InetSocketAddress) {
        if (p_InetSocketAddress == null) {
            return null;
        }
        Object object = this.m_SyncReceive;
        synchronized (object) {
            for (int intReceiver = 0; intReceiver < this.m_UDPGroupReceivers.size(); ++intReceiver) {
                UDPGroupReceiver o_UDPMulticastReceiver = this.m_UDPGroupReceivers.get(intReceiver);
                if (!NetworkTool.isEqual(p_InetSocketAddress, o_UDPMulticastReceiver.getInetSocketAddress())) continue;
                return o_UDPMulticastReceiver;
            }
        }
        return null;
    }

    public boolean leaveGroup(InetAddress p_InetAddress, int p_Port) {
        if (p_InetAddress == null) {
            return false;
        }
        InetSocketAddress o_InetSocketAddress = new InetSocketAddress(p_InetAddress, p_Port);
        return this.leaveGroup(o_InetSocketAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean leaveGroup(InetSocketAddress p_InetSocketAddress) {
        if (!this.isBound()) {
            return false;
        }
        if (p_InetSocketAddress == null) {
            return false;
        }
        UDPGroupReceiver o_UDPGroupReceiver = this.getUDPGroupReceiver(p_InetSocketAddress);
        if (o_UDPGroupReceiver == null) {
            return false;
        }
        try {
            Object object = this.m_SyncReceive;
            synchronized (object) {
                o_UDPGroupReceiver.close();
                this.m_UDPGroupReceivers.remove(o_UDPGroupReceiver);
                this.m_JoinedGroups.remove(o_UDPGroupReceiver.getInetSocketAddress());
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leaveGroupsAll() {
        ArrayList<UDPGroupReceiver> o_UDPGroupReceivers;
        Object object = this.m_SyncReceive;
        synchronized (object) {
            if (this.m_UDPGroupReceivers == null) {
                return;
            }
            if (this.m_UDPGroupReceivers.size() <= 0) {
                return;
            }
            o_UDPGroupReceivers = new ArrayList<UDPGroupReceiver>(this.m_UDPGroupReceivers.size());
            o_UDPGroupReceivers.addAll(this.m_UDPGroupReceivers);
        }
        for (int intReceiver = o_UDPGroupReceivers.size() - 1; intReceiver >= 0; --intReceiver) {
            UDPGroupReceiver o_UDPMulticastReceiver = (UDPGroupReceiver)o_UDPGroupReceivers.get(intReceiver);
            this.leaveGroup(o_UDPMulticastReceiver.getInetSocketAddress());
        }
        o_UDPGroupReceivers.clear();
    }

    public InetAddress getLocalInetAddress() {
        return this.m_LocalInetAddress;
    }

    public int getLocalPort() {
        return this.m_MulticastSocket.getLocalPort();
    }

    public InetSocketAddress getLocalInetSocketAddress() {
        return this.m_LocalInetSocketAddress;
    }

    public boolean send(byte[] p_Data, int p_Length, InetSocketAddress p_InetSocketAddress) {
        if (p_InetSocketAddress == null) {
            return false;
        }
        return this.send(p_Data, p_Length, p_InetSocketAddress.getAddress(), p_InetSocketAddress.getPort());
    }

    public boolean send(byte[] p_Data, int p_Length, InetAddress p_InetAddress, int p_Port) {
        if (p_Data == null) {
            return false;
        }
        if (p_InetAddress == null) {
            return false;
        }
        if (!this.isBound()) {
            return false;
        }
        if (p_Length > p_Data.length) {
            p_Length = p_Data.length;
        }
        DatagramPacket o_DatagramPacket = new DatagramPacket(p_Data, p_Length, p_InetAddress, p_Port);
        return this.send(o_DatagramPacket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean send(DatagramPacket p_DatagramPacket) {
        MulticastSocket o_MulticastSocket;
        if (p_DatagramPacket == null) {
            return false;
        }
        if (!this.isBound()) {
            return false;
        }
        Object object = this.m_SyncReceive;
        synchronized (object) {
            o_MulticastSocket = this.m_MulticastSocket;
        }
        try {
            if (o_MulticastSocket != null) {
                object = this.m_SyncSend;
                synchronized (object) {
                    o_MulticastSocket.send(p_DatagramPacket);
                }
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startReceive() {
        if (this.m_MulticastSocket == null) {
            return;
        }
        if (this.m_ThreadReceiver != null) {
            this.stopReceive();
        }
        Object object = this.m_SyncReceive;
        synchronized (object) {
            this.m_IsListen = true;
            this.m_ThreadReceiver = new Thread(this.m_RunnableReceive, this.getClass().getSimpleName() + "_startReceive");
            this.m_ThreadReceiver.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopReceive() {
        if (this.m_MulticastSocket == null) {
            return;
        }
        this.m_IsListen = false;
        Object object = this.m_SyncReceive;
        synchronized (object) {
            boolean bl = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setSOTimeout(int p_SOTimeout) {
        MulticastSocket o_MulticastSocket;
        if (p_SOTimeout <= 0) {
            return false;
        }
        Object object = this.m_SyncReceive;
        synchronized (object) {
            o_MulticastSocket = this.m_MulticastSocket;
        }
        if (o_MulticastSocket != null) {
            try {
                o_MulticastSocket.setSoTimeout(p_SOTimeout);
                this.m_SOTimeout = p_SOTimeout;
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public int getSOTimeout() {
        return this.m_SOTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receive() {
        if (!this.isBound()) {
            this.m_IsListen = false;
            return;
        }
        byte[] o_ByteArray = new byte[65535];
        this.m_DatagramPacket_Received = new DatagramPacket(o_ByteArray, o_ByteArray.length);
        this.setSOTimeout(this.m_SOTimeout);
        this.m_IsListen = true;
        while (this.m_IsListen) {
            try {
                Object object = this.m_SyncReceive;
                synchronized (object) {
                    this.m_MulticastSocket.receive(this.m_DatagramPacket_Received);
                    if (!this.m_IsListen) {
                        this.m_ThreadReceiver = null;
                    }
                }
                InetAddress o_InetAddress_Received = this.m_DatagramPacket_Received.getAddress();
                if (o_InetAddress_Received == null) continue;
                if (!o_InetAddress_Received.equals(this.m_LocalInetAddress) || this.getLocalPort() == this.m_DatagramPacket_Received.getPort()) {
                    // empty if block
                }
                this.fireEventDataReceived(this.m_DatagramPacket_Received, this.getLocalInetSocketAddress());
            }
            catch (Exception e) {
                if (!(e instanceof SocketTimeoutException)) continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireEventClosed() {
        ArrayList<UDPTransportListener> o_UDPTransportListeners;
        Object object = this.m_SyncListeners;
        synchronized (object) {
            if (this.m_UDPTransportListeners == null) {
                return;
            }
            if (this.m_UDPTransportListeners.size() <= 0) {
                return;
            }
            o_UDPTransportListeners = new ArrayList<UDPTransportListener>(this.m_UDPTransportListeners.size());
            o_UDPTransportListeners.addAll(this.m_UDPTransportListeners);
            this.m_UDPTransportListeners.clear();
        }
        for (int intListener = 0; intListener < o_UDPTransportListeners.size(); ++intListener) {
            UDPTransportListener o_UDPTransportListener = (UDPTransportListener)o_UDPTransportListeners.get(intListener);
            o_UDPTransportListener.eventClosed(this);
        }
        o_UDPTransportListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireEventBound() {
        ArrayList<UDPTransportListener> o_UDPTransportListeners;
        Object object = this.m_SyncListeners;
        synchronized (object) {
            if (this.m_UDPTransportListeners == null) {
                return;
            }
            if (this.m_UDPTransportListeners.size() <= 0) {
                return;
            }
            o_UDPTransportListeners = new ArrayList<UDPTransportListener>(this.m_UDPTransportListeners.size());
            o_UDPTransportListeners.addAll(this.m_UDPTransportListeners);
        }
        for (int intListener = 0; intListener < o_UDPTransportListeners.size(); ++intListener) {
            UDPTransportListener o_UDPTransportListener = (UDPTransportListener)o_UDPTransportListeners.get(intListener);
            o_UDPTransportListener.eventBound(this);
        }
        o_UDPTransportListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireEventDataReceived(DatagramPacket p_DatagramPacket, InetSocketAddress p_ReceiverSocketAddress) {
        ArrayList<UDPTransportListener> o_UDPTransportListeners;
        Object object = this.m_SyncListeners;
        synchronized (object) {
            if (this.m_UDPTransportListeners == null) {
                return;
            }
            if (this.m_UDPTransportListeners.size() <= 0) {
                return;
            }
            o_UDPTransportListeners = new ArrayList<UDPTransportListener>(this.m_UDPTransportListeners.size());
            o_UDPTransportListeners.addAll(this.m_UDPTransportListeners);
        }
        for (int intListener = 0; intListener < o_UDPTransportListeners.size(); ++intListener) {
            UDPTransportListener o_UDPTransportListener = (UDPTransportListener)o_UDPTransportListeners.get(intListener);
            o_UDPTransportListener.eventDataReceived(this, p_DatagramPacket, p_ReceiverSocketAddress);
        }
        o_UDPTransportListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addUDPTransportListener(UDPTransportListener p_UDPTransportListener) {
        if (p_UDPTransportListener == null) {
            return false;
        }
        Object object = this.m_SyncListeners;
        synchronized (object) {
            if (this.m_UDPTransportListeners.contains(p_UDPTransportListener)) {
                return true;
            }
            this.m_UDPTransportListeners.add(p_UDPTransportListener);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeUDPTransportListener(UDPTransportListener p_UDPTransportListener) {
        if (p_UDPTransportListener == null) {
            return false;
        }
        Object object = this.m_SyncListeners;
        synchronized (object) {
            if (!this.m_UDPTransportListeners.contains(p_UDPTransportListener)) {
                return false;
            }
            return this.m_UDPTransportListeners.remove(p_UDPTransportListener);
        }
    }

    public static class UDPGroupReceiver {
        private UDP_Transport_Multicast m_UDP_Transport;
        private InetAddress m_InetAddress_Remote;
        private int m_Port_Remote;
        private InetSocketAddress m_InetSocketAddress_Remote;
        private Thread m_ThreadReceiver;
        private Runnable m_RunnableReceive;
        private boolean m_IsListen;
        private DatagramPacket m_DatagramPacket_Received;
        private MulticastSocket m_MulticastSocket;
        private final Object m_SyncReceive = new Object();

        public UDPGroupReceiver(UDP_Transport_Multicast p_UDP_Transport, InetAddress p_RemoteInetAddress, int p_RemotePort) {
            this.initMembers();
            this.m_UDP_Transport = p_UDP_Transport;
            this.m_InetAddress_Remote = p_RemoteInetAddress;
            this.m_Port_Remote = p_RemotePort;
            this.m_InetSocketAddress_Remote = new InetSocketAddress(this.m_InetAddress_Remote, this.m_Port_Remote);
            try {
                this.m_MulticastSocket = new MulticastSocket(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void initMembers() {
            this.m_ThreadReceiver = null;
            this.m_RunnableReceive = new Runnable(){

                @Override
                public void run() {
                    this.receive();
                }
            };
        }

        public void close() {
            this.m_IsListen = false;
            MulticastSocket o_MulticastSocket = this.m_MulticastSocket;
            if (o_MulticastSocket != null) {
                try {
                    o_MulticastSocket.leaveGroup(this.m_InetAddress_Remote);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.stopReceive();
                o_MulticastSocket.close();
            }
        }

        public boolean bind() {
            this.m_InetSocketAddress_Remote = new InetSocketAddress(this.m_InetAddress_Remote, this.m_Port_Remote);
            InetSocketAddress o_LocalInetSocketAddress = new InetSocketAddress(this.m_UDP_Transport.getLocalInetAddress(), this.m_Port_Remote);
            try {
                this.m_MulticastSocket.bind(o_LocalInetSocketAddress);
                this.m_MulticastSocket.joinGroup(this.m_InetSocketAddress_Remote, this.m_UDP_Transport.getNetworkInterface());
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }

        public InetSocketAddress getInetSocketAddress() {
            return this.m_InetSocketAddress_Remote;
        }

        public boolean isBound() {
            if (this.m_MulticastSocket == null) {
                return false;
            }
            return this.m_MulticastSocket.isBound();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void startReceive() {
            if (this.m_MulticastSocket == null) {
                return;
            }
            if (this.m_ThreadReceiver != null) {
                this.stopReceive();
            }
            Object object = this.m_SyncReceive;
            synchronized (object) {
                this.m_IsListen = true;
                try {
                    this.m_ThreadReceiver = new Thread(this.m_RunnableReceive, this.getClass().getSimpleName() + "_startReceive");
                    this.m_ThreadReceiver.start();
                }
                catch (Exception e) {
                    System.err.println("UDP_Transport_Multicast UDPGroupReceiver startReceive error: " + e.getStackTrace());
                }
            }
        }

        public void stopReceive() {
            if (this.m_MulticastSocket == null) {
                return;
            }
            this.m_IsListen = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void receive() {
            if (this.m_MulticastSocket == null) {
                return;
            }
            byte[] o_ByteArray = new byte[65535];
            this.m_DatagramPacket_Received = new DatagramPacket(o_ByteArray, o_ByteArray.length);
            try {
                this.m_MulticastSocket.setSoTimeout(this.m_UDP_Transport.getSOTimeout());
            }
            catch (Exception exception) {
                // empty catch block
            }
            while (this.m_IsListen) {
                try {
                    Object object = this.m_SyncReceive;
                    synchronized (object) {
                        this.m_MulticastSocket.receive(this.m_DatagramPacket_Received);
                        if (!this.m_IsListen) {
                            this.m_ThreadReceiver = null;
                        }
                    }
                    InetAddress o_InetAddress_Received = this.m_DatagramPacket_Received.getAddress();
                    if (o_InetAddress_Received == null || o_InetAddress_Received.equals(this.m_UDP_Transport.getLocalInetAddress()) && (this.m_MulticastSocket.getLocalPort() == this.m_DatagramPacket_Received.getPort() || this.m_UDP_Transport.getLocalPort() == this.m_DatagramPacket_Received.getPort())) continue;
                    this.m_UDP_Transport.fireEventDataReceived(this.m_DatagramPacket_Received, this.getInetSocketAddress());
                }
                catch (Exception e) {
                    if (!(e instanceof SocketTimeoutException)) continue;
                }
            }
        }
    }

    public static interface UDPTransportListener {
        public void eventDataReceived(UDP_Transport_Multicast var1, DatagramPacket var2, InetSocketAddress var3);

        public void eventClosed(UDP_Transport_Multicast var1);

        public void eventBound(UDP_Transport_Multicast var1);

        public void eventError(UDP_Transport_Multicast var1, Exception var2);
    }
}

