/*
 * Decompiled with CFR 0.152.
 */
package NetworkTools;

import SwingModelPackage.TableAndListModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;

public class NetworkTool {
    public static TableAndListModel.ListModel<NetworkInterface> s_NetworkInterfaces = new TableAndListModel.ListModel(false);
    public static ListCellRenderer s_NetworkInterfaces_CellRenderer;
    public static boolean s_NetworkChecked;
    public static final Object s_SyncNetwork;
    public static boolean s_PreferIP4IsSet;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TableAndListModel.ListModel<NetworkInterface> getNetworkInterfaces() {
        Object object = s_SyncNetwork;
        synchronized (object) {
            s_NetworkChecked = false;
            s_NetworkInterfaces.clear();
            try {
                Enumeration<NetworkInterface> enumNetworkInterfaces = NetworkInterface.getNetworkInterfaces();
                while (enumNetworkInterfaces.hasMoreElements()) {
                    NetworkInterface o_NetworkInterface = enumNetworkInterfaces.nextElement();
                    if (o_NetworkInterface != null) {
                        if (!o_NetworkInterface.isUp()) continue;
                        Enumeration<InetAddress> addresses = o_NetworkInterface.getInetAddresses();
                        for (InetAddress o_InetAddressTry : Collections.list(addresses)) {
                            if (o_InetAddressTry == null || o_InetAddressTry.isLoopbackAddress() || o_InetAddressTry instanceof Inet6Address) continue;
                            s_NetworkInterfaces.add((Object)o_NetworkInterface);
                        }
                        continue;
                    }
                    boolean bl = false;
                }
                s_NetworkChecked = true;
                return s_NetworkInterfaces;
            }
            catch (Exception exception) {
                return s_NetworkInterfaces;
            }
        }
    }

    public static ListCellRenderer getNetworkInterfaces_CellRenderer() {
        if (s_NetworkInterfaces_CellRenderer == null) {
            s_NetworkInterfaces_CellRenderer = new NetworkList_CellRenderer();
        }
        return s_NetworkInterfaces_CellRenderer;
    }

    public static ArrayList<NetworkInterface> getSubNetworkInterfaces(NetworkInterface p_NetworkInterface, ArrayList<NetworkInterface> p_ArrayList) {
        ArrayList<NetworkInterface> o_ArrayListNetworkInterfaces;
        if (p_ArrayList != null) {
            p_ArrayList.clear();
            o_ArrayListNetworkInterfaces = p_ArrayList;
        } else {
            o_ArrayListNetworkInterfaces = new ArrayList();
        }
        if (p_NetworkInterface == null) {
            return o_ArrayListNetworkInterfaces;
        }
        try {
            Enumeration<NetworkInterface> enumNetworkInterfaces = p_NetworkInterface.getSubInterfaces();
            while (enumNetworkInterfaces.hasMoreElements()) {
                NetworkInterface o_SubNetworkInterface = enumNetworkInterfaces.nextElement();
                if (o_SubNetworkInterface == null) continue;
                o_ArrayListNetworkInterfaces.add(o_SubNetworkInterface);
            }
        }
        catch (Exception e) {
            return o_ArrayListNetworkInterfaces;
        }
        return o_ArrayListNetworkInterfaces;
    }

    public static NetworkInterface getNetworkInterface(InetSocketAddress p_InetSocketAddress) {
        if (p_InetSocketAddress == null) {
            return null;
        }
        InetAddress o_InetAddress = p_InetSocketAddress.getAddress();
        if (o_InetAddress == null) {
            return null;
        }
        try {
            return NetworkInterface.getByInetAddress(o_InetAddress);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static NetworkInterface getNetworkInterface(InetAddress p_InetAddress) {
        if (p_InetAddress == null) {
            return null;
        }
        try {
            return NetworkInterface.getByInetAddress(p_InetAddress);
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean isVirtual(NetworkInterface p_NetworkInterface) {
        if (p_NetworkInterface == null) {
            return true;
        }
        return p_NetworkInterface.isVirtual();
    }

    public boolean supportsMulticast(NetworkInterface p_NetworkInterface) {
        if (p_NetworkInterface == null) {
            return false;
        }
        try {
            return p_NetworkInterface.supportsMulticast();
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isLoopback(NetworkInterface p_NetworkInterface) {
        if (p_NetworkInterface == null) {
            return false;
        }
        try {
            return p_NetworkInterface.isLoopback();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static List<InterfaceAddress> getInterfaceAddresses(NetworkInterface p_NetworkInterface) {
        if (p_NetworkInterface == null) {
            return null;
        }
        if (!s_PreferIP4IsSet) {
            System.setProperty("java.net.preferIPv4Stack", "true");
            s_PreferIP4IsSet = true;
        }
        return p_NetworkInterface.getInterfaceAddresses();
    }

    public static String cleanIPAddress(String p_IPAddress) {
        if (p_IPAddress == null) {
            return null;
        }
        if (p_IPAddress.length() <= 0) {
            return p_IPAddress;
        }
        String stringCleanIPAddress = p_IPAddress;
        while (stringCleanIPAddress.startsWith("/")) {
            stringCleanIPAddress = stringCleanIPAddress.substring(1);
        }
        while (stringCleanIPAddress.endsWith("/")) {
            stringCleanIPAddress = stringCleanIPAddress.substring(0, stringCleanIPAddress.length() - 1);
        }
        return stringCleanIPAddress;
    }

    public static InetAddress getInetAddressFirst(NetworkInterface p_NetworkInterface) {
        if (p_NetworkInterface == null) {
            return null;
        }
        InetAddress o_InetAddress = null;
        List<InterfaceAddress> o_InterfaceAddresses = NetworkTool.getInterfaceAddresses(p_NetworkInterface);
        if (o_InterfaceAddresses.size() > 0) {
            o_InetAddress = o_InterfaceAddresses.get(0).getAddress();
        }
        return o_InetAddress;
    }

    public static InterfaceAddress getInterfaceAddress(NetworkInterface p_NetworkInterface, InetAddress p_InetAddress) {
        if (p_NetworkInterface == null) {
            return null;
        }
        if (p_InetAddress == null) {
            return null;
        }
        InetAddress o_InetAddress = null;
        List<InterfaceAddress> o_InterfaceAddresses = NetworkTool.getInterfaceAddresses(p_NetworkInterface);
        if (o_InterfaceAddresses == null) {
            return null;
        }
        for (int intAddress = 0; intAddress < o_InterfaceAddresses.size(); ++intAddress) {
            InterfaceAddress o_InterfaceAddress = o_InterfaceAddresses.get(intAddress);
            if (o_InterfaceAddress == null || !p_InetAddress.equals(o_InetAddress = o_InterfaceAddress.getAddress())) continue;
            return o_InterfaceAddress;
        }
        return null;
    }

    public static InetAddress getInet4AddressFirst(NetworkInterface p_NetworkInterface) {
        if (p_NetworkInterface == null) {
            return null;
        }
        InetAddress o_InetAddress = null;
        List<InterfaceAddress> o_InterfaceAddresses = NetworkTool.getInterfaceAddresses(p_NetworkInterface);
        if (o_InterfaceAddresses == null) {
            return null;
        }
        for (int intAddress = 0; intAddress < o_InterfaceAddresses.size(); ++intAddress) {
            InterfaceAddress o_InterfaceAddress = o_InterfaceAddresses.get(intAddress);
            if (o_InterfaceAddress == null) continue;
            o_InetAddress = o_InterfaceAddress.getAddress();
            if (o_InetAddress instanceof Inet4Address) break;
            o_InetAddress = null;
        }
        return o_InetAddress;
    }

    public static InetAddress getInet6AddressFirst(NetworkInterface p_NetworkInterface) {
        if (p_NetworkInterface == null) {
            return null;
        }
        InetAddress o_InetAddress = null;
        List<InterfaceAddress> o_InterfaceAddresses = NetworkTool.getInterfaceAddresses(p_NetworkInterface);
        if (o_InterfaceAddresses == null) {
            return null;
        }
        for (int intAddress = 0; intAddress < o_InterfaceAddresses.size(); ++intAddress) {
            InterfaceAddress o_InterfaceAddress = o_InterfaceAddresses.get(intAddress);
            if (o_InterfaceAddress == null) continue;
            o_InetAddress = o_InterfaceAddress.getAddress();
            if (o_InetAddress instanceof Inet6Address) break;
            o_InetAddress = null;
        }
        return o_InetAddress;
    }

    public static InetAddress getInetAddressBroadcast(InetAddress p_InetAddress) {
        NetworkInterface o_NetworkInterface = NetworkTool.getNetworkInterface(p_InetAddress);
        return NetworkTool.getInetAddressBroadcast(o_NetworkInterface, p_InetAddress);
    }

    public static InetAddress getInetAddressBroadcast(NetworkInterface p_NetworkInterface, InetAddress p_InetAddress) {
        if (p_NetworkInterface == null) {
            return null;
        }
        InetAddress o_InetAddressBroadcast = null;
        try {
            if (p_NetworkInterface.isLoopback()) {
                List<InterfaceAddress> o_InterfaceAddresses = NetworkTool.getInterfaceAddresses(p_NetworkInterface);
                if (o_InterfaceAddresses.size() <= 0) {
                    return null;
                }
                return o_InterfaceAddresses.get(0).getAddress();
            }
        }
        catch (Exception e) {
            return null;
        }
        for (InterfaceAddress interfaceAddress : NetworkTool.getInterfaceAddresses(p_NetworkInterface)) {
            if (interfaceAddress == null) continue;
            if (p_InetAddress != null) {
                InetAddress o_InetAddress = interfaceAddress.getAddress();
                if (o_InetAddress == null) continue;
                if (!p_InetAddress.getHostAddress().equals(o_InetAddress.getHostAddress())) break;
                o_InetAddressBroadcast = interfaceAddress.getBroadcast();
                break;
            }
            o_InetAddressBroadcast = interfaceAddress.getBroadcast();
            if (o_InetAddressBroadcast == null) continue;
        }
        if (o_InetAddressBroadcast == null) {
            try {
                o_InetAddressBroadcast = InetAddress.getByName("ff02::1");
            }
            catch (Exception e) {
                o_InetAddressBroadcast = null;
            }
        }
        return o_InetAddressBroadcast;
    }

    public static ArrayList<InetAddress> getInetAddresses(NetworkInterface p_NetworkInterface, ArrayList<InetAddress> p_ArrayList) {
        ArrayList<InetAddress> o_ArrayListInetAddresses;
        if (p_ArrayList != null) {
            p_ArrayList.clear();
            o_ArrayListInetAddresses = p_ArrayList;
        } else {
            o_ArrayListInetAddresses = new ArrayList();
        }
        if (p_NetworkInterface == null) {
            return o_ArrayListInetAddresses;
        }
        try {
            Enumeration<InetAddress> enumInetAddresses = p_NetworkInterface.getInetAddresses();
            while (enumInetAddresses.hasMoreElements()) {
                InetAddress o_InetAddress = enumInetAddresses.nextElement();
                if (o_InetAddress == null) continue;
                o_ArrayListInetAddresses.add(o_InetAddress);
            }
        }
        catch (Exception e) {
            return o_ArrayListInetAddresses;
        }
        return o_ArrayListInetAddresses;
    }

    public static ArrayList<InetAddress> getInetAddressesAll(ArrayList<InetAddress> p_ArrayList) {
        return NetworkTool.getInetAddressesAll(p_ArrayList, true, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<InetAddress> getInetAddressesAll(ArrayList<InetAddress> p_ArrayList, boolean p_ContainVirtual, boolean p_ContainLoopback, boolean p_OnlyMulticast) {
        ArrayList<InetAddress> o_ArrayListInetAddresses;
        if (p_ArrayList != null) {
            p_ArrayList.clear();
            o_ArrayListInetAddresses = p_ArrayList;
        } else {
            o_ArrayListInetAddresses = new ArrayList();
        }
        if (!s_NetworkChecked) {
            NetworkTool.getNetworkInterfaces();
        }
        Object object = s_SyncNetwork;
        synchronized (object) {
            ArrayList<InetAddress> o_ArrayListInetAddresses_Interface = new ArrayList<InetAddress>();
            for (int intInterface = 0; intInterface < s_NetworkInterfaces.size(); ++intInterface) {
                NetworkInterface o_NetworkInterface = (NetworkInterface)s_NetworkInterfaces.get(intInterface);
                if (!p_ContainVirtual && o_NetworkInterface.isVirtual()) continue;
                if (!p_ContainLoopback) {
                    try {
                        if (o_NetworkInterface.isLoopback()) {
                        }
                    }
                    catch (Exception e) {}
                    continue;
                }
                if (p_OnlyMulticast) {
                    try {
                        if (!o_NetworkInterface.supportsMulticast()) {
                        }
                    }
                    catch (Exception e) {}
                    continue;
                }
                o_ArrayListInetAddresses_Interface = NetworkTool.getInetAddresses(o_NetworkInterface, o_ArrayListInetAddresses_Interface);
                for (int intAddress = 0; intAddress < o_ArrayListInetAddresses_Interface.size(); ++intAddress) {
                    InetAddress o_InetAddress = o_ArrayListInetAddresses_Interface.get(intAddress);
                    if (NetworkTool.contains(o_ArrayListInetAddresses, o_InetAddress)) continue;
                    o_ArrayListInetAddresses.add(o_ArrayListInetAddresses_Interface.get(intAddress));
                }
            }
        }
        return o_ArrayListInetAddresses;
    }

    public static boolean contains(ArrayList<InetAddress> p_InetAddresses, InetAddress p_InetAddress) {
        for (int intAddress = 0; intAddress < p_InetAddresses.size(); ++intAddress) {
            InetAddress o_InetAddress = p_InetAddresses.get(intAddress);
            if (!(o_InetAddress != null ? NetworkTool.isEqual(o_InetAddress, p_InetAddress) : p_InetAddress == null)) continue;
            return true;
        }
        return false;
    }

    public static byte[] detectSubNetMaskIP4(InetAddress p_InetAddress) {
        NetworkInterface o_NetworkInterface;
        if (p_InetAddress == null) {
            return null;
        }
        if (!(p_InetAddress instanceof Inet4Address)) {
            return null;
        }
        InterfaceAddress o_InterfaceAddress = null;
        InetAddress o_InetAddress = null;
        byte[] o_SubNetBytes = new byte[4];
        try {
            o_NetworkInterface = NetworkInterface.getByInetAddress(p_InetAddress);
        }
        catch (Exception e) {
            o_NetworkInterface = null;
        }
        if (o_NetworkInterface == null) {
            return null;
        }
        List<InterfaceAddress> o_InterfaceAddresses = o_NetworkInterface.getInterfaceAddresses();
        for (int intAddress = 0; intAddress < o_InterfaceAddresses.size(); ++intAddress) {
            o_InterfaceAddress = o_InterfaceAddresses.get(intAddress);
            if (o_InterfaceAddress == null || (o_InetAddress = o_InterfaceAddress.getAddress()) == null) continue;
            if (o_InetAddress.getHostAddress().equals(p_InetAddress.getHostAddress())) break;
            o_InetAddress = null;
        }
        if (o_InetAddress == null || o_InterfaceAddress == null) {
            return null;
        }
        return NetworkTool.detectSubNetMaskIP4(o_InterfaceAddress);
    }

    public static byte[] detectSubNetMaskIP4(InterfaceAddress p_InterfaceAddress) {
        if (p_InterfaceAddress == null) {
            return null;
        }
        byte[] o_SubNetBytes = new byte[4];
        short shortPrefixLength = p_InterfaceAddress.getNetworkPrefixLength();
        if (p_InterfaceAddress.getAddress() instanceof Inet4Address) {
            short prflen = p_InterfaceAddress.getNetworkPrefixLength();
            int shft = -1 << 32 - prflen;
            o_SubNetBytes[0] = (byte)((shft & 0xFF000000) >> 24);
            o_SubNetBytes[1] = (byte)((shft & 0xFF0000) >> 16);
            o_SubNetBytes[2] = (byte)((shft & 0xFF00) >> 8);
            o_SubNetBytes[3] = (byte)(shft & 0xFF);
            return o_SubNetBytes;
        }
        return null;
    }

    public static String detectSubNetMask_String(InetAddress p_InetAddress) {
        NetworkInterface o_NetworkInterface;
        if (p_InetAddress == null) {
            return "";
        }
        InterfaceAddress o_InterfaceAddress = null;
        InetAddress o_InetAddress = null;
        String stringSubNetMask = "";
        try {
            o_NetworkInterface = NetworkInterface.getByInetAddress(p_InetAddress);
        }
        catch (Exception e) {
            o_NetworkInterface = null;
        }
        if (o_NetworkInterface == null) {
            return "";
        }
        List<InterfaceAddress> o_InterfaceAddresses = o_NetworkInterface.getInterfaceAddresses();
        for (int intAddress = 0; intAddress < o_InterfaceAddresses.size(); ++intAddress) {
            o_InterfaceAddress = o_InterfaceAddresses.get(intAddress);
            if (o_InterfaceAddress == null || (o_InetAddress = o_InterfaceAddress.getAddress()) == null) continue;
            if (o_InetAddress.getHostAddress().equals(p_InetAddress.getHostAddress())) break;
            o_InetAddress = null;
        }
        if (o_InetAddress == null || o_InterfaceAddress == null) {
            return "";
        }
        short shortPrefixLength = o_InterfaceAddress.getNetworkPrefixLength();
        if (o_InetAddress instanceof Inet4Address) {
            short prflen = o_InterfaceAddress.getNetworkPrefixLength();
            int shft = -1 << 32 - prflen;
            int oct1 = (byte)((shft & 0xFF000000) >> 24) & 0xFF;
            int oct2 = (byte)((shft & 0xFF0000) >> 16) & 0xFF;
            int oct3 = (byte)((shft & 0xFF00) >> 8) & 0xFF;
            int oct4 = (byte)(shft & 0xFF) & 0xFF;
            stringSubNetMask = oct1 + "." + oct2 + "." + oct3 + "." + oct4;
        } else if (o_InetAddress instanceof Inet6Address) {
            stringSubNetMask = "/" + String.valueOf(shortPrefixLength);
        }
        return stringSubNetMask;
    }

    public static boolean isSameIP4AddressRange(byte[] p_Subnet, byte[] p_IPAddress1, byte[] p_IPAddress2) {
        if (p_Subnet == null || p_Subnet.length != 4) {
            return false;
        }
        if (p_IPAddress1 == null || p_IPAddress1.length != 4) {
            return false;
        }
        if (p_IPAddress2 == null || p_IPAddress2.length != 4) {
            return false;
        }
        for (int intByte = 0; intByte < 4; ++intByte) {
            if ((p_Subnet[intByte] & 0xFF) <= 0 || (p_IPAddress1[intByte] & p_Subnet[intByte]) == (p_IPAddress2[intByte] & p_Subnet[intByte])) continue;
            return false;
        }
        return true;
    }

    public static boolean isEqual(InetAddress p_InetAddress1, InetAddress p_InetAddress2) {
        if (p_InetAddress1 == null) {
            return p_InetAddress2 == null;
        }
        if (p_InetAddress2 == null) {
            return false;
        }
        return p_InetAddress1.hashCode() == p_InetAddress2.hashCode();
    }

    public static boolean isEqual(InetSocketAddress p_SocketAddress1, InetSocketAddress p_SocketAddress2) {
        if (p_SocketAddress1 == null) {
            if (p_SocketAddress2 == null) {
                return true;
            }
        } else {
            if (p_SocketAddress2 == null) {
                return false;
            }
            if (!NetworkTool.isEqual(p_SocketAddress1.getAddress(), p_SocketAddress2.getAddress())) {
                return false;
            }
            if (p_SocketAddress1.getPort() != p_SocketAddress2.getPort()) {
                return false;
            }
        }
        return true;
    }

    static {
        s_NetworkChecked = false;
        s_SyncNetwork = new Object();
        s_PreferIP4IsSet = false;
    }

    public static class NetworkList_CellRenderer
    extends JLabel
    implements ListCellRenderer<NetworkInterface> {
        public static Dimension LABEL_DIMENSION = new Dimension(100, 32);

        @Override
        public Component getListCellRendererComponent(JList<? extends NetworkInterface> list, NetworkInterface value, int index, boolean isSelected, boolean cellHasFocus) {
            Color o_Background = null;
            Color o_Foreground = null;
            o_Background = list.getBackground();
            o_Foreground = list.getForeground();
            if (isSelected) {
                if (list.hasFocus()) {
                    o_Background = UIManager.getColor("List.selectionBackground");
                    o_Foreground = UIManager.getColor("List.selectionForeground");
                } else {
                    o_Background = UIManager.getColor("List.selectionInactiveBackground");
                    o_Foreground = UIManager.getColor("List.selectionInactiveForeground");
                }
            }
            this.setForeground(o_Foreground);
            this.setBackground(o_Background);
            this.setHorizontalAlignment(0);
            this.setPreferredSize(LABEL_DIMENSION);
            if (value == null) {
                this.setText("?");
            } else {
                this.setText(value.getName() + " " + value.getDisplayName());
            }
            return this;
        }
    }
}

