/*
 * Decompiled with CFR 0.152.
 */
package NetworkTools;

import NetworkTools.NetworkTool;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketTimeoutException;
import java.util.ArrayList;

public class UDP_Transport_Broadcast {
    private static final int SOTIMEOUT = 1000;
    private DatagramSocket m_DatagramSocket;
    private DatagramSocket m_DatagramSocket_Receiver_Broadcast;
    private final Object m_SyncSend = new Object();
    private int m_SOTimeout;
    private NetworkInterface m_NetworkInterface;
    private InterfaceAddress m_LocalInterfaceAddress;
    private InetAddress m_LocalInetAddress;
    private InetAddress m_LocalInetAddress_Broadcast;
    private int m_LocalPort;
    private InetSocketAddress m_LocalInetSocketAddress;
    private InetSocketAddress m_LocalInetSocketAddress_Broadcast;
    private boolean m_IsListen;
    private Thread m_ThreadReceiver_Broadcast;
    private Runnable m_RunnableReceive_Broadcast;
    private Thread m_ThreadReceiver_Local;
    private Runnable m_RunnableReceive_local;
    private DatagramPacket m_DatagramPacket_Received_Broadcast;
    private DatagramPacket m_DatagramPacket_Received_Local;
    private ArrayList<UDPTransportListener> m_UDPTransportListeners;
    private final Object m_SyncListeners = new Object();
    private final Object m_SyncReceive_Broadcast = new Object();
    private final Object m_SyncReceive_Local = new Object();

    public UDP_Transport_Broadcast() {
        this.initMembers();
    }

    private void initMembers() {
        this.m_LocalInterfaceAddress = null;
        this.m_LocalInetAddress = null;
        this.m_LocalInetAddress_Broadcast = null;
        this.m_LocalPort = 0;
        this.m_IsListen = false;
        this.m_UDPTransportListeners = new ArrayList();
        this.m_ThreadReceiver_Broadcast = null;
        this.m_SOTimeout = 1000;
        this.m_RunnableReceive_Broadcast = new Runnable(){

            @Override
            public void run() {
                UDP_Transport_Broadcast.this.receive_Broadcast();
            }
        };
        this.m_RunnableReceive_local = new Runnable(){

            @Override
            public void run() {
                UDP_Transport_Broadcast.this.receive_Local();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.stopReceive();
        this.m_IsListen = false;
        DatagramSocket o_DatagramSocket = this.m_DatagramSocket;
        if (o_DatagramSocket != null) {
            o_DatagramSocket.close();
        }
        if (this.m_DatagramSocket != this.m_DatagramSocket_Receiver_Broadcast && (o_DatagramSocket = this.m_DatagramSocket_Receiver_Broadcast) != null) {
            o_DatagramSocket.close();
        }
        this.fireEventClosed();
        Object object = this.m_SyncListeners;
        synchronized (object) {
            this.m_UDPTransportListeners.clear();
        }
    }

    public boolean bind(NetworkInterface p_NetworkInterface, InterfaceAddress p_InterfaceAddress, InetAddress p_InetAddress, InetAddress p_InetAddress_Broadcast, Integer p_Port) {
        if (this.isBound()) {
            this.stopReceive();
            if (this.m_DatagramSocket != null) {
                InetAddress boundInetAddress = this.m_DatagramSocket.getLocalAddress();
                int boundPort = this.m_DatagramSocket.getLocalPort();
                if (boundInetAddress != null && NetworkTool.isEqual(boundInetAddress, p_InetAddress) && boundPort == p_Port) {
                    return true;
                }
                this.m_DatagramSocket.close();
            }
            if (this.m_DatagramSocket_Receiver_Broadcast != null && this.m_DatagramSocket != this.m_DatagramSocket_Receiver_Broadcast) {
                this.m_DatagramSocket_Receiver_Broadcast.close();
            }
        }
        this.m_LocalInetAddress = p_InetAddress;
        this.m_LocalInetAddress_Broadcast = p_InetAddress_Broadcast;
        if (p_NetworkInterface == null) {
            p_NetworkInterface = NetworkTool.getNetworkInterface(this.m_LocalInetAddress);
        } else {
            this.m_NetworkInterface = p_NetworkInterface;
        }
        if (p_InterfaceAddress == null) {
            p_InterfaceAddress = NetworkTool.getInterfaceAddress(this.m_NetworkInterface, this.m_LocalInetAddress);
        } else {
            this.m_LocalInterfaceAddress = p_InterfaceAddress;
        }
        this.m_LocalPort = p_Port == null ? 0 : (p_Port < 0 ? 0 : p_Port);
        this.m_LocalInetSocketAddress = new InetSocketAddress(this.m_LocalInetAddress, this.m_LocalPort);
        this.m_LocalInetSocketAddress_Broadcast = new InetSocketAddress(this.m_LocalInetAddress_Broadcast, this.m_LocalPort);
        try {
            if (this.m_LocalInetAddress == null) {
                this.m_DatagramSocket = new DatagramSocket(p_Port);
                this.m_DatagramSocket.setReuseAddress(true);
                this.m_DatagramSocket.setBroadcast(true);
            } else {
                this.m_DatagramSocket = new DatagramSocket(this.m_LocalInetSocketAddress);
                this.m_DatagramSocket.setReuseAddress(true);
                this.m_DatagramSocket.setBroadcast(true);
            }
            try {
                if (this.m_LocalInetAddress_Broadcast == null) {
                    this.m_DatagramSocket_Receiver_Broadcast = new DatagramSocket(p_Port);
                    this.m_DatagramSocket_Receiver_Broadcast.setReuseAddress(true);
                    this.m_DatagramSocket_Receiver_Broadcast.setBroadcast(true);
                } else {
                    this.m_DatagramSocket_Receiver_Broadcast = new DatagramSocket(this.m_LocalInetSocketAddress_Broadcast);
                    this.m_DatagramSocket_Receiver_Broadcast.setReuseAddress(true);
                    this.m_DatagramSocket_Receiver_Broadcast.setBroadcast(true);
                }
            }
            catch (Exception e) {
                this.m_DatagramSocket_Receiver_Broadcast = this.m_DatagramSocket;
            }
            this.setSOTimeout(this.m_SOTimeout);
            this.fireEventBound(this.m_LocalInetAddress, this.m_LocalPort);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isBound() {
        if (this.m_DatagramSocket == null) {
            return false;
        }
        return this.m_DatagramSocket.isBound();
    }

    public InetSocketAddress getLocalInetSocketAddress() {
        return this.m_LocalInetSocketAddress;
    }

    public InetSocketAddress getLocalInetSocketAddress_Broadcast() {
        return this.m_LocalInetSocketAddress_Broadcast;
    }

    public NetworkInterface getNetworkInterface() {
        if (!this.isBound()) {
            return null;
        }
        return this.m_NetworkInterface;
    }

    public InterfaceAddress getLocalInterfaceAddress() {
        return this.m_LocalInterfaceAddress;
    }

    public InetAddress getLocalInetAddress() {
        return this.m_LocalInetAddress;
    }

    public InetAddress getLocalInetAddress_Broadcast() {
        return this.m_LocalInetAddress_Broadcast;
    }

    public int getLocalPort() {
        return this.m_DatagramSocket.getLocalPort();
    }

    public boolean send(byte[] p_Data, int p_Length, InetAddress p_InetAddress, int p_Port) {
        if (p_Data == null) {
            return false;
        }
        if (p_InetAddress == null) {
            return false;
        }
        if (!this.isBound()) {
            return false;
        }
        if (p_Length > p_Data.length) {
            p_Length = p_Data.length;
        }
        DatagramPacket o_DatagramPacket = new DatagramPacket(p_Data, p_Length, p_InetAddress, p_Port);
        return this.send(o_DatagramPacket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean send(DatagramPacket p_DatagramPacket) {
        if (p_DatagramPacket == null) {
            return false;
        }
        if (this.m_DatagramSocket == null) {
            return false;
        }
        if (!this.isBound()) {
            return false;
        }
        try {
            Object object = this.m_SyncSend;
            synchronized (object) {
                this.m_DatagramSocket.send(p_DatagramPacket);
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startReceive() {
        Object object;
        if (this.m_DatagramSocket_Receiver_Broadcast == null && this.m_DatagramPacket_Received_Local == null) {
            return;
        }
        this.stopReceive();
        if (this.m_DatagramSocket != this.m_DatagramSocket_Receiver_Broadcast) {
            object = this.m_SyncReceive_Broadcast;
            synchronized (object) {
                if (this.m_DatagramSocket_Receiver_Broadcast != null) {
                    this.m_IsListen = true;
                    this.m_ThreadReceiver_Broadcast = new Thread(this.m_RunnableReceive_Broadcast, this.getClass().getSimpleName() + "_startReceive");
                    this.m_ThreadReceiver_Broadcast.start();
                }
            }
        }
        object = this.m_SyncReceive_Local;
        synchronized (object) {
            if (this.m_DatagramSocket != null) {
                this.m_IsListen = true;
                this.m_ThreadReceiver_Local = new Thread(this.m_RunnableReceive_local, this.getClass().getSimpleName() + "_startReceive");
                this.m_ThreadReceiver_Local.start();
            }
        }
    }

    public void stopReceive() {
        if (this.m_DatagramSocket_Receiver_Broadcast == null && this.m_DatagramSocket == null) {
            return;
        }
        this.m_IsListen = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setSOTimeout(int p_SOTimeout) {
        DatagramSocket o_DatagramSocket;
        if (p_SOTimeout <= 0) {
            return false;
        }
        Object object = this.m_SyncReceive_Broadcast;
        synchronized (object) {
            o_DatagramSocket = this.m_DatagramSocket_Receiver_Broadcast;
        }
        if (this.m_DatagramSocket_Receiver_Broadcast != this.m_DatagramSocket && o_DatagramSocket != null) {
            try {
                o_DatagramSocket.setSoTimeout(p_SOTimeout);
                this.m_SOTimeout = p_SOTimeout;
            }
            catch (Exception e) {
                return false;
            }
        }
        Object e = this.m_SyncReceive_Local;
        synchronized (e) {
            o_DatagramSocket = this.m_DatagramSocket;
        }
        if (o_DatagramSocket != null) {
            try {
                o_DatagramSocket.setSoTimeout(p_SOTimeout);
                this.m_SOTimeout = p_SOTimeout;
            }
            catch (Exception e2) {
                return false;
            }
        }
        return true;
    }

    public int getSOTimeout() {
        return this.m_SOTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receive_Broadcast() {
        if (!this.isBound()) {
            this.m_IsListen = false;
            return;
        }
        byte[] o_LocalAddressBytes = null;
        byte[] o_RemoteAddressBytes = null;
        byte[] o_SubNetMaskBytes = null;
        byte[] o_ByteArray = new byte[65535];
        this.m_DatagramPacket_Received_Broadcast = new DatagramPacket(o_ByteArray, o_ByteArray.length);
        this.m_IsListen = true;
        if (this.m_LocalInetAddress != null) {
            o_LocalAddressBytes = this.m_LocalInetAddress.getAddress();
            o_SubNetMaskBytes = NetworkTool.detectSubNetMaskIP4(this.m_LocalInterfaceAddress);
        }
        while (this.m_IsListen) {
            try {
                Object object = this.m_SyncReceive_Broadcast;
                synchronized (object) {
                    this.m_DatagramSocket_Receiver_Broadcast.receive(this.m_DatagramPacket_Received_Broadcast);
                    if (!this.m_IsListen) {
                        this.m_ThreadReceiver_Broadcast = null;
                        break;
                    }
                }
                InetAddress o_RemoteInetAddress = this.m_DatagramPacket_Received_Broadcast.getAddress();
                if (o_RemoteInetAddress == null || (o_RemoteAddressBytes = o_RemoteInetAddress.getAddress()) == null || !NetworkTool.isSameIP4AddressRange(o_SubNetMaskBytes, o_LocalAddressBytes, o_RemoteAddressBytes) || NetworkTool.isEqual(this.m_LocalInetAddress, o_RemoteInetAddress) && this.m_LocalPort == this.m_DatagramPacket_Received_Broadcast.getPort()) continue;
                this.fireEventDataReceived(this.m_DatagramPacket_Received_Broadcast, this.m_LocalInetSocketAddress);
            }
            catch (Exception e) {
                if (!(e instanceof SocketTimeoutException)) continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receive_Local() {
        if (!this.isBound()) {
            this.m_IsListen = false;
            return;
        }
        byte[] o_LocalAddressBytes = null;
        byte[] o_RemoteAddressBytes = null;
        byte[] o_SubNetMaskBytes = null;
        byte[] o_ByteArray = new byte[65535];
        this.m_DatagramPacket_Received_Local = new DatagramPacket(o_ByteArray, o_ByteArray.length);
        this.m_IsListen = true;
        if (this.m_LocalInetAddress != null) {
            o_LocalAddressBytes = this.m_LocalInetAddress.getAddress();
            o_SubNetMaskBytes = NetworkTool.detectSubNetMaskIP4(this.m_LocalInterfaceAddress);
        }
        while (this.m_IsListen) {
            try {
                Object object = this.m_SyncReceive_Local;
                synchronized (object) {
                    this.m_DatagramSocket.receive(this.m_DatagramPacket_Received_Local);
                    if (!this.m_IsListen) {
                        this.m_ThreadReceiver_Local = null;
                        break;
                    }
                }
                InetAddress o_RemoteInetAddress = this.m_DatagramPacket_Received_Local.getAddress();
                if (o_RemoteInetAddress == null || (o_RemoteAddressBytes = o_RemoteInetAddress.getAddress()) == null || !NetworkTool.isSameIP4AddressRange(o_SubNetMaskBytes, o_LocalAddressBytes, o_RemoteAddressBytes) || NetworkTool.isEqual(this.m_LocalInetAddress, o_RemoteInetAddress) && this.m_LocalPort == this.m_DatagramPacket_Received_Local.getPort()) continue;
                this.fireEventDataReceived(this.m_DatagramPacket_Received_Local, this.m_LocalInetSocketAddress);
            }
            catch (Exception e) {
                if (!(e instanceof SocketTimeoutException)) continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireEventClosed() {
        Object object = this.m_SyncListeners;
        synchronized (object) {
            for (int intListener = 0; intListener < this.m_UDPTransportListeners.size(); ++intListener) {
                UDPTransportListener o_UDPTransportListener = this.m_UDPTransportListeners.get(intListener);
                o_UDPTransportListener.eventClosed(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireEventBound(InetAddress p_InetAddress, int p_Port) {
        Object object = this.m_SyncListeners;
        synchronized (object) {
            for (int intListener = 0; intListener < this.m_UDPTransportListeners.size(); ++intListener) {
                UDPTransportListener o_UDPTransportListener = this.m_UDPTransportListeners.get(intListener);
                o_UDPTransportListener.eventBound(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireEventDataReceived(DatagramPacket p_DatagramPacket, InetSocketAddress p_ReceiverSocketAddress) {
        Object object = this.m_SyncListeners;
        synchronized (object) {
            for (int intListener = 0; intListener < this.m_UDPTransportListeners.size(); ++intListener) {
                UDPTransportListener o_UDPTransportListener = this.m_UDPTransportListeners.get(intListener);
                o_UDPTransportListener.eventDataReceived(this, p_DatagramPacket, p_ReceiverSocketAddress);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addUDPTransportListener(UDPTransportListener p_UDPTransportListener) {
        if (p_UDPTransportListener == null) {
            return false;
        }
        Object object = this.m_SyncListeners;
        synchronized (object) {
            if (this.m_UDPTransportListeners.contains(p_UDPTransportListener)) {
                return true;
            }
            this.m_UDPTransportListeners.add(p_UDPTransportListener);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeUDPTransportListener(UDPTransportListener p_UDPTransportListener) {
        if (p_UDPTransportListener == null) {
            return false;
        }
        Object object = this.m_SyncListeners;
        synchronized (object) {
            if (!this.m_UDPTransportListeners.contains(p_UDPTransportListener)) {
                return false;
            }
            return this.m_UDPTransportListeners.remove(p_UDPTransportListener);
        }
    }

    public static interface UDPTransportListener {
        public void eventDataReceived(UDP_Transport_Broadcast var1, DatagramPacket var2, InetSocketAddress var3);

        public void eventClosed(UDP_Transport_Broadcast var1);

        public void eventBound(UDP_Transport_Broadcast var1);

        public void eventError(UDP_Transport_Broadcast var1, Exception var2);
    }
}

