/*
 * Decompiled with CFR 0.152.
 */
package StartPackage;

import DMX512.DMXUniverse;
import DMXDeviceEditorPackage.LiveShowDMXDeviceEditor;
import DMXDevicePackage.DMXDevice;
import DMXDevicePackage.DMXDeviceType;
import DMXDevicePackage.DMXPresets;
import DMXEffectsPackage.DMXEffect;
import DMXEffectsPackage.LiveShowDMXEffectsView;
import DMXGraphics.LiveShowDMXCrossTable_DMXDeviceDMXObject;
import DMXGraphics.LiveShowDMXDeviceSettings;
import DMXGraphics.LiveShowDMXDeviceTypeSelection;
import DMXGraphics.LiveShowDMXHardwareSettings;
import DMXGraphics.LiveShowDMXInputSettings;
import DMXGraphics.LiveShowDMXMixerView;
import DMXGraphics.LiveShowDMXSceneView;
import DMXGraphics.LiveShowDMXStageView;
import DMXHardwarePackage.DMXHardware;
import DMXHardwarePackage.DMXPowerSource;
import DMXMixer.DMXControlComponent;
import DMXMixer.DMXMixerPanel;
import DMXScenePackage.DMXScene;
import DMXVirtualPackage.LiveShowDMXObject;
import DMXVirtualPackage.LiveShowDMXObjectDescription;
import DMXVirtualPackage.LiveShowDMXVIP;
import JarLoader.JarResources;
import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LanguageTools.LiveLanguagePackage.LiveLanguageString;
import LiveShowControlObjects.ControlGroup;
import LiveShowObjectPackage.LiveShowJingle;
import LiveShowObjectPackage.LiveShowObject;
import LiveShowObjectPackage.LiveShowObjectDescription;
import LiveShowObjectPackage.LiveShowObjectInterface;
import LiveShowObjectPackage.LiveShowProjectDescription;
import LiveShowVirtualPackage.LiveShow_ImportDescription;
import OS.OSChecker;
import java.awt.Font;
import java.awt.event.WindowFocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.UIManager;

public class LiveShowDMXSystem
implements PropertyChangeListener {
    public static final int SOFTWAREVERSION = 1;
    private static LiveShowProjectDescription s_LiveShowProjectDescription;
    private static LiveShowDMXVIP s_LiveShowDMXVIP;
    private static ArrayList<LiveShowDMXObject> s_JingleObjects;
    private static final Object s_SyncJingles;
    @LiveLanguageString
    public static String BYTE_0_HIGHBYTE;
    @LiveLanguageString
    public static String BYTE_1_LOWHBYTE;
    @LiveLanguageString
    public static String NOTIFICATION_ACTION_LOAD_DMX;
    @LiveLanguageString
    public static String NOTIFICATION_ACTION_LOAD_DMXHARDWARE;
    @LiveLanguageString
    public static String NOTIFICATION_ACTION_LOAD_DMXUNIVERSES;
    @LiveLanguageString
    public static String NOTIFICATION_ACTION_LOAD_DMXPOWERSOURCES;
    @LiveLanguageString
    public static String NOTIFICATION_ACTION_LOAD_DMXMIXERS;
    @LiveLanguageString
    public static String NOTIFICATION_ACTION_LOAD_DMXSCENES;
    @LiveLanguageString
    public static String NOTIFICATION_ACTION_LOAD_DMXEFFECTS;
    @LiveLanguageString
    public static String NOTIFICATION_ACTION_LOAD_DMXUNIVERSES_READ;
    public static final String FOLDER_HARDWAREINTERFACES = "HardwareInterfaces";
    public static final String FOLDER_DMXDEVICES = "DMXDevices";
    public static final String FOLDER_LANGUAGES = "Languages";
    public static final String FOLDER_STYLES = "Styles";
    public static final String FOLDER_DIMMERCURVES = "DimmerCurves";
    public static File s_DirOriginalDeviceTypes;
    public static File s_DirDeviceTypes;
    public static File s_DirDimmerCurves;
    public static ControlGroup s_ControlGroup_Active;
    public static ControlGroup s_ControlGroupVirtual_Active;
    public static DMXControlComponent.DMXControlTypeListModel s_DMXControlDescriptionListModel;
    private static final Object s_SyncUniverses;
    public static Locale s_LanguageLocale;
    public static Font s_FontDefault;
    public static JarResources s_JarResources_Default;
    public static LiveShowDMXDeviceSettings s_LiveShowDMXDeviceSettings;
    public static LiveShowDMXMixerView s_LiveShowDMXMixerView;
    public static LiveShowDMXStageView s_LiveShowDMXStageView;
    public static LiveShowDMXDeviceTypeSelection s_DMXDeviceTypeSelection;
    public static LiveShowDMXHardwareSettings s_LiveShowDMXHardwareSettings;
    public static LiveShowDMXInputSettings s_LiveShowDMXInputSettings;
    public static LiveShowDMXSceneView s_LiveShowDMXSceneView;
    public static LiveShowDMXEffectsView s_LiveShowDMXEffectsView;
    public static LiveShowDMXDeviceEditor s_LiveShowDMXDeviceEditor;
    public static WindowFocusListener s_HelpFocusListener;
    public static ArrayList<UnitMixerListener> s_UnitMixerListeners;
    public static final Object s_SyncUnitMixerListeners;
    public static boolean s_ShowUnitMixerPercent;
    public static boolean s_ShowUnitMixerByteValues;
    public static LiveShowDMXSystem s_SingleInstance;
    public static LiveShowJingle.JingleCreatorInterface s_JingleCreatorInterface;
    public static LiveShowJingle.JingleContainerInterface s_JingleContainerInterface;

    public LiveShowDMXSystem() {
        LiveShowDMXSystem.init();
        LiveLanguage.addLanguageListener((Object)this, null);
    }

    private static void init() {
        s_LanguageLocale = Locale.getDefault();
        s_FontDefault = UIManager.getFont(s_LanguageLocale);
        DMXDeviceType.loadAllDMXDeviceTypes();
        DMXPowerSource.addDMXPowerSource(null);
    }

    public static void setLiveShowProjectDescription(LiveShowProjectDescription p_LiveShowProjectDescription) {
        s_LiveShowProjectDescription = p_LiveShowProjectDescription;
    }

    public static LiveShowProjectDescription getLiveShowProjectDescription() {
        return s_LiveShowProjectDescription;
    }

    public static void setLiveShowDMXVIP(LiveShowDMXVIP p_LiveShowDMXVIP) {
        if (s_LiveShowDMXVIP == p_LiveShowDMXVIP) {
            return;
        }
        s_LiveShowDMXVIP = p_LiveShowDMXVIP;
        s_LiveShowDMXStageView.setLiveShowDMXVip(s_LiveShowDMXVIP);
    }

    public static void removeLiveShowDMXVIP(LiveShowDMXVIP p_LiveShowDMXVIP) {
        if (s_LiveShowDMXVIP != p_LiveShowDMXVIP) {
            return;
        }
        s_LiveShowDMXVIP = null;
        s_LiveShowDMXStageView.setLiveShowDMXVip(s_LiveShowDMXVIP);
        s_LiveShowDMXDeviceSettings.setLiveShowDMXVIP(s_LiveShowDMXVIP);
    }

    public static LiveShowDMXVIP getLiveShowDMXVIP() {
        return s_LiveShowDMXVIP;
    }

    public static String getFolderHardwareInterfaces() {
        return FOLDER_HARDWAREINTERFACES;
    }

    public static String getPathOriginalDeviceTypes() {
        return s_DirOriginalDeviceTypes.getAbsolutePath();
    }

    public static File getDirOriginalDeviceTypes() {
        return s_DirOriginalDeviceTypes;
    }

    public static String getPathDeviceTypes() {
        return s_DirDeviceTypes.getAbsolutePath();
    }

    public static File getDirDeviceTypes() {
        return s_DirDeviceTypes;
    }

    public static String getFolderStyles() {
        return FOLDER_STYLES;
    }

    public static String getPathDimmerCurves() {
        return s_DirDimmerCurves.getAbsolutePath();
    }

    public static String getFolderDimmerCurves() {
        return FOLDER_DIMMERCURVES;
    }

    public static Locale getLanguageLocale() {
        if (s_LanguageLocale == null) {
            return Locale.getDefault();
        }
        return s_LanguageLocale;
    }

    public static Font getFontDefault() {
        return s_FontDefault;
    }

    public static void closeProject() {
        LiveShowDMXSystem.closeDMXMixerPanels();
        LiveShowDMXSystem.closeDMXEffects();
        LiveShowDMXSystem.closeDMXScenes();
        LiveShowDMXSystem.closeDMXUniverses();
        LiveShowDMXSystem.closeDMXPresets();
        LiveShowDMXSystem.closeDMXPowerSources();
        LiveShowDMXSystem.getLiveShowDMXStageView();
        LiveShowDMXStageView.clearSelectedDMXDevices();
        int intDMXDeviceCount = DMXDevice.getDMXDeviceCount();
        for (int intDMXDevice = intDMXDeviceCount - 1; intDMXDevice >= 0; --intDMXDevice) {
            DMXDevice o_DMXDevice = DMXDevice.getDMXDevice(intDMXDevice);
            if (o_DMXDevice == null) continue;
            o_DMXDevice.close();
        }
        LiveShowDMXSystem.closeDMXHardwares();
        LiveShowDMXObjectDescription.poolClear();
        LiveShowDMXCrossTable_DMXDeviceDMXObject.DMXCrossTableRow.poolClear();
    }

    public static LiveShowDMXHardwareSettings getLiveShowDMXHardwareSettings() {
        return s_LiveShowDMXHardwareSettings;
    }

    public static LiveShowDMXInputSettings getLiveShowDMXInputSettings() {
        return s_LiveShowDMXInputSettings;
    }

    public static LiveShowDMXDeviceEditor getLiveShowDMXDeviceEditor() {
        return s_LiveShowDMXDeviceEditor;
    }

    public static LiveShowDMXDeviceSettings getLiveShowDMXDeviceSettings() {
        return s_LiveShowDMXDeviceSettings;
    }

    public static LiveShowDMXDeviceTypeSelection getDMXDeviceTypeSelection() {
        return s_DMXDeviceTypeSelection;
    }

    public static LiveShowDMXStageView getLiveShowDMXStageView() {
        return s_LiveShowDMXStageView;
    }

    public static LiveShowDMXMixerView getLiveShowDMXMixerView() {
        return s_LiveShowDMXMixerView;
    }

    public static LiveShowDMXSceneView getLiveShowDMXSceneView() {
        return s_LiveShowDMXSceneView;
    }

    public static LiveShowDMXEffectsView getLiveShowDMXEffectsView() {
        return s_LiveShowDMXEffectsView;
    }

    public static void addDMXUniverse(DMXUniverse p_DMXUniverse) {
        if (p_DMXUniverse == null) {
            return;
        }
        DMXUniverse.addDMXUniverse(p_DMXUniverse);
        p_DMXUniverse.addPropertyChangeListener(s_SingleInstance);
        s_LiveShowDMXHardwareSettings.addDMXUniverse(p_DMXUniverse);
    }

    public static void removeDMXUniverse(DMXUniverse p_DMXUniverse) {
        if (p_DMXUniverse == null) {
            return;
        }
        p_DMXUniverse.removePropertyChangeListener(s_SingleInstance);
        s_LiveShowDMXHardwareSettings.removeDMXUniverse(p_DMXUniverse);
        DMXUniverse.removeDMXUniverse(p_DMXUniverse);
    }

    public static DMXUniverse getDMXUniverse(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        DMXUniverse o_DMXUniverse = DMXUniverse.getDMXUniverse(p_Index);
        return o_DMXUniverse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeDMXUniverses() {
        Object object = s_SyncUniverses;
        synchronized (object) {
            ArrayList<DMXUniverse> o_Universes = DMXUniverse.getDMXUniverses();
            for (int intUniverse = o_Universes.size() - 1; intUniverse >= 1; --intUniverse) {
                DMXUniverse o_DMXUniverse = o_Universes.get(intUniverse);
                if (o_DMXUniverse == null) continue;
                LiveShowDMXSystem.removeDMXUniverse(o_DMXUniverse);
            }
        }
    }

    public static void closeDMXPresets() {
        DMXPresets.closeDMXPresets();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveDMXUniverses(LiveShowProjectDescription p_LiveShowProjectDescription, ArrayList<DMXDevice> p_DMXDevices) {
        if (p_LiveShowProjectDescription == null) {
            return;
        }
        Object object = s_SyncUniverses;
        synchronized (object) {
            DMXUniverse.saveDMXUniverses(p_LiveShowProjectDescription, p_DMXDevices);
            DMXPresets.saveDMXPresets(p_LiveShowProjectDescription, p_DMXDevices);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteDMXUniverses(LiveShowProjectDescription p_LiveShowProjectDescription) {
        if (p_LiveShowProjectDescription == null) {
            return;
        }
        Object object = s_SyncUniverses;
        synchronized (object) {
            DMXUniverse.deleteDMXUniverses(p_LiveShowProjectDescription);
            DMXPresets.deleteDMXPresets(p_LiveShowProjectDescription);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean loadDMXUniverses(LiveShowProjectDescription p_LiveShowProjectDescription, LiveShow_ImportDescription p_LiveShow_ImportDescription) {
        boolean boolLoaded;
        if (p_LiveShowProjectDescription == null) {
            return false;
        }
        Object object = s_SyncUniverses;
        synchronized (object) {
            boolLoaded = DMXUniverse.loadDMXUniverses(p_LiveShowProjectDescription, p_LiveShow_ImportDescription);
            DMXPresets.loadDMXPresets(p_LiveShowProjectDescription, p_LiveShow_ImportDescription);
        }
        return boolLoaded;
    }

    public static void readAllDMXUniverses() {
        for (int intUniverse = 1; intUniverse < DMXUniverse.getDMXUniverseCount(); ++intUniverse) {
            DMXUniverse o_DMXUniverse = DMXUniverse.getDMXUniverse(intUniverse);
            if (o_DMXUniverse == null) continue;
            o_DMXUniverse.callDMXOutput_ReadChannels();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeDMXPowerSources() {
        Object object = s_SyncUniverses;
        synchronized (object) {
            ArrayList<DMXPowerSource> o_DMXPowerSources = DMXPowerSource.getDMXPowerSources();
            for (int intPowerSource = o_DMXPowerSources.size() - 1; intPowerSource >= 1; --intPowerSource) {
                DMXPowerSource o_DMXPowerSource = o_DMXPowerSources.get(intPowerSource);
                if (o_DMXPowerSource == null) continue;
                o_DMXPowerSource.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean loadDMXPowerSources(LiveShowProjectDescription p_LiveShowProjectDescription, LiveShow_ImportDescription p_LiveShow_ImportDescription) {
        boolean boolLoaded;
        if (p_LiveShowProjectDescription == null) {
            return false;
        }
        Object object = s_SyncUniverses;
        synchronized (object) {
            boolLoaded = DMXPowerSource.loadDMXPowerSources(p_LiveShowProjectDescription, p_LiveShow_ImportDescription);
        }
        if (!boolLoaded && p_LiveShow_ImportDescription.getLoadNewProject()) {
            DMXPowerSource o_DMXPowerSource = DMXPowerSource.getDMXPowerSource(0);
            for (int intDMXDevice = 0; intDMXDevice < DMXDevice.getDMXDeviceCount(); ++intDMXDevice) {
                DMXDevice o_DMXDevice = DMXDevice.getDMXDevice(intDMXDevice);
                if (o_DMXDevice == null) continue;
                for (int intSector = 0; intSector < o_DMXDevice.getInternalSectorCount(); ++intSector) {
                    DMXDevice.InternalSector o_InternalSector = o_DMXDevice.getInternalSector(intSector);
                    if (o_InternalSector.getDMXPowerSource() != null) continue;
                    o_InternalSector.setDMXPowerSource(DMXPowerSource.getDMXPowerSource(0));
                }
            }
        }
        return boolLoaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveDMXPowerSources(LiveShowProjectDescription p_LiveShowProjectDescription, ArrayList<DMXDevice> p_DMXDevices) {
        if (p_LiveShowProjectDescription == null) {
            return;
        }
        Object object = s_SyncUniverses;
        synchronized (object) {
            DMXPowerSource.saveDMXPowerSources(p_LiveShowProjectDescription, p_DMXDevices);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteDMXPowerSources(LiveShowProjectDescription p_LiveShowProjectDescription) {
        if (p_LiveShowProjectDescription == null) {
            return;
        }
        Object object = s_SyncUniverses;
        synchronized (object) {
            DMXPowerSource.deleteDMXPowerSources(p_LiveShowProjectDescription);
        }
    }

    public static void addDMXHardware(DMXHardware p_DMXHardware) {
        if (p_DMXHardware == null) {
            return;
        }
        DMXHardware.addDMXHardware(p_DMXHardware);
    }

    public static void removeDMXHardware(DMXHardware p_DMXHardware) {
        if (p_DMXHardware == null) {
            return;
        }
        DMXHardware.removeDMXHardware(p_DMXHardware);
    }

    public static void closeDMXHardwares() {
        ArrayList<DMXHardware> o_Hardwares = DMXHardware.getDMXHardwares();
        for (int intHardware = o_Hardwares.size() - 1; intHardware >= 0; --intHardware) {
            DMXHardware o_DMXHardware = o_Hardwares.get(intHardware);
            if (o_DMXHardware == null) continue;
            DMXHardware.removeDMXHardware(o_DMXHardware);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveDMXHardwares(LiveShowProjectDescription p_LiveShowProjectDescription) {
        if (p_LiveShowProjectDescription == null) {
            return;
        }
        Object object = s_SyncUniverses;
        synchronized (object) {
            DMXHardware.saveDMXHardwares(p_LiveShowProjectDescription);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean loadDMXHardwares(LiveShowProjectDescription p_LiveShowProjectDescription, LiveShow_ImportDescription p_LiveShow_ImportDescription) {
        boolean boolLoaded;
        if (p_LiveShowProjectDescription == null) {
            return false;
        }
        Object object = s_SyncUniverses;
        synchronized (object) {
            boolLoaded = DMXHardware.loadDMXHardwares(p_LiveShowProjectDescription, p_LiveShow_ImportDescription);
        }
        return boolLoaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteDMXHardwares(LiveShowProjectDescription p_LiveShowProjectDescription) {
        if (p_LiveShowProjectDescription == null) {
            return;
        }
        Object object = s_SyncUniverses;
        synchronized (object) {
            DMXHardware.deleteDMXHardwares(p_LiveShowProjectDescription);
        }
    }

    public static void addDMXMixerPanel(DMXMixerPanel p_DMXMixerPanel) {
        if (p_DMXMixerPanel == null) {
            return;
        }
        s_LiveShowDMXMixerView.addDMXMixerPanel(p_DMXMixerPanel);
    }

    public static void removeDMXMixerPanel(DMXMixerPanel p_DMXMixerPanel) {
        if (p_DMXMixerPanel == null) {
            return;
        }
        DMXMixerPanel.removeDMXMixerPanel(p_DMXMixerPanel);
    }

    public static void closeDMXMixerPanels() {
        ArrayList<DMXMixerPanel> o_DMXMixerPanels = DMXMixerPanel.getDMXMixerPanels();
        int intDMXMixerPanelCount = o_DMXMixerPanels.size();
        for (int intMixerPanel = intDMXMixerPanelCount - 1; intMixerPanel >= 0; --intMixerPanel) {
            DMXMixerPanel o_DMXMixerPanel = o_DMXMixerPanels.get(intMixerPanel);
            if (o_DMXMixerPanel == null) continue;
            DMXMixerPanel.removeDMXMixerPanel(o_DMXMixerPanel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveDMXMixerPanels(LiveShowProjectDescription p_LiveShowProjectDescription) {
        if (p_LiveShowProjectDescription == null) {
            return;
        }
        Object object = s_SyncUniverses;
        synchronized (object) {
            DMXMixerPanel.saveDMXMixerPanels(p_LiveShowProjectDescription);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteDMXMixerPanels(LiveShowProjectDescription p_LiveShowProjectDescription) {
        if (p_LiveShowProjectDescription == null) {
            return;
        }
        Object object = s_SyncUniverses;
        synchronized (object) {
            DMXMixerPanel.deleteDMXMixerPanels(p_LiveShowProjectDescription);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean loadDMXMixerPanels(LiveShowProjectDescription p_LiveShowProjectDescription, LiveShow_ImportDescription p_LiveShow_ImportDescription) {
        boolean boolLoaded;
        if (p_LiveShowProjectDescription == null) {
            return false;
        }
        Object object = s_SyncUniverses;
        synchronized (object) {
            boolLoaded = DMXMixerPanel.loadDMXMixerPanels(p_LiveShowProjectDescription, p_LiveShow_ImportDescription);
        }
        return boolLoaded;
    }

    public static void setUnitMixer(boolean p_ShowPercent, boolean p_ShowByteValues) {
        s_ShowUnitMixerPercent = p_ShowPercent;
        s_ShowUnitMixerByteValues = p_ShowByteValues;
        LiveShowDMXSystem.notifyUnitMixer();
    }

    public static void setUnitMixer_Percent(boolean p_ShowPercent) {
        if (s_ShowUnitMixerPercent == p_ShowPercent) {
            return;
        }
        LiveShowDMXSystem.setUnitMixer(p_ShowPercent, s_ShowUnitMixerByteValues);
    }

    public static void setUnitMixer_ByteValues(boolean p_ShowByteValues) {
        if (p_ShowByteValues == s_ShowUnitMixerByteValues) {
            return;
        }
        LiveShowDMXSystem.setUnitMixer(s_ShowUnitMixerPercent, p_ShowByteValues);
    }

    public static boolean getShowUnitMixer_Percent() {
        return s_ShowUnitMixerPercent;
    }

    public static boolean getShowUnitMixer_ByteValues() {
        return s_ShowUnitMixerByteValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addUnitMixerListener(UnitMixerListener p_UnitMixerListener) {
        if (p_UnitMixerListener == null) {
            return;
        }
        Object object = s_SyncUnitMixerListeners;
        synchronized (object) {
            if (s_UnitMixerListeners.contains(p_UnitMixerListener)) {
                return;
            }
            s_UnitMixerListeners.add(p_UnitMixerListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeUnitMixerListener(UnitMixerListener p_UnitMixerListener) {
        if (p_UnitMixerListener == null) {
            return;
        }
        Object object = s_SyncUnitMixerListeners;
        synchronized (object) {
            if (!s_UnitMixerListeners.contains(p_UnitMixerListener)) {
                return;
            }
            s_UnitMixerListeners.remove(p_UnitMixerListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyUnitMixer() {
        ArrayList<UnitMixerListener> o_UnitMixerListeners;
        Object object = s_SyncUnitMixerListeners;
        synchronized (object) {
            o_UnitMixerListeners = new ArrayList<UnitMixerListener>(s_UnitMixerListeners.size());
            o_UnitMixerListeners.addAll(s_UnitMixerListeners);
        }
        for (int intListener = 0; intListener < o_UnitMixerListeners.size(); ++intListener) {
            UnitMixerListener o_UnitMixerListener = (UnitMixerListener)o_UnitMixerListeners.get(intListener);
            o_UnitMixerListener.eventDMXShowUnitMixer(s_ShowUnitMixerPercent, s_ShowUnitMixerByteValues);
        }
    }

    public static void closeDMXScenes() {
        ArrayList<DMXScene> o_DMXScenes = DMXScene.getDMXScenes();
        for (int intScene = o_DMXScenes.size() - 1; intScene >= 0; --intScene) {
            DMXScene o_DMXScene = o_DMXScenes.get(intScene);
            if (o_DMXScene == null) continue;
            DMXScene.removeDMXScene(o_DMXScene, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveDMXScenes(LiveShowProjectDescription p_LiveShowProjectDescription, ArrayList<DMXScene> p_DMXScenes) {
        if (p_LiveShowProjectDescription == null) {
            return;
        }
        Object object = s_SyncUniverses;
        synchronized (object) {
            DMXScene.saveDMXScenes(p_LiveShowProjectDescription, p_DMXScenes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteDMXScenes(LiveShowProjectDescription p_LiveShowProjectDescription) {
        if (p_LiveShowProjectDescription == null) {
            return;
        }
        Object object = s_SyncUniverses;
        synchronized (object) {
            DMXScene.deleteDMXScenes(p_LiveShowProjectDescription);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean loadDMXScenes(LiveShowProjectDescription p_LiveShowProjectDescription, LiveShow_ImportDescription p_LiveShow_ImportDescription) {
        boolean boolLoaded;
        if (p_LiveShowProjectDescription == null) {
            return false;
        }
        Object object = s_SyncUniverses;
        synchronized (object) {
            boolLoaded = DMXScene.loadDMXScenes(p_LiveShowProjectDescription, p_LiveShow_ImportDescription);
        }
        return boolLoaded;
    }

    public static void closeDMXEffects() {
        ArrayList<DMXEffect> o_DMXEffects = DMXEffect.getDMXEffects();
        for (int intEffect = o_DMXEffects.size() - 1; intEffect >= 0; --intEffect) {
            DMXEffect o_DMXEffect = o_DMXEffects.get(intEffect);
            if (o_DMXEffect == null) continue;
            DMXEffect.removeDMXEffect(o_DMXEffect, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveDMXEffects(LiveShowProjectDescription p_LiveShowProjectDescription, ArrayList<DMXEffect> p_DMXEffects) {
        if (p_LiveShowProjectDescription == null) {
            return;
        }
        Object object = s_SyncUniverses;
        synchronized (object) {
            DMXEffect.saveDMXEffects(p_LiveShowProjectDescription, p_DMXEffects);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteDMXEffects(LiveShowProjectDescription p_LiveShowProjectDescription) {
        if (p_LiveShowProjectDescription == null) {
            return;
        }
        Object object = s_SyncUniverses;
        synchronized (object) {
            DMXEffect.deleteDMXEffects(p_LiveShowProjectDescription);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean loadDMXEffects(LiveShowProjectDescription p_LiveShowProjectDescription, LiveShow_ImportDescription p_LiveShow_ImportDescription) {
        boolean boolLoaded;
        if (p_LiveShowProjectDescription == null) {
            return false;
        }
        Object object = s_SyncUniverses;
        synchronized (object) {
            boolLoaded = DMXEffect.loadDMXEffects(p_LiveShowProjectDescription, p_LiveShow_ImportDescription);
        }
        return boolLoaded;
    }

    public static void setControlGroupActive(ControlGroup p_ControlGroup) {
        if (p_ControlGroup == null) {
            return;
        }
        s_ControlGroup_Active = p_ControlGroup;
    }

    public static ControlGroup getControlGroupActive() {
        return s_ControlGroup_Active;
    }

    public static void setControlGroupVirtualActive(ControlGroup p_ControlGroup) {
        if (p_ControlGroup == null) {
            return;
        }
        s_ControlGroupVirtual_Active = p_ControlGroup;
    }

    public static ControlGroup getControlGroupVirtualActive() {
        return s_ControlGroupVirtual_Active;
    }

    public static DMXControlComponent.DMXControlTypeListModel getDMXControlTypeListModel() {
        return s_DMXControlDescriptionListModel;
    }

    public static void setJingleCreator(LiveShowJingle.JingleCreatorInterface p_JingleCreatorInterface) {
        s_JingleCreatorInterface = p_JingleCreatorInterface;
    }

    public static LiveShowJingle.JingleInterface createJingle(LiveShowObjectDescription p_LiveShowObjectDescription) {
        if (s_JingleCreatorInterface == null) {
            return null;
        }
        return s_JingleCreatorInterface.createJingle(p_LiveShowObjectDescription);
    }

    public static LiveShowJingle.JingleInterface createJingle(LiveShowObjectInterface p_LiveShowObjectInterface) {
        if (s_JingleCreatorInterface == null) {
            return null;
        }
        return s_JingleCreatorInterface.createJingle(p_LiveShowObjectInterface);
    }

    public static void setJingleContainer(LiveShowJingle.JingleContainerInterface p_JingleContainerInterface) {
        s_JingleContainerInterface = p_JingleContainerInterface;
    }

    public static LiveShowJingle.JingleContainerInterface getJingleContainerInterface() {
        return s_JingleContainerInterface;
    }

    public static int getJingleObjectCount() {
        LiveShowJingle.JingleContainerInterface o_JingleContainerInterface = s_JingleContainerInterface;
        if (o_JingleContainerInterface == null) {
            return 0;
        }
        return o_JingleContainerInterface.getJingleViewCount();
    }

    public static LiveShowDMXObject getJingleObject(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        LiveShowJingle.JingleContainerInterface o_JingleContainerInterface = s_JingleContainerInterface;
        if (o_JingleContainerInterface == null) {
            return null;
        }
        LiveShowJingle.JingleInterface o_JingleInterface = o_JingleContainerInterface.getJingleView(p_Index);
        if (o_JingleInterface == null) {
            return null;
        }
        return (LiveShowDMXObject)o_JingleInterface.getLiveShowObject();
    }

    public static LiveShowObjectInterface getJingleObject(String p_ID) {
        if (p_ID == null) {
            return null;
        }
        LiveShowJingle.JingleContainerInterface o_JingleContainerInterface = s_JingleContainerInterface;
        if (o_JingleContainerInterface == null) {
            return null;
        }
        for (int intObject = 0; intObject < o_JingleContainerInterface.getJingleViewCount(); ++intObject) {
            LiveShowJingle.JingleInterface o_JingleInterface = o_JingleContainerInterface.getJingleView(intObject);
            LiveShowObject o_LiveShowObjectInterface = o_JingleInterface.getLiveShowObject();
            if (o_LiveShowObjectInterface == null || !p_ID.equals(o_LiveShowObjectInterface.getID())) continue;
            return o_LiveShowObjectInterface;
        }
        return null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof DMXUniverse) {
            switch (evt.getPropertyName()) {
                case "universeConnectionStatus_Output": {
                    break;
                }
            }
        }
    }

    public static void setHelpFocusListener(WindowFocusListener p_HelpFocusListener) {
        s_HelpFocusListener = p_HelpFocusListener;
        s_LiveShowDMXDeviceSettings.addWindowFocusListener(p_HelpFocusListener);
    }

    public static WindowFocusListener getHelpFocusListener() {
        return s_HelpFocusListener;
    }

    static {
        s_LiveShowDMXVIP = null;
        s_JingleObjects = new ArrayList();
        s_SyncJingles = new Object();
        BYTE_0_HIGHBYTE = "HighByte";
        BYTE_1_LOWHBYTE = "LowByte";
        NOTIFICATION_ACTION_LOAD_DMX = "Load DMX";
        NOTIFICATION_ACTION_LOAD_DMXHARDWARE = "Load DMX Hardware";
        NOTIFICATION_ACTION_LOAD_DMXUNIVERSES = "Load DMX Universes";
        NOTIFICATION_ACTION_LOAD_DMXPOWERSOURCES = "Load DMX PowerSources";
        NOTIFICATION_ACTION_LOAD_DMXMIXERS = "Load DMX Mixers";
        NOTIFICATION_ACTION_LOAD_DMXSCENES = "Load DMX Scenes";
        NOTIFICATION_ACTION_LOAD_DMXEFFECTS = "Load DMX Effects";
        NOTIFICATION_ACTION_LOAD_DMXUNIVERSES_READ = "Read all DMX Universes";
        s_DirOriginalDeviceTypes = new File(FOLDER_DMXDEVICES);
        s_DirDeviceTypes = new File(OSChecker.getUserHomeConfigDirectory() + "/" + FOLDER_DMXDEVICES);
        s_DirDimmerCurves = new File(OSChecker.getUserHomeConfigDirectory() + "/" + FOLDER_DIMMERCURVES);
        s_ControlGroup_Active = null;
        s_ControlGroupVirtual_Active = new ControlGroup(0);
        s_DMXControlDescriptionListModel = new DMXControlComponent.DMXControlTypeListModel();
        s_SyncUniverses = new Object();
        s_JarResources_Default = new JarResources(LiveShowDMXSystem.getFolderStyles() + File.separator + "LiveShowControls_Black.jar");
        s_LiveShowDMXDeviceSettings = new LiveShowDMXDeviceSettings(null, false);
        s_LiveShowDMXMixerView = new LiveShowDMXMixerView();
        s_LiveShowDMXStageView = new LiveShowDMXStageView();
        s_DMXDeviceTypeSelection = new LiveShowDMXDeviceTypeSelection(true);
        s_LiveShowDMXHardwareSettings = new LiveShowDMXHardwareSettings();
        s_LiveShowDMXInputSettings = new LiveShowDMXInputSettings();
        s_LiveShowDMXSceneView = new LiveShowDMXSceneView();
        s_LiveShowDMXEffectsView = new LiveShowDMXEffectsView();
        s_LiveShowDMXDeviceEditor = new LiveShowDMXDeviceEditor();
        s_UnitMixerListeners = new ArrayList();
        s_SyncUnitMixerListeners = new Object();
        s_ShowUnitMixerPercent = true;
        s_ShowUnitMixerByteValues = false;
        s_SingleInstance = new LiveShowDMXSystem();
        s_JingleCreatorInterface = null;
        s_JingleContainerInterface = null;
    }

    public static interface UnitMixerListener {
        public void eventDMXShowUnitMixer(boolean var1, boolean var2);
    }
}

