/*
 * Decompiled with CFR 0.152.
 */
package PlayDMXPackage;

import DMXDevicePackage.DMXDevice;
import DMXEffectsPackage.DMXEffect_PlayContainer;
import DMXScenePackage.DMXScene;
import DMXVirtualPackage.LiveShowDMXObject;
import DMXVirtualPackage.LiveShowDMXVIPAdjustment;
import LiveShowObjectPackage.LiveShowObjectInterface;
import LiveShowPlayPackage.Play;
import LiveShowPlayPackage.PlayListener;
import LiveShowPlayPackage.Playable;
import OS.OSChecker;
import TimerPackage.JavaTimer;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class PlayDMX
extends Play
implements Runnable {
    public static final String INIFILE_NAME = OSChecker.getPathUserHomeConfigDirectory() + "/PlayDMX.ini";
    public static final String INIFILE_FIELDSEPERATOR = "=";
    public static int BUFFER_MILLISECONDS = 40;
    public static int NEW_BUFFER_MILLISECONDS = 40;
    public static boolean USESINIFILE = PlayDMX.readIni();
    protected static boolean s_ReadIniActive = false;
    public static final Object s_SyncWriteIni = new Object();
    protected long m_FramesToReadTime;
    protected long m_FramesToReadDefault;
    protected DMXPlayObject m_DMXPlayObject;
    protected DMXPlayObject m_DMXPlayObject_EditMode;
    protected long m_FramePositionToWrite;
    protected JavaTimer m_JavaTimer;
    protected final Object m_SyncPlayWait = new Object();
    protected DMXEffect_PlayContainer m_DMXEffect_PlayContainer;

    public static int getNewBufferMilliseconds() {
        return NEW_BUFFER_MILLISECONDS;
    }

    public static void setNewBufferMilliseconds(int p_Milliseconds) {
        NEW_BUFFER_MILLISECONDS = p_Milliseconds;
    }

    public static boolean readIni() {
        LiveShowDMXVIPAdjustment.setAdjustmentCrossoverCorrectionFrames(LiveShowDMXVIPAdjustment.getAdjustmentCrossoverCorrectionFrames());
        File o_FileIni = new File(INIFILE_NAME);
        if (!o_FileIni.exists()) {
            return false;
        }
        s_ReadIniActive = true;
        boolean boolIni = false;
        FileReader o_FileReaderIni = null;
        BufferedReader o_BufferedReader = null;
        try {
            o_FileReaderIni = new FileReader(o_FileIni);
            o_BufferedReader = new BufferedReader(o_FileReaderIni);
            String stringLine = o_BufferedReader.readLine();
            while (stringLine != null) {
                String[] stringValuePair = stringLine.split(INIFILE_FIELDSEPERATOR);
                if (stringValuePair == null) {
                    stringLine = o_BufferedReader.readLine();
                    continue;
                }
                if (stringValuePair.length < 2) {
                    stringLine = o_BufferedReader.readLine();
                    continue;
                }
                if (stringValuePair[1].trim().length() > 0) {
                    String stringPropertyName = stringValuePair[0].trim();
                    String stringPropertyValue = stringValuePair[1].trim();
                    if (stringPropertyName.trim().equals("DMXPlayBuffer_ms")) {
                        int intValue = Integer.valueOf(stringPropertyValue.trim());
                        if (intValue > 10 && intValue <= 1000) {
                            BUFFER_MILLISECONDS = intValue;
                            NEW_BUFFER_MILLISECONDS = intValue;
                        }
                        boolIni = true;
                    } else if (stringPropertyName.trim().equals("DMXAdjustmentLength_ms")) {
                        long longValue = Long.valueOf(stringPropertyValue.trim());
                        if (longValue >= 0L) {
                            LiveShowDMXVIPAdjustment.setAdjustmentTime(longValue);
                        }
                        boolIni = true;
                    } else if (stringPropertyName.trim().equals("DMXAdjustmentDelay_ms")) {
                        long longValue = Long.valueOf(stringPropertyValue.trim());
                        if (longValue >= 0L) {
                            LiveShowDMXVIPAdjustment.setAdjustmentDelay(longValue);
                        }
                        boolIni = true;
                    } else if (stringPropertyName.trim().equals("JingleFadeInBlackout")) {
                        boolean booleanFadeBlackout;
                        DMXScene.s_JingleFadeInBlackout = booleanFadeBlackout = Boolean.valueOf(stringPropertyValue).booleanValue();
                        boolIni = true;
                    }
                }
                stringLine = o_BufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (o_BufferedReader != null) {
                o_BufferedReader.close();
            }
            if (o_FileReaderIni != null) {
                o_FileReaderIni.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        s_ReadIniActive = false;
        return boolIni;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeIni() {
        if (s_ReadIniActive) {
            return false;
        }
        Object object = s_SyncWriteIni;
        synchronized (object) {
            File o_FileIni;
            boolean boolOK = true;
            if (s_ReadIniActive) {
                return false;
            }
            try {
                o_FileIni = new File(INIFILE_NAME);
                if (o_FileIni.exists()) {
                    boolOK = o_FileIni.delete();
                }
                if (!boolOK) {
                    return false;
                }
            }
            catch (Exception e) {
                System.err.println("ERROR PlayDMX writeIni() - delete ini file:");
                e.printStackTrace();
                return false;
            }
            boolean boolIni = false;
            FileWriter o_FileWriterIni = null;
            BufferedWriter o_BufferedWriter = null;
            try {
                o_FileWriterIni = new FileWriter(o_FileIni);
                o_BufferedWriter = new BufferedWriter(o_FileWriterIni);
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.delete(0, stringBuilder.length());
                stringBuilder.append("DMXPlayBuffer_ms");
                stringBuilder.append(INIFILE_FIELDSEPERATOR);
                stringBuilder.append(NEW_BUFFER_MILLISECONDS);
                stringBuilder.append(INIFILE_FIELDSEPERATOR);
                stringBuilder.append("time in milliseconds dmx values will be sended (default 40, for older hardware try 80)");
                o_BufferedWriter.append(stringBuilder.toString());
                o_BufferedWriter.newLine();
                stringBuilder.delete(0, stringBuilder.length());
                stringBuilder.append("DMXAdjustmentLength_ms");
                stringBuilder.append(INIFILE_FIELDSEPERATOR);
                stringBuilder.append(LiveShowDMXVIPAdjustment.getAdjustmentLength());
                stringBuilder.append(INIFILE_FIELDSEPERATOR);
                stringBuilder.append("time (ms) duration the adjustent uses to arrange the DMXDevices as it will be used in the next scene");
                o_BufferedWriter.append(stringBuilder.toString());
                o_BufferedWriter.newLine();
                long longAdjustmentDelay = LiveShowDMXVIPAdjustment.getAdjustmentDelay();
                if (longAdjustmentDelay <= LiveShowDMXVIPAdjustment.getAdjustmentCrossoverCorrection()) {
                    longAdjustmentDelay = 0L;
                }
                stringBuilder.delete(0, stringBuilder.length());
                stringBuilder.append("DMXAdjustmentDelay_ms");
                stringBuilder.append(INIFILE_FIELDSEPERATOR);
                stringBuilder.append(longAdjustmentDelay);
                stringBuilder.append(INIFILE_FIELDSEPERATOR);
                stringBuilder.append("delay (ms) the adjustment starts to arrange the DMXDevice after a scene and will be ready in front of a it's new scene");
                o_BufferedWriter.append(stringBuilder.toString());
                o_BufferedWriter.newLine();
                stringBuilder.delete(0, stringBuilder.length());
                stringBuilder.append("JingleFadeInBlackout");
                stringBuilder.append(INIFILE_FIELDSEPERATOR);
                stringBuilder.append(DMXScene.s_JingleFadeInBlackout);
                stringBuilder.append(INIFILE_FIELDSEPERATOR);
                stringBuilder.append("Fade movingheads in DMXJingle with lamp on (true) or lamp off (false)");
                o_BufferedWriter.append(stringBuilder.toString());
                o_BufferedWriter.newLine();
                boolIni = true;
            }
            catch (IOException e_IOException) {
                System.err.println("ERROR PlayDMX writeIni():");
                e_IOException.printStackTrace();
            }
            try {
                if (o_BufferedWriter != null) {
                    o_BufferedWriter.flush();
                    o_BufferedWriter.close();
                }
                if (o_FileWriterIni != null) {
                    o_FileWriterIni.close();
                }
            }
            catch (IOException e_IOException) {
                System.err.println("ERROR PlayDMX writeIni() - close ini file:");
                e_IOException.printStackTrace();
            }
            return boolIni;
        }
    }

    public PlayDMX(Playable p_Playable, int p_FlagMixSource) {
        super(p_Playable);
        this.initMembers();
        this.m_DMXPlayObject.getDMXSceneValueContainer().setFlagMixSource(p_FlagMixSource);
        this.setPlayCursor(this.m_FramePlayCursor);
    }

    private void initMembers() {
        this.initPlayObject();
        this.setColor(Color.YELLOW);
        this.m_FramesToReadTime = BUFFER_MILLISECONDS;
        this.m_DMXEffect_PlayContainer = new DMXEffect_PlayContainer(this);
        this.m_JavaTimer = new JavaTimer();
    }

    @Override
    public boolean createOutputLine() {
        this.m_HasOutputLine = true;
        return true;
    }

    @Override
    public boolean closeOutputLine() {
        this.m_HasOutputLine = false;
        return true;
    }

    @Override
    public void close() {
        super.close();
        if (this.m_DMXPlayObject != null) {
            this.m_DMXPlayObject.close();
        }
        if (this.m_DMXPlayObject_EditMode != null) {
            this.m_DMXPlayObject_EditMode.close();
        }
        this.m_JavaTimer.close();
    }

    public DMXEffect_PlayContainer getDMXEffect_PlayContainer() {
        return this.m_DMXEffect_PlayContainer;
    }

    @Override
    public void setPlayable(Playable p_Playable, Object p_FlagMixSource) {
        if (this.m_Playable == p_Playable) {
            return;
        }
        if (p_Playable == null) {
            return;
        }
        if (p_FlagMixSource == null) {
            return;
        }
        if (!(p_FlagMixSource instanceof Integer)) {
            return;
        }
        super.setPlayable(p_Playable, p_FlagMixSource);
        if (this.m_DMXPlayObject != null) {
            this.m_DMXPlayObject.close();
        }
        this.initPlayObject();
        this.m_DMXPlayObject.getDMXSceneValueContainer().setFlagMixSource((Integer)p_FlagMixSource);
    }

    @Override
    protected void initPlayObject() {
        this.m_DMXPlayObject = new DMXPlayObject(this.m_Playable);
        this.m_DMXPlayObject.setFramesBuffered(1);
        this.m_FramesToReadDefault = (long)((double)BUFFER_MILLISECONDS / this.m_Playable.getFrameTime() + 0.5);
        this.m_DMXPlayObject.setFramesBuffered((int)this.m_FramesToReadDefault);
    }

    @Override
    public Playable.PlayObject getPlayObject() {
        return this.m_DMXPlayObject;
    }

    @Override
    public long getBufferDelayFrames() {
        return BUFFER_MILLISECONDS;
    }

    public long getPlayCursorJumpPerReadCycle() {
        return this.m_FramesToReadDefault;
    }

    @Override
    public void setPlayCursor(long p_FramePosition) {
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return;
        }
        super.setPlayCursor(p_FramePosition);
        super.setPlayCursorInternal(super.getOldPlayCursor(), super.getPlayCursor());
        this.m_FramePositionToWrite = super.getPlayCursor();
        this.m_LiveCloseSemaphore.leaveWorkerSection();
    }

    @Override
    public void letsRun() {
        super.letsRun();
    }

    @Override
    public void setWaitForTrigger(boolean p_Wait) {
        super.setWaitForTrigger(p_Wait);
        if (!p_Wait) {
            // empty if block
        }
    }

    @Override
    protected void clearPlaying() {
        this.m_FramesRead = -1L;
    }

    @Override
    public void reworkPause() {
    }

    @Override
    public void reworkStop() {
    }

    @Override
    public void playFramePositionOnce(long p_FramePosition) {
        if (this.m_Playable == null) {
            return;
        }
        if (!this.m_IsEditModeOn) {
            if (this.m_DMXPlayObject == null) {
                return;
            }
            this.m_DMXPlayObject.clear();
            this.m_DMXPlayObject.setFramePosition(p_FramePosition);
            this.m_DMXPlayObject.setFramesToRead(1L);
            this.m_Playable.read(this, this.m_DMXPlayObject);
            DMXScene.DMXSceneValueContainer o_DMXSceneValueContainer = this.m_DMXPlayObject.getDMXSceneValueContainer();
            if (o_DMXSceneValueContainer == null) {
                return;
            }
            this.fetchWriteLiveShowObjectInterfaces_Jingle(this.m_DMXPlayObject.getFramePosition(), this.m_DMXPlayObject.getFramesToRead());
            o_DMXSceneValueContainer.writeDMXSceneLight();
        } else {
            if (this.m_DMXPlayObject_EditMode == null) {
                this.m_DMXPlayObject_EditMode = new DMXPlayObject(this.m_Playable, true);
                this.m_DMXPlayObject_EditMode.setFramesBuffered(1);
                long longFramesToReadDefault = (long)((double)BUFFER_MILLISECONDS / this.m_Playable.getFrameTime() + 0.5);
                this.m_DMXPlayObject_EditMode.setFramesBuffered((int)longFramesToReadDefault);
            }
            this.m_DMXPlayObject_EditMode.clear();
            this.m_DMXPlayObject_EditMode.setFramePosition(p_FramePosition);
            this.m_DMXPlayObject_EditMode.setFramesToRead(1L);
            this.m_Playable.read(this, this.m_DMXPlayObject_EditMode);
            DMXScene.DMXSceneValueContainer o_DMXSceneValueContainer = this.m_DMXPlayObject_EditMode.getDMXSceneValueContainer();
            if (o_DMXSceneValueContainer == null) {
                return;
            }
            o_DMXSceneValueContainer.writeDMXSceneLight();
        }
    }

    @Override
    public void playFramePositionOnce() {
        if (!this.m_IsEditModeOn) {
            this.playFramePositionOnce(this.m_FramePlayCursor);
        } else {
            this.playFramePositionOnce(this.m_FrameEditCursor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    protected void fetchwriteData() {
        long longFramesToRead;
        long longOldFramePositionToWrite;
        DMXScene.DMXSceneValueContainer o_DMXSceneValueContainer;
        Playable o_Playable;
        DMXPlayObject o_DMXPlayObject;
        boolean boolFadedInAtEndPosition;
        block29: {
            long longFrames;
            block31: {
                if (this.m_PlayListeners == null) {
                    return;
                }
                boolFadedInAtEndPosition = false;
                o_DMXPlayObject = this.m_DMXPlayObject;
                o_Playable = this.m_Playable;
                if (o_DMXPlayObject == null) {
                    if (this.m_PlaySynchronisizer != null) {
                        this.m_PlaySynchronisizer.actionPlayPause();
                        return;
                    }
                    this.m_StopFlag = true;
                    return;
                }
                if (o_Playable == null) {
                    if (this.m_PlaySynchronisizer != null) {
                        this.m_PlaySynchronisizer.actionPlayPause();
                        return;
                    }
                    this.m_StopFlag = true;
                    return;
                }
                o_DMXPlayObject.clear();
                o_DMXSceneValueContainer = o_DMXPlayObject.getDMXSceneValueContainer();
                if (this.m_FramePositionToWrite >= o_Playable.getFrameEndToPlay()) {
                    this.m_FramePositionToWrite = o_Playable.getFrameEndToPlay();
                    super.setPlayCursorInternal(o_Playable.getFrameEndToPlay(), o_Playable.getFrameEndToPlay());
                    if (o_DMXSceneValueContainer == null) return;
                    o_DMXSceneValueContainer.setFadeInProgress(0.0);
                    o_DMXSceneValueContainer.setFadeOutProgress(0.0);
                    o_DMXSceneValueContainer.setFadeProgress(0.0);
                    return;
                }
                longOldFramePositionToWrite = this.m_FramePositionToWrite;
                longFrames = o_DMXPlayObject.getFramesBuffered();
                if (!this.m_PauseAfterFadeIn) break block31;
                long longFadedInPos = o_Playable.findFramePosition_FadeIn(1.0) - 1L;
                if (longFadedInPos >= o_Playable.getFrameEndToPlay()) {
                    if (longFadedInPos > o_Playable.getFrameEndToPlay()) {
                        longFadedInPos = o_Playable.getFrameEndToPlay();
                    }
                    if (this.m_FramePositionToWrite + o_DMXPlayObject.getFramesToRead() >= longFadedInPos) {
                        this.m_FramePositionToWrite = longFadedInPos - 1L;
                        longFramesToRead = 1L;
                        boolFadedInAtEndPosition = true;
                        break block29;
                    } else {
                        longFramesToRead = longFrames;
                    }
                    break block29;
                } else if (this.m_FramePositionToWrite + o_DMXPlayObject.getFramesToRead() > longFadedInPos) {
                    this.m_FramePositionToWrite = longFadedInPos;
                    longFramesToRead = 0L;
                    boolFadedInAtEndPosition = true;
                    break block29;
                } else {
                    longFramesToRead = longFrames;
                }
                break block29;
            }
            longFramesToRead = this.m_FramePositionToWrite + longFrames > o_Playable.getFrameEndToPlay() ? o_Playable.getFrameEndToPlay() - this.m_FramePositionToWrite : longFrames;
        }
        boolean boolReady = false;
        boolean boolJumpNow = false;
        boolean boolReadFromSceneBridge = false;
        while (!boolReady) {
            block30: {
                block32: {
                    boolReady = true;
                    if (this.m_ActualPlayJump == null || !this.m_ActualPlayJump.getJumpIsActive()) break block32;
                    if (!boolJumpNow) {
                        if (this.m_FramePositionToWrite < this.m_ActualPlayJump.getJumpFrameFrom() && this.m_FramePositionToWrite + longFramesToRead > this.m_ActualPlayJump.getJumpFrameFrom()) {
                            longFramesToRead = this.m_ActualPlayJump.getJumpFrameFrom() - this.m_FramePositionToWrite;
                            boolJumpNow = true;
                            boolReady = false;
                            if (longFramesToRead <= 0L) {
                                continue;
                            }
                            break block30;
                        } else {
                            boolReady = true;
                        }
                        break block30;
                    } else {
                        this.setPlayCursor(this.m_ActualPlayJump.getJumpFrameTo());
                        boolReady = true;
                        continue;
                    }
                }
                boolReady = true;
            }
            this.setWillStopAtSceneBridge(null);
            Object object = this.m_SyncPlayListeners;
            // MONITORENTER : object
            for (int intListener = 0; this.m_PlayListeners != null && intListener < this.m_PlayListeners.size(); ++intListener) {
                PlayListener o_PlayListener = (PlayListener)this.m_PlayListeners.get(intListener);
                if (o_PlayListener == null) continue;
                long longVetoFramesToRead = o_PlayListener.eventPlayCheckRead(this, this.m_FramePositionToWrite, longFramesToRead);
                if (longVetoFramesToRead <= 0L) {
                    longVetoFramesToRead = 0L;
                }
                if (longVetoFramesToRead >= longFramesToRead) continue;
                longFramesToRead = longVetoFramesToRead;
            }
            // MONITOREXIT : object
            if (longFramesToRead <= 0L) {
                longFramesToRead = 0L;
            }
            this.fetchWriteLiveShowObjectInterfaces_Jingle(this.m_FramePositionToWrite, longFramesToRead);
            o_DMXPlayObject.setFramePosition(this.m_FramePositionToWrite);
            o_DMXPlayObject.setFramesToRead(longFramesToRead);
            boolReadFromSceneBridge = o_Playable.getLiveShowSceneBridge_Actual() != null;
            o_Playable.read(this, o_DMXPlayObject);
            if (boolFadedInAtEndPosition && o_DMXSceneValueContainer != null) {
                o_DMXSceneValueContainer.setFadeInProgress(1.0);
                o_DMXSceneValueContainer.setFadeProgress(1.0);
            }
            this.m_FramePositionToWrite += longFramesToRead;
            if (o_DMXSceneValueContainer == null) {
                return;
            }
            o_DMXSceneValueContainer.setOverwriteManualValues(this.m_OverwriteManualValues || boolReadFromSceneBridge);
            DMXScene.mixMain(o_DMXSceneValueContainer);
            if (this.m_Status != 3) {
                return;
            }
            super.setPlayCursorInternal(longOldFramePositionToWrite, this.m_FramePositionToWrite);
            this.setWillStopAtSceneBridge(null);
            if (this.m_FramesRead < 0L) {
                this.m_PlayStartTime = System.nanoTime();
                return;
            }
            long longActualTime = (System.nanoTime() - this.m_PlayStartTime) / 1000000L;
            long longActualTimeCalculated = (long)((double)this.m_FramesRead * o_Playable.getFrameTime());
            long longTimeDiff = longActualTime - longActualTimeCalculated;
            this.m_FramesToReadTime = (long)((double)longFramesToRead * o_Playable.getFrameTime() + 0.5);
            long longTimeToWait = this.m_FramesToReadTime - longTimeDiff;
            if (this.m_FramesToReadTime > 0L) {
                this.m_JavaTimer.sleep(longTimeToWait);
            }
            this.m_FramesRead += longFramesToRead;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLiveShowObjectInterface_Jingle(LiveShowObjectInterface p_LiveShowObjectInterface) {
        if (p_LiveShowObjectInterface == null) {
            return;
        }
        if (!p_LiveShowObjectInterface.getIsJingle()) {
            return;
        }
        DMXPlayObject o_DMXPlayObject = null;
        boolean boolFirstAdded = false;
        Object object = this.m_SyncJingles;
        synchronized (object) {
            LiveShowDMXObject o_LiveShowDMXObject;
            if (this.m_LiveShowOOjects_Jingle.size() == 0) {
                boolFirstAdded = true;
            }
            if (this.m_LiveShowOOjects_Jingle.contains(p_LiveShowObjectInterface)) {
                this.m_LiveShowOOjects_Jingle.remove(p_LiveShowObjectInterface);
                o_DMXPlayObject = (DMXPlayObject)this.getPlayObject_Jingle(p_LiveShowObjectInterface);
            }
            int intJingle = 0;
            for (intJingle = 0; intJingle < this.m_LiveShowOOjects_Jingle.size() && ((o_LiveShowDMXObject = (LiveShowDMXObject)this.m_LiveShowOOjects_Jingle.get(intJingle)) == null || o_LiveShowDMXObject.getFrameStart() <= p_LiveShowObjectInterface.getFrameStart()); ++intJingle) {
            }
            o_LiveShowDMXObject = (LiveShowDMXObject)p_LiveShowObjectInterface;
            this.m_LiveShowOOjects_Jingle.add(intJingle, o_LiveShowDMXObject);
            if (o_DMXPlayObject == null) {
                o_DMXPlayObject = new DMXPlayObject(o_LiveShowDMXObject);
                o_DMXPlayObject.getDMXSceneValueContainer().setFlagMixSource(2);
                this.m_PlayObjects_Jingles.put(p_LiveShowObjectInterface.getID(), o_DMXPlayObject);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLiveShowObjectInterface_Jingle(LiveShowObjectInterface p_LiveShowObjectInterface) {
        if (p_LiveShowObjectInterface == null) {
            return;
        }
        boolean boolChangedActiveDMXPlayObjects = false;
        boolean boolAllRemoved = false;
        Object object = this.m_SyncJingles;
        synchronized (object) {
            DMXPlayObject o_DMXPlayObject;
            if (!this.m_LiveShowOOjects_Jingle.remove(p_LiveShowObjectInterface)) {
                return;
            }
            if (this.m_LiveShowOOjects_Jingle.size() == 0) {
                boolAllRemoved = true;
            }
            if ((o_DMXPlayObject = (DMXPlayObject)this.getPlayObject_Jingle(p_LiveShowObjectInterface)) == null) {
                return;
            }
            this.m_PlayObjects_Jingles.remove(p_LiveShowObjectInterface.getID());
            if (this.m_LiveShowObjects_JingleActive.remove(o_DMXPlayObject)) {
                DMXScene.removeJingleDMXSceneValueContainer(o_DMXPlayObject.getDMXSceneValueContainer());
                boolChangedActiveDMXPlayObjects = true;
            }
            this.m_LiveShowObjects_JingleStopped.remove(o_DMXPlayObject);
            o_DMXPlayObject.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Playable.PlayObject getPlayObject_Jingle(LiveShowObjectInterface p_LiveShowDMXObject) {
        if (p_LiveShowDMXObject == null) {
            return null;
        }
        Object object = this.m_SyncJingles;
        synchronized (object) {
            return (Playable.PlayObject)this.m_PlayObjects_Jingles.get(p_LiveShowDMXObject.getID());
        }
    }

    @Override
    public int getLiveShowObjectInterfaces_JingleCount() {
        return this.m_LiveShowOOjects_Jingle.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LiveShowObjectInterface getLiveShowObjectInterface_Jingle(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        Object object = this.m_SyncJingles;
        synchronized (object) {
            if (p_Index >= this.m_LiveShowOOjects_Jingle.size()) {
                return null;
            }
            return (LiveShowObjectInterface)this.m_LiveShowOOjects_Jingle.get(p_Index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fetchWriteLiveShowObjectInterfaces_Jingle(long p_FramePositionToWrite, long p_FramesToRead) {
        boolean boolActiveObjectsChanged = false;
        for (int intJingle = 0; intJingle < this.getLiveShowObjectInterfaces_JingleCount(); ++intJingle) {
            Object object;
            DMXPlayObject o_DMXPlayObject;
            LiveShowDMXObject o_LiveShowDMXJingle = (LiveShowDMXObject)this.getLiveShowObjectInterface_Jingle(intJingle);
            if (o_LiveShowDMXJingle == null || (o_DMXPlayObject = (DMXPlayObject)this.getPlayObject_Jingle(o_LiveShowDMXJingle)) == null) continue;
            o_DMXPlayObject.clear();
            o_DMXPlayObject.setFramePosition(p_FramePositionToWrite);
            o_DMXPlayObject.setFramesToRead(p_FramesToRead);
            if (o_LiveShowDMXJingle.read(this, o_DMXPlayObject) == null) {
                object = this.m_SyncJingles;
                synchronized (object) {
                    if (this.m_LiveShowObjects_JingleActive.remove(o_DMXPlayObject)) {
                        this.m_LiveShowObjects_JingleStopped.add(o_DMXPlayObject);
                        boolActiveObjectsChanged = true;
                    }
                    continue;
                }
            }
            object = this.m_SyncJingles;
            synchronized (object) {
                if (!this.m_LiveShowObjects_JingleActive.contains(o_DMXPlayObject) && this.m_LiveShowObjects_JingleActive.add(o_DMXPlayObject)) {
                    this.m_LiveShowObjects_JingleStopped.remove(o_DMXPlayObject);
                    boolActiveObjectsChanged = true;
                }
                continue;
            }
        }
        if (boolActiveObjectsChanged) {
            DMXScene.changedJingleDMXSceneValueContainer(this.m_LiveShowObjects_JingleActive, this.m_LiveShowObjects_JingleStopped);
        }
        if (this.m_LiveShowObjects_JingleActive.size() > 0) {
            DMXScene.mixJingles();
        }
    }

    public static Playable.PlayObject mixDMXSceneBridgePlayObjects(Playable.PlayObject p_PlayObjectLine, Playable.PlayObject p_PlayObject, double p_FadeOutProgress) {
        if (p_PlayObjectLine == null) {
            return null;
        }
        if (p_PlayObject == null) {
            return null;
        }
        DMXPlayObject o_DMXPlayObjectLine = (DMXPlayObject)p_PlayObjectLine;
        DMXPlayObject o_DMXPlayObject = (DMXPlayObject)p_PlayObject;
        DMXScene.DMXSceneValueContainer o_DMXSceneValueContainerLine = o_DMXPlayObjectLine.getDMXSceneValueContainer();
        if (o_DMXSceneValueContainerLine == null) {
            return p_PlayObjectLine;
        }
        DMXScene.DMXSceneValueContainer o_DMXSceneValueContainer = o_DMXPlayObject.getDMXSceneValueContainer();
        o_DMXSceneValueContainerLine.mixDMXSceneBridgePlayObjects(o_DMXSceneValueContainer, p_FadeOutProgress);
        return p_PlayObjectLine;
    }

    public static double calculateVolumeFactor(double p_Loudness) {
        double doubleFactor;
        if (p_Loudness <= 0.0) {
            doubleFactor = 0.0;
        } else if (p_Loudness == 1.0) {
            doubleFactor = 1.0;
        } else {
            double doubleExp = 0.5 * Math.log10(p_Loudness) / Math.log10(2.0);
            doubleFactor = Math.pow(10.0, doubleExp);
        }
        return doubleFactor;
    }

    public static class DMXPlayObject
    implements Playable.PlayObject {
        private Playable m_Playable;
        private long m_FramePosition;
        private long m_FramesToRead;
        private int m_FramesBuffered;
        private float m_ValueFactor;
        private float m_ValueFactorMax;
        private boolean m_EditMode;
        protected DMXScene.DMXSceneValueContainer m_DMXSceneValueContainer;

        public DMXPlayObject(Playable p_Playable) {
            this(p_Playable, false);
        }

        public DMXPlayObject(Playable p_Playable, boolean p_EditMode) {
            this.m_Playable = p_Playable;
            this.initMembers();
            this.m_EditMode = p_EditMode;
        }

        private void initMembers() {
            this.m_DMXSceneValueContainer = new DMXScene.DMXSceneValueContainer(null);
            this.m_FramePosition = 0L;
            this.m_FramesToRead = 0L;
            this.setFramesBuffered(1);
            this.m_ValueFactor = 1.0f;
            this.m_ValueFactorMax = 1.0f;
            this.m_EditMode = false;
        }

        public void close() {
            if (this.m_DMXSceneValueContainer != null) {
                this.m_DMXSceneValueContainer.close();
            }
        }

        public boolean getEditMode() {
            return this.m_EditMode;
        }

        @Override
        public Playable getPlayable() {
            return this.m_Playable;
        }

        @Override
        public void setFramePosition(long p_FramePosition) {
            this.m_FramePosition = p_FramePosition;
        }

        @Override
        public long getFramePosition() {
            return this.m_FramePosition;
        }

        @Override
        public void setFramesToRead(long p_FrameLength) {
            this.m_FramesToRead = p_FrameLength;
        }

        @Override
        public long getFramesToRead() {
            return this.m_FramesToRead;
        }

        @Override
        public void setFramesBuffered(int p_FramesBuffered) {
            this.m_FramesBuffered = p_FramesBuffered;
            if (this.m_DMXSceneValueContainer.getDeviceCount() != DMXDevice.getDMXDeviceCount()) {
                this.refreshDMXDevices();
            }
        }

        public void refreshDMXDevices() {
            for (int intDevice = 0; intDevice < DMXDevice.getDMXDeviceCount(); ++intDevice) {
                DMXDevice o_DMXDevice = DMXDevice.getDMXDevice(intDevice);
                if (o_DMXDevice == null) continue;
                this.m_DMXSceneValueContainer.addDMXDevice(o_DMXDevice);
            }
        }

        @Override
        public int getFramesBuffered() {
            return this.m_FramesBuffered;
        }

        @Override
        public Object getData() {
            return this.m_DMXSceneValueContainer;
        }

        @Override
        public void clear() {
            if (this.m_DMXSceneValueContainer != null) {
                this.m_DMXSceneValueContainer.clearDMXSceneLight(this.m_Playable);
            }
            this.m_ValueFactor = 1.0f;
            this.m_ValueFactorMax = 1.0f;
        }

        public DMXScene.DMXSceneValueContainer getDMXSceneValueContainer() {
            return this.m_DMXSceneValueContainer;
        }

        @Override
        public double getFadeProgress() {
            if (this.m_DMXSceneValueContainer == null) {
                return 0.0;
            }
            return this.m_DMXSceneValueContainer.getFadeProgress();
        }

        @Override
        public double getFadeInProgress() {
            if (this.m_DMXSceneValueContainer == null) {
                return 0.0;
            }
            return this.m_DMXSceneValueContainer.getFadeInProgress();
        }

        @Override
        public double getFadeOutProgress() {
            if (this.m_DMXSceneValueContainer == null) {
                return 0.0;
            }
            return this.m_DMXSceneValueContainer.getFadeOutProgress();
        }

        public int getDMXDeviceCount() {
            return this.m_DMXSceneValueContainer.getDeviceCount();
        }
    }
}

