/*
 * Decompiled with CFR 0.152.
 */
package DMXVirtualPackage;

import DMXDevicePackage.DMXDevice;
import DMXEffectsPackage.DMXEffect_PlayContainer;
import DMXScenePackage.DMXScene;
import DMXVirtualPackage.DMXFadeDescription;
import DMXVirtualPackage.LiveShowDMXObject;
import DMXVirtualPackage.LiveShowDMXObjectDescription;
import DMXVirtualPackage.LiveShowDMXVIP;
import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LanguageTools.LiveLanguagePackage.LiveLanguageString;
import LiveShowObjectPackage.LiveShowObjectDescription;
import LiveShowObjectPackage.LiveShowProjectDescription;
import LiveShowPlayPackage.Play;
import LiveShowPlayPackage.Playable;
import LiveShowVirtualPackage.LiveShowSceneBridge;
import LiveShowVirtualPackage.LiveShowVIP;
import PlayDMXPackage.PlayDMX;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;

public class LiveShowDMXSceneBridge
extends LiveShowSceneBridge {
    public static final int SOFTWAREVERSION = 1;
    @LiveLanguageString
    public static String s_BridgeRemoteGroupName = "Scene_DMX";
    private PlayDMX.DMXPlayObject m_DMXPlayObjectPre_StartStatus;
    private PlayDMX.DMXPlayObject m_DMXPlayObjectPre;
    private ArrayList<LiveShowDMXObject> m_LiveShowDMXObjectsLastRead;

    public LiveShowDMXSceneBridge(LiveShowDMXObjectDescription p_LiveShowObjectDescription) {
        super(p_LiveShowObjectDescription);
        this.initMembers();
        this.initMembersFurther(p_LiveShowObjectDescription);
        LiveLanguage.addLanguageListener((Object)this, null);
    }

    private void initMembers() {
        this.setObjectType(12);
        this.m_LiveShowDMXObjectsLastRead = new ArrayList(5);
    }

    private void initMembersFurther(LiveShowObjectDescription p_LiveShowObjectDescription) {
        super.setDescription(p_LiveShowObjectDescription);
        if (this.m_LiveShowVIP != null) {
            this.m_DMXPlayObjectPre = new PlayDMX.DMXPlayObject(this.m_LiveShowVIP);
            this.m_DMXPlayObjectPre.refreshDMXDevices();
            this.m_DMXPlayObjectPre_StartStatus = new PlayDMX.DMXPlayObject(this.m_LiveShowVIP);
            this.m_DMXPlayObjectPre_StartStatus.refreshDMXDevices();
        }
    }

    @Override
    public void setLiveShowVIP(LiveShowVIP p_LiveShowSoundVIP) {
        super.setLiveShowVIP(p_LiveShowSoundVIP);
        if (this.m_LiveShowVIP != null) {
            this.m_DMXPlayObjectPre = new PlayDMX.DMXPlayObject(this.m_LiveShowVIP);
            this.m_DMXPlayObjectPre.refreshDMXDevices();
            this.m_DMXPlayObjectPre.clear();
            this.m_DMXPlayObjectPre_StartStatus = new PlayDMX.DMXPlayObject(this.m_LiveShowVIP);
            this.m_DMXPlayObjectPre_StartStatus.refreshDMXDevices();
            this.m_DMXPlayObjectPre_StartStatus.clear();
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(1);
        this.m_Description.writeExternal(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int intSoftwareVersion = in.readInt();
        LiveShowDMXObjectDescription o_LiveShowDMXObjectDescription = LiveShowDMXObjectDescription.poolGet(false);
        o_LiveShowDMXObjectDescription.readExternal(in);
        this.initMembersFurther(o_LiveShowDMXObjectDescription);
    }

    @Override
    public boolean exportExternal(ObjectOutput out, LiveShowProjectDescription p_LiveShowProjectDescription, String p_ReplaceName) throws IOException {
        this.writeExternal(out);
        return true;
    }

    @Override
    public void setDescription(LiveShowObjectDescription p_Description) {
        if (p_Description == null) {
            return;
        }
        boolean boolEqualFadeDescription = true;
        this.initMembersFurther((LiveShowDMXObjectDescription)p_Description);
        if (!((LiveShowDMXObjectDescription)p_Description).getDMXFadeDescription().isEqual(((LiveShowDMXObjectDescription)this.m_Description).getDMXFadeDescription())) {
            boolEqualFadeDescription = false;
        }
        DMXFadeDescription o_DMXFadeDescription_Self = ((LiveShowDMXObjectDescription)this.m_Description).getDMXFadeDescription();
        DMXFadeDescription o_DMXFadeDescription_Param = ((LiveShowDMXObjectDescription)p_Description).getDMXFadeDescription();
        if (o_DMXFadeDescription_Param == null || o_DMXFadeDescription_Self == null) {
            return;
        }
        o_DMXFadeDescription_Param.copyTo(o_DMXFadeDescription_Self);
        o_DMXFadeDescription_Self.setToDefault();
        if (!boolEqualFadeDescription) {
            this.checkEqualsFadeSettingsToDefault();
            this.m_ChangedSinceLastAction = true;
            this.notifyObjectListeners_ObjectParameterChanged(this.m_Description);
        }
    }

    @Override
    public void close(boolean p_Finish) {
        super.close(p_Finish);
        if (this.m_DMXPlayObjectPre_StartStatus != null) {
            this.m_DMXPlayObjectPre_StartStatus.close();
        }
        if (this.m_DMXPlayObjectPre != null) {
            this.m_DMXPlayObjectPre.close();
        }
    }

    public DMXScene.DMXSceneValueContainer getPreDMXSceneValueContainer() {
        if (this.m_DMXPlayObjectPre_StartStatus == null) {
            return null;
        }
        return this.m_DMXPlayObjectPre_StartStatus.getDMXSceneValueContainer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Playable.PlayObject read(Play p_Play, Playable.PlayObject p_PlayObject, LiveShowSceneBridge p_LiveShowSceneBridge, long p_SceneBridgeFrameInside, double p_SceneBridgeFadeProgress, boolean p_IsPreObject) {
        if (p_Play == null) {
            return null;
        }
        if (p_PlayObject == null) {
            return null;
        }
        if (p_PlayObject.getFramePosition() < 0L) {
            return null;
        }
        if (p_PlayObject.getData() == null) {
            return null;
        }
        if (!(p_PlayObject instanceof PlayDMX.DMXPlayObject)) {
            return null;
        }
        if (this.m_LiveShowVIP == null) {
            return null;
        }
        PlayDMX.DMXPlayObject o_DMXPlayObject = (PlayDMX.DMXPlayObject)p_PlayObject;
        if (o_DMXPlayObject == null) {
            return null;
        }
        if (this.m_Play == null) {
            return null;
        }
        DMXEffect_PlayContainer o_DMXEffect_PlayContainer = ((PlayDMX)p_Play).getDMXEffect_PlayContainer();
        boolean boolBridgeStarted = false;
        if (!this.m_IsPlaying) {
            this.m_IsPlaying = true;
            boolBridgeStarted = true;
            this.setFramePositionPre(o_DMXPlayObject.getFramePosition());
            if (p_Play.isRunning()) {
                this.m_Play.setPlayCursor(this.m_Description.getFrameStart());
                o_DMXPlayObject.setFramePosition(this.m_Description.getFrameStart());
            }
            if (this.m_DMXPlayObjectPre_StartStatus == null) {
                this.m_DMXPlayObjectPre_StartStatus = new PlayDMX.DMXPlayObject(this.m_LiveShowVIP);
            }
            if (this.m_DMXPlayObjectPre_StartStatus.getFramesBuffered() != o_DMXPlayObject.getFramesBuffered()) {
                this.m_DMXPlayObjectPre_StartStatus.setFramesBuffered(o_DMXPlayObject.getFramesBuffered());
            }
            this.m_DMXPlayObjectPre_StartStatus.clear();
            this.m_DMXPlayObjectPre_StartStatus.setFramePosition(this.getFramePositionPre());
            this.m_DMXPlayObjectPre_StartStatus.setFramesToRead(o_DMXPlayObject.getFramesToRead());
            this.m_DMXPlayObjectPre_StartStatus = (PlayDMX.DMXPlayObject)this.readInternal_FromChannels(this.m_DMXPlayObjectPre_StartStatus, this, true);
            this.m_DMXPlayObjectPre_StartStatus.getDMXSceneValueContainer().setPanTilt_VirtualPointFromAngles();
            Object object = LiveShowDMXVIP.s_SyncDMXObjects_LastRead;
            synchronized (object) {
                this.m_LiveShowDMXObjectsLastRead.clear();
                this.m_LiveShowDMXObjectsLastRead.addAll(LiveShowDMXVIP.s_LiveShowDMXObjects_LastRead);
            }
            ((LiveShowDMXVIP)this.m_LiveShowVIP).getLiveShowDMXVIPAdjustment().calculateAdjustmentSceneBridgeStarted(this, this.m_LiveShowDMXObjectsLastRead);
        }
        if (!this.isCursorPositionInside(o_DMXPlayObject.getFramePosition())) {
            if (this.m_IsPlaying) {
                this.stopSceneBridge();
                this.m_IsPlaying = false;
            }
            Playable.PlayObject o_ResultPlayObject = this.m_LiveShowVIP.readInternal(p_Play, o_DMXPlayObject, null, -1L, 1.0, false);
            return o_ResultPlayObject;
        }
        long longFrameInside = p_PlayObject.getFramePosition() - this.getFrameStart();
        if (this.m_DMXPlayObjectPre == null) {
            this.m_DMXPlayObjectPre = new PlayDMX.DMXPlayObject(this.m_LiveShowVIP);
        }
        if (this.m_DMXPlayObjectPre.getFramesBuffered() != o_DMXPlayObject.getFramesBuffered()) {
            this.m_DMXPlayObjectPre.setFramesBuffered(o_DMXPlayObject.getFramesBuffered());
        }
        this.m_DMXPlayObjectPre.clear();
        this.m_DMXPlayObjectPre.setFramePosition(this.getFramePositionPre());
        this.m_DMXPlayObjectPre.setFramesToRead(o_DMXPlayObject.getFramesToRead());
        double doubleFadeInProgress = 1.0;
        double doubleFadeOutProgress = 1.0;
        doubleFadeOutProgress = this.calculateFadeProgress(longFrameInside, o_DMXPlayObject.getFramesToRead(), false, true);
        this.m_DMXPlayObjectPre.getDMXSceneValueContainer().fillPlayObject_DMXSceneBridgePre(this, this.m_LiveShowDMXObjectsLastRead, this.m_DMXPlayObjectPre_StartStatus.getDMXSceneValueContainer(), this.m_Description.getVolumeFactor_Linear(), doubleFadeOutProgress, false, true);
        this.m_DMXPlayObjectPre_StartStatus.setFramePosition(this.getFramePositionPre());
        if (o_DMXEffect_PlayContainer.getDMXEffectObjectCount() > 0) {
            o_DMXEffect_PlayContainer.read(false, p_PlayObject.getFramePosition(), this, this.m_DMXPlayObjectPre, this.m_DMXPlayObjectPre_StartStatus, this.m_Description.getVolumeFactor_Linear(), doubleFadeOutProgress, false, true);
        }
        doubleFadeInProgress = this.calculateFadeProgress(longFrameInside, o_DMXPlayObject.getFramesToRead(), true, false);
        PlayDMX.DMXPlayObject o_DMXPlayObjectPost = (PlayDMX.DMXPlayObject)this.m_LiveShowVIP.readInternal(p_Play, o_DMXPlayObject, this, longFrameInside, doubleFadeInProgress, false);
        PlayDMX.DMXPlayObject o_ResultPlayObject = (PlayDMX.DMXPlayObject)PlayDMX.mixDMXSceneBridgePlayObjects(o_DMXPlayObject, this.m_DMXPlayObjectPre, doubleFadeOutProgress);
        ((LiveShowDMXVIP)this.m_LiveShowVIP).getLiveShowDMXVIPAdjustment().readInternal(p_Play, o_DMXPlayObject, this, longFrameInside, 1.0, p_IsPreObject);
        this.setFramePositionPre(this.getFramePositionPre() + p_PlayObject.getFramesToRead());
        Play.PlaySynchronisizer o_PlaySynchronisizer = this.m_Play.getPlaySynchronizer();
        if (o_PlaySynchronisizer != null) {
            // empty if block
        }
        if (!this.m_LiveShowVIP.getActive()) {
            return null;
        }
        return o_ResultPlayObject;
    }

    public Playable.PlayObject readInternal_FromChannels(Playable.PlayObject p_PlayObject, LiveShowSceneBridge p_LiveShowSceneBridge, boolean p_IsPreObject) {
        if (p_PlayObject == null) {
            return null;
        }
        if (p_PlayObject.getFramePosition() < 0L) {
            return null;
        }
        if (p_PlayObject.getData() == null) {
            return null;
        }
        if (!(p_PlayObject instanceof PlayDMX.DMXPlayObject)) {
            return null;
        }
        if (!p_IsPreObject) {
            return null;
        }
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return null;
        }
        PlayDMX.DMXPlayObject o_DMXPlayObject = (PlayDMX.DMXPlayObject)p_PlayObject;
        DMXScene.DMXSceneValueContainer o_PlayObjectValueContainer = o_DMXPlayObject.getDMXSceneValueContainer();
        for (int intDevice = 0; intDevice < DMXDevice.getDMXDeviceCount(); ++intDevice) {
            DMXScene.DMXSceneDeviceValues o_DMXSceneDeviceValues;
            DMXDevice o_DMXDevice = DMXDevice.getDMXDevice(intDevice);
            if (o_DMXDevice == null || (o_DMXSceneDeviceValues = o_PlayObjectValueContainer.getDMXSceneDeviceValues(o_DMXDevice.getID())) == null) continue;
            o_DMXSceneDeviceValues.copyValuesNewFromChannels();
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return p_PlayObject;
    }

    private double calculateFadeProgress(long p_FramePositionInside, long p_FramesLength, boolean p_FadeIn, boolean p_FadeOut) {
        boolean boolInside = false;
        double doubleFactor = 1.0;
        long longFramePositionInside = p_FramePositionInside;
        if (longFramePositionInside > 0L && longFramePositionInside < this.m_Description.getFrameStart() + this.m_Description.getFrameLength()) {
            boolInside = true;
        }
        if (boolInside = true) {
            if (!p_FadeIn) {
                if (this.m_Description.getFrameFadeOutLength() - this.m_Description.getFrameFadeOutOffset() > 0L && longFramePositionInside <= this.m_Description.getFrameFadeOutLength()) {
                    if (longFramePositionInside > this.m_Description.getFrameFadeOutOffset()) {
                        doubleFactor = (double)(this.m_Description.getFrameFadeOutLength() - longFramePositionInside) / (double)(this.m_Description.getFrameFadeOutLength() - this.m_Description.getFrameFadeOutOffset());
                    }
                } else {
                    doubleFactor = longFramePositionInside >= this.m_Description.getFrameFadeOutOffset() ? 0.0 : 1.0;
                }
            } else {
                long longPositionFromEnd = this.m_Description.getFrameLength() - longFramePositionInside;
                if (longPositionFromEnd < 0L) {
                    doubleFactor = 1.0;
                } else if (this.m_Description.getFrameFadeInLength() - this.m_Description.getFrameFadeInOffset() > 0L && longPositionFromEnd <= this.m_Description.getFrameFadeInLength()) {
                    if (longPositionFromEnd > this.m_Description.getFrameFadeInOffset()) {
                        doubleFactor = (double)(this.m_Description.getFrameFadeInLength() - longPositionFromEnd) / (double)(this.m_Description.getFrameFadeInLength() - this.m_Description.getFrameFadeInOffset());
                    }
                } else {
                    doubleFactor = longPositionFromEnd > this.m_Description.getFrameFadeInOffset() ? 0.0 : 1.0;
                }
            }
        } else {
            doubleFactor = 0.0;
        }
        if (doubleFactor > 1.0) {
            doubleFactor = 1.0;
        }
        if (doubleFactor < 0.0) {
            doubleFactor = 0.0;
        }
        return doubleFactor;
    }

    public DMXFadeDescription getDMXFadeDescription() {
        return ((LiveShowDMXObjectDescription)this.m_Description).getDMXFadeDescription();
    }

    @Override
    public double getFrameTime() {
        return LiveShowDMXVIP.FRAMETIME;
    }

    public boolean checkEqualsFadeSettingsToDefault() {
        ((LiveShowDMXObjectDescription)this.m_Description).checkEqualsFadeSettingsToDefault();
        return this.m_Description.isEqualDefaultSettings();
    }

    @Override
    public void setSource(Object p_SourceObject) {
    }

    @Override
    public Object getSource() {
        return null;
    }

    @Override
    public String getSourceAdditionalInfo() {
        return null;
    }

    @Override
    public ComboBoxModel getSourceListModel() {
        return null;
    }

    @Override
    public boolean getSourceIsReplaceable() {
        return false;
    }

    @Override
    public DefaultListCellRenderer getSourceListRenderer() {
        return null;
    }

    @Override
    public boolean getFrameOffsetAbility() {
        return false;
    }

    @Override
    public void notifyObjectListeners_ObjectParameterChanged(LiveShowObjectDescription p_LiveShowObjectDescription) {
        super.notifyObjectListeners_ObjectParameterChanged(p_LiveShowObjectDescription);
    }

    @Override
    public void eventEndOfAction(LiveShowVIP p_ActorLiveShowVIP, boolean p_Success, int p_Action) {
        super.eventEndOfAction(p_ActorLiveShowVIP, p_Success, p_Action);
    }

    @Override
    public String getRemoteGroupName() {
        return s_BridgeRemoteGroupName;
    }
}

