/*
 * Decompiled with CFR 0.152.
 */
package DMXVirtualPackage;

import DMXDevicePackage.DMXDevice;
import DMXEffectsPackage.DMXEffect;
import DMXEffectsPackage.DMXEffect_Function;
import DMXEffectsPackage.DMXEffect_PlayContainer;
import DMXEffectsPackage.LiveShowDMXObjectEffectSettingsPanel;
import DMXMixer.DMXControlComponent;
import DMXMixer.DMXControlDescription;
import DMXScenePackage.DMXScene;
import DMXVirtualPackage.DMXFadeDescription;
import DMXVirtualPackage.LiveShowDMXObjectCopyInterface;
import DMXVirtualPackage.LiveShowDMXObjectDescription;
import DMXVirtualPackage.LiveShowDMXObjectPanel;
import DMXVirtualPackage.LiveShowDMXVIP;
import DMXVirtualPackage.LiveShowDMXVIPAdjustment;
import Icons.IconManager;
import LanguageTools.LiveLanguagePackage.LiveLanguageString;
import LiveShowControlModels.ControlLabelModel;
import LiveShowControlObjects.ControlObject;
import LiveShowObjectPackage.LiveShowObject;
import LiveShowObjectPackage.LiveShowObjectDescription;
import LiveShowObjectPackage.LiveShowObjectInterface;
import LiveShowObjectPackage.LiveShowObjectPanel;
import LiveShowObjectPackage.LiveShowProjectDescription;
import LiveShowPlayPackage.Play;
import LiveShowPlayPackage.Playable;
import LiveShowVirtualPackage.LiveShowSceneBridge;
import LiveShowVirtualPackage.LiveShowVIP;
import PlayDMXPackage.PlayDMX;
import StartPackage.LiveShowDMXSystem;
import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;

public class LiveShowDMXObject
extends LiveShowObject
implements DMXFadeDescription.DMXFadeDescriptionListener {
    public static final int SOFTWAREVERSION = 1;
    @LiveLanguageString
    public static String DEFAULT_DMXOBJECTNAME = "Object";
    public static ImageIcon s_Icon = IconManager.getImageIcon("DMX.png");
    public static LiveShowDMXObjectEffectSettingsPanel s_DMXObjectEffectSettingsPanel = new LiveShowDMXObjectEffectSettingsPanel();
    private DMXScene m_DMXScene;
    private DMXEffect m_DMXEffect;
    private DMXEffect_Function.StepFactor m_DMXEffect_StepFactor;
    private boolean m_Closing;

    public LiveShowDMXObject(LiveShowObjectDescription p_Description) {
        super(p_Description);
        this.initMembers();
        this.initMembersFurther((LiveShowDMXObjectDescription)p_Description);
    }

    public DMXDevice getOnlyForDMXDevice() {
        return null;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(1);
        ((LiveShowDMXObjectDescription)this.m_Description).writeExternal(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int intSoftwareVersion = in.readInt();
        LiveShowDMXObjectDescription o_LiveShowObjectDescription = LiveShowDMXObjectDescription.poolGet(true);
        o_LiveShowObjectDescription.readExternal(in);
        DMXScene o_DMXScene = DMXScene.getDMXScene(o_LiveShowObjectDescription.getSourceString());
        if (o_DMXScene != null) {
            o_LiveShowObjectDescription.setSourceName(o_DMXScene.getName());
        } else {
            o_LiveShowObjectDescription.setSourceName("");
        }
        this.initMembersFurther(o_LiveShowObjectDescription);
    }

    @Override
    public boolean exportExternal(ObjectOutput out, LiveShowProjectDescription p_LiveShowProjectDescription, String p_ReplaceName) throws IOException {
        this.writeExternal(out);
        return true;
    }

    private void initMembersFurther(LiveShowDMXObjectDescription p_Description) {
        if (p_Description == null) {
            return;
        }
        super.setDescription(p_Description);
        this.setSource(DMXScene.getDMXScene(p_Description.getSourceString()));
        DMXFadeDescription o_DMXFadeDescription = ((LiveShowDMXObjectDescription)this.m_Description).getDMXFadeDescription();
        if (o_DMXFadeDescription != null) {
            o_DMXFadeDescription.addDMXFadeDescriptionListener(this);
        }
        if (!(this instanceof LiveShowDMXVIPAdjustment.DMXDeviceAdjustObject)) {
            this.checkEqualsFadeSettingsToDefault();
        }
        this.setDMXEffect(DMXEffect.getDMXEffect(p_Description.getEffectSourceString()));
    }

    @Override
    public void setDescription(LiveShowObjectDescription p_Description) {
        if (p_Description == null) {
            return;
        }
        boolean boolEqualFadeDescription = true;
        this.initMembersFurther((LiveShowDMXObjectDescription)p_Description);
        DMXFadeDescription o_DMXFadeDescription_Self = ((LiveShowDMXObjectDescription)this.m_Description).getDMXFadeDescription();
        DMXFadeDescription o_DMXFadeDescription = ((LiveShowDMXObjectDescription)p_Description).getDMXFadeDescription();
        if (o_DMXFadeDescription == null) {
            return;
        }
        if (!(this instanceof LiveShowDMXVIPAdjustment.DMXDeviceAdjustObject) && !o_DMXFadeDescription.isEqual(o_DMXFadeDescription_Self)) {
            boolEqualFadeDescription = false;
        }
        o_DMXFadeDescription.copyTo(o_DMXFadeDescription_Self);
        if (!boolEqualFadeDescription) {
            this.m_ChangedSinceLastAction = true;
            this.checkEqualsFadeSettingsToDefault();
            this.notifyObjectListeners_ObjectParameterChanged(this.m_Description);
        }
    }

    private void initMembers() {
        this.m_Closing = false;
        this.setObjectType(11);
        this.m_DMXEffect_StepFactor = new DMXEffect_Function.StepFactor();
    }

    @Override
    public void close(boolean p_Finish) {
        DMXFadeDescription o_DMXFadeDescription;
        if (this.m_Closing) {
            return;
        }
        this.m_Closing = true;
        LiveShowDMXObjectDescription o_LiveShowDMXObjectDescription = (LiveShowDMXObjectDescription)this.m_Description;
        if (o_LiveShowDMXObjectDescription != null && (o_DMXFadeDescription = o_LiveShowDMXObjectDescription.getDMXFadeDescription()) != null) {
            o_DMXFadeDescription.removeDMXFadeDescriptionListener(this);
        }
        if (this.m_DMXScene != null) {
            this.m_DMXScene.removePropertyChangeListener(this);
            this.m_DMXScene.removeLiveShowDMXObject(this);
            this.m_DMXScene = null;
        }
        if (this.m_DMXEffect != null) {
            this.m_DMXEffect.removePropertyChangeListener(this);
            this.m_DMXEffect.removeLiveShowDMXObject(this);
            this.m_DMXEffect = null;
        }
        super.close(p_Finish);
    }

    public static void printtestTime(String p_FunctionName, long p_TimeStart) {
        long testDuration = System.nanoTime() - p_TimeStart;
        System.out.println(p_FunctionName + "  " + testDuration);
    }

    @Override
    public void reactivate(LiveShowObjectDescription p_LiveShowDMXObjectDescription) {
        this.m_LiveCloseSemaphore.refresh();
        this.m_Closing = false;
        if (p_LiveShowDMXObjectDescription == null) {
            this.m_Description = LiveShowDMXObjectDescription.poolGet();
            this.m_Description.setObjectType(11);
        } else {
            this.m_Description = p_LiveShowDMXObjectDescription.clone(null);
        }
        this.m_IsSelected = false;
        this.m_Overlap = false;
        this.m_SendNotification = true;
        this.m_ChangedSinceLastAction = false;
        this.setDescription(p_LiveShowDMXObjectDescription);
    }

    @Override
    public LiveShowVIP getLiveShowVIP() {
        return LiveShowDMXSystem.getLiveShowDMXVIP();
    }

    public DMXScene getDMXScene() {
        return this.m_DMXScene;
    }

    public void setDMXScene(DMXScene p_DMXScene) {
        if (p_DMXScene == null) {
            return;
        }
        if (p_DMXScene == this.m_DMXScene) {
            return;
        }
        if (this.m_DMXScene != null) {
            this.m_DMXScene.removePropertyChangeListener(this);
            this.m_DMXScene.removeLiveShowDMXObject(this);
        }
        this.m_DMXScene = p_DMXScene;
        if (this.m_DMXScene != null) {
            this.m_Description.setSourceString(this.m_DMXScene.getID());
            this.m_Description.setSourceName(this.m_DMXScene.getName());
            this.m_DMXScene.addPropertyChangeListener(this);
            this.m_DMXScene.addLiveShowDMXObject(this);
            this.m_ChangedSinceLastAction = true;
            this.notifyObjectListeners_ObjectParameterChanged(this.m_Description);
        }
    }

    public boolean checkEqualsFadeSettingsToDefault() {
        boolean oldEqualDefaultSettings = this.m_Description.isEqualDefaultSettings();
        ((LiveShowDMXObjectDescription)this.m_Description).checkEqualsFadeSettingsToDefault();
        if (this.m_Description.isEqualDefaultSettings() != oldEqualDefaultSettings) {
            this.notifyObjectListeners_ObjectAdditionalChanged(this.m_Description);
        }
        return this.m_Description.isEqualDefaultSettings();
    }

    public void setDMXEffect(DMXEffect p_DMXEffect) {
        if (p_DMXEffect == this.m_DMXEffect) {
            return;
        }
        if (this.m_DMXEffect != null) {
            this.m_DMXEffect.removePropertyChangeListener(this);
            this.m_DMXEffect.removeLiveShowDMXObject(this);
        }
        this.m_DMXEffect = p_DMXEffect;
        if (this.m_DMXEffect != null) {
            this.m_Description.setEffectSourceString(this.m_DMXEffect.getID());
            this.m_DMXEffect.addPropertyChangeListener(this);
            this.m_DMXEffect.addLiveShowDMXObject(this);
        } else {
            this.m_Description.setEffectSourceString(null);
        }
        this.m_ChangedSinceLastAction = true;
        this.notifyObjectListeners_ObjectParameterChanged(this.m_Description);
    }

    public DMXEffect getDMXEffect() {
        return this.m_DMXEffect;
    }

    @Override
    public String getEffectName() {
        DMXEffect o_DMXEffect = this.m_DMXEffect;
        if (o_DMXEffect == null) {
            return null;
        }
        return o_DMXEffect.getName();
    }

    public long getDMXEffectDelay() {
        return DMXEffect.getDelay(this.m_Description.getEffectParameters());
    }

    public long setDMXEffectDelay(long p_Frames) {
        if (DMXEffect.getDelay(this.m_Description.getEffectParameters()) != p_Frames) {
            DMXEffect.setDelay(this.m_DMXEffect, p_Frames, this.m_Description.getEffectParameters());
            this.notifyObjectListeners_ObjectParameterChanged(this.m_Description);
        }
        return DMXEffect.getDelay(this.m_Description.getEffectParameters());
    }

    public long getDMXEffectDuration() {
        return DMXEffect.getDuration(this.m_Description.getEffectParameters());
    }

    public long setDMXEffectDuration(long p_Frames) {
        if (DMXEffect.getDuration(this.m_Description.getEffectParameters()) != p_Frames) {
            DMXEffect.setDuration(this.m_DMXEffect, p_Frames, this.m_Description.getEffectParameters());
            this.notifyObjectListeners_ObjectParameterChanged(this.m_Description);
        }
        return DMXEffect.getDuration(this.m_Description.getEffectParameters());
    }

    public long getDMXEffectLoops() {
        return DMXEffect.getLoops(this.m_Description.getEffectParameters());
    }

    public long setDMXEffectLoops(long p_Loops) {
        if (DMXEffect.getLoops(this.m_Description.getEffectParameters()) != p_Loops) {
            DMXEffect.setLoops(this.m_DMXEffect, p_Loops, this.m_Description.getEffectParameters());
            this.notifyObjectListeners_ObjectParameterChanged(this.m_Description);
        }
        return DMXEffect.getLoops(this.m_Description.getEffectParameters());
    }

    public int getDMXEffectTrigger() {
        return DMXEffect.getTrigger(this.m_Description.getEffectParameters());
    }

    public int setDMXEffectTrigger(int p_Trigger) {
        if (DMXEffect.getTrigger(this.m_Description.getEffectParameters()) != p_Trigger) {
            DMXEffect.setTrigger(this.m_DMXEffect, p_Trigger, this.m_Description.getEffectParameters());
            this.notifyObjectListeners_ObjectParameterChanged(this.m_Description);
        }
        return DMXEffect.getTrigger(this.m_Description.getEffectParameters());
    }

    public void setDMXEffectParameters(ArrayList<Double> p_DMXEffectParamters) {
        if (this.m_Description.setEffectParameters(p_DMXEffectParamters)) {
            this.notifyObjectListeners_ObjectParameterChanged(this.m_Description);
        }
    }

    public ArrayList<Double> getDMXEffectParameters() {
        return this.m_Description.getEffectParameters();
    }

    public DMXEffect_Function.StepFactor getDMXEffect_StepFactor() {
        return this.m_DMXEffect_StepFactor;
    }

    public long getFrameDuration_consumption(DMXDevice p_DMXDevice, DMXControlComponent p_DMXControlComponent, int p_ControlIndex, int p_DimensionIndex) {
        DMXEffect o_DMXEffect;
        if (p_DMXControlComponent == null) {
            return 0L;
        }
        long longFrameDuration = 0L;
        int intStepsIsOn = 0;
        DMXScene o_DMXScene = this.m_DMXScene;
        if (o_DMXScene == null) {
            return longFrameDuration;
        }
        if (o_DMXScene.getValue(p_DMXDevice, p_DMXControlComponent.getDMXControlType(), p_ControlIndex, p_DimensionIndex) > 0.0) {
            longFrameDuration += this.getFrameLength();
        }
        if ((o_DMXEffect = this.m_DMXEffect) != null) {
            double doubleEffectLoops;
            DMXEffect.DMXDeviceElement o_DMXDeviceElement = o_DMXEffect.getDMXDeviceElement(p_DMXDevice);
            if (o_DMXDeviceElement == null) {
                return longFrameDuration;
            }
            DMXEffect_Function o_DMXEffect_Function = "rgbcmy".equals(p_DMXControlComponent.getDMXControlType().getDMXControlDescription().getID()) ? o_DMXEffect.getDMXEffect_Function("rgbcmy") : o_DMXEffect.getDMXEffect_Function("dimmer");
            if (o_DMXEffect_Function == null) {
                return longFrameDuration;
            }
            for (int intStep = 0; intStep < o_DMXEffect_Function.getStepCount(); ++intStep) {
                if (!(o_DMXEffect_Function.getValue(intStep, p_DMXControlComponent, p_ControlIndex, p_DimensionIndex) > 0.0)) continue;
                ++intStepsIsOn;
            }
            if (this.getDMXEffectLoops() <= 0L) {
                longFrameDuration = 0L;
                doubleEffectLoops = ((double)this.getFrameLength() - (double)this.getDMXEffectDelay()) / (double)this.getDMXEffectDuration();
            } else {
                if (this.getDMXEffectDelay() + this.getDMXEffectDuration() * this.getDMXEffectLoops() > this.getFrameLength()) {
                    doubleEffectLoops = ((double)this.getFrameLength() - (double)this.getDMXEffectDelay()) / (double)this.getDMXEffectDuration();
                    longFrameDuration = 0L;
                } else {
                    doubleEffectLoops = this.getDMXEffectLoops();
                    longFrameDuration -= (long)((double)this.getDMXEffectDelay() + (double)this.getDMXEffectDuration() * doubleEffectLoops);
                }
                if (longFrameDuration < 0L) {
                    longFrameDuration = 0L;
                }
            }
            longFrameDuration += (long)((double)this.getDMXEffectDuration() / (double)o_DMXEffect_Function.getStepCount() * (double)intStepsIsOn * doubleEffectLoops);
        }
        return longFrameDuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Playable.PlayObject read(Play p_Play, Playable.PlayObject p_PlayObject, LiveShowSceneBridge p_LiveShowSceneBridge, long p_SceneBridgeFrameInside, double p_SceneBridgeFadeProgress, boolean p_IsPreObject) {
        if (p_Play == null) {
            this.m_IsPlaying = false;
            return null;
        }
        if (p_PlayObject == null) {
            this.m_IsPlaying = false;
            return null;
        }
        if (p_PlayObject.getData() == null) {
            this.m_IsPlaying = false;
            return null;
        }
        boolean boolFadeIn = false;
        boolean boolFadeOut = false;
        DMXScene o_DMXScene = this.m_DMXScene;
        if (o_DMXScene == null) {
            return null;
        }
        LiveShowDMXVIP o_LiveShowDMXVIP = LiveShowDMXSystem.getLiveShowDMXVIP();
        if (o_LiveShowDMXVIP != null && !o_LiveShowDMXVIP.getActive()) {
            return null;
        }
        if (!p_IsPreObject) {
            Object object = LiveShowDMXVIP.s_SyncDMXObjects_LastRead;
            synchronized (object) {
                LiveShowDMXVIP.s_LiveShowDMXObjects_LastRead.add(this);
            }
        }
        if (p_LiveShowSceneBridge != null) {
            if (p_LiveShowSceneBridge.isCursorPositionInside(this.getFrameStart()) && p_LiveShowSceneBridge.isCursorPositionInside(this.getFrameStart() + this.getFrameLength() - 1L)) {
                if (p_IsPreObject) {
                    return null;
                }
            } else if (p_IsPreObject) {
                if (p_LiveShowSceneBridge.isCursorPositionInside(this.getFrameStart()) && p_PlayObject.getFramePosition() < p_LiveShowSceneBridge.getFrameStart() + p_LiveShowSceneBridge.getFrameLength()) {
                    return null;
                }
                LiveShowSceneBridge o_ExcludedLiveShowSceneBridge = p_LiveShowSceneBridge.getLiveShowVIP().getLiveShowSceneBridge_Exluded();
                if (o_ExcludedLiveShowSceneBridge != null && this.getFrameStart() >= o_ExcludedLiveShowSceneBridge.getFrameStart()) {
                    return null;
                }
            } else if (p_LiveShowSceneBridge.isCursorPositionInside(this.getFrameStart() + this.getFrameLength() - 1L)) {
                return null;
            }
            if (p_IsPreObject) {
                boolFadeOut = true;
            } else {
                boolFadeIn = true;
            }
        }
        if (!this.m_LiveCloseSemaphore.enterWorkerSection()) {
            return null;
        }
        PlayDMX.DMXPlayObject o_DMXPlayObject = (PlayDMX.DMXPlayObject)p_PlayObject;
        DMXScene.DMXSceneValueContainer o_DMXSceneValueContainer = o_DMXScene.getDMXSceneValueContainer();
        if (o_DMXSceneValueContainer == null) {
            this.m_LiveCloseSemaphore.leaveWorkerSection();
            return null;
        }
        DMXScene.DMXSceneValueContainer o_PlayObjectValueContainer = o_DMXPlayObject.getDMXSceneValueContainer();
        long longFramePosition = o_DMXPlayObject.getFramePosition();
        long longFramesToRead = o_DMXPlayObject.getFramesToRead();
        if (longFramePosition < this.m_Description.getFrameStart()) {
            this.m_LiveCloseSemaphore.leaveWorkerSection();
            o_PlayObjectValueContainer.setFadeInProgress(0.0);
            o_PlayObjectValueContainer.setFadeOutProgress(0.0);
            o_PlayObjectValueContainer.setFadeProgress(0.0);
            this.m_IsPlaying = false;
            return null;
        }
        if (longFramePosition >= this.m_Description.getFrameStart() + this.getFrameLengthToPlay()) {
            this.m_LiveCloseSemaphore.leaveWorkerSection();
            o_PlayObjectValueContainer.setFadeInProgress(0.0);
            o_PlayObjectValueContainer.setFadeOutProgress(0.0);
            o_PlayObjectValueContainer.setFadeProgress(0.0);
            this.m_IsPlaying = false;
            return null;
        }
        this.m_IsPlaying = true;
        if (o_DMXScene == null) {
            this.m_LiveCloseSemaphore.leaveWorkerSection();
            return null;
        }
        boolean boolInside = false;
        double doubleFadeInFactor = 1.0;
        double doubleFadeOutFactor = 0.0;
        double doubleFadeFactor = 1.0;
        float floatVolumeFactor = 1.0f;
        long longFramePositionInside = longFramePosition - this.m_Description.getFrameStart();
        if (longFramePositionInside > 0L || longFramePositionInside < this.getFrameLengthToPlay()) {
            boolInside = true;
        }
        if (boolInside) {
            long longFrameFromEndPosition = this.getFrameLengthToPlay() - longFramePositionInside;
            long longFrameFromStartPosition = longFramePositionInside > this.getFrameLengthToPlay() - this.m_Description.getFrameFadeOutLength() ? this.getFrameLengthToPlay() - this.m_Description.getFrameFadeOutLength() : longFramePositionInside;
            floatVolumeFactor = this.m_Description.getVolumeFactor_Linear();
            doubleFadeInFactor = 1.0;
            if (this.m_Description.getFrameFadeInLength() > 0L && longFrameFromStartPosition < this.m_Description.getFrameFadeInLength()) {
                doubleFadeInFactor = (double)longFrameFromStartPosition / (double)this.m_Description.getFrameFadeInLength();
                if (doubleFadeInFactor > 1.0) {
                    doubleFadeInFactor = 1.0;
                }
                if (doubleFadeInFactor < 0.0) {
                    doubleFadeInFactor = 0.0;
                }
                boolFadeIn = true;
            }
            doubleFadeOutFactor = 1.0;
            if (longFrameFromEndPosition < 0L) {
                longFrameFromEndPosition = 0L;
            }
            if (this.m_Description.getFrameFadeOutLength() > 0L && longFrameFromEndPosition < this.m_Description.getFrameFadeOutLength()) {
                doubleFadeOutFactor = p_Play.getWillStopAtSceneBridge() != null ? 0.0 : (double)longFrameFromEndPosition / (double)this.m_Description.getFrameFadeOutLength();
                if (doubleFadeOutFactor > 1.0) {
                    doubleFadeOutFactor = 1.0;
                }
                if (doubleFadeOutFactor < 0.0) {
                    doubleFadeOutFactor = 0.0;
                }
                boolFadeOut = true;
            }
        } else {
            doubleFadeFactor = 0.0;
            boolFadeIn = false;
            boolFadeOut = false;
        }
        doubleFadeFactor = doubleFadeInFactor * doubleFadeOutFactor;
        o_PlayObjectValueContainer.setFadeInProgress(doubleFadeInFactor);
        o_PlayObjectValueContainer.setFadeOutProgress(doubleFadeOutFactor);
        o_PlayObjectValueContainer.setFadeProgress(doubleFadeFactor);
        boolean boolReadDMXEffect = false;
        DMXEffect o_DMXEffect = this.m_DMXEffect;
        if (o_DMXEffect != null) {
            boolReadDMXEffect = true;
            o_DMXEffect.readLiveShowDMXObject(this, o_DMXPlayObject, longFramePositionInside, o_DMXSceneValueContainer, floatVolumeFactor, doubleFadeFactor * p_SceneBridgeFadeProgress, boolFadeIn, boolFadeOut);
            DMXEffect_PlayContainer o_DMXEffect_PlayContainer = ((PlayDMX)p_Play).getDMXEffect_PlayContainer();
            DMXEffect_PlayContainer.DMXEffectObject o_DMXEffectObject = o_DMXEffect_PlayContainer.addDMXEffectObject(this);
            if (o_DMXEffectObject != null && p_LiveShowSceneBridge != null) {
                o_DMXEffectObject.setOnlyAdjustment(true);
            }
        }
        if (!boolReadDMXEffect) {
            o_PlayObjectValueContainer.fillPlayObject_DMXObject(this, o_DMXSceneValueContainer, floatVolumeFactor, doubleFadeFactor * p_SceneBridgeFadeProgress, boolFadeIn, boolFadeOut);
        }
        this.m_LiveCloseSemaphore.leaveWorkerSection();
        return p_PlayObject;
    }

    @Override
    public LiveShowObjectPanel createLiveShowObjectPanel(boolean p_Resizable) {
        LiveShowDMXObjectPanel o_LiveShowDMXObjectPanel = new LiveShowDMXObjectPanel(this, p_Resizable);
        return o_LiveShowDMXObjectPanel;
    }

    @Override
    public long getSourceFrameLength() {
        return -1L;
    }

    public DMXFadeDescription getDMXFadeDescription() {
        return ((LiveShowDMXObjectDescription)this.m_Description).getDMXFadeDescription();
    }

    @Override
    public void refreshJumps() {
    }

    @Override
    public double getFrameTime() {
        return LiveShowVIP.FRAMETIME;
    }

    @Override
    public ImageIcon getImageIcon() {
        return s_Icon;
    }

    @Override
    public void setSource(Object p_SourceObject) {
        if (p_SourceObject == null) {
            return;
        }
        if (p_SourceObject instanceof DMXScene) {
            this.setDMXScene((DMXScene)p_SourceObject);
        }
    }

    @Override
    public Object getSource() {
        return this.m_DMXScene;
    }

    @Override
    public String createToolTipText(boolean p_Complete) {
        DMXScene o_DMXScene;
        StringBuilder o_StringBuffer = new StringBuilder();
        if (p_Complete) {
            o_StringBuffer.append("<html>");
        }
        o_StringBuffer.append("<center>");
        if (this.m_Description.getIsJingle()) {
            o_StringBuffer.append("DMX Jingle");
        } else {
            o_StringBuffer.append(LiveShowDMXObjectDescription.DEFAULTNAME);
        }
        o_StringBuffer.append("<br>");
        o_StringBuffer.append("</center>");
        o_StringBuffer.append(super.createToolTipText(false));
        int intDMXDeviceCount_InColumn = 0;
        int intNextDMXDeviceColumn = LiveShowDMXObjectPanel.DMXDEVICES_PER_COLUMN;
        double doubleValueMax = 0.0;
        DMXEffect o_DMXEffect = this.getDMXEffect();
        if (o_DMXEffect != null) {
            o_StringBuffer.append("<tr  style=\"color:rgb(0,0,255)\">");
            o_StringBuffer.append("<td align=right>");
            o_StringBuffer.append(DMXEffect.s_DefaultName);
            o_StringBuffer.append("</td>");
            o_StringBuffer.append("<td align=center>");
            o_StringBuffer.append("<b>");
            o_StringBuffer.append(o_DMXEffect.getName());
            o_StringBuffer.append("</b>");
            o_StringBuffer.append("</td>");
            o_StringBuffer.append("</tr>");
        }
        if ((o_DMXScene = this.getDMXScene()) != null) {
            o_StringBuffer.append("<tr>");
            o_StringBuffer.append("<td align=center>");
            o_StringBuffer.append("");
            o_StringBuffer.append("</td>");
            o_StringBuffer.append("<td align=center>");
            o_StringBuffer.append("");
            o_StringBuffer.append("</td>");
            o_StringBuffer.append("</tr>");
            o_StringBuffer.append("<tr>");
            o_StringBuffer.append("<td align=right><b>");
            o_StringBuffer.append(DMXDevice.DEFAULT_DMXDEVICENAME);
            o_StringBuffer.append("</b></td>");
            o_StringBuffer.append("<td align=right><b>");
            o_StringBuffer.append("%");
            o_StringBuffer.append("</b></td>");
            o_StringBuffer.append("</tr>");
            o_StringBuffer.append("</table>");
            o_StringBuffer.append("<table align=center>");
            o_StringBuffer.append("<tr>");
            o_StringBuffer.append("<td align=center>");
            o_StringBuffer.append("<table align=top>");
            for (int intDMXDevice = 0; intDMXDevice < DMXDevice.getDMXDeviceCount(); ++intDMXDevice) {
                DMXDevice o_DMXDevice = DMXDevice.getDMXDevice(intDMXDevice);
                if (o_DMXDevice == null) continue;
                if (!o_DMXDevice.getIsDimmable()) {
                    if (!o_DMXScene.isSomethingOn(o_DMXDevice)) continue;
                    if (intDMXDeviceCount_InColumn >= LiveShowDMXObjectPanel.DMXDEVICES_PER_COLUMN) {
                        intDMXDeviceCount_InColumn = 0;
                        this.m_StringBuilderToolTip.append("</table>");
                        this.m_StringBuilderToolTip.append("</td>");
                        this.m_StringBuilderToolTip.append("<td align=center>");
                        this.m_StringBuilderToolTip.append("<table align=top>");
                    }
                    o_StringBuffer.append("<p>");
                    o_StringBuffer.append("<tr>");
                    o_StringBuffer.append("<td align=right>");
                    o_StringBuffer.append(o_DMXDevice.getName());
                    o_StringBuffer.append("</td>");
                    o_StringBuffer.append("<td align=right>");
                    o_StringBuffer.append("?");
                    o_StringBuffer.append("</td>");
                    o_StringBuffer.append("</tr>");
                    o_StringBuffer.append("</p");
                    ++intDMXDeviceCount_InColumn;
                    continue;
                }
                doubleValueMax = o_DMXScene.getDimmerValue(o_DMXDevice);
                if (doubleValueMax > 0.0) {
                    if (intDMXDeviceCount_InColumn >= LiveShowDMXObjectPanel.DMXDEVICES_PER_COLUMN) {
                        intDMXDeviceCount_InColumn = 0;
                        o_StringBuffer.append("</table>");
                        o_StringBuffer.append("</td>");
                        o_StringBuffer.append("<td align=center>");
                        o_StringBuffer.append("<table align=top>");
                    }
                    o_StringBuffer.append("<p>");
                    o_StringBuffer.append("<tr>");
                    o_StringBuffer.append("<td align=right>");
                    o_StringBuffer.append(o_DMXDevice.getName());
                    o_StringBuffer.append("</td>");
                    o_StringBuffer.append("<td align=right style=\"color:rgb(0,255,0)\">");
                    o_StringBuffer.append((int)(doubleValueMax / 65535.0 * 100.0 + 0.5));
                    o_StringBuffer.append("</td>");
                    o_StringBuffer.append("</tr>");
                    o_StringBuffer.append("</p");
                    ++intDMXDeviceCount_InColumn;
                    continue;
                }
                if (o_DMXEffect == null || !o_DMXEffect.containsDMXDevice(o_DMXDevice)) continue;
                if (intDMXDeviceCount_InColumn >= LiveShowDMXObjectPanel.DMXDEVICES_PER_COLUMN) {
                    intDMXDeviceCount_InColumn = 0;
                    o_StringBuffer.append("</table>");
                    o_StringBuffer.append("</td>");
                    o_StringBuffer.append("<td align=center>");
                    o_StringBuffer.append("<table align=top>");
                }
                o_StringBuffer.append("<p>");
                o_StringBuffer.append("<tr>");
                o_StringBuffer.append("<td align=right>");
                o_StringBuffer.append(o_DMXDevice.getName());
                o_StringBuffer.append("</td>");
                o_StringBuffer.append("<td align=right style=\"color:rgb(0,0,255)\">");
                o_StringBuffer.append(o_DMXEffect.getName());
                o_StringBuffer.append("</td>");
                o_StringBuffer.append("</tr>");
                o_StringBuffer.append("</p");
                ++intDMXDeviceCount_InColumn;
            }
        }
        o_StringBuffer.append("</table>");
        o_StringBuffer.append("</td>");
        o_StringBuffer.append("</table>");
        if (p_Complete) {
            o_StringBuffer.append("</html>");
        }
        return o_StringBuffer.toString();
    }

    @Override
    public String getSourceAdditionalInfo() {
        return null;
    }

    @Override
    public ComboBoxModel getSourceListModel() {
        return DMXScene.getDMXSceneListModel();
    }

    @Override
    public boolean getSourceIsReplaceable() {
        return true;
    }

    @Override
    public DefaultListCellRenderer getSourceListRenderer() {
        return DMXScene.getDMXSceneListRenderer();
    }

    @Override
    public void setEffect(Object p_Effect) {
        if (p_Effect == null) {
            this.setDMXEffect(null);
        }
        if (p_Effect instanceof DMXEffect) {
            this.setDMXEffect((DMXEffect)p_Effect);
        }
    }

    @Override
    public Object getEffect() {
        return this.m_DMXEffect;
    }

    @Override
    public void setEffectParameters(ArrayList<Double> p_EffectParameters) {
        this.setDMXEffectParameters(p_EffectParameters);
    }

    @Override
    public ArrayList<Double> getEffectParameters() {
        return this.getDMXEffectParameters();
    }

    @Override
    public LiveShowObjectInterface.EffectPanel getEffectPanel() {
        return s_DMXObjectEffectSettingsPanel;
    }

    @Override
    public boolean getFrameOffsetAbility() {
        return false;
    }

    public static void copyFrom(LiveShowDMXObjectCopyInterface p_DMXObjectCopyInterface, LiveShowObject p_LiveShowObject_Dest, DMXDevice p_DMXDevice_Dest, LiveShowObject p_LiveShowObject_Source, DMXDevice p_DMXDevice_Source) {
        if (p_DMXDevice_Source == null || p_LiveShowObject_Source == null) {
            return;
        }
        if (!(p_LiveShowObject_Source instanceof LiveShowDMXObject)) {
            return;
        }
        DMXScene o_DMXScene_Dest = ((LiveShowDMXObject)p_LiveShowObject_Dest).getDMXScene();
        DMXScene o_DMXScene_Source = ((LiveShowDMXObject)p_LiveShowObject_Source).getDMXScene();
        if (o_DMXScene_Dest == null) {
            return;
        }
        if (o_DMXScene_Source == null) {
            return;
        }
        if (p_DMXDevice_Dest == p_DMXDevice_Source && o_DMXScene_Dest == o_DMXScene_Source) {
            return;
        }
        for (int intDMXControl = 0; intDMXControl < p_DMXDevice_Dest.getDMXControlComponentCount(); ++intDMXControl) {
            DMXControlComponent o_DMXControlComponent_Dest = p_DMXDevice_Dest.getDMXControlComponent(intDMXControl);
            LiveShowDMXObject.copyFrom(p_DMXObjectCopyInterface, o_DMXControlComponent_Dest, p_LiveShowObject_Dest, p_DMXDevice_Dest, o_DMXScene_Dest, p_LiveShowObject_Source, p_DMXDevice_Source, o_DMXScene_Source);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void copyFrom(LiveShowDMXObjectCopyInterface p_DMXObjectCopyInterface, DMXControlComponent p_DMXControlComponent_Dest, LiveShowObject p_LiveShowObject_Dest, DMXDevice p_DMXDevice_Dest, DMXScene p_DMXScene_Dest, LiveShowObject p_LiveShowObject_Source, DMXDevice p_DMXDevice_Source, DMXScene p_DMXScene_Source) {
        DMXControlComponent o_DMXControlComponent_Source;
        if (p_LiveShowObject_Source == null) {
            return;
        }
        if (!(p_LiveShowObject_Source instanceof LiveShowDMXObject)) {
            return;
        }
        if (p_LiveShowObject_Dest == null) {
            return;
        }
        if (!(p_LiveShowObject_Dest instanceof LiveShowDMXObject)) {
            return;
        }
        if (p_DMXControlComponent_Dest == null) {
            return;
        }
        if (p_DMXDevice_Source == null || p_DMXScene_Source == null) {
            return;
        }
        if (p_DMXDevice_Dest == null || p_DMXScene_Dest == null) {
            return;
        }
        if (p_DMXDevice_Dest == p_DMXDevice_Source && p_DMXScene_Dest == p_DMXScene_Source) {
            return;
        }
        boolean boolCopy_Something = false;
        boolean boolCopySame_DMXDeviceType = false;
        if (p_DMXDevice_Source.getDMXDeviceType().getID().equals(p_DMXDevice_Dest.getDMXDeviceType().getID())) {
            boolCopySame_DMXDeviceType = true;
        }
        ArrayList<DMXControlComponent> o_DMXControlComponents_Source = new ArrayList<DMXControlComponent>();
        DMXControlComponent o_DMXControlComponent_Dest = p_DMXControlComponent_Dest;
        DMXControlDescription o_DMXControlDescription_Dest = o_DMXControlComponent_Dest.getDMXControlType().getDMXControlDescription();
        String stringDescriptionID_Dest = o_DMXControlDescription_Dest.getID();
        if (boolCopySame_DMXDeviceType) {
            int intIndex = p_DMXDevice_Dest.getDMXControlComponentIndex(p_DMXControlComponent_Dest);
            o_DMXControlComponent_Source = p_DMXDevice_Source.getDMXControlComponent(intIndex);
            if (o_DMXControlComponent_Source == null) return;
            o_DMXControlComponents_Source.add(o_DMXControlComponent_Dest);
        } else {
            o_DMXControlComponents_Source = p_DMXDevice_Source.getDMXControlComponentsByDescription(o_DMXControlDescription_Dest, o_DMXControlComponents_Source);
        }
        boolean boolCopy_FixedDMXControl = false;
        if (stringDescriptionID_Dest.equals("dimmer")) {
            boolCopy_FixedDMXControl = true;
        } else if (stringDescriptionID_Dest.equals("rgbcmy")) {
            boolCopy_FixedDMXControl = true;
        } else if (stringDescriptionID_Dest.equals("pantilt")) {
            boolCopy_FixedDMXControl = true;
        }
        ControlObject.ControlDimension o_ControlDimensionChanged_Last = null;
        if (o_DMXControlComponents_Source.size() == 1) {
            o_DMXControlComponent_Source = o_DMXControlComponents_Source.get(0);
            if (o_DMXControlComponent_Source.getControlObjectCount() != o_DMXControlComponent_Dest.getControlObjectCount()) {
                return;
            }
            boolean boolCopy_Uncertain = false;
            for (int intControl = 0; intControl < o_DMXControlComponent_Dest.getControlObjectCount(); ++intControl) {
                ControlObject o_ControlObject_Source;
                ControlObject o_ControlObject_Dest = o_DMXControlComponent_Dest.getControlObject(intControl);
                if (o_ControlObject_Dest == null || (o_ControlObject_Source = o_DMXControlComponent_Source.getControlObject(intControl)) == null) continue;
                if (o_ControlObject_Dest.getControlDimensionCount() != o_ControlObject_Dest.getControlDimensionCount()) {
                    boolCopy_Uncertain = true;
                    continue;
                }
                for (int intDimension = 0; intDimension < o_ControlObject_Dest.getControlDimensionCount(); ++intDimension) {
                    ControlObject.ControlDimension o_ControlDimension_Source;
                    ControlObject.ControlDimension o_ControlDimension_Dest = o_ControlObject_Dest.getControlDimension(intDimension);
                    if (o_ControlDimension_Dest == null || (o_ControlDimension_Source = o_ControlObject_Source.getControlDimension(intDimension)) == null) continue;
                    boolean boolCopy_SameLabelStructure = true;
                    if (!boolCopySame_DMXDeviceType && !boolCopy_FixedDMXControl) {
                        ControlLabelModel o_ControlLabelModel_Source;
                        ControlLabelModel o_ControlLabelModel_Dest = o_ControlDimension_Dest.getControlLabelModel();
                        boolCopy_SameLabelStructure = o_ControlLabelModel_Dest.isSameStructure(o_ControlLabelModel_Source = o_ControlDimension_Source.getControlLabelModel());
                        if (!boolCopy_SameLabelStructure) {
                            boolCopy_Uncertain = true;
                            continue;
                        }
                        if (!o_ControlLabelModel_Dest.isSameAs(o_ControlLabelModel_Source)) {
                            boolCopy_Uncertain = true;
                        }
                    }
                    if (p_DMXScene_Source.getValue(p_DMXDevice_Source, o_DMXControlComponent_Source.getDMXControlType(), intControl, intDimension) < 0.0) continue;
                    o_ControlDimensionChanged_Last = o_ControlDimension_Dest;
                    boolCopy_Something = true;
                }
            }
            if (!boolCopy_Something) return;
            DMXFadeDescription o_DMXFadeDescription = ((LiveShowDMXObject)p_LiveShowObject_Source).getDMXFadeDescription();
            if (o_DMXFadeDescription != null) {
                DMXFadeDescription.DMXControlTypeFadeDescription o_DMXControlTypeFadeDescription_Source = o_DMXFadeDescription.getDMXControlTypeFadeDescription(p_DMXDevice_Source.getID(), o_DMXControlComponent_Source.getDMXControlType().getID());
                p_DMXObjectCopyInterface.setValue(o_DMXControlTypeFadeDescription_Source, p_LiveShowObject_Dest, p_DMXDevice_Dest, p_DMXScene_Dest, p_DMXControlComponent_Dest.getDMXControlType());
                boolean bl = o_DMXControlTypeFadeDescription_Source.getDisabled();
            }
            if (!boolCopy_Uncertain) {
                p_DMXObjectCopyInterface.setCopyDone(1, p_DMXDevice_Dest, p_DMXScene_Dest, p_DMXControlComponent_Dest);
                return;
            } else {
                p_DMXObjectCopyInterface.setCopyDone(2, p_DMXDevice_Dest, p_DMXScene_Dest, p_DMXControlComponent_Dest);
            }
            return;
        } else if (o_DMXControlComponents_Source.size() > 0) return;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.m_DMXEffect) {
            if ("dmxeffectClosing".equals(evt.getPropertyName())) {
                this.setDMXEffect(null);
            }
            if ("dmxeffectName".equals(evt.getPropertyName())) {
                this.notifyObjectListeners_ObjectParameterChanged(this.m_Description);
            }
        }
        if ("liveShowObject_SourceClose".equals(evt.getPropertyName())) {
            this.close(true);
        }
        if (evt.getSource() instanceof DMXScene) {
            if ("dmxsceneName".equals(evt.getPropertyName())) {
                super.setSourceName((String)evt.getNewValue());
            } else {
                this.notifyObjectListeners_ObjectParameterChanged(this.m_Description);
            }
        }
        super.propertyChange(evt);
    }

    @Override
    public void eventFadeDescriptionDMXDevice(DMXFadeDescription p_DMXFadeDescription) {
        this.checkEqualsFadeSettingsToDefault();
    }

    @Override
    public void notifyObjectListeners_ObjectParameterChanged(LiveShowObjectDescription p_LiveShowObjectDescription) {
        super.notifyObjectListeners_ObjectParameterChanged(p_LiveShowObjectDescription);
    }

    @Override
    public void eventEndOfAction(LiveShowVIP p_ActorLiveShowVIP, boolean p_Success, int p_Action) {
        super.eventEndOfAction(p_ActorLiveShowVIP, p_Success, p_Action);
    }
}

