/*
 * Decompiled with CFR 0.152.
 */
package DMXVirtualPackage;

import DMXMixer.DMXControlComponent;
import DMXVirtualPackage.DMXFadeDescription;
import DMXVirtualPackage.LiveShowDMXSceneBridge;
import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LanguageTools.LiveLanguagePackage.LiveLanguageString;
import LiveShowControlObjects.ControlObject;
import LiveShowControls.JControlMeter;
import LiveShowObjectPackage.LiveShowObjectInterface;
import SwingComponents.MouseAdapter_Delayed;
import SwingToolTipPackage.PopUpToolTip;
import SynchronizationPackage.EventQueueHandler;
import ToolsGraphics.JCheckBox_MultiSelection;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class DMXFadeDescriptionPanel
extends JPanel {
    public static final String PROP_PARAMSCHANGED = "paramsChanged";
    @LiveLanguageString
    public static String TEXT_DISABLED = "disabled";
    @LiveLanguageString
    public static String TOOLTIPTEXT_DISABLED = "<html>In Timeline and Jingle will the values of this control be ignored.</html>";
    @LiveLanguageString
    public static String TEXT_DISABLEDADJUSTMENT = "only adjustment disabled";
    @LiveLanguageString
    public static String TOOLTIPTEXT_DISABLEDADJUSTMENT = "<html>In the timeline will all values of the DMXDevices be precalcluted (adjusted) when the cursor leaves an DMXObject.<br>When you disable the adjustment for this control, its values will not be precalculated.</html>";
    @LiveLanguageString
    public static String TOOLTIPTEXT_FADEBEHAVIOUR = "<html>Here, you can change the fade behavior as a percentage of the total fade time.</html>";
    @LiveLanguageString
    public static String TOOLTIPTEXT_FADEMINMAX = "<html>Here you can set the<br>minimum value at the start and<br>the maximum value at the end<br>of the fade.</html>";
    @LiveLanguageString
    public static String TOOLTIPTEXT_SETTODEFAULT = "<html>Set all selected elements to default settings</html>";
    public static final int FADESTARTENDPANEL_WIDTH = 150;
    public static final int FADESTARTENDPANEL_HEIGHT = 150;
    public static float SNAPDISTANCE = 0.046666667f;
    private LiveShowObjectInterface m_LiveShowObjectInterface;
    private ArrayList<Float> m_Tabs;
    private ArrayList<DMXFadeDescription.DMXControlTypeFadeDescription> m_DMXControlTypeFadeDescriptions;
    private DMXControlComponent.DMXControlType m_Coincidence_DMXControlType;
    private JCheckBox_MultiSelection m_JCheckBox_Disabled;
    private JCheckBox_MultiSelection m_JCheckBox_DisabledAdjustment;
    private JFadePanel m_FadeInPanel;
    private JFadePanel m_FadeOutPanel;
    private boolean m_Changed;
    private JButton jButton_SetToDefault;

    public DMXFadeDescriptionPanel() {
        this.initMembers();
        this.initComponents();
        this.initComponentsFurther();
    }

    private void initMembers() {
        this.m_DMXControlTypeFadeDescriptions = new ArrayList();
        this.m_Coincidence_DMXControlType = null;
        this.m_Tabs = new ArrayList();
        this.m_Tabs.add(Float.valueOf(0.0f));
        this.m_Tabs.add(Float.valueOf(0.25f));
        this.m_Tabs.add(Float.valueOf(0.5f));
        this.m_Tabs.add(Float.valueOf(0.75f));
        this.m_Tabs.add(Float.valueOf(1.0f));
        LiveLanguage.addLanguageListener((Object)this, null);
        this.m_Changed = false;
    }

    private void initComponents() {
        this.jButton_SetToDefault = new JButton();
        this.setLayout(new GridBagLayout());
        this.jButton_SetToDefault.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Slider_DeviceDefaultValues.png")));
        this.jButton_SetToDefault.setToolTipText("Set to default");
        this.jButton_SetToDefault.setContentAreaFilled(false);
        this.jButton_SetToDefault.setIconTextGap(0);
        this.jButton_SetToDefault.setMargin(new Insets(0, 0, 0, 0));
        this.jButton_SetToDefault.setMaximumSize(new Dimension(64, 32));
        this.jButton_SetToDefault.setMinimumSize(new Dimension(64, 32));
        this.jButton_SetToDefault.setPreferredSize(new Dimension(64, 32));
        this.jButton_SetToDefault.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed_Wide.png")));
        this.jButton_SetToDefault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DMXFadeDescriptionPanel.this.jButton_SetToDefaultActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jButton_SetToDefault, gridBagConstraints);
    }

    private void jButton_SetToDefaultActionPerformed(ActionEvent evt) {
        this.setToDefault();
    }

    private void initComponentsFurther() {
        GridBagConstraints o_GridBagConstraints = new GridBagConstraints();
        o_GridBagConstraints.insets = new Insets(3, 3, 3, 3);
        o_GridBagConstraints.gridx = 1;
        o_GridBagConstraints.gridy = 0;
        o_GridBagConstraints.fill = 0;
        o_GridBagConstraints.weightx = 1.0;
        o_GridBagConstraints.weighty = 0.0;
        o_GridBagConstraints.gridwidth = 1;
        o_GridBagConstraints.gridheight = 2;
        o_GridBagConstraints.anchor = 17;
        this.remove(this.jButton_SetToDefault);
        this.add((Component)this.jButton_SetToDefault, o_GridBagConstraints);
        this.jButton_SetToDefault.setToolTipText(TOOLTIPTEXT_SETTODEFAULT);
        this.jButton_SetToDefault.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.m_JCheckBox_Disabled = new JCheckBox_MultiSelection(TEXT_DISABLED);
        this.m_JCheckBox_Disabled.setToolTipText(TOOLTIPTEXT_DISABLED);
        this.m_JCheckBox_Disabled.setHorizontalAlignment(2);
        this.m_JCheckBox_Disabled.setForeground(Color.WHITE);
        this.m_JCheckBox_Disabled.setOpaque(false);
        this.m_JCheckBox_Disabled.setVisible(true);
        this.m_JCheckBox_Disabled.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int intSelectionFlag = DMXFadeDescriptionPanel.this.getDisabled();
                switch (intSelectionFlag) {
                    case 0: {
                        DMXFadeDescriptionPanel.this.setDisabled(true);
                        break;
                    }
                    case 2: {
                        DMXFadeDescriptionPanel.this.setDisabled(true);
                        break;
                    }
                    case 1: {
                        DMXFadeDescriptionPanel.this.setDisabled(false);
                    }
                }
            }
        });
        o_GridBagConstraints.insets = new Insets(3, 3, 3, 3);
        o_GridBagConstraints.gridx = 0;
        o_GridBagConstraints.gridy = 0;
        o_GridBagConstraints.fill = 2;
        o_GridBagConstraints.anchor = 17;
        o_GridBagConstraints.weightx = 1.0;
        o_GridBagConstraints.weighty = 0.0;
        o_GridBagConstraints.gridwidth = 1;
        o_GridBagConstraints.gridheight = 1;
        this.add((Component)this.m_JCheckBox_Disabled, o_GridBagConstraints);
        this.m_JCheckBox_DisabledAdjustment = new JCheckBox_MultiSelection(TEXT_DISABLEDADJUSTMENT);
        this.m_JCheckBox_DisabledAdjustment.setToolTipText(TOOLTIPTEXT_DISABLEDADJUSTMENT);
        this.m_JCheckBox_DisabledAdjustment.setHorizontalAlignment(2);
        this.m_JCheckBox_DisabledAdjustment.setForeground(Color.WHITE);
        this.m_JCheckBox_DisabledAdjustment.setOpaque(false);
        this.m_JCheckBox_DisabledAdjustment.setVisible(true);
        this.m_JCheckBox_DisabledAdjustment.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int intSelectionFlag = DMXFadeDescriptionPanel.this.getDisabledAdjustment();
                switch (intSelectionFlag) {
                    case 0: {
                        DMXFadeDescriptionPanel.this.setDisabledAdjustment(true);
                        break;
                    }
                    case 2: {
                        DMXFadeDescriptionPanel.this.setDisabledAdjustment(true);
                        break;
                    }
                    case 1: {
                        DMXFadeDescriptionPanel.this.setDisabledAdjustment(false);
                    }
                }
            }
        });
        o_GridBagConstraints.insets = new Insets(3, 3, 3, 3);
        o_GridBagConstraints.gridx = 0;
        o_GridBagConstraints.gridy = 1;
        o_GridBagConstraints.fill = 2;
        o_GridBagConstraints.anchor = 17;
        o_GridBagConstraints.weightx = 1.0;
        o_GridBagConstraints.weighty = 0.0;
        o_GridBagConstraints.gridwidth = 1;
        this.add((Component)this.m_JCheckBox_DisabledAdjustment, o_GridBagConstraints);
        this.m_FadeInPanel = new JFadePanel(this, 0);
        this.m_FadeInPanel.setVisible(true);
        o_GridBagConstraints.gridwidth = 1;
        o_GridBagConstraints.gridx = 0;
        o_GridBagConstraints.gridy = 2;
        o_GridBagConstraints.fill = 1;
        o_GridBagConstraints.anchor = 10;
        o_GridBagConstraints.weightx = 1.0;
        o_GridBagConstraints.weighty = 1.0;
        this.add((Component)this.m_FadeInPanel, o_GridBagConstraints);
        this.m_FadeOutPanel = new JFadePanel(this, 1);
        this.m_FadeOutPanel.setVisible(true);
        o_GridBagConstraints.gridx = 1;
        this.add((Component)this.m_FadeOutPanel, o_GridBagConstraints);
        this.m_JCheckBox_Disabled.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.m_JCheckBox_DisabledAdjustment.setComponentPopupMenu(PopUpToolTip.getSelfReference());
    }

    public void close() {
        LiveLanguage.removeLanguageListener((Object)this);
        this.m_JCheckBox_Disabled.setComponentPopupMenu(null);
        this.m_JCheckBox_DisabledAdjustment.setComponentPopupMenu(null);
        this.jButton_SetToDefault.setComponentPopupMenu(null);
        LiveLanguage.removeLanguageListener((Object)this);
    }

    public ArrayList<Float> getTabs() {
        return this.m_Tabs;
    }

    public void refresh() {
        if (this.getDMXControlTypeFadeDescriptionCount() == 0) {
            this.m_JCheckBox_Disabled.setSelection(0);
            this.m_JCheckBox_Disabled.setEnabled(false);
            this.m_JCheckBox_DisabledAdjustment.setSelection(0);
            this.m_JCheckBox_DisabledAdjustment.setEnabled(false);
        } else {
            this.m_JCheckBox_Disabled.setEnabled(true);
            this.m_JCheckBox_Disabled.setSelection(this.getDisabled());
            this.m_JCheckBox_DisabledAdjustment.setEnabled(true);
            this.m_JCheckBox_DisabledAdjustment.setSelection(this.getDisabledAdjustment());
        }
        if (this.m_LiveShowObjectInterface == null) {
            this.jButton_SetToDefault.setVisible(false);
        } else if (this.m_LiveShowObjectInterface instanceof LiveShowDMXSceneBridge) {
            this.jButton_SetToDefault.setVisible(false);
            this.m_JCheckBox_Disabled.setEnabled(false);
            this.m_JCheckBox_DisabledAdjustment.setEnabled(false);
        } else {
            this.jButton_SetToDefault.setVisible(true);
        }
        this.m_FadeInPanel.refresh();
        this.m_FadeOutPanel.refresh();
    }

    public void setLiveShowObject(LiveShowObjectInterface p_LiveShowObjectInterface) {
        this.m_LiveShowObjectInterface = p_LiveShowObjectInterface;
        this.m_Changed = false;
        this.refresh();
    }

    public LiveShowObjectInterface getLiveShowObjectInterface() {
        return this.m_LiveShowObjectInterface;
    }

    public void addDMXControlTypeFadeDescription(DMXFadeDescription.DMXControlTypeFadeDescription p_DMXControlTypeFadeDescription) {
        if (p_DMXControlTypeFadeDescription == null) {
            return;
        }
        if (this.m_DMXControlTypeFadeDescriptions.contains(p_DMXControlTypeFadeDescription)) {
            return;
        }
        this.m_DMXControlTypeFadeDescriptions.add(p_DMXControlTypeFadeDescription);
        this.checkDMXControlTypes();
        this.refresh();
    }

    public void removeDMXControlTypeFadeDescription(DMXFadeDescription.DMXControlTypeFadeDescription p_DMXControlTypeFadeDescription) {
        if (p_DMXControlTypeFadeDescription == null) {
            return;
        }
        if (!this.m_DMXControlTypeFadeDescriptions.contains(p_DMXControlTypeFadeDescription)) {
            return;
        }
        this.m_DMXControlTypeFadeDescriptions.remove(p_DMXControlTypeFadeDescription);
        this.checkDMXControlTypes();
        this.refresh();
    }

    private void checkDMXControlTypes() {
        if (this.m_DMXControlTypeFadeDescriptions.size() <= 0) {
            this.m_Coincidence_DMXControlType = null;
            this.setCoincidence_DMXControlType(this.m_Coincidence_DMXControlType);
            return;
        }
        this.m_Coincidence_DMXControlType = null;
        for (int intDescription = 0; intDescription < this.m_DMXControlTypeFadeDescriptions.size(); ++intDescription) {
            DMXFadeDescription.DMXControlTypeFadeDescription o_DMXControlTypeFadeDescription = this.m_DMXControlTypeFadeDescriptions.get(intDescription);
            DMXControlComponent.DMXControlType o_DMXControlType = o_DMXControlTypeFadeDescription.getDMXControlType();
            if (this.m_Coincidence_DMXControlType == null) {
                this.m_Coincidence_DMXControlType = o_DMXControlType;
                continue;
            }
            if (this.m_Coincidence_DMXControlType.isSameAs(o_DMXControlType)) continue;
            this.m_Coincidence_DMXControlType = null;
            break;
        }
        this.setCoincidence_DMXControlType(this.m_Coincidence_DMXControlType);
    }

    public void setCoincidence_DMXControlType(DMXControlComponent.DMXControlType p_DMXControlType) {
        this.m_Coincidence_DMXControlType = p_DMXControlType;
        this.m_FadeInPanel.setCoincidence_DMXControlType(this.m_Coincidence_DMXControlType);
        this.m_FadeOutPanel.setCoincidence_DMXControlType(this.m_Coincidence_DMXControlType);
    }

    public DMXControlComponent.DMXControlType getincidence_DMXControlType() {
        return this.m_Coincidence_DMXControlType;
    }

    public void clearDMXControlTypeFadeDescriptions() {
        this.m_DMXControlTypeFadeDescriptions.clear();
        this.checkDMXControlTypes();
        this.refresh();
    }

    public int getDMXControlTypeFadeDescriptionCount() {
        return this.m_DMXControlTypeFadeDescriptions.size();
    }

    public DMXFadeDescription.DMXControlTypeFadeDescription getDMXControlTypeFadeDescription(int p_Index) {
        if (p_Index < 0 || p_Index >= this.m_DMXControlTypeFadeDescriptions.size()) {
            return null;
        }
        DMXFadeDescription.DMXControlTypeFadeDescription o_DMXControlTypeFadeDescription = this.m_DMXControlTypeFadeDescriptions.get(p_Index);
        return o_DMXControlTypeFadeDescription;
    }

    public void setToDefault() {
        DMXFadeDescription.DMXControlTypeFadeDescription o_DMXControlTypeFadeDescription;
        int intFadeDescription;
        boolean boolChanged = false;
        DMXControlComponent.DMXControlType o_Coincidence_DMXControlType = this.m_Coincidence_DMXControlType;
        this.setCoincidence_DMXControlType(null);
        ArrayList<DMXFadeDescription.DMXControlTypeFadeDescription> o_DMXControlTypeFadeDescriptions = new ArrayList<DMXFadeDescription.DMXControlTypeFadeDescription>();
        for (intFadeDescription = 0; intFadeDescription < this.m_DMXControlTypeFadeDescriptions.size(); ++intFadeDescription) {
            o_DMXControlTypeFadeDescription = this.m_DMXControlTypeFadeDescriptions.get(intFadeDescription);
            if (!o_DMXControlTypeFadeDescription.setToDefault()) continue;
            boolChanged = true;
            o_DMXControlTypeFadeDescriptions.add(o_DMXControlTypeFadeDescription);
        }
        if (boolChanged) {
            this.m_Changed = true;
            for (intFadeDescription = 0; intFadeDescription < o_DMXControlTypeFadeDescriptions.size(); ++intFadeDescription) {
                o_DMXControlTypeFadeDescription = (DMXFadeDescription.DMXControlTypeFadeDescription)o_DMXControlTypeFadeDescriptions.get(intFadeDescription);
                this.firePropertyChange(PROP_PARAMSCHANGED, null, o_DMXControlTypeFadeDescription);
                this.refresh();
            }
        }
        this.setCoincidence_DMXControlType(o_Coincidence_DMXControlType);
    }

    public void setDisabled(boolean p_Disabled) {
        for (int intFadeDescription = 0; intFadeDescription < this.m_DMXControlTypeFadeDescriptions.size(); ++intFadeDescription) {
            DMXFadeDescription.DMXControlTypeFadeDescription o_DMXControlTypeFadeDescription = this.m_DMXControlTypeFadeDescriptions.get(intFadeDescription);
            boolean oldValue = o_DMXControlTypeFadeDescription.getDisabled();
            if (oldValue == p_Disabled) continue;
            this.m_Changed = true;
            o_DMXControlTypeFadeDescription.setDisabled(p_Disabled);
            this.firePropertyChange(PROP_PARAMSCHANGED, null, o_DMXControlTypeFadeDescription);
            this.refresh();
        }
    }

    public int getDisabled() {
        boolean boolDisabled = false;
        for (int intFadeDescription = 0; intFadeDescription < this.m_DMXControlTypeFadeDescriptions.size(); ++intFadeDescription) {
            DMXFadeDescription.DMXControlTypeFadeDescription o_DMXControlTypeFadeDescription = this.m_DMXControlTypeFadeDescriptions.get(intFadeDescription);
            if (intFadeDescription == 0) {
                boolDisabled = o_DMXControlTypeFadeDescription.getDisabled();
                continue;
            }
            if (boolDisabled == o_DMXControlTypeFadeDescription.getDisabled()) continue;
            return 2;
        }
        if (boolDisabled) {
            return 1;
        }
        return 0;
    }

    public void setDisabledAdjustment(boolean p_DisabledAdjustment) {
        for (int intFadeDescription = 0; intFadeDescription < this.m_DMXControlTypeFadeDescriptions.size(); ++intFadeDescription) {
            DMXFadeDescription.DMXControlTypeFadeDescription o_DMXControlTypeFadeDescription = this.m_DMXControlTypeFadeDescriptions.get(intFadeDescription);
            boolean oldValue = o_DMXControlTypeFadeDescription.getDisabledAdjustment();
            if (oldValue == p_DisabledAdjustment) continue;
            this.m_Changed = true;
            o_DMXControlTypeFadeDescription.setDisabledAdjustment(p_DisabledAdjustment);
            this.firePropertyChange(PROP_PARAMSCHANGED, null, o_DMXControlTypeFadeDescription);
            this.refresh();
        }
    }

    public int getDisabledAdjustment() {
        boolean boolDisabledAdjustment = false;
        for (int intFadeDescription = 0; intFadeDescription < this.m_DMXControlTypeFadeDescriptions.size(); ++intFadeDescription) {
            DMXFadeDescription.DMXControlTypeFadeDescription o_DMXControlTypeFadeDescription = this.m_DMXControlTypeFadeDescriptions.get(intFadeDescription);
            if (intFadeDescription == 0) {
                boolDisabledAdjustment = o_DMXControlTypeFadeDescription.getDisabledAdjustment();
                continue;
            }
            if (boolDisabledAdjustment == o_DMXControlTypeFadeDescription.getDisabledAdjustment()) continue;
            return 2;
        }
        if (boolDisabledAdjustment) {
            return 1;
        }
        return 0;
    }

    public void setFade(float p_Value, int p_FadeOutIn, int p_FadeStartEnd) {
        for (int intFadeDescription = 0; intFadeDescription < this.m_DMXControlTypeFadeDescriptions.size(); ++intFadeDescription) {
            DMXFadeDescription.DMXControlTypeFadeDescription o_DMXControlTypeFadeDescription = this.m_DMXControlTypeFadeDescriptions.get(intFadeDescription);
            float oldValue = o_DMXControlTypeFadeDescription.getFade(p_FadeOutIn, p_FadeStartEnd);
            if (oldValue == p_Value) continue;
            this.m_Changed = true;
            o_DMXControlTypeFadeDescription.setFade(p_Value, p_FadeOutIn, p_FadeStartEnd);
            this.firePropertyChange(PROP_PARAMSCHANGED, null, o_DMXControlTypeFadeDescription);
        }
    }

    private float checkSnapping(float p_Position, int p_FadeInOut, int p_FadeStartEnd) {
        block4: for (int intFadeDescription = 0; intFadeDescription < this.m_DMXControlTypeFadeDescriptions.size(); ++intFadeDescription) {
            DMXFadeDescription.DMXControlTypeFadeDescription o_DMXControlTypeFadeDescription = this.m_DMXControlTypeFadeDescriptions.get(intFadeDescription);
            switch (p_FadeInOut) {
                case 0: {
                    float floatDescriptionValue = o_DMXControlTypeFadeDescription.getInternalFadeOut_Start();
                    if (Math.abs(p_Position - floatDescriptionValue) < SNAPDISTANCE) {
                        return floatDescriptionValue;
                    }
                    floatDescriptionValue = o_DMXControlTypeFadeDescription.getInternalFadeOut_End();
                    if (!(Math.abs(p_Position - floatDescriptionValue) < SNAPDISTANCE)) continue block4;
                    return floatDescriptionValue;
                }
                case 1: {
                    float floatDescriptionValue = o_DMXControlTypeFadeDescription.getInternalFadeIn_Start();
                    if (Math.abs(p_Position - floatDescriptionValue) < SNAPDISTANCE) {
                        return floatDescriptionValue;
                    }
                    floatDescriptionValue = o_DMXControlTypeFadeDescription.getInternalFadeIn_End();
                    if (!(Math.abs(p_Position - floatDescriptionValue) < SNAPDISTANCE)) continue block4;
                    return floatDescriptionValue;
                }
            }
        }
        for (int intTab = 0; intTab < this.m_Tabs.size(); ++intTab) {
            float floatTab = this.m_Tabs.get(intTab).floatValue();
            if (!(Math.abs(p_Position - floatTab) < SNAPDISTANCE)) continue;
            return floatTab;
        }
        return p_Position;
    }

    public void setFadeValues(int p_FadeOutIn, int p_FadeStartEnd, int p_ControlIndex, int p_DimensionIndex, int p_Value) {
        for (int intFadeDescription = 0; intFadeDescription < this.m_DMXControlTypeFadeDescriptions.size(); ++intFadeDescription) {
            DMXFadeDescription.DMXControlTypeFadeDescription o_DMXControlTypeFadeDescription = this.m_DMXControlTypeFadeDescriptions.get(intFadeDescription);
            int intValue = o_DMXControlTypeFadeDescription.getInternalFadeValue(p_FadeOutIn, p_FadeStartEnd, p_ControlIndex, p_DimensionIndex);
            if (intValue == p_Value) continue;
            this.m_Changed = true;
            o_DMXControlTypeFadeDescription.setFadeValue(p_Value, p_FadeOutIn, p_FadeStartEnd, p_ControlIndex, p_DimensionIndex);
            this.firePropertyChange(PROP_PARAMSCHANGED, null, o_DMXControlTypeFadeDescription);
        }
    }

    public boolean getChanged() {
        return this.m_Changed;
    }

    public static class JFadeControlsMinMaxPanel
    extends JPanel
    implements PropertyChangeListener,
    ComponentListener {
        JLabel m_Label_Start;
        JLabel m_Label_End;
        DMXControlComponent m_DMXControlComponent_Start;
        DMXControlComponent m_DMXControlComponent_End;
        DMXControlComponent.DMXControlType m_Coincidence_DMXControlType;
        JFadePanel m_JFadePanel;
        DMXFadeDescriptionPanel m_DMXFadeDescriptionPanel;
        private Dimension m_OldSize;
        JFadeControlsMinMaxPanel m_SelfReference = this;

        public JFadeControlsMinMaxPanel(JFadePanel p_JFadePanel) {
            this.m_JFadePanel = p_JFadePanel;
            this.m_DMXFadeDescriptionPanel = this.m_JFadePanel.getDMXFadeDescriptionPanel();
            this.initMembers();
            this.initComponents();
        }

        private void initMembers() {
            this.m_OldSize = new Dimension(0, 0);
            this.m_DMXControlComponent_Start = null;
            this.m_DMXControlComponent_End = null;
        }

        private void initComponents() {
            super.setLayout(new GridBagLayout());
            GridBagConstraints o_GridBagConstraints = new GridBagConstraints();
            this.m_Label_Start = new JLabel("Start");
            this.m_Label_Start.setForeground(Color.WHITE);
            this.m_Label_Start.setHorizontalAlignment(0);
            this.m_Label_Start.setVisible(true);
            o_GridBagConstraints.gridx = 0;
            o_GridBagConstraints.gridy = 0;
            o_GridBagConstraints.fill = 2;
            o_GridBagConstraints.weightx = 1.0;
            this.add((Component)this.m_Label_Start, o_GridBagConstraints);
            this.m_Label_End = new JLabel("End");
            this.m_Label_End.setForeground(Color.WHITE);
            this.m_Label_End.setHorizontalAlignment(0);
            this.m_Label_End.setVisible(true);
            o_GridBagConstraints.gridx = 1;
            this.add((Component)this.m_Label_End, o_GridBagConstraints);
            this.addComponentListener(this);
            this.setToolTipText(TOOLTIPTEXT_FADEMINMAX);
            this.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        }

        public void refresh() {
            DMXFadeDescription.DMXControlTypeFadeDescription o_DMXControlTypeFadeDescription;
            if (this.m_Coincidence_DMXControlType == null) {
                return;
            }
            if (this.m_DMXControlComponent_Start == null) {
                return;
            }
            if (this.m_DMXFadeDescriptionPanel.getDisabledAdjustment() != 1) {
                if (this.m_DMXControlComponent_Start != null) {
                    this.m_DMXControlComponent_Start.setVisible(false);
                }
                if (this.m_DMXControlComponent_End != null) {
                    this.m_DMXControlComponent_End.setVisible(false);
                }
            } else {
                if (this.m_DMXControlComponent_Start != null) {
                    this.m_DMXControlComponent_Start.setVisible(true);
                }
                if (this.m_DMXControlComponent_End != null) {
                    this.m_DMXControlComponent_End.setVisible(true);
                }
            }
            if ((o_DMXControlTypeFadeDescription = this.m_DMXFadeDescriptionPanel.getDMXControlTypeFadeDescription(0)) == null) {
                return;
            }
            int intControlCount = this.m_DMXControlComponent_Start.getControlObjectCount();
            for (int intControl = 0; intControl < intControlCount; ++intControl) {
                ControlObject o_ControlObject_Start = this.m_DMXControlComponent_Start.getControlObject(intControl);
                ControlObject o_ControlObject_End = this.m_DMXControlComponent_End.getControlObject(intControl);
                for (int intDimension = 0; intDimension < o_ControlObject_Start.getControlDimensionCount(); ++intDimension) {
                    ControlObject.ControlDimension o_ControlDimension_Start = o_ControlObject_Start.getControlDimension(intDimension);
                    ControlObject.ControlDimension o_ControlDimension_End = o_ControlObject_End.getControlDimension(intDimension);
                    if (o_DMXControlTypeFadeDescription == null) continue;
                    int intValue = o_DMXControlTypeFadeDescription.getInternalFadeValue(this.m_JFadePanel.getFadeType(), 0, intControl, intDimension);
                    if ((double)intValue != o_ControlDimension_Start.getValue()) {
                        o_ControlDimension_Start.setValue((double)intValue, 0.0, 0);
                    }
                    if ((double)(intValue = o_DMXControlTypeFadeDescription.getInternalFadeValue(this.m_JFadePanel.getFadeType(), 1, intControl, intDimension)) == o_ControlDimension_End.getValue()) continue;
                    o_ControlDimension_End.setValue((double)intValue, 0.0, 0);
                }
            }
        }

        public void setCoincidence_DMXControlType(DMXControlComponent.DMXControlType p_DMXControlType) {
            if (this.m_Coincidence_DMXControlType == p_DMXControlType) {
                return;
            }
            if (p_DMXControlType != null) {
                GridBagConstraints o_GridBagConstraints;
                if (this.m_DMXControlComponent_Start != null || this.m_DMXControlComponent_End != null) {
                    this.clearCoincidence_DMXControlType();
                }
                this.m_Coincidence_DMXControlType = p_DMXControlType;
                DMXFadeDescription.DMXControlTypeFadeDescription o_DMXControlTypeFadeDescription = this.m_DMXFadeDescriptionPanel.getDMXControlTypeFadeDescription(0);
                this.m_DMXControlComponent_Start = DMXControlComponent.loadDMXControlComponent(this.m_Coincidence_DMXControlType.copyWithoutLinks());
                if (this.m_DMXControlComponent_Start != null) {
                    this.m_DMXControlComponent_Start.setEnableSettings(false);
                    this.m_DMXControlComponent_Start.setVisible(true);
                    o_GridBagConstraints = this.m_DMXControlComponent_Start.getGridBagConstraints();
                    o_GridBagConstraints.gridx = 0;
                    o_GridBagConstraints.gridy = 1;
                    o_GridBagConstraints.fill = 3;
                    o_GridBagConstraints.weighty = 1.0;
                    this.add((Component)this.m_DMXControlComponent_Start, o_GridBagConstraints);
                }
                this.m_DMXControlComponent_End = DMXControlComponent.loadDMXControlComponent(this.m_Coincidence_DMXControlType.copyWithoutLinks());
                if (this.m_DMXControlComponent_End != null) {
                    this.m_DMXControlComponent_End.setEnableSettings(false);
                    this.m_DMXControlComponent_End.setVisible(true);
                    o_GridBagConstraints = this.m_DMXControlComponent_End.getGridBagConstraints();
                    o_GridBagConstraints.gridx = 1;
                    o_GridBagConstraints.gridy = 1;
                    o_GridBagConstraints.fill = 3;
                    o_GridBagConstraints.weighty = 1.0;
                    this.add((Component)this.m_DMXControlComponent_End, o_GridBagConstraints);
                }
                this.refresh();
                EventQueueHandler.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DMXControlComponent o_DMXControlComponent_Start = m_DMXControlComponent_Start;
                        DMXControlComponent o_DMXControlComponent_End = m_DMXControlComponent_End;
                        if (o_DMXControlComponent_Start == null || o_DMXControlComponent_End == null) {
                            return;
                        }
                        for (int intControl = 0; intControl < o_DMXControlComponent_Start.getControlObjectCount(); ++intControl) {
                            ControlObject o_ControlObject_Start = o_DMXControlComponent_Start.getControlObject(intControl);
                            ControlObject o_ControlObject_End = o_DMXControlComponent_End.getControlObject(intControl);
                            if (o_ControlObject_Start == null || o_ControlObject_End == null) continue;
                            for (int intDimension = 0; intDimension < o_ControlObject_Start.getControlDimensionCount(); ++intDimension) {
                                ControlObject.ControlDimension o_ControlDimension_Start = o_ControlObject_Start.getControlDimension(intDimension);
                                ControlObject.ControlDimension o_ControlDimension_End = o_ControlObject_End.getControlDimension(intDimension);
                                if (o_ControlDimension_Start == null || o_ControlDimension_End == null) continue;
                                o_ControlDimension_Start.addPropertyChangeListener((PropertyChangeListener)m_SelfReference);
                                o_ControlDimension_End.addPropertyChangeListener((PropertyChangeListener)m_SelfReference);
                            }
                        }
                    }
                });
            } else {
                this.clearCoincidence_DMXControlType();
            }
        }

        public void clearCoincidence_DMXControlType() {
            if (this.m_DMXControlComponent_Start == null) {
                return;
            }
            if (this.m_DMXControlComponent_End == null) {
                return;
            }
            this.m_DMXControlComponent_Start.setVisible(false);
            this.remove(this.m_DMXControlComponent_Start);
            this.m_DMXControlComponent_End.setVisible(false);
            this.remove(this.m_DMXControlComponent_End);
            for (int intControl = 0; intControl < this.m_DMXControlComponent_Start.getControlObjectCount(); ++intControl) {
                ControlObject o_ControlObject_Start = this.m_DMXControlComponent_Start.getControlObject(intControl);
                ControlObject o_ControlObject_End = this.m_DMXControlComponent_End.getControlObject(intControl);
                for (int intDimension = 0; intDimension < o_ControlObject_Start.getControlDimensionCount(); ++intDimension) {
                    ControlObject.ControlDimension o_ControlDimension_Start = o_ControlObject_Start.getControlDimension(intDimension);
                    ControlObject.ControlDimension o_ControlDimension_End = o_ControlObject_End.getControlDimension(intDimension);
                    o_ControlDimension_Start.removePropertyChangeListener((PropertyChangeListener)this);
                    o_ControlDimension_End.removePropertyChangeListener((PropertyChangeListener)this);
                    JControlMeter o_ControlMeter = this.m_DMXControlComponent_Start.getControlMeter(intControl, intDimension);
                    o_ControlMeter.clearControlDisplayItems();
                }
            }
            this.m_DMXControlComponent_Start = null;
            this.m_DMXControlComponent_End = null;
            this.m_Coincidence_DMXControlType = null;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() instanceof ControlObject.ControlDimension) {
                if (!"value".equals(evt.getPropertyName())) {
                    return;
                }
                ControlObject.ControlDimension o_ControlDimension = (ControlObject.ControlDimension)evt.getSource();
                ControlObject o_ControlObject = o_ControlDimension.getControlObject();
                int intIndexControlDimension = o_ControlObject.indexOf(o_ControlDimension);
                int intIndexControlObject = this.m_DMXControlComponent_Start.indexOf(o_ControlObject);
                if (intIndexControlObject >= 0) {
                    int intValue = (int)this.m_DMXControlComponent_Start.getValue(intIndexControlObject, intIndexControlDimension);
                    this.m_DMXFadeDescriptionPanel.setFadeValues(this.m_JFadePanel.getFadeType(), 0, intIndexControlObject, intIndexControlDimension, intValue);
                } else {
                    intIndexControlObject = this.m_DMXControlComponent_End.indexOf(o_ControlObject);
                    if (intIndexControlObject >= 0) {
                        int intValue = (int)this.m_DMXControlComponent_End.getValue(intIndexControlObject, intIndexControlDimension);
                        this.m_DMXFadeDescriptionPanel.setFadeValues(this.m_JFadePanel.getFadeType(), 1, intIndexControlObject, intIndexControlDimension, intValue);
                    }
                }
            }
        }

        @Override
        public void componentResized(ComponentEvent e) {
            if (this.getWidth() == this.m_OldSize.width && this.getHeight() == this.m_OldSize.height) {
                return;
            }
            this.m_OldSize.setSize(this.getWidth(), this.getHeight());
            if (this.m_DMXControlComponent_Start != null) {
                this.m_DMXControlComponent_Start.changedParentHeight(this.getHeight() - this.m_Label_End.getHeight());
            }
            if (this.m_DMXControlComponent_End != null) {
                this.m_DMXControlComponent_End.changedParentHeight(this.getHeight() - this.m_Label_End.getHeight());
            }
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentShown(ComponentEvent e) {
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }
    }

    public static class LabelFade
    extends JLabel {
        public static int SIZE = 17;
        public static final int OVALSIZE = 13;
        private JFadeStartEndPanel m_JFadeStartEndPanel;
        private AbsoluteConstraints m_Constraints;
        private int m_ParentFadeType;
        private int m_FadeStartEnd;
        private float m_Position;
        private String m_ToolTipText;
        private DMXFadeDescriptionPanel m_DMXFadeDescriptionPanel;
        private int m_MousePressedX;
        private MouseAdapter_Delayed m_MouseAdapter_Delayed;

        public LabelFade(JFadeStartEndPanel p_JFadeStartEndPanel, int p_FadeStartEnd) {
            this.m_JFadeStartEndPanel = p_JFadeStartEndPanel;
            this.m_DMXFadeDescriptionPanel = this.m_JFadeStartEndPanel.getDMXFadeDescriptionPanel();
            this.m_ParentFadeType = this.m_JFadeStartEndPanel.getFadeType();
            this.m_FadeStartEnd = p_FadeStartEnd;
            this.initComponents();
            this.addMouseMotionListener(this.m_MouseAdapter_Delayed);
            this.addMouseListener(this.m_MouseAdapter_Delayed);
        }

        private void initComponents() {
            this.createMouseAdapter_Delayed();
            this.m_Constraints = new AbsoluteConstraints(0, 0, 0, 0);
            boolean boolBorder = true;
            switch (this.m_ParentFadeType) {
                case 0: {
                    this.setCursor(Cursor.getPredefinedCursor(4));
                    this.m_ToolTipText = "FadeIn";
                    break;
                }
                case 1: {
                    this.setOpaque(true);
                    this.setCursor(Cursor.getPredefinedCursor(6));
                    this.m_ToolTipText = "FadeOut";
                }
            }
            switch (this.m_FadeStartEnd) {
                case 0: {
                    this.m_ToolTipText = this.m_ToolTipText + " Start";
                    break;
                }
                case 1: {
                    this.m_ToolTipText = this.m_ToolTipText + " End";
                }
            }
            this.setToolTipText(this.m_ToolTipText);
        }

        public void calculatePosition() {
            this.m_Constraints.width = SIZE;
            this.m_Constraints.height = SIZE;
            Dimension o_Size = this.m_JFadeStartEndPanel.getPreferredSize();
            int intWidth = o_Size.width;
            int intHeight = o_Size.height;
            switch (this.m_ParentFadeType) {
                case 0: {
                    if (this.m_FadeStartEnd == 0) {
                        this.m_Constraints.x = (int)((float)intWidth * this.m_Position) - SIZE / 2;
                        this.m_Constraints.y = intHeight - SIZE;
                        break;
                    }
                    this.m_Constraints.x = (int)((float)intWidth * this.m_Position) - SIZE / 2;
                    this.m_Constraints.y = 0;
                    break;
                }
                case 1: {
                    if (this.m_FadeStartEnd == 0) {
                        this.m_Constraints.x = (int)((float)intWidth * this.m_Position) - SIZE / 2;
                        this.m_Constraints.y = 0;
                        break;
                    }
                    this.m_Constraints.x = (int)((float)intWidth * this.m_Position) - SIZE / 2;
                    this.m_Constraints.y = intHeight - SIZE;
                }
            }
            this.m_JFadeStartEndPanel.revalidate();
        }

        @Override
        public void paintComponent(Graphics p_Graphics) {
            if (p_Graphics == null) {
                return;
            }
            Graphics2D o_Graphics2D = (Graphics2D)p_Graphics;
            Color o_OldColor = p_Graphics.getColor();
            switch (this.m_ParentFadeType) {
                case 0: 
                case 1: {
                    o_Graphics2D.setColor(Color.BLACK);
                    o_Graphics2D.drawOval((SIZE - 13) / 2 + 1, (SIZE - 13) / 2 + 1, 12, 12);
                    o_Graphics2D.setColor(Color.WHITE);
                    o_Graphics2D.drawOval((SIZE - 13) / 2, (SIZE - 13) / 2, 12, 12);
                    if (!this.isOpaque()) break;
                    o_Graphics2D.fillOval((SIZE - 13) / 2, (SIZE - 13) / 2, 12, 12);
                    break;
                }
                default: {
                    super.paintComponent(p_Graphics);
                }
            }
            o_Graphics2D.setColor(o_OldColor);
            p_Graphics.dispose();
        }

        public void setPosition(float p_Position) {
            if (this.m_Position == p_Position) {
                return;
            }
            this.m_Position = p_Position;
            this.calculatePosition();
        }

        public AbsoluteConstraints getAbsoluteConstraints() {
            return this.m_Constraints;
        }

        public void createMouseAdapter_Delayed() {
            this.m_MouseAdapter_Delayed = new MouseAdapter_Delayed(){

                @Override
                public void mouseClicked_Delayed(MouseEvent e) {
                    if (!this.isEnabled()) {
                        return;
                    }
                    if (e.getClickCount() > 1) {
                        if (m_FadeStartEnd == 0) {
                            m_DMXFadeDescriptionPanel.setFade(0.0f, m_ParentFadeType, m_FadeStartEnd);
                        } else {
                            m_DMXFadeDescriptionPanel.setFade(1.0f, m_ParentFadeType, m_FadeStartEnd);
                        }
                    }
                }

                @Override
                public void mousePressed_Delayed(MouseEvent e) {
                    m_MousePressedX = e.getX();
                }

                @Override
                public void mouseReleased_Delayed(MouseEvent e) {
                }

                @Override
                public void mouseEntered_Delayed(MouseEvent e) {
                }

                @Override
                public void mouseExited_Delayed(MouseEvent e) {
                }

                @Override
                public void mouseDragged_Delayed(MouseEvent e) {
                    if (!this.isEnabled()) {
                        return;
                    }
                    int intX = e.getPoint().x;
                    int intY = e.getPoint().y;
                    int intWidth = m_JFadeStartEndPanel.getWidth();
                    float floatNewPosition = m_Position + (float)(intX - m_MousePressedX) / (float)intWidth;
                    if (floatNewPosition > 1.0f) {
                        floatNewPosition = 1.0f;
                    }
                    if (floatNewPosition < 0.0f) {
                        floatNewPosition = 0.0f;
                    }
                    floatNewPosition = m_DMXFadeDescriptionPanel.checkSnapping(floatNewPosition, m_ParentFadeType, m_FadeStartEnd);
                    m_DMXFadeDescriptionPanel.setFade(floatNewPosition, m_ParentFadeType, m_FadeStartEnd);
                }

                @Override
                public void mouseMoved_Delayed(MouseEvent e) {
                }
            };
        }
    }

    public static class JFadeStartEndPanel
    extends JPanel
    implements PropertyChangeListener {
        private DMXFadeDescriptionPanel m_DMXFadeDescriptionPanel;
        private JFadePanel m_JFadePanel;
        private Rectangle m_RectComponent;
        private Color m_ColorBackground;
        private LabelFade m_LabelFadeStart;
        private LabelFade m_LabelFadeEnd;
        private Rectangle m_RectSize;

        public JFadeStartEndPanel(JFadePanel p_FadePanel) {
            this.initMembers();
            this.m_JFadePanel = p_FadePanel;
            this.m_DMXFadeDescriptionPanel = this.m_JFadePanel.getDMXFadeDescriptionPanel();
            this.initComponents();
            this.refresh();
        }

        private void initMembers() {
            this.m_RectComponent = new Rectangle();
            this.m_ColorBackground = Color.ORANGE;
            this.m_RectSize = new Rectangle();
        }

        private void initComponents() {
            this.setLayout((LayoutManager)new AbsoluteLayout());
            Dimension o_Dimension = new Dimension(150, 150);
            this.setPreferredSize(o_Dimension);
            this.setMinimumSize(o_Dimension);
            this.m_LabelFadeStart = new LabelFade(this, 0);
            AbsoluteConstraints o_AbsoluteConstraints = this.m_LabelFadeStart.getAbsoluteConstraints();
            this.add((Component)this.m_LabelFadeStart, o_AbsoluteConstraints);
            this.m_LabelFadeStart.calculatePosition();
            this.m_LabelFadeEnd = new LabelFade(this, 1);
            o_AbsoluteConstraints = this.m_LabelFadeEnd.getAbsoluteConstraints();
            this.add((Component)this.m_LabelFadeEnd, o_AbsoluteConstraints);
            this.m_LabelFadeEnd.calculatePosition();
            this.m_DMXFadeDescriptionPanel.addPropertyChangeListener(DMXFadeDescriptionPanel.PROP_PARAMSCHANGED, this);
        }

        public DMXFadeDescriptionPanel getDMXFadeDescriptionPanel() {
            return this.m_JFadePanel.getDMXFadeDescriptionPanel();
        }

        public JFadePanel getJFadePanel() {
            return this.m_JFadePanel;
        }

        public int getFadeType() {
            return this.m_JFadePanel.getFadeType();
        }

        public void refresh() {
            int intCount = this.m_DMXFadeDescriptionPanel.getDMXControlTypeFadeDescriptionCount();
            this.m_ColorBackground = intCount == 0 || this.m_DMXFadeDescriptionPanel.getDisabledAdjustment() != 1 ? Color.GRAY : (this.m_DMXFadeDescriptionPanel.getLiveShowObjectInterface() instanceof LiveShowDMXSceneBridge ? (((LiveShowDMXSceneBridge)this.m_DMXFadeDescriptionPanel.getLiveShowObjectInterface()).getIsMainBridge() ? Color.RED : Color.LIGHT_GRAY) : Color.ORANGE);
            if (intCount > 0 && this.m_DMXFadeDescriptionPanel.getDisabledAdjustment() == 1) {
                DMXFadeDescription.DMXControlTypeFadeDescription o_FadeDescription = this.m_DMXFadeDescriptionPanel.getDMXControlTypeFadeDescription(0);
                this.m_LabelFadeStart.setEnabled(true);
                this.m_LabelFadeEnd.setEnabled(true);
                switch (this.m_JFadePanel.getFadeType()) {
                    case 0: {
                        this.m_LabelFadeStart.setPosition(o_FadeDescription.getInternalFadeIn_Start());
                        this.m_LabelFadeEnd.setPosition(o_FadeDescription.getInternalFadeIn_End());
                        break;
                    }
                    case 1: {
                        this.m_LabelFadeStart.setPosition(o_FadeDescription.getInternalFadeOut_Start());
                        this.m_LabelFadeEnd.setPosition(o_FadeDescription.getInternalFadeOut_End());
                    }
                }
            } else {
                this.m_LabelFadeStart.setEnabled(false);
                this.m_LabelFadeEnd.setEnabled(false);
                this.m_LabelFadeStart.setPosition(0.0f);
                this.m_LabelFadeEnd.setPosition(1.0f);
            }
            this.revalidate();
            if (!SwingUtilities.isEventDispatchThread()) {
                // empty if block
            }
            this.repaint();
        }

        @Override
        public void paintComponent(Graphics p_Graphics) {
            super.paintComponent(p_Graphics);
            this.m_RectComponent.setBounds(0, 0, this.getWidth(), this.getHeight());
            if (this.m_RectComponent.getWidth() == 0.0 || this.m_RectComponent.getHeight() == 0.0) {
                return;
            }
            p_Graphics.setColor(this.m_ColorBackground);
            p_Graphics.fillRect(this.m_RectComponent.x, this.m_RectComponent.y, this.m_RectComponent.width, this.m_RectComponent.height);
            p_Graphics.setColor(Color.BLACK);
            ArrayList<Float> o_Tabs = this.m_DMXFadeDescriptionPanel.getTabs();
            for (int intTab = 1; intTab < o_Tabs.size() - 1; ++intTab) {
                int intX = (int)(o_Tabs.get(intTab).floatValue() * (float)this.m_RectComponent.width);
                p_Graphics.drawLine(intX, 0, intX, 7);
                p_Graphics.drawLine(intX, this.m_RectComponent.height, intX, this.m_RectComponent.height - 7);
            }
            p_Graphics.setColor(Color.WHITE);
            switch (this.m_JFadePanel.getFadeType()) {
                case 0: {
                    p_Graphics.drawLine(this.m_RectComponent.x, this.m_RectComponent.height, this.m_RectComponent.width, this.m_RectComponent.y);
                    break;
                }
                case 1: {
                    p_Graphics.drawLine(this.m_RectComponent.x, this.m_RectComponent.y, this.m_RectComponent.width, this.m_RectComponent.height);
                }
            }
            int intX_Start = 0;
            int intX_End = 1;
            int intY_Start = 0;
            int intY_End = 1;
            switch (this.m_JFadePanel.getFadeType()) {
                case 0: {
                    intY_Start = this.m_RectComponent.height;
                    intY_End = 0;
                    break;
                }
                case 1: {
                    intY_Start = 0;
                    intY_End = this.m_RectComponent.height;
                }
            }
            p_Graphics.setColor(Color.GRAY);
            for (int intDescription = this.m_DMXFadeDescriptionPanel.getDMXControlTypeFadeDescriptionCount() - 1; intDescription >= 0; --intDescription) {
                DMXFadeDescription.DMXControlTypeFadeDescription o_DMXControlTypeFadeDescription = this.m_DMXFadeDescriptionPanel.getDMXControlTypeFadeDescription(intDescription);
                switch (this.m_JFadePanel.getFadeType()) {
                    case 0: {
                        intX_Start = (int)(o_DMXControlTypeFadeDescription.getInternalFadeIn_Start() * (float)this.m_RectComponent.width);
                        intX_End = (int)(o_DMXControlTypeFadeDescription.getInternalFadeIn_End() * (float)this.m_RectComponent.width);
                        p_Graphics.drawRect(intX_Start - LabelFade.SIZE / 2, this.m_RectComponent.height - LabelFade.SIZE, LabelFade.SIZE, LabelFade.SIZE);
                        p_Graphics.drawRect(intX_End - LabelFade.SIZE / 2, 0, LabelFade.SIZE, LabelFade.SIZE);
                        break;
                    }
                    case 1: {
                        intX_Start = (int)(o_DMXControlTypeFadeDescription.getInternalFadeOut_Start() * (float)this.m_RectComponent.width);
                        intX_End = (int)(o_DMXControlTypeFadeDescription.getInternalFadeOut_End() * (float)this.m_RectComponent.width);
                        p_Graphics.drawRect(intX_Start - LabelFade.SIZE / 2, 0, LabelFade.SIZE, LabelFade.SIZE);
                        p_Graphics.drawRect(intX_End - LabelFade.SIZE / 2, this.m_RectComponent.height - LabelFade.SIZE, LabelFade.SIZE, LabelFade.SIZE);
                    }
                }
                if (intDescription == 0) {
                    p_Graphics.setColor(Color.BLACK);
                }
                p_Graphics.drawLine(intX_Start, intY_Start, intX_End, intY_End);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
        }
    }

    public static class JFadePanel
    extends JPanel
    implements PropertyChangeListener {
        public static String TITLE_FADEIN = "Fade In";
        public static String TITLE_FADEOUT = "Fade Out";
        private DMXFadeDescriptionPanel m_DMXFadeDescriptionPanel;
        private JLabel m_JLabelTitle;
        private JFadeStartEndPanel m_JFadeStartEndPanel;
        private JFadeControlsMinMaxPanel m_JFadeControlsMinMaxPanel;
        private int m_FadeType;

        public JFadePanel(DMXFadeDescriptionPanel p_DMXFadeDescriptionPanel, int p_FadeType) {
            this.initMembers();
            this.m_DMXFadeDescriptionPanel = p_DMXFadeDescriptionPanel;
            this.m_FadeType = p_FadeType;
            this.initComponents();
        }

        private void initMembers() {
            this.m_FadeType = 0;
        }

        private void initComponents() {
            this.setLayout(new GridBagLayout());
            this.m_JLabelTitle = new JLabel();
            this.m_JLabelTitle.setForeground(Color.WHITE);
            this.m_JLabelTitle.setHorizontalAlignment(0);
            GridBagConstraints o_GridBagConstraints = new GridBagConstraints();
            o_GridBagConstraints.gridx = 0;
            o_GridBagConstraints.gridy = 0;
            o_GridBagConstraints.insets = new Insets(3, 3, 3, 3);
            o_GridBagConstraints.fill = 2;
            o_GridBagConstraints.weightx = 1.0;
            this.add((Component)this.m_JLabelTitle, o_GridBagConstraints);
            switch (this.m_FadeType) {
                case 0: {
                    this.m_JLabelTitle.setText(TITLE_FADEIN);
                    break;
                }
                case 1: {
                    this.m_JLabelTitle.setText(TITLE_FADEOUT);
                }
            }
            this.m_JFadeStartEndPanel = new JFadeStartEndPanel(this);
            this.m_JFadeStartEndPanel.setVisible(true);
            o_GridBagConstraints.gridy = 2;
            o_GridBagConstraints.fill = 0;
            o_GridBagConstraints.weightx = 0.0;
            o_GridBagConstraints.weighty = 0.0;
            this.add((Component)this.m_JFadeStartEndPanel, o_GridBagConstraints);
            this.m_JFadeControlsMinMaxPanel = new JFadeControlsMinMaxPanel(this);
            this.m_JFadeControlsMinMaxPanel.setVisible(true);
            o_GridBagConstraints.gridx = 0;
            o_GridBagConstraints.gridy = 3;
            o_GridBagConstraints.fill = 1;
            o_GridBagConstraints.weightx = 1.0;
            o_GridBagConstraints.weighty = 1.0;
            this.add((Component)this.m_JFadeControlsMinMaxPanel, o_GridBagConstraints);
            this.m_DMXFadeDescriptionPanel.addPropertyChangeListener(DMXFadeDescriptionPanel.PROP_PARAMSCHANGED, this);
            this.setToolTipText(TOOLTIPTEXT_FADEBEHAVIOUR);
            this.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        }

        public DMXFadeDescriptionPanel getDMXFadeDescriptionPanel() {
            return this.m_DMXFadeDescriptionPanel;
        }

        public JFadeStartEndPanel getJFadeStartEndPanel() {
            return this.m_JFadeStartEndPanel;
        }

        public int getFadeType() {
            return this.m_FadeType;
        }

        public void setCoincidence_DMXControlType(DMXControlComponent.DMXControlType p_DMXControlType) {
            this.m_JFadeControlsMinMaxPanel.setCoincidence_DMXControlType(p_DMXControlType);
        }

        public void refresh() {
            if (this.m_DMXFadeDescriptionPanel.getDisabledAdjustment() == 1) {
                this.m_JFadeStartEndPanel.setEnabled(true);
                this.m_JFadeControlsMinMaxPanel.setEnabled(true);
            } else {
                this.m_JFadeStartEndPanel.setEnabled(false);
                this.m_JFadeControlsMinMaxPanel.setEnabled(false);
            }
            this.m_JFadeStartEndPanel.refresh();
            this.m_JFadeControlsMinMaxPanel.refresh();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() instanceof DMXFadeDescriptionPanel && DMXFadeDescriptionPanel.PROP_PARAMSCHANGED.equals(evt.getPropertyName())) {
                this.refresh();
            }
        }
    }
}

