/*
 * Decompiled with CFR 0.152.
 */
package DMXMixer;

import DMX512.DMXUniverseInputPatch;
import DMXDevicePackage.DMXDevice;
import DMXDevicePackage.DMXDeviceFunctionPanel;
import DMXDevicePackage.DMXDeviceType;
import DMXGraphics.LiveShowDMXStageView;
import DMXMixer.DMXControlComponent;
import DMXMixer.DMXControlComponentPool;
import DMXMixer.DMXControlDescription;
import DMXMixer.DMXControl_GridPanTilt;
import JarLoader.JarClassLoader;
import JarLoader.JarResources;
import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LanguageTools.LiveLanguagePackage.LiveLanguageString;
import LiveShowControlObjects.ControlGroup;
import LiveShowControlObjects.ControlObject;
import LiveShowControls.JControlGrid;
import LiveShowControls.JControlKnob;
import LiveShowControls.JControlSlider;
import LiveShowControls.JControlSwitch;
import LiveShowObjectPackage.LiveShowProjectDescription;
import LiveShowVirtualPackage.LiveShow_ImportDescription;
import StartPackage.LiveShowDMXSystem;
import SwingComponents.MouseAdapter_Delayed;
import SwingFramePackage.JOptionDialog;
import SwingModelPackage.TableAndListModel;
import SwingToolTipPackage.PopUpToolTip;
import SynchronizationPackage.EventQueueHandler;
import SynchronizationPackage.LiveCloseSemaphore;
import ToolsGraphics.JPanelBackground;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Externalizable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;

public class DMXMixerPanel
extends JPanel
implements Externalizable,
ComponentListener,
PropertyChangeListener,
DMXControlComponentPool {
    public static final int SOFTWAREVERSION = 2;
    public static final String FILESUFFIX = ".lsx";
    public static String DMXMIXERPANEL_NAMENEW = "Panel";
    public static final String PROP_DMXMIXERPANEL_NAME = "name";
    public static final String PROP_DMXMIXERPANEL_REMARK = "dmxmixerpanelRemark";
    public static final int OWNER_STAGEVIEW = 0;
    public static final int OWNER_MAINMIXER = 1;
    public static final int OWNER_DMXMIXER = 2;
    public static final int OWNER_DMXEDITOR = 3;
    @LiveLanguageString
    public static String s_OnlyOneDimmerAllowed_Titel = "Only one dimmer allowed";
    @LiveLanguageString
    public static String s_OnlyOneDimmerAllowed_Text = "<html>Only one main dimmer is allowed.<br>Use FreeFaders for sub dimmers and activate its 'Use as dimmer' option.</html>";
    public static final int CONTROLGROUP_CATEGORY_DEVICESGROUPS = 10;
    public static int s_ControlGroup_ChangeType_Devices = 0;
    protected static DMXMixerPanelTableModel s_DMXMixerPanelTableModel = new DMXMixerPanelTableModel();
    protected static int s_DMXMixerPanelCount = -3;
    private DMXControlComponent.DMXControlComponentList m_DMXControlComponentList;
    private ArrayList<DMXControlComponent> m_SelectedDMXControlComponents;
    protected String m_Name;
    protected String m_Remark;
    private int m_FadeWidth;
    protected GridBagConstraints m_GridBagConstraints;
    protected ArrayList<DMXMixerPanelListener> m_DMXMixerPanelListeners;
    protected MouseListener m_MouseListener;
    protected final Object m_SyncSelectionListener = new Object();
    protected final Object m_SyncDMXObjects = new Object();
    private LiveCloseSemaphore m_LiveCloseSemaphore;
    private DMXDevice.TreeModel_Device_Channels m_DMXDeviceTreeModel;
    private StringBuilder m_StringBuilderDevice;
    private final Object m_SyncStringBuilder = new Object();
    protected final Object m_SyncDMXDevices = new Object();
    private ArrayList<DMXDevice> m_DMXDevices;
    private HashMap<DMXControlComponent, ControlGroup.ControlGroupSet> m_ControlGroups;
    private Border m_Border_ControlGroup_ChangeType_Same;
    private Border m_Border_ControlGroup_ChangeType_Difference;
    private Border m_Border_ControlGroup_ChangeType_Percent;
    private Border m_Border_ControlGroup_ChangeType_Assimilate;
    private Dimension m_OldSize;
    private int m_Owner;
    private Runnable m_RunnableRepaint;
    private Runnable m_RunnableResetScrollPane;
    private DMXDeviceFunctionPanel dMXDeviceFunctionPanel1;
    private JButton jButton_ControlGroup_Change_Assimilate;
    private JButton jButton_ControlGroup_Change_Difference;
    private JButton jButton_ControlGroup_Change_Percent;
    private JButton jButton_ControlGroup_Change_Same;
    private JLabel jLabel_Name;
    private JPanel jPanel_ControlGroupChangeType;
    private JPanelBackground jPanel_InnerPanel;
    private JScrollPane jScrollPane_DMXMixerPanel;

    public DMXMixerPanel() {
        this.initMembers();
        this.initComponents();
        this.initComponentsFurther();
        if (++s_DMXMixerPanelCount <= DMXMixerPanel.getDMXMixerPanelCount() - 3) {
            s_DMXMixerPanelCount = DMXMixerPanel.getDMXMixerPanelCount() - 3 + 1;
        }
        this.setName(DMXMIXERPANEL_NAMENEW + String.valueOf(s_DMXMixerPanelCount));
        LiveLanguage.addLanguageListener((Object)this, null);
    }

    private void initMembers() {
        this.m_LiveCloseSemaphore = new LiveCloseSemaphore(this.getClass().getSimpleName());
        this.m_OldSize = new Dimension(0, 0);
        this.m_Name = "";
        this.m_Remark = "";
        this.m_DMXDevices = new ArrayList();
        this.m_DMXControlComponentList = new DMXControlComponent.DMXControlComponentList();
        this.m_SelectedDMXControlComponents = new ArrayList();
        this.m_Owner = 0;
        this.m_FadeWidth = 60;
        this.m_DMXMixerPanelListeners = new ArrayList();
        this.m_DMXDeviceTreeModel = null;
        this.m_StringBuilderDevice = new StringBuilder();
        this.m_ControlGroups = new HashMap();
        this.m_Border_ControlGroup_ChangeType_Same = new LineBorder(ControlGroup.CHANGECOLOR_VALUE_SAME, 1);
        this.m_Border_ControlGroup_ChangeType_Difference = new LineBorder(ControlGroup.CHANGECOLOR_VALUE_DIFFERENCE, 1);
        this.m_Border_ControlGroup_ChangeType_Percent = new LineBorder(ControlGroup.CHANGECOLOR_VALUE_PERCENT, 1);
        this.m_Border_ControlGroup_ChangeType_Assimilate = new LineBorder(ControlGroup.CHANGECOLOR_VALUE_ASSIMILATE, 1);
        this.m_RunnableRepaint = new Runnable(){

            @Override
            public void run() {
                DMXMixerPanel.this.jPanel_InnerPanel.revalidate();
                DMXMixerPanel.this.jPanel_InnerPanel.repaint();
                DMXMixerPanel.this.revalidate();
                DMXMixerPanel.this.repaint();
            }
        };
        this.m_RunnableResetScrollPane = new Runnable(){

            @Override
            public void run() {
                DMXMixerPanel.this.resetScrollPane();
            }
        };
    }

    private void initComponents() {
        this.jScrollPane_DMXMixerPanel = new JScrollPane();
        this.jPanel_InnerPanel = new JPanelBackground();
        this.jLabel_Name = new JLabel();
        this.dMXDeviceFunctionPanel1 = new DMXDeviceFunctionPanel();
        this.jPanel_ControlGroupChangeType = new JPanel();
        this.jButton_ControlGroup_Change_Same = new JButton();
        this.jButton_ControlGroup_Change_Difference = new JButton();
        this.jButton_ControlGroup_Change_Percent = new JButton();
        this.jButton_ControlGroup_Change_Assimilate = new JButton();
        this.setLayout(new GridBagLayout());
        this.jScrollPane_DMXMixerPanel.setBorder(null);
        this.jPanel_InnerPanel.setOpaque(true);
        this.jPanel_InnerPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DMXMixerPanel.this.jPanel_InnerPanelMouseClicked(evt);
            }
        });
        this.jPanel_InnerPanel.setLayout(new GridBagLayout());
        this.jScrollPane_DMXMixerPanel.setViewportView(this.jPanel_InnerPanel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPane_DMXMixerPanel, gridBagConstraints);
        this.jLabel_Name.setForeground(new Color(255, 255, 255));
        this.jLabel_Name.setHorizontalAlignment(0);
        this.jLabel_Name.setText("jLabel1");
        this.jLabel_Name.setMaximumSize(new Dimension(34, 20));
        this.jLabel_Name.setMinimumSize(new Dimension(34, 20));
        this.jLabel_Name.setPreferredSize(new Dimension(34, 20));
        this.jLabel_Name.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DMXMixerPanel.this.jLabel_NameMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jLabel_Name, gridBagConstraints);
        this.dMXDeviceFunctionPanel1.setMinimumSize(new Dimension(0, 34));
        this.dMXDeviceFunctionPanel1.setPreferredSize(new Dimension(100, 34));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.add((Component)this.dMXDeviceFunctionPanel1, gridBagConstraints);
        this.jPanel_ControlGroupChangeType.setLayout(new GridBagLayout());
        this.jButton_ControlGroup_Change_Same.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Slider_ValuesSame.png")));
        this.jButton_ControlGroup_Change_Same.setToolTipText("Control group change type: same values");
        this.jButton_ControlGroup_Change_Same.setContentAreaFilled(false);
        this.jButton_ControlGroup_Change_Same.setFocusable(false);
        this.jButton_ControlGroup_Change_Same.setHorizontalTextPosition(0);
        this.jButton_ControlGroup_Change_Same.setMargin(new Insets(2, 3, 2, 3));
        this.jButton_ControlGroup_Change_Same.setMaximumSize(new Dimension(32, 32));
        this.jButton_ControlGroup_Change_Same.setMinimumSize(new Dimension(32, 32));
        this.jButton_ControlGroup_Change_Same.setPreferredSize(new Dimension(32, 32));
        this.jButton_ControlGroup_Change_Same.setVerticalTextPosition(3);
        this.jButton_ControlGroup_Change_Same.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DMXMixerPanel.this.jButton_ControlGroup_Change_SameActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_ControlGroupChangeType.add((Component)this.jButton_ControlGroup_Change_Same, gridBagConstraints);
        this.jButton_ControlGroup_Change_Difference.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Slider_ValuesDifference.png")));
        this.jButton_ControlGroup_Change_Difference.setToolTipText("Control group change type:keep values difference");
        this.jButton_ControlGroup_Change_Difference.setContentAreaFilled(false);
        this.jButton_ControlGroup_Change_Difference.setFocusable(false);
        this.jButton_ControlGroup_Change_Difference.setHorizontalTextPosition(0);
        this.jButton_ControlGroup_Change_Difference.setMargin(new Insets(2, 3, 2, 3));
        this.jButton_ControlGroup_Change_Difference.setMaximumSize(new Dimension(32, 32));
        this.jButton_ControlGroup_Change_Difference.setMinimumSize(new Dimension(32, 32));
        this.jButton_ControlGroup_Change_Difference.setPreferredSize(new Dimension(32, 32));
        this.jButton_ControlGroup_Change_Difference.setVerticalTextPosition(3);
        this.jButton_ControlGroup_Change_Difference.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DMXMixerPanel.this.jButton_ControlGroup_Change_DifferenceActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_ControlGroupChangeType.add((Component)this.jButton_ControlGroup_Change_Difference, gridBagConstraints);
        this.jButton_ControlGroup_Change_Percent.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Slider_ValuesPercent.png")));
        this.jButton_ControlGroup_Change_Percent.setToolTipText("Control group change type: percentage values");
        this.jButton_ControlGroup_Change_Percent.setContentAreaFilled(false);
        this.jButton_ControlGroup_Change_Percent.setFocusable(false);
        this.jButton_ControlGroup_Change_Percent.setHorizontalTextPosition(0);
        this.jButton_ControlGroup_Change_Percent.setMargin(new Insets(2, 3, 2, 3));
        this.jButton_ControlGroup_Change_Percent.setMaximumSize(new Dimension(32, 32));
        this.jButton_ControlGroup_Change_Percent.setMinimumSize(new Dimension(32, 32));
        this.jButton_ControlGroup_Change_Percent.setPreferredSize(new Dimension(32, 32));
        this.jButton_ControlGroup_Change_Percent.setVerticalTextPosition(3);
        this.jButton_ControlGroup_Change_Percent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DMXMixerPanel.this.jButton_ControlGroup_Change_PercentActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_ControlGroupChangeType.add((Component)this.jButton_ControlGroup_Change_Percent, gridBagConstraints);
        this.jButton_ControlGroup_Change_Assimilate.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Slider_ValuesAssimilate.png")));
        this.jButton_ControlGroup_Change_Assimilate.setToolTipText("Control group change type: assimilate values to 100% or 0%");
        this.jButton_ControlGroup_Change_Assimilate.setContentAreaFilled(false);
        this.jButton_ControlGroup_Change_Assimilate.setFocusable(false);
        this.jButton_ControlGroup_Change_Assimilate.setHorizontalTextPosition(0);
        this.jButton_ControlGroup_Change_Assimilate.setMargin(new Insets(2, 3, 2, 3));
        this.jButton_ControlGroup_Change_Assimilate.setMaximumSize(new Dimension(32, 32));
        this.jButton_ControlGroup_Change_Assimilate.setMinimumSize(new Dimension(32, 32));
        this.jButton_ControlGroup_Change_Assimilate.setPreferredSize(new Dimension(32, 32));
        this.jButton_ControlGroup_Change_Assimilate.setVerticalTextPosition(3);
        this.jButton_ControlGroup_Change_Assimilate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DMXMixerPanel.this.jButton_ControlGroup_Change_AssimilateActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_ControlGroupChangeType.add((Component)this.jButton_ControlGroup_Change_Assimilate, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.add((Component)this.jPanel_ControlGroupChangeType, gridBagConstraints);
    }

    private void jLabel_NameMouseClicked(MouseEvent evt) {
        this.notifyListener_MixerPanelSelection();
    }

    private void jPanel_InnerPanelMouseClicked(MouseEvent evt) {
        this.notifyListener_MixerPanelSelection();
    }

    private void jButton_ControlGroup_Change_SameActionPerformed(ActionEvent evt) {
        this.setControlGroupsChangeType(10, 0);
    }

    private void jButton_ControlGroup_Change_DifferenceActionPerformed(ActionEvent evt) {
        this.setControlGroupsChangeType(10, 1);
    }

    private void jButton_ControlGroup_Change_PercentActionPerformed(ActionEvent evt) {
        this.setControlGroupsChangeType(10, 3);
    }

    private void jButton_ControlGroup_Change_AssimilateActionPerformed(ActionEvent evt) {
        this.setControlGroupsChangeType(10, 2);
    }

    private void initComponentsFurther() {
        this.setJarRessources(LiveShowDMXSystem.s_JarResources_Default);
        this.addComponentListener(this);
        this.dMXDeviceFunctionPanel1.setOrientation(0);
        this.setControlFunctionsVisible(false);
        this.m_MouseListener = new MouseAdapter_Delayed(){

            @Override
            public void mouseClicked_Delayed(MouseEvent e) {
                if (DMXMixerPanel.this.m_Owner == 0) {
                    return;
                }
                if (DMXMixerPanel.this.m_Owner == 1) {
                    return;
                }
                if (e.getClickCount() == 1 && (e.getSource() instanceof DMXControlComponent || e.getSource() instanceof JControlSlider.SliderAdjuster || e.getSource() instanceof JControlSwitch.SliderAdjuster || e.getSource() instanceof JControlGrid.GridAdjuster || e.getSource() instanceof JControlKnob.KnobAdjuster) && e.getClickCount() == 1) {
                    DMXControlComponent o_DMXControlComponent = DMXMixerPanel.this.getDMXControlComponent(e.getComponent());
                    if (o_DMXControlComponent == null) {
                        return;
                    }
                    if (e.isControlDown() || e.isShiftDown()) {
                        if (DMXMixerPanel.this.m_SelectedDMXControlComponents.contains(o_DMXControlComponent)) {
                            DMXMixerPanel.this.removeSelectedControlComponent(o_DMXControlComponent);
                        } else {
                            DMXMixerPanel.this.addSelectedControlComponent(o_DMXControlComponent);
                        }
                    } else if (DMXMixerPanel.this.m_SelectedDMXControlComponents.contains(o_DMXControlComponent)) {
                        DMXMixerPanel.this.clearSelectedControlComponents();
                    } else {
                        DMXMixerPanel.this.clearSelectedControlComponents();
                        DMXMixerPanel.this.addSelectedControlComponent(o_DMXControlComponent);
                    }
                }
            }
        };
        DMXDevice.getTreeModel_Device_Channels().addPropertyChangeListener(this);
        this.refreshChangeTypeButtons(10);
        this.jPanel_ControlGroupChangeType.setVisible(false);
        this.jButton_ControlGroup_Change_Assimilate.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_ControlGroup_Change_Difference.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_ControlGroup_Change_Percent.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_ControlGroup_Change_Same.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jPanel_InnerPanel.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jLabel_Name.setComponentPopupMenu(PopUpToolTip.getSelfReference());
    }

    public void setJarRessources(JarResources p_JarResources) {
        this.jPanel_InnerPanel.setBackgroundOpaque(true);
        if (p_JarResources != null) {
            this.jPanel_InnerPanel.setBackgroundStyle(0);
            byte[] o_Bytes = p_JarResources.getResource("LiveShowControls/Background");
            Image o_Image = null;
            if (o_Bytes != null) {
                try {
                    o_Image = Toolkit.getDefaultToolkit().createImage(o_Bytes);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.jPanel_InnerPanel.setBackgroundImage(o_Image);
            JarClassLoader o_JarClassLoader = p_JarResources.getJarClassLoader();
            if (o_JarClassLoader != null) {
                try {
                    Class o_Class = o_JarClassLoader.loadClass("LiveShowControls.Colors");
                    Field o_Field = o_Class.getDeclaredField("Mixer_Background");
                    Color o_Color = (Color)o_Field.get(o_Class);
                    this.setBackground(o_Color);
                    this.jPanel_InnerPanel.setBackground(o_Color);
                }
                catch (Exception e) {
                    e.getMessage();
                }
            }
        } else {
            this.jPanel_InnerPanel.setBackgroundImage(null);
            this.jPanel_InnerPanel.setBackground(Color.BLACK);
            this.jPanel_InnerPanel.setBackgroundStyle(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        LiveLanguage.removeLanguageListener((Object)this);
        this.jButton_ControlGroup_Change_Assimilate.setComponentPopupMenu(null);
        this.jButton_ControlGroup_Change_Difference.setComponentPopupMenu(null);
        this.jButton_ControlGroup_Change_Percent.setComponentPopupMenu(null);
        this.jButton_ControlGroup_Change_Same.setComponentPopupMenu(null);
        this.jPanel_InnerPanel.setComponentPopupMenu(null);
        this.jLabel_Name.setComponentPopupMenu(null);
        if (!this.m_LiveCloseSemaphore.enterCloseSection()) {
            return;
        }
        this.unlinkLabelListConditions();
        DMXDevice.getTreeModel_Device_Channels().removePropertyChangeListener(this);
        this.clearSelectedControlComponents();
        this.notifyListener_MixerPanelClose();
        if (this.m_DMXMixerPanelListeners != null) {
            this.m_DMXMixerPanelListeners.clear();
        }
        Object object = this.m_SyncDMXObjects;
        synchronized (object) {
            if (this.m_DMXControlComponentList != null) {
                int intDMXControlCount = this.m_DMXControlComponentList.size();
                for (int intDMXControl = intDMXControlCount - 1; intDMXControl >= 0; --intDMXControl) {
                    DMXControlComponent o_DMXControlComponent = (DMXControlComponent)this.m_DMXControlComponentList.get(intDMXControl);
                    if (o_DMXControlComponent == null) continue;
                    this.removeControlComponent(o_DMXControlComponent, false);
                }
                this.m_DMXControlComponentList.close();
            }
        }
        this.clearDMXDevices();
        this.m_LiveCloseSemaphore.leaveCloseSection();
        LiveLanguage.removeLanguageListener((Object)this);
    }

    public void setOwner(int p_Owner) {
        this.m_Owner = p_Owner;
    }

    public int getOwner() {
        return this.m_Owner;
    }

    public DMXControlComponent getDMXControlComponent(Component p_Component) {
        DMXControlComponent o_DMXControlComponent = null;
        Component o_Component = p_Component;
        while (o_DMXControlComponent == null && o_Component != null) {
            if (o_Component instanceof DMXControlComponent) {
                o_DMXControlComponent = (DMXControlComponent)o_Component;
                continue;
            }
            if (o_Component.getParent() instanceof JComponent) {
                o_Component = (JComponent)o_Component.getParent();
                continue;
            }
            o_Component = null;
        }
        return o_DMXControlComponent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearDMXDevices() {
        Object object = this.m_SyncDMXDevices;
        synchronized (object) {
            for (int intDevice = this.m_DMXDevices.size() - 1; intDevice >= 0; --intDevice) {
                DMXDevice o_DMXDevice = this.m_DMXDevices.get(intDevice);
                this.removeDMXDevice(o_DMXDevice);
            }
        }
    }

    public void setControlFunctionsVisible(boolean p_Visible) {
        this.dMXDeviceFunctionPanel1.setVisible(p_Visible);
    }

    public void addDMXDevice(DMXDevice p_DMXDevice) {
        if (p_DMXDevice == null) {
            return;
        }
        this.checkControlGroups(p_DMXDevice, null);
    }

    public void removeDMXDevice(DMXDevice p_DMXDevice) {
        if (p_DMXDevice == null) {
            return;
        }
        this.checkControlGroups(null, p_DMXDevice);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DMXDevice getDMXDevice(int p_Index) {
        Object object = this.m_SyncDMXDevices;
        synchronized (object) {
            if (p_Index < 0) {
                return null;
            }
            if (p_Index >= this.m_DMXDevices.size()) {
                return null;
            }
            return this.m_DMXDevices.get(p_Index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkControlGroups(DMXDevice p_AddedDMXDevice, DMXDevice p_RemovedDMXDevice) {
        int intDMXControl;
        ControlGroup.ControlGroupSet o_ControlGroupSet;
        DMXControlComponent o_DMXControlComponentFirst;
        Object object;
        if (p_AddedDMXDevice == null && p_RemovedDMXDevice == null) {
            return;
        }
        DMXDevice o_DMXDeviceFirst = null;
        boolean boolFirstDMXDeviceAdded = false;
        ArrayList<DMXControlComponent> o_DMXControlComponents = null;
        ArrayList<DMXControlComponent> o_DMXControlComponentsInOneGroup = new ArrayList<DMXControlComponent>();
        boolFirstDMXDeviceAdded = false;
        boolean boolFirstDMXDeviceRemoved = false;
        if (p_AddedDMXDevice != null) {
            object = this.m_SyncDMXDevices;
            synchronized (object) {
                if (this.m_DMXDevices.contains(p_AddedDMXDevice)) {
                    return;
                }
                if (this.m_DMXDevices.size() == 0) {
                    boolFirstDMXDeviceAdded = true;
                }
                this.m_DMXDevices.add(p_AddedDMXDevice);
            }
            DMXUniverseInputPatch.addSelectedDMXDevice(p_AddedDMXDevice);
            p_AddedDMXDevice.addPropertyChangeListener(this);
            this.dMXDeviceFunctionPanel1.addDMXDevice(p_AddedDMXDevice);
            o_DMXDeviceFirst = this.m_DMXDevices.get(0);
        }
        if (p_RemovedDMXDevice != null) {
            object = this.m_SyncDMXDevices;
            synchronized (object) {
                if (this.m_DMXDevices.size() <= 0 || !this.m_DMXDevices.contains(p_RemovedDMXDevice)) {
                    return;
                }
                if (this.m_DMXDevices.get(0) == p_RemovedDMXDevice) {
                    boolFirstDMXDeviceRemoved = true;
                    o_DMXDeviceFirst = p_RemovedDMXDevice;
                } else {
                    o_DMXDeviceFirst = this.m_DMXDevices.get(0);
                }
                this.m_DMXDevices.remove(p_RemovedDMXDevice);
            }
            DMXUniverseInputPatch.removeSelectedDMXDevice(p_RemovedDMXDevice);
            p_RemovedDMXDevice.removePropertyChangeListener(this);
            this.dMXDeviceFunctionPanel1.removeDMXDevice(p_RemovedDMXDevice);
        }
        for (int intDMXControlComponent = 0; intDMXControlComponent < o_DMXDeviceFirst.getDMXControlComponentCount(); ++intDMXControlComponent) {
            o_DMXControlComponentFirst = o_DMXDeviceFirst.getDMXControlComponent(intDMXControlComponent);
            o_ControlGroupSet = this.m_ControlGroups.get(o_DMXControlComponentFirst);
            if (o_ControlGroupSet == null) continue;
            if (boolFirstDMXDeviceRemoved) {
                o_ControlGroupSet.close();
                this.m_ControlGroups.remove(o_DMXControlComponentFirst);
                continue;
            }
            o_ControlGroupSet.clearControlGroups();
        }
        if (this.m_DMXDevices.size() <= 0) {
            this.jPanel_ControlGroupChangeType.setVisible(false);
            this.removeAllControlComponents();
            this.refreshName(null);
            return;
        }
        if (this.m_DMXDevices.size() == 1) {
            o_DMXDeviceFirst = this.getDMXDevice(0);
            if (boolFirstDMXDeviceRemoved) {
                this.removeAllControlComponents();
            }
            if (o_DMXDeviceFirst != null) {
                for (intDMXControl = 0; intDMXControl < o_DMXDeviceFirst.getDMXControlComponentCount(); ++intDMXControl) {
                    o_DMXControlComponentFirst = o_DMXDeviceFirst.getDMXControlComponent(intDMXControl);
                    if (o_DMXControlComponentFirst == null) continue;
                    o_DMXControlComponentFirst.setEnableSettings(false);
                    if (boolFirstDMXDeviceAdded || boolFirstDMXDeviceRemoved) {
                        this.addDMXControlComponent(o_DMXControlComponentFirst);
                    }
                    this.showDMXControlComponent(o_DMXControlComponentFirst, intDMXControl);
                }
                this.refreshName(o_DMXDeviceFirst);
            }
            this.jPanel_ControlGroupChangeType.setVisible(false);
        } else if (this.m_DMXDevices.size() > 1) {
            o_DMXDeviceFirst = this.getDMXDevice(0);
            if (boolFirstDMXDeviceAdded || boolFirstDMXDeviceRemoved) {
                if (boolFirstDMXDeviceRemoved) {
                    this.removeAllControlComponents();
                }
                if (o_DMXDeviceFirst != null) {
                    for (intDMXControl = 0; intDMXControl < o_DMXDeviceFirst.getDMXControlComponentCount(); ++intDMXControl) {
                        o_DMXControlComponentFirst = o_DMXDeviceFirst.getDMXControlComponent(intDMXControl);
                        if (o_DMXControlComponentFirst == null) continue;
                        o_DMXControlComponentFirst.setEnableSettings(false);
                        this.addDMXControlComponent(o_DMXControlComponentFirst);
                    }
                    this.refreshName(o_DMXDeviceFirst);
                }
            }
            this.jPanel_ControlGroupChangeType.setVisible(true);
            ArrayList<DMXControlComponent> o_UsedDMXControlComponents = new ArrayList<DMXControlComponent>();
            for (int intDMXControlComponent = 0; intDMXControlComponent < o_DMXDeviceFirst.getDMXControlComponentCount(); ++intDMXControlComponent) {
                o_DMXControlComponentFirst = o_DMXDeviceFirst.getDMXControlComponent(intDMXControlComponent);
                if (o_DMXControlComponentFirst == null) continue;
                DMXControlDescription o_DMXControlDescriptionFirst = o_DMXControlComponentFirst.getDMXControlType().getDMXControlDescription();
                int intDMXControlComponentFirstCountByDescription = o_DMXDeviceFirst.getDMXControlComponentCountByDescription(o_DMXControlDescriptionFirst.getID());
                o_ControlGroupSet = this.m_ControlGroups.get(o_DMXControlComponentFirst);
                if (o_ControlGroupSet == null) {
                    ControlGroup o_ControlGroup;
                    o_ControlGroupSet = new ControlGroup.ControlGroupSet();
                    o_ControlGroupSet.setMembershipObject((Object)o_DMXControlComponentFirst);
                    this.m_ControlGroups.put(o_DMXControlComponentFirst, o_ControlGroupSet);
                    if (o_DMXControlComponentFirst instanceof DMXControl_GridPanTilt) {
                        o_ControlGroup = new ControlGroup(10, s_ControlGroup_ChangeType_Devices);
                        o_ControlGroupSet.addControlGroup(o_ControlGroup);
                        o_ControlGroup = new ControlGroup(10, s_ControlGroup_ChangeType_Devices);
                        o_ControlGroupSet.addControlGroup(o_ControlGroup);
                    } else {
                        for (int intControl = 0; intControl < o_DMXControlComponentFirst.getControlObjectCount(); ++intControl) {
                            o_ControlGroup = new ControlGroup(10, s_ControlGroup_ChangeType_Devices);
                            o_ControlGroupSet.addControlGroup(o_ControlGroup);
                        }
                    }
                }
                o_DMXControlComponentsInOneGroup.clear();
                boolean boolAllDMXDevicesHaveDMXControl = true;
                block11: for (int intDMXDevice = 0; intDMXDevice < this.m_DMXDevices.size(); ++intDMXDevice) {
                    DMXControlComponent o_DMXControlComponent;
                    DMXDevice o_DMXDevice = this.getDMXDevice(intDMXDevice);
                    if (o_DMXDevice == null) continue;
                    if (o_DMXControlDescriptionFirst.getID().equals(DMXControlDescription.ID_UNDEFINED)) {
                        if (o_DMXDevice.getDMXDeviceType() == o_DMXDeviceFirst.getDMXDeviceType()) {
                            o_DMXControlComponent = o_DMXDevice.getDMXControlComponent(intDMXControlComponent);
                            if (o_DMXControlComponent != null) {
                                o_DMXControlComponentsInOneGroup.add(o_DMXControlComponent);
                            }
                        } else {
                            boolAllDMXDevicesHaveDMXControl = false;
                            break;
                        }
                    }
                    if ((o_DMXControlComponents = o_DMXDevice.getDMXControlComponentsByDescription(o_DMXControlDescriptionFirst, o_DMXControlComponents)).size() <= 0) {
                        boolAllDMXDevicesHaveDMXControl = false;
                        break;
                    }
                    if (intDMXControlComponentFirstCountByDescription == 1) {
                        o_DMXControlComponentsInOneGroup.addAll(o_DMXControlComponents);
                        continue;
                    }
                    if (intDMXControlComponentFirstCountByDescription != o_DMXControlComponents.size()) {
                        boolAllDMXDevicesHaveDMXControl = false;
                        break;
                    }
                    if (o_DMXDevice.getDMXDeviceType() == o_DMXDeviceFirst.getDMXDeviceType()) {
                        o_DMXControlComponent = o_DMXDevice.getDMXControlComponent(intDMXControlComponent);
                        if (o_DMXControlComponent == null) continue;
                        o_DMXControlComponentsInOneGroup.add(o_DMXControlComponent);
                        continue;
                    }
                    for (int intFoundComponent = 0; intFoundComponent < o_DMXControlComponents.size(); ++intFoundComponent) {
                        o_DMXControlComponent = o_DMXControlComponents.get(intFoundComponent);
                        if (o_UsedDMXControlComponents.contains(o_DMXControlComponent)) continue;
                        o_DMXControlComponentsInOneGroup.add(o_DMXControlComponent);
                        o_UsedDMXControlComponents.add(o_DMXControlComponent);
                        continue block11;
                    }
                }
                if (!boolAllDMXDevicesHaveDMXControl) {
                    this.hideDMXControlComponent(o_DMXControlComponentFirst, intDMXControlComponent);
                    if (o_ControlGroupSet == null) continue;
                    o_ControlGroupSet.clearControlGroups();
                    continue;
                }
                this.showDMXControlComponent(o_DMXControlComponentFirst, intDMXControlComponent);
                o_DMXControlComponentsInOneGroup.add(o_DMXControlComponentFirst);
                this.addToControlGroup(o_ControlGroupSet, o_DMXControlComponentsInOneGroup);
            }
        }
    }

    private void hideDMXControlComponent(DMXControlComponent p_DMXControlComponent, int p_Index) {
        if (p_DMXControlComponent == null) {
            return;
        }
        boolean boolFireChange = false;
        if (p_DMXControlComponent.isVisible()) {
            boolFireChange = true;
        }
        p_DMXControlComponent.setVisible(false);
        if (boolFireChange && this.m_Owner == 0) {
            LiveShowDMXStageView.notifyDMXControlComponentVisible(p_DMXControlComponent, p_Index, false);
        }
    }

    private void showDMXControlComponent(DMXControlComponent p_DMXControlComponent, int p_Index) {
        if (p_DMXControlComponent == null) {
            return;
        }
        boolean boolFireChange = false;
        if (!p_DMXControlComponent.isVisible()) {
            boolFireChange = true;
        }
        p_DMXControlComponent.setVisible(true);
        if (boolFireChange && this.m_Owner == 0) {
            LiveShowDMXStageView.notifyDMXControlComponentVisible(p_DMXControlComponent, p_Index, true);
        }
    }

    private void addToControlGroup(ControlGroup.ControlGroupSet p_ControlGroupSet, ArrayList<DMXControlComponent> p_DMXControlComponents) {
        if (p_ControlGroupSet == null) {
            return;
        }
        if (p_DMXControlComponents == null) {
            return;
        }
        for (int intDMXControlComponent = 0; intDMXControlComponent < p_DMXControlComponents.size(); ++intDMXControlComponent) {
            ControlGroup o_ControlGroup;
            int intControl;
            DMXControlComponent o_DMXControlComponent = p_DMXControlComponents.get(intDMXControlComponent);
            if (!(o_DMXControlComponent instanceof DMXControl_GridPanTilt) && p_ControlGroupSet.getControlGroupCount() < o_DMXControlComponent.getControlObjectCount()) {
                for (intControl = p_ControlGroupSet.getControlGroupCount() - 1; intControl < o_DMXControlComponent.getControlObjectCount(); ++intControl) {
                    o_ControlGroup = new ControlGroup(10, s_ControlGroup_ChangeType_Devices);
                    p_ControlGroupSet.addControlGroup(o_ControlGroup);
                }
            }
            if (o_DMXControlComponent instanceof DMXControl_GridPanTilt) {
                DMXControl_GridPanTilt o_DMXControl_GridPanTilt = (DMXControl_GridPanTilt)o_DMXControlComponent;
                o_DMXControl_GridPanTilt.addToControlGroup(p_ControlGroupSet.getControlGroup(0), p_ControlGroupSet.getControlGroup(1));
                continue;
            }
            for (intControl = 0; intControl < o_DMXControlComponent.getControlObjectCount(); ++intControl) {
                ControlObject o_ControlObject = o_DMXControlComponent.getControlObject(intControl);
                o_ControlGroup = p_ControlGroupSet.getControlGroup(intControl);
                o_ControlGroup.addControlObject(o_ControlObject);
            }
        }
    }

    public int getControlGroupsChangeType() {
        return s_ControlGroup_ChangeType_Devices;
    }

    public void setControlGroupsChangeType(int p_ControlGroupCategory, int p_ChangeType) {
        if (p_ControlGroupCategory == 10) {
            s_ControlGroup_ChangeType_Devices = p_ChangeType;
            LiveShowDMXStageView.notifyControlGroupsChangeType(p_ChangeType);
        }
        for (int intDMXComponent = 0; intDMXComponent < this.m_DMXControlComponentList.size(); ++intDMXComponent) {
            DMXControlComponent o_DMXControlComponent = (DMXControlComponent)this.m_DMXControlComponentList.get(intDMXComponent);
            if (o_DMXControlComponent == null) continue;
            for (int intControl = 0; intControl < o_DMXControlComponent.getControlObjectCount(); ++intControl) {
                ControlGroup o_ControlGroup;
                int intControlGroup;
                ControlObject o_ControlObject = o_DMXControlComponent.getControlObject(intControl);
                for (intControlGroup = 0; intControlGroup < o_ControlObject.getControlGroupCount(); ++intControlGroup) {
                    o_ControlGroup = o_ControlObject.getControlGroup(intControlGroup);
                    if (o_ControlGroup == null || o_ControlGroup.getCategory() != p_ControlGroupCategory) continue;
                    o_ControlGroup.setChangeType(p_ChangeType);
                }
                if (!SwingUtilities.isEventDispatchThread()) {
                    System.out.println("DMXMixerPanel setControlGroupsChangeType");
                }
                o_ControlObject.repaint();
                if (!(o_DMXControlComponent instanceof DMXControl_GridPanTilt)) continue;
                o_ControlObject = ((DMXControl_GridPanTilt)o_DMXControlComponent).getJControlGridVirtual();
                for (intControlGroup = 0; intControlGroup < o_ControlObject.getControlGroupCount(); ++intControlGroup) {
                    o_ControlGroup = o_ControlObject.getControlGroup(intControlGroup);
                    if (o_ControlGroup == null || o_ControlGroup.getCategory() != p_ControlGroupCategory) continue;
                    o_ControlGroup.setChangeType(p_ChangeType);
                }
                if (!SwingUtilities.isEventDispatchThread()) {
                    System.out.println("DMXMixerPanel setControlGroupsChangeType");
                }
                o_ControlObject.repaint();
            }
        }
        this.refreshChangeTypeButtons(p_ControlGroupCategory);
    }

    private void refreshChangeTypeButtons(int p_ControlGroupCategory) {
        int intGroupChangeTypeFlag = p_ControlGroupCategory == 10 ? s_ControlGroup_ChangeType_Devices : 9999;
        switch (intGroupChangeTypeFlag) {
            case 0: {
                this.jButton_ControlGroup_Change_Same.setBorder(this.m_Border_ControlGroup_ChangeType_Same);
                this.jButton_ControlGroup_Change_Same.setBorderPainted(true);
                this.jButton_ControlGroup_Change_Difference.setBorder(null);
                this.jButton_ControlGroup_Change_Difference.setBorderPainted(false);
                this.jButton_ControlGroup_Change_Percent.setBorder(null);
                this.jButton_ControlGroup_Change_Percent.setBorderPainted(false);
                this.jButton_ControlGroup_Change_Assimilate.setBorder(null);
                this.jButton_ControlGroup_Change_Assimilate.setBorderPainted(false);
                break;
            }
            case 1: {
                this.jButton_ControlGroup_Change_Same.setBorder(null);
                this.jButton_ControlGroup_Change_Same.setBorderPainted(false);
                this.jButton_ControlGroup_Change_Difference.setBorder(this.m_Border_ControlGroup_ChangeType_Difference);
                this.jButton_ControlGroup_Change_Difference.setBorderPainted(true);
                this.jButton_ControlGroup_Change_Percent.setBorder(null);
                this.jButton_ControlGroup_Change_Percent.setBorderPainted(false);
                this.jButton_ControlGroup_Change_Assimilate.setBorder(null);
                this.jButton_ControlGroup_Change_Assimilate.setBorderPainted(false);
                break;
            }
            case 3: {
                this.jButton_ControlGroup_Change_Same.setBorder(null);
                this.jButton_ControlGroup_Change_Same.setBorderPainted(false);
                this.jButton_ControlGroup_Change_Difference.setBorder(null);
                this.jButton_ControlGroup_Change_Difference.setBorderPainted(false);
                this.jButton_ControlGroup_Change_Percent.setBorder(this.m_Border_ControlGroup_ChangeType_Percent);
                this.jButton_ControlGroup_Change_Percent.setBorderPainted(true);
                this.jButton_ControlGroup_Change_Assimilate.setBorder(null);
                this.jButton_ControlGroup_Change_Assimilate.setBorderPainted(false);
                break;
            }
            case 2: {
                this.jButton_ControlGroup_Change_Same.setBorder(null);
                this.jButton_ControlGroup_Change_Same.setBorderPainted(false);
                this.jButton_ControlGroup_Change_Difference.setBorder(null);
                this.jButton_ControlGroup_Change_Difference.setBorderPainted(false);
                this.jButton_ControlGroup_Change_Percent.setBorder(null);
                this.jButton_ControlGroup_Change_Percent.setBorderPainted(false);
                this.jButton_ControlGroup_Change_Assimilate.setBorder(this.m_Border_ControlGroup_ChangeType_Assimilate);
                this.jButton_ControlGroup_Change_Assimilate.setBorderPainted(true);
                break;
            }
            default: {
                this.jButton_ControlGroup_Change_Same.setBorder(null);
                this.jButton_ControlGroup_Change_Same.setBorderPainted(false);
                this.jButton_ControlGroup_Change_Difference.setBorder(null);
                this.jButton_ControlGroup_Change_Difference.setBorderPainted(false);
                this.jButton_ControlGroup_Change_Percent.setBorder(null);
                this.jButton_ControlGroup_Change_Percent.setBorderPainted(false);
                this.jButton_ControlGroup_Change_Assimilate.setBorder(null);
                this.jButton_ControlGroup_Change_Assimilate.setBorderPainted(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshName(DMXDevice p_DMXDevice) {
        if (p_DMXDevice == null) {
            this.setName("---");
        } else {
            String stringName;
            Object object = this.m_SyncStringBuilder;
            synchronized (object) {
                this.m_StringBuilderDevice.delete(0, this.m_StringBuilderDevice.length());
                this.m_StringBuilderDevice.append("<html>");
                this.m_StringBuilderDevice.append("<b>");
                this.m_StringBuilderDevice.append(p_DMXDevice.getName());
                this.m_StringBuilderDevice.append("</b>");
                for (int intSector = 0; intSector < p_DMXDevice.getInternalSectorCount(); ++intSector) {
                    DMXDevice.InternalSector o_InternalSector = p_DMXDevice.getInternalSector(intSector);
                    if (p_DMXDevice.getInternalSectorCount() > 1) {
                        this.m_StringBuilderDevice.append(" ");
                        this.m_StringBuilderDevice.append(DMXDeviceType.SECTORNAME);
                        this.m_StringBuilderDevice.append(" ");
                        this.m_StringBuilderDevice.append(intSector + 1);
                    }
                    if (o_InternalSector.getDMXUniverse() != null) {
                        this.m_StringBuilderDevice.append(": ");
                        this.m_StringBuilderDevice.append(o_InternalSector.getDMXUniverse().getName());
                        this.m_StringBuilderDevice.append(" (");
                        this.m_StringBuilderDevice.append("<b>");
                        this.m_StringBuilderDevice.append(o_InternalSector.getDMXStartAddressVisible());
                        this.m_StringBuilderDevice.append("</b>");
                        this.m_StringBuilderDevice.append(" - ");
                        this.m_StringBuilderDevice.append(o_InternalSector.getDMXStartAddress() + o_InternalSector.getInternalChannelCount());
                        this.m_StringBuilderDevice.append(")");
                    } else {
                        this.m_StringBuilderDevice.append(": ---");
                    }
                    this.m_StringBuilderDevice.append(" ");
                    if (intSector < 2) continue;
                    this.m_StringBuilderDevice.append(" ... ");
                    break;
                }
                this.m_StringBuilderDevice.append(" -> ");
                this.m_StringBuilderDevice.append(p_DMXDevice.getStringSceneBridgeAdjusted());
                this.m_StringBuilderDevice.append("</html>");
                stringName = this.m_StringBuilderDevice.toString();
            }
            this.setName(stringName);
        }
    }

    @Override
    public void setName(String p_Name) {
        if (p_Name == null) {
            p_Name = "";
        }
        if (p_Name.equals(this.m_Name)) {
            return;
        }
        String oldValue = this.m_Remark;
        this.m_Name = p_Name;
        this.jLabel_Name.setText(p_Name);
        this.firePropertyChange(PROP_DMXMIXERPANEL_REMARK, oldValue, this.m_Name);
    }

    public String getMixerPanelName() {
        return this.m_Name;
    }

    public void setRemark(String p_Remark) {
        if (p_Remark == null) {
            p_Remark = "";
        }
        if (p_Remark.equals(this.m_Remark)) {
            return;
        }
        String oldValue = this.m_Remark;
        this.m_Remark = p_Remark;
        this.jPanel_InnerPanel.setToolTipText(p_Remark);
        this.jLabel_Name.setToolTipText(p_Remark);
        this.firePropertyChange(PROP_DMXMIXERPANEL_REMARK, oldValue, this.m_Remark);
    }

    public String getRemark() {
        return this.m_Remark;
    }

    public void setDMXDeviceTreeModel(DMXDevice.TreeModel_Device_Channels p_DMXDeviceTreeModel_Channel) {
        this.m_DMXDeviceTreeModel = p_DMXDeviceTreeModel_Channel;
    }

    public DMXControlComponent loadDMXControlComponent(DMXControlComponent.DMXControlType p_DMXControlType) {
        DMXControlComponent o_DMXControlComponent = DMXControlComponent.loadDMXControlComponent(p_DMXControlType, this.m_DMXDeviceTreeModel);
        if (o_DMXControlComponent != null) {
            o_DMXControlComponent.setDMXControlComponentPool(this);
            this.addDMXControlComponent(o_DMXControlComponent);
            this.addSelectedControlComponent(o_DMXControlComponent);
        }
        return o_DMXControlComponent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(2);
        out.writeUTF(this.m_Name);
        out.writeUTF(this.m_Remark);
        Object object = this.m_SyncDMXObjects;
        synchronized (object) {
            out.writeInt(this.m_DMXControlComponentList.size());
            for (int intDMXControl = 0; intDMXControl < this.m_DMXControlComponentList.size(); ++intDMXControl) {
                DMXControlComponent o_DMXControlComponent = (DMXControlComponent)this.m_DMXControlComponentList.get(intDMXControl);
                DMXControlComponent.DMXControlType o_DMXControlType = o_DMXControlComponent.getDMXControlType();
                o_DMXControlType.writeExternal(out);
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int intSoftwareVersion = in.readInt();
        this.setName(in.readUTF());
        if (intSoftwareVersion >= 2) {
            this.m_Remark = in.readUTF();
        }
        int intDMXControlCount = in.readInt();
        for (int intControl = 0; intControl < intDMXControlCount; ++intControl) {
            DMXControlComponent.DMXControlType o_DMXControlType = new DMXControlComponent.DMXControlType();
            o_DMXControlType.setMixerPanelOwner(this.m_Owner);
            o_DMXControlType.readExternal(in);
            DMXControlComponent o_DMXControlComponent = this.loadDMXControlComponent(o_DMXControlType);
        }
        this.clearSelectedControlComponents();
        this.linkLabelListConditions();
    }

    public void setGridBagConstraints(GridBagConstraints p_GridBagConstraints) {
        this.m_GridBagConstraints = p_GridBagConstraints;
    }

    public GridBagConstraints getGridBagConstraints() {
        return this.m_GridBagConstraints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSelectionListener(DMXMixerPanelListener p_SelectionListener) {
        Object object = this.m_SyncSelectionListener;
        synchronized (object) {
            if (this.m_DMXMixerPanelListeners == null) {
                return;
            }
            if (this.m_DMXMixerPanelListeners.contains(p_SelectionListener)) {
                return;
            }
            this.m_DMXMixerPanelListeners.add(p_SelectionListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSelectionListener(DMXMixerPanelListener p_SelectionListener) {
        Object object = this.m_SyncSelectionListener;
        synchronized (object) {
            if (this.m_DMXMixerPanelListeners == null) {
                return;
            }
            if (!this.m_DMXMixerPanelListeners.contains(p_SelectionListener)) {
                return;
            }
            this.m_DMXMixerPanelListeners.remove(p_SelectionListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListener_MixerPanelSelection() {
        ArrayList<DMXMixerPanelListener> o_DMXMixerPanelListeners;
        Object object = this.m_SyncSelectionListener;
        synchronized (object) {
            if (this.m_DMXMixerPanelListeners == null) {
                return;
            }
            if (this.m_DMXMixerPanelListeners.size() <= 0) {
                return;
            }
            o_DMXMixerPanelListeners = new ArrayList<DMXMixerPanelListener>(this.m_DMXMixerPanelListeners.size());
            o_DMXMixerPanelListeners.addAll(this.m_DMXMixerPanelListeners);
        }
        for (int intListener = 0; intListener < o_DMXMixerPanelListeners.size(); ++intListener) {
            DMXMixerPanelListener o_SelectionListener = (DMXMixerPanelListener)o_DMXMixerPanelListeners.get(intListener);
            o_SelectionListener.eventDMXMixerPanelSelected(this);
        }
        o_DMXMixerPanelListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListener_MixerPanelClose() {
        ArrayList<DMXMixerPanelListener> o_DMXMixerPanelListeners;
        Object object = this.m_SyncSelectionListener;
        synchronized (object) {
            if (this.m_DMXMixerPanelListeners == null) {
                return;
            }
            if (this.m_DMXMixerPanelListeners.size() <= 0) {
                return;
            }
            o_DMXMixerPanelListeners = new ArrayList<DMXMixerPanelListener>(this.m_DMXMixerPanelListeners.size());
            o_DMXMixerPanelListeners.addAll(this.m_DMXMixerPanelListeners);
        }
        for (int intListener = 0; intListener < o_DMXMixerPanelListeners.size(); ++intListener) {
            DMXMixerPanelListener o_SelectionListener = (DMXMixerPanelListener)o_DMXMixerPanelListeners.get(intListener);
            o_SelectionListener.eventDMXMixerPanelClose(this);
        }
        o_DMXMixerPanelListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListener_MixerPanelDMXControlAdded(DMXControlComponent p_DMXControlComponent) {
        ArrayList<DMXMixerPanelListener> o_DMXMixerPanelListeners;
        Object object = this.m_SyncSelectionListener;
        synchronized (object) {
            if (this.m_DMXMixerPanelListeners == null) {
                return;
            }
            if (this.m_DMXMixerPanelListeners.size() <= 0) {
                return;
            }
            o_DMXMixerPanelListeners = new ArrayList<DMXMixerPanelListener>(this.m_DMXMixerPanelListeners.size());
            o_DMXMixerPanelListeners.addAll(this.m_DMXMixerPanelListeners);
        }
        for (int intListener = 0; intListener < o_DMXMixerPanelListeners.size(); ++intListener) {
            DMXMixerPanelListener o_SelectionListener = (DMXMixerPanelListener)o_DMXMixerPanelListeners.get(intListener);
            o_SelectionListener.eventDMXMixerPanelDMXControlAdded(this, p_DMXControlComponent);
        }
        o_DMXMixerPanelListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListener_MixerPanelDMXControlRemoved(DMXControlComponent p_DMXControlComponent) {
        ArrayList<DMXMixerPanelListener> o_DMXMixerPanelListeners;
        Object object = this.m_SyncSelectionListener;
        synchronized (object) {
            if (this.m_DMXMixerPanelListeners == null) {
                return;
            }
            if (this.m_DMXMixerPanelListeners.size() <= 0) {
                return;
            }
            o_DMXMixerPanelListeners = new ArrayList<DMXMixerPanelListener>(this.m_DMXMixerPanelListeners.size());
            o_DMXMixerPanelListeners.addAll(this.m_DMXMixerPanelListeners);
        }
        for (int intListener = 0; intListener < o_DMXMixerPanelListeners.size(); ++intListener) {
            DMXMixerPanelListener o_SelectionListener = (DMXMixerPanelListener)o_DMXMixerPanelListeners.get(intListener);
            o_SelectionListener.eventDMXMixerPanelDMXControlRemoved(this, p_DMXControlComponent);
        }
        o_DMXMixerPanelListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListener_MixerPanelDMXControlMoved(DMXControlComponent p_DMXControlComponent, int p_NewPosition) {
        ArrayList<DMXMixerPanelListener> o_DMXMixerPanelListeners;
        Object object = this.m_SyncSelectionListener;
        synchronized (object) {
            if (this.m_DMXMixerPanelListeners == null) {
                return;
            }
            if (this.m_DMXMixerPanelListeners.size() <= 0) {
                return;
            }
            o_DMXMixerPanelListeners = new ArrayList<DMXMixerPanelListener>(this.m_DMXMixerPanelListeners.size());
            o_DMXMixerPanelListeners.addAll(this.m_DMXMixerPanelListeners);
        }
        for (int intListener = 0; intListener < o_DMXMixerPanelListeners.size(); ++intListener) {
            DMXMixerPanelListener o_SelectionListener = (DMXMixerPanelListener)o_DMXMixerPanelListeners.get(intListener);
            o_SelectionListener.eventDMXMixerPanelDMXControlMoved(this, p_DMXControlComponent, p_NewPosition);
        }
        o_DMXMixerPanelListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addDMXControlComponent(DMXControlComponent p_DMXControlComponent) {
        int intIndex;
        if (p_DMXControlComponent == null) {
            return false;
        }
        Object object = this.m_SyncDMXObjects;
        synchronized (object) {
            if (this.m_DMXControlComponentList.contains(p_DMXControlComponent)) {
                return true;
            }
            this.m_DMXControlComponentList.add(p_DMXControlComponent);
            p_DMXControlComponent.setMixerPanelOwner(this.m_Owner);
            GridBagConstraints o_GridBagConstraints = p_DMXControlComponent.getGridBagConstraints();
            o_GridBagConstraints.gridy = 0;
            o_GridBagConstraints.gridx = intIndex = this.m_DMXControlComponentList.size() - 1;
            o_GridBagConstraints.weighty = 1.0;
            o_GridBagConstraints.insets.top = 1;
            o_GridBagConstraints.insets.left = 0;
            o_GridBagConstraints.insets.right = 0;
            o_GridBagConstraints.insets.bottom = 1;
            o_GridBagConstraints.fill = 3;
            p_DMXControlComponent.addMouseListener(this.m_MouseListener);
            this.jPanel_InnerPanel.add((Component)p_DMXControlComponent, o_GridBagConstraints);
            p_DMXControlComponent.setVisible(true);
            p_DMXControlComponent.changedParentHeight(this.jPanel_InnerPanel.getHeight());
        }
        this.refreshControlComponents();
        this.notifyListener_MixerPanelDMXControlAdded(p_DMXControlComponent);
        if (this.m_Owner == 0) {
            LiveShowDMXStageView.notifyDMXControlComponentAdded(p_DMXControlComponent, intIndex);
        }
        return true;
    }

    public boolean containsDMXControlComponent(String p_DMXControlTypeClassName) {
        if (p_DMXControlTypeClassName == null) {
            return false;
        }
        for (int intControl = 0; intControl < this.m_DMXControlComponentList.size(); ++intControl) {
            DMXControlComponent.DMXControlType o_DMXControlType;
            DMXControlComponent o_DMXControlComponent = (DMXControlComponent)this.m_DMXControlComponentList.get(intControl);
            if (o_DMXControlComponent == null || (o_DMXControlType = o_DMXControlComponent.getDMXControlType()) == null || !p_DMXControlTypeClassName.equals(o_DMXControlType.getClassName())) continue;
            return true;
        }
        return false;
    }

    public void showDialog_OnlyOneDimmer() {
        JOptionDialog.showMessageDialog(null, s_OnlyOneDimmerAllowed_Text, s_OnlyOneDimmerAllowed_Titel, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSelectedControlComponent(DMXControlComponent p_DMXControlComponent) {
        Object object = this.m_SyncDMXObjects;
        synchronized (object) {
            if (this.m_SelectedDMXControlComponents.contains(p_DMXControlComponent)) {
                return;
            }
            if (this.m_SelectedDMXControlComponents.add(p_DMXControlComponent)) {
                p_DMXControlComponent.setSelected(true);
            }
        }
        this.notifyListener_MixerPanelSelection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSelectedControlComponent(DMXControlComponent p_DMXControlComponent) {
        Object object = this.m_SyncDMXObjects;
        synchronized (object) {
            if (!this.m_SelectedDMXControlComponents.contains(p_DMXControlComponent)) {
                return;
            }
            if (this.m_SelectedDMXControlComponents.remove(p_DMXControlComponent)) {
                p_DMXControlComponent.setSelected(false);
            }
        }
        this.notifyListener_MixerPanelSelection();
    }

    public int getSelectedControlComponentCount() {
        return this.m_SelectedDMXControlComponents.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DMXControlComponent getSelectedControlComponent(int p_Index) {
        Object object = this.m_SyncDMXObjects;
        synchronized (object) {
            if (p_Index < 0 || p_Index >= this.m_SelectedDMXControlComponents.size()) {
                return null;
            }
            return this.m_SelectedDMXControlComponents.get(p_Index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSelectedControlComponents() {
        Object object = this.m_SyncDMXObjects;
        synchronized (object) {
            for (int intComponent = this.m_SelectedDMXControlComponents.size() - 1; intComponent >= 0; --intComponent) {
                DMXControlComponent o_DMXControlComponent = this.m_SelectedDMXControlComponents.get(intComponent);
                this.m_SelectedDMXControlComponents.remove(o_DMXControlComponent);
                o_DMXControlComponent.setSelected(false);
            }
        }
        this.notifyListener_MixerPanelSelection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeControlComponent(DMXControlComponent p_DMXControlComponent) {
        int intIndex;
        if (p_DMXControlComponent == null) {
            return;
        }
        boolean boolRemoved = false;
        Object object = this.m_SyncDMXObjects;
        synchronized (object) {
            intIndex = this.m_DMXControlComponentList.indexOf(p_DMXControlComponent);
            if (intIndex < 0) {
                return;
            }
            p_DMXControlComponent.removeMouseListener(this.m_MouseListener);
            if (this.m_SelectedDMXControlComponents.contains(p_DMXControlComponent)) {
                this.removeSelectedControlComponent(p_DMXControlComponent);
            }
            try {
                this.jPanel_InnerPanel.remove(p_DMXControlComponent);
                this.hideDMXControlComponent(p_DMXControlComponent, intIndex);
                this.jPanel_InnerPanel.revalidate();
            }
            catch (Exception e) {
                System.out.println("Error DMXMixerPanel removeControlComponent " + e.getMessage());
                e.printStackTrace();
            }
            boolRemoved = this.m_DMXControlComponentList.remove(p_DMXControlComponent);
        }
        if (boolRemoved && this.m_Owner == 0) {
            LiveShowDMXStageView.notifyDMXControlComponentRemoved(p_DMXControlComponent, intIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeControlComponent(DMXControlComponent p_DMXControlComponent, boolean p_KeepType) {
        int intIndex;
        if (p_DMXControlComponent == null) {
            return false;
        }
        boolean boolRemoved = false;
        Object object = this.m_SyncDMXObjects;
        synchronized (object) {
            if (!this.m_DMXControlComponentList.contains(p_DMXControlComponent)) {
                return false;
            }
            p_DMXControlComponent.removeMouseListener(this.m_MouseListener);
            if (this.m_SelectedDMXControlComponents.contains(p_DMXControlComponent)) {
                this.removeSelectedControlComponent(p_DMXControlComponent);
            }
            intIndex = this.m_DMXControlComponentList.indexOf(p_DMXControlComponent);
            this.hideDMXControlComponent(p_DMXControlComponent, intIndex);
            this.jPanel_InnerPanel.remove(p_DMXControlComponent);
            boolRemoved = this.m_DMXControlComponentList.remove(p_DMXControlComponent);
        }
        if (boolRemoved) {
            if (!p_KeepType) {
                this.notifyListener_MixerPanelDMXControlRemoved(p_DMXControlComponent);
                if (this.m_Owner == 0) {
                    LiveShowDMXStageView.notifyDMXControlComponentRemoved(p_DMXControlComponent, intIndex);
                }
                p_DMXControlComponent.close();
            } else {
                p_DMXControlComponent.clearInstance();
            }
        }
        this.refreshControlComponents();
        return boolRemoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeControlComponent(int p_Index, boolean p_KeepType) {
        if (p_Index < 0) {
            return false;
        }
        Object object = this.m_SyncDMXObjects;
        synchronized (object) {
            if (p_Index >= this.m_DMXControlComponentList.size()) {
                return false;
            }
            DMXControlComponent o_DMXControlComponent = (DMXControlComponent)this.m_DMXControlComponentList.get(p_Index);
            return this.removeControlComponent(o_DMXControlComponent, p_KeepType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllControlComponents() {
        Object object = this.m_SyncDMXObjects;
        synchronized (object) {
            int intControlCount = this.m_DMXControlComponentList.size();
            for (int intControl = intControlCount - 1; intControl >= 0; --intControl) {
                DMXControlComponent o_DMXControlComponent = (DMXControlComponent)this.m_DMXControlComponentList.get(intControl);
                this.removeControlComponent(o_DMXControlComponent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int moveDMXControlComponent(DMXControlComponent p_DMXControlComponent, int p_NewPosition) {
        if (p_DMXControlComponent == null) {
            return -1;
        }
        Object object = this.m_SyncDMXObjects;
        synchronized (object) {
            if (!this.m_DMXControlComponentList.contains(p_DMXControlComponent)) {
                return -1;
            }
            int intOldPosition = this.m_DMXControlComponentList.indexOf(p_DMXControlComponent);
            if (intOldPosition < 0) {
                return -1;
            }
            if (p_NewPosition < 0) {
                p_NewPosition = 0;
            }
            if (p_NewPosition >= this.m_DMXControlComponentList.size()) {
                p_NewPosition = this.m_DMXControlComponentList.size() - 1;
            }
            if (intOldPosition == p_NewPosition) {
                return intOldPosition;
            }
            this.m_DMXControlComponentList.remove(p_DMXControlComponent);
            this.m_DMXControlComponentList.add(p_NewPosition, p_DMXControlComponent);
        }
        this.refreshControlComponents();
        return p_NewPosition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int moveleftDMXControlComponent(DMXControlComponent p_DMXControlComponent) {
        int intPosition;
        Object object = this.m_SyncDMXObjects;
        synchronized (object) {
            intPosition = this.m_DMXControlComponentList.indexOf(p_DMXControlComponent);
            if (intPosition <= 0) {
                return -1;
            }
            intPosition = this.moveDMXControlComponent(p_DMXControlComponent, intPosition - 1);
        }
        if (intPosition >= 0) {
            this.notifyListener_MixerPanelDMXControlMoved(p_DMXControlComponent, intPosition);
        }
        return intPosition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int moverightDMXControlComponent(DMXControlComponent p_DMXControlComponent) {
        int intPosition;
        Object object = this.m_SyncDMXObjects;
        synchronized (object) {
            intPosition = this.m_DMXControlComponentList.indexOf(p_DMXControlComponent);
            if (intPosition < 0) {
                return -1;
            }
            if (intPosition >= this.m_DMXControlComponentList.size() - 1) {
                return -1;
            }
            intPosition = this.moveDMXControlComponent(p_DMXControlComponent, intPosition + 1);
        }
        if (intPosition >= 0) {
            this.notifyListener_MixerPanelDMXControlMoved(p_DMXControlComponent, intPosition);
        }
        return intPosition;
    }

    public int getDMXControlComponentCount() {
        return this.m_DMXControlComponentList.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DMXControlComponent getDMXControlComponent(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        Object object = this.m_SyncDMXObjects;
        synchronized (object) {
            if (p_Index >= this.m_DMXControlComponentList.size()) {
                return null;
            }
            return (DMXControlComponent)this.m_DMXControlComponentList.get(p_Index);
        }
    }

    public int getPosition(DMXControlComponent p_DMXControlComponent) {
        return this.m_DMXControlComponentList.indexOf(p_DMXControlComponent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshControlComponents() {
        Object object = this.m_SyncDMXObjects;
        synchronized (object) {
            for (int intControl = 0; intControl < this.m_DMXControlComponentList.size(); ++intControl) {
                DMXControlComponent o_DMXControlComponent = (DMXControlComponent)this.m_DMXControlComponentList.get(intControl);
                if (o_DMXControlComponent == null) continue;
                GridBagConstraints o_GridBagConstraints = o_DMXControlComponent.getGridBagConstraints();
                o_GridBagConstraints.gridx = intControl;
                ((GridBagLayout)this.jPanel_InnerPanel.getLayout()).setConstraints(o_DMXControlComponent, o_GridBagConstraints);
                this.showDMXControlComponent(o_DMXControlComponent, intControl);
            }
            if (!SwingUtilities.isEventDispatchThread()) {
                EventQueueHandler.invokeLater(this.m_RunnableRepaint);
            } else {
                this.m_RunnableRepaint.run();
            }
            EventQueueHandler.invokeLater(this.m_RunnableResetScrollPane);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetScrollPane() {
        DMXControlComponent o_DMXControlComponent = null;
        JPanelBackground o_InnerPanel = null;
        Object object = this.m_SyncDMXObjects;
        synchronized (object) {
            if (this.m_SelectedDMXControlComponents.size() > 0) {
                o_DMXControlComponent = this.m_SelectedDMXControlComponents.get(0);
                o_InnerPanel = this.jPanel_InnerPanel;
            }
        }
        if (o_DMXControlComponent != null && o_InnerPanel != null) {
            o_InnerPanel.scrollRectToVisible(o_DMXControlComponent.getBounds());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void componentResized(ComponentEvent e) {
        Object object = this.m_SyncDMXObjects;
        synchronized (object) {
            if (this.getWidth() == this.m_OldSize.width && this.getHeight() == this.m_OldSize.height) {
                return;
            }
            this.m_OldSize.setSize(this.getWidth(), this.getHeight());
            for (int intControl = 0; intControl < this.m_DMXControlComponentList.size(); ++intControl) {
                DMXControlComponent o_DMXControlComponent = (DMXControlComponent)this.m_DMXControlComponentList.get(intControl);
                if (o_DMXControlComponent == null) continue;
                o_DMXControlComponent.changedParentHeight(this.jPanel_InnerPanel.getHeight());
            }
        }
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof DMXDevice) {
            if ("dmxdeviceDimmerValue".equals(evt.getPropertyName())) {
                return;
            }
            DMXDevice o_DMXDevice = (DMXDevice)evt.getSource();
            if (o_DMXDevice == null) {
                return;
            }
            if (this.m_DMXDevices.size() > 0 && this.getDMXDevice(0) == o_DMXDevice) {
                this.refreshName(o_DMXDevice);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DMXControlComponent getDMXControlComponentByID(String p_ID) {
        if (p_ID == null) {
            return null;
        }
        Object object = this.m_SyncDMXObjects;
        synchronized (object) {
            for (int intDMXControlComponent = 0; intDMXControlComponent < this.m_DMXControlComponentList.size(); ++intDMXControlComponent) {
                DMXControlComponent o_DMXControlComponent = (DMXControlComponent)this.m_DMXControlComponentList.get(intDMXControlComponent);
                if (o_DMXControlComponent == null || !o_DMXControlComponent.getDMXControlType().getID().equals(p_ID)) continue;
                return o_DMXControlComponent;
            }
        }
        return null;
    }

    @Override
    public DMXControlComponent.DMXControlComponentList getListModelDMXControlComponents() {
        return this.m_DMXControlComponentList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void linkLabelListConditions() {
        Object object = this.m_SyncDMXObjects;
        synchronized (object) {
            for (int intDMXControlComponent = 0; intDMXControlComponent < this.m_DMXControlComponentList.size(); ++intDMXControlComponent) {
                DMXControlComponent o_DMXControlComponent = (DMXControlComponent)this.m_DMXControlComponentList.get(intDMXControlComponent);
                if (o_DMXControlComponent == null) {
                    return;
                }
                o_DMXControlComponent.linkLabelListConditions();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlinkLabelListConditions() {
        Object object = this.m_SyncDMXObjects;
        synchronized (object) {
            for (int intDMXControlComponent = 0; intDMXControlComponent < this.m_DMXControlComponentList.size(); ++intDMXControlComponent) {
                DMXControlComponent o_DMXControlComponent = (DMXControlComponent)this.m_DMXControlComponentList.get(intDMXControlComponent);
                if (o_DMXControlComponent == null) {
                    return;
                }
                o_DMXControlComponent.unlinkLabelListConditions();
            }
        }
    }

    public static void addDMXMixerPanel(DMXMixerPanel p_DMXMixerPanel) {
        if (p_DMXMixerPanel == null) {
            return;
        }
        s_DMXMixerPanelTableModel.addDMXMixerPanel(p_DMXMixerPanel);
    }

    public static void removeDMXMixerPanel(DMXMixerPanel p_DMXMixerPanel) {
        if (p_DMXMixerPanel == null) {
            return;
        }
        s_DMXMixerPanelTableModel.removeDMXMixerPanel(p_DMXMixerPanel);
        p_DMXMixerPanel.close();
    }

    public static void moveDMXMixerPanel(DMXMixerPanel p_DMXMixerPanel, int p_NewPosition) {
        if (p_DMXMixerPanel == null) {
            return;
        }
        s_DMXMixerPanelTableModel.moveDMXMixerPanel(p_DMXMixerPanel, p_NewPosition);
    }

    public static ArrayList<DMXMixerPanel> getDMXMixerPanels() {
        ArrayList<DMXMixerPanel> o_DMXMixerPanels = s_DMXMixerPanelTableModel.getElementArrayList_Safe();
        return o_DMXMixerPanels;
    }

    public static int getDMXMixerPanelCount() {
        return s_DMXMixerPanelTableModel.size();
    }

    public static DMXMixerPanel getDMXMixerPanel(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        return s_DMXMixerPanelTableModel.getDMXMixerPanel(p_Index);
    }

    public static boolean saveDMXMixerPanels(LiveShowProjectDescription p_LiveShowProjectDescription) {
        if (p_LiveShowProjectDescription == null) {
            return false;
        }
        String stringFileName = p_LiveShowProjectDescription.getProjectPathName() + FILESUFFIX;
        try {
            File o_File = new File(stringFileName);
            if (o_File.exists()) {
                try {
                    o_File.delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            o_File.createNewFile();
            FileOutputStream o_FileOutputStream = new FileOutputStream(o_File);
            ObjectOutputStream o_ObjectOutput = new ObjectOutputStream(o_FileOutputStream);
            o_ObjectOutput.writeInt(2);
            int intDMXMixerPanelsCount = DMXMixerPanel.getDMXMixerPanelCount();
            o_ObjectOutput.writeInt(intDMXMixerPanelsCount);
            for (int intMixer = 0; intMixer < intDMXMixerPanelsCount; ++intMixer) {
                DMXMixerPanel o_DMXMixerPanel = DMXMixerPanel.getDMXMixerPanel(intMixer);
                if (o_DMXMixerPanel == null) continue;
                o_DMXMixerPanel.writeExternal(o_ObjectOutput);
            }
            o_ObjectOutput.close();
            o_FileOutputStream.close();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean deleteDMXMixerPanels(LiveShowProjectDescription p_LiveShowProjectDescription) {
        if (p_LiveShowProjectDescription == null) {
            return false;
        }
        boolean boolSuccess = false;
        String stringFileName = p_LiveShowProjectDescription.getProjectPathName() + FILESUFFIX;
        File o_File = new File(stringFileName);
        if (o_File.exists()) {
            try {
                boolSuccess = o_File.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return boolSuccess;
    }

    public static boolean loadDMXMixerPanels(LiveShowProjectDescription p_LiveShowProjectDescription, LiveShow_ImportDescription p_LiveShow_ImportDescription) {
        if (p_LiveShowProjectDescription == null) {
            return false;
        }
        FileInputStream o_FileInputStream = null;
        ObjectInput o_ObjectInput = null;
        String stringFileName = p_LiveShowProjectDescription.getProjectPathName() + FILESUFFIX;
        try {
            File o_File = new File(stringFileName);
            o_FileInputStream = new FileInputStream(o_File);
            o_ObjectInput = new ObjectInputStream(o_FileInputStream);
            int intSoftwareVersion = o_ObjectInput.readInt();
            int intMixerPanelCount = o_ObjectInput.readInt();
            for (int intMixerPanel = 0; intMixerPanel < intMixerPanelCount; ++intMixerPanel) {
                DMXMixerPanel o_DMXMixerPanel = new DMXMixerPanel();
                o_DMXMixerPanel.setOwner(2);
                o_DMXMixerPanel.readExternal(o_ObjectInput);
                LiveShowDMXSystem.addDMXMixerPanel(o_DMXMixerPanel);
            }
            o_ObjectInput.close();
            o_FileInputStream.close();
        }
        catch (Exception e) {
            try {
                if (o_ObjectInput != null) {
                    o_ObjectInput.close();
                }
                if (o_FileInputStream != null) {
                    o_FileInputStream.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
        return true;
    }

    public static DMXMixerPanelTableModel getDMXMixerPanelTableModel() {
        return s_DMXMixerPanelTableModel;
    }

    public static class DMXMixerPanelTableModel
    extends TableAndListModel<DMXMixerPanel>
    implements PropertyChangeListener {
        public static final int COLUMNCOUNT = 2;
        public static final int COLUMNINDEX_MIXERPANELNAME = 0;
        public static final int COLUMNINDEX_MIXERPANELDESCRIPTION = 1;
        @LiveLanguageString
        public static String COLUMN_MIXERPANELNAME = "Name";
        @LiveLanguageString
        public static String COLUMN_MIXERPANELDESCRIPTION = "Description";
        private final Object m_SyncMixerPanels = new Object();
        private String[] m_ColumnNames;

        public DMXMixerPanelTableModel() {
            super(false);
            LiveLanguage.addLanguageListener((Object)this, null);
            this.initMembers();
        }

        private void initMembers() {
            this.m_ColumnNames = new String[2];
            this.m_ColumnNames[0] = COLUMN_MIXERPANELNAME;
            this.m_ColumnNames[1] = COLUMN_MIXERPANELDESCRIPTION;
        }

        public void finishJTable(JTable p_JTable) {
            TableAndListModel.TableCellEditorRenderer_String o_TableCellEditorRenderer_String;
            if (p_JTable == null) {
                return;
            }
            TableRowSorter<DMXMixerPanelTableModel> o_TableRowSorter = new TableRowSorter<DMXMixerPanelTableModel>(this);
            o_TableRowSorter.setComparator(0, TableAndListModel.getStringComparator_Normal());
            o_TableRowSorter.setComparator(1, TableAndListModel.getStringComparator_Normal());
            super.finishJTable(p_JTable, o_TableRowSorter, null);
            TableColumnModel o_TableColumnModel = p_JTable.getColumnModel();
            TableColumn o_TableColumn = o_TableColumnModel.getColumn(0);
            if (o_TableColumn != null) {
                o_TableCellEditorRenderer_String = new TableAndListModel.TableCellEditorRenderer_String();
                o_TableCellEditorRenderer_String.setHorizontalAlignment(10);
                o_TableCellEditorRenderer_String.setToolTipText_Automatic(1);
                o_TableCellEditorRenderer_String.setToolTipTextAt(false, true);
                o_TableColumn.setCellEditor(o_TableCellEditorRenderer_String);
                o_TableColumn.setCellRenderer(o_TableCellEditorRenderer_String);
            }
            if ((o_TableColumn = o_TableColumnModel.getColumn(1)) != null) {
                o_TableCellEditorRenderer_String = new TableAndListModel.TableCellEditorRenderer_String();
                o_TableCellEditorRenderer_String.setHorizontalAlignment(10);
                o_TableCellEditorRenderer_String.setToolTipText_Automatic(1);
                o_TableCellEditorRenderer_String.setToolTipTextAt(false, true);
                o_TableColumn.setCellEditor(o_TableCellEditorRenderer_String);
                o_TableColumn.setCellRenderer(o_TableCellEditorRenderer_String);
            }
            p_JTable.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addDMXMixerPanel(DMXMixerPanel p_DMXMixerPanel) {
            if (p_DMXMixerPanel == null) {
                return;
            }
            Object object = this.m_SyncMixerPanels;
            synchronized (object) {
                if (this.add(p_DMXMixerPanel)) {
                    p_DMXMixerPanel.addPropertyChangeListener(this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeDMXMixerPanel(DMXMixerPanel p_DMXMixerPanel) {
            if (p_DMXMixerPanel == null) {
                return;
            }
            Object object = this.m_SyncMixerPanels;
            synchronized (object) {
                if (this.remove(p_DMXMixerPanel)) {
                    p_DMXMixerPanel.removePropertyChangeListener(this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void moveDMXMixerPanel(DMXMixerPanel p_DMXMixerPanel, int p_NewPosition) {
            Object object = this.m_SyncMixerPanels;
            synchronized (object) {
                this.remove(p_DMXMixerPanel);
                this.add(p_NewPosition, p_DMXMixerPanel);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addSelectedDMXMixerPanel(JTable p_JTable, DMXMixerPanel p_DMXMixerPanel) {
            if (p_JTable == null) {
                return;
            }
            if (p_DMXMixerPanel == null) {
                return;
            }
            Object object = this.m_SyncMixerPanels;
            synchronized (object) {
                this.addSelectedElement(p_JTable, p_DMXMixerPanel);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeSelectedDMXMixerPanel(JTable p_JTable, DMXMixerPanel p_DMXMixerPanel) {
            if (p_JTable == null) {
                return;
            }
            if (p_DMXMixerPanel == null) {
                return;
            }
            Object object = this.m_SyncMixerPanels;
            synchronized (object) {
                this.removeSelectedElement(p_JTable, p_DMXMixerPanel);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DMXMixerPanel getDMXMixerPanel(int p_Index) {
            if (p_Index < 0) {
                return null;
            }
            Object object = this.m_SyncMixerPanels;
            synchronized (object) {
                return (DMXMixerPanel)this.get(p_Index);
            }
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return COLUMN_MIXERPANELNAME;
                }
                case 1: {
                    return COLUMN_MIXERPANELDESCRIPTION;
                }
            }
            return "";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getValue(DMXMixerPanel p_DMXMixerPanel, int columnIndex) {
            String stringValue = "";
            Object object = this.m_SyncMixerPanels;
            synchronized (object) {
                if (p_DMXMixerPanel == null) {
                    return stringValue;
                }
            }
            switch (columnIndex) {
                case 0: {
                    stringValue = p_DMXMixerPanel.getMixerPanelName();
                    break;
                }
                case 1: {
                    stringValue = p_DMXMixerPanel.getRemark();
                }
            }
            return stringValue;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            switch (col) {
                case 0: {
                    return true;
                }
                case 1: {
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setValue(DMXMixerPanel p_DMXMixerPanel, Object value, int col) {
            Object object = this.m_SyncMixerPanels;
            synchronized (object) {
                if (p_DMXMixerPanel == null) {
                    return;
                }
            }
            switch (col) {
                case 0: {
                    String stringValue = (String)value;
                    p_DMXMixerPanel.setName(stringValue);
                    break;
                }
                case 1: {
                    String stringValue = (String)value;
                    p_DMXMixerPanel.setRemark(stringValue);
                }
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() instanceof DMXMixerPanel) {
                DMXMixerPanel o_DMXMixerPanel = (DMXMixerPanel)evt.getSource();
                if (DMXMixerPanel.PROP_DMXMIXERPANEL_NAME.equals(evt.getPropertyName())) {
                    this.changedElement(o_DMXMixerPanel);
                }
                if (DMXMixerPanel.PROP_DMXMIXERPANEL_REMARK.equals(evt.getPropertyName())) {
                    this.changedElement(o_DMXMixerPanel);
                }
            }
        }
    }

    public static interface DMXMixerPanelListener {
        public void eventDMXMixerPanelClose(DMXMixerPanel var1);

        public void eventDMXMixerPanelSelected(DMXMixerPanel var1);

        public void eventDMXMixerPanelDMXControlAdded(DMXMixerPanel var1, DMXControlComponent var2);

        public void eventDMXMixerPanelDMXControlRemoved(DMXMixerPanel var1, DMXControlComponent var2);

        public void eventDMXMixerPanelDMXControlMoved(DMXMixerPanel var1, DMXControlComponent var2, int var3);
    }
}

