/*
 * Decompiled with CFR 0.152.
 */
package DMXMixer;

import DMXDevicePackage.DMXDevice;
import DMXMixer.DMXControlComponent;
import FileToolPackage.FileSelection;
import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LanguageTools.LiveLanguagePackage.LiveLanguageString;
import LiveShowControlModels.JTextFieldBytePanel;
import LiveShowControlObjects.ControlObject;
import LiveShowControls.CorrectionModel;
import LiveShowControls.JControlCorrection;
import StartPackage.LiveShowDMXSystem;
import SwingToolTipPackage.PopUpToolTip;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.filechooser.FileNameExtensionFilter;

public class DMXControl_Dimmer_DeviceSettings
extends DMXControlComponent.DeviceSettingsPanel
implements ComponentListener,
PropertyChangeListener {
    public static final int SOFTWAREVERSION = 1;
    public static final String DIMMERCURVE_FILESUFFIX = ".cur";
    @LiveLanguageString
    public static String DIMMERCURVE_LOAD = "Load dimmer curve";
    @LiveLanguageString
    public static String DIMMERCURVE_SAVE = "Save dimmer curve";
    @LiveLanguageString
    public static String DIMMERCURVE_NAME = "Dimmer curve";
    public static FileNameExtensionFilter s_FileNameExtensionFilter = FileSelection.createFileNameExtensionFilter(DIMMERCURVE_NAME + " (.cur)", ".cur");
    private Point2D.Double m_SelectedCorrectionPoint;
    private CorrectionModel m_CorrectionModel_Old;
    private boolean m_IsEqualsDefault;
    private boolean m_Changed;
    private File m_File;
    private JButton jButton_AddPoint;
    private JButton jButton_LoadCurve;
    private JButton jButton_MovePointX;
    private JButton jButton_MovePointY;
    private JButton jButton_RemovePoint;
    private JButton jButton_ResetLinear;
    private JButton jButton_SaveCurve;
    private JButton jButton_SetPoints;
    private JButton jButton_SetToDefault;
    private JControlCorrection jControlCorrection1;
    private JTextFieldBytePanel jTextFieldBytePanel_Input;
    private JTextFieldBytePanel jTextFieldBytePanel_InputDistance;
    private JTextFieldBytePanel jTextFieldBytePanel_Output;

    public DMXControl_Dimmer_DeviceSettings(DMXDevice p_DMXDevice, DMXControlComponent p_DMXControlComponent) {
        super(p_DMXDevice, p_DMXControlComponent);
        this.initMembers();
        this.initComponents();
        this.initComponentsFurther();
        if (p_DMXControlComponent.getDMXControlType().getCorrectionModel() == null) {
            p_DMXControlComponent.getDMXControlType().setCorrectionModel(this.jControlCorrection1.getCorrectionModel());
        } else {
            this.jControlCorrection1.setCorrectionModel(p_DMXControlComponent.getDMXControlType().getCorrectionModel());
        }
        this.jControlCorrection1.getCorrectionModel().addPropertyChangeListener((PropertyChangeListener)this);
        this.refreshSelectedPoint(this.jControlCorrection1.getCorrectionModel().getSelectedCorrectionPoint());
        LiveLanguage.addLanguageListener((Object)this, null);
    }

    private void initMembers() {
        this.m_IsEqualsDefault = true;
        this.m_SelectedCorrectionPoint = null;
        this.m_Changed = false;
        this.m_File = null;
    }

    private void initComponents() {
        this.jTextFieldBytePanel_Input = new JTextFieldBytePanel();
        this.jTextFieldBytePanel_Output = new JTextFieldBytePanel();
        this.jControlCorrection1 = new JControlCorrection();
        this.jButton_RemovePoint = new JButton();
        this.jButton_SetToDefault = new JButton();
        this.jButton_SetPoints = new JButton();
        this.jTextFieldBytePanel_InputDistance = new JTextFieldBytePanel();
        this.jButton_ResetLinear = new JButton();
        this.jButton_SaveCurve = new JButton();
        this.jButton_LoadCurve = new JButton();
        this.jButton_AddPoint = new JButton();
        this.jButton_MovePointX = new JButton();
        this.jButton_MovePointY = new JButton();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.add((Component)this.jTextFieldBytePanel_Input, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.add((Component)this.jTextFieldBytePanel_Output, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jControlCorrection1, gridBagConstraints);
        this.jButton_RemovePoint.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Delete.png")));
        this.jButton_RemovePoint.setToolTipText("delete the selected point");
        this.jButton_RemovePoint.setContentAreaFilled(false);
        this.jButton_RemovePoint.setMargin(new Insets(0, 0, 0, 0));
        this.jButton_RemovePoint.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_RemovePoint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DMXControl_Dimmer_DeviceSettings.this.jButton_RemovePointActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.25;
        this.add((Component)this.jButton_RemovePoint, gridBagConstraints);
        this.jButton_SetToDefault.setText("Set to default");
        this.jButton_SetToDefault.setToolTipText("Set the default curve as defined in device type");
        this.jButton_SetToDefault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DMXControl_Dimmer_DeviceSettings.this.jButton_SetToDefaultActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jButton_SetToDefault, gridBagConstraints);
        this.jButton_SetPoints.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Object_AddMultiple.png")));
        this.jButton_SetPoints.setToolTipText("set points every :");
        this.jButton_SetPoints.setContentAreaFilled(false);
        this.jButton_SetPoints.setIconTextGap(0);
        this.jButton_SetPoints.setMargin(new Insets(0, 0, 0, 0));
        this.jButton_SetPoints.setName("");
        this.jButton_SetPoints.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_SetPoints.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DMXControl_Dimmer_DeviceSettings.this.jButton_SetPointsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jButton_SetPoints, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jTextFieldBytePanel_InputDistance, gridBagConstraints);
        this.jButton_ResetLinear.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Object_SetLinear.png")));
        this.jButton_ResetLinear.setToolTipText("reset to linear curve");
        this.jButton_ResetLinear.setContentAreaFilled(false);
        this.jButton_ResetLinear.setMargin(new Insets(0, 0, 0, 0));
        this.jButton_ResetLinear.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_ResetLinear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DMXControl_Dimmer_DeviceSettings.this.jButton_ResetLinearActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.25;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jButton_ResetLinear, gridBagConstraints);
        this.jButton_SaveCurve.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/File_Save.png")));
        this.jButton_SaveCurve.setToolTipText("save curve to file");
        this.jButton_SaveCurve.setContentAreaFilled(false);
        this.jButton_SaveCurve.setMargin(new Insets(0, 0, 0, 0));
        this.jButton_SaveCurve.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_SaveCurve.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DMXControl_Dimmer_DeviceSettings.this.jButton_SaveCurveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jButton_SaveCurve, gridBagConstraints);
        this.jButton_LoadCurve.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/File_Load.png")));
        this.jButton_LoadCurve.setToolTipText("load curve from file");
        this.jButton_LoadCurve.setContentAreaFilled(false);
        this.jButton_LoadCurve.setMargin(new Insets(0, 0, 0, 0));
        this.jButton_LoadCurve.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_LoadCurve.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DMXControl_Dimmer_DeviceSettings.this.jButton_LoadCurveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jButton_LoadCurve, gridBagConstraints);
        this.jButton_AddPoint.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Edit_Plus.png")));
        this.jButton_AddPoint.setToolTipText("add a point at input-position");
        this.jButton_AddPoint.setContentAreaFilled(false);
        this.jButton_AddPoint.setMargin(new Insets(0, 0, 0, 0));
        this.jButton_AddPoint.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_AddPoint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DMXControl_Dimmer_DeviceSettings.this.jButton_AddPointActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.25;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jButton_AddPoint, gridBagConstraints);
        this.jButton_MovePointX.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Arrow_Right.png")));
        this.jButton_MovePointX.setToolTipText("Moves the selected point to input-position");
        this.jButton_MovePointX.setContentAreaFilled(false);
        this.jButton_MovePointX.setMargin(new Insets(0, 0, 0, 0));
        this.jButton_MovePointX.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_MovePointX.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DMXControl_Dimmer_DeviceSettings.this.jButton_MovePointXActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.25;
        this.add((Component)this.jButton_MovePointX, gridBagConstraints);
        this.jButton_MovePointY.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Arrow_Up.png")));
        this.jButton_MovePointY.setToolTipText("Moves the selected point to output-position");
        this.jButton_MovePointY.setContentAreaFilled(false);
        this.jButton_MovePointY.setMargin(new Insets(0, 0, 0, 0));
        this.jButton_MovePointY.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_MovePointY.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DMXControl_Dimmer_DeviceSettings.this.jButton_MovePointYActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.25;
        this.add((Component)this.jButton_MovePointY, gridBagConstraints);
    }

    private void jButton_RemovePointActionPerformed(ActionEvent evt) {
        Point2D.Double o_SelectedPoint = this.jControlCorrection1.getCorrectionModel().getSelectedCorrectionPoint();
        if (o_SelectedPoint != null) {
            this.jControlCorrection1.getCorrectionModel().removeCorrectionPoint(o_SelectedPoint);
        }
    }

    private void jButton_SetPointsActionPerformed(ActionEvent evt) {
        Point2D.Double o_Point;
        int intPoint;
        CorrectionModel o_CorrectionModel = this.jControlCorrection1.getCorrectionModel();
        if (o_CorrectionModel == null) {
            return;
        }
        double doubleValueMaximum = this.getValueMaximumLinked();
        if (doubleValueMaximum == 0.0) {
            return;
        }
        double doubleValueXDistance = this.jTextFieldBytePanel_InputDistance.getValue();
        if (doubleValueXDistance == 0.0) {
            return;
        }
        if (doubleValueXDistance >= doubleValueMaximum) {
            return;
        }
        ArrayList<Point2D.Double> o_PointsToRemove = new ArrayList<Point2D.Double>();
        for (intPoint = 1; intPoint < o_CorrectionModel.getCorrectionPointCount() - 1; ++intPoint) {
            o_Point = o_CorrectionModel.getCorrectionPoint(intPoint);
            o_PointsToRemove.add(o_Point);
        }
        for (double doubleValueX = doubleValueXDistance; doubleValueX < doubleValueMaximum; doubleValueX += doubleValueXDistance) {
            double doubleValueXNormed = doubleValueX / doubleValueMaximum;
            for (intPoint = o_PointsToRemove.size() - 1; intPoint >= 0; --intPoint) {
                o_Point = (Point2D.Double)o_PointsToRemove.get(intPoint);
                if (doubleValueXNormed != o_Point.getX()) continue;
                o_PointsToRemove.remove(intPoint);
            }
            if (doubleValueX == 0.0 || doubleValueXNormed == 1.0) continue;
            o_CorrectionModel.createCorrectionPoinNormed(doubleValueXNormed);
        }
        for (intPoint = o_PointsToRemove.size() - 1; intPoint >= 0; --intPoint) {
            o_Point = (Point2D.Double)o_PointsToRemove.get(intPoint);
            o_CorrectionModel.removeCorrectionPoint(o_Point);
            o_PointsToRemove.remove(intPoint);
        }
    }

    private void jButton_SetToDefaultActionPerformed(ActionEvent evt) {
        this.setToDefault();
    }

    private void jButton_ResetLinearActionPerformed(ActionEvent evt) {
        this.setLinearCurve();
    }

    private void jButton_SaveCurveActionPerformed(ActionEvent evt) {
        File o_SelectedFile;
        File o_DimmerCurveDirectory = new File(LiveShowDMXSystem.getPathDimmerCurves());
        if (!o_DimmerCurveDirectory.exists()) {
            try {
                o_DimmerCurveDirectory.mkdir();
            }
            catch (Exception e) {
                return;
            }
        }
        if (this.m_File == null) {
            this.m_File = o_DimmerCurveDirectory;
        }
        if ((o_SelectedFile = FileSelection.showSave(this, DIMMERCURVE_SAVE, this.m_File, s_FileNameExtensionFilter, false, false)) == null) {
            return;
        }
        this.m_File = o_SelectedFile;
        String stringFileName = this.m_File.getName();
        if (stringFileName.length() <= 0) {
            return;
        }
        int intIndex = stringFileName.indexOf(".");
        if (intIndex < 0) {
            stringFileName = stringFileName + DIMMERCURVE_FILESUFFIX;
        } else {
            stringFileName = stringFileName.substring(0, intIndex);
            stringFileName = stringFileName + DIMMERCURVE_FILESUFFIX;
        }
        this.m_File = new File(o_DimmerCurveDirectory + "/" + stringFileName);
        CorrectionModel o_CorrectionModel = this.jControlCorrection1.getCorrectionModel();
        CorrectionModel.save((CorrectionModel)o_CorrectionModel, (File)this.m_File);
    }

    private void jButton_LoadCurveActionPerformed(ActionEvent evt) {
        File o_SelectedFile;
        File o_DimmerCurveDirectory = new File(LiveShowDMXSystem.getPathDimmerCurves());
        if (!o_DimmerCurveDirectory.exists()) {
            try {
                o_DimmerCurveDirectory.mkdir();
            }
            catch (Exception e) {
                return;
            }
        }
        if ((o_SelectedFile = FileSelection.showOpen(this, DIMMERCURVE_LOAD, o_DimmerCurveDirectory, s_FileNameExtensionFilter = FileSelection.createFileNameExtensionFilter(DIMMERCURVE_NAME + " (.cur)", DIMMERCURVE_FILESUFFIX), true, false)) == null) {
            return;
        }
        this.m_File = o_SelectedFile;
        CorrectionModel o_CorrectionModel = CorrectionModel.load((File)this.m_File);
        if (o_CorrectionModel != null) {
            o_CorrectionModel.copyTo(this.jControlCorrection1.getCorrectionModel());
        }
    }

    private void jButton_AddPointActionPerformed(ActionEvent evt) {
        CorrectionModel o_CorrectionModel = this.jControlCorrection1.getCorrectionModel();
        if (o_CorrectionModel == null) {
            return;
        }
        double doubleValueMaximum = this.getValueMaximumLinked();
        if (doubleValueMaximum == 0.0) {
            return;
        }
        double doubleValueX = this.jTextFieldBytePanel_Input.getValue();
        double doubleValueXNormed = doubleValueX / doubleValueMaximum;
        o_CorrectionModel.createCorrectionPoinNormed(doubleValueXNormed);
    }

    private void jButton_MovePointXActionPerformed(ActionEvent evt) {
        this.setInputValue(this.jTextFieldBytePanel_Input.getValue());
    }

    private void jButton_MovePointYActionPerformed(ActionEvent evt) {
        this.setOutputValue(this.jTextFieldBytePanel_Output.getValue());
    }

    private void initComponentsFurther() {
        this.jTextFieldBytePanel_Input.setValueSourceObject(null);
        this.jTextFieldBytePanel_Input.setLabelString(null);
        this.jTextFieldBytePanel_Input.setOnlyIntegerValues(true);
        this.jTextFieldBytePanel_Input.setValueRange(0.0, 65535.0);
        this.jTextFieldBytePanel_Input.setVisible(true);
        this.jTextFieldBytePanel_Input.setValue(0.0);
        this.jTextFieldBytePanel_Output.setValueSourceObject(null);
        this.jTextFieldBytePanel_Output.setLabelString(null);
        this.jTextFieldBytePanel_Output.setOnlyIntegerValues(true);
        this.jTextFieldBytePanel_Output.setValueRange(0.0, 65535.0);
        this.jTextFieldBytePanel_Output.setVisible(true);
        this.jTextFieldBytePanel_Output.setValue(0.0);
        this.jTextFieldBytePanel_InputDistance.setValueSourceObject(null);
        this.jTextFieldBytePanel_InputDistance.setLabelString(null);
        this.jTextFieldBytePanel_InputDistance.setOnlyIntegerValues(true);
        this.jTextFieldBytePanel_InputDistance.setValueRange(0.0, 65535.0);
        this.jTextFieldBytePanel_InputDistance.setVisible(true);
        this.jTextFieldBytePanel_InputDistance.setValue(0.0);
        this.addComponentListener(this);
        this.m_CorrectionModel_Old = new CorrectionModel();
        this.jTextFieldBytePanel_Input.addPropertyChangeListener((PropertyChangeListener)this);
        this.jTextFieldBytePanel_Output.addPropertyChangeListener((PropertyChangeListener)this);
        this.jControlCorrection1.addPropertyChangeListener((PropertyChangeListener)this);
        this.jButton_MovePointX.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_MovePointY.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_AddPoint.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_RemovePoint.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_ResetLinear.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_SetPoints.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_SetToDefault.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_LoadCurve.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_SaveCurve.setComponentPopupMenu(PopUpToolTip.getSelfReference());
    }

    public void refreshSelectedPoint(Point2D.Double p_CorrectionPoint) {
        double doubleValueMaximum = this.getValueMaximumLinked();
        this.m_SelectedCorrectionPoint = p_CorrectionPoint;
        if (this.m_SelectedCorrectionPoint == null) {
            this.jButton_RemovePoint.setEnabled(false);
            this.jButton_MovePointX.setEnabled(false);
            this.jButton_MovePointY.setEnabled(false);
        } else {
            this.jButton_MovePointX.setEnabled(true);
            this.jButton_MovePointY.setEnabled(true);
            this.jTextFieldBytePanel_Input.setValue(p_CorrectionPoint.getX() * doubleValueMaximum);
            this.jTextFieldBytePanel_Output.setValue(p_CorrectionPoint.getY() * doubleValueMaximum);
            int intIndex = this.jControlCorrection1.getCorrectionModel().getIndexOf(p_CorrectionPoint);
            if (intIndex <= 0 || intIndex >= this.jControlCorrection1.getCorrectionModel().getCorrectionPointCount() - 1) {
                this.jButton_RemovePoint.setEnabled(false);
            } else {
                this.jButton_RemovePoint.setEnabled(true);
            }
        }
    }

    public void setInputValue(double p_Value) {
        if (this.m_SelectedCorrectionPoint == null) {
            return;
        }
        CorrectionModel o_CorrectionModel = this.jControlCorrection1.getCorrectionModel();
        if (o_CorrectionModel == null) {
            return;
        }
        double doubleValueMaximum = this.getValueMaximumLinked();
        if (doubleValueMaximum == 0.0) {
            return;
        }
        double doubleValueInput = p_Value;
        if (doubleValueInput > doubleValueMaximum) {
            doubleValueInput = doubleValueMaximum;
        }
        double doubleValueInputNormed = doubleValueInput / doubleValueMaximum;
        o_CorrectionModel.moveCorrectionPoint(this.m_SelectedCorrectionPoint, doubleValueInputNormed, this.m_SelectedCorrectionPoint.getY());
    }

    public void setOutputValue(double p_Value) {
        if (this.m_SelectedCorrectionPoint == null) {
            return;
        }
        CorrectionModel o_CorrectionModel = this.jControlCorrection1.getCorrectionModel();
        if (o_CorrectionModel == null) {
            return;
        }
        double doubleValueMaximum = this.getValueMaximumLinked();
        if (doubleValueMaximum == 0.0) {
            return;
        }
        double doubleValueOutput = p_Value;
        if (doubleValueOutput > doubleValueMaximum) {
            doubleValueOutput = doubleValueMaximum;
        }
        double doubleValueOutputNormed = doubleValueOutput / doubleValueMaximum;
        o_CorrectionModel.moveCorrectionPoint(this.m_SelectedCorrectionPoint, this.m_SelectedCorrectionPoint.getX(), doubleValueOutputNormed);
    }

    public void writeValue() {
        if (this.m_DMXControlComponent == null) {
            return;
        }
        if (this.m_DMXDevice == null) {
            return;
        }
        if (this.m_DMXDevice.getEditMode()) {
            return;
        }
        if (this.m_SelectedCorrectionPoint == null) {
            return;
        }
        CorrectionModel o_CorrectionModel = this.jControlCorrection1.getCorrectionModel();
        if (o_CorrectionModel == null) {
            return;
        }
        ControlObject o_ControlObject = this.m_DMXControlComponent.getControlObject(0);
        if (o_ControlObject == null) {
            return;
        }
        ControlObject.ControlDimension o_ControlDimension = o_ControlObject.getControlDimension(0);
        if (o_ControlDimension == null) {
            return;
        }
        double doubleValueMaximum = this.getValueMaximumLinked();
        if (doubleValueMaximum == 0.0) {
            return;
        }
        double doubleValueNormed = o_CorrectionModel.getNormedValue(this.m_SelectedCorrectionPoint.getX());
        double doubleValue = this.m_SelectedCorrectionPoint.getX() * doubleValueMaximum;
        o_ControlDimension.setValue(doubleValue);
        o_ControlObject.setValueManuallyIsReady();
        this.m_DMXDevice.sendValuesDMXUniverse(true);
    }

    public double getValueMaximumLinked() {
        double doubleValueMaximum;
        if (this.m_DMXControlComponent == null) {
            doubleValueMaximum = 0.0;
        } else {
            DMXControlComponent.ControlDimensionType o_ControlDimensionType;
            doubleValueMaximum = 65535.0;
            DMXControlComponent.ControlType o_ControlType = this.m_DMXControlComponent.getControlType(0);
            if (o_ControlType != null && (o_ControlDimensionType = o_ControlType.getControlDimensionType(0)) != null) {
                doubleValueMaximum = o_ControlDimensionType.getValueMaximum_Linked();
            }
        }
        return doubleValueMaximum;
    }

    public void refresh() {
        if (this.m_DMXDevice == null) {
            this.jButton_SetToDefault.setEnabled(false);
            this.jButton_SetPoints.setEnabled(false);
            this.jButton_RemovePoint.setEnabled(false);
            this.jTextFieldBytePanel_Input.setEnabled(false);
            this.jTextFieldBytePanel_Output.setEnabled(false);
            this.jTextFieldBytePanel_InputDistance.setEnabled(false);
        } else {
            this.jButton_SetPoints.setEnabled(true);
            this.jButton_RemovePoint.setEnabled(true);
            this.jButton_SetToDefault.setEnabled(true);
            this.jTextFieldBytePanel_Input.setEnabled(true);
            this.jTextFieldBytePanel_Output.setEnabled(true);
            this.jTextFieldBytePanel_InputDistance.setEnabled(true);
            if ("TEST".equals(this.m_DMXDevice.getID())) {
                this.jButton_SetToDefault.setVisible(false);
            } else {
                this.jButton_SetToDefault.setVisible(true);
            }
        }
    }

    @Override
    public void close() {
        this.jButton_MovePointX.setComponentPopupMenu(null);
        this.jButton_MovePointY.setComponentPopupMenu(null);
        this.jButton_AddPoint.setComponentPopupMenu(null);
        this.jButton_RemovePoint.setComponentPopupMenu(null);
        this.jButton_ResetLinear.setComponentPopupMenu(null);
        this.jButton_SetPoints.setComponentPopupMenu(null);
        this.jButton_SetToDefault.setComponentPopupMenu(null);
        this.jButton_LoadCurve.setComponentPopupMenu(null);
        this.jButton_SaveCurve.setComponentPopupMenu(null);
        LiveLanguage.removeLanguageListener((Object)this);
        this.removeComponentListener(this);
        this.jTextFieldBytePanel_Input.removePropertyChangeListener((PropertyChangeListener)this);
        this.jTextFieldBytePanel_Output.removePropertyChangeListener((PropertyChangeListener)this);
        this.jControlCorrection1.removePropertyChangeListener((PropertyChangeListener)this);
        CorrectionModel o_CorrectionModel = this.jControlCorrection1.getCorrectionModel();
        if (o_CorrectionModel != null) {
            o_CorrectionModel.removePropertyChangeListener((PropertyChangeListener)this);
        }
        this.setDMXDevice(null);
        LiveLanguage.removeLanguageListener((Object)this);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        ByteArrayOutputStream o_ByteArrayOutputStream = new ByteArrayOutputStream();
        o_ByteArrayOutputStream.reset();
        ObjectOutputStream o_ObjectOutputStream = new ObjectOutputStream(o_ByteArrayOutputStream);
        o_ObjectOutputStream.writeInt(1);
        this.checkEqualsDefault();
        o_ObjectOutputStream.writeBoolean(this.m_IsEqualsDefault);
        this.jControlCorrection1.getCorrectionModel().writeExternal((ObjectOutput)o_ObjectOutputStream);
        o_ObjectOutputStream.flush();
        o_ByteArrayOutputStream.flush();
        out.writeInt(o_ByteArrayOutputStream.size());
        out.write(o_ByteArrayOutputStream.toByteArray());
        o_ObjectOutputStream.close();
        o_ByteArrayOutputStream.close();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int intBytesActuallyReaden;
        ObjectInputStream o_ObjectInputStream = null;
        int intByteCount = in.readInt();
        byte[] o_ByteArray = new byte[intByteCount];
        for (int intBytesReaden = 0; intBytesReaden < intByteCount && (intBytesActuallyReaden = in.read(o_ByteArray, intBytesReaden, intByteCount - intBytesReaden)) >= 0; intBytesReaden += intBytesActuallyReaden) {
        }
        ByteArrayInputStream o_ByteArrayInputStream = new ByteArrayInputStream(o_ByteArray);
        try {
            o_ObjectInputStream = new ObjectInputStream(o_ByteArrayInputStream);
            int intSoftwareVersion = o_ObjectInputStream.readInt();
            this.m_IsEqualsDefault = o_ObjectInputStream.readBoolean();
            this.jControlCorrection1.getCorrectionModel().readExternal((ObjectInput)o_ObjectInputStream);
            if (this.m_IsEqualsDefault) {
                this.setToDefault();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_Changed = false;
    }

    @Override
    public long getDiskSpaceEstimated() {
        long longBytesCount = 0L;
        longBytesCount += 4L;
        ++longBytesCount;
        return longBytesCount += this.jControlCorrection1.getCorrectionModel().getDiskSpaceEstimated();
    }

    public boolean checkEqualsDefault() {
        CorrectionModel o_CorrectionModel_Default;
        DMXControlComponent.DMXControlType o_DMXControlType_DeviceType;
        this.m_IsEqualsDefault = false;
        if (this.m_DMXDevice != null && this.m_DMXDevice.getDMXDeviceType() != null && (o_DMXControlType_DeviceType = this.m_DMXDevice.getDMXDeviceType().getDMXControlType(this.m_DMXControlComponent.getDMXControlType().getID())) != null && (o_CorrectionModel_Default = o_DMXControlType_DeviceType.getCorrectionModel()) != null && this.jControlCorrection1.getCorrectionModel().equals((Object)o_CorrectionModel_Default)) {
            this.m_IsEqualsDefault = true;
        }
        return this.m_IsEqualsDefault;
    }

    @Override
    public boolean getIsEqualDefault() {
        return this.m_IsEqualsDefault;
    }

    public void setLinearCurve() {
        this.jControlCorrection1.getCorrectionModel().resetToLinear();
        this.refreshSelectedPoint(this.jControlCorrection1.getCorrectionModel().getSelectedCorrectionPoint());
    }

    public boolean setToDefault() {
        DMXControlComponent.DMXControlType o_DMXControlType_DeviceType;
        boolean boolSetToDefault = false;
        if (this.m_DMXDevice != null && this.m_DMXDevice.getDMXDeviceType() != null && (o_DMXControlType_DeviceType = this.m_DMXDevice.getDMXDeviceType().getDMXControlType(this.m_DMXControlComponent.getDMXControlType().getID())) != null) {
            CorrectionModel o_CorrectionModel_Default = o_DMXControlType_DeviceType.getCorrectionModel();
            if (o_CorrectionModel_Default != null) {
                if (o_CorrectionModel_Default != this.jControlCorrection1.getCorrectionModel()) {
                    o_CorrectionModel_Default.copyTo(this.jControlCorrection1.getCorrectionModel());
                    boolSetToDefault = true;
                    this.m_IsEqualsDefault = true;
                }
            } else {
                this.jControlCorrection1.getCorrectionModel().resetToLinear();
            }
        }
        this.refreshSelectedPoint(this.jControlCorrection1.getCorrectionModel().getSelectedCorrectionPoint());
        return boolSetToDefault;
    }

    public void gridClicked(Point2D.Double p_Point) {
        double doubleYNormed;
        if (p_Point == null) {
            return;
        }
        double doubleValueMaximum = this.getValueMaximumLinked();
        double doubleXNormed = p_Point.getX();
        if (doubleXNormed != Double.NaN) {
            double doubleX = doubleValueMaximum * doubleXNormed;
            if (doubleX > doubleValueMaximum) {
                doubleX = doubleValueMaximum;
            }
            if (doubleX < 0.0) {
                doubleX = 0.0;
            }
            this.jTextFieldBytePanel_Input.setValue(doubleX);
        }
        if ((doubleYNormed = p_Point.getY()) != Double.NaN) {
            double doubleY = doubleValueMaximum * doubleYNormed;
            if (doubleY > doubleValueMaximum) {
                doubleY = doubleValueMaximum;
            }
            if (doubleY < 0.0) {
                doubleY = 0.0;
            }
            this.jTextFieldBytePanel_Output.setValue(doubleY);
        }
    }

    public CorrectionModel getCorrectionModel() {
        if (this.jControlCorrection1 != null) {
            return this.jControlCorrection1.getCorrectionModel();
        }
        return null;
    }

    @Override
    public void setDMXDevice(DMXDevice p_DMXDevice) {
        this.m_DMXDevice = p_DMXDevice;
        CorrectionModel o_CorrectionModel = this.jControlCorrection1.getCorrectionModel();
        o_CorrectionModel.copyTo(this.m_CorrectionModel_Old);
        this.m_Changed = false;
        this.checkEqualsDefault();
        this.refresh();
    }

    @Override
    public void addDMXControlComponent(DMXControlComponent p_DMXControlComponent) {
    }

    @Override
    public void removeDMXControlComponent(DMXControlComponent p_DMXControlComponent) {
    }

    @Override
    public void save() {
        this.m_Changed = false;
        this.checkEqualsDefault();
    }

    @Override
    public void cancel() {
        this.m_CorrectionModel_Old.copyTo(this.jControlCorrection1.getCorrectionModel());
        this.m_Changed = false;
    }

    @Override
    public void setDMXDeviceSettings() {
    }

    @Override
    public void validateValuesDevice(boolean p_IsScene, boolean p_EditMode) {
    }

    @Override
    public void validateReverseValuesInterface(boolean p_EditMode) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof CorrectionModel) {
            if ("correctionmodelPointAdded".equals(evt.getPropertyName())) {
                this.m_Changed = true;
            } else if ("correctionmodelPointRemoved".equals(evt.getPropertyName())) {
                this.m_Changed = true;
            } else if ("correctionmodelPointSelected".equals(evt.getPropertyName())) {
                this.refreshSelectedPoint((Point2D.Double)evt.getNewValue());
                this.writeValue();
            } else if ("correctionmodelPointMoved".equals(evt.getPropertyName())) {
                this.refreshSelectedPoint((Point2D.Double)evt.getNewValue());
                this.writeValue();
                this.m_Changed = true;
            }
        } else if (evt.getSource() == this.jTextFieldBytePanel_Input) {
            if ("valueChanged".equals(evt.getPropertyName())) {
                // empty if block
            }
        } else if (evt.getSource() == this.jTextFieldBytePanel_Output) {
            if ("valueChanged".equals(evt.getPropertyName())) {
                // empty if block
            }
        } else if (evt.getSource() == this.jControlCorrection1 && "jcontrolcorrectionGridClicked".equals(evt.getPropertyName())) {
            this.gridClicked((Point2D.Double)evt.getNewValue());
        }
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }
}

