/*
 * Decompiled with CFR 0.152.
 */
package DMXMixer;

import DMXMixer.DMXControlSpecialSettings;
import LanguageTools.LiveLanguagePackage.LiveLanguage;
import ToolsGraphics.GraphicsTools;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DMXControlSpecialSettings_Color
extends DMXControlSpecialSettings {
    public static final int SOFTWAREVERSION = 1;
    private Color m_Color;
    private Color m_OldColor;
    private JLabel jLabel1;
    private JPanel jPanel_Color;

    public DMXControlSpecialSettings_Color() {
        this.initMembers();
        this.initComponents();
        LiveLanguage.addLanguageListener((Object)this, null);
    }

    private void initMembers() {
        this.m_OldColor = this.m_Color = Color.WHITE;
    }

    private void initComponents() {
        this.jPanel_Color = new JPanel();
        this.jLabel1 = new JLabel();
        this.setMinimumSize(new Dimension(38, 38));
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(38, 38));
        this.setLayout(new GridBagLayout());
        this.jPanel_Color.setBorder(BorderFactory.createEtchedBorder(0, Color.black, Color.white));
        this.jPanel_Color.setMinimumSize(new Dimension(32, 32));
        this.jPanel_Color.setPreferredSize(new Dimension(32, 32));
        this.jPanel_Color.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DMXControlSpecialSettings_Color.this.jPanel_ColorMouseClicked(evt);
            }
        });
        GroupLayout jPanel_ColorLayout = new GroupLayout(this.jPanel_Color);
        this.jPanel_Color.setLayout(jPanel_ColorLayout);
        jPanel_ColorLayout.setHorizontalGroup(jPanel_ColorLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 28, Short.MAX_VALUE));
        jPanel_ColorLayout.setVerticalGroup(jPanel_ColorLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 28, Short.MAX_VALUE));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jPanel_Color, gridBagConstraints);
        this.jLabel1.setText("SelectColor");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jLabel1, gridBagConstraints);
    }

    private void jPanel_ColorMouseClicked(MouseEvent evt) {
        Color o_Color = JColorChooser.showDialog(this, "Color", this.m_Color);
        if (o_Color != null) {
            this.m_Color = o_Color;
            this.refresh();
        }
        this.notifyDMXControlComponent();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(1);
        out.writeInt(this.m_Color.getRed());
        out.writeInt(this.m_Color.getGreen());
        out.writeInt(this.m_Color.getBlue());
        out.writeInt(this.m_Color.getAlpha());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int intSoftwareVersion = in.readInt();
        int intRed = in.readInt();
        int intGreen = in.readInt();
        int intBlue = in.readInt();
        int intAlpha = in.readInt();
        this.m_OldColor = this.m_Color = new Color(intRed, intGreen, intBlue, intAlpha);
        this.refresh();
    }

    @Override
    public long getDiskSpaceEstimated() {
        long longBytesCount = 0L;
        longBytesCount += 4L;
        longBytesCount += 4L;
        longBytesCount += 4L;
        longBytesCount += 4L;
        return longBytesCount += 4L;
    }

    private void refresh() {
        this.jPanel_Color.setBackground(this.m_Color);
    }

    public Color getColor() {
        return this.m_Color;
    }

    public void setColor(Color p_Color) {
        if (p_Color == null) {
            return;
        }
        this.m_OldColor = this.m_Color = GraphicsTools.newColorSave(p_Color.getRed(), p_Color.getGreen(), p_Color.getBlue(), p_Color.getAlpha());
        this.refresh();
    }

    @Override
    public DMXControlSpecialSettings getCopy() {
        DMXControlSpecialSettings_Color o_DMXControlSpecialSettings_Color = new DMXControlSpecialSettings_Color();
        o_DMXControlSpecialSettings_Color.setColor(this.m_Color);
        return o_DMXControlSpecialSettings_Color;
    }

    @Override
    public void notifyDMXControlComponent() {
        if (this.m_DMXControlComponent != null) {
            this.m_DMXControlComponent.eventDMXControlSpecialSettings(this);
        }
    }

    @Override
    public void save() {
        this.m_OldColor = this.m_Color;
        this.notifyDMXControlComponent();
    }

    @Override
    public void cancel() {
        this.m_Color = this.m_OldColor;
        this.notifyDMXControlComponent();
    }
}

