/*
 * Decompiled with CFR 0.152.
 */
package DMXMixer;

import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LanguageTools.LiveLanguagePackage.LiveLanguageString;
import OS.OSChecker;
import SwingModelPackage.TableAndListModel;
import ToolsGraphics.JLabelBackground;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.Externalizable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.ComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class DMXControlDescription
implements Externalizable {
    public static final int SOFTWAREVERSION = 1;
    public static final String ID_UNDEFINED = DMXControlDescriptions.ID_UNDEFINED;
    public static final String ID_DIMMER = "dimmer";
    public static final String ID_SWITCH = "switch";
    public static final String ID_RGBCMY = "rgbcmy";
    public static final String ID_EXTRACOLOR_CYAN = "colorcyan";
    public static final String ID_EXTRACOLOR_MAGENTA = "colormagenta";
    public static final String ID_EXTRACOLOR_YELLOW = "coloryellow";
    public static final String ID_EXTRACOLOR_WHITE = "colorwhite";
    public static final String ID_EXTRACOLOR_WHITE_COLD = "colorwhitecold";
    public static final String ID_EXTRACOLOR_WHITE_WARM = "colorwhitewarm";
    public static final String ID_EXTRACOLOR_LIME = "colorlime";
    public static final String ID_EXTRACOLOR_AMBER = "coloramber";
    public static final String ID_EXTRACOLOR_UV = "coloruv";
    public static final String ID_EXTRACOLOR_LIGHTBLUE = "colorlightblue";
    public static final String ID_EXTRACOLOR_PINK = "colorpink";
    public static final String ID_EXTRACOLOR_PURPLE = "colorpurple";
    public static final String ID_COLOR1 = "color1";
    public static final String ID_COLOR2 = "color2";
    public static final String ID_COLORTEMPERATURE = "colortemperature";
    public static final String ID_PANTILT = "pantilt";
    public static final String ID_DURATION = "duration";
    public static final String ID_GOBO1 = "gobo1";
    public static final String ID_GOBO2 = "gobo2";
    public static final String ID_INTENSITY = "intensity";
    public static final String ID_DEFLECTION = "deflection";
    public static final String ID_SHUTTER = "shutter";
    public static final String ID_IRIS = "iris";
    public static final String ID_ZOOM = "zoom";
    public static final String ID_FOCUS = "focus";
    public static final String ID_FROST = "frost";
    public static final String ID_PRISMA = "prisma";
    public static final String ID_FRAME = "frame";
    public static final String ID_FRAMEANGLE = "frameangle";
    public static final String ID_FRAMEHEADER = "frameheader";
    public static final String ID_STROBE = "strobe";
    public static final String ID_PROGRAMS = "programs";
    public static ArrayList<String> MOVABLECONTROLS_IDS = new ArrayList<String>(Arrays.asList("pantilt", "color1", "color2", "gobo1", "gobo2"));
    public static DMXControlDescriptions s_DMXControlDescriptions = new DMXControlDescriptions();
    public static DMXControlDescriptionCellRenderer s_DMXControlDescriptionCellRenderer = new DMXControlDescriptionCellRenderer();
    private String m_ID;
    private String m_Name;
    private boolean m_Fixed;
    private boolean m_IsDimmableByMain;

    public static DMXControlDescriptionCellRenderer getRenderer() {
        return s_DMXControlDescriptionCellRenderer;
    }

    public static DMXControlDescription getDMXControlDescription(String p_ID) {
        return s_DMXControlDescriptions.getDMXControlDescription(p_ID);
    }

    public DMXControlDescription() {
        this.initMembers();
    }

    public DMXControlDescription(String p_ID, String p_Name, boolean p_IsDimmableByMain, boolean p_Fixed) {
        this.initMembers();
        this.m_ID = p_ID;
        this.m_Name = p_Name;
        this.m_IsDimmableByMain = p_IsDimmableByMain;
        this.m_Fixed = p_Fixed;
        if (s_DMXControlDescriptions != null) {
            s_DMXControlDescriptions.addDMXControlDescription(this);
        }
    }

    private void initMembers() {
        this.m_Fixed = false;
        this.m_IsDimmableByMain = false;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(1);
        out.writeUTF(this.m_ID);
        out.writeUTF(this.m_Name);
        out.writeBoolean(this.m_IsDimmableByMain);
        out.writeBoolean(this.m_Fixed);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int intSoftwareVersion = in.readInt();
        this.m_ID = in.readUTF();
        this.m_Name = in.readUTF();
        this.m_IsDimmableByMain = in.readBoolean();
        this.m_Fixed = in.readBoolean();
        s_DMXControlDescriptions.addDMXControlDescription(this);
    }

    public String getID() {
        return this.m_ID;
    }

    public void setID(String p_ID) {
        this.m_ID = p_ID;
    }

    public String getName() {
        return this.m_Name;
    }

    public boolean getFixed() {
        return this.m_Fixed;
    }

    public boolean getIsDimmableByMain() {
        return this.m_IsDimmableByMain;
    }

    public static DMXControlDescriptionCellRenderer getDMXControlDescriptionCellRenderer() {
        return s_DMXControlDescriptionCellRenderer;
    }

    public static class DMXControlDescriptionsWrapper
    implements ComboBoxModel<DMXControlDescription> {
        private DMXControlDescription m_SelectedDescription = null;
        private DMXControlDescriptions m_DMXControlDescriptionList;

        public DMXControlDescriptionsWrapper(DMXControlDescriptions p_DMXControlDescriptionList) {
            this.m_DMXControlDescriptionList = p_DMXControlDescriptionList;
        }

        @Override
        public void setSelectedItem(Object anItem) {
            this.m_SelectedDescription = (DMXControlDescription)anItem;
        }

        @Override
        public Object getSelectedItem() {
            return this.m_SelectedDescription;
        }

        public void addDMXControlDescription(DMXControlDescription p_DMXControlDescription) {
            this.m_DMXControlDescriptionList.addDMXControlDescription(p_DMXControlDescription);
        }

        @Override
        public int getSize() {
            return this.m_DMXControlDescriptionList.getSize();
        }

        @Override
        public DMXControlDescription getElementAt(int index) {
            return this.m_DMXControlDescriptionList.getElementAt(index);
        }

        @Override
        public void addListDataListener(ListDataListener l) {
            this.m_DMXControlDescriptionList.addListDataListener(l);
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
            this.m_DMXControlDescriptionList.removeListDataListener(l);
        }
    }

    public static class DMXControlDescriptionListModel
    extends TableAndListModel.ListModel<DMXControlDescription> {
        private final Object m_SyncDescriptions = new Object();
        private final Object m_SyncListeners = new Object();

        public DMXControlDescriptionListModel() {
            super(false);
            this.initMembers();
        }

        private void initMembers() {
        }

        public boolean addDMXControlDescription(DMXControlDescription p_DMXControlDescription) {
            if (p_DMXControlDescription == null) {
                return false;
            }
            return this.add(p_DMXControlDescription);
        }

        public boolean removeDMXControlDescription(DMXControlDescription p_DMXControlDescription) {
            if (p_DMXControlDescription == null) {
                return false;
            }
            return this.remove(p_DMXControlDescription);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean removeDMXControlDescription(String p_DMXControlDescriptionID) {
            if (p_DMXControlDescriptionID == null) {
                return false;
            }
            DMXControlDescription o_DMXControlDescription = null;
            Object object = this.m_SyncDescriptions;
            synchronized (object) {
                for (int intDescription = 0; intDescription < this.size() && !p_DMXControlDescriptionID.equals((o_DMXControlDescription = (DMXControlDescription)this.get(intDescription)).getID()); ++intDescription) {
                    o_DMXControlDescription = null;
                }
            }
            if (o_DMXControlDescription != null) {
                return this.removeDMXControlDescription(o_DMXControlDescription);
            }
            return false;
        }
    }

    public static class DMXControlDescriptionCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private StringBuilder m_StringBuilder;
        protected JLabel m_JLabel;

        public DMXControlDescriptionCellRenderer() {
            this.initMembers();
        }

        private void initMembers() {
            this.m_StringBuilder = new StringBuilder();
            this.m_JLabel = new JLabelBackground();
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Color o_Background = null;
            Color o_Foreground = null;
            o_Background = list.getBackground();
            o_Foreground = list.getForeground();
            if (isSelected) {
                if (list.hasFocus()) {
                    o_Background = UIManager.getColor("List.selectionBackground");
                    o_Foreground = UIManager.getColor("List.selectionForeground");
                } else {
                    o_Background = UIManager.getColor("List.selectionInactiveBackground");
                    o_Foreground = UIManager.getColor("List.selectionInactiveForeground");
                }
            }
            this.m_JLabel.setForeground(o_Foreground);
            this.m_JLabel.setBackground(o_Background);
            this.m_StringBuilder.delete(0, this.m_StringBuilder.length());
            this.m_JLabel.setHorizontalAlignment(0);
            if (value instanceof DMXControlDescription) {
                this.m_JLabel.setPreferredSize(new Dimension(100, 20));
                DMXControlDescription o_DMXControlDescription = (DMXControlDescription)value;
                this.m_StringBuilder.append("<html>");
                if (o_DMXControlDescription.getName() != null) {
                    this.m_StringBuilder.append("<b>");
                    this.m_StringBuilder.append(o_DMXControlDescription.getName());
                    this.m_StringBuilder.append("</b>");
                }
                this.m_StringBuilder.append("</html>");
                this.m_JLabel.setText(this.m_StringBuilder.toString());
            }
            return this.m_JLabel;
        }
    }

    public static class DMXControlDescriptions
    implements ComboBoxModel<DMXControlDescription> {
        public static final String INIFILE_NAME = OSChecker.getPathUserHomeConfigDirectory() + "/DMXControlDescriptions.ini";
        public static final String INIFILE_FIELDSEPERATOR = ";";
        public static final String INIFILE_FIELDVALUEPAIRSEPERATOR = "=";
        public static final String INIFILE_REMARK = "//";
        private ArrayList<DMXControlDescription> m_FixedControlDescriptions;
        private ArrayList<DMXControlDescription> m_DMXControlDescriptions;
        private ArrayList<ListDataListener> m_ArrayListListDataListeners;
        private DMXControlDescription m_SelectedDescription;
        private final Object m_SyncListeners = new Object();
        public static String ID_UNDEFINED = "-";
        @LiveLanguageString
        public static String NAME_UNDEFINED = "-";
        public static final String ID_DIMMER = "dimmer";
        @LiveLanguageString
        public static String NAME_DIMMER = "Dimmer";
        public static final String ID_SWITCH = "switch";
        @LiveLanguageString
        public static String NAME_SWITCH = "Switch";
        public static final String ID_RGBCMY = "rgbcmy";
        @LiveLanguageString
        public static String NAME_RGBCMY = "RGB/CMY";
        public static final String ID_EXTRACOLOR_WHITE = "colorwhite";
        @LiveLanguageString
        public static String NAME_EXTRACOLOR_WHITE = "Extra Color White";
        public static final String ID_EXTRACOLOR_WHITE_COLD = "colorwhitecold";
        @LiveLanguageString
        public static String NAME_EXTRACOLOR_WHITE_COLD = "Extra Color Cold White";
        public static final String ID_EXTRACOLOR_WHITE_WARM = "colorwhitewarm";
        @LiveLanguageString
        public static String NAME_EXTRACOLOR_WHITE_WARM = "Extra Color Warm White";
        public static final String ID_EXTRACOLOR_LIME = "colorlime";
        @LiveLanguageString
        public static String NAME_EXTRACOLOR_LIME = "Extra Color Lime";
        public static final String ID_EXTRACOLOR_LIGHTBLUE = "colorlightblue";
        @LiveLanguageString
        public static String NAME_EXTRACOLOR_LIGHTBLUS = "Extra Color LightBlue";
        public static final String ID_EXTRACOLOR_PINK = "colorpink";
        @LiveLanguageString
        public static String NAME_EXTRACOLOR_PINK = "Extra Color Pink";
        public static final String ID_EXTRACOLOR_PURPLE = "colorpurple";
        @LiveLanguageString
        public static String NAME_EXTRACOLOR_PURPLE = "Extra Color Purple";
        public static final String ID_EXTRACOLOR_CYAN = "colorcyan";
        @LiveLanguageString
        public static String NAME_EXTRACOLOR_CYAN = "Extra Color Cyan";
        public static final String ID_EXTRACOLOR_MAGENTA = "colormagenta";
        @LiveLanguageString
        public static String NAME_EXTRACOLOR_MAGENTA = "Extra Color Magenta";
        public static final String ID_EXTRACOLOR_YELLOW = "coloryellow";
        @LiveLanguageString
        public static String NAME_EXTRACOLOR_YELLOW = "Extra Color Yellow";
        public static final String ID_EXTRACOLOR_AMBER = "coloramber";
        @LiveLanguageString
        public static String NAME_EXTRACOLOR_AMBER = "Extra Color Amber";
        public static final String ID_EXTRACOLOR_UV = "coloruv";
        @LiveLanguageString
        public static String NAME_EXTRACOLOR_UV = "Extra Color UV";
        public static final String ID_COLOR1 = "color1";
        @LiveLanguageString
        public static String NAME_COLOR1 = "ColorWheel";
        public static final String ID_COLOR2 = "color2";
        @LiveLanguageString
        public static String NAME_COLOR2 = "ColorWheel 2";
        public static final String ID_PANTILT = "pantilt";
        @LiveLanguageString
        public static String NAME_PANTILT = "Pan/Tilt";
        public static final String ID_DURATION = "duration";
        @LiveLanguageString
        public static String NAME_DURATION = "Duration";
        public static final String ID_DEFLECTION = "deflection";
        @LiveLanguageString
        public static String NAME_DEFLECTION = "Deflection/Angle";
        public static final String ID_PROGRAMS = "programs";
        @LiveLanguageString
        public static String NAME_PROGRAMS = "Programs/Macros";
        public static final String ID_INTENSITY = "intensity";
        @LiveLanguageString
        public static String NAME_INTENSITY = "Intensity";
        public static final String ID_GOBO1 = "gobo1";
        @LiveLanguageString
        public static String NAME_GOBO1 = "GoboWheel 1";
        public static final String ID_GOBO2 = "gobo2";
        @LiveLanguageString
        public static String NAME_GOBO2 = "GoboWheel 2";
        public static final String ID_COLORTEMPERATURE = "colortemperature";
        @LiveLanguageString
        public static String NAME_COLORTEMPERATURE = "ColorTemperature";
        public static final String ID_SHUTTER = "shutter";
        @LiveLanguageString
        public static String NAME_SHUTTER = "Shutter";
        public static final String ID_ZOOM = "zoom";
        @LiveLanguageString
        public static String NAME_ZOOM = "Zoom";
        public static final String ID_FOCUS = "focus";
        @LiveLanguageString
        public static String NAME_FOCUS = "Focus";
        public static final String ID_IRIS = "iris";
        @LiveLanguageString
        public static String NAME_IRIS = "Iris";
        public static final String ID_FROST = "frost";
        @LiveLanguageString
        public static String NAME_FROST = "Frost";
        public static final String ID_PRISMA = "prisma";
        @LiveLanguageString
        public static String NAME_PRISMA = "Prisma";
        @LiveLanguageString
        public static String NAME_FRAME = "Frame";
        public static final String ID_FRAME = "frame";
        @LiveLanguageString
        public static String NAME_FRAMEANGLE = "Frameangle";
        public static final String ID_FRAMEANGLE = "frameangle";
        @LiveLanguageString
        public static String NAME_FRAMEHEADER = "Frameheader";
        public static final String ID_FRAMEHEADER = "frameheader";
        public static final String ID_STROBE = "strobe";
        @LiveLanguageString
        public static String NAME_STROBE = "Strobe";

        public DMXControlDescriptions() {
            this.initMembers();
            LiveLanguage.addLanguageListener((Object)this, null);
            this.constructStandardDMXControlDescriptions();
            this.readIni();
        }

        private void initMembers() {
            this.m_FixedControlDescriptions = new ArrayList();
            this.m_DMXControlDescriptions = new ArrayList();
            this.m_ArrayListListDataListeners = new ArrayList();
            this.m_SelectedDescription = null;
        }

        private void constructStandardDMXControlDescriptions() {
            DMXControlDescription o_DMXControlDescription = new DMXControlDescription(ID_UNDEFINED, NAME_UNDEFINED, false, false);
            this.addDMXControlDescription(o_DMXControlDescription);
            o_DMXControlDescription = new DMXControlDescription("dimmer", NAME_DIMMER, true, true);
            this.addDMXControlDescription(o_DMXControlDescription);
            o_DMXControlDescription = new DMXControlDescription("rgbcmy", NAME_RGBCMY, true, true);
            this.addDMXControlDescription(o_DMXControlDescription);
            o_DMXControlDescription = new DMXControlDescription("pantilt", NAME_PANTILT, false, true);
            this.addDMXControlDescription(o_DMXControlDescription);
            o_DMXControlDescription = new DMXControlDescription("switch", NAME_SWITCH, false, false);
            this.addDMXControlDescription(o_DMXControlDescription);
            o_DMXControlDescription = new DMXControlDescription("colorwhite", NAME_EXTRACOLOR_WHITE, true, false);
            this.addDMXControlDescription(o_DMXControlDescription);
            o_DMXControlDescription = new DMXControlDescription("colorwhitecold", NAME_EXTRACOLOR_WHITE_COLD, true, false);
            this.addDMXControlDescription(o_DMXControlDescription);
            o_DMXControlDescription = new DMXControlDescription("colorwhitewarm", NAME_EXTRACOLOR_WHITE_WARM, true, false);
            this.addDMXControlDescription(o_DMXControlDescription);
            o_DMXControlDescription = new DMXControlDescription("coloramber", NAME_EXTRACOLOR_AMBER, true, false);
            this.addDMXControlDescription(o_DMXControlDescription);
            o_DMXControlDescription = new DMXControlDescription("coloruv", NAME_EXTRACOLOR_UV, true, false);
            this.addDMXControlDescription(o_DMXControlDescription);
            o_DMXControlDescription = new DMXControlDescription("colorlime", NAME_EXTRACOLOR_LIME, true, false);
            this.addDMXControlDescription(o_DMXControlDescription);
            o_DMXControlDescription = new DMXControlDescription("colorlightblue", NAME_EXTRACOLOR_LIGHTBLUS, true, false);
            this.addDMXControlDescription(o_DMXControlDescription);
            o_DMXControlDescription = new DMXControlDescription("colorpink", NAME_EXTRACOLOR_PINK, true, false);
            this.addDMXControlDescription(o_DMXControlDescription);
            o_DMXControlDescription = new DMXControlDescription("colorpurple", NAME_EXTRACOLOR_PURPLE, true, false);
            this.addDMXControlDescription(o_DMXControlDescription);
            o_DMXControlDescription = new DMXControlDescription("colorcyan", NAME_EXTRACOLOR_CYAN, true, false);
            this.addDMXControlDescription(o_DMXControlDescription);
            o_DMXControlDescription = new DMXControlDescription("colormagenta", NAME_EXTRACOLOR_MAGENTA, true, false);
            this.addDMXControlDescription(o_DMXControlDescription);
            o_DMXControlDescription = new DMXControlDescription("coloryellow", NAME_EXTRACOLOR_YELLOW, true, false);
            this.addDMXControlDescription(o_DMXControlDescription);
            o_DMXControlDescription = new DMXControlDescription("colortemperature", NAME_COLORTEMPERATURE, false, false);
            this.addDMXControlDescription(o_DMXControlDescription);
            o_DMXControlDescription = new DMXControlDescription("color1", NAME_COLOR1, false, false);
            this.addDMXControlDescription(o_DMXControlDescription);
            o_DMXControlDescription = new DMXControlDescription("color2", NAME_COLOR2, false, false);
            this.addDMXControlDescription(o_DMXControlDescription);
            o_DMXControlDescription = new DMXControlDescription("duration", NAME_DURATION, false, false);
            this.addDMXControlDescription(o_DMXControlDescription);
            o_DMXControlDescription = new DMXControlDescription("intensity", NAME_INTENSITY, false, false);
            this.addDMXControlDescription(o_DMXControlDescription);
            o_DMXControlDescription = new DMXControlDescription("deflection", NAME_DEFLECTION, false, false);
            this.addDMXControlDescription(o_DMXControlDescription);
            o_DMXControlDescription = new DMXControlDescription("programs", NAME_PROGRAMS, false, false);
            this.addDMXControlDescription(o_DMXControlDescription);
            o_DMXControlDescription = new DMXControlDescription("gobo1", NAME_GOBO1, false, false);
            this.addDMXControlDescription(o_DMXControlDescription);
            o_DMXControlDescription = new DMXControlDescription("gobo2", NAME_GOBO2, false, false);
            this.addDMXControlDescription(o_DMXControlDescription);
            o_DMXControlDescription = new DMXControlDescription("shutter", NAME_SHUTTER, false, false);
            this.addDMXControlDescription(o_DMXControlDescription);
            o_DMXControlDescription = new DMXControlDescription("strobe", NAME_STROBE, false, false);
            this.addDMXControlDescription(o_DMXControlDescription);
            o_DMXControlDescription = new DMXControlDescription("zoom", NAME_ZOOM, false, false);
            this.addDMXControlDescription(o_DMXControlDescription);
            o_DMXControlDescription = new DMXControlDescription("focus", NAME_FOCUS, false, false);
            this.addDMXControlDescription(o_DMXControlDescription);
            o_DMXControlDescription = new DMXControlDescription("iris", NAME_IRIS, false, false);
            this.addDMXControlDescription(o_DMXControlDescription);
            o_DMXControlDescription = new DMXControlDescription("frost", NAME_FROST, false, false);
            this.addDMXControlDescription(o_DMXControlDescription);
            o_DMXControlDescription = new DMXControlDescription("prisma", NAME_PRISMA, false, false);
            this.addDMXControlDescription(o_DMXControlDescription);
            o_DMXControlDescription = new DMXControlDescription("frame", NAME_FRAME, false, false);
            this.addDMXControlDescription(o_DMXControlDescription);
            o_DMXControlDescription = new DMXControlDescription("frameangle", NAME_FRAMEANGLE, false, false);
            this.addDMXControlDescription(o_DMXControlDescription);
            o_DMXControlDescription = new DMXControlDescription("frameheader", NAME_FRAMEHEADER, false, false);
            this.addDMXControlDescription(o_DMXControlDescription);
        }

        public boolean readIni() {
            File o_FileIni = new File(INIFILE_NAME);
            if (!o_FileIni.exists()) {
                return false;
            }
            boolean boolIni = false;
            FileReader o_FileReaderIni = null;
            BufferedReader o_BufferedReader = null;
            try {
                o_FileReaderIni = new FileReader(o_FileIni);
                o_BufferedReader = new BufferedReader(o_FileReaderIni);
                String stringLine = o_BufferedReader.readLine();
                while (stringLine != null) {
                    String[] stringValuePair;
                    if (stringLine.trim().length() < 2) {
                        stringLine = o_BufferedReader.readLine();
                        continue;
                    }
                    if (stringLine.trim().substring(0, 2).equals(INIFILE_REMARK)) {
                        stringLine = o_BufferedReader.readLine();
                        continue;
                    }
                    String[] stringValues = stringLine.split(INIFILE_FIELDSEPERATOR);
                    if (stringValues == null) {
                        stringLine = o_BufferedReader.readLine();
                        continue;
                    }
                    if (stringValues.length < 2) {
                        stringLine = o_BufferedReader.readLine();
                        continue;
                    }
                    String stringID = null;
                    String stringDimmable = null;
                    String stringName = null;
                    String stringFixed = null;
                    boolean boolFixed = false;
                    boolean boolDimmable = false;
                    for (int intValue = 0; intValue < stringValues.length && (stringValuePair = stringValues[intValue].split(INIFILE_FIELDVALUEPAIRSEPERATOR)) != null && stringValuePair.length >= 2; ++intValue) {
                        if (stringValuePair[1].trim().length() <= 0) continue;
                        String stringPropertyName = stringValuePair[0].trim();
                        String stringPropertyValue = stringValuePair[1].trim();
                        if (stringPropertyName.trim().toLowerCase().equals("ID".toLowerCase())) {
                            stringID = stringPropertyValue.trim();
                            continue;
                        }
                        if (stringPropertyName.trim().toLowerCase().equals("Name".toLowerCase())) {
                            stringName = stringPropertyValue.trim();
                            continue;
                        }
                        if (stringPropertyName.trim().toLowerCase().equals("IsDimmableByMain".toLowerCase())) {
                            stringDimmable = stringPropertyValue.trim();
                            continue;
                        }
                        if (!stringPropertyName.trim().toLowerCase().equals("Fixed".toLowerCase())) continue;
                        stringFixed = stringPropertyValue.trim();
                    }
                    if (stringID != null && stringName != null) {
                        DMXControlDescription o_DMXControlDescription;
                        if (stringFixed != null) {
                            boolFixed = stringFixed.toLowerCase().equals("true");
                        }
                        if (stringDimmable != null) {
                            boolDimmable = stringDimmable.toLowerCase().equals("true");
                        }
                        if ((o_DMXControlDescription = this.getDMXControlDescription(stringID)) == null) {
                            String stringLanguageName = LiveLanguage.loadLanguageString((Object)this, stringID);
                            if (stringLanguageName != null) {
                                stringName = stringLanguageName;
                            }
                            o_DMXControlDescription = new DMXControlDescription(stringID, stringName, boolDimmable, boolFixed);
                            this.addDMXControlDescription(o_DMXControlDescription);
                        }
                    }
                    stringLine = o_BufferedReader.readLine();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                if (o_BufferedReader != null) {
                    o_BufferedReader.close();
                }
                if (o_FileReaderIni != null) {
                    o_FileReaderIni.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return boolIni;
        }

        public boolean addDMXControlDescription(DMXControlDescription p_DMXControlDescription) {
            if (p_DMXControlDescription == null) {
                return false;
            }
            if (p_DMXControlDescription.getFixed()) {
                if (this.m_FixedControlDescriptions.contains(p_DMXControlDescription)) {
                    return false;
                }
                int intIndex = this.getIndexOfFixedDMXControlDescription(p_DMXControlDescription.getID());
                if (intIndex >= 0) {
                    this.m_FixedControlDescriptions.set(intIndex, p_DMXControlDescription);
                    this.fireDMXControlDescriptionChanged(p_DMXControlDescription);
                } else {
                    this.m_FixedControlDescriptions.add(p_DMXControlDescription);
                    this.fireDMXControlDescriptionAdded(p_DMXControlDescription);
                }
            } else {
                if (this.m_DMXControlDescriptions.contains(p_DMXControlDescription)) {
                    return false;
                }
                int intIndex = this.getIndexOfDMXControlDescription(p_DMXControlDescription.getID());
                if (intIndex >= 0) {
                    this.m_DMXControlDescriptions.set(intIndex, p_DMXControlDescription);
                    this.fireDMXControlDescriptionChanged(p_DMXControlDescription);
                } else {
                    this.m_DMXControlDescriptions.add(p_DMXControlDescription);
                    this.fireDMXControlDescriptionAdded(p_DMXControlDescription);
                }
            }
            return true;
        }

        public int getIndexOfDMXControlDescription(DMXControlDescription p_DMXControlDescription) {
            if (p_DMXControlDescription == null) {
                return -1;
            }
            return this.m_DMXControlDescriptions.indexOf(p_DMXControlDescription);
        }

        public int getIndexOfDMXControlDescription(String p_ID) {
            if (p_ID == null) {
                return -1;
            }
            DMXControlDescription o_DMXControlDescription = this.getDMXControlDescription(p_ID);
            return this.getIndexOfDMXControlDescription(o_DMXControlDescription);
        }

        public DMXControlDescription getDMXControlDescription(String p_ID) {
            DMXControlDescription o_DMXControlDescription = null;
            for (int intDescfription = 0; intDescfription < this.m_DMXControlDescriptions.size(); ++intDescfription) {
                o_DMXControlDescription = this.m_DMXControlDescriptions.get(intDescfription);
                if (!o_DMXControlDescription.getID().equals(p_ID)) continue;
                return o_DMXControlDescription;
            }
            return this.getFixedDMXControlDescription(p_ID);
        }

        public int getIndexOfFixedDMXControlDescription(DMXControlDescription p_DMXControlDescription) {
            if (p_DMXControlDescription == null) {
                return -1;
            }
            return this.m_FixedControlDescriptions.indexOf(p_DMXControlDescription);
        }

        public int getIndexOfFixedDMXControlDescription(String p_ID) {
            if (p_ID == null) {
                return -1;
            }
            DMXControlDescription o_DMXControlDescription = this.getFixedDMXControlDescription(p_ID);
            return this.getIndexOfFixedDMXControlDescription(o_DMXControlDescription);
        }

        public DMXControlDescription getFixedDMXControlDescription(String p_ID) {
            for (int intDescription = 0; intDescription < this.m_FixedControlDescriptions.size(); ++intDescription) {
                DMXControlDescription o_DMXControlDescription = this.m_FixedControlDescriptions.get(intDescription);
                if (!o_DMXControlDescription.getID().equals(p_ID)) continue;
                return o_DMXControlDescription;
            }
            return null;
        }

        @Override
        public void setSelectedItem(Object anItem) {
            this.m_SelectedDescription = (DMXControlDescription)anItem;
        }

        @Override
        public Object getSelectedItem() {
            return this.m_SelectedDescription;
        }

        @Override
        public int getSize() {
            return this.m_DMXControlDescriptions.size();
        }

        @Override
        public DMXControlDescription getElementAt(int p_Index) {
            if (p_Index < 0 || p_Index >= this.m_DMXControlDescriptions.size()) {
                return null;
            }
            return this.m_DMXControlDescriptions.get(p_Index);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addListDataListener(ListDataListener p_ListDataListener) {
            if (p_ListDataListener == null) {
                return;
            }
            Object object = this.m_SyncListeners;
            synchronized (object) {
                if (this.m_ArrayListListDataListeners == null) {
                    return;
                }
                if (this.m_ArrayListListDataListeners.contains(p_ListDataListener)) {
                    return;
                }
                this.m_ArrayListListDataListeners.add(p_ListDataListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeListDataListener(ListDataListener p_ListDataListener) {
            if (p_ListDataListener == null) {
                return;
            }
            Object object = this.m_SyncListeners;
            synchronized (object) {
                if (this.m_ArrayListListDataListeners == null) {
                    return;
                }
                this.m_ArrayListListDataListeners.remove(p_ListDataListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireDMXControlDescriptionAdded(DMXControlDescription p_DMXControlDescription) {
            ArrayList o_Listeners;
            int intIndex;
            if (p_DMXControlDescription == null) {
                return;
            }
            Object object = this.m_SyncListeners;
            synchronized (object) {
                if (this.m_ArrayListListDataListeners == null || this.m_ArrayListListDataListeners.size() <= 0) {
                    return;
                }
                intIndex = this.m_DMXControlDescriptions.indexOf(p_DMXControlDescription);
                o_Listeners = new ArrayList(this.m_ArrayListListDataListeners.size());
            }
            ListDataEvent o_ListDataEvent = new ListDataEvent(this, 1, intIndex, intIndex);
            for (int intListener = 0; intListener < o_Listeners.size(); ++intListener) {
                ListDataListener o_ListDataListener = (ListDataListener)o_Listeners.get(intListener);
                o_ListDataListener.intervalAdded(o_ListDataEvent);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireDMXControlDescriptionRemoved(int p_Index) {
            ArrayList o_Listeners;
            if (p_Index < 0) {
                return;
            }
            Object object = this.m_SyncListeners;
            synchronized (object) {
                if (this.m_ArrayListListDataListeners == null || this.m_ArrayListListDataListeners.size() <= 0) {
                    return;
                }
                o_Listeners = new ArrayList(this.m_ArrayListListDataListeners.size());
            }
            ListDataEvent o_ListDataEvent = new ListDataEvent(this, 2, p_Index, p_Index);
            for (int intListener = 0; intListener < o_Listeners.size(); ++intListener) {
                ListDataListener o_ListDataListener = (ListDataListener)o_Listeners.get(intListener);
                o_ListDataListener.intervalRemoved(o_ListDataEvent);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireDMXControlDescriptionChanged(DMXControlDescription p_DMXControlDescription) {
            ArrayList o_Listeners;
            int intIndex;
            if (p_DMXControlDescription == null) {
                return;
            }
            Object object = this.m_SyncListeners;
            synchronized (object) {
                if (this.m_ArrayListListDataListeners == null || this.m_ArrayListListDataListeners.size() <= 0) {
                    return;
                }
                intIndex = this.m_DMXControlDescriptions.indexOf(p_DMXControlDescription);
                o_Listeners = new ArrayList(this.m_ArrayListListDataListeners.size());
            }
            ListDataEvent o_ListDataEvent = new ListDataEvent(this, 0, intIndex, intIndex);
            for (int intListener = 0; intListener < o_Listeners.size(); ++intListener) {
                ListDataListener o_ListDataListener = (ListDataListener)o_Listeners.get(intListener);
                o_ListDataListener.contentsChanged(o_ListDataEvent);
            }
        }
    }
}

