/*
 * Decompiled with CFR 0.152.
 */
package DMXHardwarePackage;

import DMXDevicePackage.DMXDevice;
import DMXDevicePackage.DMXDeviceFilter;
import DMXDevicePackage.DMXDeviceType;
import GUID.LiveGUID;
import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LanguageTools.LiveLanguagePackage.LiveLanguageString;
import LiveShowObjectPackage.LiveShowProjectDescription;
import LiveShowObjectPackage.SinglePropertyChangeSupport;
import LiveShowVirtualPackage.LiveShow_ImportDescription;
import SwingModelPackage.TableAndListModel;
import ToolsGraphics.JLabelBackground;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeListener;
import java.io.Externalizable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public class DMXPowerSource
implements DMXDeviceFilter.FilterInterface,
Externalizable {
    public static final int SOFTWAREVERSION = 2;
    public static String FILESUFFIX = ".lse";
    public static final String PROP_NAME = "name";
    public static final String PROP_REMARK = "remark";
    public static final String PROP_DMXDEVICEINTERNALSECTOR = "dmxpowersourceDMXDeviceInternalSector";
    public static final String PROP_VOLTAGE = "dmxpowersourceVoltage";
    public static final String PROP_FUSE = "dmxpowersourceFuse";
    public static final String PROP_WATTAGE = "dmxpowersourceWattage";
    public static final String PROP_ADDITIONALWATTAGE = "dmxpowersourceAdditionalWattage";
    public static final String PROP_WATTAGEUSED = "dmxpowersourceWattageUsed";
    public static final String PROP_SETTINGS = "dmxpowersourceSettings";
    public static int DEFAULT_VOLTAGE = 230;
    public static int DEFAULT_FUSE = 16;
    @LiveLanguageString
    public static String s_DMXPowerSourceName = "power source";
    @LiveLanguageString
    public static String s_WATTAGEUNIT = "W";
    public static TableAndListModel.ListModel<DMXPowerSource> s_DMXPowerSourceListModel = new TableAndListModel.ListModel(true);
    public static DMXPowerSourceRenderer s_DMXPowerSourceRenderer = new DMXPowerSourceRenderer();
    public static Icon s_Icon = new ImageIcon(DMXPowerSource.class.getResource("/IconsPackage/PowerSource.png"));
    public static File s_FileLastPowerSource = null;
    private String m_ID;
    private ArrayList<DMXDevice> m_DMXDevices;
    private ArrayList<DMXDevice.InternalSector> m_DMXDeviceInternalSectors;
    private String m_Name;
    private String m_NamePlusWattage;
    private String m_ToolTipText;
    private String m_Remark;
    private int m_Voltage;
    private int m_Fuse;
    private int m_Wattage;
    private int m_AddtionalWattage;
    private int m_WattageUsed;
    private SinglePropertyChangeSupport m_PropertyChangeSupport;

    public static TableAndListModel.ListModel<DMXPowerSource> getListModel() {
        return s_DMXPowerSourceListModel;
    }

    public static DefaultListCellRenderer getListCellRenderer() {
        return s_DMXPowerSourceRenderer;
    }

    public static void addDMXPowerSource(DMXPowerSource p_DMXPowerSource) {
        s_DMXPowerSourceListModel.add(p_DMXPowerSource);
    }

    public static void removeDMXPowerSource(DMXPowerSource p_DMXPowerSource) {
        if (p_DMXPowerSource == null) {
            return;
        }
        if (s_DMXPowerSourceListModel.remove(p_DMXPowerSource)) {
            p_DMXPowerSource.close();
        }
    }

    public static boolean contains(DMXPowerSource p_DMXPowerSource) {
        return s_DMXPowerSourceListModel.contains(p_DMXPowerSource);
    }

    public static boolean contains(String p_ID) {
        return DMXPowerSource.getDMXPowerSource(p_ID) != null;
    }

    public static int getDMXPowerSourceCount() {
        return s_DMXPowerSourceListModel.size();
    }

    public static DMXPowerSource getDMXPowerSource(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        return s_DMXPowerSourceListModel.get(p_Index);
    }

    public static DMXPowerSource getDMXPowerSource(String p_ID) {
        if (p_ID == null) {
            return null;
        }
        for (int intDMXPowerSource = 0; intDMXPowerSource < s_DMXPowerSourceListModel.size(); ++intDMXPowerSource) {
            DMXPowerSource o_DMXPowerSource = s_DMXPowerSourceListModel.get(intDMXPowerSource);
            if (o_DMXPowerSource == null || !p_ID.equals(o_DMXPowerSource.getID())) continue;
            return o_DMXPowerSource;
        }
        return null;
    }

    public static ArrayList<DMXPowerSource> getDMXPowerSources() {
        return s_DMXPowerSourceListModel.getElementArrayList_Safe();
    }

    public static boolean saveDMXPowerSources(LiveShowProjectDescription p_LiveShowProjectDescription, ArrayList<DMXDevice> p_DMXDevices) {
        if (p_LiveShowProjectDescription == null) {
            return false;
        }
        String stringFileName = p_LiveShowProjectDescription.getProjectPathName() + FILESUFFIX;
        try {
            int intPowerSource;
            DMXPowerSource o_DMXPowerSource;
            ArrayList<DMXPowerSource> o_ArrayListDMXPowerSources;
            File o_File = new File(stringFileName);
            if (o_File.exists()) {
                try {
                    o_File.delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            o_File.createNewFile();
            FileOutputStream o_FileOutputStream = new FileOutputStream(o_File);
            ObjectOutputStream o_ObjectOutput = new ObjectOutputStream(o_FileOutputStream);
            o_ObjectOutput.writeInt(2);
            if (p_DMXDevices == null) {
                o_ArrayListDMXPowerSources = DMXPowerSource.getDMXPowerSources();
            } else {
                o_ArrayListDMXPowerSources = new ArrayList();
                for (int intDMXDevice = 0; intDMXDevice < p_DMXDevices.size(); ++intDMXDevice) {
                    DMXDevice o_DMXDevice = p_DMXDevices.get(intDMXDevice);
                    for (int intSector = 0; intSector < o_DMXDevice.getInternalSectorCount(); ++intSector) {
                        o_DMXPowerSource = o_DMXDevice.getDMXPowerSource(intSector);
                        if (o_DMXPowerSource == null || o_ArrayListDMXPowerSources.contains(o_DMXPowerSource)) continue;
                        o_ArrayListDMXPowerSources.add(o_DMXPowerSource);
                    }
                }
            }
            int intDMXPowerSourceCount = o_ArrayListDMXPowerSources.size();
            for (intPowerSource = 0; intPowerSource < intDMXPowerSourceCount; ++intPowerSource) {
                o_DMXPowerSource = o_ArrayListDMXPowerSources.get(intPowerSource);
                if (o_DMXPowerSource != null) continue;
                --intDMXPowerSourceCount;
            }
            o_ObjectOutput.writeInt(intDMXPowerSourceCount);
            for (intPowerSource = 0; intPowerSource < o_ArrayListDMXPowerSources.size(); ++intPowerSource) {
                o_DMXPowerSource = o_ArrayListDMXPowerSources.get(intPowerSource);
                if (o_DMXPowerSource == null) continue;
                o_DMXPowerSource.writeExternal(o_ObjectOutput);
            }
            o_ObjectOutput.close();
            o_FileOutputStream.close();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean deleteDMXPowerSources(LiveShowProjectDescription p_LiveShowProjectDescription) {
        if (p_LiveShowProjectDescription == null) {
            return false;
        }
        boolean boolSuccess = false;
        String stringFileName = p_LiveShowProjectDescription.getProjectPathName() + FILESUFFIX;
        File o_File = new File(stringFileName);
        if (o_File.exists()) {
            try {
                boolSuccess = o_File.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return boolSuccess;
    }

    public static boolean loadDMXPowerSources(LiveShowProjectDescription p_LiveShowProjectDescription, LiveShow_ImportDescription p_LiveShow_ImportDescription) {
        if (p_LiveShowProjectDescription == null) {
            return false;
        }
        boolean boolLoaded = false;
        String stringFileName = p_LiveShowProjectDescription.getProjectPathName() + FILESUFFIX;
        boolLoaded = p_LiveShow_ImportDescription == null || p_LiveShow_ImportDescription.getLoadNewProject() ? DMXPowerSource.importDMXPowerSources(stringFileName, false) : DMXPowerSource.importDMXPowerSources(stringFileName, true);
        if (s_DMXPowerSourceListModel.size() <= 1) {
            DMXPowerSource o_DMXPowerSource = new DMXPowerSource();
            DMXPowerSource.addDMXPowerSource(o_DMXPowerSource);
        }
        return boolLoaded;
    }

    public static boolean importDMXPowerSources(String p_FileName, boolean p_IsImport) {
        ArrayList<DMXPowerSource> o_DMXPowerSources;
        if (p_FileName == null) {
            return false;
        }
        try {
            String stringFileNamePostfix = p_FileName.substring(p_FileName.length() - 4, p_FileName.length());
            if (!stringFileNamePostfix.equals(FILESUFFIX)) {
                return false;
            }
            String stringRareFileName = p_FileName.substring(0, p_FileName.length() - 4);
        }
        catch (Exception e) {
            return false;
        }
        FileInputStream o_FileInputStream = null;
        ObjectInput o_ObjectInput = null;
        try {
            File o_File = new File(p_FileName);
            o_FileInputStream = new FileInputStream(o_File);
            o_ObjectInput = new ObjectInputStream(o_FileInputStream);
            int intSoftwareVersion = o_ObjectInput.readInt();
            int intPowerSourceCount = o_ObjectInput.readInt();
            o_DMXPowerSources = new ArrayList<DMXPowerSource>();
            for (int intPowerSource = 0; intPowerSource < intPowerSourceCount; ++intPowerSource) {
                DMXPowerSource o_DMXPowerSource = new DMXPowerSource();
                o_DMXPowerSource.readExternal(o_ObjectInput);
                if (DMXPowerSource.contains(o_DMXPowerSource.getID())) continue;
                if (p_IsImport) {
                    o_DMXPowerSource.setName(LiveShow_ImportDescription.createImportedName(o_DMXPowerSource.getName()));
                }
                DMXPowerSource.addDMXPowerSource(o_DMXPowerSource);
                o_DMXPowerSource.refreshDMXDeviceInternalSectors();
                o_DMXPowerSources.add(o_DMXPowerSource);
            }
            o_ObjectInput.close();
            o_FileInputStream.close();
        }
        catch (Exception e) {
            try {
                if (o_ObjectInput != null) {
                    o_ObjectInput.close();
                }
                if (o_FileInputStream != null) {
                    o_FileInputStream.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.out.println("DMXPowerSource importDMXPowerSources() error " + e.getMessage());
            return false;
        }
        if (o_DMXPowerSources.size() > 0) {
            o_DMXPowerSources.clear();
            return true;
        }
        return false;
    }

    public DMXPowerSource() {
        this.initMembers();
    }

    private void initMembers() {
        LiveLanguage.addLanguageListener((Object)this, null);
        this.m_ID = LiveGUID.getUID();
        this.m_ToolTipText = null;
        this.m_DMXDevices = new ArrayList();
        this.m_DMXDeviceInternalSectors = new ArrayList();
        this.m_Name = s_DMXPowerSourceName + " " + String.valueOf(s_DMXPowerSourceListModel.size());
        this.m_Remark = "";
        this.m_Voltage = DEFAULT_VOLTAGE;
        this.m_Fuse = DEFAULT_FUSE;
        this.m_Wattage = this.m_Voltage * this.m_Fuse;
        this.m_AddtionalWattage = 0;
        this.m_WattageUsed = 0;
        this.calculateNamePlusWattage();
        this.m_PropertyChangeSupport = new SinglePropertyChangeSupport(this);
        DMXDeviceFilter.createDMXDeviceFilter(this);
    }

    public void close() {
        LiveLanguage.removeLanguageListener((Object)this);
        DMXDeviceFilter.removeDMXDeviceFilter(this);
        for (int intDMXDevice = this.m_DMXDeviceInternalSectors.size() - 1; intDMXDevice >= 0; --intDMXDevice) {
            DMXDevice.InternalSector o_InternalSector = this.m_DMXDeviceInternalSectors.get(intDMXDevice);
            this.removeDMXDeviceInternalSector(o_InternalSector);
        }
        DMXPowerSource.removeDMXPowerSource(this);
        this.m_DMXDevices.clear();
        LiveLanguage.removeLanguageListener((Object)this);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(2);
        out.writeUTF(this.m_ID);
        out.writeUTF(this.m_Name);
        out.writeUTF(this.m_Remark);
        out.writeInt(this.m_Voltage);
        out.writeInt(this.m_Fuse);
        out.writeInt(this.m_Wattage);
        out.writeInt(this.m_AddtionalWattage);
        out.writeInt(this.m_DMXDeviceInternalSectors.size());
        for (int intSector = 0; intSector < this.m_DMXDeviceInternalSectors.size(); ++intSector) {
            DMXDevice.InternalSector o_InternalSector = this.m_DMXDeviceInternalSectors.get(intSector);
            DMXDevice o_DMXDevice = o_InternalSector.getDMXDevice();
            if (o_DMXDevice == null) {
                out.writeUTF("");
            } else {
                out.writeUTF(o_DMXDevice.getID());
            }
            out.writeInt(o_InternalSector.getDMXDeviceSectorIndex());
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int intSoftwareVersion = in.readInt();
        this.m_ID = in.readUTF();
        this.m_Name = in.readUTF();
        this.m_Remark = in.readUTF();
        this.m_Voltage = in.readInt();
        this.m_Fuse = in.readInt();
        this.m_Wattage = in.readInt();
        if (intSoftwareVersion > 1) {
            this.m_AddtionalWattage = in.readInt();
        }
        int intInternalSectorCount = in.readInt();
        for (int intSector = 0; intSector < intInternalSectorCount; ++intSector) {
            DMXDevice.InternalSector o_InternalSector;
            String stringDMXDeviceID = in.readUTF();
            int intInternalSectorIndex = in.readInt();
            DMXDevice o_DMXDevice = DMXDevice.getDMXDevice(stringDMXDeviceID);
            if (o_DMXDevice == null || (o_InternalSector = o_DMXDevice.getInternalSector(intInternalSectorIndex)) == null) continue;
            this.addDMXDeviceInternalSector(o_InternalSector);
        }
    }

    public String getID() {
        return this.m_ID;
    }

    public void setID(String p_ID) {
        if (p_ID == null) {
            return;
        }
        this.m_ID = p_ID;
    }

    public int getVoltage() {
        return this.m_Voltage;
    }

    public void setVoltage(int p_Voltage) {
        int oldValue;
        if (p_Voltage <= 0) {
            p_Voltage = this.m_Wattage / this.m_Fuse;
            oldValue = 0;
        } else {
            if (p_Voltage == this.m_Voltage) {
                return;
            }
            oldValue = this.m_Voltage;
        }
        this.m_Voltage = p_Voltage;
        this.m_Wattage = this.m_Voltage * this.m_Fuse;
        this.calculateWattageUsed();
        this.calculateNamePlusWattage();
        this.m_PropertyChangeSupport.firePropertyChange(PROP_VOLTAGE, oldValue, this.m_Voltage);
    }

    public int getFuse() {
        return this.m_Fuse;
    }

    public void setFuse(int p_Fuse) {
        int oldValue;
        if (p_Fuse <= 0) {
            p_Fuse = this.m_Wattage / this.m_Voltage;
            oldValue = 0;
        } else {
            if (p_Fuse == this.m_Fuse) {
                return;
            }
            oldValue = this.m_Fuse;
        }
        this.m_Fuse = p_Fuse;
        this.m_Wattage = this.m_Voltage * this.m_Fuse;
        this.calculateWattageUsed();
        this.calculateNamePlusWattage();
        this.m_PropertyChangeSupport.firePropertyChange(PROP_FUSE, oldValue, this.m_Fuse);
    }

    public int getWattage() {
        return this.m_Wattage;
    }

    public void setWattage(int p_Wattage) {
        int oldValue;
        if (p_Wattage <= 0) {
            p_Wattage = this.m_Voltage * this.m_Fuse;
            oldValue = 0;
        } else {
            if (p_Wattage == this.m_Wattage) {
                return;
            }
            oldValue = this.m_Wattage;
        }
        this.m_Wattage = p_Wattage;
        if (this.m_Voltage != 0) {
            this.m_Fuse = (int)((double)this.m_Wattage / (double)this.m_Voltage + 0.999999);
        }
        this.calculateWattageUsed();
        this.calculateNamePlusWattage();
        this.m_PropertyChangeSupport.firePropertyChange(PROP_WATTAGE, oldValue, this.m_Wattage);
    }

    public void setAdditionalWattage(int p_AdditionalWattage) {
        if (p_AdditionalWattage < 0) {
            p_AdditionalWattage = 0;
        }
        if (this.m_AddtionalWattage == p_AdditionalWattage) {
            return;
        }
        int oldValue = this.m_AddtionalWattage;
        this.m_AddtionalWattage = p_AdditionalWattage;
        this.calculateWattageUsed();
        this.calculateNamePlusWattage();
        this.m_PropertyChangeSupport.firePropertyChange(PROP_ADDITIONALWATTAGE, oldValue, this.m_AddtionalWattage);
    }

    public int getAdditionalWattage() {
        return this.m_AddtionalWattage;
    }

    public int getWattageFree() {
        return this.m_Wattage - this.m_WattageUsed - this.m_AddtionalWattage;
    }

    public boolean getOverload() {
        return this.m_WattageUsed + this.m_AddtionalWattage > this.m_Wattage;
    }

    public boolean addDMXDeviceInternalSector(DMXDevice.InternalSector p_DMXDeviceInternalSector) {
        if (p_DMXDeviceInternalSector == null) {
            return false;
        }
        if (this.m_DMXDeviceInternalSectors.contains(p_DMXDeviceInternalSector)) {
            return true;
        }
        boolean boolAdded = false;
        boolAdded = this.m_DMXDeviceInternalSectors.add(p_DMXDeviceInternalSector);
        return boolAdded;
    }

    public boolean refreshDMXDeviceInternalSectors() {
        boolean boolChanged_One = false;
        boolean boolChanged_Single = false;
        for (int intInternalSector = 0; intInternalSector < this.m_DMXDeviceInternalSectors.size(); ++intInternalSector) {
            boolChanged_Single = false;
            DMXDevice.InternalSector o_DMXDeviceInternalSector = this.m_DMXDeviceInternalSectors.get(intInternalSector);
            DMXDevice o_DMXDevice = o_DMXDeviceInternalSector.getDMXDevice();
            if (o_DMXDevice != null && !this.m_DMXDevices.contains(o_DMXDevice)) {
                boolChanged_One = true;
                boolChanged_Single = true;
                this.m_DMXDevices.add(o_DMXDevice);
            }
            if (o_DMXDeviceInternalSector.getDMXPowerSource() != this) {
                boolChanged_One = true;
                boolChanged_Single = true;
                o_DMXDeviceInternalSector.setDMXPowerSource(this);
            }
            if (!boolChanged_Single) continue;
            this.calculateWattageUsed();
            this.m_PropertyChangeSupport.firePropertyChange(PROP_DMXDEVICEINTERNALSECTOR, null, o_DMXDeviceInternalSector);
        }
        return boolChanged_One;
    }

    public boolean removeDMXDeviceInternalSector(DMXDevice.InternalSector p_DMXDeviceInternalSector) {
        if (p_DMXDeviceInternalSector == null) {
            return false;
        }
        if (!this.m_DMXDeviceInternalSectors.contains(p_DMXDeviceInternalSector)) {
            return false;
        }
        boolean boolDeviceUsed = false;
        boolean boolRemoved = false;
        boolRemoved = this.m_DMXDeviceInternalSectors.remove(p_DMXDeviceInternalSector);
        if (boolRemoved) {
            DMXDevice o_DMXDeviceRemoved = p_DMXDeviceInternalSector.getDMXDevice();
            for (int intSector = 0; intSector < this.m_DMXDeviceInternalSectors.size(); ++intSector) {
                DMXDevice o_DMXDevice = this.m_DMXDeviceInternalSectors.get(intSector).getDMXDevice();
                if (o_DMXDevice != o_DMXDeviceRemoved) continue;
                boolDeviceUsed = true;
                break;
            }
            if (!boolDeviceUsed) {
                this.m_DMXDevices.remove(o_DMXDeviceRemoved);
            }
            p_DMXDeviceInternalSector.setDMXPowerSource(null);
            this.calculateWattageUsed();
            this.m_PropertyChangeSupport.firePropertyChange(PROP_DMXDEVICEINTERNALSECTOR, p_DMXDeviceInternalSector, null);
        }
        return boolRemoved;
    }

    public void calculateWattageUsed() {
        int oldValue = this.m_WattageUsed;
        this.m_WattageUsed = 0;
        for (int intSector = 0; intSector < this.m_DMXDeviceInternalSectors.size(); ++intSector) {
            DMXDeviceType o_DMXDeviceType;
            DMXDevice o_DMXDevice;
            DMXDevice.InternalSector o_InternalSector = this.m_DMXDeviceInternalSectors.get(intSector);
            if (o_InternalSector == null || (o_DMXDevice = o_InternalSector.getDMXDevice()) == null || (o_DMXDeviceType = o_DMXDevice.getDMXDeviceType()) == null) continue;
            int intDMXDeviceSectorIndex = o_InternalSector.getDMXDeviceSectorIndex();
            DMXDeviceType.DMXDeviceSector o_DMXDeviceSector = o_DMXDeviceType.getDMXDeviceSector(intDMXDeviceSectorIndex);
            if (o_DMXDeviceType == null) continue;
            this.m_WattageUsed += o_DMXDeviceSector.getWattage();
        }
        if (oldValue != this.m_WattageUsed) {
            this.calculateNamePlusWattage();
            this.m_PropertyChangeSupport.firePropertyChange(PROP_WATTAGEUSED, oldValue, this.m_WattageUsed);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
        this.m_PropertyChangeSupport.addPropertyChangeListener(p_PropertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
        this.m_PropertyChangeSupport.removePropertyChangeListener(p_PropertyChangeListener);
    }

    public void addPropertyChangeListener(String p_PropertyName, PropertyChangeListener p_PropertyChangeListener) {
        this.m_PropertyChangeSupport.addPropertyChangeListener(p_PropertyName, p_PropertyChangeListener);
    }

    public void removePropertyChangeListener(String p_PropertyName, PropertyChangeListener p_PropertyChangeListener) {
        this.m_PropertyChangeSupport.removePropertyChangeListener(p_PropertyName, p_PropertyChangeListener);
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.m_PropertyChangeSupport.getPropertyChangeListeners();
    }

    public PropertyChangeListener[] getPropertyChangeListeners(String p_PropertyName) {
        return this.m_PropertyChangeSupport.getPropertyChangeListeners(p_PropertyName);
    }

    public boolean hasListeners(String p_PropertyName) {
        return this.m_PropertyChangeSupport.hasListeners(p_PropertyName);
    }

    @Override
    public String getName() {
        return this.m_Name;
    }

    public void setName(String p_Name) {
        if (p_Name == null) {
            return;
        }
        if (p_Name.equals(this.m_Name)) {
            return;
        }
        String oldValue = this.m_Name;
        this.m_Name = p_Name;
        this.calculateNamePlusWattage();
        this.m_PropertyChangeSupport.firePropertyChange(PROP_NAME, oldValue, this.m_Name);
    }

    private void calculateNamePlusWattage() {
        StringBuilder o_StringBuilder = new StringBuilder();
        o_StringBuilder.append(this.getName());
        o_StringBuilder.append(" (");
        o_StringBuilder.append(this.getWattageFree());
        o_StringBuilder.append(" / ");
        o_StringBuilder.append(this.getWattage());
        o_StringBuilder.append(" ");
        o_StringBuilder.append(s_WATTAGEUNIT);
        o_StringBuilder.append(")");
        this.m_NamePlusWattage = o_StringBuilder.toString();
        this.calculateToolTipText();
    }

    public String getNamePlusWattage() {
        return this.m_NamePlusWattage;
    }

    public void calculateToolTipText() {
        StringBuilder o_StringBuilder = new StringBuilder();
        o_StringBuilder.append("<html>");
        o_StringBuilder.append("<b>");
        o_StringBuilder.append(this.getName());
        o_StringBuilder.append("</b>");
        o_StringBuilder.append("<br>");
        if (this.m_Remark != null && this.m_Remark.length() > 0) {
            o_StringBuilder.append(this.m_Remark);
            o_StringBuilder.append("<br>");
        }
        o_StringBuilder.append(" (");
        if (this.getWattageFree() < 0) {
            o_StringBuilder.append("<font color=\"#FF7000\">");
            o_StringBuilder.append(this.getWattageFree());
            o_StringBuilder.append("</font>");
        } else {
            o_StringBuilder.append(this.getWattageFree());
        }
        o_StringBuilder.append(" / ");
        o_StringBuilder.append(this.getWattage());
        o_StringBuilder.append(" ");
        o_StringBuilder.append(s_WATTAGEUNIT);
        o_StringBuilder.append(")");
        o_StringBuilder.append("</html>");
        this.m_ToolTipText = o_StringBuilder.toString();
    }

    public String getToolTipText() {
        return this.m_ToolTipText;
    }

    @Override
    public String getRemark() {
        return this.m_Remark;
    }

    public void setRemark(String p_Remark) {
        if (p_Remark == null) {
            p_Remark = "";
        }
        if (p_Remark.equals(this.m_Remark)) {
            return;
        }
        String oldValue = this.m_Remark;
        this.m_Remark = p_Remark;
        this.m_PropertyChangeSupport.firePropertyChange(PROP_REMARK, oldValue, this.m_Remark);
    }

    @Override
    public Icon getIcon() {
        return s_Icon;
    }

    public int getDMXDeviceCount() {
        return this.m_DMXDevices.size();
    }

    public DMXDevice getDMXDevice(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        if (p_Index >= this.m_DMXDevices.size()) {
            return null;
        }
        return this.m_DMXDevices.get(p_Index);
    }

    @Override
    public boolean useDMXDevice(DMXDevice p_DMXDevice) {
        return this.m_DMXDevices.contains(p_DMXDevice);
    }

    public static class DMXPowerSourceRenderer
    extends DefaultListCellRenderer {
        protected static final Border SAFE_NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);
        protected static final Border DEFAULT_NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);
        protected static final Border SELECTED_BORDER = new LineBorder(Color.BLUE, 2, true);
        protected static Dimension s_PreferredDimension_NULL = new Dimension(0, 0);
        protected Dimension m_PreferredDimension;
        protected boolean m_ShowNUll = true;
        protected JLabelBackground m_JLabelBackground = new JLabelBackground();

        public DMXPowerSourceRenderer() {
            super.setOpaque(true);
            this.m_JLabelBackground.setBackgroundStyle(0);
            this.m_JLabelBackground.setBackgroundGradientAngle(90);
            this.m_JLabelBackground.setBackgroundGradientColorFrom(Color.BLACK);
            this.m_JLabelBackground.setBackgroundGradientColorTo(Color.BLACK);
            this.m_JLabelBackground.setBackgroundOpaque(true);
            this.m_JLabelBackground.setForeground(Color.WHITE);
            this.m_PreferredDimension = new Dimension(20, 28);
        }

        public void setShowNULL(boolean p_ShowNull) {
            this.m_ShowNUll = p_ShowNull;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setComponentOrientation(list.getComponentOrientation());
            Color o_Background = null;
            Color o_Foreground = null;
            o_Background = list.getBackground();
            o_Foreground = list.getForeground();
            if (isSelected) {
                if (list.hasFocus()) {
                    o_Background = UIManager.getColor("List.selectionBackground");
                    o_Foreground = UIManager.getColor("List.selectionForeground");
                } else {
                    o_Background = UIManager.getColor("List.selectionInactiveBackground");
                    o_Foreground = UIManager.getColor("List.selectionInactiveForeground");
                }
            }
            this.m_JLabelBackground.setForeground(o_Foreground);
            this.m_JLabelBackground.setBackground(o_Background);
            if (value instanceof Icon) {
                this.m_JLabelBackground.setIcon((Icon)value);
                this.m_JLabelBackground.setText("");
            } else {
                this.m_JLabelBackground.setIcon(null);
                String stringName = "";
                String stringRemark = null;
                String stringToolTipText = null;
                if (value == null || !(value instanceof DMXPowerSource)) {
                    if (!this.m_ShowNUll) {
                        this.m_JLabelBackground.setPreferredSize(s_PreferredDimension_NULL);
                        this.m_JLabelBackground.setIcon(null);
                        this.m_JLabelBackground.setBorder(null);
                        this.m_JLabelBackground.setEnabled(false);
                        this.m_JLabelBackground.setToolTipText(null);
                        return this;
                    }
                    stringName = "---";
                    stringRemark = null;
                    this.m_JLabelBackground.setPreferredSize(this.m_PreferredDimension);
                } else {
                    DMXPowerSource o_DMXPowerSource = (DMXPowerSource)value;
                    if (o_DMXPowerSource != null) {
                        stringName = o_DMXPowerSource.getNamePlusWattage();
                        stringRemark = o_DMXPowerSource.getRemark();
                        stringToolTipText = o_DMXPowerSource.getToolTipText();
                        if (o_DMXPowerSource.getOverload()) {
                            this.m_JLabelBackground.setBackground(Color.RED);
                            this.m_JLabelBackground.setForeground(Color.BLACK);
                            this.m_JLabelBackground.setBackgroundGradientColorFrom(Color.RED);
                            this.m_JLabelBackground.setBackgroundGradientColorTo(Color.RED);
                        }
                    }
                    this.m_JLabelBackground.setIcon(s_Icon);
                    if (s_Icon != null && s_Icon.getIconHeight() < this.m_PreferredDimension.height) {
                        this.m_JLabelBackground.setPreferredSize(this.m_PreferredDimension);
                    }
                }
                this.m_JLabelBackground.setText(stringName);
                this.m_JLabelBackground.setToolTipText(stringToolTipText);
            }
            this.m_JLabelBackground.setEnabled(list.isEnabled());
            this.m_JLabelBackground.setFont(list.getFont());
            Border border = null;
            if (isSelected) {
                border = SELECTED_BORDER;
            }
            if (border == null) {
                border = this.getNoFocusBorder();
            }
            return this.m_JLabelBackground;
        }

        private Border getNoFocusBorder() {
            Border border = null;
            if (System.getSecurityManager() != null) {
                if (border != null) {
                    return border;
                }
                return SAFE_NO_FOCUS_BORDER;
            }
            if (border != null && (noFocusBorder == null || noFocusBorder == DEFAULT_NO_FOCUS_BORDER)) {
                return border;
            }
            return noFocusBorder;
        }
    }
}

