/*
 * Decompiled with CFR 0.152.
 */
package DMXGraphics;

import DMXDevicePackage.DMXDevice;
import DMXDevicePackage.DMXDeviceType;
import DMXMixer.DMXControlComponent;
import DMXMixer.DMXControl_Dimmer;
import DMXMixer.DMXControl_RGB;
import DMXMixer.DMXMixerPanel;
import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LiveShowControlObjects.ControlObject;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.JPanel;

public class LiveShowDMXMixerMainView
extends JPanel
implements PropertyChangeListener {
    public static String MAINDMXMIXERPANELNAME = "DMX Main";
    private DMXControl_Dimmer dMXControl_DimmerMain;
    private DMXControl_RGB dmxControl_RGBMain;
    private ArrayList<DMXControlComponent> m_MainMixerDMXControlComponents;
    private DMXMixerPanel dMXMixerPanel_MainMixer;
    public static final String SPITID_MAINDMX_DIMMER = "mainmixerDMX_Dimmer";
    public static final String SPITID_MAINDMX_RGB = "mainmixerDMX_RGB";

    public LiveShowDMXMixerMainView() {
        this.initMembers();
        this.initComponents();
        this.initComponentsFurther();
        LiveLanguage.addLanguageListener((Object)this, null);
    }

    private void initMembers() {
        this.m_MainMixerDMXControlComponents = new ArrayList();
    }

    public void close() {
        LiveLanguage.removeLanguageListener((Object)this);
        if (this.m_MainMixerDMXControlComponents != null) {
            int intMainDMXControlComponentCount = this.m_MainMixerDMXControlComponents.size();
            for (int intDMXControlComponent = intMainDMXControlComponentCount - 1; intDMXControlComponent >= 0; --intDMXControlComponent) {
                DMXControlComponent o_DMXControlComponent = this.m_MainMixerDMXControlComponents.get(intDMXControlComponent);
                this.removeMainMixerDMXControlComponent(o_DMXControlComponent);
            }
            this.m_MainMixerDMXControlComponents.clear();
        }
        LiveLanguage.removeLanguageListener((Object)this);
    }

    private void initComponents() {
        this.dMXMixerPanel_MainMixer = new DMXMixerPanel();
        this.setLayout(new GridBagLayout());
        this.dMXMixerPanel_MainMixer.setName("DMX Main");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.dMXMixerPanel_MainMixer, gridBagConstraints);
    }

    private void initComponentsFurther() {
        this.dMXMixerPanel_MainMixer.setName(MAINDMXMIXERPANELNAME);
        this.dMXMixerPanel_MainMixer.setOwner(1);
        DMXDevice.getTreeModel_Device_Channels().addPropertyChangeListener(this);
        this.dMXControl_DimmerMain = new DMXControl_Dimmer();
        this.addMainMixerDMXControlComponent(this.dMXControl_DimmerMain);
        this.dmxControl_RGBMain = new DMXControl_RGB();
        this.addMainMixerDMXControlComponent(this.dmxControl_RGBMain);
    }

    public void addMainMixerDMXControlComponent(DMXControlComponent p_DMXControlComponent) {
        if (p_DMXControlComponent == null) {
            return;
        }
        if (this.m_MainMixerDMXControlComponents.contains(p_DMXControlComponent)) {
            return;
        }
        p_DMXControlComponent.setEnableSettings(false);
        p_DMXControlComponent.setIsMaster(true);
        this.m_MainMixerDMXControlComponents.add(p_DMXControlComponent);
        this.dMXMixerPanel_MainMixer.addDMXControlComponent(p_DMXControlComponent);
        for (int intDMXDevice = 0; intDMXDevice < DMXDevice.getDMXDeviceCount(); ++intDMXDevice) {
            DMXDevice o_DMXDevice = DMXDevice.getDMXDevice(intDMXDevice);
            if (o_DMXDevice == null) continue;
            this.addMainLinks(o_DMXDevice, p_DMXControlComponent);
        }
    }

    public void removeMainMixerDMXControlComponent(DMXControlComponent p_DMXControlComponent) {
        if (p_DMXControlComponent == null) {
            return;
        }
        if (!this.m_MainMixerDMXControlComponents.contains(p_DMXControlComponent)) {
            return;
        }
        this.m_MainMixerDMXControlComponents.remove(p_DMXControlComponent);
        this.dMXMixerPanel_MainMixer.removeControlComponent(p_DMXControlComponent, false);
        for (int intDMXDevice = DMXDevice.getDMXDeviceCount() - 1; intDMXDevice >= 0; --intDMXDevice) {
            DMXDevice o_DMXDevice = DMXDevice.getDMXDevice(intDMXDevice);
            if (o_DMXDevice == null) continue;
            this.removeMainLinks(o_DMXDevice, p_DMXControlComponent);
        }
    }

    public DMXControl_Dimmer getDMXControlDimmer() {
        return this.dMXControl_DimmerMain;
    }

    public DMXControl_RGB getDMXControl_RGB() {
        return this.dmxControl_RGBMain;
    }

    private void addDMXDevice(DMXDevice p_DMXDevice) {
        if (p_DMXDevice == null) {
            return;
        }
        p_DMXDevice.addPropertyChangeListener("dmxdeviceDMXDeviceType", this);
        for (int intDMXControlComponent = 0; intDMXControlComponent < this.m_MainMixerDMXControlComponents.size(); ++intDMXControlComponent) {
            DMXControlComponent o_DMXControlComponent = this.m_MainMixerDMXControlComponents.get(intDMXControlComponent);
            this.addMainLinks(p_DMXDevice, o_DMXControlComponent);
        }
    }

    private void removeDMXDevice(DMXDevice p_DMXDevice) {
        if (p_DMXDevice == null) {
            return;
        }
        p_DMXDevice.removePropertyChangeListener("dmxdeviceDMXDeviceType", this);
        for (int intDMXControlComponent = this.m_MainMixerDMXControlComponents.size() - 1; intDMXControlComponent >= 0; --intDMXControlComponent) {
            DMXControlComponent o_DMXControlComponent = this.m_MainMixerDMXControlComponents.get(intDMXControlComponent);
            this.removeMainLinks(p_DMXDevice, o_DMXControlComponent);
        }
    }

    private void addMainLinks(DMXDevice p_DMXDevice, DMXControlComponent p_DMXControlComponent) {
        if (p_DMXDevice == null || p_DMXControlComponent == null) {
            return;
        }
        DMXDeviceType o_DMXDeviceType = p_DMXDevice.getDMXDeviceType();
        if (o_DMXDeviceType == null) {
            return;
        }
        this.addMainLinks(p_DMXDevice, o_DMXDeviceType, p_DMXControlComponent);
    }

    private void addMainLinks(DMXDevice p_DMXDevice, DMXDeviceType p_DMXDeviceType, DMXControlComponent p_MainDMXControlComponent) {
        if (p_DMXDevice == null || p_DMXDeviceType == null || p_MainDMXControlComponent == null) {
            return;
        }
        int intDMXControlTypeCount = p_DMXDeviceType.getDMXControlTypeCount();
        for (int intDMXControlType = 0; intDMXControlType < intDMXControlTypeCount; ++intDMXControlType) {
            DMXControlComponent.DMXControlType o_DMXControlType = p_DMXDeviceType.getDMXControlType(intDMXControlType);
            if (!o_DMXControlType.getDMXControlDescription().getIsDimmableByMain() || !o_DMXControlType.getDMXControlDescription().getID().equals(p_MainDMXControlComponent.getDMXControlType().getDMXControlDescription().getID()) && (!o_DMXControlType.getIsDimmer() && !o_DMXControlType.getIsDimmerSubstitute() || !p_MainDMXControlComponent.getIsDimmer() && !p_MainDMXControlComponent.getIsDimmerSubstitute())) continue;
            int intControlTypeCount = o_DMXControlType.getControlTypeCount();
            for (int intControlType = 0; intControlType < intControlTypeCount; ++intControlType) {
                DMXControlComponent.ControlType o_ControlType = o_DMXControlType.getControlType(intControlType);
                if (o_ControlType == null) continue;
                int intControlDimensionTypeCount = o_ControlType.getControlDimensionTypeCount();
                for (int intControlDimensionType = 0; intControlDimensionType < intControlDimensionTypeCount; ++intControlDimensionType) {
                    DMXControlComponent.ControlDimensionType o_ControlDimensionType = o_ControlType.getControlDimensionType(intControlDimensionType);
                    if (o_ControlDimensionType == null) continue;
                    for (int intLink = 0; intLink < o_ControlDimensionType.getDeviceControlLinkCount(); ++intLink) {
                        DMXControlComponent.DeviceControlLink o_DeviceControlLink = o_ControlDimensionType.getDeviceControlLink(intLink);
                        if (o_DeviceControlLink == null) continue;
                        int intByteResolution = o_DeviceControlLink.getByteResolution();
                        for (int intByte = 0; intByte < intByteResolution; ++intByte) {
                            double doubleMainValue;
                            ControlObject.ControlDimension o_MainControlDimension;
                            ControlObject o_MainControlObject;
                            DMXControlComponent.DeviceControlLink o_DeviceControlLinkAdded;
                            double doubleMainFactor = 1.0;
                            if (p_MainDMXControlComponent.getIsDimmer()) {
                                o_DeviceControlLinkAdded = p_MainDMXControlComponent.addDMXDeviceControlLink(p_DMXDevice, o_DeviceControlLink.getDMXDeviceSectorIndex(), o_DeviceControlLink.getDeviceInternalChannel(intByte), 0, intControlDimensionType, intByte);
                                o_MainControlObject = p_MainDMXControlComponent.getControlObject(intControlType);
                                if (o_MainControlObject != null && (o_MainControlDimension = o_MainControlObject.getControlDimension(0)) != null) {
                                    doubleMainValue = o_MainControlDimension.getValue();
                                    doubleMainFactor = (doubleMainValue - o_MainControlDimension.getValueMinimum()) / (o_MainControlDimension.getValueMaximum() - o_MainControlDimension.getValueMinimum());
                                }
                            } else {
                                o_DeviceControlLinkAdded = p_MainDMXControlComponent.addDMXDeviceControlLink(p_DMXDevice, o_DeviceControlLink.getDMXDeviceSectorIndex(), o_DeviceControlLink.getDeviceInternalChannel(intByte), intControlType, intControlDimensionType, intByte);
                                p_MainDMXControlComponent.getControlObject(intControlType).getControlDimension(intControlDimensionType).getValue();
                                o_MainControlObject = p_MainDMXControlComponent.getControlObject(intControlType);
                                if (o_MainControlObject != null && (o_MainControlDimension = o_MainControlObject.getControlDimension(0)) != null) {
                                    doubleMainValue = o_MainControlDimension.getValue();
                                    doubleMainFactor = (doubleMainValue - o_MainControlDimension.getValueMinimum()) / (o_MainControlDimension.getValueMaximum() - o_MainControlDimension.getValueMinimum());
                                    if (o_MainControlObject.getInvertedSecondary()) {
                                        doubleMainFactor = 1.0 - doubleMainFactor;
                                    }
                                }
                            }
                            if (o_DeviceControlLinkAdded == null) continue;
                            o_DeviceControlLinkAdded.setIsMainMixerLink(true);
                            o_DeviceControlLinkAdded.setValueByte_Factor(intByte, doubleMainFactor);
                        }
                    }
                }
            }
        }
        p_DMXDevice.refreshValueFactors();
    }

    private void removeMainLinks(DMXDevice p_DMXDevice, DMXControlComponent p_DMXControlComponent) {
        if (p_DMXDevice == null) {
            return;
        }
        if (p_DMXControlComponent == null) {
            return;
        }
        DMXDeviceType o_DMXDeviceType = p_DMXDevice.getDMXDeviceType();
        if (o_DMXDeviceType == null) {
            return;
        }
        this.removeMainLinks(p_DMXDevice, o_DMXDeviceType, p_DMXControlComponent);
    }

    private void removeMainLinks(DMXDevice p_DMXDevice, DMXDeviceType p_DMXDeviceType, DMXControlComponent p_DMXControlComponent) {
        if (p_DMXDevice == null) {
            return;
        }
        if (p_DMXDeviceType == null) {
            return;
        }
        if (p_DMXControlComponent == null) {
            return;
        }
        int intDMXControlTypeCount = p_DMXDeviceType.getDMXControlTypeCount();
        for (int intDMXControlType = 0; intDMXControlType < intDMXControlTypeCount; ++intDMXControlType) {
            DMXControlComponent.DMXControlType o_DMXControlType = p_DMXDeviceType.getDMXControlType(intDMXControlType);
            if (!o_DMXControlType.getDMXControlDescription().getID().equals(p_DMXControlComponent.getDMXControlType().getDMXControlDescription().getID())) continue;
            int intControlTypeCount = o_DMXControlType.getControlTypeCount();
            for (int intControlType = 0; intControlType < intControlTypeCount; ++intControlType) {
                DMXControlComponent.ControlType o_ControlType = o_DMXControlType.getControlType(intControlType);
                if (o_ControlType == null) continue;
                int intControlDimensionTypeCount = o_ControlType.getControlDimensionTypeCount();
                for (int intControlDimensionType = 0; intControlDimensionType < intControlDimensionTypeCount; ++intControlDimensionType) {
                    DMXControlComponent.ControlDimensionType o_ControlDimensionType = o_ControlType.getControlDimensionType(intControlDimensionType);
                    if (o_ControlDimensionType == null) continue;
                    for (int intLink = o_ControlDimensionType.getDeviceControlLinkCount() - 1; intLink >= 0; --intLink) {
                        DMXControlComponent.DeviceControlLink o_DeviceControlLink = o_ControlDimensionType.getDeviceControlLink(intLink);
                        if (o_DeviceControlLink == null) continue;
                        int intByteResolution = o_DeviceControlLink.getByteResolution();
                        for (int intByte = intByteResolution - 1; intByte >= 0; --intByte) {
                            DMXControlComponent.DeviceControlLink o_DeviceControlLinkToRemove = p_DMXControlComponent.getDeviceControlLink(p_DMXDevice, o_DeviceControlLink.getDMXDeviceSectorIndex(), o_DeviceControlLink.getDeviceInternalChannel(intByte), intControlType, intControlDimensionType, intByte);
                            if (o_DeviceControlLinkToRemove == null) continue;
                            o_DeviceControlLinkToRemove.close();
                        }
                    }
                }
            }
        }
    }

    public void changeDMXDevice(DMXDevice p_DMXDevice, DMXDeviceType p_DMXDeviceTypeOld, DMXDeviceType p_DMXDeviceTypeNew) {
        if (p_DMXDevice == null) {
            return;
        }
        for (int intDMXControlComponent = 0; intDMXControlComponent < this.m_MainMixerDMXControlComponents.size(); ++intDMXControlComponent) {
            DMXControlComponent o_DMXControlComponent = this.m_MainMixerDMXControlComponents.get(intDMXControlComponent);
            this.removeMainLinks(p_DMXDevice, p_DMXDeviceTypeOld, o_DMXControlComponent);
            this.addMainLinks(p_DMXDevice, o_DMXControlComponent);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof DMXDevice.TreeModel_Device_Channels) {
            if ("dmxdevicetreemodelDMXDeviceAdded".equals(evt.getPropertyName())) {
                DMXDevice o_DMXDevice = (DMXDevice)evt.getNewValue();
                this.addDMXDevice(o_DMXDevice);
            } else if ("dmxdevicetreemodelDMXDeviceRemoved".equals(evt.getPropertyName())) {
                DMXDevice o_DMXDevice = (DMXDevice)evt.getOldValue();
                this.removeDMXDevice(o_DMXDevice);
            }
        } else if (evt.getSource() instanceof DMXDevice && "dmxdeviceDMXDeviceType".equals(evt.getPropertyName())) {
            this.changeDMXDevice((DMXDevice)evt.getSource(), (DMXDeviceType)evt.getOldValue(), (DMXDeviceType)evt.getNewValue());
        }
    }

    public void createSPITRemote(String p_GroupName) {
        this.dMXControl_DimmerMain.createSPITRemote(SPITID_MAINDMX_DIMMER, p_GroupName, this.dMXMixerPanel_MainMixer.getName(), null);
        this.dmxControl_RGBMain.createSPITRemote(SPITID_MAINDMX_RGB, p_GroupName, this.dMXMixerPanel_MainMixer.getName(), null);
    }
}

