/*
 * Decompiled with CFR 0.152.
 */
package DMXGraphics;

import DMXDevicePackage.DMXDevice;
import DMXDevicePackage.DMXDeviceType;
import DMXGraphics.LiveShowDMXAddressSetting;
import DMXGraphics.LiveShowDMXStageView;
import DMXVirtualPackage.LiveShowDMXObjectDescription;
import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LanguageTools.LiveLanguagePackage.LiveLanguageString;
import StartPackage.LiveShowDMXSystem;
import SwingTextPackage.DocumentFilter_Integer;
import SwingToolTipPackage.PopUpToolTip;
import ToolsGraphics.JLabelBackground;
import ToolsGraphics.JLabel_ResizeFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreePath;

public class LiveShowDMXDeviceTypeSelection
extends JDialog
implements PropertyChangeListener {
    @LiveLanguageString
    public static String CHANNELS = "Channels";
    public static LiveShowDMXDeviceTypeSelection s_SelfReference;
    private DMXDeviceType m_SelectedDeviceType;
    private JButton jButton_Apply;
    private JButton jButton_Cancel;
    private JButton jButton_CountMinus;
    private JButton jButton_CountPlus;
    private JLabel jLabel_DeviceChannelCount;
    private JLabel jLabel_DeviceCount;
    private JLabel jLabel_DeviceDescription;
    private JLabel jLabel_DeviceManufactureer;
    private JLabel jLabel_DeviceName;
    private JLabel jLabel_DeviceType;
    private JLabel jLabel_DeviceTypeSelect;
    private JLabelBackground jLabel_Icon;
    private JLabel_ResizeFrame jLabel_ResizeFrame1;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JTextField jTextField_DeviceCount;
    private JTextField jTextField_DeviceName;
    private JTree jTree_DeviceTypes;
    private LiveShowDMXAddressSetting liveShowDMXAddressSetting1;

    public static LiveShowDMXDeviceTypeSelection getSelfreference() {
        return s_SelfReference;
    }

    public static void closeProject() {
        if (s_SelfReference != null) {
            s_SelfReference.setVisible(false);
        }
    }

    public static void close() {
        if (s_SelfReference != null) {
            LiveShowDMXDeviceTypeSelection.closeProject();
            LiveShowDMXDeviceTypeSelection.s_SelfReference.jLabel_DeviceCount.setComponentPopupMenu(null);
            LiveShowDMXDeviceTypeSelection.s_SelfReference.jTextField_DeviceCount.setComponentPopupMenu(null);
            LiveShowDMXDeviceTypeSelection.s_SelfReference.jButton_CountPlus.setComponentPopupMenu(null);
            LiveShowDMXDeviceTypeSelection.s_SelfReference.jButton_CountMinus.setComponentPopupMenu(null);
            LiveShowDMXDeviceTypeSelection.s_SelfReference.jButton_Apply.setComponentPopupMenu(null);
            LiveShowDMXDeviceTypeSelection.s_SelfReference.jButton_Cancel.setComponentPopupMenu(null);
        }
    }

    public LiveShowDMXDeviceTypeSelection(boolean modal) {
        super((Frame)null, modal);
        s_SelfReference = this;
        this.initComponents();
        this.initComponentsFurther();
        this.initMembers();
        this.liveShowDMXAddressSetting1.addPropertyChangeListener(this);
        LiveLanguage.addLanguageListener((Object)this, null);
    }

    private void initMembers() {
        this.jTree_DeviceTypes.setModel(DMXDeviceType.getTreeModel());
        this.jTree_DeviceTypes.setCellRenderer(DMXDeviceType.getTreeCellRenderer());
        DefaultTreeSelectionModel o_TreeSelectionModel = new DefaultTreeSelectionModel();
        o_TreeSelectionModel.setSelectionMode(1);
        this.jTree_DeviceTypes.setSelectionModel(o_TreeSelectionModel);
        this.setPreferredSize(new Dimension(650, 600));
        this.pack();
    }

    private void initComponentsFurther() {
        this.getContentPane().setBackground(Color.BLACK);
        this.jLabel_ResizeFrame1.setContainer(this);
        this.jLabel_DeviceCount.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jTextField_DeviceCount.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_CountPlus.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_CountMinus.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_Apply.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_Cancel.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jLabel_Icon.setBackgroundStyle(0);
        this.jLabel_Icon.setBackgroundOpaque(false);
        DocumentFilter_Integer o_DocumentFilter_Integer = new DocumentFilter_Integer(this.jTextField_DeviceCount);
        o_DocumentFilter_Integer.setAllowNegativeNumbers(false);
        this.jTextField_DeviceCount.setText("1");
        this.setIconImage(((ImageIcon)DMXDeviceType.s_Icon).getImage());
    }

    public void expandDeviceTypesRoot() {
        DMXDeviceType.DMXDeviceTypeTreeModel o_TreeModel = (DMXDeviceType.DMXDeviceTypeTreeModel)this.jTree_DeviceTypes.getModel();
        if (o_TreeModel == null) {
            return;
        }
        DMXDeviceType.DMXDeviceTypeTreeNode o_Root = (DMXDeviceType.DMXDeviceTypeTreeNode)o_TreeModel.getRoot();
        this.jTree_DeviceTypes.expandPath(o_TreeModel.getTreePathToRoot(o_Root));
    }

    public DMXDeviceType getSelectedDMXDeviceType() {
        return this.m_SelectedDeviceType;
    }

    private void setSelectedDMXDeviceType(DMXDeviceType p_DMXDeviceType) {
        this.m_SelectedDeviceType = p_DMXDeviceType;
        this.refreshGUI();
    }

    private void refreshGUI() {
        int intChannelCountAll = 0;
        if (this.m_SelectedDeviceType != null) {
            this.jLabel_DeviceManufactureer.setText(this.m_SelectedDeviceType.getManufactureerName());
            this.jLabel_DeviceType.setText(this.m_SelectedDeviceType.getTypeName());
            this.jLabel_DeviceDescription.setText(this.m_SelectedDeviceType.getRemark());
            for (int intSector = 0; intSector < this.m_SelectedDeviceType.getDMXDeviceSectorCount(); ++intSector) {
                DMXDeviceType.DMXDeviceSector o_DMXDeviceSector = this.m_SelectedDeviceType.getDMXDeviceSector(intSector);
                intChannelCountAll += o_DMXDeviceSector.getChannelCount();
            }
            this.jLabel_DeviceChannelCount.setText(String.valueOf(intChannelCountAll) + " " + CHANNELS);
            this.jLabel_Icon.setBackgroundImage(this.m_SelectedDeviceType.getDeviceImage());
            this.jLabel_Icon.setBackgroundStyle(3);
            this.jLabel_Icon.setBackgroundOpaque(true);
            this.jButton_Apply.setEnabled(true);
            this.liveShowDMXAddressSetting1.setDMXDeviceSectorCount(this.m_SelectedDeviceType.getDMXDeviceSectorCount());
            this.liveShowDMXAddressSetting1.setSelectedDMXAddressSector(0);
            this.findNextFreeStartAddressAllSectors();
        } else {
            this.jLabel_DeviceManufactureer.setIcon(null);
            this.jLabel_DeviceManufactureer.setText("");
            this.jLabel_DeviceType.setText("");
            this.jLabel_DeviceDescription.setText("");
            this.jLabel_DeviceChannelCount.setText("");
            this.jLabel_Icon.setBackgroundStyle(0);
            this.jLabel_Icon.setBackgroundOpaque(false);
            this.jLabel_Icon.setBackgroundImage(null);
            this.jButton_Apply.setEnabled(false);
            this.jTextField_DeviceCount.setText("1");
            this.liveShowDMXAddressSetting1.setDMXDeviceSectorCount(1);
            this.liveShowDMXAddressSetting1.setSelectedDMXAddressSector(0);
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel_ResizeFrame1 = new JLabel_ResizeFrame();
        this.jScrollPane1 = new JScrollPane();
        this.jTree_DeviceTypes = new JTree();
        this.jLabel_DeviceTypeSelect = new JLabel();
        this.jButton_Apply = new JButton();
        this.jButton_Cancel = new JButton();
        this.jLabel_DeviceManufactureer = new JLabel();
        this.jLabel_DeviceType = new JLabel();
        this.liveShowDMXAddressSetting1 = new LiveShowDMXAddressSetting();
        this.jLabel_DeviceDescription = new JLabel();
        this.jLabel_DeviceName = new JLabel();
        this.jTextField_DeviceName = new JTextField();
        this.jLabel_DeviceChannelCount = new JLabel();
        this.jLabel_Icon = new JLabelBackground();
        this.jLabel_DeviceCount = new JLabel();
        this.jTextField_DeviceCount = new JTextField();
        this.jButton_CountPlus = new JButton();
        this.jButton_CountMinus = new JButton();
        this.setTitle("Add DMXDevice");
        this.setAlwaysOnTop(true);
        this.setIconImage(null);
        this.setMinimumSize(new Dimension(550, 400));
        this.setPreferredSize(new Dimension(550, 500));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent evt) {
                LiveShowDMXDeviceTypeSelection.this.formComponentShown(evt);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent evt) {
                LiveShowDMXDeviceTypeSelection.this.formWindowActivated(evt);
            }

            @Override
            public void windowOpened(WindowEvent evt) {
                LiveShowDMXDeviceTypeSelection.this.formWindowOpened(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.jPanel1.setBorder(BorderFactory.createLineBorder(Color.gray));
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel_ResizeFrame1.setToolTipText("");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 14;
        this.jPanel1.add((Component)this.jLabel_ResizeFrame1, gridBagConstraints);
        this.jScrollPane1.setMaximumSize(null);
        this.jScrollPane1.setMinimumSize(null);
        this.jScrollPane1.setPreferredSize(new Dimension(150, 500));
        this.jTree_DeviceTypes.setRootVisible(false);
        this.jTree_DeviceTypes.setRowHeight(26);
        this.jTree_DeviceTypes.setShowsRootHandles(true);
        this.jTree_DeviceTypes.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                LiveShowDMXDeviceTypeSelection.this.jTree_DeviceTypesValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTree_DeviceTypes);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 9;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jLabel_DeviceTypeSelect.setFont(new Font("Tahoma", 1, 12));
        this.jLabel_DeviceTypeSelect.setHorizontalAlignment(0);
        this.jLabel_DeviceTypeSelect.setText("Select DMXDeviceType");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.jLabel_DeviceTypeSelect, gridBagConstraints);
        this.jButton_Apply.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Edit_Plus.png")));
        this.jButton_Apply.setContentAreaFilled(false);
        this.jButton_Apply.setEnabled(false);
        this.jButton_Apply.setIconTextGap(0);
        this.jButton_Apply.setMargin(new Insets(0, 0, 0, 0));
        this.jButton_Apply.setMaximumSize(new Dimension(32, 32));
        this.jButton_Apply.setMinimumSize(new Dimension(32, 32));
        this.jButton_Apply.setPreferredSize(new Dimension(32, 32));
        this.jButton_Apply.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_Apply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowDMXDeviceTypeSelection.this.jButton_ApplyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.jButton_Apply, gridBagConstraints);
        this.jButton_Cancel.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Edit_Cancel.png")));
        this.jButton_Cancel.setContentAreaFilled(false);
        this.jButton_Cancel.setIconTextGap(0);
        this.jButton_Cancel.setMargin(new Insets(0, 0, 0, 0));
        this.jButton_Cancel.setMaximumSize(new Dimension(32, 32));
        this.jButton_Cancel.setMinimumSize(new Dimension(32, 32));
        this.jButton_Cancel.setPreferredSize(new Dimension(32, 32));
        this.jButton_Cancel.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_Cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowDMXDeviceTypeSelection.this.jButton_CancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.jButton_Cancel, gridBagConstraints);
        this.jLabel_DeviceManufactureer.setBackground(new Color(255, 255, 255));
        this.jLabel_DeviceManufactureer.setFont(new Font("Tahoma", 1, 12));
        this.jLabel_DeviceManufactureer.setHorizontalAlignment(0);
        this.jLabel_DeviceManufactureer.setHorizontalTextPosition(0);
        this.jLabel_DeviceManufactureer.setPreferredSize(new Dimension(100, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.jLabel_DeviceManufactureer, gridBagConstraints);
        this.jLabel_DeviceType.setBackground(new Color(255, 255, 255));
        this.jLabel_DeviceType.setFont(new Font("Tahoma", 1, 12));
        this.jLabel_DeviceType.setHorizontalAlignment(0);
        this.jLabel_DeviceType.setHorizontalTextPosition(0);
        this.jLabel_DeviceType.setPreferredSize(new Dimension(100, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.jLabel_DeviceType, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        this.jPanel1.add((Component)this.liveShowDMXAddressSetting1, gridBagConstraints);
        this.jLabel_DeviceDescription.setHorizontalAlignment(0);
        this.jLabel_DeviceDescription.setPreferredSize(new Dimension(100, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        this.jPanel1.add((Component)this.jLabel_DeviceDescription, gridBagConstraints);
        this.jLabel_DeviceName.setBackground(new Color(0, 0, 0));
        this.jLabel_DeviceName.setText("Device Name:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.jLabel_DeviceName, gridBagConstraints);
        this.jTextField_DeviceName.setHorizontalAlignment(0);
        this.jTextField_DeviceName.setToolTipText("");
        this.jTextField_DeviceName.setMinimumSize(new Dimension(6, 24));
        this.jTextField_DeviceName.setPreferredSize(new Dimension(6, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.jTextField_DeviceName, gridBagConstraints);
        this.jLabel_DeviceChannelCount.setHorizontalAlignment(0);
        this.jLabel_DeviceChannelCount.setHorizontalTextPosition(0);
        this.jLabel_DeviceChannelCount.setPreferredSize(new Dimension(100, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        this.jPanel1.add((Component)this.jLabel_DeviceChannelCount, gridBagConstraints);
        this.jLabel_Icon.setToolTipText("");
        this.jLabel_Icon.setMaximumSize(new Dimension(150, 150));
        this.jLabel_Icon.setMinimumSize(new Dimension(150, 150));
        this.jLabel_Icon.setOpaque(true);
        this.jLabel_Icon.setPreferredSize(new Dimension(150, 150));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 4;
        this.jPanel1.add((Component)this.jLabel_Icon, gridBagConstraints);
        this.jLabel_DeviceCount.setText("Device Count:");
        this.jLabel_DeviceCount.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.jLabel_DeviceCount, gridBagConstraints);
        this.jTextField_DeviceCount.setFont(new Font("Tahoma", 1, 14));
        this.jTextField_DeviceCount.setHorizontalAlignment(0);
        this.jTextField_DeviceCount.setMinimumSize(new Dimension(50, 24));
        this.jTextField_DeviceCount.setPreferredSize(new Dimension(50, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.jTextField_DeviceCount, gridBagConstraints);
        this.jButton_CountPlus.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/DIP_Up.png")));
        this.jButton_CountPlus.setToolTipText("Zoom Plus");
        this.jButton_CountPlus.setMargin(new Insets(0, 0, 0, 0));
        this.jButton_CountPlus.setMaximumSize(new Dimension(24, 24));
        this.jButton_CountPlus.setMinimumSize(new Dimension(24, 24));
        this.jButton_CountPlus.setPreferredSize(new Dimension(24, 24));
        this.jButton_CountPlus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowDMXDeviceTypeSelection.this.jButton_CountPlusActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 10, 3, 3);
        this.jPanel1.add((Component)this.jButton_CountPlus, gridBagConstraints);
        this.jButton_CountMinus.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/DIP_Down.png")));
        this.jButton_CountMinus.setToolTipText("Zoom Minus");
        this.jButton_CountMinus.setMargin(new Insets(0, 0, 0, 0));
        this.jButton_CountMinus.setMaximumSize(new Dimension(24, 24));
        this.jButton_CountMinus.setMinimumSize(new Dimension(24, 24));
        this.jButton_CountMinus.setPreferredSize(new Dimension(24, 24));
        this.jButton_CountMinus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowDMXDeviceTypeSelection.this.jButton_CountMinusActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 10, 3, 3);
        this.jPanel1.add((Component)this.jButton_CountMinus, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.pack();
    }

    private void jTree_DeviceTypesValueChanged(TreeSelectionEvent evt) {
        TreePath o_TreePath = evt.getNewLeadSelectionPath();
        if (o_TreePath == null) {
            this.setSelectedDMXDeviceType(null);
            return;
        }
        Object o_SourceObject = ((DMXDeviceType.DMXDeviceTypeTreeNode)o_TreePath.getLastPathComponent()).getSourceObject();
        if (o_SourceObject instanceof DMXDeviceType) {
            this.setSelectedDMXDeviceType((DMXDeviceType)o_SourceObject);
        } else {
            this.setSelectedDMXDeviceType(null);
        }
    }

    private void jButton_ApplyActionPerformed(ActionEvent evt) {
        DMXDevice o_DMXDevice;
        int intDevice;
        int intDeviceCount;
        if (this.m_SelectedDeviceType == null) {
            return;
        }
        ArrayList<DMXDevice> o_NewDMXDevices = new ArrayList<DMXDevice>();
        try {
            intDeviceCount = Integer.valueOf(this.jTextField_DeviceCount.getText());
        }
        catch (Exception e) {
            intDeviceCount = 1;
        }
        if (intDeviceCount <= 0) {
            intDeviceCount = 1;
            this.jTextField_DeviceCount.setText("1");
        }
        StringBuilder o_StringBuffer = new StringBuilder();
        LiveShowDMXObjectDescription.poolClear();
        for (intDevice = 0; intDevice < intDeviceCount; ++intDevice) {
            o_DMXDevice = new DMXDevice(this.jTextField_DeviceName.getText());
            o_NewDMXDevices.add(o_DMXDevice);
            o_DMXDevice.setDMXDeviceType(this.m_SelectedDeviceType);
            this.liveShowDMXAddressSetting1.setDMXDeviceToDMXAddress(o_DMXDevice);
            LiveShowDMXSystem.getLiveShowDMXStageView().addDMXDevice(o_DMXDevice, intDevice);
            this.liveShowDMXAddressSetting1.checkAddressValid(this.m_SelectedDeviceType);
            for (int intSector = 0; intSector < this.m_SelectedDeviceType.getDMXDeviceSectorCount(); ++intSector) {
                DMXDeviceType.DMXDeviceSector o_DMXDeviceSector = this.m_SelectedDeviceType.getDMXDeviceSector(intSector);
                if (o_DMXDeviceSector == null) continue;
                this.liveShowDMXAddressSetting1.setDMXStartAddressVisible(intSector, this.liveShowDMXAddressSetting1.getDMXStartAddressVisible(intSector) + o_DMXDeviceSector.getChannelCount());
            }
        }
        LiveShowDMXSystem.getLiveShowDMXStageView();
        LiveShowDMXStageView.clearSelectedDMXDevices();
        for (intDevice = 0; intDevice < o_NewDMXDevices.size(); ++intDevice) {
            o_DMXDevice = (DMXDevice)o_NewDMXDevices.get(intDevice);
            LiveShowDMXSystem.getLiveShowDMXStageView().addSelectedDMXDevice(o_DMXDevice);
        }
        this.setVisible(false);
    }

    public void findNextFreeStartAddressAllSectors() {
        int intDMXDeviceCount;
        if (this.m_SelectedDeviceType == null) {
            return;
        }
        try {
            intDMXDeviceCount = Integer.valueOf(this.jTextField_DeviceCount.getText());
        }
        catch (Exception e) {
            intDMXDeviceCount = 1;
        }
        for (int intSector = 0; intSector < this.m_SelectedDeviceType.getDMXDeviceSectorCount(); ++intSector) {
            DMXDeviceType.DMXDeviceSector o_DMXDeviceSector = this.m_SelectedDeviceType.getDMXDeviceSector(intSector);
            if (o_DMXDeviceSector == null) continue;
            int intValidAddress = this.findNextFreeStartAddress(intSector, o_DMXDeviceSector.getChannelCount() * intDMXDeviceCount);
            this.liveShowDMXAddressSetting1.setDMXStartAddressInternal(intSector, intValidAddress);
        }
        this.liveShowDMXAddressSetting1.checkAddressValid(this.m_SelectedDeviceType);
    }

    public int findNextFreeStartAddress(int p_SectorIndex, int p_ChannelCount) {
        if (this.m_SelectedDeviceType == null) {
            return 0;
        }
        if (p_SectorIndex < 0) {
            return 0;
        }
        if (p_SectorIndex >= this.m_SelectedDeviceType.getDMXDeviceSectorCount()) {
            return 0;
        }
        int intValidAddress = this.liveShowDMXAddressSetting1.findNextFreeStartAddress(p_SectorIndex, p_ChannelCount);
        return intValidAddress;
    }

    private void jButton_CancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void formComponentShown(ComponentEvent evt) {
        this.expandDeviceTypesRoot();
        this.jTextField_DeviceCount.setText("1");
        this.refreshGUI();
    }

    private void jButton_CountPlusActionPerformed(ActionEvent evt) {
        int intDMXDeviceCount;
        try {
            intDMXDeviceCount = Integer.valueOf(this.jTextField_DeviceCount.getText());
        }
        catch (Exception e) {
            intDMXDeviceCount = 1;
        }
        this.jTextField_DeviceCount.setText(String.valueOf(++intDMXDeviceCount));
    }

    private void jButton_CountMinusActionPerformed(ActionEvent evt) {
        int intDMXDeviceCount;
        try {
            intDMXDeviceCount = Integer.valueOf(this.jTextField_DeviceCount.getText());
        }
        catch (Exception e) {
            intDMXDeviceCount = 1;
        }
        if (--intDMXDeviceCount < 1) {
            intDMXDeviceCount = 1;
        }
        this.jTextField_DeviceCount.setText(String.valueOf(intDMXDeviceCount));
    }

    private void formWindowOpened(WindowEvent evt) {
        this.jTree_DeviceTypes.requestFocusInWindow();
    }

    private void formWindowActivated(WindowEvent evt) {
        this.jTree_DeviceTypes.requestFocusInWindow();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof LiveShowDMXAddressSetting) {
            int intValidAddress;
            if (LiveShowDMXAddressSetting.PROPERTY_DMXDEVICESECTORINDEX.equals(evt.getPropertyName())) {
                intValidAddress = this.liveShowDMXAddressSetting1.findNextFreeStartAddress(this.m_SelectedDeviceType);
                this.liveShowDMXAddressSetting1.setDMXStartAddressInternal(intValidAddress);
                this.liveShowDMXAddressSetting1.checkAddressValid(this.m_SelectedDeviceType);
            }
            if (LiveShowDMXAddressSetting.PROPERTY_DMXUNIVERSE.equals(evt.getPropertyName())) {
                intValidAddress = this.liveShowDMXAddressSetting1.findNextFreeStartAddress(this.m_SelectedDeviceType);
                this.liveShowDMXAddressSetting1.setDMXStartAddressInternal(intValidAddress);
                this.liveShowDMXAddressSetting1.checkAddressValid(this.m_SelectedDeviceType);
            } else if (LiveShowDMXAddressSetting.PROPERTY_DMXADDRESS.equals(evt.getPropertyName())) {
                this.liveShowDMXAddressSetting1.checkAddressValid(this.m_SelectedDeviceType);
            }
        }
    }
}

