/*
 * Decompiled with CFR 0.152.
 */
package DMXGraphics;

import DMX512.DMXUniverse;
import DMXDevicePackage.DMXDevice;
import DMXDevicePackage.DMXDeviceType;
import DMXHardwarePackage.DMXPowerSource;
import LanguageTools.LiveLanguagePackage.LiveLanguage;
import SwingModelPackage.TableAndListModel;
import SwingTextPackage.DocumentFilter_Integer;
import SynchronizationPackage.EventQueueHandler;
import ToolsGraphics.JLabelBackground;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class LiveShowDMXAddressSetting
extends JPanel
implements InternalFrameListener,
WindowListener,
ListDataListener,
ItemListener {
    public static String PROPERTY_DMXDEVICESECTORINDEX = "dmxDeviceSectorIndex";
    public static String PROPERTY_DMXUNIVERSE = "dmxUniverse";
    public static String PROPERTY_DMXADDRESS = "dmxAddress";
    public static String PROPERTY_DMXPOWERSOURCE = "dmxPowerSource";
    public ArrayList<DMXDevice.SectorAddress> m_DMXAddresseSectors;
    private int m_DMXDeviceSectorIndex;
    private TableAndListModel.ListModelWrapper<DMXUniverse> m_DMXUniverseListModelWrapper;
    private int m_DMXStartAddress;
    private Image m_ImageIcon_DIPOn;
    private Image m_ImageIcon_DIPOff;
    private DMXUniverse m_SelectedDMXUniverse;
    private int m_SelectedSectorIndex;
    private Border m_BorderNormal;
    private Border m_BorderInvalid;
    public ArrayList<DMXPowerSource> m_DMXPowerSources;
    private TableAndListModel.ListModelWrapper<DMXPowerSource> m_DMXPowerSourceListModelWrapper;
    private JButton jButton_Down;
    private JButton jButton_Up;
    private JComboBox jComboBoxDMXPowerSource;
    private JComboBox jComboBox_DMXDeviceSector;
    private JComboBox jComboBox_DMXUniverse;
    private JLabelBackground jLabel_DIP1;
    private JLabelBackground jLabel_DIP10;
    private JLabelBackground jLabel_DIP2;
    private JLabelBackground jLabel_DIP3;
    private JLabelBackground jLabel_DIP4;
    private JLabelBackground jLabel_DIP5;
    private JLabelBackground jLabel_DIP6;
    private JLabelBackground jLabel_DIP7;
    private JLabelBackground jLabel_DIP8;
    private JLabelBackground jLabel_DIP9;
    private JLabel jLabel_DIPText1;
    private JLabel jLabel_DIPText10;
    private JLabel jLabel_DIPText2;
    private JLabel jLabel_DIPText3;
    private JLabel jLabel_DIPText4;
    private JLabel jLabel_DIPText5;
    private JLabel jLabel_DIPText6;
    private JLabel jLabel_DIPText7;
    private JLabel jLabel_DIPText8;
    private JLabel jLabel_DIPText9;
    private JLabel jLabel_DIPTextOff;
    private JLabel jLabel_DIPTextOn;
    private JLabel jLabel_DMXAddress;
    private JLabel jLabel_DMXDeviceSector;
    private JLabel jLabel_DMXUniverse;
    private JPanel jPanel_DIP;
    private JTextField jTextField_DMXAddress;

    public LiveShowDMXAddressSetting() {
        this.initMembers();
        this.initComponents();
        this.initComponentsFurther();
        this.setDMXDeviceSectorCount(1);
        LiveLanguage.addLanguageListener((Object)this, null);
    }

    private void initMembers() {
        this.m_DMXAddresseSectors = new ArrayList();
        this.m_DMXUniverseListModelWrapper = DMXUniverse.getListModel().createListModelWrapper();
        this.m_ImageIcon_DIPOn = new ImageIcon(this.getClass().getResource("/IconsPackage/DIP_On.png")).getImage();
        this.m_ImageIcon_DIPOff = new ImageIcon(this.getClass().getResource("/IconsPackage/DIP_Off.png")).getImage();
        this.m_DMXPowerSources = new ArrayList();
        this.m_DMXPowerSourceListModelWrapper = DMXPowerSource.getListModel().createListModelWrapper();
    }

    public void close() {
        LiveLanguage.removeLanguageListener((Object)this);
        if (this.m_DMXUniverseListModelWrapper != null) {
            this.m_DMXUniverseListModelWrapper.close();
            this.m_DMXUniverseListModelWrapper = null;
        }
        LiveLanguage.removeLanguageListener((Object)this);
    }

    protected void finalize() {
        this.close();
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void initComponents() {
        this.jTextField_DMXAddress = new JTextField();
        this.jLabel_DMXAddress = new JLabel();
        this.jButton_Up = new JButton();
        this.jButton_Down = new JButton();
        this.jPanel_DIP = new JPanel();
        this.jLabel_DIPText1 = new JLabel();
        this.jLabel_DIPText2 = new JLabel();
        this.jLabel_DIPText3 = new JLabel();
        this.jLabel_DIPText4 = new JLabel();
        this.jLabel_DIPText5 = new JLabel();
        this.jLabel_DIPText6 = new JLabel();
        this.jLabel_DIPText7 = new JLabel();
        this.jLabel_DIPText8 = new JLabel();
        this.jLabel_DIPText9 = new JLabel();
        this.jLabel_DIPText10 = new JLabel();
        this.jLabel_DIP1 = new JLabelBackground();
        this.jLabel_DIP2 = new JLabelBackground();
        this.jLabel_DIP3 = new JLabelBackground();
        this.jLabel_DIP4 = new JLabelBackground();
        this.jLabel_DIP5 = new JLabelBackground();
        this.jLabel_DIP6 = new JLabelBackground();
        this.jLabel_DIP7 = new JLabelBackground();
        this.jLabel_DIP8 = new JLabelBackground();
        this.jLabel_DIP9 = new JLabelBackground();
        this.jLabel_DIP10 = new JLabelBackground();
        this.jLabel_DIPTextOff = new JLabel();
        this.jLabel_DIPTextOn = new JLabel();
        this.jLabel_DMXUniverse = new JLabel();
        this.jComboBox_DMXUniverse = new JComboBox();
        this.jLabel_DMXDeviceSector = new JLabel();
        this.jComboBox_DMXDeviceSector = new JComboBox();
        this.jComboBoxDMXPowerSource = new JComboBox();
        this.setBackground(new Color(0, 0, 80));
        this.setMinimumSize(new Dimension(250, 185));
        this.setPreferredSize(new Dimension(250, 185));
        this.setLayout(new GridBagLayout());
        this.jTextField_DMXAddress.setBackground(new Color(0, 0, 0));
        this.jTextField_DMXAddress.setForeground(new Color(255, 255, 255));
        this.jTextField_DMXAddress.setHorizontalAlignment(0);
        this.jTextField_DMXAddress.setText("0");
        this.jTextField_DMXAddress.setToolTipText("change DMXAddress");
        this.jTextField_DMXAddress.setMinimumSize(new Dimension(20, 20));
        this.jTextField_DMXAddress.setPreferredSize(new Dimension(30, 20));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jTextField_DMXAddress, gridBagConstraints);
        this.jLabel_DMXAddress.setForeground(new Color(255, 255, 255));
        this.jLabel_DMXAddress.setText("DMXAddress");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jLabel_DMXAddress, gridBagConstraints);
        this.jButton_Up.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/DIP_Up.png")));
        this.jButton_Up.setToolTipText("increment DMXAddress");
        this.jButton_Up.setMargin(new Insets(2, 2, 2, 2));
        this.jButton_Up.setMaximumSize(new Dimension(20, 20));
        this.jButton_Up.setMinimumSize(new Dimension(20, 20));
        this.jButton_Up.setOpaque(false);
        this.jButton_Up.setPreferredSize(new Dimension(20, 20));
        this.jButton_Up.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowDMXAddressSetting.this.jButton_UpActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jButton_Up, gridBagConstraints);
        this.jButton_Down.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/DIP_Down.png")));
        this.jButton_Down.setToolTipText("decrement DMXAddress");
        this.jButton_Down.setIconTextGap(0);
        this.jButton_Down.setMargin(new Insets(2, 2, 2, 2));
        this.jButton_Down.setMaximumSize(new Dimension(20, 20));
        this.jButton_Down.setMinimumSize(new Dimension(20, 20));
        this.jButton_Down.setPreferredSize(new Dimension(20, 20));
        this.jButton_Down.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowDMXAddressSetting.this.jButton_DownActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jButton_Down, gridBagConstraints);
        this.jPanel_DIP.setForeground(new Color(255, 255, 255));
        this.jPanel_DIP.setOpaque(false);
        this.jPanel_DIP.setLayout(new GridBagLayout());
        this.jLabel_DIPText1.setFont(new Font("Tahoma", 0, 9));
        this.jLabel_DIPText1.setForeground(new Color(255, 255, 255));
        this.jLabel_DIPText1.setHorizontalAlignment(0);
        this.jLabel_DIPText1.setText("<html><center>1<br>1</center></html>");
        this.jLabel_DIPText1.setMinimumSize(new Dimension(14, 22));
        this.jLabel_DIPText1.setPreferredSize(new Dimension(14, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.jPanel_DIP.add((Component)this.jLabel_DIPText1, gridBagConstraints);
        this.jLabel_DIPText2.setFont(new Font("Tahoma", 0, 9));
        this.jLabel_DIPText2.setForeground(new Color(255, 255, 255));
        this.jLabel_DIPText2.setHorizontalAlignment(0);
        this.jLabel_DIPText2.setText("<html><center>2<br>2</center></html>");
        this.jLabel_DIPText2.setMinimumSize(new Dimension(14, 22));
        this.jLabel_DIPText2.setPreferredSize(new Dimension(14, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.jPanel_DIP.add((Component)this.jLabel_DIPText2, gridBagConstraints);
        this.jLabel_DIPText3.setFont(new Font("Tahoma", 0, 9));
        this.jLabel_DIPText3.setForeground(new Color(255, 255, 255));
        this.jLabel_DIPText3.setHorizontalAlignment(0);
        this.jLabel_DIPText3.setText("<html><center>3<br>4</center></html>3");
        this.jLabel_DIPText3.setMinimumSize(new Dimension(14, 22));
        this.jLabel_DIPText3.setPreferredSize(new Dimension(14, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.jPanel_DIP.add((Component)this.jLabel_DIPText3, gridBagConstraints);
        this.jLabel_DIPText4.setFont(new Font("Tahoma", 0, 9));
        this.jLabel_DIPText4.setForeground(new Color(255, 255, 255));
        this.jLabel_DIPText4.setHorizontalAlignment(0);
        this.jLabel_DIPText4.setText("<html><center>4<br>8</center></html>");
        this.jLabel_DIPText4.setMinimumSize(new Dimension(14, 22));
        this.jLabel_DIPText4.setPreferredSize(new Dimension(14, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.jPanel_DIP.add((Component)this.jLabel_DIPText4, gridBagConstraints);
        this.jLabel_DIPText5.setFont(new Font("Tahoma", 0, 9));
        this.jLabel_DIPText5.setForeground(new Color(255, 255, 255));
        this.jLabel_DIPText5.setHorizontalAlignment(0);
        this.jLabel_DIPText5.setText("<html><center>5<br>16</center></html>");
        this.jLabel_DIPText5.setMinimumSize(new Dimension(14, 22));
        this.jLabel_DIPText5.setPreferredSize(new Dimension(14, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.jPanel_DIP.add((Component)this.jLabel_DIPText5, gridBagConstraints);
        this.jLabel_DIPText6.setFont(new Font("Tahoma", 0, 9));
        this.jLabel_DIPText6.setForeground(new Color(255, 255, 255));
        this.jLabel_DIPText6.setHorizontalAlignment(0);
        this.jLabel_DIPText6.setText("<html><center>6<br>32</center></html>");
        this.jLabel_DIPText6.setMinimumSize(new Dimension(14, 22));
        this.jLabel_DIPText6.setPreferredSize(new Dimension(14, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.jPanel_DIP.add((Component)this.jLabel_DIPText6, gridBagConstraints);
        this.jLabel_DIPText7.setFont(new Font("Tahoma", 0, 9));
        this.jLabel_DIPText7.setForeground(new Color(255, 255, 255));
        this.jLabel_DIPText7.setHorizontalAlignment(0);
        this.jLabel_DIPText7.setText("<html><center>7<br>64</center></html>");
        this.jLabel_DIPText7.setMinimumSize(new Dimension(14, 22));
        this.jLabel_DIPText7.setPreferredSize(new Dimension(14, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.jPanel_DIP.add((Component)this.jLabel_DIPText7, gridBagConstraints);
        this.jLabel_DIPText8.setFont(new Font("Tahoma", 0, 9));
        this.jLabel_DIPText8.setForeground(new Color(255, 255, 255));
        this.jLabel_DIPText8.setHorizontalAlignment(0);
        this.jLabel_DIPText8.setText("<html><center>8<br>128</center></html>");
        this.jLabel_DIPText8.setMinimumSize(new Dimension(14, 22));
        this.jLabel_DIPText8.setPreferredSize(new Dimension(14, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.jPanel_DIP.add((Component)this.jLabel_DIPText8, gridBagConstraints);
        this.jLabel_DIPText9.setFont(new Font("Tahoma", 0, 9));
        this.jLabel_DIPText9.setForeground(new Color(255, 255, 255));
        this.jLabel_DIPText9.setHorizontalAlignment(0);
        this.jLabel_DIPText9.setText("<html><center>9<br>256</center></html>");
        this.jLabel_DIPText9.setMinimumSize(new Dimension(14, 22));
        this.jLabel_DIPText9.setPreferredSize(new Dimension(14, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.jPanel_DIP.add((Component)this.jLabel_DIPText9, gridBagConstraints);
        this.jLabel_DIPText10.setFont(new Font("Tahoma", 0, 9));
        this.jLabel_DIPText10.setForeground(new Color(255, 255, 255));
        this.jLabel_DIPText10.setHorizontalAlignment(0);
        this.jLabel_DIPText10.setText("<html><center>10<br>512</center></html>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.jPanel_DIP.add((Component)this.jLabel_DIPText10, gridBagConstraints);
        this.jLabel_DIP1.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jLabel_DIP1.setBackgroundOpaque(true);
        this.jLabel_DIP1.setBackgroundStyle(2);
        this.jLabel_DIP1.setPreferredSize(new Dimension(14, 10));
        this.jLabel_DIP1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                LiveShowDMXAddressSetting.this.jLabel_DIP1MouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.jPanel_DIP.add((Component)this.jLabel_DIP1, gridBagConstraints);
        this.jLabel_DIP2.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jLabel_DIP2.setBackgroundOpaque(true);
        this.jLabel_DIP2.setBackgroundStyle(2);
        this.jLabel_DIP2.setPreferredSize(new Dimension(14, 10));
        this.jLabel_DIP2.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                LiveShowDMXAddressSetting.this.jLabel_DIP2MouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.jPanel_DIP.add((Component)this.jLabel_DIP2, gridBagConstraints);
        this.jLabel_DIP3.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jLabel_DIP3.setBackgroundOpaque(true);
        this.jLabel_DIP3.setBackgroundStyle(2);
        this.jLabel_DIP3.setPreferredSize(new Dimension(14, 10));
        this.jLabel_DIP3.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                LiveShowDMXAddressSetting.this.jLabel_DIP3MouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.jPanel_DIP.add((Component)this.jLabel_DIP3, gridBagConstraints);
        this.jLabel_DIP4.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jLabel_DIP4.setBackgroundOpaque(true);
        this.jLabel_DIP4.setBackgroundStyle(2);
        this.jLabel_DIP4.setPreferredSize(new Dimension(14, 10));
        this.jLabel_DIP4.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                LiveShowDMXAddressSetting.this.jLabel_DIP4MouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.jPanel_DIP.add((Component)this.jLabel_DIP4, gridBagConstraints);
        this.jLabel_DIP5.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jLabel_DIP5.setBackgroundOpaque(true);
        this.jLabel_DIP5.setBackgroundStyle(2);
        this.jLabel_DIP5.setPreferredSize(new Dimension(14, 10));
        this.jLabel_DIP5.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                LiveShowDMXAddressSetting.this.jLabel_DIP5MouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.jPanel_DIP.add((Component)this.jLabel_DIP5, gridBagConstraints);
        this.jLabel_DIP6.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jLabel_DIP6.setBackgroundOpaque(true);
        this.jLabel_DIP6.setBackgroundStyle(2);
        this.jLabel_DIP6.setPreferredSize(new Dimension(14, 10));
        this.jLabel_DIP6.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                LiveShowDMXAddressSetting.this.jLabel_DIP6MouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.jPanel_DIP.add((Component)this.jLabel_DIP6, gridBagConstraints);
        this.jLabel_DIP7.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jLabel_DIP7.setBackgroundOpaque(true);
        this.jLabel_DIP7.setBackgroundStyle(2);
        this.jLabel_DIP7.setPreferredSize(new Dimension(14, 10));
        this.jLabel_DIP7.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                LiveShowDMXAddressSetting.this.jLabel_DIP7MouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.jPanel_DIP.add((Component)this.jLabel_DIP7, gridBagConstraints);
        this.jLabel_DIP8.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jLabel_DIP8.setBackgroundOpaque(true);
        this.jLabel_DIP8.setBackgroundStyle(2);
        this.jLabel_DIP8.setPreferredSize(new Dimension(14, 10));
        this.jLabel_DIP8.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                LiveShowDMXAddressSetting.this.jLabel_DIP8MouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.jPanel_DIP.add((Component)this.jLabel_DIP8, gridBagConstraints);
        this.jLabel_DIP9.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jLabel_DIP9.setBackgroundImageFile("<Not Set>");
        this.jLabel_DIP9.setBackgroundOpaque(true);
        this.jLabel_DIP9.setBackgroundStyle(2);
        this.jLabel_DIP9.setPreferredSize(new Dimension(14, 10));
        this.jLabel_DIP9.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                LiveShowDMXAddressSetting.this.jLabel_DIP9MouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.jPanel_DIP.add((Component)this.jLabel_DIP9, gridBagConstraints);
        this.jLabel_DIP10.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jLabel_DIP10.setBackgroundImageFile("<Not Set>");
        this.jLabel_DIP10.setBackgroundOpaque(true);
        this.jLabel_DIP10.setBackgroundStyle(2);
        this.jLabel_DIP10.setPreferredSize(new Dimension(14, 10));
        this.jLabel_DIP10.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                LiveShowDMXAddressSetting.this.jLabel_DIP10MouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.jPanel_DIP.add((Component)this.jLabel_DIP10, gridBagConstraints);
        this.jLabel_DIPTextOff.setFont(new Font("Tahoma", 0, 9));
        this.jLabel_DIPTextOff.setForeground(new Color(255, 255, 255));
        this.jLabel_DIPTextOff.setHorizontalAlignment(0);
        this.jLabel_DIPTextOff.setText("<html><center>off</center></html>");
        this.jLabel_DIPTextOff.setMinimumSize(new Dimension(14, 22));
        this.jLabel_DIPTextOff.setPreferredSize(new Dimension(14, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.jPanel_DIP.add((Component)this.jLabel_DIPTextOff, gridBagConstraints);
        this.jLabel_DIPTextOn.setFont(new Font("Tahoma", 0, 9));
        this.jLabel_DIPTextOn.setForeground(new Color(255, 255, 255));
        this.jLabel_DIPTextOn.setHorizontalAlignment(0);
        this.jLabel_DIPTextOn.setText("<html><center>on</center></html>");
        this.jLabel_DIPTextOn.setMinimumSize(new Dimension(14, 22));
        this.jLabel_DIPTextOn.setPreferredSize(new Dimension(14, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.jPanel_DIP.add((Component)this.jLabel_DIPTextOn, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jPanel_DIP, gridBagConstraints);
        this.jLabel_DMXUniverse.setForeground(new Color(255, 255, 255));
        this.jLabel_DMXUniverse.setText("DMXUniverse");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jLabel_DMXUniverse, gridBagConstraints);
        this.jComboBox_DMXUniverse.setMaximumRowCount(12);
        this.jComboBox_DMXUniverse.setMinimumSize(new Dimension(51, 28));
        this.jComboBox_DMXUniverse.setPreferredSize(new Dimension(51, 28));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jComboBox_DMXUniverse, gridBagConstraints);
        this.jLabel_DMXDeviceSector.setForeground(new Color(255, 255, 255));
        this.jLabel_DMXDeviceSector.setText("DMX input");
        this.jLabel_DMXDeviceSector.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jLabel_DMXDeviceSector, gridBagConstraints);
        this.jComboBox_DMXDeviceSector.setMaximumRowCount(12);
        this.jComboBox_DMXDeviceSector.setMinimumSize(new Dimension(51, 28));
        this.jComboBox_DMXDeviceSector.setPreferredSize(new Dimension(51, 28));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jComboBox_DMXDeviceSector, gridBagConstraints);
        this.jComboBoxDMXPowerSource.setMinimumSize(new Dimension(51, 28));
        this.jComboBoxDMXPowerSource.setPreferredSize(new Dimension(51, 28));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jComboBoxDMXPowerSource, gridBagConstraints);
    }

    private void jButton_UpActionPerformed(ActionEvent evt) {
        this.setDMXStartAddressVisible(this.m_DMXStartAddress + 1);
    }

    private void jButton_DownActionPerformed(ActionEvent evt) {
        this.setDMXStartAddressVisible(this.m_DMXStartAddress - 1);
    }

    private void jLabel_DIP1MouseClicked(MouseEvent evt) {
        if ((this.m_DMXStartAddress & 1) > 0) {
            this.setDMXStartAddressVisible(this.m_DMXStartAddress - 1);
        } else {
            this.setDMXStartAddressVisible(this.m_DMXStartAddress + 1);
        }
    }

    private void jLabel_DIP2MouseClicked(MouseEvent evt) {
        if ((this.m_DMXStartAddress & 2) > 0) {
            this.setDMXStartAddressVisible(this.m_DMXStartAddress - 2);
        } else {
            this.setDMXStartAddressVisible(this.m_DMXStartAddress + 2);
        }
    }

    private void jLabel_DIP3MouseClicked(MouseEvent evt) {
        if ((this.m_DMXStartAddress & 4) > 0) {
            this.setDMXStartAddressVisible(this.m_DMXStartAddress - 4);
        } else {
            this.setDMXStartAddressVisible(this.m_DMXStartAddress + 4);
        }
    }

    private void jLabel_DIP4MouseClicked(MouseEvent evt) {
        if ((this.m_DMXStartAddress & 8) > 0) {
            this.setDMXStartAddressVisible(this.m_DMXStartAddress - 8);
        } else {
            this.setDMXStartAddressVisible(this.m_DMXStartAddress + 8);
        }
    }

    private void jLabel_DIP5MouseClicked(MouseEvent evt) {
        if ((this.m_DMXStartAddress & 0x10) > 0) {
            this.setDMXStartAddressVisible(this.m_DMXStartAddress - 16);
        } else {
            this.setDMXStartAddressVisible(this.m_DMXStartAddress + 16);
        }
    }

    private void jLabel_DIP6MouseClicked(MouseEvent evt) {
        if ((this.m_DMXStartAddress & 0x20) > 0) {
            this.setDMXStartAddressVisible(this.m_DMXStartAddress - 32);
        } else {
            this.setDMXStartAddressVisible(this.m_DMXStartAddress + 32);
        }
    }

    private void jLabel_DIP7MouseClicked(MouseEvent evt) {
        if ((this.m_DMXStartAddress & 0x40) > 0) {
            this.setDMXStartAddressVisible(this.m_DMXStartAddress - 64);
        } else {
            this.setDMXStartAddressVisible(this.m_DMXStartAddress + 64);
        }
    }

    private void jLabel_DIP8MouseClicked(MouseEvent evt) {
        if ((this.m_DMXStartAddress & 0x80) > 0) {
            this.setDMXStartAddressVisible(this.m_DMXStartAddress - 128);
        } else {
            this.setDMXStartAddressVisible(this.m_DMXStartAddress + 128);
        }
    }

    private void jLabel_DIP9MouseClicked(MouseEvent evt) {
        if ((this.m_DMXStartAddress & 0x100) > 0) {
            this.setDMXStartAddressVisible(this.m_DMXStartAddress - 256);
        } else {
            this.setDMXStartAddressVisible(this.m_DMXStartAddress + 256);
        }
    }

    private void jLabel_DIP10MouseClicked(MouseEvent evt) {
        if ((this.m_DMXStartAddress & 0x200) > 0) {
            this.setDMXStartAddressVisible(this.m_DMXStartAddress - 512);
        } else {
            this.setDMXStartAddressVisible(this.m_DMXStartAddress + 512);
        }
    }

    private void initComponentsFurther() {
        this.m_BorderNormal = new EmptyBorder(2, 2, 2, 2);
        this.m_BorderInvalid = new LineBorder(Color.RED, 2);
        final Runnable o_Runnable_Change = new Runnable(){

            @Override
            public void run() {
                try {
                    if (LiveShowDMXAddressSetting.this.jTextField_DMXAddress.getText().length() <= 0) {
                        return;
                    }
                    LiveShowDMXAddressSetting.this.setDMXStartAddressVisible(Integer.valueOf(LiveShowDMXAddressSetting.this.jTextField_DMXAddress.getText()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        DocumentFilter_Integer o_DocumentFilter_Integer = new DocumentFilter_Integer(this.jTextField_DMXAddress);
        this.jTextField_DMXAddress.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                try {
                    this.change(e.getDocument().getText(0, e.getDocument().getLength() - 1));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                try {
                    if (e.getDocument().getLength() <= 0) {
                        return;
                    }
                    this.change(e.getDocument().getText(0, e.getDocument().getLength() - 1));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                try {
                    this.change(e.getDocument().getText(0, e.getDocument().getLength() - 1));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            private void change(String p_String) {
                EventQueueHandler.invokeLater(o_Runnable_Change);
            }
        });
        this.jComboBox_DMXUniverse.setModel(this.m_DMXUniverseListModelWrapper);
        this.jComboBox_DMXUniverse.setRenderer(DMXUniverse.getCellRenderer());
        this.jComboBox_DMXUniverse.addItemListener(this);
        this.jComboBox_DMXDeviceSector.setRenderer(new DMXDeviceSectorRenderer());
        this.jComboBox_DMXDeviceSector.addItemListener(this);
        this.jComboBox_DMXDeviceSector.removeAllItems();
        this.jComboBoxDMXPowerSource.setModel(this.m_DMXPowerSourceListModelWrapper);
        this.jComboBoxDMXPowerSource.setRenderer(DMXPowerSource.getListCellRenderer());
        this.jComboBoxDMXPowerSource.addItemListener(this);
        if (this.m_DMXPowerSourceListModelWrapper.getSize() > 0) {
            this.jComboBoxDMXPowerSource.setSelectedIndex(0);
        }
    }

    public void setDMXDeviceSectorCount(int p_DMXDeviceSectorCount) {
        block3: {
            block2: {
                if (p_DMXDeviceSectorCount <= this.m_DMXAddresseSectors.size()) break block2;
                for (int intSector = this.m_DMXAddresseSectors.size(); intSector < p_DMXDeviceSectorCount; ++intSector) {
                    DMXDevice.SectorAddress o_SectorDMXAddress = new DMXDevice.SectorAddress(intSector);
                    this.m_DMXAddresseSectors.add(o_SectorDMXAddress);
                    this.jComboBox_DMXDeviceSector.addItem(DMXDeviceType.SECTORNAME + " " + (intSector + 1));
                    this.m_DMXPowerSources.add(null);
                }
                break block3;
            }
            if (p_DMXDeviceSectorCount >= this.m_DMXAddresseSectors.size()) break block3;
            for (int intSector = this.m_DMXAddresseSectors.size() - 1; intSector >= p_DMXDeviceSectorCount; --intSector) {
                DMXDevice.SectorAddress o_SectorDMXAddress = this.m_DMXAddresseSectors.get(intSector);
                this.m_DMXAddresseSectors.remove(o_SectorDMXAddress);
                this.jComboBox_DMXDeviceSector.removeItemAt(intSector);
                o_SectorDMXAddress.clear();
                this.m_DMXPowerSources.remove(intSector);
            }
        }
    }

    public int getDMXDeviceSectorCount() {
        return this.m_DMXAddresseSectors.size();
    }

    public void setDMXAddressSectors(DMXDevice p_DMXDevice) {
        if (p_DMXDevice == null) {
            this.setDMXDeviceSectorCount(1);
        } else {
            this.setDMXDeviceSectorCount(p_DMXDevice.getInternalSectorCount());
        }
        for (int intSector = 0; intSector < this.m_DMXAddresseSectors.size(); ++intSector) {
            DMXDevice.SectorAddress o_DMXAddressSector = this.m_DMXAddresseSectors.get(intSector);
            if (p_DMXDevice == null) {
                o_DMXAddressSector.setDMXUniverse(null);
                o_DMXAddressSector.setDMXStartAddress(0);
                this.m_DMXPowerSources.set(intSector, null);
                continue;
            }
            DMXDevice.InternalSector o_InternalSector = p_DMXDevice.getInternalSector(intSector);
            o_DMXAddressSector.setDMXUniverse(o_InternalSector.getDMXUniverse());
            o_DMXAddressSector.setDMXStartAddress(o_InternalSector.getDMXStartAddress());
            this.m_DMXPowerSources.set(intSector, o_InternalSector.getDMXPowerSource());
        }
        if (this.m_SelectedSectorIndex < 0 || this.m_SelectedSectorIndex >= this.m_DMXAddresseSectors.size()) {
            this.setSelectedDMXAddressSector(0);
        } else {
            this.setSelectedDMXAddressSector(this.m_SelectedSectorIndex);
        }
    }

    public void setDMXDeviceToDMXAddress(DMXDevice p_DMXDevice) {
        if (p_DMXDevice == null) {
            return;
        }
        for (int intSector = 0; intSector < this.m_DMXAddresseSectors.size(); ++intSector) {
            DMXDevice.SectorAddress o_SectorAddress;
            DMXDevice.InternalSector o_DMXDeviceInternalSector = p_DMXDevice.getInternalSector(intSector);
            if (o_DMXDeviceInternalSector == null || (o_SectorAddress = this.m_DMXAddresseSectors.get(intSector)) == null) continue;
            o_DMXDeviceInternalSector.setDMXAddress(o_SectorAddress.getDMXUniverse(), o_SectorAddress.getDMXStartAddress());
            o_DMXDeviceInternalSector.setDMXPowerSource(this.m_DMXPowerSources.get(intSector));
        }
    }

    public void setSelectedDMXAddressSector(int p_SelectionIndex) {
        if (p_SelectionIndex < 0) {
            return;
        }
        if (p_SelectionIndex >= this.m_DMXAddresseSectors.size()) {
            return;
        }
        if (this.jComboBox_DMXDeviceSector.getSelectedIndex() != p_SelectionIndex) {
            this.jComboBox_DMXDeviceSector.setSelectedIndex(p_SelectionIndex);
        }
        this.m_SelectedSectorIndex = p_SelectionIndex;
        this.refreshSelectedDMXAddressSector();
    }

    public DMXDevice.SectorAddress getSelectedDMXAddressSector() {
        if (this.m_SelectedSectorIndex < 0 || this.m_SelectedSectorIndex >= this.m_DMXAddresseSectors.size()) {
            return null;
        }
        return this.m_DMXAddresseSectors.get(this.m_SelectedSectorIndex);
    }

    public DMXPowerSource getSelectedDMXPowerSource() {
        if (this.m_SelectedSectorIndex < 0 || this.m_SelectedSectorIndex >= this.m_DMXPowerSources.size()) {
            return null;
        }
        return this.m_DMXPowerSources.get(this.m_SelectedSectorIndex);
    }

    public void setSelectedDMXPowerSource(DMXPowerSource p_DMXPowerSource) {
        if (this.m_SelectedSectorIndex < 0 || this.m_SelectedSectorIndex >= this.m_DMXPowerSources.size()) {
            return;
        }
        this.m_DMXPowerSources.set(this.m_SelectedSectorIndex, p_DMXPowerSource);
    }

    public void refreshSelectedDMXAddressSector() {
        DMXDevice.SectorAddress o_DMXAddressSector = this.getSelectedDMXAddressSector();
        if (o_DMXAddressSector == null) {
            this.setSelectedDMXUniverse(null);
            this.setDMXStartAddressVisible(1);
            this.jComboBoxDMXPowerSource.setSelectedItem(null);
        } else {
            this.setSelectedDMXUniverse(o_DMXAddressSector.getDMXUniverse());
            this.setDMXStartAddressVisible(o_DMXAddressSector.getDMXStartAddressVisible());
            this.jComboBoxDMXPowerSource.setSelectedItem(this.getSelectedDMXPowerSource());
        }
    }

    private void refreshUI() {
    }

    public int getDMXStartAddressVisible() {
        return this.m_DMXStartAddress;
    }

    public void setDMXStartAddressVisible(int p_DMXStartAddress) {
        if (p_DMXStartAddress < 1) {
            p_DMXStartAddress = 1;
        } else if (p_DMXStartAddress > 512) {
            p_DMXStartAddress = 512;
        }
        DMXDevice.SectorAddress o_DMXAddressSector = this.getSelectedDMXAddressSector();
        if (o_DMXAddressSector != null) {
            if (o_DMXAddressSector.getDMXStartAddressVisible() == p_DMXStartAddress) {
                // empty if block
            }
            int oldValue = o_DMXAddressSector.getDMXStartAddressVisible();
            o_DMXAddressSector.setDMXStartAddressVisible(p_DMXStartAddress);
            this.m_DMXStartAddress = o_DMXAddressSector.getDMXStartAddressVisible();
            String stringAddress = String.valueOf(this.m_DMXStartAddress);
            if (!stringAddress.equals(this.jTextField_DMXAddress.getText())) {
                this.jTextField_DMXAddress.setText(stringAddress);
            }
            this.refreshLabelsDIP();
            this.firePropertyChange(PROPERTY_DMXADDRESS, oldValue, this.m_DMXStartAddress);
        } else {
            this.m_DMXStartAddress = 1;
            this.jTextField_DMXAddress.setText(String.valueOf(this.m_DMXStartAddress));
            this.refreshLabelsDIP();
        }
    }

    public void setDMXStartAddressVisible(int p_SectorIndex, int p_DMXStartAddress) {
        if (p_SectorIndex < 0 || p_SectorIndex >= this.m_DMXAddresseSectors.size()) {
            return;
        }
        if (p_DMXStartAddress < 1) {
            p_DMXStartAddress = 1;
        } else if (p_DMXStartAddress > 512) {
            p_DMXStartAddress = 512;
        }
        DMXDevice.SectorAddress o_DMXAddressSector = this.m_DMXAddresseSectors.get(p_SectorIndex);
        if (o_DMXAddressSector != null) {
            if (o_DMXAddressSector.getDMXStartAddressVisible() == p_DMXStartAddress) {
                // empty if block
            }
            int oldValue = o_DMXAddressSector.getDMXStartAddressVisible();
            if (this.m_SelectedSectorIndex == p_SectorIndex) {
                this.setDMXStartAddressVisible(p_DMXStartAddress);
            } else {
                o_DMXAddressSector.setDMXStartAddressVisible(p_DMXStartAddress);
            }
        }
    }

    public int getDMXStartAddressVisible(int p_SectorIndex) {
        if (p_SectorIndex < 0) {
            return 0;
        }
        if (p_SectorIndex >= this.m_DMXAddresseSectors.size()) {
            return 0;
        }
        DMXDevice.SectorAddress o_SectorAddress = this.m_DMXAddresseSectors.get(p_SectorIndex);
        if (o_SectorAddress == null) {
            return 0;
        }
        return o_SectorAddress.getDMXStartAddressVisible();
    }

    public void setDMXStartAddressInternal(int p_DMXStartAddress) {
        this.setDMXStartAddressVisible(p_DMXStartAddress + 1);
    }

    public void setDMXStartAddressInternal(int p_SectorIndex, int p_DMXStartAddress) {
        this.setDMXStartAddressVisible(p_SectorIndex, p_DMXStartAddress + 1);
    }

    public int getDMXStartAddressInternal() {
        return this.m_DMXStartAddress - 1;
    }

    public int getDMXStartAddressInternal(int p_SectorIndex) {
        return this.getDMXStartAddressVisible(p_SectorIndex) - 1;
    }

    public boolean checkAddressValid(DMXDevice p_DMXDevice) {
        boolean boolAddressValid = true;
        DMXDevice.SectorAddress o_DMXAddressSector = this.getSelectedDMXAddressSector();
        boolAddressValid = o_DMXAddressSector == null ? false : (o_DMXAddressSector.getDMXUniverse() == null ? false : o_DMXAddressSector.getDMXUniverse().checkAddressValid(p_DMXDevice.getInternalSector(o_DMXAddressSector.getDMXDeviceSectorIndex()), o_DMXAddressSector.getDMXStartAddress()));
        if (boolAddressValid) {
            this.jTextField_DMXAddress.setForeground(Color.WHITE);
            super.setBorder(this.m_BorderNormal);
            return true;
        }
        this.jTextField_DMXAddress.setForeground(Color.RED);
        super.setBorder(this.m_BorderInvalid);
        return false;
    }

    public boolean checkAddressValid(DMXDeviceType p_DMXDeviceType) {
        boolean boolAddressValid = true;
        DMXDevice.SectorAddress o_DMXAddressSector = this.getSelectedDMXAddressSector();
        boolAddressValid = o_DMXAddressSector == null ? false : (o_DMXAddressSector.getDMXUniverse() == null ? false : o_DMXAddressSector.getDMXUniverse().checkAddressValid(p_DMXDeviceType, o_DMXAddressSector.getDMXDeviceSectorIndex(), o_DMXAddressSector.getDMXStartAddress()));
        if (boolAddressValid) {
            this.jTextField_DMXAddress.setForeground(Color.WHITE);
            super.setBorder(this.m_BorderNormal);
            return true;
        }
        this.jTextField_DMXAddress.setForeground(Color.RED);
        super.setBorder(this.m_BorderInvalid);
        return false;
    }

    public int findNextFreeStartAddress(DMXDeviceType p_DMXDeviceType) {
        if (p_DMXDeviceType == null) {
            return 0;
        }
        DMXDevice.SectorAddress o_DMXAddressSector = this.getSelectedDMXAddressSector();
        if (o_DMXAddressSector == null) {
            return 0;
        }
        if (o_DMXAddressSector.getDMXUniverse() == null) {
            return 0;
        }
        return o_DMXAddressSector.getDMXUniverse().findAddressValid(p_DMXDeviceType, o_DMXAddressSector.getDMXDeviceSectorIndex());
    }

    public int findNextFreeStartAddress(int p_SectorIndex, int p_ChannelsNeeded) {
        if (p_SectorIndex < 0) {
            return 0;
        }
        if (p_ChannelsNeeded <= 0) {
            return 0;
        }
        if (p_SectorIndex >= this.m_DMXAddresseSectors.size()) {
            return 0;
        }
        DMXDevice.SectorAddress o_DMXAddressSector = this.m_DMXAddresseSectors.get(p_SectorIndex);
        if (o_DMXAddressSector == null) {
            return 0;
        }
        if (o_DMXAddressSector.getDMXUniverse() == null) {
            return 0;
        }
        return o_DMXAddressSector.getDMXUniverse().findAddressValid(p_ChannelsNeeded);
    }

    public DMXUniverse getSelectedDMXUniverse() {
        DMXUniverse o_DMXUniverse = (DMXUniverse)this.jComboBox_DMXUniverse.getSelectedItem();
        return o_DMXUniverse;
    }

    public void setSelectedDMXUniverse(DMXUniverse p_DMXUniverse) {
        DMXDevice.SectorAddress o_DMXAddressSector = this.getSelectedDMXAddressSector();
        if (o_DMXAddressSector != null) {
            if (this.jComboBox_DMXUniverse.getSelectedItem() != p_DMXUniverse) {
                this.jComboBox_DMXUniverse.setSelectedItem(p_DMXUniverse);
            }
            if (o_DMXAddressSector.getDMXUniverse() == p_DMXUniverse) {
                return;
            }
            o_DMXAddressSector.setDMXUniverse(p_DMXUniverse);
        } else {
            this.jComboBox_DMXUniverse.setSelectedIndex(0);
        }
    }

    private void refreshLabelsDIP() {
        if ((this.m_DMXStartAddress & 1) > 0) {
            this.jLabel_DIP1.setBackgroundImage(this.m_ImageIcon_DIPOn);
        } else {
            this.jLabel_DIP1.setBackgroundImage(this.m_ImageIcon_DIPOff);
        }
        if ((this.m_DMXStartAddress & 2) > 0) {
            this.jLabel_DIP2.setBackgroundImage(this.m_ImageIcon_DIPOn);
        } else {
            this.jLabel_DIP2.setBackgroundImage(this.m_ImageIcon_DIPOff);
        }
        if ((this.m_DMXStartAddress & 4) > 0) {
            this.jLabel_DIP3.setBackgroundImage(this.m_ImageIcon_DIPOn);
        } else {
            this.jLabel_DIP3.setBackgroundImage(this.m_ImageIcon_DIPOff);
        }
        if ((this.m_DMXStartAddress & 8) > 0) {
            this.jLabel_DIP4.setBackgroundImage(this.m_ImageIcon_DIPOn);
        } else {
            this.jLabel_DIP4.setBackgroundImage(this.m_ImageIcon_DIPOff);
        }
        if ((this.m_DMXStartAddress & 0x10) > 0) {
            this.jLabel_DIP5.setBackgroundImage(this.m_ImageIcon_DIPOn);
        } else {
            this.jLabel_DIP5.setBackgroundImage(this.m_ImageIcon_DIPOff);
        }
        if ((this.m_DMXStartAddress & 0x20) > 0) {
            this.jLabel_DIP6.setBackgroundImage(this.m_ImageIcon_DIPOn);
        } else {
            this.jLabel_DIP6.setBackgroundImage(this.m_ImageIcon_DIPOff);
        }
        if ((this.m_DMXStartAddress & 0x40) > 0) {
            this.jLabel_DIP7.setBackgroundImage(this.m_ImageIcon_DIPOn);
        } else {
            this.jLabel_DIP7.setBackgroundImage(this.m_ImageIcon_DIPOff);
        }
        if ((this.m_DMXStartAddress & 0x80) > 0) {
            this.jLabel_DIP8.setBackgroundImage(this.m_ImageIcon_DIPOn);
        } else {
            this.jLabel_DIP8.setBackgroundImage(this.m_ImageIcon_DIPOff);
        }
        if ((this.m_DMXStartAddress & 0x100) > 0) {
            this.jLabel_DIP9.setBackgroundImage(this.m_ImageIcon_DIPOn);
        } else {
            this.jLabel_DIP9.setBackgroundImage(this.m_ImageIcon_DIPOff);
        }
        if ((this.m_DMXStartAddress & 0x200) > 0) {
            this.jLabel_DIP10.setBackgroundImage(this.m_ImageIcon_DIPOn);
        } else {
            this.jLabel_DIP10.setBackgroundImage(this.m_ImageIcon_DIPOff);
        }
    }

    @Override
    public void internalFrameOpened(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameClosing(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameClosed(InternalFrameEvent e) {
        this.close();
        e.getInternalFrame().removeInternalFrameListener(this);
    }

    @Override
    public void internalFrameIconified(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameDeiconified(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameActivated(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameDeactivated(InternalFrameEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
        this.close();
        e.getWindow().removeWindowListener(this);
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.jComboBox_DMXDeviceSector) {
            int intOldValue = this.m_SelectedSectorIndex;
            Integer o_SectorIndex = this.jComboBox_DMXDeviceSector.getSelectedIndex();
            if (o_SectorIndex < 0) {
                return;
            }
            this.setSelectedDMXAddressSector(o_SectorIndex);
            this.firePropertyChange(PROPERTY_DMXDEVICESECTORINDEX, intOldValue, this.m_SelectedSectorIndex);
        } else if (e.getSource() == this.jComboBox_DMXUniverse) {
            DMXUniverse oldValue = this.m_SelectedDMXUniverse;
            this.setSelectedDMXUniverse((DMXUniverse)this.jComboBox_DMXUniverse.getSelectedItem());
            this.firePropertyChange(PROPERTY_DMXUNIVERSE, oldValue, this.m_SelectedDMXUniverse);
        } else if (e.getSource() == this.jComboBoxDMXPowerSource) {
            DMXPowerSource oldValue = this.getSelectedDMXPowerSource();
            DMXPowerSource o_DMXPowerSource = (DMXPowerSource)this.jComboBoxDMXPowerSource.getSelectedItem();
            this.setSelectedDMXPowerSource(o_DMXPowerSource);
            this.firePropertyChange(PROPERTY_DMXPOWERSOURCE, oldValue, o_DMXPowerSource);
        }
    }

    public static class DMXDeviceSectorRenderer
    extends DefaultListCellRenderer {
        protected static final Border SAFE_NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);
        protected static final Border DEFAULT_NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);
        protected static final Border SELECTED_BORDER = new LineBorder(Color.BLUE, 2, true);
        protected static Dimension s_PreferredDimension_NULL = new Dimension(0, 0);
        protected Dimension m_PreferredDimension;
        protected boolean m_ShowNUll;
        protected JLabelBackground m_JLabel = new JLabelBackground();

        public DMXDeviceSectorRenderer() {
            this.m_JLabel.setBackgroundStyle(1);
            this.m_JLabel.setBackgroundGradientColorFrom(Color.BLACK);
            this.m_JLabel.setBackgroundGradientColorTo(Color.BLACK);
            this.m_JLabel.setForeground(Color.WHITE);
            this.m_JLabel.setOpaque(true);
            this.m_JLabel.setBackgroundOpaque(true);
            this.m_ShowNUll = false;
            this.m_PreferredDimension = new Dimension(20, 25);
            this.m_JLabel.setPreferredSize(this.m_PreferredDimension);
            this.m_JLabel.setHorizontalAlignment(0);
        }

        public void setShowNULL(boolean p_ShowNull) {
            this.m_ShowNUll = p_ShowNull;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.m_JLabel.setComponentOrientation(list.getComponentOrientation());
            Color o_Background = null;
            Color o_Foreground = null;
            o_Background = list.getBackground();
            o_Foreground = list.getForeground();
            if (isSelected) {
                if (list.hasFocus()) {
                    o_Background = UIManager.getColor("List.selectionBackground");
                    o_Foreground = UIManager.getColor("List.selectionForeground");
                } else {
                    o_Background = UIManager.getColor("List.selectionInactiveBackground");
                    o_Foreground = UIManager.getColor("List.selectionInactiveForeground");
                }
            }
            this.m_JLabel.setForeground(o_Foreground);
            this.m_JLabel.setBackground(o_Background);
            this.m_JLabel.setBackgroundGradientColorFrom(o_Background);
            this.m_JLabel.setBackgroundGradientColorTo(o_Background);
            if (value instanceof Icon) {
                this.m_JLabel.setIcon((Icon)value);
                this.m_JLabel.setText("");
            } else {
                this.m_JLabel.setIcon(null);
                String stringbuilderName = "";
                if (value == null) {
                    if (!this.m_ShowNUll) {
                        this.m_JLabel.setPreferredSize(s_PreferredDimension_NULL);
                        this.m_JLabel.setIcon(null);
                        this.m_JLabel.setBorder(null);
                        this.m_JLabel.setEnabled(false);
                        return this;
                    }
                    stringbuilderName = "---";
                    this.m_JLabel.setPreferredSize(this.m_PreferredDimension);
                } else {
                    stringbuilderName = (String)value;
                    this.m_JLabel.setIcon(null);
                }
                this.m_JLabel.setText(stringbuilderName);
            }
            this.m_JLabel.setEnabled(list.isEnabled());
            this.m_JLabel.setFont(list.getFont());
            Border border = null;
            if (isSelected) {
                border = SELECTED_BORDER;
            }
            if (border == null) {
                border = this.getNoFocusBorder();
            }
            return this.m_JLabel;
        }

        private Border getNoFocusBorder() {
            Border border = null;
            if (System.getSecurityManager() != null) {
                if (border != null) {
                    return border;
                }
                return SAFE_NO_FOCUS_BORDER;
            }
            if (border != null && (noFocusBorder == null || noFocusBorder == DEFAULT_NO_FOCUS_BORDER)) {
                return border;
            }
            return noFocusBorder;
        }
    }
}

