/*
 * Decompiled with CFR 0.152.
 */
package DMXEffectsPackage;

import DMXDevicePackage.DMXDeviceFilter;
import DMXEffectsPackage.DMXEffect;
import DMXEffectsPackage.DMXEffect_Jingle;
import DMXEffectsPackage.DMXEffect_Panel;
import DMXGraphics.LiveShowDMXStageView;
import DMXScenePackage.DMXScene;
import DMXVirtualPackage.LiveShowDMXObject;
import DMXVirtualPackage.LiveShowDMXVIP;
import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LanguageTools.LiveLanguagePackage.LiveLanguageString;
import LiveShowObjectPackage.LiveShowObjectInterface;
import LiveShowPlayPackage.PlayControlPanel;
import LiveShowVirtualPackage.LiveShowSceneBridge;
import StartPackage.LiveShowDMXSystem;
import SwingFramePackage.JOptionDialog;
import SwingToolTipPackage.PopUpToolTip;
import SynchronizationPackage.EventQueueHandler;
import ToolsGraphics.JLabel_ResizeFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.table.DefaultTableModel;

public class LiveShowDMXEffectsView
extends JPanel
implements ListSelectionListener,
PropertyChangeListener {
    private DMXEffect m_SelectedDMXEffect;
    @LiveLanguageString
    public static String DELETE_SELECTEDDMXEFFECT = "<html>The effect is used either in timeline or in jingles.<br>Deleting will remove the effect from all objects!<br>Do you really want to delete the selected effect?</html>";
    @LiveLanguageString
    public static String DELETE_SELECTEDDMXEFFECT_TITLE = "Delete selected DMXEffect";
    DMXEffect_Jingle m_DMXEffect_Jingle;
    PlayControlPanel m_PlayControlPanel;
    private DMXEffect_Panel dMXEffect_Panel;
    private JButton jButton_AddDMXEffect;
    private JButton jButton_CopyEffect;
    private JButton jButton_FilterDevices;
    private JButton jButton_RemoveDMXEffect;
    private JButton jButton_ShowInTimeline;
    private JComboBox<String> jComboBox_DMXScene;
    private JLabel_ResizeFrame jLabel_ResizeFrame1;
    private JPanel jPanel_DMXEffects;
    private JPanel jPanel_Play;
    private JScrollPane jScrollPane_DMXEffects;
    private JSlider jSlider_EffectDuration;
    private JSplitPane jSplitPane1;
    private JTable jTable_DMXEffects;
    private JToolBar jToolBar1;

    public LiveShowDMXEffectsView() {
        this.initMembers();
        this.initComponents();
        this.initComponentsFurther();
        this.setSelectedDMXEffect(null);
        LiveLanguage.addLanguageListener((Object)this, null);
    }

    private void initMembers() {
        this.m_SelectedDMXEffect = null;
    }

    private void initComponentsFurther() {
        this.jScrollPane_DMXEffects.getViewport().setBackground(Color.BLACK);
        this.jTable_DMXEffects.setModel(DMXEffect.getDMXEffectTableModel());
        DMXEffect.getDMXEffectTableModel().finishJTable(this.jTable_DMXEffects);
        this.jTable_DMXEffects.getSelectionModel().addListSelectionListener(this);
        this.jTable_DMXEffects.setRowHeight(24);
        for (int intCopmponent = 0; intCopmponent < this.jSplitPane1.getComponentCount(); ++intCopmponent) {
            Component o_Component = this.jSplitPane1.getComponent(intCopmponent);
            if (!(o_Component instanceof BasicSplitPaneDivider)) continue;
            BasicSplitPaneDivider o_BasicSplitPaneDivider = (BasicSplitPaneDivider)o_Component;
            o_BasicSplitPaneDivider.setBackground(Color.BLACK);
            o_BasicSplitPaneDivider.setBorder(null);
        }
        this.m_DMXEffect_Jingle = new DMXEffect_Jingle();
        this.jSlider_EffectDuration.setMinimum(100);
        this.jSlider_EffectDuration.setMaximum(10000);
        this.jSlider_EffectDuration.setValue(4000);
        this.jComboBox_DMXScene.setModel(DMXScene.getDMXSceneListModel().createListModelWrapper());
        this.jComboBox_DMXScene.setRenderer(DMXScene.getDMXSceneListRenderer());
        this.jComboBox_DMXScene.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                DMXScene o_DMXScene = (DMXScene)LiveShowDMXEffectsView.this.jComboBox_DMXScene.getSelectedItem();
                LiveShowDMXEffectsView.this.m_DMXEffect_Jingle.setDMXScene(o_DMXScene);
            }
        });
        this.m_PlayControlPanel = new PlayControlPanel(this.m_DMXEffect_Jingle.getPlaySynchronisizer(), 0, true, true, true, true, false, false, false, false, false, false);
        this.m_PlayControlPanel.addPlay(this.m_DMXEffect_Jingle.getPlay());
        GridBagConstraints o_GridBagConstraints = new GridBagConstraints();
        o_GridBagConstraints.gridx = 1;
        o_GridBagConstraints.gridy = 0;
        o_GridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Play.add((Component)this.m_PlayControlPanel, o_GridBagConstraints);
        this.jScrollPane_DMXEffects.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jTable_DMXEffects.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_AddDMXEffect.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_RemoveDMXEffect.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_CopyEffect.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_FilterDevices.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_ShowInTimeline.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jComboBox_DMXScene.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jSlider_EffectDuration.setComponentPopupMenu(PopUpToolTip.getSelfReference());
    }

    private void initComponents() {
        this.jLabel_ResizeFrame1 = new JLabel_ResizeFrame();
        this.jSplitPane1 = new JSplitPane();
        this.jPanel_DMXEffects = new JPanel();
        this.jScrollPane_DMXEffects = new JScrollPane();
        this.jTable_DMXEffects = new JTable();
        this.jToolBar1 = new JToolBar();
        this.jButton_AddDMXEffect = new JButton();
        this.jButton_RemoveDMXEffect = new JButton();
        this.jButton_CopyEffect = new JButton();
        this.jButton_FilterDevices = new JButton();
        this.jButton_ShowInTimeline = new JButton();
        this.jPanel_Play = new JPanel();
        this.jComboBox_DMXScene = new JComboBox();
        this.jSlider_EffectDuration = new JSlider();
        this.dMXEffect_Panel = new DMXEffect_Panel();
        this.setLayout(new GridBagLayout());
        this.jLabel_ResizeFrame1.setText("jLabel_ResizeFrame1");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 14;
        this.add((Component)this.jLabel_ResizeFrame1, gridBagConstraints);
        this.jSplitPane1.setBorder(null);
        this.jSplitPane1.setDividerSize(16);
        this.jSplitPane1.setMinimumSize(new Dimension(392, 400));
        this.jSplitPane1.setPreferredSize(new Dimension(485, 500));
        this.jPanel_DMXEffects.setMinimumSize(new Dimension(100, 100));
        this.jPanel_DMXEffects.setPreferredSize(new Dimension(100, 100));
        this.jPanel_DMXEffects.setLayout(new GridBagLayout());
        this.jScrollPane_DMXEffects.setMinimumSize(new Dimension(150, 23));
        this.jScrollPane_DMXEffects.setPreferredSize(new Dimension(250, 402));
        this.jTable_DMXEffects.setFont(new Font("Tahoma", 0, 14));
        this.jTable_DMXEffects.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTable_DMXEffects.setSelectionMode(0);
        this.jScrollPane_DMXEffects.setViewportView(this.jTable_DMXEffects);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel_DMXEffects.add((Component)this.jScrollPane_DMXEffects, gridBagConstraints);
        this.jToolBar1.setBorder(null);
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.jButton_AddDMXEffect.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Edit_Plus.png")));
        this.jButton_AddDMXEffect.setToolTipText("Add DMXEffect");
        this.jButton_AddDMXEffect.setContentAreaFilled(false);
        this.jButton_AddDMXEffect.setFocusable(false);
        this.jButton_AddDMXEffect.setHorizontalTextPosition(0);
        this.jButton_AddDMXEffect.setMargin(new Insets(2, 3, 2, 3));
        this.jButton_AddDMXEffect.setMaximumSize(new Dimension(32, 32));
        this.jButton_AddDMXEffect.setMinimumSize(new Dimension(32, 32));
        this.jButton_AddDMXEffect.setPreferredSize(new Dimension(32, 32));
        this.jButton_AddDMXEffect.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_AddDMXEffect.setVerticalTextPosition(3);
        this.jButton_AddDMXEffect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowDMXEffectsView.this.jButton_AddDMXEffectActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_AddDMXEffect);
        this.jButton_RemoveDMXEffect.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Delete.png")));
        this.jButton_RemoveDMXEffect.setToolTipText("Remove DMXEffect");
        this.jButton_RemoveDMXEffect.setContentAreaFilled(false);
        this.jButton_RemoveDMXEffect.setFocusable(false);
        this.jButton_RemoveDMXEffect.setHorizontalTextPosition(0);
        this.jButton_RemoveDMXEffect.setMargin(new Insets(2, 3, 2, 3));
        this.jButton_RemoveDMXEffect.setMaximumSize(new Dimension(32, 32));
        this.jButton_RemoveDMXEffect.setMinimumSize(new Dimension(32, 32));
        this.jButton_RemoveDMXEffect.setPreferredSize(new Dimension(32, 32));
        this.jButton_RemoveDMXEffect.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_RemoveDMXEffect.setVerticalTextPosition(3);
        this.jButton_RemoveDMXEffect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowDMXEffectsView.this.jButton_RemoveDMXEffectActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_RemoveDMXEffect);
        this.jButton_CopyEffect.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Edit_Copy.png")));
        this.jButton_CopyEffect.setToolTipText("Copy DMXEffect");
        this.jButton_CopyEffect.setContentAreaFilled(false);
        this.jButton_CopyEffect.setFocusable(false);
        this.jButton_CopyEffect.setHorizontalTextPosition(0);
        this.jButton_CopyEffect.setMargin(new Insets(2, 3, 2, 3));
        this.jButton_CopyEffect.setMaximumSize(new Dimension(32, 32));
        this.jButton_CopyEffect.setMinimumSize(new Dimension(32, 32));
        this.jButton_CopyEffect.setPreferredSize(new Dimension(32, 32));
        this.jButton_CopyEffect.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_CopyEffect.setVerticalTextPosition(3);
        this.jButton_CopyEffect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowDMXEffectsView.this.jButton_CopyEffectActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_CopyEffect);
        this.jButton_FilterDevices.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Device_Filter.png")));
        this.jButton_FilterDevices.setToolTipText("Show devices used in this lightscene");
        this.jButton_FilterDevices.setContentAreaFilled(false);
        this.jButton_FilterDevices.setFocusable(false);
        this.jButton_FilterDevices.setHorizontalTextPosition(0);
        this.jButton_FilterDevices.setIconTextGap(0);
        this.jButton_FilterDevices.setMargin(new Insets(0, 0, 0, 0));
        this.jButton_FilterDevices.setMaximumSize(new Dimension(32, 32));
        this.jButton_FilterDevices.setMinimumSize(new Dimension(32, 32));
        this.jButton_FilterDevices.setPreferredSize(new Dimension(32, 32));
        this.jButton_FilterDevices.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_FilterDevices.setVerticalTextPosition(3);
        this.jButton_FilterDevices.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowDMXEffectsView.this.jButton_FilterDevicesActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_FilterDevices);
        this.jButton_ShowInTimeline.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Timeline_Selection.png")));
        this.jButton_ShowInTimeline.setToolTipText("Selects all objects in timeline using this scene.");
        this.jButton_ShowInTimeline.setContentAreaFilled(false);
        this.jButton_ShowInTimeline.setFocusable(false);
        this.jButton_ShowInTimeline.setHorizontalTextPosition(0);
        this.jButton_ShowInTimeline.setIconTextGap(0);
        this.jButton_ShowInTimeline.setMargin(new Insets(0, 0, 0, 0));
        this.jButton_ShowInTimeline.setMaximumSize(new Dimension(32, 32));
        this.jButton_ShowInTimeline.setMinimumSize(new Dimension(32, 32));
        this.jButton_ShowInTimeline.setPreferredSize(new Dimension(32, 32));
        this.jButton_ShowInTimeline.setPressedIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ButtonPressed.png")));
        this.jButton_ShowInTimeline.setVerticalTextPosition(3);
        this.jButton_ShowInTimeline.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveShowDMXEffectsView.this.jButton_ShowInTimelineActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_ShowInTimeline);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel_DMXEffects.add((Component)this.jToolBar1, gridBagConstraints);
        this.jPanel_Play.setLayout(new GridBagLayout());
        this.jComboBox_DMXScene.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Play.add(this.jComboBox_DMXScene, gridBagConstraints);
        this.jSlider_EffectDuration.setMinimum(200);
        this.jSlider_EffectDuration.setToolTipText("Speed");
        this.jSlider_EffectDuration.setValue(4000);
        this.jSlider_EffectDuration.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                LiveShowDMXEffectsView.this.jSlider_EffectDurationStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Play.add((Component)this.jSlider_EffectDuration, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel_DMXEffects.add((Component)this.jPanel_Play, gridBagConstraints);
        this.jSplitPane1.setLeftComponent(this.jPanel_DMXEffects);
        this.jSplitPane1.setRightComponent(this.dMXEffect_Panel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jSplitPane1, gridBagConstraints);
    }

    private void jButton_AddDMXEffectActionPerformed(ActionEvent evt) {
        DMXEffect o_DMXEffect = new DMXEffect();
        DMXEffect.addDMXEffect(o_DMXEffect);
        this.setSelectedDMXEffect(o_DMXEffect);
    }

    private void jButton_RemoveDMXEffectActionPerformed(ActionEvent evt) {
        int intOptionAnswer;
        DMXEffect o_DMXEffect = this.m_SelectedDMXEffect;
        if (o_DMXEffect == null) {
            return;
        }
        boolean boolInUse = false;
        if (o_DMXEffect.getLiveShowDMXObjectCount() > 0 && (intOptionAnswer = JOptionDialog.showConfirmDialog(null, DELETE_SELECTEDDMXEFFECT, DELETE_SELECTEDDMXEFFECT_TITLE, 0, 1)) != 0) {
            return;
        }
        int intIndex = DMXEffect.getDMXEffectTableModel().indexOf(o_DMXEffect);
        o_DMXEffect.close();
        if (intIndex >= DMXEffect.getDMXEffectCount()) {
            intIndex = DMXEffect.getDMXEffectCount() - 1;
        }
        if (intIndex < 0) {
            DMXEffect.getDMXEffectTableModel().clearSelection(this.jTable_DMXEffects);
            this.setSelectedDMXEffect(null);
            return;
        }
        o_DMXEffect = DMXEffect.getDMXEffect(intIndex);
        DMXEffect.getDMXEffectTableModel().setSelectedElement(this.jTable_DMXEffects, o_DMXEffect);
    }

    private void jButton_CopyEffectActionPerformed(ActionEvent evt) {
        DMXEffect o_DMXEffect = this.m_SelectedDMXEffect;
        if (o_DMXEffect == null) {
            return;
        }
        DMXEffect o_NewDMXEffect = o_DMXEffect.clone(null);
        DMXEffect.addDMXEffect(o_NewDMXEffect);
        this.setSelectedDMXEffect(o_NewDMXEffect);
    }

    private void jButton_FilterDevicesActionPerformed(ActionEvent evt) {
        if (this.m_SelectedDMXEffect == null) {
            return;
        }
        DMXDeviceFilter o_DMXDeviceFilter = DMXDeviceFilter.getDMXDeviceFilter(this.m_SelectedDMXEffect);
        LiveShowDMXStageView o_LiveShowDMXStageView = LiveShowDMXSystem.getLiveShowDMXStageView();
        o_LiveShowDMXStageView.filterDMXDevices(o_DMXDeviceFilter);
        o_LiveShowDMXStageView.toFront();
    }

    private void jButton_ShowInTimelineActionPerformed(ActionEvent evt) {
        if (this.m_SelectedDMXEffect == null) {
            return;
        }
        LiveShowDMXVIP o_LiveShowDMXVIP = LiveShowDMXSystem.getLiveShowDMXVIP();
        if (o_LiveShowDMXVIP == null) {
            return;
        }
        o_LiveShowDMXVIP.clearSelectedObjects(true);
        for (int intObject = 0; intObject < o_LiveShowDMXVIP.getLiveShowObjectInterfaceCount(); ++intObject) {
            LiveShowDMXObject o_LiveShowDMXObject;
            LiveShowObjectInterface o_LiveShowObjectInterface = o_LiveShowDMXVIP.getLiveShowObjectInterface(intObject);
            if (o_LiveShowObjectInterface instanceof LiveShowSceneBridge || this.m_SelectedDMXEffect != (o_LiveShowDMXObject = (LiveShowDMXObject)o_LiveShowObjectInterface).getDMXEffect()) continue;
            o_LiveShowDMXVIP.addSelectedObject(o_LiveShowObjectInterface);
        }
        if (o_LiveShowDMXVIP.getSelectedObjectsCount() > 0) {
            o_LiveShowDMXVIP.toFront();
        }
    }

    private void jSlider_EffectDurationStateChanged(ChangeEvent evt) {
        int intDuration = this.jSlider_EffectDuration.getValue();
        this.m_DMXEffect_Jingle.setDuration(intDuration);
    }

    public JLabel_ResizeFrame getLabel_ResizeFrame() {
        return this.jLabel_ResizeFrame1;
    }

    public void setEditModeOn(boolean p_EditMode) {
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        DMXEffect o_DMXEffect = null;
        if (this.jTable_DMXEffects.getSelectedRowCount() > 1) {
            return;
        }
        int intSelectedRow = this.jTable_DMXEffects.getSelectedRow();
        if (intSelectedRow >= 0) {
            try {
                intSelectedRow = this.jTable_DMXEffects.convertRowIndexToModel(intSelectedRow);
                o_DMXEffect = DMXEffect.getDMXEffect(intSelectedRow);
            }
            catch (Exception error) {
                System.out.println("LiveSHowDMXEffectsView valueChanged" + error.getMessage());
                o_DMXEffect = null;
            }
        } else {
            o_DMXEffect = this.m_SelectedDMXEffect;
        }
        this.setSelectedDMXEffect(o_DMXEffect);
    }

    public void setSelectedDMXEffect(DMXEffect p_DMXEffect) {
        if (this.m_SelectedDMXEffect != null) {
            // empty if block
        }
        if (p_DMXEffect == null) {
            DMXEffect.getDMXEffectTableModel().clearSelection(this.jTable_DMXEffects);
            this.dMXEffect_Panel.setDMXEffect(null);
            this.dMXEffect_Panel.setVisible(false);
            this.m_DMXEffect_Jingle.setDMXEffect(p_DMXEffect);
            EventQueueHandler.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LiveShowDMXEffectsView.this.jSplitPane1.setDividerLocation(1);
                }
            });
        } else {
            DMXEffect.getDMXEffectTableModel().setSelectedElement(this.jTable_DMXEffects, p_DMXEffect);
            DMXEffect.getDMXEffectTableModel().scrollToSelection(this.jTable_DMXEffects);
            this.dMXEffect_Panel.setVisible(true);
            EventQueueHandler.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (LiveShowDMXEffectsView.this.jSplitPane1.getDividerLocation() < LiveShowDMXEffectsView.this.jSplitPane1.getDividerSize() + 10 || LiveShowDMXEffectsView.this.jSplitPane1.getDividerLocation() >= LiveShowDMXEffectsView.this.jSplitPane1.getWidth() - LiveShowDMXEffectsView.this.jSplitPane1.getDividerSize() - 10) {
                        LiveShowDMXEffectsView.this.jSplitPane1.setDividerLocation(0.3);
                    }
                }
            });
        }
        this.m_SelectedDMXEffect = p_DMXEffect;
        this.dMXEffect_Panel.setDMXEffect(this.m_SelectedDMXEffect);
        this.m_DMXEffect_Jingle.setDMXEffect(this.m_SelectedDMXEffect);
        this.refreshButtons();
    }

    public DMXEffect getSelectedDMXEffect() {
        return this.m_SelectedDMXEffect;
    }

    private void refreshButtons() {
        int intSelectedRow = this.jTable_DMXEffects.getSelectedRow();
        if (intSelectedRow < 0) {
            this.jButton_RemoveDMXEffect.setEnabled(false);
            this.jButton_CopyEffect.setEnabled(false);
            this.jButton_FilterDevices.setEnabled(false);
            this.jButton_ShowInTimeline.setEnabled(false);
        } else {
            this.jButton_RemoveDMXEffect.setEnabled(true);
            this.jButton_CopyEffect.setEnabled(true);
            this.jButton_FilterDevices.setEnabled(true);
            this.jButton_ShowInTimeline.setEnabled(true);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof DMXEffect) {
            DMXEffect o_DMXEffect = (DMXEffect)evt.getSource();
            if ("dmxeffectClosing".equals(evt.getPropertyName()) && o_DMXEffect == this.m_SelectedDMXEffect) {
                this.setSelectedDMXEffect(null);
            }
        }
    }
}

