/*
 * Decompiled with CFR 0.152.
 */
package DMXEffectsPackage;

import DMXDevicePackage.DMXDevice;
import DMXEffectsPackage.DMXEffect_FunctionPanel;
import DMXEffectsPackage.DMXEffect_FunctionRowPanel;
import DMXMixer.DMXControlComponent;
import DMXMixer.DMXControl_GridPanTilt;
import DMXMixer.DMXControl_GridPanTilt_DeviceSettings;
import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LiveShowControlObjects.ControlObject;
import LiveShowControls.JControlGrid;
import SwingToolTipPackage.PopUpToolTip;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.security.SecureRandom;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DMXEffect_Randomizer_JPanel
extends JPanel
implements DMXControlComponent.ManuallyChangeListener,
DMXControl_GridPanTilt.VirtualManuallyChangeListener,
DMXEffect_FunctionPanel.StepSelectionListener,
DMXControl_GridPanTilt.ToggleViewListener {
    private DMXControlComponent m_DMXControlComponent_Start;
    private ArrayList<Double> m_Values_Start;
    private ArrayList<Double> m_NormedValues_Start;
    private DMXControlComponent m_DMXControlComponent_End;
    private ArrayList<Double> m_Values_End;
    private ArrayList<Double> m_NormedValues_End;
    private DMXEffect_FunctionPanel m_DMXEffect_FunctionPanel;
    private SecureRandom m_Random;
    private JButton jButton_RandomizeSteps;
    private JLabel jLabel_Remark;
    private JLabel jLabel_ValueEnd;
    private JLabel jLabel_ValueStart;
    private JPanel jPanel_Buttons;
    private JPanel jPanel_ValueEnd;
    private JPanel jPanel_ValueStart;

    public DMXEffect_Randomizer_JPanel() {
        this.initMembers();
        this.initComponents();
        this.initComponentsFurther();
        LiveLanguage.addLanguageListener((Object)this, null);
    }

    private void initMembers() {
        this.m_DMXControlComponent_Start = null;
        this.m_DMXControlComponent_End = null;
        this.m_DMXEffect_FunctionPanel = null;
        this.m_Values_Start = new ArrayList();
        this.m_Values_End = new ArrayList();
        this.m_NormedValues_Start = new ArrayList();
        this.m_NormedValues_End = new ArrayList();
        this.m_Random = new SecureRandom();
    }

    private void initComponents() {
        this.jLabel_Remark = new JLabel();
        this.jPanel_ValueStart = new JPanel();
        this.jLabel_ValueStart = new JLabel();
        this.jPanel_ValueEnd = new JPanel();
        this.jLabel_ValueEnd = new JLabel();
        this.jPanel_Buttons = new JPanel();
        this.jButton_RandomizeSteps = new JButton();
        this.setLayout(new GridBagLayout());
        this.jLabel_Remark.setHorizontalAlignment(0);
        this.jLabel_Remark.setText("Please select steps in the dmx effect");
        this.jLabel_Remark.setToolTipText("");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jLabel_Remark, gridBagConstraints);
        this.jPanel_ValueStart.setLayout(new GridBagLayout());
        this.jLabel_ValueStart.setHorizontalAlignment(0);
        this.jLabel_ValueStart.setText("From");
        this.jLabel_ValueStart.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel_ValueStart.add((Component)this.jLabel_ValueStart, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jPanel_ValueStart, gridBagConstraints);
        this.jPanel_ValueEnd.setLayout(new GridBagLayout());
        this.jLabel_ValueEnd.setHorizontalAlignment(0);
        this.jLabel_ValueEnd.setText("To");
        this.jLabel_ValueEnd.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel_ValueEnd.add((Component)this.jLabel_ValueEnd, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jPanel_ValueEnd, gridBagConstraints);
        this.jPanel_Buttons.setLayout(new GridBagLayout());
        this.jButton_RandomizeSteps.setText("Randomize");
        this.jButton_RandomizeSteps.setToolTipText("");
        this.jButton_RandomizeSteps.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DMXEffect_Randomizer_JPanel.this.jButton_RandomizeStepsActionPerformed(evt);
            }
        });
        this.jPanel_Buttons.add((Component)this.jButton_RandomizeSteps, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jPanel_Buttons, gridBagConstraints);
    }

    private void initComponentsFurther() {
        this.jButton_RandomizeSteps.setComponentPopupMenu(PopUpToolTip.getSelfReference());
    }

    private void jButton_RandomizeStepsActionPerformed(ActionEvent evt) {
        this.fillStepPanels_Selected();
    }

    public void setDMXEffect_FunctionPanel(DMXEffect_FunctionPanel p_DMXEffect_FunctionPanel) {
        if (this.m_DMXEffect_FunctionPanel == p_DMXEffect_FunctionPanel) {
            return;
        }
        if (this.m_DMXEffect_FunctionPanel != null) {
            this.m_DMXEffect_FunctionPanel.removeStepSelectionListener(this);
        }
        this.m_DMXEffect_FunctionPanel = p_DMXEffect_FunctionPanel;
        if (this.m_DMXEffect_FunctionPanel != null) {
            this.m_DMXEffect_FunctionPanel.addStepSelectionListener(this);
        }
        this.refresh();
    }

    private void refresh() {
        GridBagConstraints o_GridBagConstraints;
        DMXControl_GridPanTilt o_DMXControl_GridPanTilt;
        int intValue;
        DMXEffect_FunctionPanel o_DMXEffect_FunctionPanel = this.m_DMXEffect_FunctionPanel;
        if (o_DMXEffect_FunctionPanel == null || o_DMXEffect_FunctionPanel.getSelectedStepPanelCount() <= 0) {
            this.jButton_RandomizeSteps.setEnabled(false);
            this.jLabel_ValueStart.setVisible(false);
            if (this.m_DMXControlComponent_Start != null) {
                this.m_DMXControlComponent_Start.setVisible(false);
            }
            this.jLabel_ValueEnd.setVisible(false);
            if (this.m_DMXControlComponent_End != null) {
                this.m_DMXControlComponent_End.setVisible(false);
            }
            this.jLabel_Remark.setVisible(true);
            return;
        }
        this.jLabel_Remark.setVisible(false);
        this.jLabel_ValueStart.setVisible(true);
        this.jLabel_ValueEnd.setVisible(true);
        DMXEffect_FunctionRowPanel.StepPanel o_StepPanel = o_DMXEffect_FunctionPanel.getSelectedStepPanel(0);
        if (o_StepPanel == null) {
            return;
        }
        DMXControlComponent.DMXControlType o_DMXControlType = o_StepPanel.getDMXControlType();
        int intDimensionCount = 0;
        for (int intControl = 0; intControl < o_DMXControlType.getControlTypeCount(); ++intControl) {
            DMXControlComponent.ControlType o_ControlType = o_DMXControlType.getControlType(intControl);
            if (o_ControlType == null) continue;
            intDimensionCount += o_ControlType.getControlDimensionTypeCount();
        }
        if (this.m_NormedValues_Start.size() != intDimensionCount) {
            this.m_NormedValues_Start.clear();
            this.m_Values_Start.clear();
            for (intValue = 0; intValue < intDimensionCount; ++intValue) {
                this.m_NormedValues_Start.add(0.0);
                this.m_Values_Start.add(0.0);
            }
        }
        if (this.m_NormedValues_End.size() != intDimensionCount) {
            this.m_NormedValues_End.clear();
            this.m_Values_End.clear();
            for (intValue = 0; intValue < intDimensionCount; ++intValue) {
                this.m_NormedValues_End.add(0.0);
                this.m_Values_End.add(0.0);
            }
        }
        if (this.m_DMXControlComponent_Start == null || !this.m_DMXControlComponent_Start.getDMXControlType().getDMXControlDescription().getID().equals(o_DMXControlType.getDMXControlDescription().getID())) {
            if (this.m_DMXControlComponent_Start != null) {
                if (this.m_DMXControlComponent_Start instanceof DMXControl_GridPanTilt) {
                    o_DMXControl_GridPanTilt = (DMXControl_GridPanTilt)this.m_DMXControlComponent_Start;
                    o_DMXControl_GridPanTilt.removeVirtualManuallyChangeListener(this);
                    o_DMXControl_GridPanTilt.removeToggleViewListener(this);
                }
                this.m_DMXControlComponent_Start.removeManuallyChangeListener(this);
                this.m_DMXControlComponent_Start.setVisible(false);
                this.jPanel_ValueStart.remove(this.m_DMXControlComponent_Start);
            }
            this.m_DMXControlComponent_Start = DMXControlComponent.loadDMXControlComponent(o_DMXControlType.copyWithoutLinks());
            this.m_DMXControlComponent_Start.setEnableSettings(false);
            this.m_DMXControlComponent_Start.addManuallyChangeListener(this);
            o_GridBagConstraints = new GridBagConstraints();
            o_GridBagConstraints.gridx = 0;
            o_GridBagConstraints.gridy = 1;
            o_GridBagConstraints.fill = this.m_DMXControlComponent_Start instanceof DMXControl_GridPanTilt ? 1 : 3;
            o_GridBagConstraints.weightx = 1.0;
            o_GridBagConstraints.weighty = 1.0;
            this.jPanel_ValueStart.add((Component)this.m_DMXControlComponent_Start, o_GridBagConstraints);
            if (this.m_DMXControlComponent_Start instanceof DMXControl_GridPanTilt) {
                o_DMXControl_GridPanTilt = (DMXControl_GridPanTilt)this.m_DMXControlComponent_Start;
                o_DMXControl_GridPanTilt.addVirtualManuallyChangeListener(this);
                o_DMXControl_GridPanTilt.addToggleViewListener(this);
            }
        }
        this.m_DMXControlComponent_Start.setVisible(true);
        if (this.m_DMXControlComponent_Start instanceof DMXControl_GridPanTilt) {
            o_DMXControl_GridPanTilt = (DMXControl_GridPanTilt)this.m_DMXControlComponent_Start;
            if (o_DMXControl_GridPanTilt.isVirtual_PanTilt_Visible()) {
                this.checkPanTilt_VirtualGridAreas(o_DMXControl_GridPanTilt, this.m_DMXEffect_FunctionPanel.getRandomizerVirtualValues_Start());
            } else {
                o_DMXControl_GridPanTilt.setValuesByDMXEffect(this.m_DMXEffect_FunctionPanel.getRandomizerValues_Start());
            }
        } else {
            this.m_DMXControlComponent_Start.setValuesByDMXEffect(this.m_DMXEffect_FunctionPanel.getRandomizerValues_Start());
        }
        if (this.m_DMXControlComponent_End == null || !this.m_DMXControlComponent_End.getDMXControlType().getDMXControlDescription().getID().equals(o_DMXControlType.getDMXControlDescription().getID())) {
            if (this.m_DMXControlComponent_End != null) {
                if (this.m_DMXControlComponent_End instanceof DMXControl_GridPanTilt) {
                    o_DMXControl_GridPanTilt = (DMXControl_GridPanTilt)this.m_DMXControlComponent_End;
                    o_DMXControl_GridPanTilt.removeVirtualManuallyChangeListener(this);
                    o_DMXControl_GridPanTilt.removeToggleViewListener(this);
                }
                this.m_DMXControlComponent_End.removeManuallyChangeListener(this);
                this.m_DMXControlComponent_End.setVisible(false);
                this.jPanel_ValueStart.remove(this.m_DMXControlComponent_End);
            }
            this.m_DMXControlComponent_End = DMXControlComponent.loadDMXControlComponent(o_DMXControlType.copyWithoutLinks());
            this.m_DMXControlComponent_End.setEnableSettings(false);
            this.m_DMXControlComponent_End.addManuallyChangeListener(this);
            o_GridBagConstraints = new GridBagConstraints();
            o_GridBagConstraints.gridx = 0;
            o_GridBagConstraints.gridy = 1;
            o_GridBagConstraints.fill = this.m_DMXControlComponent_End instanceof DMXControl_GridPanTilt ? 1 : 3;
            o_GridBagConstraints.weightx = 1.0;
            o_GridBagConstraints.weighty = 1.0;
            this.jPanel_ValueEnd.add((Component)this.m_DMXControlComponent_End, o_GridBagConstraints);
            if (this.m_DMXControlComponent_End instanceof DMXControl_GridPanTilt) {
                o_DMXControl_GridPanTilt = (DMXControl_GridPanTilt)this.m_DMXControlComponent_End;
                o_DMXControl_GridPanTilt.addVirtualManuallyChangeListener(this);
                o_DMXControl_GridPanTilt.addToggleViewListener(this);
            }
        }
        this.m_DMXControlComponent_End.setVisible(true);
        if (this.m_DMXControlComponent_End instanceof DMXControl_GridPanTilt) {
            o_DMXControl_GridPanTilt = (DMXControl_GridPanTilt)this.m_DMXControlComponent_End;
            if (o_DMXControl_GridPanTilt.isVirtual_PanTilt_Visible()) {
                this.checkPanTilt_VirtualGridAreas(o_DMXControl_GridPanTilt, this.m_DMXEffect_FunctionPanel.getRandomizerVirtualValues_End());
            } else {
                o_DMXControl_GridPanTilt.setValuesByDMXEffect(this.m_DMXEffect_FunctionPanel.getRandomizerValues_End());
            }
        } else {
            this.m_DMXControlComponent_End.setValuesByDMXEffect(this.m_DMXEffect_FunctionPanel.getRandomizerValues_End());
        }
        this.calculateStartEnd_NormedValues();
        this.jButton_RandomizeSteps.setEnabled(true);
    }

    private void checkPanTilt_VirtualGridAreas(DMXControl_GridPanTilt p_DMXControl_GridPanTilt, ArrayList<Double> p_VirtualValues) {
        Point2D o_Point2D;
        if (p_DMXControl_GridPanTilt == null) {
            return;
        }
        ArrayList o_GridAreas = null;
        DMXEffect_FunctionPanel o_DMXEffect_FunctionPanel = this.m_DMXEffect_FunctionPanel;
        if (o_DMXEffect_FunctionPanel == null) {
            return;
        }
        if (p_VirtualValues != null && p_VirtualValues.size() == 2) {
            o_GridAreas = p_DMXControl_GridPanTilt.getJControlGridVirtual().getGridAreasWithIntersection(p_VirtualValues.get(0).doubleValue(), p_VirtualValues.get(1).doubleValue());
        }
        for (int intGridArea = 0; intGridArea < p_DMXControl_GridPanTilt.getJControlGridVirtual().getGridAreaCount(); ++intGridArea) {
            JControlGrid.GridArea o_GridArea = p_DMXControl_GridPanTilt.getJControlGridVirtual().getGridArea(intGridArea);
            if (o_GridArea == null) continue;
            o_GridArea.setComplete(true);
            for (int intStep = 0; intStep < o_DMXEffect_FunctionPanel.getSelectedStepPanelCount(); ++intStep) {
                DMXDevice o_DMXDevice;
                DMXEffect_FunctionRowPanel.StepPanel o_StepPanel = o_DMXEffect_FunctionPanel.getSelectedStepPanel(intStep);
                if (o_StepPanel == null || (o_DMXDevice = o_StepPanel.getDMXDevice()) == null) continue;
                DMXControlComponent o_DeviceDMXControlComponent = o_DMXDevice.getDMXControlComponentByDescriptionFirst(this.m_DMXEffect_FunctionPanel.getDMXEffect_Function().getDMXControlDescriptionID());
                if (o_DeviceDMXControlComponent == null) {
                    return;
                }
                DMXControl_GridPanTilt o_DeviceDMXControl_GridPanTilt = (DMXControl_GridPanTilt)o_DeviceDMXControlComponent;
                JControlGrid.GridArea o_DeviceGridArea = o_DeviceDMXControl_GridPanTilt.getJControlGridVirtual().getGridAreaBySortID(o_GridArea.getSortID());
                DMXControl_GridPanTilt_DeviceSettings.StageArea o_StageArea = (DMXControl_GridPanTilt_DeviceSettings.StageArea)o_DeviceGridArea.getAreaObject();
                if (o_StageArea == null || o_StageArea.getEnabled()) continue;
                o_GridArea.setComplete(false);
                if (o_GridAreas == null) continue;
                o_GridAreas.remove(o_GridArea);
            }
        }
        if ((o_GridAreas == null || o_GridAreas.size() <= 0) && p_VirtualValues != null && p_VirtualValues.size() == 2 && (o_Point2D = p_DMXControl_GridPanTilt.getJControlGridVirtual().checkValuesInAreas(p_VirtualValues.get(0).doubleValue(), p_VirtualValues.get(1).doubleValue())) != null) {
            p_VirtualValues.set(0, o_Point2D.getX());
            p_VirtualValues.set(1, o_Point2D.getY());
        }
        p_DMXControl_GridPanTilt.setVirtualValuesByDMXEffect(p_VirtualValues);
    }

    @Override
    public void eventToggleView(DMXControl_GridPanTilt p_DMXControl_GridPanTilt, boolean p_VirtualGridVisible) {
        if (p_DMXControl_GridPanTilt == this.m_DMXControlComponent_Start) {
            ((DMXControl_GridPanTilt)this.m_DMXControlComponent_End).setVirtual_PanTilt_Visible(p_VirtualGridVisible);
        } else {
            ((DMXControl_GridPanTilt)this.m_DMXControlComponent_Start).setVirtual_PanTilt_Visible(p_VirtualGridVisible);
        }
        this.refresh();
    }

    private void calculateStartEnd_NormedValues() {
        double doubleValueNormed;
        double doubleDimensionMaxValue;
        int intDimaension;
        ControlObject o_ControlObject;
        int intValue;
        DMXControlComponent o_DMXControlComponent = this.m_DMXControlComponent_Start;
        if (o_DMXControlComponent != null) {
            DMXControl_GridPanTilt o_DMXControl_GridPanTilt;
            this.m_Values_Start = o_DMXControlComponent instanceof DMXControl_GridPanTilt ? ((o_DMXControl_GridPanTilt = (DMXControl_GridPanTilt)o_DMXControlComponent).isVirtual_PanTilt_Visible() ? o_DMXControl_GridPanTilt.getVirtualValuesForDMXEffect(this.m_Values_Start) : o_DMXControlComponent.getValuesForDMXEffect(this.m_Values_Start)) : o_DMXControlComponent.getValuesForDMXEffect(this.m_Values_Start);
            intValue = 0;
            for (int intControl = 0; intControl < o_DMXControlComponent.getControlObjectCount(); ++intControl) {
                o_ControlObject = o_DMXControlComponent.getControlObject(intControl);
                if (o_ControlObject == null) continue;
                for (intDimaension = 0; intDimaension < o_ControlObject.getControlDimensionCount(); ++intDimaension) {
                    if (intValue >= this.m_Values_Start.size()) continue;
                    doubleDimensionMaxValue = o_DMXControlComponent.getValueMaximum(intControl, intDimaension);
                    doubleValueNormed = doubleDimensionMaxValue <= 0.0 ? 0.0 : this.m_Values_Start.get(intValue) / doubleDimensionMaxValue;
                    this.m_NormedValues_Start.set(intValue, doubleValueNormed);
                    ++intValue;
                }
            }
        }
        if ((o_DMXControlComponent = this.m_DMXControlComponent_End) != null) {
            DMXControl_GridPanTilt o_DMXControl_GridPanTilt;
            this.m_Values_End = o_DMXControlComponent instanceof DMXControl_GridPanTilt ? ((o_DMXControl_GridPanTilt = (DMXControl_GridPanTilt)o_DMXControlComponent).isVirtual_PanTilt_Visible() ? o_DMXControl_GridPanTilt.getVirtualValuesForDMXEffect(this.m_Values_End) : o_DMXControlComponent.getValuesForDMXEffect(this.m_Values_End)) : o_DMXControlComponent.getValuesForDMXEffect(this.m_Values_End);
            intValue = 0;
            for (int intControl = 0; intControl < o_DMXControlComponent.getControlObjectCount(); ++intControl) {
                o_ControlObject = o_DMXControlComponent.getControlObject(intControl);
                if (o_ControlObject == null) continue;
                for (intDimaension = 0; intDimaension < o_ControlObject.getControlDimensionCount(); ++intDimaension) {
                    if (intValue >= this.m_Values_End.size()) continue;
                    doubleDimensionMaxValue = o_DMXControlComponent.getValueMaximum(intControl, intDimaension);
                    doubleValueNormed = doubleDimensionMaxValue <= 0.0 ? 0.0 : this.m_Values_End.get(intValue) / doubleDimensionMaxValue;
                    this.m_NormedValues_End.set(intValue, doubleValueNormed);
                    ++intValue;
                }
            }
        }
    }

    @Override
    public void eventManuallyChanged(DMXControlComponent p_DMXControlComponent) {
        if (p_DMXControlComponent == this.m_DMXControlComponent_Start) {
            this.calculateStartEnd_NormedValues();
            if (this.m_DMXEffect_FunctionPanel != null) {
                if (this.m_DMXControlComponent_Start instanceof DMXControl_GridPanTilt) {
                    DMXControl_GridPanTilt o_DMXControl_GridPanTilt = (DMXControl_GridPanTilt)this.m_DMXControlComponent_Start;
                    if (o_DMXControl_GridPanTilt.isVirtual_PanTilt_Visible()) {
                        this.m_DMXEffect_FunctionPanel.setRandomizerVirtualValues_Start(this.m_Values_Start);
                    } else {
                        this.m_DMXEffect_FunctionPanel.setRandomizerValues_Start(this.m_Values_Start);
                    }
                } else {
                    this.m_DMXEffect_FunctionPanel.setRandomizerValues_Start(this.m_Values_Start);
                }
            }
        } else if (p_DMXControlComponent == this.m_DMXControlComponent_End) {
            this.calculateStartEnd_NormedValues();
            if (this.m_DMXEffect_FunctionPanel != null) {
                if (this.m_DMXControlComponent_End instanceof DMXControl_GridPanTilt) {
                    DMXControl_GridPanTilt o_DMXControl_GridPanTilt = (DMXControl_GridPanTilt)this.m_DMXControlComponent_End;
                    if (o_DMXControl_GridPanTilt.isVirtual_PanTilt_Visible()) {
                        this.m_DMXEffect_FunctionPanel.setRandomizerVirtualValues_End(this.m_Values_End);
                    } else {
                        this.m_DMXEffect_FunctionPanel.setRandomizerValues_End(this.m_Values_End);
                    }
                } else {
                    this.m_DMXEffect_FunctionPanel.setRandomizerValues_End(this.m_Values_End);
                }
            }
        }
    }

    @Override
    public void eventVirtualManuallyChanged(DMXControlComponent p_DMXControlComponent) {
        if (p_DMXControlComponent == null) {
            return;
        }
        if (!(p_DMXControlComponent instanceof DMXControl_GridPanTilt)) {
            return;
        }
        DMXControl_GridPanTilt o_DMXControl_GridPanTilt = (DMXControl_GridPanTilt)p_DMXControlComponent;
        if (p_DMXControlComponent == this.m_DMXControlComponent_Start) {
            this.calculateStartEnd_NormedValues();
            if (o_DMXControl_GridPanTilt.isVirtual_PanTilt_Visible()) {
                this.m_DMXEffect_FunctionPanel.setRandomizerVirtualValues_Start(this.m_Values_Start);
            } else {
                this.m_DMXEffect_FunctionPanel.setRandomizerValues_Start(this.m_Values_Start);
            }
        } else if (p_DMXControlComponent == this.m_DMXControlComponent_End) {
            this.calculateStartEnd_NormedValues();
            if (o_DMXControl_GridPanTilt.isVirtual_PanTilt_Visible()) {
                this.m_DMXEffect_FunctionPanel.setRandomizerVirtualValues_End(this.m_Values_End);
            } else {
                this.m_DMXEffect_FunctionPanel.setRandomizerValues_End(this.m_Values_End);
            }
        }
    }

    private void fillStepPanels_Selected() {
        DMXEffect_FunctionPanel o_DMXEffect_FunctionPanel = this.m_DMXEffect_FunctionPanel;
        if (o_DMXEffect_FunctionPanel == null) {
            return;
        }
        this.m_Random = new SecureRandom();
        if (this.m_DMXControlComponent_Start.getDMXControlDescriptionID().equals("pantilt") && ((DMXControl_GridPanTilt)this.m_DMXControlComponent_Start).isVirtual_PanTilt_Visible() && ((DMXControl_GridPanTilt)this.m_DMXControlComponent_End).isVirtual_PanTilt_Visible()) {
            this.fillStepPanels_PanTilt();
            return;
        }
        for (int intStepPanel = 0; intStepPanel < o_DMXEffect_FunctionPanel.getSelectedStepPanelCount(); ++intStepPanel) {
            DMXEffect_FunctionRowPanel.StepPanel o_StepPanel = o_DMXEffect_FunctionPanel.getSelectedStepPanel(intStepPanel);
            if (o_StepPanel == null) continue;
            this.fillStepPanel(o_StepPanel);
        }
    }

    private void fillStepPanel(DMXEffect_FunctionRowPanel.StepPanel p_StepPanel) {
        if (p_StepPanel == null) {
            return;
        }
        ArrayList<Double> o_Values = new ArrayList<Double>();
        DMXDevice o_DMXDevice = p_StepPanel.getDMXDevice();
        if (o_DMXDevice == null) {
            return;
        }
        DMXControlComponent o_DMXControlComponent = o_DMXDevice.getDMXControlComponentByDescriptionFirst(this.m_DMXEffect_FunctionPanel.getDMXEffect_Function().getDMXControlDescriptionID());
        if (o_DMXControlComponent == null) {
            return;
        }
        int intValue = 0;
        for (int intControl = 0; intControl < o_DMXControlComponent.getControlObjectCount(); ++intControl) {
            ControlObject o_ControlObject = o_DMXControlComponent.getControlObject(intControl);
            if (o_ControlObject == null) {
                return;
            }
            for (int intDimension = 0; intDimension < o_ControlObject.getControlDimensionCount(); ++intDimension) {
                double doubleNormedValue_Start;
                double doubleNormedValue_End;
                if (intValue >= this.m_NormedValues_Start.size()) continue;
                double doubleMaxValue = o_DMXControlComponent.getValueMaximum(intControl, intDimension);
                if (this.m_NormedValues_Start.get(intValue) < this.m_NormedValues_End.get(intValue)) {
                    doubleNormedValue_End = this.m_NormedValues_End.get(intValue);
                    doubleNormedValue_Start = this.m_NormedValues_Start.get(intValue);
                } else {
                    doubleNormedValue_End = this.m_NormedValues_Start.get(intValue);
                    doubleNormedValue_Start = this.m_NormedValues_End.get(intValue);
                }
                double doubleValueResult = (doubleNormedValue_Start + (doubleNormedValue_End - doubleNormedValue_Start) * this.m_Random.nextDouble()) * doubleMaxValue;
                o_Values.add(doubleValueResult);
                ++intValue;
            }
        }
        p_StepPanel.setValues(o_Values);
    }

    private void fillStepPanels_PanTilt() {
        Point2D.Double o_Point2D_Coordinates_Start = null;
        ArrayList o_GridAreas_Start = null;
        Point2D.Double o_Point2D_Coordinates_End = null;
        ArrayList o_GridAreas_End = null;
        DMXEffect_FunctionPanel o_DMXEffect_FunctionPanel = this.m_DMXEffect_FunctionPanel;
        if (o_DMXEffect_FunctionPanel == null) {
            return;
        }
        if (!this.m_DMXControlComponent_Start.getDMXControlDescriptionID().equals("pantilt")) {
            return;
        }
        DMXControl_GridPanTilt o_DMXControl_GridPanTilt = (DMXControl_GridPanTilt)this.m_DMXControlComponent_Start;
        if (o_DMXControl_GridPanTilt.isVirtual_PanTilt_Visible()) {
            o_Point2D_Coordinates_Start = new Point2D.Double(o_DMXControl_GridPanTilt.getVirtualControlGrid().getValue_X(), o_DMXControl_GridPanTilt.getVirtualControlGrid().getValue_Y());
            o_GridAreas_Start = o_DMXControl_GridPanTilt.getJControlGridVirtual().getGridAreasWithIntersection(((Point2D)o_Point2D_Coordinates_Start).getX(), ((Point2D)o_Point2D_Coordinates_Start).getY());
        }
        if ((o_DMXControl_GridPanTilt = (DMXControl_GridPanTilt)this.m_DMXControlComponent_End).isVirtual_PanTilt_Visible()) {
            o_Point2D_Coordinates_End = new Point2D.Double(o_DMXControl_GridPanTilt.getVirtualControlGrid().getValue_X(), o_DMXControl_GridPanTilt.getVirtualControlGrid().getValue_Y());
            o_GridAreas_End = o_DMXControl_GridPanTilt.getJControlGridVirtual().getGridAreasWithIntersection(((Point2D)o_Point2D_Coordinates_End).getX(), ((Point2D)o_Point2D_Coordinates_End).getY());
        }
        if (o_GridAreas_Start != null && o_GridAreas_Start.size() > 0 && o_GridAreas_End != null && o_GridAreas_End.size() > 0) {
            for (int intStepPanel = 0; intStepPanel < o_DMXEffect_FunctionPanel.getSelectedStepPanelCount(); ++intStepPanel) {
                DMXEffect_FunctionRowPanel.StepPanel o_StepPanel = o_DMXEffect_FunctionPanel.getSelectedStepPanel(intStepPanel);
                if (o_StepPanel == null) continue;
                this.fillStepPanel_PanTilt(o_StepPanel, o_GridAreas_Start, o_Point2D_Coordinates_Start, o_GridAreas_End, o_Point2D_Coordinates_End);
            }
        }
    }

    public void fillStepPanel_PanTilt(DMXEffect_FunctionRowPanel.StepPanel p_StepPanel, ArrayList<JControlGrid.GridArea> p_GridAreas_Start, Point2D p_Point2D_Coordinates_Start, ArrayList<JControlGrid.GridArea> p_GridAreas_End, Point2D p_Point2D_Coordinates_End) {
        Point2D o_Point2D = null;
        double doubleMin_X = Double.MAX_VALUE;
        double doubleMax_X = -1.7976931348623157E308;
        double doubleMin_Y = Double.MAX_VALUE;
        double doubleMax_Y = -1.7976931348623157E308;
        boolean boolStartFound = false;
        boolean boolEndFound = false;
        DMXDevice o_DMXDevice = p_StepPanel.getDMXDevice();
        if (o_DMXDevice == null) {
            return;
        }
        DMXControlComponent o_DMXControlComponent = o_DMXDevice.getDMXControlComponentByDescriptionFirst(this.m_DMXEffect_FunctionPanel.getDMXEffect_Function().getDMXControlDescriptionID());
        if (o_DMXControlComponent == null) {
            return;
        }
        DMXControl_GridPanTilt o_DMXControl_GridPanTilt = (DMXControl_GridPanTilt)o_DMXControlComponent;
        if (p_GridAreas_Start != null && p_GridAreas_Start.size() > 0 && p_GridAreas_End != null && p_GridAreas_End.size() > 0) {
            DMXControl_GridPanTilt_DeviceSettings.StageArea o_StageArea;
            JControlGrid.GridArea o_GridArea;
            int intGridArea;
            for (intGridArea = 0; intGridArea < p_GridAreas_Start.size(); ++intGridArea) {
                o_GridArea = p_GridAreas_Start.get(intGridArea);
                o_GridArea = o_DMXControl_GridPanTilt.getJControlGridVirtual().getGridAreaBySortID(o_GridArea.getSortID());
                o_StageArea = (DMXControl_GridPanTilt_DeviceSettings.StageArea)o_GridArea.getAreaObject();
                if (o_StageArea == null || !o_StageArea.getEnabled() || (o_Point2D = DMXControl_GridPanTilt_DeviceSettings.calculateVirtualValuesFromCoordinate(o_Point2D, o_StageArea, p_Point2D_Coordinates_Start.getX(), p_Point2D_Coordinates_Start.getY(), false)) == null) continue;
                boolStartFound = true;
                o_Point2D.setLocation(o_Point2D.getX() + (double)o_StageArea.getPosX(), o_Point2D.getY() + (double)o_StageArea.getPosY());
                if (o_Point2D.getX() > doubleMax_X) {
                    doubleMax_X = o_Point2D.getX();
                }
                if (o_Point2D.getX() < doubleMin_X) {
                    doubleMin_X = o_Point2D.getX();
                }
                if (o_Point2D.getY() > doubleMax_Y) {
                    doubleMax_Y = o_Point2D.getY();
                }
                if (!(o_Point2D.getY() < doubleMin_Y)) continue;
                doubleMin_Y = o_Point2D.getY();
            }
            for (intGridArea = 0; intGridArea < p_GridAreas_End.size(); ++intGridArea) {
                o_GridArea = p_GridAreas_End.get(intGridArea);
                o_GridArea = o_DMXControl_GridPanTilt.getJControlGridVirtual().getGridAreaBySortID(o_GridArea.getSortID());
                o_StageArea = (DMXControl_GridPanTilt_DeviceSettings.StageArea)o_GridArea.getAreaObject();
                if (o_StageArea == null || !o_StageArea.getEnabled() || (o_Point2D = DMXControl_GridPanTilt_DeviceSettings.calculateVirtualValuesFromCoordinate(o_Point2D, o_StageArea, p_Point2D_Coordinates_End.getX(), p_Point2D_Coordinates_End.getY(), false)) == null) continue;
                boolEndFound = true;
                o_Point2D.setLocation(o_Point2D.getX() + (double)o_StageArea.getPosX(), o_Point2D.getY() + (double)o_StageArea.getPosY());
                if (o_Point2D.getX() > doubleMax_X) {
                    doubleMax_X = o_Point2D.getX();
                }
                if (o_Point2D.getX() < doubleMin_X) {
                    doubleMin_X = o_Point2D.getX();
                }
                if (o_Point2D.getY() > doubleMax_Y) {
                    doubleMax_Y = o_Point2D.getY();
                }
                if (!(o_Point2D.getY() < doubleMin_Y)) continue;
                doubleMin_Y = o_Point2D.getY();
            }
            if (!boolStartFound || !boolEndFound) {
                return;
            }
            Point2D.Double o_RandomVirtualPoint = new Point2D.Double(doubleMin_X + (doubleMax_X - doubleMin_X) * this.m_Random.nextDouble(), doubleMin_Y + (doubleMax_Y - doubleMin_Y) * this.m_Random.nextDouble());
            o_StageArea = o_DMXControl_GridPanTilt.getStageArea_Linked_ByPos(o_DMXDevice, (int)((Point2D)o_RandomVirtualPoint).getX(), (int)((Point2D)o_RandomVirtualPoint).getY());
            if (o_StageArea == null) {
                return;
            }
            ((Point2D)o_RandomVirtualPoint).setLocation(((Point2D)o_RandomVirtualPoint).getX() - (double)o_StageArea.getPosX(), ((Point2D)o_RandomVirtualPoint).getY() - (double)o_StageArea.getPosY());
            Point2D o_AnglesVirtualPoint = DMXControl_GridPanTilt_DeviceSettings.calculateAnglesFromVirtual(null, o_DMXDevice, o_StageArea, ((Point2D)o_RandomVirtualPoint).getX(), ((Point2D)o_RandomVirtualPoint).getY(), 0.0);
            if (o_AnglesVirtualPoint == null) {
                return;
            }
            ArrayList<Double> o_Values = new ArrayList<Double>(2);
            o_Values.add(o_AnglesVirtualPoint.getX());
            o_Values.add(o_AnglesVirtualPoint.getY());
            p_StepPanel.setValues(o_Values);
        }
    }

    @Override
    public void eventStepSelectionChanged(DMXEffect_FunctionPanel p_DMXEffect_FunctionPanel) {
        this.setDMXEffect_FunctionPanel(p_DMXEffect_FunctionPanel);
        this.refresh();
    }
}

