/*
 * Decompiled with CFR 0.152.
 */
package DMXEffectsPackage;

import DMXDevicePackage.DMXDevice;
import DMXEffectsPackage.DMXEffect;
import DMXEffectsPackage.DMXEffect_Function;
import DMXEffectsPackage.DMXEffect_FunctionPanel;
import DMXMixer.DMXControlComponent;
import DMXMixer.DMXControlDisplayLabel;
import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LanguageTools.LiveLanguagePackage.LiveLanguageString;
import SwingToolTipPackage.PopUpToolTip;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public class DMXEffect_FunctionRowPanel
extends JPanel
implements PropertyChangeListener {
    public static Dimension s_DisplaySize = new Dimension(24, 24);
    public static Insets s_DisplayInsets = new Insets(1, 1, 1, 1);
    @LiveLanguageString
    public static String s_StepPanelToolTip = "<html>Click to select and change value.<br>Hold down shift or ctrl to select several.</html>";
    private DMXEffect_FunctionPanel m_DMXEffect_FunctionPanel;
    private DMXEffect_Function m_DMXEffect_Function;
    private int m_Row;
    private DMXEffect_Function.DMXEffectElement m_DMXEffectElement;
    private ArrayList<StepPanel> m_StepPanels;
    private Dimension m_PreferredSize;
    private JLabel jLabel_DMXControl;
    private JLabel jLabel_DMXDevice;

    public DMXEffect_FunctionRowPanel(DMXEffect_FunctionPanel p_DMXEffect_FunctionPanel) {
        this.initMembers();
        this.m_DMXEffect_FunctionPanel = p_DMXEffect_FunctionPanel;
        this.initComponents();
        this.initComponentsFurther();
        LiveLanguage.addLanguageListener((Object)this, null);
    }

    private void initMembers() {
        this.m_StepPanels = new ArrayList();
        this.m_PreferredSize = new Dimension();
    }

    private void initComponents() {
        this.jLabel_DMXDevice = new JLabel();
        this.jLabel_DMXControl = new JLabel();
        this.setMinimumSize(new Dimension(50, 20));
        this.setPreferredSize(new Dimension(400, 20));
        this.setLayout(new GridBagLayout());
        this.jLabel_DMXDevice.setFont(new Font("Tahoma", 0, 12));
        this.jLabel_DMXDevice.setHorizontalAlignment(4);
        this.jLabel_DMXDevice.setText("jLabel1");
        this.jLabel_DMXDevice.setMaximumSize(new Dimension(100, 15));
        this.jLabel_DMXDevice.setMinimumSize(new Dimension(100, 15));
        this.jLabel_DMXDevice.setPreferredSize(new Dimension(100, 15));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 3);
        this.add((Component)this.jLabel_DMXDevice, gridBagConstraints);
        this.jLabel_DMXControl.setFont(new Font("Tahoma", 0, 12));
        this.jLabel_DMXControl.setHorizontalAlignment(4);
        this.jLabel_DMXControl.setText("jLabel1");
        this.jLabel_DMXControl.setMaximumSize(new Dimension(100, 15));
        this.jLabel_DMXControl.setMinimumSize(new Dimension(100, 15));
        this.jLabel_DMXControl.setName("");
        this.jLabel_DMXControl.setPreferredSize(new Dimension(100, 15));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 5);
        this.add((Component)this.jLabel_DMXControl, gridBagConstraints);
    }

    private void initComponentsFurther() {
        this.m_PreferredSize.setSize(this.jLabel_DMXDevice.getPreferredSize().width + this.jLabel_DMXControl.getPreferredSize().width + 10, DMXEffect_FunctionRowPanel.s_DisplaySize.height + 4);
        this.jLabel_DMXDevice.setComponentPopupMenu(PopUpToolTip.getSelfReference());
    }

    public void close() {
        this.jLabel_DMXDevice.setComponentPopupMenu(null);
        this.clear();
        LiveLanguage.removeLanguageListener((Object)this);
    }

    public void setDMXEffect_Function(int p_Row, DMXEffect_Function p_DMXEffect_Function) {
        if (this.m_DMXEffect_Function != null) {
            this.m_DMXEffect_Function.removePropertyChangeListener(this);
        }
        this.m_DMXEffect_Function = p_DMXEffect_Function;
        if (this.m_DMXEffect_Function != null) {
            this.m_DMXEffect_Function.addPropertyChangeListener(this);
        }
        this.m_Row = p_Row;
        this.refresh();
    }

    public DMXEffect_FunctionPanel getDMXEffect_FunctionPanel() {
        return this.m_DMXEffect_FunctionPanel;
    }

    public DMXEffect_Function getDMXEffect_Function() {
        return this.m_DMXEffect_Function;
    }

    public DMXEffect_Function.DMXEffectElement getDMXEffectElement() {
        return this.m_DMXEffectElement;
    }

    public int getRow() {
        return this.m_Row;
    }

    public DMXDevice getDMXDevice() {
        if (this.m_DMXEffectElement == null) {
            return null;
        }
        return this.m_DMXEffectElement.getDMXDevice();
    }

    public int getStepCount() {
        return this.m_StepPanels.size();
    }

    public int getStep(StepPanel p_StepPanel) {
        if (p_StepPanel == null) {
            return -1;
        }
        return this.m_StepPanels.indexOf(p_StepPanel);
    }

    public StepPanel getStepPanel(int p_Step) {
        if (p_Step < 0) {
            return null;
        }
        if (p_Step >= this.m_StepPanels.size()) {
            return null;
        }
        return this.m_StepPanels.get(p_Step);
    }

    public void refresh() {
        StepPanel o_StepPanel;
        int intStep;
        DMXDevice o_DMXDevice;
        DMXEffect_Function o_DMXEffect_Function = this.m_DMXEffect_Function;
        if (o_DMXEffect_Function == null) {
            this.clear();
            return;
        }
        DMXEffect_Function.DMXEffectElement o_DMXEffectElement = this.m_DMXEffect_Function.getDMXEffectElement(this.m_Row);
        if (o_DMXEffectElement != this.m_DMXEffectElement) {
            if (this.m_DMXEffectElement != null && (o_DMXDevice = this.m_DMXEffectElement.getDMXDevice()) != null) {
                o_DMXDevice.removePropertyChangeListener(this);
            }
            this.m_DMXEffectElement = o_DMXEffectElement;
        }
        if (this.m_DMXEffectElement == null) {
            this.clear();
            return;
        }
        o_DMXDevice = this.m_DMXEffectElement.getDMXDevice();
        DMXControlComponent o_DMXControlComponent = this.m_DMXEffectElement.getDMXControlComponent();
        int intDMXControlComponentIndex = this.m_DMXEffectElement.getInternalRowIndex();
        if (o_DMXDevice == null || o_DMXControlComponent == null) {
            this.clear();
            return;
        }
        o_DMXDevice.addPropertyChangeListener(this);
        if (intDMXControlComponentIndex == 0) {
            this.jLabel_DMXDevice.setText(o_DMXDevice.getName());
            this.jLabel_DMXDevice.setToolTipText(o_DMXDevice.getToolTipText());
        } else {
            this.jLabel_DMXDevice.setText("");
            this.jLabel_DMXDevice.setToolTipText(null);
        }
        this.jLabel_DMXControl.setText(o_DMXControlComponent.getName());
        DMXEffect_Function.DMXEffect_ValuesMatrix o_DMXEffect_ValuesMatrix = o_DMXEffect_Function.getDMXEffect_ValuesMatrix();
        int intStepCount = o_DMXEffect_ValuesMatrix == null ? 0 : o_DMXEffect_ValuesMatrix.getStepCount();
        if (intStepCount > this.m_StepPanels.size()) {
            GridBagConstraints o_GridBagConstraints = new GridBagConstraints();
            o_GridBagConstraints.gridy = 0;
            o_GridBagConstraints.insets = s_DisplayInsets;
            for (intStep = this.m_StepPanels.size(); intStep < intStepCount; ++intStep) {
                o_StepPanel = new StepPanel(this);
                o_StepPanel.setMaximumSize(s_DisplaySize);
                o_StepPanel.setMinimumSize(s_DisplaySize);
                o_StepPanel.setPreferredSize(s_DisplaySize);
                o_StepPanel.setDMXControlComponent(o_DMXControlComponent);
                this.m_StepPanels.add(o_StepPanel);
                o_GridBagConstraints.gridx = 2 + intStep;
                this.add((Component)o_StepPanel, o_GridBagConstraints);
                this.m_PreferredSize.width += DMXEffect_FunctionRowPanel.s_DisplaySize.width + DMXEffect_FunctionRowPanel.s_DisplayInsets.left + DMXEffect_FunctionRowPanel.s_DisplayInsets.right;
            }
            this.setPreferredSize(this.m_PreferredSize);
        } else if (intStepCount < this.m_StepPanels.size()) {
            for (intStep = this.m_StepPanels.size() - 1; intStep >= intStepCount; --intStep) {
                o_StepPanel = this.m_StepPanels.get(intStep);
                if (o_StepPanel != null) {
                    this.remove(o_StepPanel);
                    o_StepPanel.close();
                }
                this.m_StepPanels.remove(intStep);
                this.m_PreferredSize.width -= DMXEffect_FunctionRowPanel.s_DisplaySize.width + DMXEffect_FunctionRowPanel.s_DisplayInsets.left + DMXEffect_FunctionRowPanel.s_DisplayInsets.right;
            }
            this.setPreferredSize(this.m_PreferredSize);
        }
        if (this.m_StepPanels.size() <= 0) {
            return;
        }
        for (intStep = 0; intStep < this.m_StepPanels.size(); ++intStep) {
            o_StepPanel = this.m_StepPanels.get(intStep);
            o_StepPanel.setDMXControlComponent(o_DMXControlComponent);
            o_StepPanel.setStep(intStep);
            o_StepPanel.refresh();
        }
    }

    private void clear() {
        this.jLabel_DMXDevice.setText("");
        this.jLabel_DMXControl.setText("");
        for (int intStep = this.m_StepPanels.size() - 1; intStep >= 0; --intStep) {
            StepPanel o_StepPanel = this.m_StepPanels.get(intStep);
            if (o_StepPanel == null) continue;
            o_StepPanel.close();
            this.remove(o_StepPanel);
        }
        this.m_StepPanels.clear();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof DMXDevice) {
            DMXDevice o_DMXDevice = (DMXDevice)evt.getSource();
            if (this.m_DMXEffectElement != null && this.m_DMXEffectElement.getInternalRowIndex() == 0 && o_DMXDevice == this.m_DMXEffectElement.getDMXDevice()) {
                this.jLabel_DMXDevice.setText(o_DMXDevice.getName());
            }
            return;
        }
        if (evt.getSource() instanceof DMXEffect_Function && DMXEffect_Function.PROP_DMXEFFECTFUNCTION_VALUESCHANGED.equals(evt.getPropertyName())) {
            this.refresh();
        }
    }

    public void selectedStepPanels_AddAll() {
        for (int intStepPanel = 0; intStepPanel < this.m_StepPanels.size(); ++intStepPanel) {
            StepPanel o_StepPanel = this.m_StepPanels.get(intStepPanel);
            o_StepPanel.setSelected(true);
        }
    }

    public static class StepPanel
    extends JPanel {
        private static Border s_EmptyBorder = new EmptyBorder(1, 1, 1, 1);
        private static Border s_SelectedBorder = new LineBorder(Color.BLUE, 2);
        private static Border s_DMXControlDisplayLabelBorder = new LineBorder(Color.GRAY, 1);
        private DMXEffect_FunctionRowPanel m_DMXEffect_FunctionRowPanel;
        private DMXControlDisplayLabel m_DMXControlDisplayLabel;
        private int m_Step;
        private MouseAdapter m_MouseAdapter;
        private boolean m_Selected;
        private Rectangle m_Bounds;
        private boolean m_ExternalMouseInside;
        private StepPanel m_SelfReference = this;

        public StepPanel(DMXEffect_FunctionRowPanel p_DMXEffect_FunctionRowPanel) {
            this.m_DMXEffect_FunctionRowPanel = p_DMXEffect_FunctionRowPanel;
            this.initMembers();
            this.initComponents();
        }

        private void initMembers() {
            this.m_Selected = false;
        }

        private void initComponents() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints o_GridBagConstraints = new GridBagConstraints();
            o_GridBagConstraints.gridx = 0;
            o_GridBagConstraints.gridy = 0;
            o_GridBagConstraints.fill = 1;
            o_GridBagConstraints.weightx = 1.0;
            o_GridBagConstraints.weighty = 1.0;
            this.m_DMXControlDisplayLabel = new DMXControlDisplayLabel();
            this.m_DMXControlDisplayLabel.setBorder(s_DMXControlDisplayLabelBorder);
            this.add((Component)this.m_DMXControlDisplayLabel, o_GridBagConstraints);
            this.m_DMXControlDisplayLabel.setVisible(true);
            this.m_MouseAdapter = new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getSource() instanceof DMXControlDisplayLabel && e.getButton() == 1) {
                        if (e.isShiftDown()) {
                            this.setSelected(!m_Selected);
                        } else if (e.isControlDown()) {
                            this.setSelected(!m_Selected);
                        } else {
                            this.clearSelection();
                            this.setSelected(true);
                        }
                    }
                }

                @Override
                public void mouseDragged(MouseEvent e) {
                    Point o_Point = new Point(e.getXOnScreen(), e.getYOnScreen());
                    DMXEffect_FunctionPanel o_DMXEffect_FunctionPanel = m_SelfReference.getDMXEffect_FunctionPanel();
                    if (o_DMXEffect_FunctionPanel == null) {
                        return;
                    }
                    if (o_DMXEffect_FunctionPanel.getJPanel_Rows() == null) {
                        return;
                    }
                    SwingUtilities.convertPointFromScreen(o_Point, o_DMXEffect_FunctionPanel.getJPanel_Rows());
                    MouseEvent o_MouseEvent = new MouseEvent(e.getComponent(), e.getID(), e.getWhen(), e.getModifiers(), o_Point.x, o_Point.y, e.getClickCount(), false, e.getButton());
                    o_DMXEffect_FunctionPanel.getJPanel_Rows().dispatchEvent(o_MouseEvent);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    Point o_Point = new Point(e.getXOnScreen(), e.getYOnScreen());
                    DMXEffect_FunctionPanel o_DMXEffect_FunctionPanel = m_SelfReference.getDMXEffect_FunctionPanel();
                    if (o_DMXEffect_FunctionPanel == null) {
                        return;
                    }
                    if (o_DMXEffect_FunctionPanel.getJPanel_Rows() == null) {
                        return;
                    }
                    SwingUtilities.convertPointFromScreen(o_Point, o_DMXEffect_FunctionPanel.getJPanel_Rows());
                    MouseEvent o_MouseEvent = new MouseEvent(e.getComponent(), e.getID(), e.getWhen(), e.getModifiers(), o_Point.x, o_Point.y, e.getClickCount(), false, e.getButton());
                    o_DMXEffect_FunctionPanel.getJPanel_Rows().dispatchEvent(o_MouseEvent);
                }
            };
            this.m_DMXControlDisplayLabel.addMouseListener(this.m_MouseAdapter);
            this.m_DMXControlDisplayLabel.addMouseMotionListener(this.m_MouseAdapter);
            this.m_DMXControlDisplayLabel.setToolTipText_Foreign(s_StepPanelToolTip);
            this.setToolTipText(s_StepPanelToolTip);
            this.setComponentPopupMenu(PopUpToolTip.getSelfReference());
            this.setBorder(s_EmptyBorder);
            this.setBackground(Color.BLACK);
        }

        public void close() {
            this.setSelected(false);
            this.setComponentPopupMenu(null);
            this.m_DMXControlDisplayLabel.setToolTipText_Foreign(null);
            this.m_DMXControlDisplayLabel.removeMouseListener(this.m_MouseAdapter);
            this.m_DMXControlDisplayLabel.setVisible(false);
            this.m_DMXControlDisplayLabel.close();
        }

        DMXEffect_FunctionRowPanel getDMXEffect_FunctionRowPanel() {
            return this.m_DMXEffect_FunctionRowPanel;
        }

        DMXEffect_FunctionPanel getDMXEffect_FunctionPanel() {
            if (this.m_DMXEffect_FunctionRowPanel != null) {
                return this.m_DMXEffect_FunctionRowPanel.getDMXEffect_FunctionPanel();
            }
            return null;
        }

        public DMXDevice getDMXDevice() {
            DMXEffect_FunctionRowPanel o_DMXEffect_FunctionRowPanel = this.m_DMXEffect_FunctionRowPanel;
            if (o_DMXEffect_FunctionRowPanel == null) {
                return null;
            }
            return o_DMXEffect_FunctionRowPanel.getDMXDevice();
        }

        public DMXControlDisplayLabel getDMXControlDisplayLabel() {
            return this.m_DMXControlDisplayLabel;
        }

        public DMXControlComponent getDMXControlComponent() {
            return this.m_DMXControlDisplayLabel.getDMXControlComponent();
        }

        public DMXControlComponent.DMXControlType getDMXControlType() {
            DMXControlComponent o_DMXControlComponent = this.m_DMXControlDisplayLabel.getDMXControlComponent();
            if (o_DMXControlComponent == null) {
                return null;
            }
            return o_DMXControlComponent.getDMXControlType();
        }

        public void setDMXControlComponent(DMXControlComponent p_DMXControlComponent) {
            this.m_DMXControlDisplayLabel.setDMXControlComponent(p_DMXControlComponent);
        }

        public void setStep(int p_Step) {
            this.m_Step = p_Step;
        }

        public int getStep() {
            return this.m_DMXEffect_FunctionRowPanel.getStep(this);
        }

        public void clearSelection() {
            DMXEffect_FunctionPanel o_DMXEffect_FunctionPanel = this.m_DMXEffect_FunctionRowPanel.getDMXEffect_FunctionPanel();
            o_DMXEffect_FunctionPanel.selectedStepPanels_Clear();
        }

        public void setSelected(boolean p_Selected) {
            if (this.m_Selected == p_Selected) {
                return;
            }
            this.m_Selected = p_Selected;
            if (this.m_Selected) {
                this.setBorder(s_SelectedBorder);
            } else {
                this.setBorder(s_EmptyBorder);
            }
            DMXEffect_FunctionPanel o_DMXEffect_FunctionPanel = this.m_DMXEffect_FunctionRowPanel.getDMXEffect_FunctionPanel();
            if (this.m_Selected) {
                o_DMXEffect_FunctionPanel.selectedStepPanels_Add(this);
            } else {
                o_DMXEffect_FunctionPanel.selectedStepPanels_Remove(this);
            }
        }

        public boolean getSelected() {
            return this.m_Selected;
        }

        public boolean externalMouseEnter(int p_LastX, int p_LastY, int p_X, int p_Y) {
            this.m_Bounds = this.getBounds(this.m_Bounds);
            this.m_Bounds.setRect(this.m_Bounds.x + 3, this.m_Bounds.y + 3, this.m_Bounds.width - 6, this.m_Bounds.height - 6);
            if (!(p_LastX < this.m_Bounds.x && p_X < this.m_Bounds.x || p_LastX > this.m_Bounds.x + this.m_Bounds.width && p_X > this.m_Bounds.x + this.m_Bounds.width || p_LastY < this.m_Bounds.y && p_Y < this.m_Bounds.y || p_LastY > this.m_Bounds.y + this.m_Bounds.height && p_Y > this.m_Bounds.y + this.m_Bounds.height)) {
                if (this.m_ExternalMouseInside) {
                    return false;
                }
                this.m_ExternalMouseInside = true;
                return true;
            }
            this.m_ExternalMouseInside = false;
            return false;
        }

        public void externalMouseReleased(int p_X, int p_Y) {
            this.m_ExternalMouseInside = false;
        }

        public ArrayList<Double> getValues() {
            DMXEffect_Function o_DMXEffect_Function = this.m_DMXEffect_FunctionRowPanel.getDMXEffect_Function();
            if (o_DMXEffect_Function == null) {
                return null;
            }
            DMXEffect_Function.DMXEffect_ValuesMatrix o_DMXEffect_ValuesMatrix = o_DMXEffect_Function.getDMXEffect_ValuesMatrix();
            return o_DMXEffect_ValuesMatrix.getValues(this.m_DMXEffect_FunctionRowPanel.getRow(), this.m_Step);
        }

        public void setValues(ArrayList<Double> p_Values) {
            DMXEffect.DMXDeviceElement o_DMXDeviceElement;
            DMXEffect_Function o_DMXEffect_Function = this.m_DMXEffect_FunctionRowPanel.getDMXEffect_Function();
            if (o_DMXEffect_Function == null) {
                return;
            }
            int intRow = this.m_DMXEffect_FunctionRowPanel.getRow();
            DMXEffect_Function.DMXEffect_ValuesMatrix o_DMXEffect_ValuesMatrix = o_DMXEffect_Function.getDMXEffect_ValuesMatrix();
            o_DMXEffect_ValuesMatrix.setValues(p_Values, intRow, this.m_Step);
            DMXEffect_Function.DMXEffectElement o_DMXEffectElement = o_DMXEffect_Function.getDMXEffectElement(intRow);
            if (o_DMXEffectElement != null && (o_DMXDeviceElement = o_DMXEffectElement.getDMXDeviceElement()) != null) {
                o_DMXDeviceElement.calculateIsOnSteps();
            }
            this.refresh();
        }

        public void refresh() {
            DMXEffect_Function o_DMXEffect_Function = this.m_DMXEffect_FunctionRowPanel.getDMXEffect_Function();
            if (o_DMXEffect_Function == null) {
                return;
            }
            DMXEffect_Function.DMXEffect_ValuesMatrix o_DMXEffect_ValuesMatrix = o_DMXEffect_Function.getDMXEffect_ValuesMatrix();
            if (o_DMXEffect_ValuesMatrix == null) {
                return;
            }
            int intRow = this.m_DMXEffect_FunctionRowPanel.getRow();
            DMXEffect_Function.DMXEffectElement o_DMXEffectElement = this.m_DMXEffect_FunctionRowPanel.getDMXEffectElement();
            if (o_DMXEffectElement == null) {
                return;
            }
            DMXDevice o_DMXDevice = o_DMXEffectElement.getDMXDevice();
            if (o_DMXDevice == null) {
                return;
            }
            DMXControlComponent o_DMXControlComponent = o_DMXEffectElement.getDMXControlComponent();
            if (o_DMXControlComponent == null) {
                return;
            }
            if (o_DMXControlComponent != this.m_DMXControlDisplayLabel.getDMXControlComponent()) {
                this.m_DMXControlDisplayLabel.setDMXControlComponent(o_DMXControlComponent);
            }
            o_DMXControlComponent.refreshDisplay_Foreign(this.m_DMXControlDisplayLabel, o_DMXControlComponent.getControlLabelList_First(o_DMXDevice), o_DMXEffect_ValuesMatrix.getValues(intRow, this.m_Step));
        }

        public void fetchValues() {
            ArrayList<Double> o_Values = this.getValues();
            DMXDevice o_DMXDevice = this.m_DMXEffect_FunctionRowPanel.getDMXEffectElement().getDMXDevice();
            DMXControlComponent o_DMXControlComponent_Original = o_DMXDevice.getDMXControlComponentByID(this.m_DMXEffect_FunctionRowPanel.getDMXEffectElement().getDMXControlComponent().getDMXControlType().getID());
            if (o_DMXControlComponent_Original == null) {
                return;
            }
            o_Values = o_DMXControlComponent_Original.getValuesForDMXEffect(o_Values);
            this.setValues(o_Values);
            this.refresh();
        }

        public void writeValues() {
            ArrayList<Double> o_Values = this.getValues();
            DMXDevice o_DMXDevice = this.m_DMXEffect_FunctionRowPanel.getDMXEffectElement().getDMXDevice();
            DMXControlComponent o_DMXControlComponent_Original = o_DMXDevice.getDMXControlComponentByID(this.m_DMXEffect_FunctionRowPanel.getDMXEffectElement().getDMXControlComponent().getDMXControlType().getID());
            if (o_DMXControlComponent_Original == null) {
                return;
            }
            o_DMXControlComponent_Original.setValuesByDMXEffect(o_Values);
            o_DMXControlComponent_Original.setValueManuallyIsReady();
        }
    }
}

