/*
 * Decompiled with CFR 0.152.
 */
package DMXEffectsPackage;

import DMXDevicePackage.DMXDevice;
import DMXEffectsPackage.DMXEffect;
import DMXGraphics.LiveShowDMXStageView;
import LanguageTools.LiveLanguagePackage.LiveLanguage;
import StartPackage.LiveShowDMXSystem;
import SwingModelPackage.TableAndListModel;
import SwingToolTipPackage.PopUpToolTip;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DMXEffect_DMXDevicePanel
extends JPanel
implements ListSelectionListener {
    private DMXEffect m_DMXEffect;
    private TableAndListModel.ListModelWrapper<DMXEffect.DMXDeviceElement> m_ListModelWrapper_DMXDevices;
    private final Object m_SyncObject = new Object();
    private JButton jButton_AddDMXDevices;
    private JButton jButton_InvertDMXDevice;
    private JButton jButton_MoveDown;
    private JButton jButton_MoveUp;
    private JButton jButton_RemoveDMXDevice;
    private JButton jButton_ShowDMXStageView;
    private JList<DMXEffect.DMXDeviceElement> jList_Devices;
    private JScrollPane jScrollPane1;
    private JToolBar jToolBar1;

    public DMXEffect_DMXDevicePanel(DMXEffect p_DMXEffect) {
        this.initMembers();
        this.m_DMXEffect = p_DMXEffect;
        this.initComponents();
        this.initComponentsFurther();
        this.refresh();
        LiveLanguage.addLanguageListener((Object)this, null);
    }

    private void initMembers() {
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jList_Devices = new JList();
        this.jToolBar1 = new JToolBar();
        this.jButton_AddDMXDevices = new JButton();
        this.jButton_RemoveDMXDevice = new JButton();
        this.jButton_MoveUp = new JButton();
        this.jButton_MoveDown = new JButton();
        this.jButton_InvertDMXDevice = new JButton();
        this.jButton_ShowDMXStageView = new JButton();
        this.setLayout(new GridBagLayout());
        this.jList_Devices.setFont(new Font("Tahoma", 0, 12));
        this.jScrollPane1.setViewportView(this.jList_Devices);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jToolBar1.setBorder(null);
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setOrientation(1);
        this.jToolBar1.setRollover(true);
        this.jButton_AddDMXDevices.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Edit_Plus.png")));
        this.jButton_AddDMXDevices.setToolTipText("Add DMXDevices as selected in DMXStageView");
        this.jButton_AddDMXDevices.setContentAreaFilled(false);
        this.jButton_AddDMXDevices.setFocusable(false);
        this.jButton_AddDMXDevices.setHorizontalTextPosition(0);
        this.jButton_AddDMXDevices.setVerticalTextPosition(3);
        this.jButton_AddDMXDevices.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DMXEffect_DMXDevicePanel.this.jButton_AddDMXDevicesActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_AddDMXDevices);
        this.jButton_RemoveDMXDevice.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Delete.png")));
        this.jButton_RemoveDMXDevice.setToolTipText("Remove selected DMXDevice");
        this.jButton_RemoveDMXDevice.setContentAreaFilled(false);
        this.jButton_RemoveDMXDevice.setFocusable(false);
        this.jButton_RemoveDMXDevice.setHorizontalTextPosition(0);
        this.jButton_RemoveDMXDevice.setVerticalTextPosition(3);
        this.jButton_RemoveDMXDevice.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DMXEffect_DMXDevicePanel.this.jButton_RemoveDMXDeviceActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_RemoveDMXDevice);
        this.jButton_MoveUp.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Arrow_Up.png")));
        this.jButton_MoveUp.setToolTipText("Move up selected device");
        this.jButton_MoveUp.setContentAreaFilled(false);
        this.jButton_MoveUp.setFocusable(false);
        this.jButton_MoveUp.setHorizontalTextPosition(0);
        this.jButton_MoveUp.setVerticalTextPosition(3);
        this.jButton_MoveUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DMXEffect_DMXDevicePanel.this.jButton_MoveUpActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_MoveUp);
        this.jButton_MoveDown.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Arrow_Down.png")));
        this.jButton_MoveDown.setToolTipText("Move down selected device");
        this.jButton_MoveDown.setContentAreaFilled(false);
        this.jButton_MoveDown.setFocusable(false);
        this.jButton_MoveDown.setHorizontalTextPosition(0);
        this.jButton_MoveDown.setVerticalTextPosition(3);
        this.jButton_MoveDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DMXEffect_DMXDevicePanel.this.jButton_MoveDownActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_MoveDown);
        this.jButton_InvertDMXDevice.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Edit_Invert.png")));
        this.jButton_InvertDMXDevice.setToolTipText("Invert the controls of the selected device");
        this.jButton_InvertDMXDevice.setContentAreaFilled(false);
        this.jButton_InvertDMXDevice.setFocusable(false);
        this.jButton_InvertDMXDevice.setHorizontalTextPosition(0);
        this.jButton_InvertDMXDevice.setVerticalTextPosition(3);
        this.jButton_InvertDMXDevice.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DMXEffect_DMXDevicePanel.this.jButton_InvertDMXDeviceActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_InvertDMXDevice);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jToolBar1, gridBagConstraints);
        this.jButton_ShowDMXStageView.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Menu_DMXStageView.png")));
        this.jButton_ShowDMXStageView.setToolTipText("Invert the controls of the selected device");
        this.jButton_ShowDMXStageView.setContentAreaFilled(false);
        this.jButton_ShowDMXStageView.setFocusable(false);
        this.jButton_ShowDMXStageView.setHorizontalTextPosition(0);
        this.jButton_ShowDMXStageView.setVerticalTextPosition(3);
        this.jButton_ShowDMXStageView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DMXEffect_DMXDevicePanel.this.jButton_ShowDMXStageViewActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 11;
        this.add((Component)this.jButton_ShowDMXStageView, gridBagConstraints);
    }

    private void initComponentsFurther() {
        this.jScrollPane1.getViewport().setBackground(Color.BLACK);
        this.jList_Devices.setCellRenderer(DMXEffect.getDMXDeviceElementListRenderer());
        this.jList_Devices.setSelectionMode(0);
        ListSelectionModel o_ListSelectionModel = this.jList_Devices.getSelectionModel();
        if (o_ListSelectionModel != null) {
            o_ListSelectionModel.addListSelectionListener(this);
        }
        this.jList_Devices.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_AddDMXDevices.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_RemoveDMXDevice.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_MoveUp.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_MoveDown.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_InvertDMXDevice.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_ShowDMXStageView.setComponentPopupMenu(PopUpToolTip.getSelfReference());
    }

    public void setDMXEffect(DMXEffect p_DMXEffect) {
        if (this.m_DMXEffect != null) {
            // empty if block
        }
        this.m_DMXEffect = p_DMXEffect;
        if (this.m_DMXEffect != null) {
            // empty if block
        }
        this.refresh();
    }

    public void refresh() {
        if (this.m_DMXEffect == null) {
            this.m_ListModelWrapper_DMXDevices = null;
            this.jList_Devices.setVisible(false);
            this.jButton_AddDMXDevices.setEnabled(false);
            this.refreshButtons();
            return;
        }
        this.m_ListModelWrapper_DMXDevices = this.m_DMXEffect.getDMXDeviceListModelWrapper();
        this.jList_Devices.setModel(this.m_ListModelWrapper_DMXDevices);
        this.jList_Devices.setVisible(true);
        this.jButton_AddDMXDevices.setEnabled(true);
        this.refreshButtons();
    }

    private void refreshButtons() {
        if (this.m_DMXEffect == null) {
            this.jButton_AddDMXDevices.setEnabled(false);
        } else {
            this.jButton_AddDMXDevices.setEnabled(true);
        }
        int intSelectedIndex = this.jList_Devices.getSelectedIndex();
        if (intSelectedIndex < 0) {
            this.jButton_RemoveDMXDevice.setEnabled(false);
            this.jButton_MoveUp.setEnabled(false);
            this.jButton_MoveDown.setEnabled(false);
            this.jButton_InvertDMXDevice.setEnabled(false);
        } else {
            this.jButton_RemoveDMXDevice.setEnabled(true);
            this.jButton_MoveUp.setEnabled(true);
            this.jButton_MoveDown.setEnabled(true);
            this.jButton_InvertDMXDevice.setEnabled(true);
        }
    }

    private void jButton_AddDMXDevicesActionPerformed(ActionEvent evt) {
        DMXDevice o_DMXDevice = null;
        DMXEffect o_DMXEffect = this.m_DMXEffect;
        if (o_DMXEffect == null) {
            return;
        }
        LiveShowDMXStageView o_LiveShowDMXStageView = LiveShowDMXSystem.getLiveShowDMXStageView();
        int intDMXDeviceCount = o_LiveShowDMXStageView.getSelectedDMXDeviceCount();
        for (int intDevice = 0; intDevice < intDMXDeviceCount; ++intDevice) {
            o_DMXDevice = o_LiveShowDMXStageView.getSelectedDMXDevice(intDevice);
            if (o_DMXDevice == null) {
                return;
            }
            o_DMXEffect.addDMXDevice(o_DMXDevice);
        }
        DMXEffect.DMXDeviceElement o_DMXDeviceElement = o_DMXEffect.getDMXDeviceElement(o_DMXDevice);
    }

    private void jButton_RemoveDMXDeviceActionPerformed(ActionEvent evt) {
        DMXEffect o_DMXEffect = this.m_DMXEffect;
        if (o_DMXEffect == null) {
            return;
        }
        int intIndex = this.jList_Devices.getSelectedIndex();
        DMXEffect.DMXDeviceElement o_DMXDeviceElement = o_DMXEffect.getDMXDeviceElement(intIndex);
        if (o_DMXDeviceElement == null) {
            return;
        }
        o_DMXEffect.removeDMXDeviceElement(o_DMXDeviceElement);
        if (intIndex >= o_DMXEffect.getDMXDeviceCount()) {
            intIndex = o_DMXEffect.getDMXDeviceCount() - 1;
        }
        if (intIndex < 0) {
            return;
        }
        try {
            this.jList_Devices.setSelectedIndex(intIndex);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void jButton_MoveUpActionPerformed(ActionEvent evt) {
        DMXEffect o_DMXEffect = this.m_DMXEffect;
        if (o_DMXEffect == null) {
            return;
        }
        int intSelectedIndex = this.jList_Devices.getSelectedIndex();
        DMXEffect.DMXDeviceElement o_DMXDeviceElement = o_DMXEffect.getDMXDeviceElement(intSelectedIndex);
        if (o_DMXDeviceElement == null) {
            return;
        }
        if (o_DMXEffect.moveUpDMXDevice(o_DMXDeviceElement) && --intSelectedIndex >= 0) {
            this.jList_Devices.setSelectedIndex(intSelectedIndex);
        }
    }

    private void jButton_MoveDownActionPerformed(ActionEvent evt) {
        DMXEffect o_DMXEffect = this.m_DMXEffect;
        if (o_DMXEffect == null) {
            return;
        }
        int intSelectedIndex = this.jList_Devices.getSelectedIndex();
        DMXEffect.DMXDeviceElement o_DMXDeviceElement = o_DMXEffect.getDMXDeviceElement(intSelectedIndex);
        if (o_DMXDeviceElement == null) {
            return;
        }
        if (o_DMXEffect.moveDownDMXDevice(o_DMXDeviceElement)) {
            this.jList_Devices.setSelectedIndex(++intSelectedIndex);
        }
    }

    private void jButton_InvertDMXDeviceActionPerformed(ActionEvent evt) {
        DMXEffect o_DMXEffect = this.m_DMXEffect;
        if (o_DMXEffect == null) {
            return;
        }
        int intSelectedIndex = this.jList_Devices.getSelectedIndex();
        DMXEffect.DMXDeviceElement o_DMXDeviceElement = o_DMXEffect.getDMXDeviceElement(intSelectedIndex);
        if (o_DMXDeviceElement == null) {
            return;
        }
        o_DMXEffect.invertDMXDeviceElement(o_DMXDeviceElement);
        this.jList_Devices.setSelectedIndex(intSelectedIndex);
    }

    private void jButton_ShowDMXStageViewActionPerformed(ActionEvent evt) {
        LiveShowDMXStageView o_LiveShowDMXStageView = LiveShowDMXSystem.getLiveShowDMXStageView();
        if (o_LiveShowDMXStageView != null) {
            o_LiveShowDMXStageView.toFront();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        if (this.m_ListModelWrapper_DMXDevices != null) {
            this.m_ListModelWrapper_DMXDevices.setSelectedItem(this.jList_Devices.getSelectedValue());
        }
        this.refreshButtons();
    }
}

