/*
 * Decompiled with CFR 0.152.
 */
package DMXEffectsPackage;

import DMXDevicePackage.DMXDevice;
import DMXDevicePackage.DMXDeviceFilter;
import DMXEffectsPackage.DMXEffect_Function;
import DMXMixer.DMXControlComponent;
import DMXMixer.DMXControlDescription;
import DMXMixer.DMXControl_GridPanTilt_DeviceSettings;
import DMXScenePackage.DMXScene;
import DMXVirtualPackage.DMXFadeDescription;
import DMXVirtualPackage.LiveShowDMXObject;
import DMXVirtualPackage.LiveShowDMXVIP;
import DMXVirtualPackage.LiveShowDMXVIPAdjustment;
import GUID.LiveGUID;
import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LanguageTools.LiveLanguagePackage.LiveLanguageString;
import LiveShowObjectPackage.LiveShowProjectDescription;
import LiveShowObjectPackage.SinglePropertyChangeSupport;
import LiveShowPlayPackage.Playable;
import LiveShowVirtualPackage.LiveShow_ImportDescription;
import PlayDMXPackage.PlayDMX;
import SoundPackage.SoundMixers;
import SwingModelPackage.TableAndListModel;
import SwingToolTipPackage.PopUpToolTip;
import Text.NameExtension;
import ToolsGraphics.JLabelBackground;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Externalizable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;

public class DMXEffect
implements PropertyChangeListener,
Externalizable,
DMXDeviceFilter.FilterInterface {
    public static final int SOFTWAREVERSION = 1;
    public static final String FILESUFFIX = ".lsf";
    public static final int TRIGGER_TIMELINE = 0;
    public static final int TRIGGER_EXTRA = 1;
    public static final String PROP_DMXEFFECT_NAME = "dmxeffectName";
    public static final String PROP_DMXEFFECT_REMARK = "dmxeffectRemark";
    public static final String PROP_DMXEFFECT_CLOSING = "dmxeffectClosing";
    public static final String PROP_DMXEFFECT_EFFECTFUNCTION_ADDED = "dmxeffectFunctionAdded";
    public static final String PROP_DMXEFFECT_EFFECTFUNCTION_REMOVED = "dmxeffectFunctionRemoved";
    public static final String PROP_DMXEFFECT_DMXDEVICE_ADDED = "dmxeffectDMXDeviceAdded";
    public static final String PROP_DMXEFFECT_DMXDEVICE_REMOVED = "dmxeffectDMXDeviceRemoved";
    public static final String PROP_DMXEFFECT_DMXDEVICE_MOVED = "dmxeffectDMXDeviceMoved";
    public static final String PROP_DMXEFFECT_DMXDEVICE_INVERTED = "dmxeffectDMXDeviceInverted";
    public static final String PROP_DMXEFFECT_PARAMCHANGED = "dmxeffectParamChanged";
    public static long s_DefaultEffectDuration = (long)(SoundMixers.DEFAULT_AUDIOFORMAT.getFrameRate() * 4.0f);
    public static long s_DefaultEffectLoops = 0L;
    public static long s_DefaultEffectDelay = 0L;
    public static long s_DefaultEffectTrigger = 0L;
    public static DMXDeviceElementListRenderer s_DMXDeviceElementListRenderer = new DMXDeviceElementListRenderer();
    protected static DMXEffectTableModel s_DMXEffectTableModel = new DMXEffectTableModel();
    protected static DMXEffectListModel s_DMXEffectListModel = new DMXEffectListModel();
    protected static DMXEffectListRenderer s_DMXEffectListRenderer = new DMXEffectListRenderer();
    protected static DMXControlDescription.DMXControlDescriptionCellRenderer s_DMXControlDescriptionCellRenderer = new DMXControlDescription.DMXControlDescriptionCellRenderer();
    protected static ImageIcon s_Icon = new ImageIcon(DMXEffect.class.getResource("/IconsPackage/DMX_Effects_24.png"));
    protected static DMXControlDescription.DMXControlDescriptionListModel s_DMXControlDescriptionList = new DMXControlDescription.DMXControlDescriptionListModel();
    @LiveLanguageString
    public static String s_DefaultName = "Effect";
    @LiveLanguageString
    public static String s_ToolTip_Invert = "Indicates if the controls are inverted or not";
    @LiveLanguageString
    public static String s_ToolTip_FirstStepOn = "The first step where the device is on";
    protected String m_ID;
    protected String m_Name;
    protected String m_Remark;
    protected String m_ToolTipText;
    protected DMXDeviceElementListModel m_DMXDeviceElementListModel;
    protected TableAndListModel.ListModelWrapper<DMXDeviceElement> m_DMXDeviceElementListModelWarpper;
    protected TableAndListModel.ListModelWrapper<DMXControlDescription> m_DMXControlDescriptionsWrapper;
    protected HashMap<String, DMXEffect_Function> m_DMXEffect_Functions;
    protected int m_MaxSteps;
    protected SinglePropertyChangeSupport m_PropertyChangeSupport;
    protected boolean m_Closed;
    protected ArrayList<LiveShowDMXObject> m_LiveShowDMXObjects;
    protected LiveShow_ImportDescription m_LiveShow_ImportDescription;
    protected final Object m_SyncEffectFunctions = new Object();
    protected final Object m_SyncDMXDevices = new Object();
    protected final Object m_SyncDMXControlDescriptions = new Object();
    public static final int EFFECTPARAMCOUNT = 4;
    public static final int EFFECTPARAMINDEX_DURATION = 0;
    public static final int EFFECTPARAMINDEX_LOOPS = 1;
    public static final int EFFECTPARAMINDEX_DELAY = 2;
    public static final int EFFECTPARAMINDEX_TRIGGER = 3;

    public static long getDuration(ArrayList<Double> p_EffectParameters) {
        if (p_EffectParameters == null) {
            return -1L;
        }
        DMXEffect.checkEffectParameters(p_EffectParameters);
        long longMilliseconds = p_EffectParameters.get(0).longValue();
        return longMilliseconds;
    }

    public static long setDuration(DMXEffect p_DMXEffect, long p_Frames, ArrayList<Double> p_EffectParameters) {
        if (p_EffectParameters == null) {
            return 0L;
        }
        if (p_Frames < (long)(PlayDMX.BUFFER_MILLISECONDS * 2)) {
            p_Frames = PlayDMX.BUFFER_MILLISECONDS * 2;
        }
        DMXEffect.checkEffectParameters(p_EffectParameters);
        p_EffectParameters.set(0, Double.valueOf(p_Frames));
        return p_Frames;
    }

    public static long getDelay(ArrayList<Double> p_EffectParameters) {
        if (p_EffectParameters == null) {
            return -1L;
        }
        DMXEffect.checkEffectParameters(p_EffectParameters);
        long longMilliseconds = p_EffectParameters.get(2).longValue();
        return longMilliseconds;
    }

    public static long setDelay(DMXEffect p_DMXEffect, long p_Frames, ArrayList<Double> p_EffectParameters) {
        if (p_EffectParameters == null) {
            return 0L;
        }
        if (p_Frames < 0L) {
            p_Frames = 0L;
        }
        DMXEffect.checkEffectParameters(p_EffectParameters);
        p_EffectParameters.set(2, Double.valueOf(p_Frames));
        return p_Frames;
    }

    public static long getLoops(ArrayList<Double> p_EffectParameters) {
        if (p_EffectParameters == null) {
            return -1L;
        }
        DMXEffect.checkEffectParameters(p_EffectParameters);
        long longMilliseconds = p_EffectParameters.get(1).longValue();
        return longMilliseconds;
    }

    public static long setLoops(DMXEffect p_DMXEffect, long p_Loops, ArrayList<Double> p_EffectParameters) {
        if (p_EffectParameters == null) {
            return 0L;
        }
        if (p_Loops < 0L) {
            p_Loops = 0L;
        }
        DMXEffect.checkEffectParameters(p_EffectParameters);
        p_EffectParameters.set(1, Double.valueOf(p_Loops));
        return p_Loops;
    }

    public static int getTrigger(ArrayList<Double> p_EffectParameters) {
        if (p_EffectParameters == null) {
            return 0;
        }
        DMXEffect.checkEffectParameters(p_EffectParameters);
        int intTriggerFlag = p_EffectParameters.get(3).intValue();
        return intTriggerFlag;
    }

    public static int setTrigger(DMXEffect p_DMXEffect, int p_TriggerFlag, ArrayList<Double> p_EffectParameters) {
        if (p_TriggerFlag < 0) {
            p_TriggerFlag = 0;
        }
        if (p_TriggerFlag > 1) {
            p_TriggerFlag = 1;
        }
        DMXEffect.checkEffectParameters(p_EffectParameters);
        p_EffectParameters.set(3, Double.valueOf(p_TriggerFlag));
        return p_TriggerFlag;
    }

    public static void checkEffectParameters(ArrayList<Double> p_EffectParameters) {
        if (p_EffectParameters.size() < 4) {
            for (int intParam = p_EffectParameters.size(); intParam < 4; ++intParam) {
                double doubleValue = intParam == 0 ? (double)s_DefaultEffectDuration : (intParam == 1 ? (double)s_DefaultEffectLoops : (intParam == 2 ? (double)s_DefaultEffectDelay : (intParam == 3 ? (double)s_DefaultEffectTrigger : 0.0)));
                p_EffectParameters.add(doubleValue);
            }
        }
    }

    public static long getFramePosition(long p_Milliseconds) {
        if (p_Milliseconds < 0L) {
            return -1L;
        }
        return (long)((double)p_Milliseconds / LiveShowDMXVIP.getFRAMETIME());
    }

    public static boolean saveDMXEffects(LiveShowProjectDescription p_LiveShowProjectDescription, ArrayList<DMXEffect> p_DMXEffects) {
        if (p_LiveShowProjectDescription == null) {
            return false;
        }
        String stringFileName = p_LiveShowProjectDescription.getProjectPathName() + FILESUFFIX;
        try {
            File o_File = new File(stringFileName);
            if (o_File.exists()) {
                try {
                    o_File.delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            o_File.createNewFile();
            FileOutputStream o_FileOutputStream = new FileOutputStream(o_File);
            ObjectOutputStream o_ObjectOutput = new ObjectOutputStream(o_FileOutputStream);
            o_ObjectOutput.writeInt(1);
            if (p_DMXEffects == null) {
                int intDMXEffectCount = DMXEffect.getDMXEffectCount();
                o_ObjectOutput.writeInt(intDMXEffectCount);
                for (int intEffect = 0; intEffect < intDMXEffectCount; ++intEffect) {
                    DMXEffect o_DMXEffect = DMXEffect.getDMXEffect(intEffect);
                    if (o_DMXEffect == null) continue;
                    o_DMXEffect.writeExternal(o_ObjectOutput);
                }
            } else {
                int intDMXEffectCount = p_DMXEffects.size();
                o_ObjectOutput.writeInt(intDMXEffectCount);
                for (int intEffect = 0; intEffect < intDMXEffectCount; ++intEffect) {
                    DMXEffect o_DMXEffect = p_DMXEffects.get(intEffect);
                    if (o_DMXEffect == null) continue;
                    o_DMXEffect.writeExternal(o_ObjectOutput);
                }
            }
            o_ObjectOutput.close();
            o_FileOutputStream.close();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean loadDMXEffects(LiveShowProjectDescription p_LiveShowProjectDescription, LiveShow_ImportDescription p_LiveShow_ImportDescription) {
        if (p_LiveShowProjectDescription == null) {
            return false;
        }
        FileInputStream o_FileInputStream = null;
        ObjectInputStream o_ObjectInput = null;
        String stringFileName = p_LiveShowProjectDescription.getProjectPathName() + FILESUFFIX;
        try {
            File o_File = new File(stringFileName);
            o_FileInputStream = new FileInputStream(o_File);
            o_ObjectInput = new ObjectInputStream(o_FileInputStream);
            int intSoftwareVersion = o_ObjectInput.readInt();
            int intDMXEffectCount = o_ObjectInput.readInt();
            for (int intEffect = 0; intEffect < intDMXEffectCount; ++intEffect) {
                DMXEffect o_DMXEffect = new DMXEffect();
                o_DMXEffect.setLiveShow_ImportDescription(p_LiveShow_ImportDescription);
                o_DMXEffect.readExternal(o_ObjectInput);
                if (DMXEffect.contains(o_DMXEffect.getID())) {
                    o_DMXEffect.close();
                    continue;
                }
                if (p_LiveShow_ImportDescription == null || p_LiveShow_ImportDescription.getLoadNewProject()) {
                    DMXEffect.addDMXEffect(o_DMXEffect);
                    continue;
                }
                String stringDMXEffectName = o_DMXEffect.getName();
                stringDMXEffectName = LiveShow_ImportDescription.createImportedName(stringDMXEffectName);
                o_DMXEffect.setName(stringDMXEffectName);
                DMXEffect.addDMXEffect(o_DMXEffect);
            }
            o_ObjectInput.close();
            o_FileInputStream.close();
        }
        catch (Exception e) {
            try {
                if (o_ObjectInput != null) {
                    o_ObjectInput.close();
                }
                if (o_FileInputStream != null) {
                    o_FileInputStream.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
        return true;
    }

    public static boolean deleteDMXEffects(LiveShowProjectDescription p_LiveShowProjectDescription) {
        if (p_LiveShowProjectDescription == null) {
            return false;
        }
        boolean boolSuccess = false;
        String stringFileName = p_LiveShowProjectDescription.getProjectPathName() + FILESUFFIX;
        File o_File = new File(stringFileName);
        if (o_File.exists()) {
            try {
                boolSuccess = o_File.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return boolSuccess;
    }

    public DMXEffect() {
        this("");
    }

    public DMXEffect(String p_Name) {
        this.initMembers();
        LiveLanguage.addLanguageListener((Object)this, null);
        this.m_Name = this.createName(p_Name);
        this.createToolTipText();
    }

    private void initMembers() {
        this.m_DMXDeviceElementListModel = new DMXDeviceElementListModel();
        this.m_DMXDeviceElementListModelWarpper = this.m_DMXDeviceElementListModel.createListModelWrapper();
        this.m_DMXEffect_Functions = new HashMap();
        this.m_MaxSteps = 0;
        this.m_ID = LiveGUID.getUID();
        this.m_Remark = "";
        this.m_ToolTipText = null;
        this.m_Closed = false;
        this.m_PropertyChangeSupport = new SinglePropertyChangeSupport(this);
        this.addDMXControlDescription(DMXControlDescription.getDMXControlDescription("dimmer"));
        this.addDMXControlDescription(DMXControlDescription.getDMXControlDescription("rgbcmy"));
        this.addDMXControlDescription(DMXControlDescription.getDMXControlDescription("colorwhite"));
        this.addDMXControlDescription(DMXControlDescription.getDMXControlDescription("colorwhitecold"));
        this.addDMXControlDescription(DMXControlDescription.getDMXControlDescription("colorwhitewarm"));
        this.addDMXControlDescription(DMXControlDescription.getDMXControlDescription("coloramber"));
        this.addDMXControlDescription(DMXControlDescription.getDMXControlDescription("coloruv"));
        this.addDMXControlDescription(DMXControlDescription.getDMXControlDescription("colorlime"));
        this.addDMXControlDescription(DMXControlDescription.getDMXControlDescription("colorcyan"));
        this.addDMXControlDescription(DMXControlDescription.getDMXControlDescription("colormagenta"));
        this.addDMXControlDescription(DMXControlDescription.getDMXControlDescription("coloryellow"));
        this.addDMXControlDescription(DMXControlDescription.getDMXControlDescription("pantilt"));
        this.addDMXControlDescription(DMXControlDescription.getDMXControlDescription("duration"));
        this.addDMXControlDescription(DMXControlDescription.getDMXControlDescription("intensity"));
        this.addDMXControlDescription(DMXControlDescription.getDMXControlDescription("deflection"));
        this.addDMXControlDescription(DMXControlDescription.getDMXControlDescription("iris"));
        this.addDMXControlDescription(DMXControlDescription.getDMXControlDescription("zoom"));
        this.addDMXControlDescription(DMXControlDescription.getDMXControlDescription("focus"));
        this.addDMXControlDescription(DMXControlDescription.getDMXControlDescription("programs"));
        DMXDevice.getTreeModel_Device_Channels().addPropertyChangeListener(this);
        this.m_LiveShow_ImportDescription = null;
        this.m_LiveShowDMXObjects = new ArrayList();
        DMXDeviceFilter.createDMXDeviceFilter(this);
    }

    public void close() {
        if (this.m_Closed) {
            return;
        }
        DMXDeviceFilter.removeDMXDeviceFilter(this);
        this.m_PropertyChangeSupport.firePropertyChange(PROP_DMXEFFECT_CLOSING, this, null);
        this.m_Closed = true;
        this.clear();
        this.m_PropertyChangeSupport.clear();
        s_DMXEffectListModel.removeDMXEffect(this);
        s_DMXEffectTableModel.removeDMXEffect(this);
    }

    public void clear() {
        Object[] o_IDs = this.m_DMXEffect_Functions.keySet().toArray();
        for (int intID = 0; intID < o_IDs.length; ++intID) {
            String stringID = (String)o_IDs[intID];
            this.removeDMXEffectFunction(stringID);
        }
        ArrayList<DMXDeviceElement> o_DMXDeviceElements = this.m_DMXDeviceElementListModel.getDMXDeviceElements();
        for (int intElement = o_DMXDeviceElements.size() - 1; intElement >= 0; --intElement) {
            DMXDeviceElement o_DMXDeviceElement = o_DMXDeviceElements.get(intElement);
            this.removeDMXDeviceElement(o_DMXDeviceElement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(1);
        out.writeUTF(this.m_ID);
        out.writeUTF(this.m_Name);
        out.writeUTF(this.m_Remark);
        Object object = this.m_SyncDMXDevices;
        synchronized (object) {
            out.writeInt(this.m_DMXDeviceElementListModel.size());
            for (int intDMXDevice = 0; intDMXDevice < this.m_DMXDeviceElementListModel.size(); ++intDMXDevice) {
                DMXDeviceElement o_DMXDeviceElement = (DMXDeviceElement)this.m_DMXDeviceElementListModel.get(intDMXDevice);
                DMXDevice o_DMXDevice = o_DMXDeviceElement.getDMXDevice();
                out.writeUTF(o_DMXDevice.getID());
                out.writeBoolean(o_DMXDeviceElement.getInvertedControls());
            }
        }
        Object object2 = this.m_SyncEffectFunctions;
        synchronized (object2) {
            Iterator<DMXEffect_Function> o_IteratorDMXEffect_Function = this.m_DMXEffect_Functions.values().iterator();
            out.writeInt(this.m_DMXEffect_Functions.size());
            while (o_IteratorDMXEffect_Function.hasNext()) {
                DMXEffect_Function o_DMXEffect_Function = o_IteratorDMXEffect_Function.next();
                out.writeUTF(o_DMXEffect_Function.getDMXControlDescriptionID());
                o_DMXEffect_Function.writeExternal(out);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        DMXDeviceElement o_DMXDeviceElement;
        int intSoftwareVersion = in.readInt();
        this.m_ID = in.readUTF();
        this.m_Name = in.readUTF();
        this.m_Remark = in.readUTF();
        Object object = this.m_SyncDMXDevices;
        synchronized (object) {
            int intDMXDeviceCount = in.readInt();
            for (int intDMXDevice = 0; intDMXDevice < intDMXDeviceCount; ++intDMXDevice) {
                LiveShow_ImportDescription o_LiveShow_ImportDescription;
                String stringDMXDeviceID = in.readUTF();
                boolean boolInvertedControls = in.readBoolean();
                DMXDevice o_DMXDevice = DMXDevice.getDMXDevice(stringDMXDeviceID);
                if (o_DMXDevice == null && (o_LiveShow_ImportDescription = this.getLiveShow_ImportDescription()) != null) {
                    stringDMXDeviceID = o_LiveShow_ImportDescription.getDMXDeviceIDReplacement(stringDMXDeviceID);
                    o_DMXDevice = DMXDevice.getDMXDevice(stringDMXDeviceID);
                }
                if (o_DMXDevice == null) continue;
                o_DMXDeviceElement = new DMXDeviceElement(this, o_DMXDevice);
                o_DMXDeviceElement.setInvertedControls(boolInvertedControls);
                this.m_DMXDeviceElementListModel.addDMXDeviceElement(o_DMXDeviceElement);
            }
        }
        Object object2 = this.m_SyncEffectFunctions;
        synchronized (object2) {
            int intDMXEffect_FunctionCount = in.readInt();
            for (int intFunction = 0; intFunction < intDMXEffect_FunctionCount; ++intFunction) {
                String stringDMXcontrolDescriptionID = in.readUTF();
                DMXControlDescription o_DMXControlDescription = DMXControlDescription.getDMXControlDescription(stringDMXcontrolDescriptionID);
                DMXEffect_Function o_DMXEffect_Function = new DMXEffect_Function(this, o_DMXControlDescription);
                for (int intDMXDevice = 0; intDMXDevice < this.m_DMXDeviceElementListModel.size(); ++intDMXDevice) {
                    o_DMXDeviceElement = (DMXDeviceElement)this.m_DMXDeviceElementListModel.get(intDMXDevice);
                    o_DMXEffect_Function.addDMXDeviceElement(this, o_DMXDeviceElement);
                }
                o_DMXEffect_Function.readExternal(in);
                if (o_DMXControlDescription == null) continue;
                this.m_DMXEffect_Functions.put(o_DMXControlDescription.getID(), o_DMXEffect_Function);
            }
        }
        this.calculateIsOnSteps();
        this.createToolTipText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DMXEffect clone(DMXEffect p_DMXEffect) {
        if (p_DMXEffect == null) {
            p_DMXEffect = new DMXEffect(this.m_Name);
        } else {
            p_DMXEffect.clear();
        }
        Object object = this.m_SyncDMXDevices;
        synchronized (object) {
            int intDMXDeviceCount = this.m_DMXDeviceElementListModel.size();
            for (int intDMXDevice = 0; intDMXDevice < intDMXDeviceCount; ++intDMXDevice) {
                DMXDeviceElement o_DMXDeviceElement = (DMXDeviceElement)this.m_DMXDeviceElementListModel.get(intDMXDevice);
                if (o_DMXDeviceElement == null) continue;
                DMXDevice o_DMXDevice = o_DMXDeviceElement.getDMXDevice();
                DMXDeviceElement dMXDeviceElement = p_DMXEffect.addDMXDevice(intDMXDevice, o_DMXDevice);
            }
        }
        Object object2 = this.m_SyncEffectFunctions;
        synchronized (object2) {
            for (DMXEffect_Function o_DMXEffect_Function : this.m_DMXEffect_Functions.values()) {
                if (o_DMXEffect_Function == null) continue;
                DMXEffect_Function o_NewDMXEffect_Function = p_DMXEffect.createDMXEffectFunction(o_DMXEffect_Function.getDMXControlDescription());
                o_DMXEffect_Function.clone(o_NewDMXEffect_Function);
            }
        }
        p_DMXEffect.calculateIsOnSteps();
        return p_DMXEffect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDiskSpaceEstimated() {
        long longDiskspace = 0L;
        longDiskspace += 4L;
        longDiskspace += (long)(this.m_ID.length() * 2);
        longDiskspace += (long)(this.m_Name.length() * 2);
        longDiskspace += (long)(this.m_Remark.length() * 2);
        longDiskspace += 8L;
        Object object = this.m_SyncDMXDevices;
        synchronized (object) {
            for (int intDMXDevice = 0; intDMXDevice < this.m_DMXDeviceElementListModel.size(); ++intDMXDevice) {
                DMXDeviceElement o_DMXDeviceElement = (DMXDeviceElement)this.m_DMXDeviceElementListModel.get(intDMXDevice);
                if (o_DMXDeviceElement == null) continue;
                longDiskspace += (long)(o_DMXDeviceElement.getDMXDeviceID().length() * 2);
            }
        }
        Object object2 = this.m_SyncEffectFunctions;
        synchronized (object2) {
            for (DMXEffect_Function o_DMXEffect_Function : this.m_DMXEffect_Functions.values()) {
                longDiskspace += o_DMXEffect_Function.getDiskSpaceEstimated();
            }
        }
        return longDiskspace;
    }

    public void setLiveShow_ImportDescription(LiveShow_ImportDescription p_LiveShow_ImportDescription) {
        this.m_LiveShow_ImportDescription = p_LiveShow_ImportDescription;
    }

    public LiveShow_ImportDescription getLiveShow_ImportDescription() {
        return this.m_LiveShow_ImportDescription;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eventStepCount(DMXEffect_Function p_DMXEffect_Function) {
        int intStepCountMax = 0;
        int intStepCount = 0;
        if (p_DMXEffect_Function != null) {
            intStepCountMax = p_DMXEffect_Function.getStepCount();
        }
        Object object = this.m_SyncEffectFunctions;
        synchronized (object) {
            for (DMXEffect_Function o_DMXEffect_Function : this.m_DMXEffect_Functions.values()) {
                intStepCount = o_DMXEffect_Function.getStepCount();
                if (intStepCount <= intStepCountMax) continue;
                intStepCountMax = intStepCount;
            }
            if (this.m_MaxSteps != intStepCountMax) {
                int intOldValue = this.m_MaxSteps;
                this.m_MaxSteps = intStepCountMax;
                this.m_PropertyChangeSupport.firePropertyChange(PROP_DMXEFFECT_PARAMCHANGED, intOldValue, this.m_MaxSteps);
            }
        }
    }

    public int getMaxStepCount() {
        return this.m_MaxSteps;
    }

    public void addLiveShowDMXObject(LiveShowDMXObject p_LiveShowDMXObject) {
        if (p_LiveShowDMXObject == null) {
            return;
        }
        if (this.m_LiveShowDMXObjects.contains(p_LiveShowDMXObject)) {
            return;
        }
        this.m_LiveShowDMXObjects.add(p_LiveShowDMXObject);
    }

    public void removeLiveShowDMXObject(LiveShowDMXObject p_LiveShowDMXObject) {
        if (p_LiveShowDMXObject == null) {
            return;
        }
        if (!this.m_LiveShowDMXObjects.contains(p_LiveShowDMXObject)) {
            return;
        }
        this.m_LiveShowDMXObjects.remove(p_LiveShowDMXObject);
    }

    public int getLiveShowDMXObjectCount() {
        return this.m_LiveShowDMXObjects.size();
    }

    public String getID() {
        return this.m_ID;
    }

    public void setID(String p_ID) {
        this.m_ID = p_ID == null ? LiveGUID.getUID() : p_ID;
    }

    public String createName(String p_Name) {
        int intPrefixCount = 0;
        int intMaxPostFix = 0;
        String stringPrefix = p_Name == null || p_Name.length() <= 0 ? s_DefaultName : NameExtension.getPrefix(p_Name);
        for (int intEffect = 0; intEffect < DMXEffect.getDMXEffectCount(); ++intEffect) {
            int intPostfix;
            DMXEffect o_DMXEffect = DMXEffect.getDMXEffect(intEffect);
            if (o_DMXEffect == null || (intPostfix = NameExtension.getPostfix_Int(o_DMXEffect.getName(), stringPrefix)) == -2) continue;
            if (intPostfix == -1) {
                intPostfix = ++intPrefixCount;
            }
            if (intPostfix <= intMaxPostFix) continue;
            intMaxPostFix = intPostfix;
        }
        return NameExtension.createName(stringPrefix, ++intMaxPostFix, "000", true);
    }

    @Override
    public String getName() {
        return this.m_Name;
    }

    public void setName(String p_Name) {
        if (p_Name == null) {
            return;
        }
        if (p_Name.equals(this.m_Name)) {
            return;
        }
        String oldValue = this.m_Name;
        this.m_Name = p_Name;
        this.createToolTipText();
        this.m_PropertyChangeSupport.firePropertyChange(PROP_DMXEFFECT_NAME, oldValue, this.m_Name);
    }

    public void setRemark(String p_Remark) {
        if (p_Remark == null) {
            return;
        }
        if (p_Remark.equals(this.m_Remark)) {
            return;
        }
        String oldValue = this.m_Remark;
        this.m_Remark = p_Remark;
        this.createToolTipText();
        this.m_PropertyChangeSupport.firePropertyChange(PROP_DMXEFFECT_REMARK, oldValue, this.m_Remark);
    }

    @Override
    public String getRemark() {
        return this.m_Remark;
    }

    public String createToolTipText() {
        StringBuilder o_StringBuilder = new StringBuilder();
        o_StringBuilder.append("<html>");
        o_StringBuilder.append(this.m_Name);
        o_StringBuilder.append("<br>");
        o_StringBuilder.append(this.m_Remark);
        o_StringBuilder.append("</html>");
        this.m_ToolTipText = o_StringBuilder.toString();
        return this.m_ToolTipText;
    }

    public String getToolTipText() {
        return this.m_ToolTipText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DMXEffect_Function createDMXEffectFunction(DMXControlDescription p_DMXControlDescription) {
        ArrayList o_DMXDeviceElements;
        if (p_DMXControlDescription == null) {
            return null;
        }
        DMXEffect_Function o_DMXEffect_Function = this.getDMXEffect_Function(p_DMXControlDescription.getID());
        if (o_DMXEffect_Function != null) {
            return o_DMXEffect_Function;
        }
        o_DMXEffect_Function = new DMXEffect_Function(this, p_DMXControlDescription);
        Object object = this.m_SyncEffectFunctions;
        synchronized (object) {
            this.m_DMXEffect_Functions.put(p_DMXControlDescription.getID(), o_DMXEffect_Function);
        }
        object = this.m_SyncDMXDevices;
        synchronized (object) {
            o_DMXDeviceElements = this.m_DMXDeviceElementListModel.getElementArrayList_Safe();
        }
        for (int intDMXDevice = 0; intDMXDevice < o_DMXDeviceElements.size(); ++intDMXDevice) {
            DMXDeviceElement o_DMXDeviceElement = (DMXDeviceElement)o_DMXDeviceElements.get(intDMXDevice);
            o_DMXEffect_Function.addDMXDeviceElement(this, o_DMXDeviceElement);
        }
        this.m_PropertyChangeSupport.firePropertyChange(PROP_DMXEFFECT_EFFECTFUNCTION_ADDED, null, o_DMXEffect_Function);
        return o_DMXEffect_Function;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DMXEffect_Function getDMXEffect_Function(String p_DMXControlTypeDescriptionID) {
        Object object = this.m_SyncEffectFunctions;
        synchronized (object) {
            return this.m_DMXEffect_Functions.get(p_DMXControlTypeDescriptionID);
        }
    }

    public DMXEffect_Function removeDMXEffectFunction(DMXControlDescription p_DMXControlDescription) {
        if (p_DMXControlDescription == null) {
            return null;
        }
        return this.removeDMXEffectFunction(p_DMXControlDescription.getID());
    }

    public DMXEffect_Function removeDMXEffectFunction(String p_DMXControlTypeDescriptionID) {
        if (p_DMXControlTypeDescriptionID == null) {
            return null;
        }
        DMXEffect_Function o_DMXEffect_Function = this.getDMXEffect_Function(p_DMXControlTypeDescriptionID);
        return this.removeDMXEffectFunction(o_DMXEffect_Function);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DMXEffect_Function removeDMXEffectFunction(DMXEffect_Function p_DMXEffect_Function) {
        DMXEffect_Function o_DMXEffect_Function;
        if (p_DMXEffect_Function == null) {
            return null;
        }
        Object object = this.m_SyncEffectFunctions;
        synchronized (object) {
            o_DMXEffect_Function = this.m_DMXEffect_Functions.remove(p_DMXEffect_Function.getDMXControlDescriptionID());
        }
        if (o_DMXEffect_Function == null) {
            return null;
        }
        o_DMXEffect_Function.close();
        this.eventStepCount(null);
        this.m_PropertyChangeSupport.firePropertyChange(PROP_DMXEFFECT_EFFECTFUNCTION_REMOVED, o_DMXEffect_Function, null);
        this.calculateIsOnSteps();
        return o_DMXEffect_Function;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDMXEffectFunctionCount() {
        Object object = this.m_SyncEffectFunctions;
        synchronized (object) {
            return this.m_DMXEffect_Functions.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getDMXEffectFunctionControlIDs() {
        Set<String> o_SetIDs;
        Object object = this.m_SyncEffectFunctions;
        synchronized (object) {
            o_SetIDs = this.m_DMXEffect_Functions.keySet();
        }
        return o_SetIDs.toArray();
    }

    public DMXDeviceElement addDMXDevice(DMXDevice p_DMXDevice) {
        int intIndex = -1;
        intIndex = this.m_DMXDeviceElementListModel.getSize();
        return this.addDMXDevice(intIndex, p_DMXDevice);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DMXDeviceElement addDMXDevice(int p_Index, DMXDevice p_DMXDevice) {
        ArrayList<DMXEffect_Function> o_DMXEffect_Functions;
        DMXDeviceElement o_DMXDeviceElement;
        if (p_DMXDevice == null) {
            return null;
        }
        Object object = this.m_SyncDMXDevices;
        synchronized (object) {
            o_DMXDeviceElement = this.m_DMXDeviceElementListModel.getElement(p_DMXDevice);
            if (o_DMXDeviceElement != null) {
                return o_DMXDeviceElement;
            }
            o_DMXDeviceElement = new DMXDeviceElement(this, p_DMXDevice);
            this.m_DMXDeviceElementListModel.addDMXDeviceElement(p_Index, o_DMXDeviceElement);
        }
        object = this.m_SyncEffectFunctions;
        synchronized (object) {
            o_DMXEffect_Functions = new ArrayList<DMXEffect_Function>(this.m_DMXEffect_Functions.size());
            o_DMXEffect_Functions.addAll(this.m_DMXEffect_Functions.values());
        }
        for (int intFunction = 0; intFunction < o_DMXEffect_Functions.size(); ++intFunction) {
            DMXEffect_Function o_DMXEffect_Function = (DMXEffect_Function)o_DMXEffect_Functions.get(intFunction);
            o_DMXEffect_Function.addDMXDeviceElement(this, o_DMXDeviceElement);
        }
        this.m_PropertyChangeSupport.firePropertyChange(PROP_DMXEFFECT_DMXDEVICE_ADDED, null, p_DMXDevice);
        return o_DMXDeviceElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDMXDevice(DMXDevice p_DMXDevice) {
        DMXDeviceElement o_DMXDeviceElement;
        if (p_DMXDevice == null) {
            return;
        }
        Object object = this.m_SyncDMXDevices;
        synchronized (object) {
            o_DMXDeviceElement = this.m_DMXDeviceElementListModel.getElement(p_DMXDevice);
            if (o_DMXDeviceElement == null) {
                return;
            }
        }
        p_DMXDevice.removePropertyChangeListener(this);
        this.removeDMXDeviceElement(o_DMXDeviceElement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceDMXDevice(DMXDevice p_DMXDevice, DMXDevice p_DMXDeviceReplacer) {
        ArrayList<DMXEffect_Function> o_DMXEffect_Functions;
        if (p_DMXDevice == null || p_DMXDeviceReplacer == null) {
            return;
        }
        if (!this.containsDMXDevice(p_DMXDevice)) {
            return;
        }
        if (this.containsDMXDevice(p_DMXDeviceReplacer)) {
            return;
        }
        int intIndex = this.getIndexOf(p_DMXDevice);
        if (intIndex < 0) {
            return;
        }
        DMXDeviceElement o_DMXDeviceElement = this.getDMXDeviceElement(p_DMXDevice);
        if (o_DMXDeviceElement == null) {
            return;
        }
        DMXDeviceElement o_DMXDeviceElementReplacer = this.addDMXDevice(intIndex + 1, p_DMXDeviceReplacer);
        if (o_DMXDeviceElementReplacer == null) {
            return;
        }
        Object object = this.m_SyncEffectFunctions;
        synchronized (object) {
            o_DMXEffect_Functions = new ArrayList<DMXEffect_Function>(this.m_DMXEffect_Functions.size());
            o_DMXEffect_Functions.addAll(this.m_DMXEffect_Functions.values());
        }
        int intDMXEffectElementsToChange = 0;
        for (int intFunction = 0; intFunction < o_DMXEffect_Functions.size(); ++intFunction) {
            DMXEffect_Function o_DMXEffect_Function = (DMXEffect_Function)o_DMXEffect_Functions.get(intFunction);
            if (o_DMXEffect_Function == null) continue;
            ArrayList<DMXEffect_Function.DMXEffectElement> o_DMXEffectElements = o_DMXEffect_Function.getDMXEffectElements(o_DMXDeviceElement);
            ArrayList<DMXEffect_Function.DMXEffectElement> o_DMXEffectElementsReplacer = o_DMXEffect_Function.getDMXEffectElements(o_DMXDeviceElementReplacer);
            if (o_DMXEffectElements == null || o_DMXEffectElements.size() <= 0 || o_DMXEffectElementsReplacer == null || o_DMXEffectElementsReplacer.size() <= 0) continue;
            intDMXEffectElementsToChange = o_DMXEffectElements.size();
            if (o_DMXEffectElements.size() != o_DMXEffectElementsReplacer.size()) {
                intDMXEffectElementsToChange = o_DMXEffectElements.size() > o_DMXEffectElementsReplacer.size() ? o_DMXEffectElementsReplacer.size() : o_DMXEffectElements.size();
            }
            for (int intDMXEffectElement = 0; intDMXEffectElement < intDMXEffectElementsToChange; ++intDMXEffectElement) {
                DMXEffect_Function.DMXEffectElement o_DMXEffectElement = o_DMXEffectElements.get(intDMXEffectElement);
                DMXEffect_Function.DMXEffectElement o_DMXEffectElementReplacer = o_DMXEffectElementsReplacer.get(intDMXEffectElement);
                for (int intStep = 0; intStep < o_DMXEffect_Function.getStepCount(); ++intStep) {
                    ArrayList<Double> o_Values = o_DMXEffect_Function.getValuesToReplace(intStep, o_DMXEffectElement);
                    DMXControl_GridPanTilt_DeviceSettings.VirtualPoint o_VirtualPoint = o_DMXEffect_Function.getVirtualPoint(intStep, o_DMXEffectElement);
                    if (o_VirtualPoint != null) {
                        Point2D o_Point2D_Dest = DMXControl_GridPanTilt_DeviceSettings.calculateAnglesFromVirtualPoint(null, p_DMXDeviceReplacer, o_VirtualPoint);
                        if (o_Point2D_Dest != null) {
                            o_Values.set(0, o_Point2D_Dest.getX());
                            o_Values.set(1, o_Point2D_Dest.getY());
                            DMXControl_GridPanTilt_DeviceSettings.VirtualPoint o_VirtualPointReplacer = new DMXControl_GridPanTilt_DeviceSettings.VirtualPoint();
                            o_VirtualPoint.clone(o_VirtualPointReplacer);
                            o_DMXEffect_Function.setValuesToReplace(intStep, o_DMXEffectElementReplacer, o_Values, o_VirtualPointReplacer);
                            continue;
                        }
                        o_DMXEffect_Function.setValuesToReplace(intStep, o_DMXEffectElementReplacer, o_Values, null);
                        continue;
                    }
                    o_DMXEffect_Function.setValuesToReplace(intStep, o_DMXEffectElementReplacer, o_Values, null);
                }
            }
        }
        this.calculateIsOnSteps();
    }

    public void addDMXDevices(ArrayList<DMXDevice> p_DMXDevices) {
        if (p_DMXDevices == null) {
            return;
        }
        int intDMXDeviceCount = this.getDMXDeviceCount();
        for (int intDevice = 0; intDevice < p_DMXDevices.size(); ++intDevice) {
            DMXDevice o_DMXDevice = p_DMXDevices.get(intDevice);
            this.addDMXDevice(intDMXDeviceCount + intDevice, o_DMXDevice);
        }
    }

    public void removeDMXDevices(ArrayList<DMXDevice> p_DMXDevices) {
        if (p_DMXDevices == null) {
            return;
        }
        for (int intDevice = 0; intDevice < p_DMXDevices.size(); ++intDevice) {
            DMXDevice o_DMXDevice = p_DMXDevices.get(intDevice);
            this.removeDMXDevice(o_DMXDevice);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDMXDeviceElement(DMXDeviceElement p_DMXDeviceElement) {
        ArrayList<DMXEffect_Function> o_DMXEffect_Functions;
        if (p_DMXDeviceElement == null) {
            return;
        }
        Object object = this.m_SyncDMXDevices;
        synchronized (object) {
            if (!this.m_DMXDeviceElementListModel.contains(p_DMXDeviceElement)) {
                return;
            }
            this.m_DMXDeviceElementListModel.removeDMXDeviceElement(p_DMXDeviceElement);
        }
        object = this.m_SyncEffectFunctions;
        synchronized (object) {
            o_DMXEffect_Functions = new ArrayList<DMXEffect_Function>(this.m_DMXEffect_Functions.size());
            o_DMXEffect_Functions.addAll(this.m_DMXEffect_Functions.values());
        }
        for (int intFunction = 0; intFunction < o_DMXEffect_Functions.size(); ++intFunction) {
            DMXEffect_Function o_DMXEffect_Function = (DMXEffect_Function)o_DMXEffect_Functions.get(intFunction);
            o_DMXEffect_Function.removeDMXDeviceElement(p_DMXDeviceElement);
        }
        this.m_PropertyChangeSupport.firePropertyChange(PROP_DMXEFFECT_DMXDEVICE_REMOVED, p_DMXDeviceElement.getDMXDevice(), null);
    }

    public int getDMXDeviceCount() {
        return this.m_DMXDeviceElementListModel.size();
    }

    public DMXDeviceElement getDMXDeviceElement(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        DMXDeviceElement o_DMXDeviceElement = (DMXDeviceElement)this.m_DMXDeviceElementListModel.get(p_Index);
        return o_DMXDeviceElement;
    }

    public DMXDeviceElement getDMXDeviceElement(DMXDevice p_DMXDevice) {
        if (p_DMXDevice == null) {
            return null;
        }
        DMXDeviceElement o_DMXDeviceElement = this.m_DMXDeviceElementListModel.getElement(p_DMXDevice);
        return o_DMXDeviceElement;
    }

    public DMXDevice getDMXDevice(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        DMXDeviceElement o_DMXDeviceElement = (DMXDeviceElement)this.m_DMXDeviceElementListModel.get(p_Index);
        if (o_DMXDeviceElement == null) {
            return null;
        }
        return o_DMXDeviceElement.getDMXDevice();
    }

    public int getIndexOf(DMXDeviceElement p_DMXDeviceElement) {
        if (p_DMXDeviceElement == null) {
            return -1;
        }
        return this.m_DMXDeviceElementListModel.indexOf(p_DMXDeviceElement);
    }

    public int getIndexOf(DMXDevice p_DMXDevice) {
        if (p_DMXDevice == null) {
            return -1;
        }
        return this.m_DMXDeviceElementListModel.getIndexOf(p_DMXDevice);
    }

    public boolean contains(DMXDevice p_DMXDevice) {
        return this.getIndexOf(p_DMXDevice) >= 0;
    }

    public boolean moveUpDMXDevice(DMXDeviceElement p_DMXDeviceElement) {
        if (p_DMXDeviceElement == null) {
            return false;
        }
        if (this.m_DMXDeviceElementListModel.moveUp(p_DMXDeviceElement)) {
            this.resortDMXEffectFunctions(p_DMXDeviceElement);
            this.m_PropertyChangeSupport.firePropertyChange(PROP_DMXEFFECT_DMXDEVICE_MOVED, null, p_DMXDeviceElement);
            this.calculateIsOnSteps();
            return true;
        }
        return false;
    }

    public boolean moveDownDMXDevice(DMXDeviceElement p_DMXDeviceElement) {
        if (p_DMXDeviceElement == null) {
            return false;
        }
        if (this.m_DMXDeviceElementListModel.moveDown(p_DMXDeviceElement)) {
            this.resortDMXEffectFunctions(p_DMXDeviceElement);
            this.m_PropertyChangeSupport.firePropertyChange(PROP_DMXEFFECT_DMXDEVICE_MOVED, null, p_DMXDeviceElement);
            this.calculateIsOnSteps();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eventDMXDeviceTypeChanged(DMXDevice p_DMXDevice) {
        DMXDeviceElement o_DMXDeviceElement;
        Object object = this.m_SyncDMXDevices;
        synchronized (object) {
            o_DMXDeviceElement = this.m_DMXDeviceElementListModel.getElement(p_DMXDevice);
            if (o_DMXDeviceElement == null) {
                return;
            }
        }
        object = this.m_SyncEffectFunctions;
        synchronized (object) {
            for (DMXEffect_Function o_DMXEffect_Function : this.m_DMXEffect_Functions.values()) {
                o_DMXEffect_Function.refreshDMXDeviceType(this, o_DMXDeviceElement);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invertDMXDeviceElement(DMXDeviceElement p_DMXDeviceElement) {
        if (p_DMXDeviceElement == null) {
            return;
        }
        Object object = this.m_SyncDMXDevices;
        synchronized (object) {
            if (!this.m_DMXDeviceElementListModel.contains(p_DMXDeviceElement)) {
                return;
            }
        }
        boolean boolInverted = p_DMXDeviceElement.getInvertedControls();
        p_DMXDeviceElement.setInvertedControls(!boolInverted);
        object = this.m_SyncEffectFunctions;
        synchronized (object) {
            for (DMXEffect_Function o_DMXEffect_Function : this.m_DMXEffect_Functions.values()) {
                o_DMXEffect_Function.invertDMXControls(p_DMXDeviceElement);
            }
        }
        this.m_PropertyChangeSupport.firePropertyChange(PROP_DMXEFFECT_DMXDEVICE_INVERTED, null, p_DMXDeviceElement);
    }

    public boolean calculateIsOnSteps(DMXDevice p_DMXDevice) {
        DMXDeviceElement o_DMXDeviceElement = this.m_DMXDeviceElementListModel.getElement(p_DMXDevice);
        if (o_DMXDeviceElement == null) {
            return false;
        }
        return o_DMXDeviceElement.calculateIsOnSteps();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void calculateIsOnSteps() {
        Object object = this.m_SyncDMXDevices;
        synchronized (object) {
            for (int intDMXDevice = 0; intDMXDevice < this.m_DMXDeviceElementListModel.size(); ++intDMXDevice) {
                DMXDeviceElement o_DMXDeviceElement = (DMXDeviceElement)this.m_DMXDeviceElementListModel.get(intDMXDevice);
                if (o_DMXDeviceElement == null) continue;
                o_DMXDeviceElement.calculateIsOnSteps();
            }
        }
    }

    public boolean containsDMXDevice(DMXDevice p_DMXDevice) {
        if (p_DMXDevice == null) {
            return false;
        }
        DMXDeviceElement o_DMXDeviceElement = this.getDMXDeviceElement(p_DMXDevice);
        return o_DMXDeviceElement != null;
    }

    public void readLiveShowDMXObject(LiveShowDMXObject p_LiveShowDMXObject, PlayDMX.DMXPlayObject p_DMXPlayObject, long p_FrameInsideObject, DMXScene.DMXSceneValueContainer p_DMXSceneValueContainer, float p_VolumeFactor, double p_FadeFactor, boolean p_FadeIn, boolean p_FadeOut) {
        int intDMXDeviceCont = DMXDevice.getDMXDeviceCount();
        DMXScene.DMXSceneValueContainer o_PlayObjectValueContainer = p_DMXPlayObject.getDMXSceneValueContainer();
        DMXFadeDescription o_DMXFadeDescription = p_LiveShowDMXObject.getDMXFadeDescription();
        boolean boolFunctionsFound = false;
        for (int intDevice = 0; intDevice < intDMXDeviceCont; ++intDevice) {
            DMXDevice o_DMXDevice = DMXDevice.getDMXDevice(intDevice);
            if (o_DMXDevice == null) continue;
            DMXScene.DMXSceneDeviceValues o_PlayDMXSceneDeviceValues = o_PlayObjectValueContainer.getDMXSceneDeviceValues(o_DMXDevice.getID());
            o_PlayDMXSceneDeviceValues.setDMXDevice(o_DMXDevice);
            DMXScene.DMXSceneDeviceValues o_DMXSceneDeviceValues = p_DMXSceneValueContainer.getDMXSceneDeviceValues(o_DMXDevice.getID());
            DMXDeviceElement o_DMXDeviceElement = this.getDMXDeviceElement(o_DMXDevice);
            if (o_DMXDeviceElement == null) {
                o_PlayDMXSceneDeviceValues.fillPlayObject(true, o_DMXSceneDeviceValues, p_LiveShowDMXObject, p_VolumeFactor, o_DMXFadeDescription, p_FadeFactor, p_FadeIn, p_FadeOut);
                continue;
            }
            for (int intDMXComponent = 0; intDMXComponent < o_DMXDevice.getDMXControlComponentCount(); ++intDMXComponent) {
                DMXControlDescription o_DMXControlDescription;
                DMXControlComponent.DMXControlType o_DMXControlType;
                DMXControlComponent o_DMXControlComponent = o_DMXDevice.getDMXControlComponent(intDMXComponent);
                if (o_DMXControlComponent == null || (o_DMXControlType = o_DMXControlComponent.getDMXControlType()) == null || (o_DMXControlDescription = o_DMXControlType.getDMXControlDescription()) == null) continue;
                DMXEffect_Function o_DMXEffect_Function = o_DMXControlComponent.getIsDimmerSubstitute() && !"rgbcmy".equals(o_DMXControlDescription.getID()) ? this.m_DMXEffect_Functions.get("dimmer") : this.m_DMXEffect_Functions.get(o_DMXControlDescription.getID());
                if (o_DMXEffect_Function == null) {
                    o_PlayDMXSceneDeviceValues.fillPlayObject(o_DMXControlComponent, true, o_DMXSceneDeviceValues, p_LiveShowDMXObject, p_VolumeFactor, o_DMXFadeDescription, p_FadeFactor, p_FadeIn, p_FadeOut);
                    continue;
                }
                boolFunctionsFound = true;
            }
        }
        if (!boolFunctionsFound) {
            return;
        }
        this.readFunctionsLiveShowDMXObject(false, true, p_DMXPlayObject, p_LiveShowDMXObject, p_LiveShowDMXObject.getDMXFadeDescription(), null, p_VolumeFactor, p_FadeFactor, p_FrameInsideObject);
    }

    public void readAdjustment(boolean p_IsStartAdjustment, LiveShowDMXVIPAdjustment.DMXDeviceAdjustObject p_DMXDeviceAdjustObject, PlayDMX.DMXPlayObject p_DMXPlayObject, long p_FrameInsideObject, DMXScene.DMXSceneDeviceValues p_DMXSceneDeviceValues, float p_VolumeFactor, double p_FadeProgress, boolean p_FadeIn, boolean p_FadeOut) {
        if (p_DMXDeviceAdjustObject == null) {
            return;
        }
        if (p_DMXPlayObject == null) {
            return;
        }
        DMXFadeDescription o_DMXFadeDescription = null;
        LiveShowDMXObject o_LiveShowDMXObject_Original = p_DMXDeviceAdjustObject.getLiveShowDMXObject();
        if (o_LiveShowDMXObject_Original == null) {
            return;
        }
        DMXDevice o_DMXDevice = p_DMXSceneDeviceValues.getDMXDevice();
        DMXScene.DMXSceneValueContainer o_PlayObjectValueContainer = p_DMXPlayObject.getDMXSceneValueContainer();
        DMXScene.DMXSceneDeviceValues o_PlayDMXSceneDeviceValues = o_PlayObjectValueContainer.getDMXSceneDeviceValues(o_DMXDevice.getID());
        DMXDeviceElement o_DMXDeviceElement = this.getDMXDeviceElement(o_DMXDevice);
        o_DMXFadeDescription = p_DMXDeviceAdjustObject.getDMXFadeDescription();
        if (o_DMXDeviceElement == null) {
            o_PlayDMXSceneDeviceValues.fillPlayObject(true, p_DMXSceneDeviceValues, p_DMXDeviceAdjustObject, p_VolumeFactor, o_DMXFadeDescription, p_FadeProgress, p_FadeIn, p_FadeOut);
            return;
        }
        for (int intDMXComponent = 0; intDMXComponent < o_DMXDevice.getDMXControlComponentCount(); ++intDMXComponent) {
            DMXEffect_Function o_DMXEffect_Function;
            DMXControlComponent.DMXControlType o_DMXControlType;
            DMXControlComponent o_DMXControlComponent = o_DMXDevice.getDMXControlComponent(intDMXComponent);
            if (o_DMXControlComponent == null || (o_DMXControlType = o_DMXControlComponent.getDMXControlType()) == null || (o_DMXEffect_Function = this.m_DMXEffect_Functions.get(o_DMXControlType.getDMXControlDescription().getID())) != null) continue;
            o_PlayDMXSceneDeviceValues.fillPlayObject(o_DMXControlComponent, true, p_DMXSceneDeviceValues, p_DMXDeviceAdjustObject, p_VolumeFactor, o_DMXFadeDescription, p_FadeProgress, p_FadeIn, p_FadeOut);
        }
        long longReadPosition = p_DMXPlayObject.getFramePosition();
        if ((longReadPosition -= o_LiveShowDMXObject_Original.getFrameStart()) < 0L) {
            longReadPosition = 0L;
        } else if (longReadPosition > o_LiveShowDMXObject_Original.getFrameLength()) {
            longReadPosition = o_LiveShowDMXObject_Original.getFrameLength();
        }
        this.readFunctions_Adjustment(o_DMXDevice, p_DMXPlayObject, o_LiveShowDMXObject_Original, o_DMXFadeDescription, true, true, o_PlayDMXSceneDeviceValues, p_VolumeFactor, p_FadeProgress, longReadPosition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFunctionsLiveShowDMXObject(boolean p_OnlyReadAdjustmentsPreStatus, boolean p_MixIn, PlayDMX.DMXPlayObject p_DMXPlayObject, LiveShowDMXObject p_LiveShowDMXObject, DMXFadeDescription p_DMXFadeDescription, PlayDMX.DMXPlayObject p_DMXPlayObjectPre_StartStatus, float p_VolumeFactor, double p_FadeFactor, long p_FrameInsideObject) {
        long longEffectDelay = p_LiveShowDMXObject.getDMXEffectDelay();
        long longEffectDuration = p_LiveShowDMXObject.getDMXEffectDuration();
        long longEffectLoops = p_LiveShowDMXObject.getDMXEffectLoops();
        int intTriggerFlag = p_LiveShowDMXObject.getDMXEffectTrigger();
        Object object = this.m_SyncEffectFunctions;
        synchronized (object) {
            for (DMXEffect_Function o_DMXEffect_Function : this.m_DMXEffect_Functions.values()) {
                o_DMXEffect_Function.readLiveShowDMXObject(p_OnlyReadAdjustmentsPreStatus, p_MixIn, p_DMXPlayObject, p_LiveShowDMXObject, p_DMXFadeDescription, p_DMXPlayObjectPre_StartStatus, p_VolumeFactor, p_FadeFactor, p_FrameInsideObject, longEffectDelay, longEffectDuration, longEffectLoops, intTriggerFlag);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFunctions_Adjustment(DMXDevice p_DMXDevice, PlayDMX.DMXPlayObject p_DMXPlayObject, LiveShowDMXObject p_LiveShowDMXObject_Original, DMXFadeDescription p_DMXFadeDescription, boolean p_IsAdjustment, boolean p_MixIn, DMXScene.DMXSceneDeviceValues o_PlayDeviceValues, float p_VolumeFactor, double p_FadeFactor, long p_FrameInsideObject) {
        DMXFadeDescription.DMXDeviceFadeDescription o_DMXDeviceFadeDescription = null;
        boolean boolDMXDeviceFound = false;
        long longEffectDelay = p_LiveShowDMXObject_Original.getDMXEffectDelay();
        long longEffectDuration = p_LiveShowDMXObject_Original.getDMXEffectDuration();
        long longEffectLoops = p_LiveShowDMXObject_Original.getDMXEffectLoops();
        int intTriggerFlag = p_LiveShowDMXObject_Original.getDMXEffectTrigger();
        o_DMXDeviceFadeDescription = p_DMXFadeDescription.getDMXDeviceFadeDescription(p_DMXDevice.getID());
        Object object = this.m_SyncEffectFunctions;
        synchronized (object) {
            if (this.m_MaxSteps <= 0) {
                return;
            }
            Iterator<DMXEffect_Function> o_Iterator = this.m_DMXEffect_Functions.values().iterator();
            block3: while (o_Iterator.hasNext()) {
                boolDMXDeviceFound = false;
                DMXEffect_Function o_DMXEffect_Function = o_Iterator.next();
                o_DMXEffect_Function.calculateStep(p_LiveShowDMXObject_Original, p_LiveShowDMXObject_Original.getDMXEffect_StepFactor(), p_FrameInsideObject, longEffectDelay, longEffectDuration, longEffectLoops, intTriggerFlag);
                for (int intElement = 0; intElement < o_DMXEffect_Function.getDMXEffectElementCount(); ++intElement) {
                    DMXEffect_Function.DMXEffectElement o_DMXEffectElement = o_DMXEffect_Function.getDMXEffectElement(intElement);
                    if (o_DMXEffectElement == null) continue;
                    if (o_DMXEffectElement.getDMXDevice() == p_DMXDevice) {
                        boolDMXDeviceFound = true;
                        o_DMXEffect_Function.readComponents(true, false, p_MixIn, o_DMXEffectElement, intElement, p_DMXDevice, p_LiveShowDMXObject_Original, o_DMXDeviceFadeDescription, o_PlayDeviceValues, null, p_VolumeFactor, p_FadeFactor);
                        continue;
                    }
                    if (boolDMXDeviceFound) continue block3;
                }
            }
        }
    }

    @Override
    public Icon getIcon() {
        return s_Icon;
    }

    @Override
    public boolean useDMXDevice(DMXDevice p_DMXDevice) {
        return this.contains(p_DMXDevice);
    }

    public static DMXDeviceElementListRenderer getDMXDeviceElementListRenderer() {
        return s_DMXDeviceElementListRenderer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resortDMXEffectFunctions(DMXDeviceElement p_DMXDeviceElement) {
        Object object = this.m_SyncEffectFunctions;
        synchronized (object) {
            for (DMXEffect_Function o_DMXEffect_Function : this.m_DMXEffect_Functions.values()) {
                o_DMXEffect_Function.resortDMXDevices(p_DMXDeviceElement);
            }
        }
    }

    public DMXDeviceElementListModel getDMXDeviceListModel() {
        return this.m_DMXDeviceElementListModel;
    }

    public TableAndListModel.ListModelWrapper<DMXDeviceElement> getDMXDeviceListModelWrapper() {
        return this.m_DMXDeviceElementListModelWarpper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDMXControlDescription(DMXControlDescription p_DMXControlDescription) {
        if (p_DMXControlDescription == null) {
            return;
        }
        Object object = this.m_SyncDMXControlDescriptions;
        synchronized (object) {
            s_DMXControlDescriptionList.addDMXControlDescription(p_DMXControlDescription);
        }
    }

    public static int getDMXControlDescriptionCount() {
        return s_DMXControlDescriptionList.size();
    }

    public static DMXControlDescription getDMXControlDescription(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        if (p_Index < 0) {
            return null;
        }
        if (p_Index >= s_DMXControlDescriptionList.size()) {
            return null;
        }
        return (DMXControlDescription)s_DMXControlDescriptionList.get(p_Index);
    }

    public static int getIndexOf(DMXControlDescription p_DMXControlDescription) {
        return s_DMXControlDescriptionList.indexOf(p_DMXControlDescription);
    }

    public void addPropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
        if (p_PropertyChangeListener == null) {
            return;
        }
        if (this.m_PropertyChangeSupport != null) {
            this.m_PropertyChangeSupport.addPropertyChangeListener(p_PropertyChangeListener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
        if (this.m_PropertyChangeSupport != null) {
            this.m_PropertyChangeSupport.removePropertyChangeListener(p_PropertyChangeListener);
        }
    }

    public TableAndListModel.ListModelWrapper<DMXControlDescription> getDMXControlDescriptionsWrapper() {
        if (this.m_DMXControlDescriptionsWrapper == null) {
            this.m_DMXControlDescriptionsWrapper = s_DMXControlDescriptionList.createListModelWrapper();
        }
        return this.m_DMXControlDescriptionsWrapper;
    }

    public static DMXControlDescription.DMXControlDescriptionCellRenderer getDMXControlDescriptionCellRenderer() {
        return s_DMXControlDescriptionCellRenderer;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof DMXEffect_Function) {
            if (DMXEffect_Function.PROP_DMXEFFECTFUNCTION_STEPADDED.equals(evt.getPropertyName()) || DMXEffect_Function.PROP_DMXEFFECTFUNCTION_STEPREMOVED.equals(evt.getPropertyName())) {
                this.eventStepCount((DMXEffect_Function)evt.getSource());
            }
        } else if (evt.getSource() instanceof DMXDevice.TreeModel_Device_Channels) {
            if ("dmxdevicetreemodelDMXDeviceRemoved".equals(evt.getPropertyName())) {
                DMXDevice o_DMXDevice = (DMXDevice)evt.getOldValue();
                this.removeDMXDevice(o_DMXDevice);
            }
        } else if (evt.getSource() instanceof DMXDevice && "dmxdeviceDMXDeviceType".equals(evt.getPropertyName())) {
            this.eventDMXDeviceTypeChanged((DMXDevice)evt.getSource());
        }
    }

    public void fillPlayObject(Playable.PlayObject p_PlayObject, float p_VolumeFactor, double p_FadeFactor, long p_StartTime, long p_Time) {
    }

    public static DMXEffectTableModel getDMXEffectTableModel() {
        return s_DMXEffectTableModel;
    }

    public static void addDMXEffect(DMXEffect p_DMXEffect) {
        if (p_DMXEffect == null) {
            return;
        }
        s_DMXEffectTableModel.addDMXEffect(p_DMXEffect);
        s_DMXEffectListModel.addDMXEffect(p_DMXEffect);
    }

    public static void removeDMXEffect(DMXEffect p_DMXEffect, boolean p_ProjectClosed) {
        if (p_DMXEffect == null) {
            return;
        }
        s_DMXEffectTableModel.removeDMXEffect(p_DMXEffect);
        s_DMXEffectListModel.removeDMXEffect(p_DMXEffect);
        p_DMXEffect.close();
        if (!p_ProjectClosed) {
            LiveShowDMXVIPAdjustment.calculateAdjustmentAll();
        }
    }

    public static DMXEffect getDMXEffect(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        return (DMXEffect)s_DMXEffectTableModel.get(p_Index);
    }

    public static ArrayList<DMXEffect> getDMXEffects() {
        ArrayList<DMXEffect> o_DMXEffects = s_DMXEffectTableModel.getElementArrayList_Safe();
        return o_DMXEffects;
    }

    public static int getDMXEffectCount() {
        return s_DMXEffectTableModel.size();
    }

    public static boolean contains(String p_ID) {
        return s_DMXEffectTableModel.contains(p_ID);
    }

    public static DMXEffect getDMXEffect(String p_ID) {
        if (p_ID == null) {
            return null;
        }
        return s_DMXEffectTableModel.getDMXEffect(p_ID);
    }

    public static DMXEffect getDMXEffectByName(String p_Name) {
        if (p_Name == null) {
            return null;
        }
        DMXEffect o_DMXEffect = null;
        int intDMXEffectCount = DMXEffect.getDMXEffectCount();
        for (int intDMXEffect = 0; intDMXEffect < intDMXEffectCount; ++intDMXEffect) {
            o_DMXEffect = s_DMXEffectTableModel.getDMXEffect(intDMXEffect);
            if (o_DMXEffect == null) continue;
            if (p_Name.equals(o_DMXEffect.getName())) break;
            o_DMXEffect = null;
        }
        return o_DMXEffect;
    }

    public static DMXEffectListModel getDMXEffectListModel() {
        return s_DMXEffectListModel;
    }

    public static DMXEffectListRenderer getDMXEffectListRenderer() {
        return s_DMXEffectListRenderer;
    }

    public static class DMXEffectTableModel
    extends TableAndListModel<DMXEffect>
    implements PropertyChangeListener {
        public static final int COLUMNCOUNT = 2;
        public static final int COLUMNINDEX_EFFECTNAME = 0;
        public static final int COLUMNINDEX_EFFECTDESCRIPTION = 1;
        @LiveLanguageString
        public static String COLUMN_EFFECTNAME = "Name";
        @LiveLanguageString
        public static String COLUMN_EFFECTDESCRIPTION = "Description";
        private final Object m_SyncObject = new Object();

        public DMXEffectTableModel() {
            super(false);
            this.initMembers();
            LiveLanguage.addLanguageListener((Object)this, null);
        }

        private void initMembers() {
        }

        public void finishJTable(JTable p_JTable) {
            TableAndListModel.TableCellEditorRenderer_String o_TableCellEditorRenderer_String;
            if (p_JTable == null) {
                return;
            }
            TableRowSorter<DMXEffectTableModel> o_TableRowSorter = new TableRowSorter<DMXEffectTableModel>(this);
            o_TableRowSorter.setComparator(0, TableAndListModel.getStringComparator_Normal());
            o_TableRowSorter.setComparator(1, TableAndListModel.getStringComparator_Normal());
            super.finishJTable(p_JTable, o_TableRowSorter, null);
            TableColumnModel o_TableColumnModel = p_JTable.getColumnModel();
            TableColumn o_TableColumn = o_TableColumnModel.getColumn(0);
            if (o_TableColumn != null) {
                o_TableCellEditorRenderer_String = new TableAndListModel.TableCellEditorRenderer_String();
                o_TableCellEditorRenderer_String.setIcon(s_Icon);
                o_TableCellEditorRenderer_String.setHorizontalAlignment(10);
                o_TableCellEditorRenderer_String.setToolTipText_Automatic(0);
                o_TableCellEditorRenderer_String.setToolTipTextAt(true, true);
                o_TableColumn.setCellEditor(o_TableCellEditorRenderer_String);
                o_TableColumn.setCellRenderer(o_TableCellEditorRenderer_String);
            }
            if ((o_TableColumn = o_TableColumnModel.getColumn(1)) != null) {
                o_TableCellEditorRenderer_String = new TableAndListModel.TableCellEditorRenderer_String();
                o_TableCellEditorRenderer_String.setHorizontalAlignment(10);
                o_TableCellEditorRenderer_String.setToolTipText_Automatic(0);
                o_TableCellEditorRenderer_String.setToolTipTextAt(true, true);
                o_TableColumn.setCellEditor(o_TableCellEditorRenderer_String);
                o_TableColumn.setCellRenderer(o_TableCellEditorRenderer_String);
            }
            p_JTable.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        }

        @Override
        public boolean contains(String p_ID) {
            if (p_ID == null) {
                return false;
            }
            DMXEffect o_DMXEffect = this.getDMXEffect(p_ID);
            return o_DMXEffect != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DMXEffect getDMXEffect(String p_ID) {
            Object object = this.m_SyncObject;
            synchronized (object) {
                for (int intDMXEffect = 0; intDMXEffect < this.size(); ++intDMXEffect) {
                    DMXEffect o_DMXEffect = (DMXEffect)this.get(intDMXEffect);
                    if (o_DMXEffect == null || !p_ID.equals(o_DMXEffect.getID())) continue;
                    return o_DMXEffect;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addDMXEffect(DMXEffect p_DMXEffect) {
            if (p_DMXEffect == null) {
                return;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (this.add(p_DMXEffect)) {
                    p_DMXEffect.addPropertyChangeListener(this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeDMXEffect(DMXEffect p_DMXEffect) {
            if (p_DMXEffect == null) {
                return;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (this.remove(p_DMXEffect)) {
                    p_DMXEffect.removePropertyChangeListener(this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addSelectedDMXEffect(JTable p_JTable, DMXEffect p_DMXEffect) {
            if (p_JTable == null) {
                return;
            }
            if (p_DMXEffect == null) {
                return;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                this.addSelectedElement(p_JTable, p_DMXEffect);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeSelectedDMXEffect(JTable p_JTable, DMXEffect p_DMXEffect) {
            if (p_JTable == null) {
                return;
            }
            if (p_DMXEffect == null) {
                return;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                this.removeSelectedElement(p_JTable, p_DMXEffect);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DMXEffect getDMXEffect(int p_Index) {
            if (p_Index < 0) {
                return null;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                return (DMXEffect)this.get(p_Index);
            }
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return COLUMN_EFFECTNAME;
                }
                case 1: {
                    return COLUMN_EFFECTDESCRIPTION;
                }
            }
            return "";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getValue(DMXEffect p_DMXEffect, int columnIndex) {
            String stringValue = "";
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (p_DMXEffect == null) {
                    return stringValue;
                }
                switch (columnIndex) {
                    case 0: {
                        stringValue = p_DMXEffect.getName();
                        break;
                    }
                    case 1: {
                        stringValue = p_DMXEffect.getRemark();
                    }
                }
                return stringValue;
            }
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            switch (col) {
                case 0: {
                    return true;
                }
                case 1: {
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setValue(DMXEffect p_DMXEffect, Object value, int col) {
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (p_DMXEffect == null) {
                    return;
                }
            }
            switch (col) {
                case 0: {
                    String stringValue = (String)value;
                    p_DMXEffect.setName(stringValue);
                    break;
                }
                case 1: {
                    String stringValue = (String)value;
                    p_DMXEffect.setRemark(stringValue);
                }
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() instanceof DMXEffect) {
                DMXEffect o_DMXEffect = (DMXEffect)evt.getSource();
                if (DMXEffect.PROP_DMXEFFECT_NAME.equals(evt.getPropertyName())) {
                    this.changedElement(o_DMXEffect);
                } else if (DMXEffect.PROP_DMXEFFECT_REMARK.equals(evt.getPropertyName())) {
                    this.changedElement(o_DMXEffect);
                }
            }
        }
    }

    public static class DMXEffectListRenderer
    extends TableAndListModel.ListRenderer {
        public DMXEffectListRenderer() {
            ImageIcon o_ImageIcon_Null = new ImageIcon(DMXEffect.class.getResource("/IconsPackage/_Empty.png"));
            super.setNullLabel(o_ImageIcon_Null, o_ImageIcon_Null, "---", null, 0, null, null);
        }
    }

    public static class DMXEffectListModel
    extends TableAndListModel.ListModel<DMXEffect>
    implements PropertyChangeListener {
        private final Object m_SyncObject = new Object();

        public DMXEffectListModel() {
            super(true);
            super.setGetSortStringMethod(DMXEffect.class, "getName", true);
            super.addElement(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addDMXEffect(DMXEffect p_DMXEffect) {
            if (p_DMXEffect == null) {
                return;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (!this.add(p_DMXEffect)) {
                    return;
                }
            }
            p_DMXEffect.addPropertyChangeListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeDMXEffect(DMXEffect p_DMXEffect) {
            if (p_DMXEffect == null) {
                return;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (!this.remove(p_DMXEffect)) {
                    return;
                }
            }
            p_DMXEffect.removePropertyChangeListener(this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() instanceof DMXEffect) {
                DMXEffect o_DMXEffect = (DMXEffect)evt.getSource();
                if (DMXEffect.PROP_DMXEFFECT_NAME.equals(evt.getPropertyName())) {
                    this.changedElement(o_DMXEffect);
                } else if (DMXEffect.PROP_DMXEFFECT_REMARK.equals(evt.getPropertyName())) {
                    this.changedElement(o_DMXEffect);
                }
            }
        }
    }

    public static class DMXDeviceElementListRenderer
    extends DefaultListCellRenderer {
        public static Dimension s_DimensionIcon = new Dimension(20, 20);
        private JPanel m_DevicePanel;
        private JLabelBackground m_LabelIcon;
        private JLabel m_LabelName;
        private JLabel m_LabelFirstStepOn;
        private JRadioButton m_RadioButton_Invert;

        public DMXDeviceElementListRenderer() {
            this.initMembers();
            this.initComponents();
        }

        private void initMembers() {
        }

        private void initComponents() {
            GridBagConstraints o_GridBagConstraints = new GridBagConstraints();
            this.m_DevicePanel = new JPanel();
            this.m_DevicePanel.setLayout(new GridBagLayout());
            o_GridBagConstraints.insets = new Insets(1, 2, 1, 2);
            o_GridBagConstraints.gridx = 0;
            o_GridBagConstraints.gridy = 0;
            this.m_LabelIcon = new JLabelBackground();
            this.m_LabelIcon.setBackgroundStyle(3);
            this.m_LabelIcon.setBackgroundOpaque(true);
            this.m_LabelIcon.setPreferredSize(s_DimensionIcon);
            this.m_DevicePanel.add((Component)this.m_LabelIcon, o_GridBagConstraints);
            o_GridBagConstraints.gridx = 1;
            o_GridBagConstraints.gridy = 0;
            o_GridBagConstraints.fill = 1;
            o_GridBagConstraints.weightx = 1.0;
            this.m_LabelName = new JLabel();
            this.m_DevicePanel.add((Component)this.m_LabelName, o_GridBagConstraints);
            o_GridBagConstraints.gridx = 2;
            o_GridBagConstraints.gridy = 0;
            o_GridBagConstraints.fill = 0;
            o_GridBagConstraints.weightx = 0.0;
            this.m_LabelFirstStepOn = new JLabel();
            this.m_DevicePanel.add((Component)this.m_LabelFirstStepOn, o_GridBagConstraints);
            o_GridBagConstraints.gridx = 3;
            o_GridBagConstraints.gridy = 0;
            o_GridBagConstraints.fill = 0;
            o_GridBagConstraints.weightx = 0.0;
            this.m_RadioButton_Invert = new JRadioButton();
            this.m_RadioButton_Invert.setForeground(Color.WHITE);
            this.m_DevicePanel.add((Component)this.m_RadioButton_Invert, o_GridBagConstraints);
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.m_LabelName.setFont(list.getFont());
            Color o_Background = null;
            Color o_Foreground = null;
            o_Background = list.getBackground();
            o_Foreground = list.getForeground();
            if (isSelected) {
                if (list.hasFocus()) {
                    o_Background = UIManager.getColor("List.selectionBackground");
                    o_Foreground = UIManager.getColor("List.selectionForeground");
                } else {
                    o_Background = UIManager.getColor("List.selectionInactiveBackground");
                    o_Foreground = UIManager.getColor("List.selectionInactiveForeground");
                }
            }
            this.setForeground(o_Foreground);
            this.setBackground(o_Background);
            this.m_DevicePanel.setBackground(o_Background);
            this.m_LabelName.setBackground(o_Background);
            this.m_LabelIcon.setBackground(o_Foreground);
            this.m_LabelFirstStepOn.setBackground(o_Background);
            this.m_RadioButton_Invert.setBackground(o_Background);
            this.m_DevicePanel.setForeground(o_Foreground);
            this.m_LabelName.setForeground(o_Foreground);
            this.m_LabelIcon.setForeground(o_Foreground);
            this.m_LabelFirstStepOn.setForeground(o_Foreground);
            this.m_RadioButton_Invert.setForeground(o_Foreground);
            if (value == null || !(value instanceof DMXDeviceElement)) {
                this.m_LabelIcon.setBackgroundImage(null);
                this.m_LabelName.setText("");
                this.m_DevicePanel.setToolTipText(null);
                this.m_LabelFirstStepOn.setText("");
                this.m_RadioButton_Invert.setSelected(false);
                this.m_DevicePanel.setToolTipText(null);
            } else {
                DMXDeviceElement o_DMXDeviceElement = (DMXDeviceElement)value;
                DMXDevice o_DMXDevice = o_DMXDeviceElement.getDMXDevice();
                this.m_LabelIcon.setBackgroundImage(o_DMXDevice.getDeviceImage());
                this.m_LabelName.setText(o_DMXDevice.getName());
                this.m_DevicePanel.setToolTipText(o_DMXDevice.getToolTipText());
                this.m_LabelFirstStepOn.setText(String.valueOf(o_DMXDeviceElement.getFirstIsOnStep() + 1));
                this.m_LabelFirstStepOn.setToolTipText(s_ToolTip_FirstStepOn);
                this.m_RadioButton_Invert.setSelected(o_DMXDeviceElement.getInvertedControls());
                this.m_RadioButton_Invert.setToolTipText(s_ToolTip_Invert);
            }
            return this.m_DevicePanel;
        }
    }

    public static class DMXDeviceElementListModel
    extends TableAndListModel.ListModel<DMXDeviceElement>
    implements PropertyChangeListener {
        private final Object m_SyncObject = new Object();

        public DMXDeviceElementListModel() {
            super(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addDMXDeviceElement(DMXDeviceElement p_DMXDeviceElement) {
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (!this.add(p_DMXDeviceElement)) {
                    return;
                }
                p_DMXDeviceElement.addPropertyChangeListener(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addDMXDeviceElement(int p_Index, DMXDeviceElement p_DMXDeviceElement) {
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (!this.add(p_Index, p_DMXDeviceElement)) {
                    return;
                }
                p_DMXDeviceElement.addPropertyChangeListener(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeDMXDeviceElement(DMXDeviceElement p_DMXDeviceElement) {
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (!this.remove(p_DMXDeviceElement)) {
                    return;
                }
                p_DMXDeviceElement.removePropertyChangeListener(this);
                p_DMXDeviceElement.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.m_SyncObject;
            synchronized (object) {
                for (int intElement = super.size() - 1; intElement >= 0; --intElement) {
                    DMXDeviceElement o_DMXDeviceElement = (DMXDeviceElement)this.get(intElement);
                    this.removeDMXDeviceElement(o_DMXDeviceElement);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean moveUp(DMXDeviceElement p_DMXDeviceElement) {
            Object object = this.m_SyncObject;
            synchronized (object) {
                int intIndex = this.indexOf(p_DMXDeviceElement);
                if (intIndex <= 0) {
                    return false;
                }
                this.remove(p_DMXDeviceElement);
                this.add(intIndex - 1, p_DMXDeviceElement);
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean moveDown(DMXDeviceElement p_DMXDeviceElement) {
            Object object = this.m_SyncObject;
            synchronized (object) {
                int intIndex = this.indexOf(p_DMXDeviceElement);
                if (intIndex < 0) {
                    return false;
                }
                if (intIndex >= this.size() - 1) {
                    return false;
                }
                this.remove(p_DMXDeviceElement);
                this.add(intIndex + 1, p_DMXDeviceElement);
            }
            return true;
        }

        public int getIndexOf(DMXDevice p_DMXDevice) {
            if (p_DMXDevice == null) {
                return -1;
            }
            for (int intIndex = 0; intIndex < this.size(); ++intIndex) {
                DMXDeviceElement o_DMXDeviceElement = (DMXDeviceElement)this.get(intIndex);
                if (o_DMXDeviceElement == null || o_DMXDeviceElement.getDMXDevice() != p_DMXDevice) continue;
                return intIndex;
            }
            return -1;
        }

        @Override
        public boolean contains(DMXDevice p_DMXDevice) {
            int intIndex = this.getIndexOf(p_DMXDevice);
            return intIndex >= 0;
        }

        public DMXDeviceElement getElement(DMXDevice p_DMXDevice) {
            if (p_DMXDevice == null) {
                return null;
            }
            for (int intElement = 0; intElement < this.size(); ++intElement) {
                DMXDeviceElement o_DMXDeviceElement = (DMXDeviceElement)this.get(intElement);
                if (o_DMXDeviceElement == null || p_DMXDevice != o_DMXDeviceElement.getDMXDevice()) continue;
                return o_DMXDeviceElement;
            }
            return null;
        }

        public ArrayList<DMXDeviceElement> getDMXDeviceElements() {
            ArrayList<DMXDeviceElement> o_DMXDeviceElements = this.getElementArrayList_Safe();
            return o_DMXDeviceElements;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ArrayList<DMXDevice> getDMXDevices() {
            ArrayList<DMXDevice> o_DMXDevices;
            Object object = this.m_SyncObject;
            synchronized (object) {
                o_DMXDevices = new ArrayList<DMXDevice>(this.size());
                for (int intDevice = 0; intDevice < this.size(); ++intDevice) {
                    DMXDeviceElement o_DMXDeviceElement = (DMXDeviceElement)this.get(intDevice);
                    if (o_DMXDeviceElement == null) continue;
                    o_DMXDevices.add(o_DMXDeviceElement.getDMXDevice());
                }
            }
            return o_DMXDevices;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() instanceof DMXDeviceElement) {
                DMXDeviceElement o_DMXDeviceElement = (DMXDeviceElement)evt.getSource();
                this.changedElement(o_DMXDeviceElement);
            }
        }
    }

    public static class DMXDeviceElement {
        public static String PROP_DMXDEVICELEMENT_DEVICEON = "dmxdeviceelement_deviceon";
        private DMXEffect m_DMXEffect;
        private DMXDevice m_DMXDevice;
        private boolean m_InvertedControls;
        private ArrayList<Integer> m_IsOnSteps;
        private ArrayList<DMXEffect_Function.DMXEffectElement> m_DimmerEffectElements;
        private SinglePropertyChangeSupport m_PropertyChangeSupport;
        private final Object m_SyncObject = new Object();

        public DMXDeviceElement(DMXEffect p_DMXEffect, DMXDevice p_DMXDevice) {
            this.initMembers();
            this.m_DMXEffect = p_DMXEffect;
            this.m_DMXDevice = p_DMXDevice;
            if (this.m_DMXDevice != null) {
                this.m_DMXDevice.addPropertyChangeListener("dmxdeviceDMXDeviceType", this.m_DMXEffect);
            }
        }

        private void initMembers() {
            this.m_PropertyChangeSupport = new SinglePropertyChangeSupport(this);
            this.m_DimmerEffectElements = new ArrayList();
            this.m_InvertedControls = false;
            this.m_IsOnSteps = new ArrayList();
        }

        public void close() {
            this.m_DimmerEffectElements.clear();
            if (this.m_DMXDevice != null) {
                this.m_DMXDevice.removePropertyChangeListener("dmxdeviceDMXDeviceType", this.m_DMXEffect);
            }
        }

        public DMXDevice getDMXDevice() {
            return this.m_DMXDevice;
        }

        public String getDMXDeviceID() {
            if (this.m_DMXDevice == null) {
                return "";
            }
            return this.m_DMXDevice.getID();
        }

        public void setInvertedControls(boolean p_Inverted) {
            this.m_InvertedControls = p_Inverted;
        }

        public boolean getInvertedControls() {
            return this.m_InvertedControls;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addDimmerDMXEffectElement(DMXEffect_Function.DMXEffectElement p_DMXEffectElement) {
            if (p_DMXEffectElement == null) {
                return;
            }
            boolean boolChanged = false;
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (this.m_DimmerEffectElements.contains(p_DMXEffectElement)) {
                    return;
                }
                if (this.m_DimmerEffectElements.add(p_DMXEffectElement)) {
                    boolChanged = true;
                }
            }
            if (boolChanged) {
                // empty if block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeDimmerDMXEffectElement(DMXEffect_Function.DMXEffectElement p_DMXEffectElement) {
            if (p_DMXEffectElement == null) {
                return;
            }
            boolean boolChanged = false;
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (this.m_DimmerEffectElements.remove(p_DMXEffectElement)) {
                    boolChanged = true;
                }
            }
            if (boolChanged) {
                // empty if block
            }
        }

        public int getDimmerDMXEffectElementCount() {
            return this.m_DimmerEffectElements.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DMXEffect_Function.DMXEffectElement getDimmerDMXEffectElement(int p_Index) {
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (this.m_DimmerEffectElements.size() <= 0) {
                    return null;
                }
                if (p_Index < 0) {
                    return null;
                }
                if (p_Index >= this.m_DimmerEffectElements.size()) {
                    return null;
                }
                return this.m_DimmerEffectElements.get(p_Index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean calculateIsOnSteps() {
            boolean boolChanged = false;
            Object object = this.m_SyncObject;
            synchronized (object) {
                this.m_IsOnSteps.clear();
                for (int intElement = 0; intElement < this.m_DimmerEffectElements.size(); ++intElement) {
                    DMXEffect_Function.DMXEffectElement o_DMXEffectElement = this.m_DimmerEffectElements.get(intElement);
                    DMXEffect_Function o_DMXEffect_Function = o_DMXEffectElement.getDMXEffect_Function();
                    if (!o_DMXEffect_Function.calculateIsOnSteps(o_DMXEffectElement, this.m_IsOnSteps)) continue;
                    boolChanged = true;
                }
            }
            if (boolChanged) {
                this.m_PropertyChangeSupport.firePropertyChange(PROP_DMXDEVICELEMENT_DEVICEON, false, true);
            }
            return boolChanged;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getFirstIsOnStep() {
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (this.m_IsOnSteps.size() <= 0) {
                    return -1;
                }
                return this.m_IsOnSteps.get(0);
            }
        }

        public int getIsOnStepCount() {
            return this.m_IsOnSteps.size();
        }

        public void addPropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
            if (p_PropertyChangeListener == null) {
                return;
            }
            if (this.m_PropertyChangeSupport != null) {
                this.m_PropertyChangeSupport.addPropertyChangeListener(p_PropertyChangeListener);
            }
        }

        public void removePropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
            if (this.m_PropertyChangeSupport != null) {
                this.m_PropertyChangeSupport.removePropertyChangeListener(p_PropertyChangeListener);
            }
        }
    }
}

