/*
 * Decompiled with CFR 0.152.
 */
package DMXDevicePackage;

import DMXDevicePackage.DMXDevice;
import DMXDevicePackage.DMXDeviceType;
import DMXGraphics.LiveShowDMXStageView;
import DMXMixer.DMXControlComponent;
import LanguageTools.LiveLanguagePackage.LiveLanguage;
import SwingComponents.MouseAdapter_Delayed;
import SwingTextPackage.DocumentFilter_Integer;
import SwingToolTipPackage.PopUpToolTip;
import ToolsGraphics.JLabelBackground;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class DMXDeviceView
extends JPanel
implements PropertyChangeListener {
    public static final String PROP_DMXDEVICEVIEW_DMXDEVICETYPE = "dmxdeviceviewDMXDeviceType";
    public static Border s_ScaleBorder = new LineBorder(new Color(100, 100, 100), 1);
    public static Border s_SelectedBorder = new LineBorder(Color.BLUE, 2);
    private DMXDevice m_DMXDevice;
    private JLabelBackground m_LabelDevice;
    private JLabel m_LabelDeviceName;
    private JLabel m_LabelDeviceActive;
    private JLabel m_LabelDeviceMute;
    private JLabel m_LabelDeviceSolo;
    private JLabel m_LabelDeviceFailure;
    private JTextField m_LabelDeviceScale;
    private int m_LabelScaleDragStart;
    private int m_LabelScaleDragStart_Y;
    private MouseAdapter_Delayed m_MouseAdapter_Delayed;
    private int m_PositionX;
    private int m_PositionY;
    private AbsoluteConstraints m_AbsoluteConstraints;
    private AbsoluteConstraints m_AbsoluteConstraints_LabelDevice;
    private AbsoluteConstraints m_AbsoluteConstraints_LabelDeviceName;
    private AbsoluteConstraints m_AbsoluteConstraints_LabelDeviceActive;
    private AbsoluteConstraints m_AbsoluteConstraints_LabelDeviceMute;
    private AbsoluteConstraints m_AbsoluteConstraints_LabelDeviceSolo;
    private AbsoluteConstraints m_AbsoluteConstraints_LabelDeviceFailure;
    private AbsoluteConstraints m_AbsoluteConstraints_LabelScale;
    private Dimension m_Dimension_TextFieldScale;
    private Rectangle m_Bounds;
    private LiveShowDMXStageView m_LiveShowDMXStageView;
    private JComponent m_Container;
    private DisplayLabelContainer m_DisplayLabelContainer;
    private Point m_MouseDragStart;
    private Point m_OldPosition;
    private boolean m_Selected;
    private DMXDeviceView m_SelfReference;
    private boolean m_ExternalMouseInside;
    private Dimension m_DimensionDeviceIcon;

    public DMXDeviceView(LiveShowDMXStageView p_LiveShowDMXStageView) {
        this.initMembers();
        this.initComponents();
        this.m_LiveShowDMXStageView = p_LiveShowDMXStageView;
        this.m_Container = this.m_LiveShowDMXStageView.getDeviceViewComponent();
        this.m_Container.add(this, this.m_AbsoluteConstraints, 0);
        this.m_SelfReference = this;
        LiveLanguage.addLanguageListener((Object)this, null);
    }

    private void initMembers() {
        this.m_DMXDevice = null;
        this.m_DimensionDeviceIcon = new Dimension();
        this.m_MouseDragStart = new Point();
        this.m_OldPosition = new Point();
        this.m_Selected = false;
        this.m_ExternalMouseInside = false;
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new AbsoluteLayout());
        this.setOpaque(false);
        this.setFocusable(true);
        this.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.m_AbsoluteConstraints = new AbsoluteConstraints(0, 0);
        this.m_LabelDevice = new JLabelBackground();
        this.m_LabelDevice.setBackgroundStyle(3);
        this.m_LabelDevice.setBackgroundOpaque(true);
        this.m_LabelDevice.setPreferredSize(new Dimension(100, 100));
        this.m_LabelDevice.setVisible(true);
        this.m_AbsoluteConstraints_LabelDevice = new AbsoluteConstraints(0, 0);
        this.add((Component)this.m_LabelDevice, this.m_AbsoluteConstraints_LabelDevice);
        this.setVisible(true);
        this.m_MouseAdapter_Delayed = new MouseAdapter_Delayed(){

            @Override
            public void mouseClicked_Delayed(MouseEvent e) {
                if (DMXDeviceView.this.m_LiveShowDMXStageView != null) {
                    if (e.getClickCount() == 1) {
                        if (e.isShiftDown() || e.isControlDown()) {
                            if (!DMXDeviceView.this.m_Selected) {
                                DMXDeviceView.this.m_LiveShowDMXStageView.addSelectedDMXDevice(DMXDeviceView.this.m_SelfReference.getDMXDevice());
                            } else {
                                DMXDeviceView.this.m_LiveShowDMXStageView.removeSelectedDMXDevice(DMXDeviceView.this.m_SelfReference.getDMXDevice());
                            }
                        } else {
                            DMXDeviceView.this.m_LiveShowDMXStageView;
                            LiveShowDMXStageView.clearSelectedDMXDevices();
                            if (!DMXDeviceView.this.m_Selected) {
                                DMXDeviceView.this.m_LiveShowDMXStageView.addSelectedDMXDevice(DMXDeviceView.this.m_SelfReference.getDMXDevice());
                            }
                        }
                    } else if (e.getClickCount() == 2) {
                        if (DMXDeviceView.this.m_DMXDevice != null) {
                            DMXDeviceView.this.m_LiveShowDMXStageView.showDMXDeviceSettings(DMXDeviceView.this.m_DMXDevice);
                        }
                    } else if (e.getClickCount() > 2 && DMXDeviceView.this.m_DMXDevice != null) {
                        DMXDeviceView.this.m_LiveShowDMXStageView;
                        LiveShowDMXStageView.clearSelectedDMXDevices();
                    }
                    e.consume();
                }
            }

            @Override
            public void mousePressed_Delayed(MouseEvent e) {
                DMXDeviceView.this.m_LabelDevice.requestFocus();
                ((DMXDeviceView)DMXDeviceView.this).m_MouseDragStart.x = e.getXOnScreen();
                ((DMXDeviceView)DMXDeviceView.this).m_MouseDragStart.y = e.getYOnScreen();
                ((DMXDeviceView)DMXDeviceView.this).m_OldPosition.x = DMXDeviceView.this.getNormPositionX();
                ((DMXDeviceView)DMXDeviceView.this).m_OldPosition.y = DMXDeviceView.this.getNormPositionY();
            }

            @Override
            public void mouseDragged_Delayed(MouseEvent e) {
                int intMouseDiffx = e.getXOnScreen() - ((DMXDeviceView)DMXDeviceView.this).m_MouseDragStart.x;
                int intMouseDiffy = e.getYOnScreen() - ((DMXDeviceView)DMXDeviceView.this).m_MouseDragStart.y;
                if (DMXDeviceView.this.m_Selected) {
                    DMXDeviceView.this.m_LiveShowDMXStageView.movePosition_DMXDeviceViews(DMXDeviceView.this.m_SelfReference, true, DMXDeviceView.this.m_OldPosition, intMouseDiffx, intMouseDiffy);
                } else {
                    DMXDeviceView.this.m_LiveShowDMXStageView.movePosition_DMXDeviceViews(DMXDeviceView.this.m_SelfReference, false, DMXDeviceView.this.m_OldPosition, intMouseDiffx, intMouseDiffy);
                }
            }
        };
        this.m_LabelDevice.addMouseListener(this.m_MouseAdapter_Delayed);
        this.m_LabelDevice.addMouseMotionListener(this.m_MouseAdapter_Delayed);
        this.m_LabelDevice.setFocusable(true);
        this.m_LabelDeviceName = new JLabel();
        this.m_LabelDeviceName.setHorizontalAlignment(0);
        Font o_Font = new Font(this.m_LabelDeviceName.getFont().getFamily(), 0, 9);
        this.m_LabelDeviceName.setFont(o_Font);
        this.m_LabelDeviceName.setPreferredSize(new Dimension(100, 12));
        this.m_LabelDeviceName.setForeground(Color.WHITE);
        this.m_AbsoluteConstraints_LabelDeviceName = new AbsoluteConstraints(0, 0);
        this.add(this.m_LabelDeviceName, this.m_AbsoluteConstraints_LabelDeviceName, 0);
        this.m_LabelDeviceName.addMouseListener(this.m_MouseAdapter_Delayed);
        this.m_LabelDeviceName.addMouseMotionListener(this.m_MouseAdapter_Delayed);
        this.m_LabelDeviceActive = new JLabel();
        this.m_LabelDeviceActive.setOpaque(true);
        this.m_LabelDeviceActive.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (DMXDeviceView.this.m_DMXDevice != null) {
                    if (!DMXDeviceView.this.m_LabelDeviceActive.isEnabled()) {
                        return;
                    }
                    DMXDeviceView.this.m_DMXDevice.setActive(!DMXDeviceView.this.m_DMXDevice.getActive());
                    if (!DMXDeviceView.this.m_SelfReference.isEnabled() && DMXDeviceView.this.m_DMXDevice.getActive()) {
                        DMXDeviceView.this.m_LabelDeviceActive.setVisible(false);
                    }
                }
            }
        });
        this.m_LabelDeviceActive.setToolTipText("Active");
        this.m_LabelDeviceActive.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.m_LabelDeviceActive.setBorder(new EtchedBorder(0));
        this.m_LabelDeviceActive.setPreferredSize(new Dimension(16, 16));
        this.m_AbsoluteConstraints_LabelDeviceActive = new AbsoluteConstraints(0, 0);
        this.add(this.m_LabelDeviceActive, this.m_AbsoluteConstraints_LabelDeviceActive, 0);
        this.m_LabelDeviceMute = new JLabel();
        this.m_LabelDeviceMute.setOpaque(true);
        this.m_LabelDeviceMute.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!DMXDeviceView.this.m_LabelDeviceMute.isEnabled()) {
                    return;
                }
                if (DMXDeviceView.this.m_DMXDevice != null) {
                    DMXDeviceView.this.m_DMXDevice.setMute(!DMXDeviceView.this.m_DMXDevice.getMute());
                    if (!DMXDeviceView.this.m_SelfReference.isEnabled() && !DMXDeviceView.this.m_DMXDevice.getMute()) {
                        DMXDeviceView.this.m_LabelDeviceMute.setVisible(false);
                    }
                }
            }
        });
        this.m_LabelDeviceMute.setToolTipText("Mute");
        this.m_LabelDeviceMute.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.m_LabelDeviceMute.setBorder(new LineBorder(Color.PINK, 1));
        this.m_LabelDeviceMute.setPreferredSize(new Dimension(16, 16));
        this.m_AbsoluteConstraints_LabelDeviceMute = new AbsoluteConstraints(0, 0);
        this.add(this.m_LabelDeviceMute, this.m_AbsoluteConstraints_LabelDeviceMute, 0);
        this.m_LabelDeviceSolo = new JLabel();
        this.m_LabelDeviceSolo.setOpaque(true);
        this.m_LabelDeviceSolo.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!DMXDeviceView.this.m_LabelDeviceSolo.isEnabled()) {
                    return;
                }
                if (DMXDeviceView.this.m_DMXDevice != null) {
                    DMXDeviceView.this.m_DMXDevice.setSolo(!DMXDeviceView.this.m_DMXDevice.getSolo());
                    if (!DMXDeviceView.this.m_SelfReference.isEnabled() && !DMXDeviceView.this.m_DMXDevice.getSolo()) {
                        DMXDeviceView.this.m_LabelDeviceSolo.setVisible(false);
                    }
                }
            }
        });
        this.m_LabelDeviceSolo.setToolTipText("Solo");
        this.m_LabelDeviceSolo.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.m_LabelDeviceSolo.setBorder(new LineBorder(Color.YELLOW, 1));
        this.m_LabelDeviceSolo.setPreferredSize(new Dimension(16, 16));
        this.m_AbsoluteConstraints_LabelDeviceSolo = new AbsoluteConstraints(0, 0);
        this.add(this.m_LabelDeviceSolo, this.m_AbsoluteConstraints_LabelDeviceSolo, 0);
        this.m_LabelDeviceFailure = new JLabel();
        this.m_LabelDeviceFailure.setOpaque(false);
        this.m_LabelDeviceFailure.setPreferredSize(new Dimension(16, 16));
        this.m_LabelDeviceFailure.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Failure_16.png")));
        this.m_AbsoluteConstraints_LabelDeviceFailure = new AbsoluteConstraints(0, 0);
        this.add(this.m_LabelDeviceFailure, this.m_AbsoluteConstraints_LabelDeviceFailure, 0);
        this.m_LabelDeviceScale = new JTextField();
        this.m_LabelDeviceScale.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.m_LabelDeviceScale.setToolTipText("Scale");
        this.m_LabelDeviceScale.setOpaque(false);
        this.m_LabelDeviceScale.setForeground(Color.ORANGE);
        this.m_LabelDeviceScale.setHorizontalAlignment(0);
        this.m_LabelDeviceScale.setBorder(s_ScaleBorder);
        this.m_LabelDeviceScale.setCursor(Cursor.getPredefinedCursor(8));
        DocumentFilter_Integer o_DocumentFilter_Integer = new DocumentFilter_Integer(this.m_LabelDeviceScale);
        o_DocumentFilter_Integer.setAllowEmptyString(true);
        this.m_LabelDeviceScale.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (DMXDeviceView.this.m_DMXDevice == null) {
                    return;
                }
                if (e.getKeyCode() == 10) {
                    if (DMXDeviceView.this.m_LabelDeviceScale.getText().length() <= 0) {
                        DMXDeviceView.this.m_DMXDevice.setScale(100);
                    } else {
                        try {
                            DMXDeviceView.this.m_DMXDevice.setScale(Integer.parseInt(DMXDeviceView.this.m_LabelDeviceScale.getText()));
                        }
                        catch (Exception error) {
                            DMXDeviceView.this.m_LabelDeviceScale.setText(String.valueOf(DMXDeviceView.this.m_DMXDevice.getScale()));
                        }
                    }
                    if (DMXDeviceView.this.m_DMXDevice.getScale() == 100) {
                        DMXDeviceView.this.m_LabelDeviceScale.setText("");
                    }
                } else if (e.getKeyCode() == 127) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            int intCaretPosition = DMXDeviceView.this.m_LabelDeviceScale.getCaretPosition();
                            try {
                                if (DMXDeviceView.this.m_LabelDeviceScale.getText().length() <= 0) {
                                    DMXDeviceView.this.m_DMXDevice.setScale(100);
                                } else {
                                    DMXDeviceView.this.m_DMXDevice.setScale(Integer.parseInt(DMXDeviceView.this.m_LabelDeviceScale.getText()));
                                    DMXDeviceView.this.m_LabelDeviceScale.setCaretPosition(intCaretPosition);
                                }
                            }
                            catch (Exception error) {
                                DMXDeviceView.this.m_LabelDeviceScale.setText(String.valueOf(DMXDeviceView.this.m_DMXDevice.getScale()));
                            }
                        }
                    });
                } else if (e.getKeyCode() == 8) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            int intCaretPosition = DMXDeviceView.this.m_LabelDeviceScale.getCaretPosition();
                            try {
                                if (DMXDeviceView.this.m_LabelDeviceScale.getText().length() <= 0) {
                                    DMXDeviceView.this.m_DMXDevice.setScale(100);
                                } else {
                                    DMXDeviceView.this.m_DMXDevice.setScale(Integer.parseInt(DMXDeviceView.this.m_LabelDeviceScale.getText()));
                                    DMXDeviceView.this.m_LabelDeviceScale.setCaretPosition(intCaretPosition);
                                }
                            }
                            catch (Exception error) {
                                DMXDeviceView.this.m_LabelDeviceScale.setText(String.valueOf(DMXDeviceView.this.m_DMXDevice.getScale()));
                            }
                        }
                    });
                }
            }
        });
        MouseAdapter o_MouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (DMXDeviceView.this.m_DMXDevice == null) {
                    return;
                }
                if (!DMXDeviceView.this.m_LabelDeviceScale.isEnabled()) {
                    return;
                }
                if (e.getClickCount() > 1) {
                    if (DMXDeviceView.this.m_DMXDevice == null) {
                        return;
                    }
                    DMXDeviceView.this.m_LabelDeviceScale.setText(String.valueOf(DMXDeviceView.this.m_DMXDevice.getScale()));
                    DMXDeviceView.this.m_LabelDeviceScale.selectAll();
                    if (!DMXDeviceView.this.m_SelfReference.isEnabled() && DMXDeviceView.this.m_DMXDevice.getScale() == 100) {
                        DMXDeviceView.this.m_LabelDeviceScale.setVisible(false);
                    }
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (DMXDeviceView.this.m_DMXDevice == null) {
                    return;
                }
                if (!DMXDeviceView.this.m_LabelDeviceScale.isEnabled()) {
                    return;
                }
                DMXDeviceView.this.m_LabelScaleDragStart_Y = e.getY();
                DMXDeviceView.this.m_LabelScaleDragStart = DMXDeviceView.this.m_DMXDevice.getScale();
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (DMXDeviceView.this.m_DMXDevice == null) {
                    return;
                }
                if (!DMXDeviceView.this.m_LabelDeviceScale.isEnabled()) {
                    return;
                }
                int intY = e.getY();
                int intDiff = DMXDeviceView.this.m_LabelScaleDragStart_Y - intY;
                DMXDeviceView.this.m_DMXDevice.setScale(DMXDeviceView.this.m_LabelScaleDragStart + intDiff / 2);
                if (!DMXDeviceView.this.m_SelfReference.isEnabled() && DMXDeviceView.this.m_DMXDevice.getScale() == 100) {
                    DMXDeviceView.this.m_LabelDeviceScale.setVisible(false);
                }
            }
        };
        FocusListener o_FocusListener = new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (DMXDeviceView.this.m_DMXDevice == null) {
                    return;
                }
                if (DMXDeviceView.this.m_DMXDevice.getScale() == 100) {
                    DMXDeviceView.this.m_LabelDeviceScale.setText("");
                }
            }
        };
        this.m_LabelDeviceScale.addMouseListener(o_MouseAdapter);
        this.m_LabelDeviceScale.addMouseMotionListener(o_MouseAdapter);
        this.m_LabelDeviceScale.addFocusListener(o_FocusListener);
        this.m_Dimension_TextFieldScale = new Dimension(16, 16);
        this.m_LabelDeviceScale.setPreferredSize(this.m_Dimension_TextFieldScale);
        this.m_AbsoluteConstraints_LabelScale = new AbsoluteConstraints(0, 0);
        this.add(this.m_LabelDeviceScale, this.m_AbsoluteConstraints_LabelScale, 0);
        this.m_DisplayLabelContainer = new DisplayLabelContainer(this);
        this.m_DisplayLabelContainer.setPreferredSize(new Dimension(100, 18));
        AbsoluteConstraints o_AbsoluteConstraints = new AbsoluteConstraints(0, 0);
        this.add(this.m_DisplayLabelContainer, o_AbsoluteConstraints, 0);
    }

    public void close() {
        this.setComponentPopupMenu(null);
        this.m_LabelDeviceActive.setComponentPopupMenu(null);
        this.m_LabelDeviceMute.setComponentPopupMenu(null);
        this.m_LabelDeviceSolo.setComponentPopupMenu(null);
        this.m_LabelDeviceScale.setComponentPopupMenu(null);
        LiveLanguage.removeLanguageListener((Object)this);
        if (this.m_DMXDevice != null) {
            this.m_DMXDevice.close();
        }
        this.setDMXDevice(null);
        if (this.m_Container != null) {
            this.setVisible(false);
            this.m_Container.remove(this);
        }
        this.m_Container = null;
        this.m_SelfReference = null;
        LiveLanguage.removeLanguageListener((Object)this);
    }

    public boolean setDMXDevice(DMXDevice p_DMXDevice) {
        if (this.m_Container == null) {
            return false;
        }
        if (this.m_DMXDevice != null) {
            this.m_DMXDevice.removePropertyChangeListener(this);
            this.m_DisplayLabelContainer.clear();
        }
        this.m_DMXDevice = p_DMXDevice;
        this.refresh();
        this.refreshPosition();
        this.setDMXControlComponents();
        if (this.m_DMXDevice != null) {
            Point o_Position = this.m_DMXDevice.getStageViewPosition();
            this.setNormPosition(o_Position.x, o_Position.y);
            this.m_DMXDevice.addPropertyChangeListener(this);
            this.setToolTipText(this.m_DMXDevice.getToolTipText());
        } else {
            this.setToolTipText(null);
        }
        return true;
    }

    public DMXDevice getDMXDevice() {
        return this.m_DMXDevice;
    }

    public Container getContainer() {
        return this.m_Container;
    }

    public void setNormPosition(int p_PositionX, int p_PositionY) {
        if (p_PositionX < 0) {
            p_PositionX = 0;
        }
        if (p_PositionY < 0) {
            p_PositionY = 0;
        }
        this.m_PositionX = p_PositionX;
        this.m_PositionY = p_PositionY;
        if (this.m_DMXDevice != null) {
            this.m_DMXDevice.setStageViewPosition(p_PositionX, p_PositionY);
        }
        this.refreshPosition();
    }

    public int getNormPositionX() {
        return this.m_PositionX;
    }

    public int getNormPositionY() {
        return this.m_PositionY;
    }

    public int getNormWidth() {
        if (this.m_DMXDevice == null) {
            return 0;
        }
        return this.m_DMXDevice.getDMXDeviceType().getDeviceIconWidth();
    }

    public int getNormHeight() {
        if (this.m_DMXDevice == null) {
            return 0;
        }
        return this.m_DMXDevice.getDMXDeviceType().getDeviceIconHeight();
    }

    public void refreshPosition() {
        if (this.m_DMXDevice == null) {
            return;
        }
        if (this.m_LiveShowDMXStageView == null) {
            return;
        }
        double doubleZoom = this.m_LiveShowDMXStageView.getZoom();
        Point o_Position = this.m_DMXDevice.getStageViewPosition();
        this.m_AbsoluteConstraints.x = (int)((double)o_Position.x * doubleZoom);
        this.m_AbsoluteConstraints.y = (int)((double)o_Position.y * doubleZoom);
        if (this.m_Container != null) {
            this.m_Container.revalidate();
        }
    }

    public boolean externalMouseEnter(int p_LastX, int p_LastY, int p_X, int p_Y) {
        this.m_Bounds = this.getBounds(this.m_Bounds);
        if (!(p_LastX < this.m_AbsoluteConstraints.x && p_X < this.m_AbsoluteConstraints.x || p_LastX > this.m_AbsoluteConstraints.x + this.m_Bounds.width && p_X > this.m_AbsoluteConstraints.x + this.m_Bounds.width || p_LastY < this.m_AbsoluteConstraints.y && p_Y < this.m_AbsoluteConstraints.y || p_LastY > this.m_AbsoluteConstraints.y + this.m_Bounds.height && p_Y > this.m_AbsoluteConstraints.y + this.m_Bounds.height)) {
            if (this.m_ExternalMouseInside) {
                return false;
            }
            this.m_ExternalMouseInside = true;
            return true;
        }
        this.m_ExternalMouseInside = false;
        return false;
    }

    public void externalMouseReleased(int p_X, int p_Y) {
        this.m_ExternalMouseInside = false;
    }

    public void refresh() {
        DMXDevice o_DMXDevice = this.m_DMXDevice;
        if (this.m_DMXDevice == null) {
            this.m_LabelDevice.setIcon(null);
            this.m_LabelDevice.setBackgroundImage(null);
            this.m_LabelDevice.setToolTipText(null);
            this.m_LabelDevice.setVisible(false);
            this.m_LabelDeviceName.setVisible(false);
            this.m_LabelDeviceActive.setBackground(Color.GRAY);
            this.m_LabelDeviceMute.setBackground(Color.GRAY);
            this.m_LabelDeviceSolo.setBackground(Color.GRAY);
            this.m_LabelDeviceScale.setVisible(false);
            this.setToolTipText(null);
        } else {
            DMXDeviceType o_DMXDeviceType = o_DMXDevice.getDMXDeviceType();
            if (o_DMXDeviceType == null) {
                return;
            }
            int intDisplayLabelHeight = DisplayLabelContainer.s_LabelSize;
            int intActionLabelSize = 16;
            double doubleZoom = this.m_LiveShowDMXStageView.getZoom();
            intActionLabelSize = doubleZoom < 1.0 ? (int)(16.0 * doubleZoom) : 16;
            this.setToolTipText(o_DMXDevice.getToolTipText());
            o_DMXDeviceType = o_DMXDevice.getDMXDeviceType();
            this.m_LabelDevice.setBackgroundImage(o_DMXDevice.getDeviceImage());
            this.m_LabelDevice.setToolTipText(o_DMXDevice.getToolTipText());
            this.m_DimensionDeviceIcon.setSize(o_DMXDeviceType.getDeviceIconWidth(), o_DMXDeviceType.getDeviceIconHeight());
            this.m_DimensionDeviceIcon.setSize((double)this.m_DimensionDeviceIcon.width * doubleZoom, (double)this.m_DimensionDeviceIcon.height * doubleZoom);
            this.m_DisplayLabelContainer.setPreferredSize(new Dimension(this.m_DimensionDeviceIcon.width, DisplayLabelContainer.s_LabelSize + 2));
            this.m_DisplayLabelContainer.setMinimumSize(new Dimension(this.m_DimensionDeviceIcon.width, DisplayLabelContainer.s_LabelSize + 2));
            this.m_LabelDeviceName.setText(o_DMXDevice.getName());
            this.m_LabelDeviceName.setPreferredSize(new Dimension(this.m_DimensionDeviceIcon.width, 14));
            this.m_LabelDeviceName.setMinimumSize(new Dimension(this.m_DimensionDeviceIcon.width, 14));
            this.m_AbsoluteConstraints_LabelDeviceName.x = 0;
            this.m_AbsoluteConstraints_LabelDeviceName.y = this.m_DimensionDeviceIcon.height + intDisplayLabelHeight;
            this.m_LabelDeviceName.setVisible(true);
            if (o_DMXDevice.getActive()) {
                this.m_LabelDeviceActive.setBackground(Color.GREEN);
            } else {
                this.m_LabelDeviceActive.setBackground(Color.RED);
            }
            this.m_AbsoluteConstraints_LabelDeviceActive.x = this.m_DimensionDeviceIcon.width - intActionLabelSize;
            this.m_AbsoluteConstraints_LabelDeviceActive.y = this.m_DimensionDeviceIcon.height - intActionLabelSize + intDisplayLabelHeight;
            this.m_AbsoluteConstraints_LabelDeviceActive.width = intActionLabelSize;
            this.m_AbsoluteConstraints_LabelDeviceActive.height = intActionLabelSize;
            if (this.isEnabled() || !o_DMXDevice.getActive()) {
                this.m_LabelDeviceActive.setVisible(true);
            } else {
                this.m_LabelDeviceActive.setVisible(false);
            }
            if (o_DMXDevice.getMute()) {
                this.m_LabelDeviceMute.setBackground(Color.PINK);
                this.m_LabelDeviceMute.setOpaque(true);
            } else {
                this.m_LabelDeviceMute.setOpaque(false);
                this.m_LabelDeviceMute.setBackground(Color.DARK_GRAY);
            }
            this.m_AbsoluteConstraints_LabelDeviceMute.x = 0;
            this.m_AbsoluteConstraints_LabelDeviceMute.y = this.m_DimensionDeviceIcon.height - intActionLabelSize + intDisplayLabelHeight;
            this.m_AbsoluteConstraints_LabelDeviceMute.width = intActionLabelSize;
            this.m_AbsoluteConstraints_LabelDeviceMute.height = intActionLabelSize;
            if (this.isEnabled() && o_DMXDevice.getIsDimmable() || o_DMXDevice.getMute()) {
                this.m_LabelDeviceMute.setVisible(true);
            } else {
                this.m_LabelDeviceMute.setVisible(false);
            }
            if (o_DMXDevice.getSolo()) {
                this.m_LabelDeviceSolo.setBackground(Color.YELLOW);
                this.m_LabelDeviceSolo.setOpaque(true);
            } else {
                this.m_LabelDeviceSolo.setOpaque(false);
                this.m_LabelDeviceSolo.setBackground(Color.DARK_GRAY);
            }
            this.m_AbsoluteConstraints_LabelDeviceSolo.x = 0;
            this.m_AbsoluteConstraints_LabelDeviceSolo.y = this.m_DimensionDeviceIcon.height - 2 * intActionLabelSize + intDisplayLabelHeight;
            this.m_AbsoluteConstraints_LabelDeviceSolo.width = intActionLabelSize;
            this.m_AbsoluteConstraints_LabelDeviceSolo.height = intActionLabelSize;
            if (this.isEnabled() && o_DMXDevice.getIsDimmable() || o_DMXDevice.getSolo()) {
                this.m_LabelDeviceSolo.setVisible(true);
            } else {
                this.m_LabelDeviceSolo.setVisible(false);
            }
            this.m_AbsoluteConstraints_LabelDeviceFailure.x = this.m_DimensionDeviceIcon.width - intActionLabelSize;
            this.m_AbsoluteConstraints_LabelDeviceFailure.y = this.m_DimensionDeviceIcon.height - 2 * intActionLabelSize + intDisplayLabelHeight;
            this.m_AbsoluteConstraints_LabelDeviceFailure.width = intActionLabelSize;
            this.m_AbsoluteConstraints_LabelDeviceFailure.height = intActionLabelSize;
            if (o_DMXDevice.getValidAddress()) {
                this.m_LabelDeviceFailure.setVisible(false);
            } else {
                this.m_LabelDeviceFailure.setToolTipText(DMXDevice.INVALIDADDRESS);
                this.m_LabelDeviceFailure.setVisible(true);
            }
            this.m_AbsoluteConstraints_LabelScale.x = intActionLabelSize;
            this.m_AbsoluteConstraints_LabelScale.y = this.m_DimensionDeviceIcon.height - intActionLabelSize + intDisplayLabelHeight;
            if (o_DMXDevice.getIsDimmable()) {
                this.m_LabelDeviceScale.setVisible(true);
            } else {
                this.m_LabelDeviceScale.setVisible(false);
            }
            this.m_Dimension_TextFieldScale.width = this.m_DimensionDeviceIcon.width - 2 * intActionLabelSize;
            this.m_Dimension_TextFieldScale.height = intActionLabelSize;
            this.m_LabelDeviceScale.setPreferredSize(this.m_Dimension_TextFieldScale);
            if (o_DMXDevice.getScale() == 100) {
                this.m_LabelDeviceScale.setText("");
            } else {
                this.m_LabelDeviceScale.setText(String.valueOf(o_DMXDevice.getScale()));
            }
            this.m_AbsoluteConstraints.width = this.m_DimensionDeviceIcon.width;
            this.m_AbsoluteConstraints.height = this.m_DimensionDeviceIcon.height + 22 + DisplayLabelContainer.s_LabelSize;
            this.m_AbsoluteConstraints_LabelDevice.height = this.m_DimensionDeviceIcon.height;
            this.m_AbsoluteConstraints_LabelDevice.width = this.m_DimensionDeviceIcon.width;
            this.m_AbsoluteConstraints_LabelDevice.x = 0;
            this.m_AbsoluteConstraints_LabelDevice.y = intDisplayLabelHeight;
            if (this.isEnabled() && o_DMXDevice.getIsDimmable() || o_DMXDevice.getScale() != 100) {
                this.m_LabelDeviceScale.setVisible(true);
            } else {
                this.m_LabelDeviceScale.setVisible(false);
            }
            if (this.m_Selected) {
                this.setBorder(s_SelectedBorder);
            } else {
                this.setBorder(null);
            }
            if (doubleZoom < 0.3) {
                this.m_LabelDeviceActive.setEnabled(false);
                this.m_LabelDeviceMute.setEnabled(false);
                this.m_LabelDeviceScale.setEnabled(false);
                this.m_LabelDeviceSolo.setEnabled(false);
            } else {
                this.m_LabelDeviceActive.setEnabled(true);
                this.m_LabelDeviceMute.setEnabled(true);
                this.m_LabelDeviceScale.setEnabled(true);
                this.m_LabelDeviceSolo.setEnabled(true);
            }
        }
        if (this.m_Container != null) {
            this.m_Container.revalidate();
        }
        this.m_DisplayLabelContainer.refresh();
    }

    private void setDMXControlComponents() {
        JComponent o_DisplayLabel;
        int intDMXControl;
        for (intDMXControl = this.m_DisplayLabelContainer.getDisplayLabelCount() - 1; intDMXControl >= 0; --intDMXControl) {
            o_DisplayLabel = this.m_DisplayLabelContainer.getDisplayLabel(intDMXControl);
            this.m_DisplayLabelContainer.removeDisplayLabel(o_DisplayLabel);
        }
        if (this.m_DMXDevice != null) {
            ArrayList<DMXControlComponent> o_DMXControlComponents = this.m_DMXDevice.getDMXControlComponents();
            for (intDMXControl = 0; intDMXControl < o_DMXControlComponents.size(); ++intDMXControl) {
                DMXControlComponent o_DMXControlComponent = o_DMXControlComponents.get(intDMXControl);
                o_DisplayLabel = o_DMXControlComponent.getDisplayLabelCopy();
                o_DMXControlComponent.refreshToolTipText_PartDMXControl();
                this.m_DisplayLabelContainer.addDisplayLabel(o_DisplayLabel);
            }
        }
    }

    @Override
    public void setEnabled(boolean p_Enabled) {
        if (super.isEnabled() == p_Enabled) {
            return;
        }
        this.m_LabelDevice.setEnabled(p_Enabled);
        this.m_LabelDeviceName.setEnabled(p_Enabled);
        this.m_DisplayLabelContainer.setVisible(p_Enabled);
        super.setEnabled(p_Enabled);
        if (p_Enabled) {
            this.m_LabelDevice.addMouseListener(this.m_MouseAdapter_Delayed);
            this.m_LabelDevice.addMouseMotionListener(this.m_MouseAdapter_Delayed);
        } else {
            this.m_LabelDevice.removeMouseListener(this.m_MouseAdapter_Delayed);
            this.m_LabelDevice.removeMouseMotionListener(this.m_MouseAdapter_Delayed);
        }
        this.refresh();
    }

    public void setSelected(boolean p_Selected) {
        boolean boolChanged = false;
        if (this.m_Selected != p_Selected) {
            boolChanged = true;
        }
        this.m_Selected = p_Selected;
        if (this.m_Selected) {
            this.setBorder(s_SelectedBorder);
        } else {
            this.setBorder(null);
        }
        if (boolChanged) {
            // empty if block
        }
    }

    public boolean getSelected() {
        return this.m_Selected;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof DMXDevice) {
            DMXDevice o_DMXDevice = (DMXDevice)evt.getSource();
            if ("dmxdeviceDeviceName".equals(evt.getPropertyName())) {
                this.refresh();
                LiveShowDMXStageView.notifyDMXDeviceViewChanged(this);
            }
            if ("dmxdeviceDeviceActive".equals(evt.getPropertyName())) {
                this.refresh();
                LiveShowDMXStageView.notifyDMXDeviceViewChanged(this);
            }
            if ("dmxdeviceDeviceMute".equals(evt.getPropertyName())) {
                this.refresh();
                LiveShowDMXStageView.notifyDMXDeviceViewChanged(this);
            }
            if ("dmxdeviceDeviceSolo".equals(evt.getPropertyName())) {
                this.refresh();
                LiveShowDMXStageView.notifyDMXDeviceViewChanged(this);
            }
            if ("dmxdeviceDeviceScale".equals(evt.getPropertyName())) {
                this.refresh();
            } else if ("dmxdeviceTypeManufactureer".equals(evt.getPropertyName())) {
                this.refresh();
            } else if ("dmxdeviceTypeName".equals(evt.getPropertyName())) {
                this.refresh();
            } else if ("dmxdeviceTypeDescription".equals(evt.getPropertyName())) {
                this.refresh();
            } else if ("dmxdeviceTypeImage".equals(evt.getPropertyName())) {
                this.refresh();
            } else if ("dmxdeviceDMXDeviceType".equals(evt.getPropertyName())) {
                if (this.m_LiveShowDMXStageView != null) {
                    this.m_LiveShowDMXStageView.removeSelectedDMXDevice(o_DMXDevice);
                }
                this.refresh();
                this.setDMXControlComponents();
                if (this.m_LiveShowDMXStageView != null) {
                    this.m_LiveShowDMXStageView.changedDMXDevice(o_DMXDevice);
                }
            } else if ("dmxdeviceUniverse".equals(evt.getPropertyName())) {
                this.refresh();
                LiveShowDMXStageView.notifyDMXDeviceViewChanged(this);
            } else if ("dmxdeviceUniverseName".equals(evt.getPropertyName())) {
                this.refresh();
                LiveShowDMXStageView.notifyDMXDeviceViewChanged(this);
            } else if ("dmxdeviceStartAddress".equals(evt.getPropertyName())) {
                this.refresh();
                LiveShowDMXStageView.notifyDMXDeviceViewChanged(this);
            } else if ("dmxdeviceValidAddress".equals(evt.getPropertyName())) {
                this.refresh();
                LiveShowDMXStageView.notifyDMXDeviceViewChanged(this);
            } else if ("dmxdeviceAdjustedSceneBridge".equals(evt.getPropertyName())) {
                this.refresh();
            } else if ("dmxdeviceDimmerValue".equals(evt.getPropertyName())) {
                this.refresh();
            } else if ("dmxdevicePowerSource".equals(evt.getPropertyName())) {
                this.refresh();
            }
        }
    }

    public static class DisplayLabelContainer
    extends JScrollPane {
        public static int s_LabelSize = 20;
        private DMXDeviceView m_DMXDeviceView;
        private JPanel m_JPanelLabels;
        private Dimension m_JPabelLabelsDimension;
        private ArrayList<JComponent> m_DisplayLabels;
        private MouseInputListener m_MouseInputListener;

        public DisplayLabelContainer(DMXDeviceView p_DMXDeviceView) {
            this.initMembers();
            this.m_DMXDeviceView = p_DMXDeviceView;
            this.initComponents();
        }

        private void initMembers() {
            this.m_DisplayLabels = new ArrayList();
        }

        private void initComponents() {
            this.setPreferredSize(new Dimension(100, s_LabelSize + 2));
            this.setBorder(new LineBorder(Color.BLACK, 1));
            this.setOpaque(false);
            this.setVisible(true);
            this.setHorizontalScrollBarPolicy(31);
            this.setVerticalScrollBarPolicy(21);
            this.getHorizontalScrollBar().setSize(0, 2);
            this.m_JPanelLabels = new JPanel();
            this.m_JPanelLabels.setBackground(Color.DARK_GRAY);
            this.m_JPanelLabels.setOpaque(true);
            this.m_JPabelLabelsDimension = new Dimension(0, s_LabelSize);
            this.m_JPanelLabels.setLayout(new GridBagLayout());
            this.setViewportView(this.m_JPanelLabels);
            this.m_MouseInputListener = new MouseInputAdapter(){
                private int m_MousePositionX;
                private boolean m_IsPressed = false;

                @Override
                public void mouseMoved(MouseEvent e) {
                }

                @Override
                public void mouseDragged(MouseEvent e) {
                    if (this.m_IsPressed) {
                        int intDeltaX = e.getXOnScreen() - this.m_MousePositionX;
                        this.getHorizontalScrollBar().setValue(this.getHorizontalScrollBar().getValue() - intDeltaX);
                        this.m_MousePositionX += intDeltaX;
                    }
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    this.m_MousePositionX = e.getXOnScreen();
                    this.m_IsPressed = true;
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    this.m_IsPressed = false;
                }
            };
        }

        public void refresh() {
            this.revalidate();
        }

        public void clear() {
            for (int intLabel = this.m_DisplayLabels.size() - 1; intLabel >= 0; --intLabel) {
                JComponent o_DisplayLabel = this.m_DisplayLabels.get(intLabel);
                if (o_DisplayLabel == null) continue;
                o_DisplayLabel.removeMouseListener(this.m_MouseInputListener);
                o_DisplayLabel.removeMouseMotionListener(this.m_MouseInputListener);
                o_DisplayLabel.setVisible(false);
                this.remove(o_DisplayLabel);
                this.m_DisplayLabels.remove(intLabel);
            }
            this.revalidate();
        }

        public void addDisplayLabel(JComponent p_DisplayLabel) {
            if (p_DisplayLabel == null) {
                return;
            }
            this.m_DisplayLabels.add(p_DisplayLabel);
            GridBagConstraints o_GridBagConstraints = new GridBagConstraints();
            o_GridBagConstraints.gridx = this.m_DisplayLabels.size() - 1;
            o_GridBagConstraints.gridy = 0;
            o_GridBagConstraints.insets.right = 1;
            o_GridBagConstraints.insets.left = 1;
            p_DisplayLabel.setPreferredSize(new Dimension(s_LabelSize, s_LabelSize));
            p_DisplayLabel.setMinimumSize(new Dimension(s_LabelSize, s_LabelSize));
            Font o_Font = p_DisplayLabel.getFont();
            Font o_FontNew = o_Font.deriveFont(10.1f);
            p_DisplayLabel.setFont(o_FontNew);
            p_DisplayLabel.setVisible(true);
            p_DisplayLabel.addMouseListener(this.m_MouseInputListener);
            p_DisplayLabel.addMouseMotionListener(this.m_MouseInputListener);
            this.m_JPanelLabels.add((Component)p_DisplayLabel, o_GridBagConstraints);
            this.m_JPabelLabelsDimension.width += s_LabelSize + 2;
            this.m_JPanelLabels.setPreferredSize(this.m_JPabelLabelsDimension);
            this.revalidate();
        }

        public void removeDisplayLabel(JComponent p_DisplayLabel) {
            if (p_DisplayLabel == null) {
                return;
            }
            int intIndex = this.m_DisplayLabels.indexOf(p_DisplayLabel);
            if (intIndex < 0) {
                return;
            }
            for (int intLabel = intIndex + 1; intLabel < this.m_DisplayLabels.size(); ++intLabel) {
                GridBagLayout o_GridBagLayout = (GridBagLayout)this.getLayout();
                GridBagConstraints o_GridBagConstraints = o_GridBagLayout.getConstraints(p_DisplayLabel);
                if (o_GridBagConstraints == null) continue;
                --o_GridBagConstraints.gridx;
            }
            this.m_DisplayLabels.remove(intIndex);
            p_DisplayLabel.setVisible(false);
            p_DisplayLabel.removeMouseListener(this.m_MouseInputListener);
            p_DisplayLabel.removeMouseMotionListener(this.m_MouseInputListener);
            this.m_JPanelLabels.remove(p_DisplayLabel);
            this.m_JPabelLabelsDimension.width -= s_LabelSize + 2;
            this.m_JPanelLabels.setPreferredSize(this.m_JPabelLabelsDimension);
            this.revalidate();
        }

        public int getDisplayLabelCount() {
            return this.m_DisplayLabels.size();
        }

        public JComponent getDisplayLabel(int p_Index) {
            if (p_Index < 0 || p_Index >= this.m_DisplayLabels.size()) {
                return null;
            }
            return this.m_DisplayLabels.get(p_Index);
        }

        @Override
        public void setEnabled(boolean p_Enabled) {
            for (int intDisplay = 0; intDisplay < this.m_DisplayLabels.size(); ++intDisplay) {
                JComponent o_DisplayLabel = this.m_DisplayLabels.get(intDisplay);
                if (o_DisplayLabel == null) continue;
                o_DisplayLabel.setEnabled(p_Enabled);
            }
            super.setEnabled(p_Enabled);
        }
    }
}

